/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.authorization;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.authorization.Privilege;
import org.apache.gravitino.authorization.Privileges;

public class PrivilegeDTO
implements Privilege {
    @JsonProperty(value="name")
    private Privilege.Name name;
    @JsonProperty(value="condition")
    private Privilege.Condition condition;

    protected PrivilegeDTO() {
    }

    protected PrivilegeDTO(Privilege.Name name, Privilege.Condition condition) {
        this.name = name;
        this.condition = condition;
    }

    @Override
    public Privilege.Name name() {
        return this.name;
    }

    @Override
    public String simpleString() {
        if (Privilege.Condition.ALLOW.equals((Object)this.condition)) {
            return Privileges.allow(this.name).simpleString();
        }
        return Privileges.deny(this.name).simpleString();
    }

    @Override
    public Privilege.Condition condition() {
        return this.condition;
    }

    @Override
    public boolean canBindTo(MetadataObject.Type type) {
        if (Privilege.Condition.ALLOW.equals((Object)this.condition)) {
            return Privileges.allow(this.name).canBindTo(type);
        }
        return Privileges.deny(this.name).canBindTo(type);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Privilege.Name name;
        private Privilege.Condition condition;

        public Builder withName(Privilege.Name name) {
            this.name = name;
            return this;
        }

        public Builder withCondition(Privilege.Condition condition) {
            this.condition = condition;
            return this;
        }

        public PrivilegeDTO build() {
            Preconditions.checkArgument(this.name != null, "name cannot be null");
            Preconditions.checkArgument(this.condition != null, "condition cannot be null");
            return new PrivilegeDTO(this.name, this.condition);
        }
    }
}

