/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.job;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.dto.job.JobTemplateDTO;

public class SparkJobTemplateDTO
extends JobTemplateDTO {
    @JsonProperty(value="className")
    private String className;
    @JsonProperty(value="jars")
    private List<String> jars;
    @JsonProperty(value="files")
    private List<String> files;
    @JsonProperty(value="archives")
    private List<String> archives;
    @JsonProperty(value="configs")
    private Map<String, String> configs;

    private SparkJobTemplateDTO() {
    }

    @Override
    public void validate() {
        super.validate();
        Preconditions.checkArgument(StringUtils.isNotBlank(this.className), "\"className\" is required and cannot be empty");
    }

    protected SparkJobTemplateDTO(SparkJobTemplateDTOBuilder<?, ?> b) {
        super(b);
        this.className = b.className;
        this.jars = b.jars;
        this.files = b.files;
        this.archives = b.archives;
        this.configs = b.configs;
    }

    public static SparkJobTemplateDTOBuilder<?, ?> builder() {
        return new SparkJobTemplateDTOBuilderImpl();
    }

    public String className() {
        return this.className;
    }

    public List<String> jars() {
        return this.jars;
    }

    public List<String> files() {
        return this.files;
    }

    public List<String> archives() {
        return this.archives;
    }

    public Map<String, String> configs() {
        return this.configs;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SparkJobTemplateDTO)) {
            return false;
        }
        SparkJobTemplateDTO other = (SparkJobTemplateDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$className = this.className();
        String other$className = other.className();
        if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
            return false;
        }
        List<String> this$jars = this.jars();
        List<String> other$jars = other.jars();
        if (this$jars == null ? other$jars != null : !((Object)this$jars).equals(other$jars)) {
            return false;
        }
        List<String> this$files = this.files();
        List<String> other$files = other.files();
        if (this$files == null ? other$files != null : !((Object)this$files).equals(other$files)) {
            return false;
        }
        List<String> this$archives = this.archives();
        List<String> other$archives = other.archives();
        if (this$archives == null ? other$archives != null : !((Object)this$archives).equals(other$archives)) {
            return false;
        }
        Map<String, String> this$configs = this.configs();
        Map<String, String> other$configs = other.configs();
        return !(this$configs == null ? other$configs != null : !((Object)this$configs).equals(other$configs));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SparkJobTemplateDTO;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $className = this.className();
        result = result * 59 + ($className == null ? 43 : $className.hashCode());
        List<String> $jars = this.jars();
        result = result * 59 + ($jars == null ? 43 : ((Object)$jars).hashCode());
        List<String> $files = this.files();
        result = result * 59 + ($files == null ? 43 : ((Object)$files).hashCode());
        List<String> $archives = this.archives();
        result = result * 59 + ($archives == null ? 43 : ((Object)$archives).hashCode());
        Map<String, String> $configs = this.configs();
        result = result * 59 + ($configs == null ? 43 : ((Object)$configs).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "SparkJobTemplateDTO(super=" + super.toString() + ", className=" + this.className() + ", jars=" + String.valueOf(this.jars()) + ", files=" + String.valueOf(this.files()) + ", archives=" + String.valueOf(this.archives()) + ", configs=" + String.valueOf(this.configs()) + ")";
    }

    public static abstract class SparkJobTemplateDTOBuilder<C extends SparkJobTemplateDTO, B extends SparkJobTemplateDTOBuilder<C, B>>
    extends JobTemplateDTO.JobTemplateDTOBuilder<C, B> {
        private String className;
        private List<String> jars;
        private List<String> files;
        private List<String> archives;
        private Map<String, String> configs;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @JsonProperty(value="className")
        public B withClassName(String className) {
            this.className = className;
            return (B)this.self();
        }

        @JsonProperty(value="jars")
        public B withJars(List<String> jars) {
            this.jars = jars;
            return (B)this.self();
        }

        @JsonProperty(value="files")
        public B withFiles(List<String> files) {
            this.files = files;
            return (B)this.self();
        }

        @JsonProperty(value="archives")
        public B withArchives(List<String> archives) {
            this.archives = archives;
            return (B)this.self();
        }

        @JsonProperty(value="configs")
        public B withConfigs(Map<String, String> configs) {
            this.configs = configs;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "SparkJobTemplateDTO.SparkJobTemplateDTOBuilder(super=" + super.toString() + ", className=" + this.className + ", jars=" + String.valueOf(this.jars) + ", files=" + String.valueOf(this.files) + ", archives=" + String.valueOf(this.archives) + ", configs=" + String.valueOf(this.configs) + ")";
        }
    }

    private static final class SparkJobTemplateDTOBuilderImpl
    extends SparkJobTemplateDTOBuilder<SparkJobTemplateDTO, SparkJobTemplateDTOBuilderImpl> {
        private SparkJobTemplateDTOBuilderImpl() {
        }

        @Override
        protected SparkJobTemplateDTOBuilderImpl self() {
            return this;
        }

        @Override
        public SparkJobTemplateDTO build() {
            return new SparkJobTemplateDTO(this);
        }
    }
}

