/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.client.transports;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.openlineage.client.MergeConfig;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FacetsConfig
implements MergeConfig<FacetsConfig> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FacetsConfig.class);
    @JsonProperty(value="disabled")
    private String[] deprecatedDisabledFacets;
    @JsonProperty(value="custom_environment_variables")
    private String[] customEnvironmentVariables;
    private Map<String, Boolean> disabledFacets;

    public void setDeprecatedDisabledFacets(String[] disabledFacets) {
        if (disabledFacets.length > 0) {
            log.warn("Deprecation warning: The property 'disabledFacets' is deprecated and will be removed in the future. Use 'facets.<name of disabled facet>.disabled=true' instead");
        }
        this.deprecatedDisabledFacets = disabledFacets;
    }

    @JsonAnySetter
    public void onOtherProperty(String key, Object value) {
        FacetsConfig.asDisabledFacetProperties(key, value).forEach(facetProperty -> {
            if (this.disabledFacets == null) {
                this.disabledFacets = new HashMap<String, Boolean>();
            }
            this.disabledFacets.put(facetProperty.getFacetName(), facetProperty.isDisabled());
        });
    }

    public static List<DisabledFacetProperty> asDisabledFacetProperties(String key, Object value) {
        if (value instanceof Map) {
            Map inputValueMap = (Map)value;
            HashMap<String, Object> flattenedMap = new HashMap<String, Object>();
            FacetsConfig.flattenMapHelper(inputValueMap, key, flattenedMap);
            return flattenedMap.entrySet().stream().filter(entry -> ((String)entry.getKey()).endsWith(".disabled")).map(entry -> new AbstractMap.SimpleEntry<String, Optional<Boolean>>((String)entry.getKey(), FacetsConfig.toBoolean((String)entry.getKey(), entry.getValue()))).filter(e -> ((Optional)e.getValue()).isPresent()).map(entry -> new DisabledFacetProperty(FacetsConfig.truncateDisabledSuffix((String)entry.getKey()), (Boolean)((Optional)entry.getValue()).get())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private static String truncateDisabledSuffix(String key) {
        return key.substring(0, key.length() - ".disabled".length());
    }

    private static Optional<Boolean> toBoolean(String key, Object value) {
        if (value instanceof Boolean) {
            return Optional.of((Boolean)value);
        }
        if (value instanceof String) {
            if ("true".equals(value)) {
                return Optional.of(true);
            }
            if ("false".equals(value)) {
                return Optional.of(false);
            }
        }
        log.warn("The property {} is not a valid boolean", (Object)key);
        return Optional.empty();
    }

    private static void flattenMapHelper(Map<String, Object> map, String prefix, Map<String, Object> flattenedMap) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = prefix.isEmpty() ? entry.getKey() : prefix + "." + entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map) {
                Map mapValue = (Map)value;
                FacetsConfig.flattenMapHelper(mapValue, key, flattenedMap);
                continue;
            }
            flattenedMap.put(key, value);
        }
    }

    @Override
    public FacetsConfig mergeWithNonNull(FacetsConfig facetsConfig) {
        return new FacetsConfig(this.mergePropertyWith(this.deprecatedDisabledFacets, facetsConfig.deprecatedDisabledFacets), this.mergePropertyWith(this.customEnvironmentVariables, facetsConfig.customEnvironmentVariables), this.mergePropertyWith(this.disabledFacets, facetsConfig.disabledFacets));
    }

    public String[] getEffectiveDisabledFacets() {
        HashSet<String> disabledFacetsSet = new HashSet<String>();
        if (this.getDeprecatedDisabledFacets() != null) {
            for (String deprecatedDisabledFacet : this.getDeprecatedDisabledFacets()) {
                disabledFacetsSet.add(deprecatedDisabledFacet);
            }
        }
        if (this.getDisabledFacets() != null) {
            this.getDisabledFacets().forEach((facetName, disabled) -> {
                if (disabled.booleanValue()) {
                    disabledFacetsSet.add((String)facetName);
                } else {
                    disabledFacetsSet.remove(facetName);
                }
            });
        }
        return disabledFacetsSet.toArray(new String[0]);
    }

    @Generated
    public FacetsConfig() {
    }

    @Generated
    public FacetsConfig(String[] deprecatedDisabledFacets, String[] customEnvironmentVariables, Map<String, Boolean> disabledFacets) {
        this.deprecatedDisabledFacets = deprecatedDisabledFacets;
        this.customEnvironmentVariables = customEnvironmentVariables;
        this.disabledFacets = disabledFacets;
    }

    @Generated
    public String toString() {
        return "FacetsConfig(deprecatedDisabledFacets=" + Arrays.deepToString(this.getDeprecatedDisabledFacets()) + ", customEnvironmentVariables=" + Arrays.deepToString(this.getCustomEnvironmentVariables()) + ", disabledFacets=" + this.getDisabledFacets() + ")";
    }

    @Deprecated
    @Generated
    public String[] getDeprecatedDisabledFacets() {
        return this.deprecatedDisabledFacets;
    }

    @Generated
    public String[] getCustomEnvironmentVariables() {
        return this.customEnvironmentVariables;
    }

    @Generated
    public Map<String, Boolean> getDisabledFacets() {
        return this.disabledFacets;
    }

    @Generated
    public void setDisabledFacets(Map<String, Boolean> disabledFacets) {
        this.disabledFacets = disabledFacets;
    }

    public static class DisabledFacetProperty {
        private final String facetName;
        private final boolean disabled;

        @Generated
        public DisabledFacetProperty(String facetName, boolean disabled) {
            this.facetName = facetName;
            this.disabled = disabled;
        }

        @Generated
        public String getFacetName() {
            return this.facetName;
        }

        @Generated
        public boolean isDisabled() {
            return this.disabled;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DisabledFacetProperty)) {
                return false;
            }
            DisabledFacetProperty other = (DisabledFacetProperty)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isDisabled() != other.isDisabled()) {
                return false;
            }
            String this$facetName = this.getFacetName();
            String other$facetName = other.getFacetName();
            return !(this$facetName == null ? other$facetName != null : !this$facetName.equals(other$facetName));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof DisabledFacetProperty;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isDisabled() ? 79 : 97);
            String $facetName = this.getFacetName();
            result = result * 59 + ($facetName == null ? 43 : $facetName.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FacetsConfig.DisabledFacetProperty(facetName=" + this.getFacetName() + ", disabled=" + this.isDisabled() + ")";
        }
    }
}

