/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino;

import java.util.Objects;
import org.apache.gravitino.annotation.Evolving;

@Evolving
public interface CatalogChange {
    public static CatalogChange rename(String newName) {
        return new RenameCatalog(newName);
    }

    public static CatalogChange updateComment(String newComment) {
        return new UpdateCatalogComment(newComment);
    }

    public static CatalogChange setProperty(String property, String value) {
        return new SetProperty(property, value);
    }

    public static CatalogChange removeProperty(String property) {
        return new RemoveProperty(property);
    }

    public static final class RenameCatalog
    implements CatalogChange {
        private final String newName;

        private RenameCatalog(String newName) {
            this.newName = newName;
        }

        public String getNewName() {
            return this.newName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RenameCatalog that = (RenameCatalog)o;
            return Objects.equals(this.newName, that.newName);
        }

        public int hashCode() {
            return Objects.hash(this.newName);
        }

        public String toString() {
            return "RENAMECATALOG " + this.newName;
        }
    }

    public static final class UpdateCatalogComment
    implements CatalogChange {
        private final String newComment;

        private UpdateCatalogComment(String newComment) {
            this.newComment = newComment;
        }

        public String getNewComment() {
            return this.newComment;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UpdateCatalogComment that = (UpdateCatalogComment)o;
            return Objects.equals(this.newComment, that.newComment);
        }

        public int hashCode() {
            return Objects.hash(this.newComment);
        }

        public String toString() {
            return "UPDATECATALOGCOMMENT " + this.newComment;
        }
    }

    public static final class SetProperty
    implements CatalogChange {
        private final String property;
        private final String value;

        private SetProperty(String property, String value) {
            this.property = property;
            this.value = value;
        }

        public String getProperty() {
            return this.property;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SetProperty that = (SetProperty)o;
            return Objects.equals(this.property, that.property) && Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hash(this.property, this.value);
        }

        public String toString() {
            return "SETPROPERTY " + this.property + " " + this.value;
        }
    }

    public static final class RemoveProperty
    implements CatalogChange {
        private final String property;

        private RemoveProperty(String property) {
            this.property = property;
        }

        public String getProperty() {
            return this.property;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RemoveProperty that = (RemoveProperty)o;
            return Objects.equals(this.property, that.property);
        }

        public int hashCode() {
            return Objects.hash(this.property);
        }

        public String toString() {
            return "REMOVEPROPERTY " + this.property;
        }
    }
}

