/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.starrocks.operations;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.StringIdentifier;
import org.apache.gravitino.catalog.jdbc.JdbcColumn;
import org.apache.gravitino.catalog.jdbc.JdbcTable;
import org.apache.gravitino.catalog.jdbc.operation.JdbcTableOperations;
import org.apache.gravitino.catalog.jdbc.operation.JdbcTablePartitionOperations;
import org.apache.gravitino.catalog.starrocks.operations.StarRocksTablePartitionOperations;
import org.apache.gravitino.catalog.starrocks.utils.StarRocksUtils;
import org.apache.gravitino.connector.BaseColumn;
import org.apache.gravitino.exceptions.NoSuchColumnException;
import org.apache.gravitino.exceptions.NoSuchTableException;
import org.apache.gravitino.rel.Column;
import org.apache.gravitino.rel.TableChange;
import org.apache.gravitino.rel.expressions.distributions.Distribution;
import org.apache.gravitino.rel.expressions.distributions.Strategy;
import org.apache.gravitino.rel.expressions.literals.Literal;
import org.apache.gravitino.rel.expressions.transforms.Transform;
import org.apache.gravitino.rel.expressions.transforms.Transforms;
import org.apache.gravitino.rel.indexes.Index;
import org.apache.gravitino.rel.indexes.Indexes;
import org.apache.gravitino.rel.partitions.Partition;

public class StarRocksTableOperations
extends JdbcTableOperations {
    private static final String BACK_QUOTE = "`";
    private static final String AUTO_INCREMENT = "AUTO_INCREMENT";
    private static final String NEW_LINE = "\n";
    private static final Set<String> SUPPORTED_MODIFY_PROPERTIES = new HashSet<String>(Arrays.asList("replication_num", "default.replication_num", "default.storage_medium", "enable_persistent_index", "bloom_filter_columns", "colocate_with", "bucket_size", "base_compaction_forbidden_time_ranges"));
    private static final String SUPPORTED_MODIFY_PROPERTIES_PREFIX_DYNAMIC_PARTITION = "dynamic_partition.";
    private static final String SUPPORTED_MODIFY_PROPERTIES_PREFIX_BINLOG = "binlog.";

    public JdbcTablePartitionOperations createJdbcTablePartitionOperations(JdbcTable loadedTable) {
        return new StarRocksTablePartitionOperations(this.dataSource, loadedTable, this.exceptionMapper, this.typeConverter);
    }

    protected String generateCreateTableSql(String tableName, JdbcColumn[] columns, String comment, Map<String, String> properties, Transform[] partitioning, Distribution distribution, Index[] indexes) {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append(String.format("CREATE TABLE `%s` ( \n", tableName));
        sqlBuilder.append(Arrays.stream(columns).map(column -> {
            StringBuilder columnsSql = new StringBuilder();
            columnsSql.append(" ").append(BACK_QUOTE).append(column.name()).append(BACK_QUOTE);
            this.appendColumnDefinition((JdbcColumn)column, columnsSql);
            return columnsSql.toString();
        }).collect(Collectors.joining(",\n")));
        sqlBuilder.append(")\n");
        if (StringUtils.isNotEmpty((CharSequence)comment)) {
            comment = StringIdentifier.addToComment((StringIdentifier)StringIdentifier.DUMMY_ID, (String)comment);
            sqlBuilder.append(" COMMENT \"").append(comment).append("\"");
        }
        StarRocksTableOperations.appendPartitionSql(partitioning, columns, sqlBuilder);
        StarRocksTableOperations.addDistributionSql(distribution, sqlBuilder);
        StarRocksTableOperations.addPropertiesSql(properties, sqlBuilder);
        String result = sqlBuilder.toString();
        LOG.info("Generated create table:{} sql: {}", (Object)tableName, (Object)result);
        return result;
    }

    protected String generateAlterTableSql(String databaseName, String tableName, TableChange ... changes) {
        JdbcTable lazyLoadTable = null;
        ArrayList<Object> alterSql = new ArrayList<Object>();
        boolean hasSetPropertyChange = false;
        for (int i = 0; i < changes.length; ++i) {
            TableChange change = changes[i];
            if (change instanceof TableChange.AddColumn) {
                TableChange.AddColumn addColumn = (TableChange.AddColumn)change;
                lazyLoadTable = this.getOrCreateTable(databaseName, tableName, lazyLoadTable);
                alterSql.add(this.addColumnFieldDefinition(addColumn));
                continue;
            }
            if (change instanceof TableChange.DeleteColumn) {
                TableChange.DeleteColumn deleteColumn = (TableChange.DeleteColumn)change;
                lazyLoadTable = this.getOrCreateTable(databaseName, tableName, lazyLoadTable);
                alterSql.add(this.deleteColumnFieldDefinition(deleteColumn, lazyLoadTable));
                continue;
            }
            if (change instanceof TableChange.RemoveProperty) {
                throw new IllegalArgumentException("Remove property is not supported yet.");
            }
            if (change instanceof TableChange.RenameColumn) {
                TableChange.RenameColumn renameColumn = (TableChange.RenameColumn)change;
                lazyLoadTable = this.getOrCreateTable(databaseName, tableName, lazyLoadTable);
                alterSql.add(this.renameColumnDefinition(renameColumn, lazyLoadTable));
                continue;
            }
            if (change instanceof TableChange.RenameTable) {
                TableChange.RenameTable renameTable = (TableChange.RenameTable)change;
                lazyLoadTable = this.getOrCreateTable(databaseName, tableName, lazyLoadTable);
                alterSql.add(this.renameTableDefinition(renameTable, lazyLoadTable));
                continue;
            }
            if (change instanceof TableChange.UpdateColumnPosition) {
                TableChange.UpdateColumnPosition updateColumnPosition = (TableChange.UpdateColumnPosition)change;
                lazyLoadTable = this.getOrCreateTable(databaseName, tableName, lazyLoadTable);
                alterSql.add(this.updateColumnPositionFieldDefinition(updateColumnPosition, lazyLoadTable));
                continue;
            }
            if (change instanceof TableChange.UpdateColumnType) {
                TableChange.UpdateColumnType updateColumnType = (TableChange.UpdateColumnType)change;
                lazyLoadTable = this.getOrCreateTable(databaseName, tableName, lazyLoadTable);
                alterSql.add(this.updateColumnTypeFieldDefinition(updateColumnType, lazyLoadTable));
                continue;
            }
            if (change instanceof TableChange.UpdateComment) {
                TableChange.UpdateComment updateComment = (TableChange.UpdateComment)change;
                String newComment = updateComment.getNewComment();
                alterSql.add("MODIFY COMMENT \"" + newComment + "\"");
                continue;
            }
            if (change instanceof TableChange.SetProperty) {
                if (hasSetPropertyChange) {
                    throw new IllegalArgumentException("StarRocks suggest modify one property at a time, please split it to multiple request.");
                }
                TableChange.SetProperty setProperty = (TableChange.SetProperty)change;
                if (!SUPPORTED_MODIFY_PROPERTIES.contains(setProperty.getProperty()) && setProperty.getProperty().startsWith(SUPPORTED_MODIFY_PROPERTIES_PREFIX_DYNAMIC_PARTITION) && setProperty.getProperty().startsWith(SUPPORTED_MODIFY_PROPERTIES_PREFIX_BINLOG)) {
                    throw new IllegalArgumentException("Current StarRocks not support modify this table property " + setProperty.getProperty());
                }
                alterSql.add(this.generateTableProperties(setProperty));
                hasSetPropertyChange = true;
                continue;
            }
            throw new IllegalArgumentException("Unsupported table change type : " + change.getClass().getName());
        }
        String result = "ALTER TABLE `" + tableName + "`\n" + String.join((CharSequence)",\n", alterSql) + ";";
        LOG.info("Generated alter table:{}.{} sql: {}", new Object[]{databaseName, tableName, result});
        return result;
    }

    protected boolean getAutoIncrementInfo(ResultSet resultSet) throws SQLException {
        return "YES".equalsIgnoreCase(resultSet.getString("IS_AUTOINCREMENT"));
    }

    protected Map<String, String> getTableProperties(Connection connection, String tableName) throws SQLException {
        String showCreateTableSQL = String.format("SHOW CREATE TABLE `%s`", tableName);
        StringBuilder createTableSqlSb = new StringBuilder();
        try (Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(showCreateTableSQL);){
            while (resultSet.next()) {
                createTableSqlSb.append(resultSet.getString("Create Table"));
            }
        }
        String createTableSql = createTableSqlSb.toString();
        if (StringUtils.isEmpty((CharSequence)createTableSql)) {
            throw new NoSuchTableException("Table %s does not exist in %s.", new Object[]{tableName, connection.getCatalog()});
        }
        return Collections.unmodifiableMap(StarRocksUtils.extractPropertiesFromSql(createTableSql));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected List<Index> getIndexes(Connection connection, String databaseName, String tableName) throws SQLException {
        String sql = String.format("SHOW INDEX FROM `%s` FROM `%s`", tableName, databaseName);
        try (PreparedStatement preparedStatement = connection.prepareStatement(sql);){
            ArrayList<Index> arrayList;
            block15: {
                ResultSet resultSet = preparedStatement.executeQuery();
                try {
                    ArrayList<Index> indexes = new ArrayList<Index>();
                    while (resultSet.next()) {
                        String indexName = resultSet.getString("Key_name");
                        String columnName = resultSet.getString("Column_name");
                        indexes.add(Indexes.of((Index.IndexType)Index.IndexType.PRIMARY_KEY, (String)indexName, (String[][])new String[][]{{columnName}}));
                    }
                    arrayList = indexes;
                    if (resultSet == null) break block15;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return arrayList;
        }
        catch (SQLException e) {
            throw this.exceptionMapper.toGravitinoException(e);
        }
    }

    /*
     * Exception decompiling
     */
    protected Transform[] getTablePartitioning(Connection connection, String databaseName, String tableName) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void correctJdbcTableFields(Connection connection, String databaseName, String tableName, JdbcTable.Builder tableBuilder) throws SQLException {
        String showCreateTableSql = String.format("SHOW CREATE TABLE `%s`", tableName);
        try (Statement statement = connection.createStatement();
             ResultSet result = statement.executeQuery(showCreateTableSql);){
            StringBuilder createTableSql = new StringBuilder();
            if (result.next()) {
                createTableSql.append(result.getString("Create Table"));
            }
            String tableComment = StarRocksUtils.extractTableCommentFromSql(createTableSql.toString());
            tableBuilder.withComment(tableComment);
        }
    }

    protected String generateRenameTableSql(String oldTableName, String newTableName) {
        return String.format("ALTER TABLE `%s` RENAME `%s`", oldTableName, newTableName);
    }

    protected String generatePurgeTableSql(String tableName) {
        throw new UnsupportedOperationException("StarRocks does not support purge table in Gravitino, please use drop table");
    }

    protected String generatePurgeTableSql(String databaseName, String tableName) {
        return String.format("TRUNCATE TABLE `%s`.`%s`", databaseName, tableName);
    }

    protected Distribution getDistributionInfo(Connection connection, String databaseName, String tableName) throws SQLException {
        String showCreateTableSql = String.format("SHOW CREATE TABLE `%s`", tableName);
        try (Statement statement = connection.createStatement();){
            Distribution distribution;
            block12: {
                ResultSet result = statement.executeQuery(showCreateTableSql);
                try {
                    result.next();
                    String createTableSyntax = result.getString("Create Table");
                    distribution = StarRocksUtils.extractDistributionInfoFromSql(createTableSyntax);
                    if (result == null) break block12;
                }
                catch (Throwable throwable) {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                result.close();
            }
            return distribution;
        }
    }

    public StringBuilder appendColumnDefinition(JdbcColumn column, StringBuilder sqlBuilder) {
        sqlBuilder.append(" ").append((String)this.typeConverter.fromGravitino(column.dataType())).append(" ");
        if (column.nullable()) {
            sqlBuilder.append("NULL ");
        } else {
            sqlBuilder.append("NOT NULL ");
        }
        if (!Column.DEFAULT_VALUE_NOT_SET.equals(column.defaultValue())) {
            sqlBuilder.append("DEFAULT ").append(this.columnDefaultValueConverter.fromGravitino(column.defaultValue())).append(" ");
        }
        if (column.autoIncrement()) {
            sqlBuilder.append(AUTO_INCREMENT).append(" ");
        }
        if (StringUtils.isNotEmpty((CharSequence)column.comment())) {
            sqlBuilder.append("COMMENT '").append(column.comment()).append("' ");
        }
        return sqlBuilder;
    }

    private static void appendPartitionSql(Transform[] partitioning, JdbcColumn[] columns, StringBuilder sqlBuilder) {
        StringBuilder partitionSqlBuilder;
        if (ArrayUtils.isEmpty((Object[])partitioning)) {
            return;
        }
        Preconditions.checkArgument((partitioning.length == 1 ? 1 : 0) != 0, (Object)"Composite partition type is not supported");
        Set<String> columnNames = Arrays.stream(columns).map(BaseColumn::name).collect(Collectors.toSet());
        if (partitioning[0] instanceof Transforms.RangeTransform) {
            Transforms.RangeTransform rangePartition = (Transforms.RangeTransform)partitioning[0];
            partitionSqlBuilder = StarRocksTableOperations.generateRangePartitionSql(rangePartition, columnNames);
        } else if (partitioning[0] instanceof Transforms.ListTransform) {
            Transforms.ListTransform listPartition = (Transforms.ListTransform)partitioning[0];
            partitionSqlBuilder = StarRocksTableOperations.generateListPartitionSql(listPartition, columnNames);
        } else {
            throw new IllegalArgumentException("Unsupported partition type of StarRocks");
        }
        sqlBuilder.append((CharSequence)partitionSqlBuilder);
    }

    private static StringBuilder generateRangePartitionSql(Transforms.RangeTransform rangePartition, Set<String> columnNames) {
        Preconditions.checkArgument((rangePartition.fieldName().length == 1 ? 1 : 0) != 0, (Object)"StarRocks partition does not support nested field");
        Preconditions.checkArgument((boolean)columnNames.contains(rangePartition.fieldName()[0]), (Object)"The partition field must be one of the columns");
        StringBuilder partitionSqlBuilder = new StringBuilder(NEW_LINE);
        String partitionDefinition = String.format(" PARTITION BY RANGE(`%s`)", rangePartition.fieldName()[0]);
        partitionSqlBuilder.append(partitionDefinition).append(NEW_LINE).append("(");
        Object[] assignments = rangePartition.assignments();
        if (!ArrayUtils.isEmpty((Object[])assignments)) {
            String partitionSqlFragments = Arrays.stream(assignments).map(StarRocksUtils::generatePartitionSqlFragment).collect(Collectors.joining(",\n"));
            partitionSqlBuilder.append(NEW_LINE).append(partitionSqlFragments);
        }
        partitionSqlBuilder.append(NEW_LINE).append(")");
        return partitionSqlBuilder;
    }

    private static StringBuilder generateListPartitionSql(Transforms.ListTransform listPartition, Set<String> columnNames) {
        String[][] filedNames;
        ImmutableList.Builder partitionColumnsBuilder = ImmutableList.builder();
        for (String[] filedName : filedNames = listPartition.fieldNames()) {
            Preconditions.checkArgument((filedName.length == 1 ? 1 : 0) != 0, (Object)"StarRocks partition does not support nested field");
            Preconditions.checkArgument((boolean)columnNames.contains(filedName[0]), (Object)"The partition field must be one of the columns");
            partitionColumnsBuilder.add((Object)(BACK_QUOTE + filedName[0] + BACK_QUOTE));
        }
        String partitionColumns = partitionColumnsBuilder.build().stream().collect(Collectors.joining(","));
        StringBuilder partitionSqlBuilder = new StringBuilder(NEW_LINE);
        String partitionDefinition = String.format(" PARTITION BY LIST(%s)", partitionColumns);
        partitionSqlBuilder.append(partitionDefinition).append(NEW_LINE).append("(");
        Object[] assignments = listPartition.assignments();
        if (!ArrayUtils.isEmpty((Object[])assignments)) {
            ImmutableList.Builder partitions = ImmutableList.builder();
            for (Object part : assignments) {
                Literal[][] lists = part.lists();
                Preconditions.checkArgument((lists.length > 0 ? 1 : 0) != 0, (Object)"The number of values in list partition must be greater than 0");
                Preconditions.checkArgument((boolean)Arrays.stream(lists).allMatch(p -> ((Literal[])p).length == filedNames.length), (Object)"The number of partitioning columns must be consistent");
                partitions.add((Object)StarRocksUtils.generatePartitionSqlFragment((Partition)part));
            }
            partitionSqlBuilder.append(NEW_LINE).append(partitions.build().stream().collect(Collectors.joining(",\n")));
        }
        partitionSqlBuilder.append(NEW_LINE).append(")");
        return partitionSqlBuilder;
    }

    private static void addDistributionSql(Distribution distribution, StringBuilder sqlBuilder) {
        if (distribution == null || distribution.strategy() == Strategy.NONE) {
            return;
        }
        if (distribution.strategy() == Strategy.HASH) {
            sqlBuilder.append(NEW_LINE).append(" DISTRIBUTED BY HASH(");
            sqlBuilder.append(Arrays.stream(distribution.expressions()).map(column -> BACK_QUOTE + column.toString() + BACK_QUOTE).collect(Collectors.joining(", ")));
            sqlBuilder.append(")");
        } else if (distribution.strategy() == Strategy.EVEN) {
            sqlBuilder.append(NEW_LINE).append(" DISTRIBUTED BY ").append("RANDOM");
        }
        if (distribution.number() != -1) {
            sqlBuilder.append(" BUCKETS ").append(StarRocksUtils.toBucketNumberString(distribution.number()));
        }
    }

    private static void addPropertiesSql(Map<String, String> properties, StringBuilder sqlBuilder) {
        if (properties == null || properties.isEmpty()) {
            return;
        }
        sqlBuilder.append(NEW_LINE).append(StarRocksUtils.generatePropertiesSql(properties));
    }

    private String addColumnFieldDefinition(TableChange.AddColumn addColumn) {
        String dataType = (String)this.typeConverter.fromGravitino(addColumn.getDataType());
        if (addColumn.fieldName().length > 1) {
            throw new UnsupportedOperationException("StarRocks does not support nested column names.");
        }
        String col = addColumn.fieldName()[0];
        StringBuilder columnDefinition = new StringBuilder();
        columnDefinition.append("ADD COLUMN ").append(BACK_QUOTE).append(col).append(BACK_QUOTE).append(" ").append(dataType).append(" ");
        if (StringUtils.isNotEmpty((CharSequence)addColumn.getComment())) {
            columnDefinition.append("COMMENT '").append(addColumn.getComment()).append("' ");
        }
        if (addColumn.getPosition() instanceof TableChange.First) {
            columnDefinition.append("FIRST");
        } else if (addColumn.getPosition() instanceof TableChange.After) {
            TableChange.After afterPosition = (TableChange.After)addColumn.getPosition();
            columnDefinition.append("AFTER ").append(BACK_QUOTE).append(afterPosition.getColumn()).append(BACK_QUOTE);
        } else if (!(addColumn.getPosition() instanceof TableChange.Default)) {
            throw new IllegalArgumentException("Invalid column position.");
        }
        return columnDefinition.toString();
    }

    private String deleteColumnFieldDefinition(TableChange.DeleteColumn deleteColumn, JdbcTable jdbcTable) {
        if (deleteColumn.fieldName().length > 1) {
            throw new UnsupportedOperationException("StarRocks does not support nested column names.");
        }
        String col = deleteColumn.fieldName()[0];
        try {
            this.getJdbcColumnFromTable(jdbcTable, col);
        }
        catch (NoSuchColumnException ex) {
            if (BooleanUtils.isTrue((Boolean)deleteColumn.getIfExists())) {
                return "";
            }
            throw new IllegalArgumentException("Delete column does not exist: " + col);
        }
        return "DROP COLUMN `" + col + BACK_QUOTE;
    }

    private String renameColumnDefinition(TableChange.RenameColumn renameColumn, JdbcTable jdbcTable) {
        if (renameColumn.fieldName().length > 1) {
            throw new UnsupportedOperationException("StarRocks does not support nested column names.");
        }
        String oldColName = renameColumn.fieldName()[0];
        try {
            this.getJdbcColumnFromTable(jdbcTable, oldColName);
        }
        catch (NoSuchColumnException ex) {
            throw new IllegalArgumentException("Original column does not exist: " + oldColName);
        }
        try {
            this.getJdbcColumnFromTable(jdbcTable, renameColumn.getNewName());
        }
        catch (NoSuchColumnException ex) {
            return String.format("RENAME COLUMN %s TO %s", oldColName, renameColumn.getNewName());
        }
        throw new IllegalArgumentException("Column already exists: " + renameColumn.getNewName());
    }

    private String renameTableDefinition(TableChange.RenameTable renameTable, JdbcTable jdbcTable) {
        try {
            this.load(jdbcTable.databaseName(), renameTable.getNewName());
        }
        catch (NoSuchTableException ex) {
            return "RENAME " + renameTable.getNewName();
        }
        throw new IllegalArgumentException("Table already exists: " + renameTable.getNewName());
    }

    private String generateTableProperties(TableChange.SetProperty setProperty) {
        return String.format("set ( \"%s\" = \"%s\" )", setProperty.getProperty(), setProperty.getValue());
    }

    private String updateColumnPositionFieldDefinition(TableChange.UpdateColumnPosition updateColumnPosition, JdbcTable jdbcTable) {
        if (updateColumnPosition.fieldName().length > 1) {
            throw new UnsupportedOperationException("StarRocks does not support nested column names.");
        }
        String col = updateColumnPosition.fieldName()[0];
        JdbcColumn column = this.getJdbcColumnFromTable(jdbcTable, col);
        StringBuilder columnDefinition = new StringBuilder();
        columnDefinition.append("MODIFY COLUMN ").append(BACK_QUOTE).append(col).append(BACK_QUOTE);
        this.appendColumnDefinition(column, columnDefinition);
        if (updateColumnPosition.getPosition() instanceof TableChange.First) {
            columnDefinition.append("FIRST");
        } else if (updateColumnPosition.getPosition() instanceof TableChange.After) {
            TableChange.After afterPosition = (TableChange.After)updateColumnPosition.getPosition();
            columnDefinition.append("AFTER ").append(BACK_QUOTE).append(afterPosition.getColumn()).append(BACK_QUOTE);
        } else {
            Arrays.stream(jdbcTable.columns()).reduce((column1, column2) -> column2).map(Column::name).ifPresent(s -> columnDefinition.append("AFTER ").append((String)s));
        }
        return columnDefinition.toString();
    }

    private String updateColumnTypeFieldDefinition(TableChange.UpdateColumnType updateColumnType, JdbcTable jdbcTable) {
        if (updateColumnType.fieldName().length > 1) {
            throw new UnsupportedOperationException("StarRocks does not support nested column names.");
        }
        String col = updateColumnType.fieldName()[0];
        JdbcColumn column = this.getJdbcColumnFromTable(jdbcTable, col);
        StringBuilder sqlBuilder = new StringBuilder("MODIFY COLUMN `" + col + BACK_QUOTE);
        JdbcColumn newColumn = (JdbcColumn)((JdbcColumn.Builder)((JdbcColumn.Builder)((JdbcColumn.Builder)((JdbcColumn.Builder)((JdbcColumn.Builder)((JdbcColumn.Builder)JdbcColumn.builder().withName(col)).withType(updateColumnType.getNewDataType())).withComment(column.comment())).withDefaultValue(Column.DEFAULT_VALUE_NOT_SET)).withNullable(column.nullable())).withAutoIncrement(column.autoIncrement())).build();
        return this.appendColumnDefinition(newColumn, sqlBuilder).toString();
    }
}

