/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.authorization.ranger;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.gravitino.authorization.AuthorizationPrivilege;
import org.apache.gravitino.authorization.AuthorizationSecurableObject;
import org.apache.gravitino.authorization.Owner;
import org.apache.gravitino.authorization.Privilege;
import org.apache.gravitino.exceptions.AuthorizationPluginException;
import org.apache.ranger.RangerClient;
import org.apache.ranger.RangerServiceException;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerRole;
import org.apache.ranger.plugin.util.GrantRevokeRoleRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerHelper {
    private static final Logger LOG = LoggerFactory.getLogger(RangerHelper.class);
    public static final String MANAGED_BY_GRAVITINO = "MANAGED_BY_GRAVITINO";
    public static final String RESOURCE_ALL = "*";
    private final Set<AuthorizationPrivilege> ownerPrivileges;
    protected final List<String> policyResourceDefines;
    private final RangerClient rangerClient;
    private final String rangerAdminName;
    private final String rangerServiceName;
    public static final String GRAVITINO_ROLE_PREFIX = "GRAVITINO_";
    public static final String GRAVITINO_METALAKE_OWNER_ROLE = "GRAVITINO_METALAKE_OWNER_ROLE";
    public static final String GRAVITINO_CATALOG_OWNER_ROLE = "GRAVITINO_CATALOG_OWNER_ROLE";
    public static final String GRAVITINO_OWNER_ROLE = "GRAVITINO_OWNER_ROLE";

    public RangerHelper(RangerClient rangerClient, String rangerAdminName, String rangerServiceName, Set<AuthorizationPrivilege> ownerPrivileges, List<String> resourceDefines) {
        this.rangerClient = rangerClient;
        this.rangerAdminName = rangerAdminName;
        this.rangerServiceName = rangerServiceName;
        this.ownerPrivileges = ownerPrivileges;
        this.policyResourceDefines = resourceDefines;
    }

    public static void checkPolicyItemAccess(RangerPolicy.RangerPolicyItem policyItem) throws AuthorizationPluginException {
        if (!RangerHelper.isGravitinoManagedPolicyItemAccess(policyItem)) {
            return;
        }
        if (policyItem.getAccesses().size() != 1) {
            throw new AuthorizationPluginException("The access type only have one in the delegate Gravitino management policy", new Object[0]);
        }
    }

    void addPolicyItem(RangerPolicy policy, String roleName, AuthorizationSecurableObject securableObject) {
        securableObject.privileges().forEach(rangerPrivilege -> {
            List matchPolicyItems = rangerPrivilege.condition() == Privilege.Condition.ALLOW ? policy.getPolicyItems().stream().filter(policyItem -> policyItem.getAccesses().stream().anyMatch(access -> access.getType().equals(rangerPrivilege.getName()) && RangerHelper.isGravitinoManagedPolicyItemAccess(policyItem))).collect(Collectors.toList()) : policy.getDenyPolicyItems().stream().filter(policyItem -> policyItem.getAccesses().stream().anyMatch(access -> access.getType().equals(rangerPrivilege.getName()) && RangerHelper.isGravitinoManagedPolicyItemAccess(policyItem))).collect(Collectors.toList());
            if (matchPolicyItems.isEmpty()) {
                RangerPolicy.RangerPolicyItem policyItem2 = new RangerPolicy.RangerPolicyItem();
                RangerPolicy.RangerPolicyItemAccess access = new RangerPolicy.RangerPolicyItemAccess();
                access.setType(rangerPrivilege.getName());
                policyItem2.getAccesses().add(access);
                policyItem2.getRoles().add(this.generateGravitinoRoleName(roleName));
                if (Privilege.Condition.ALLOW == rangerPrivilege.condition()) {
                    policy.getPolicyItems().add(policyItem2);
                } else {
                    policy.getDenyPolicyItems().add(policyItem2);
                }
            } else {
                matchPolicyItems.stream().forEach(policyItem -> {
                    if (!policyItem.getRoles().contains(this.generateGravitinoRoleName(roleName))) {
                        policyItem.getRoles().add(this.generateGravitinoRoleName(roleName));
                    }
                });
            }
        });
    }

    public static boolean isGravitinoManagedPolicyItemAccess(RangerPolicy.RangerPolicyItem policyItem) {
        return policyItem.getRoles().stream().anyMatch(role -> role.startsWith(GRAVITINO_ROLE_PREFIX));
    }

    public static boolean hasGravitinoManagedPolicyItem(RangerPolicy policy) {
        List policyItems = policy.getPolicyItems();
        policyItems.addAll(policy.getDenyPolicyItems());
        policyItems.addAll(policy.getRowFilterPolicyItems());
        policyItems.addAll(policy.getDataMaskPolicyItems());
        return policyItems.stream().anyMatch(RangerHelper::isGravitinoManagedPolicyItemAccess);
    }

    public void removeAllGravitinoManagedPolicyItem(RangerPolicy policy) {
        try {
            policy.setPolicyItems(policy.getPolicyItems().stream().filter(item -> !RangerHelper.isGravitinoManagedPolicyItemAccess(item)).collect(Collectors.toList()));
            policy.setDenyPolicyItems(policy.getDenyPolicyItems().stream().filter(item -> !RangerHelper.isGravitinoManagedPolicyItemAccess(item)).collect(Collectors.toList()));
            policy.setRowFilterPolicyItems(policy.getRowFilterPolicyItems().stream().filter(item -> !RangerHelper.isGravitinoManagedPolicyItemAccess((RangerPolicy.RangerPolicyItem)item)).collect(Collectors.toList()));
            policy.setDataMaskPolicyItems(policy.getDataMaskPolicyItems().stream().filter(item -> !RangerHelper.isGravitinoManagedPolicyItemAccess((RangerPolicy.RangerPolicyItem)item)).collect(Collectors.toList()));
            if (policy.getPolicyItems().isEmpty() && policy.getDenyPolicyItems().isEmpty() && policy.getRowFilterPolicyItems().isEmpty() && policy.getDataMaskPolicyItems().isEmpty()) {
                this.rangerClient.deletePolicy(policy.getId().longValue());
            } else {
                this.rangerClient.updatePolicy(policy.getId().longValue(), policy);
            }
        }
        catch (RangerServiceException e) {
            LOG.error("Failed to update the policy {}!", (Object)policy);
            throw new RuntimeException(e);
        }
    }

    protected boolean checkRangerRole(String roleName) throws AuthorizationPluginException {
        roleName = this.generateGravitinoRoleName(roleName);
        try {
            this.rangerClient.getRole(roleName, this.rangerAdminName, this.rangerServiceName);
        }
        catch (RangerServiceException e) {
            throw new AuthorizationPluginException((Throwable)e, "Failed to check the role(%s) in the Ranger", new Object[]{roleName});
        }
        return true;
    }

    public String generateGravitinoRoleName(String roleName) {
        if (roleName.startsWith(GRAVITINO_ROLE_PREFIX)) {
            return roleName;
        }
        return GRAVITINO_ROLE_PREFIX + roleName;
    }

    protected GrantRevokeRoleRequest createGrantRevokeRoleRequest(String roleName, String userName, String groupName) {
        HashSet groups;
        roleName = this.generateGravitinoRoleName(roleName);
        HashSet users = StringUtils.isEmpty((String)userName) ? Sets.newHashSet() : Sets.newHashSet((Object[])new String[]{userName});
        HashSet hashSet = groups = StringUtils.isEmpty((String)groupName) ? Sets.newHashSet() : Sets.newHashSet((Object[])new String[]{groupName});
        if (users.isEmpty() && groups.isEmpty()) {
            throw new AuthorizationPluginException("The user and group cannot be empty!", new Object[0]);
        }
        GrantRevokeRoleRequest roleRequest = new GrantRevokeRoleRequest();
        roleRequest.setUsers((Set)users);
        roleRequest.setGroups((Set)groups);
        roleRequest.setGrantor(this.rangerAdminName);
        roleRequest.setTargetRoles((Set)Sets.newHashSet((Object[])new String[]{roleName}));
        return roleRequest;
    }

    protected RangerRole createRangerRoleIfNotExists(String roleName, boolean isOwnerRole) {
        roleName = this.generateGravitinoRoleName(roleName);
        if (isOwnerRole) {
            Preconditions.checkArgument((roleName.equalsIgnoreCase(GRAVITINO_METALAKE_OWNER_ROLE) || roleName.equalsIgnoreCase(GRAVITINO_CATALOG_OWNER_ROLE) || roleName.equalsIgnoreCase(GRAVITINO_OWNER_ROLE) ? 1 : 0) != 0, (Object)String.format("The role name should be %s or %s or %s", GRAVITINO_METALAKE_OWNER_ROLE, GRAVITINO_CATALOG_OWNER_ROLE, GRAVITINO_OWNER_ROLE));
        } else {
            Preconditions.checkArgument((!roleName.equalsIgnoreCase(GRAVITINO_METALAKE_OWNER_ROLE) && !roleName.equalsIgnoreCase(GRAVITINO_CATALOG_OWNER_ROLE) && !roleName.equalsIgnoreCase(GRAVITINO_OWNER_ROLE) ? 1 : 0) != 0, (Object)String.format("The role name should not be %s or %s or %s", GRAVITINO_METALAKE_OWNER_ROLE, GRAVITINO_CATALOG_OWNER_ROLE, GRAVITINO_OWNER_ROLE));
        }
        RangerRole rangerRole = this.getRangerRole(roleName);
        try {
            if (rangerRole == null) {
                rangerRole = new RangerRole(roleName, MANAGED_BY_GRAVITINO, null, null, null);
                this.rangerClient.createRole(this.rangerServiceName, rangerRole);
            }
        }
        catch (RangerServiceException e) {
            throw new AuthorizationPluginException((Throwable)e, "Failed to create the role(%s) in the Ranger", new Object[]{roleName});
        }
        return rangerRole;
    }

    public RangerRole getRangerRole(String roleName) {
        RangerRole rangerRole = null;
        try {
            rangerRole = this.rangerClient.getRole(roleName, this.rangerAdminName, this.rangerServiceName);
        }
        catch (RangerServiceException e) {
            if (e.getMessage() != null && e.getMessage().contains("User doesn't have permissions to get details")) {
                LOG.warn("The role({}) does not exist in the Ranger!, e: {}", (Object)roleName, (Object)e);
            }
            throw new AuthorizationPluginException("Failed to check role(%s) whether exists in the Ranger! e: %s", new Object[]{roleName, e.getMessage()});
        }
        return rangerRole;
    }

    protected void updatePolicyOwner(RangerPolicy policy, Owner preOwner, Owner newOwner) {
        List<RangerPolicy.RangerPolicyItem> matchPolicyItems = policy.getPolicyItems().stream().filter(policyItem -> policyItem.getAccesses().stream().allMatch(policyItemAccess -> this.ownerPrivileges.stream().anyMatch(ownerPrivilege -> ownerPrivilege.equalsTo(policyItemAccess.getType())))).filter(RangerHelper::isGravitinoManagedPolicyItemAccess).collect(Collectors.toList());
        matchPolicyItems.forEach(policyItem -> {
            if (preOwner != null) {
                if (preOwner.type() == Owner.Type.USER) {
                    policyItem.getUsers().removeIf(preOwner.name()::equals);
                } else {
                    policyItem.getGroups().removeIf(preOwner.name()::equals);
                }
            }
            if (newOwner != null) {
                if (newOwner.type() == Owner.Type.USER) {
                    if (!policyItem.getUsers().contains(newOwner.name())) {
                        policyItem.getUsers().add(newOwner.name());
                    }
                } else if (!policyItem.getGroups().contains(newOwner.name())) {
                    policyItem.getGroups().add(newOwner.name());
                }
            }
        });
        this.ownerPrivileges.stream().filter(ownerPrivilege -> matchPolicyItems.stream().noneMatch(policyItem -> policyItem.getAccesses().stream().anyMatch(policyItemAccess -> ownerPrivilege.equalsTo(policyItemAccess.getType())))).forEach(ownerPrivilege -> {
            RangerPolicy.RangerPolicyItem policyItem = new RangerPolicy.RangerPolicyItem();
            policyItem.getAccesses().add(new RangerPolicy.RangerPolicyItemAccess(ownerPrivilege.getName()));
            if (newOwner != null) {
                if (newOwner.type() == Owner.Type.USER) {
                    policyItem.getUsers().add(newOwner.name());
                } else {
                    policyItem.getGroups().add(newOwner.name());
                }
                this.addRoleToPolicyItemIfNoExists(policyItem, GRAVITINO_OWNER_ROLE);
            }
            policy.getPolicyItems().add(policyItem);
        });
    }

    protected void updatePolicyOwnerRole(RangerPolicy policy, String ownerRoleName) {
        List<RangerPolicy.RangerPolicyItem> matchPolicyItems = policy.getPolicyItems().stream().filter(policyItem -> policyItem.getAccesses().stream().allMatch(policyItemAccess -> this.ownerPrivileges.stream().anyMatch(ownerPrivilege -> ownerPrivilege.equalsTo(policyItemAccess.getType())))).collect(Collectors.toList());
        matchPolicyItems.forEach(policyItem -> this.addRoleToPolicyItemIfNoExists((RangerPolicy.RangerPolicyItem)policyItem, ownerRoleName));
        this.ownerPrivileges.stream().filter(ownerPrivilege -> matchPolicyItems.stream().noneMatch(policyItem -> policyItem.getAccesses().stream().anyMatch(policyItemAccess -> ownerPrivilege.equalsTo(policyItemAccess.getType())))).forEach(ownerPrivilege -> {
            RangerPolicy.RangerPolicyItem policyItem = new RangerPolicy.RangerPolicyItem();
            policyItem.getAccesses().add(new RangerPolicy.RangerPolicyItemAccess(ownerPrivilege.getName()));
            this.addRoleToPolicyItemIfNoExists(policyItem, ownerRoleName);
            policy.getPolicyItems().add(policyItem);
        });
    }

    private void addRoleToPolicyItemIfNoExists(RangerPolicy.RangerPolicyItem policyItem, String roleName) {
        String gravitinoRoleName = this.generateGravitinoRoleName(roleName);
        if (!policyItem.getRoles().contains(gravitinoRoleName)) {
            policyItem.getRoles().add(gravitinoRoleName);
        }
    }
}

