/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.runtime;

import com.googlecode.aviator.BaseExpression;
import com.googlecode.aviator.Expression;
import com.googlecode.aviator.parser.VariableMeta;
import com.googlecode.aviator.runtime.FunctionParam;
import com.googlecode.aviator.runtime.function.LambdaFunction;
import com.googlecode.aviator.utils.Env;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class LambdaFunctionBootstrap
implements Comparable<LambdaFunctionBootstrap>,
Serializable {
    private static final long serialVersionUID = -8884911908304713609L;
    private final String name;
    private final BaseExpression expression;
    private final List<FunctionParam> params;
    private final boolean inheritEnv;
    private transient ThreadLocal<Reference<LambdaFunction>> fnLocal = new ThreadLocal();

    @Override
    public int compareTo(LambdaFunctionBootstrap o) {
        return this.name.compareTo(o.name);
    }

    public String getName() {
        return this.name;
    }

    public LambdaFunctionBootstrap(String name, Expression expression, List<FunctionParam> arguments, boolean inheritEnv) {
        this.name = name;
        this.expression = (BaseExpression)expression;
        this.params = arguments;
        this.inheritEnv = inheritEnv;
    }

    public Collection<VariableMeta> getClosureOverFullVarNames() {
        Map<String, VariableMeta> fullNames = this.expression.getFullNameMetas();
        for (FunctionParam param : this.params) {
            fullNames.remove(param.getName());
        }
        Iterator<Map.Entry<String, VariableMeta>> it = fullNames.entrySet().iterator();
        block1: while (it.hasNext()) {
            Map.Entry<String, VariableMeta> fullName = it.next();
            for (FunctionParam param : this.params) {
                if (!fullName.getKey().startsWith(param.getName() + ".")) continue;
                it.remove();
                continue block1;
            }
        }
        return fullNames.values();
    }

    public Expression getExpression() {
        return this.expression;
    }

    public LambdaFunction newInstance(Env env) {
        LambdaFunction fn;
        Reference<LambdaFunction> ref = null;
        if (this.fnLocal == null) {
            this.fnLocal = new ThreadLocal();
        }
        if (this.inheritEnv && (ref = this.fnLocal.get()) != null) {
            fn = ref.get();
            if (fn != null) {
                fn.setContext(env);
                return fn;
            }
            this.fnLocal.remove();
        }
        fn = new LambdaFunction(this.name, this.params, this.expression, env);
        fn.setInheritEnv(this.inheritEnv);
        if (this.inheritEnv) {
            this.fnLocal.set(new SoftReference<LambdaFunction>(fn));
        }
        return fn;
    }
}

