/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.runtime.type;

import com.googlecode.aviator.exception.CompareNotSupportedException;
import com.googlecode.aviator.runtime.RuntimeUtils;
import com.googlecode.aviator.runtime.type.AviatorBigInt;
import com.googlecode.aviator.runtime.type.AviatorDecimal;
import com.googlecode.aviator.runtime.type.AviatorDouble;
import com.googlecode.aviator.runtime.type.AviatorJavaType;
import com.googlecode.aviator.runtime.type.AviatorLong;
import com.googlecode.aviator.runtime.type.AviatorObject;
import com.googlecode.aviator.runtime.type.AviatorString;
import com.googlecode.aviator.utils.TypeUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;

public abstract class AviatorNumber
extends AviatorObject {
    private static final long serialVersionUID = 6775726371182360535L;
    protected Number number;
    protected long longValue;
    protected double doubleValue;

    public AviatorNumber(long longValue) {
        this.longValue = longValue;
    }

    public AviatorNumber(double doubleValue) {
        this.doubleValue = doubleValue;
    }

    public AviatorNumber(Number number) {
        this.number = number;
    }

    @Override
    public Object getValue(Map<String, Object> env) {
        return this.number;
    }

    public static AviatorNumber valueOf(Object value) {
        if (TypeUtils.isLong(value)) {
            return AviatorLong.valueOf(((Number)value).longValue());
        }
        if (TypeUtils.isDouble(value)) {
            return new AviatorDouble(((Number)value).doubleValue());
        }
        if (TypeUtils.isBigInt(value)) {
            return AviatorBigInt.valueOf((BigInteger)value);
        }
        if (TypeUtils.isDecimal(value)) {
            return AviatorDecimal.valueOf((BigDecimal)value);
        }
        throw new ClassCastException("Could not cast " + value.getClass().getName() + " to Number");
    }

    public double doubleValue() {
        return this.number.doubleValue();
    }

    @Override
    public AviatorObject add(AviatorObject other, Map<String, Object> env) {
        switch (other.getAviatorType()) {
            case String: {
                return new AviatorString(this.getValue(env).toString() + ((AviatorString)other).getLexeme(env));
            }
            case BigInt: 
            case Decimal: 
            case Long: 
            case Double: {
                return this.innerAdd(env, (AviatorNumber)other);
            }
            case JavaType: {
                AviatorJavaType otherJavaType = (AviatorJavaType)other;
                Object otherValue = otherJavaType.getValue(env);
                if (otherValue instanceof Number) {
                    return this.innerAdd(env, AviatorNumber.valueOf(otherValue));
                }
                if (TypeUtils.isString(otherValue)) {
                    return new AviatorString(this.getValue(env).toString() + otherValue);
                }
                return super.add(other, env);
            }
        }
        return super.add(other, env);
    }

    @Override
    public AviatorObject sub(AviatorObject other, Map<String, Object> env) {
        switch (other.getAviatorType()) {
            case BigInt: 
            case Decimal: 
            case Long: 
            case Double: {
                return this.innerSub(env, (AviatorNumber)other);
            }
            case JavaType: {
                AviatorJavaType otherJavaType = (AviatorJavaType)other;
                Object otherValue = otherJavaType.getValue(env);
                if (otherValue instanceof Number) {
                    return this.innerSub(env, AviatorNumber.valueOf(otherValue));
                }
                return super.sub(other, env);
            }
        }
        return super.sub(other, env);
    }

    @Override
    public AviatorObject mod(AviatorObject other, Map<String, Object> env) {
        switch (other.getAviatorType()) {
            case BigInt: 
            case Decimal: 
            case Long: 
            case Double: {
                return this.innerMod(env, (AviatorNumber)other);
            }
            case JavaType: {
                AviatorJavaType otherJavaType = (AviatorJavaType)other;
                Object otherValue = otherJavaType.getValue(env);
                if (otherValue instanceof Number) {
                    return this.innerMod(env, AviatorNumber.valueOf(otherValue));
                }
                return super.mod(other, env);
            }
        }
        return super.mod(other, env);
    }

    @Override
    public AviatorObject div(AviatorObject other, Map<String, Object> env) {
        switch (other.getAviatorType()) {
            case BigInt: 
            case Decimal: 
            case Long: 
            case Double: {
                return this.innerDiv(env, (AviatorNumber)other);
            }
            case JavaType: {
                AviatorJavaType otherJavaType = (AviatorJavaType)other;
                Object otherValue = otherJavaType.getValue(env);
                if (otherValue instanceof Number) {
                    return this.innerDiv(env, AviatorNumber.valueOf(otherValue));
                }
                return super.div(other, env);
            }
        }
        return super.div(other, env);
    }

    @Override
    public AviatorObject mult(AviatorObject other, Map<String, Object> env) {
        switch (other.getAviatorType()) {
            case BigInt: 
            case Decimal: 
            case Long: 
            case Double: {
                return this.innerMult(env, (AviatorNumber)other);
            }
            case JavaType: {
                AviatorJavaType otherJavaType = (AviatorJavaType)other;
                Object otherValue = otherJavaType.getValue(env);
                if (otherValue instanceof Number) {
                    return this.innerMult(env, AviatorNumber.valueOf(otherValue));
                }
                return super.mult(other, env);
            }
        }
        return super.mult(other, env);
    }

    @Override
    public int innerCompare(AviatorObject other, Map<String, Object> env) {
        switch (other.getAviatorType()) {
            case BigInt: 
            case Decimal: 
            case Long: 
            case Double: {
                return this.innerCompare(env, (AviatorNumber)other);
            }
            case JavaType: {
                AviatorJavaType otherJavaType = (AviatorJavaType)other;
                Object otherValue = otherJavaType.getValue(env);
                if (otherValue == null) {
                    return 1;
                }
                if (otherValue instanceof Number) {
                    return this.innerCompare(env, AviatorNumber.valueOf(otherValue));
                }
                throw new CompareNotSupportedException("Could not compare " + this.desc(env) + " with " + other.desc(env));
            }
            case Nil: {
                return 1;
            }
        }
        throw new CompareNotSupportedException("Could not compare " + this.desc(env) + " with " + other.desc(env));
    }

    public abstract AviatorObject innerSub(Map<String, Object> var1, AviatorNumber var2);

    public abstract AviatorObject innerMult(Map<String, Object> var1, AviatorNumber var2);

    public abstract AviatorObject innerMod(Map<String, Object> var1, AviatorNumber var2);

    public abstract AviatorObject innerDiv(Map<String, Object> var1, AviatorNumber var2);

    public abstract AviatorObject innerAdd(Map<String, Object> var1, AviatorNumber var2);

    public abstract int innerCompare(Map<String, Object> var1, AviatorNumber var2);

    public long longValue() {
        return this.number.longValue();
    }

    public final BigInteger toBigInt() {
        if (TypeUtils.isBigInt(this.number)) {
            return (BigInteger)this.number;
        }
        return new BigInteger(String.valueOf(this.longValue()));
    }

    public final BigDecimal toDecimal(Map<String, Object> env) {
        if (TypeUtils.isDecimal(this.number)) {
            return (BigDecimal)this.number;
        }
        if (TypeUtils.isBigInt(this.number)) {
            return new BigDecimal(this.toBigInt());
        }
        return new BigDecimal(this.doubleValue(), RuntimeUtils.getMathContext(env));
    }
}

