/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.listener;

import java.util.Map;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.Schema;
import org.apache.gravitino.SchemaChange;
import org.apache.gravitino.catalog.SchemaDispatcher;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.exceptions.NonEmptySchemaException;
import org.apache.gravitino.exceptions.SchemaAlreadyExistsException;
import org.apache.gravitino.listener.EventBus;
import org.apache.gravitino.listener.api.event.AlterSchemaEvent;
import org.apache.gravitino.listener.api.event.AlterSchemaFailureEvent;
import org.apache.gravitino.listener.api.event.AlterSchemaPreEvent;
import org.apache.gravitino.listener.api.event.CreateSchemaEvent;
import org.apache.gravitino.listener.api.event.CreateSchemaFailureEvent;
import org.apache.gravitino.listener.api.event.CreateSchemaPreEvent;
import org.apache.gravitino.listener.api.event.DropSchemaEvent;
import org.apache.gravitino.listener.api.event.DropSchemaFailureEvent;
import org.apache.gravitino.listener.api.event.DropSchemaPreEvent;
import org.apache.gravitino.listener.api.event.ListSchemaEvent;
import org.apache.gravitino.listener.api.event.ListSchemaFailureEvent;
import org.apache.gravitino.listener.api.event.ListSchemaPreEvent;
import org.apache.gravitino.listener.api.event.LoadSchemaEvent;
import org.apache.gravitino.listener.api.event.LoadSchemaFailureEvent;
import org.apache.gravitino.listener.api.event.LoadSchemaPreEvent;
import org.apache.gravitino.listener.api.info.SchemaInfo;
import org.apache.gravitino.utils.PrincipalUtils;

public class SchemaEventDispatcher
implements SchemaDispatcher {
    private final EventBus eventBus;
    private final SchemaDispatcher dispatcher;

    public SchemaEventDispatcher(EventBus eventBus, SchemaDispatcher dispatcher) {
        this.eventBus = eventBus;
        this.dispatcher = dispatcher;
    }

    @Override
    public NameIdentifier[] listSchemas(Namespace namespace) throws NoSuchCatalogException {
        this.eventBus.dispatchEvent(new ListSchemaPreEvent(PrincipalUtils.getCurrentUserName(), namespace));
        try {
            NameIdentifier[] nameIdentifiers = this.dispatcher.listSchemas(namespace);
            this.eventBus.dispatchEvent(new ListSchemaEvent(PrincipalUtils.getCurrentUserName(), namespace));
            return nameIdentifiers;
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent(new ListSchemaFailureEvent(PrincipalUtils.getCurrentUserName(), namespace, e));
            throw e;
        }
    }

    @Override
    public boolean schemaExists(NameIdentifier ident) {
        return this.dispatcher.schemaExists(ident);
    }

    @Override
    public Schema createSchema(NameIdentifier ident, String comment, Map<String, String> properties) throws NoSuchCatalogException, SchemaAlreadyExistsException {
        SchemaInfo createSchemaRequest = new SchemaInfo(ident.name(), comment, properties, null);
        this.eventBus.dispatchEvent(new CreateSchemaPreEvent(PrincipalUtils.getCurrentUserName(), ident, createSchemaRequest));
        try {
            Schema schema = this.dispatcher.createSchema(ident, comment, properties);
            this.eventBus.dispatchEvent(new CreateSchemaEvent(PrincipalUtils.getCurrentUserName(), ident, new SchemaInfo(schema)));
            return schema;
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent(new CreateSchemaFailureEvent(PrincipalUtils.getCurrentUserName(), ident, e, createSchemaRequest));
            throw e;
        }
    }

    @Override
    public Schema loadSchema(NameIdentifier ident) throws NoSuchSchemaException {
        this.eventBus.dispatchEvent(new LoadSchemaPreEvent(PrincipalUtils.getCurrentUserName(), ident));
        try {
            Schema schema = this.dispatcher.loadSchema(ident);
            this.eventBus.dispatchEvent(new LoadSchemaEvent(PrincipalUtils.getCurrentUserName(), ident, new SchemaInfo(schema)));
            return schema;
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent(new LoadSchemaFailureEvent(PrincipalUtils.getCurrentUserName(), ident, e));
            throw e;
        }
    }

    @Override
    public Schema alterSchema(NameIdentifier ident, SchemaChange ... changes) throws NoSuchSchemaException {
        this.eventBus.dispatchEvent(new AlterSchemaPreEvent(PrincipalUtils.getCurrentUserName(), ident, changes));
        try {
            Schema schema = this.dispatcher.alterSchema(ident, changes);
            this.eventBus.dispatchEvent(new AlterSchemaEvent(PrincipalUtils.getCurrentUserName(), ident, changes, new SchemaInfo(schema)));
            return schema;
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent(new AlterSchemaFailureEvent(PrincipalUtils.getCurrentUserName(), ident, e, changes));
            throw e;
        }
    }

    @Override
    public boolean dropSchema(NameIdentifier ident, boolean cascade) throws NonEmptySchemaException {
        this.eventBus.dispatchEvent(new DropSchemaPreEvent(PrincipalUtils.getCurrentUserName(), ident));
        try {
            boolean isExists = this.dispatcher.dropSchema(ident, cascade);
            this.eventBus.dispatchEvent(new DropSchemaEvent(PrincipalUtils.getCurrentUserName(), ident, isExists, cascade));
            return isExists;
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent(new DropSchemaFailureEvent(PrincipalUtils.getCurrentUserName(), ident, e, cascade));
            throw e;
        }
    }
}

