/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.deletionvectors;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Objects;
import java.util.zip.CRC32;
import org.apache.paimon.deletionvectors.BitmapDeletionVector;
import org.apache.paimon.deletionvectors.DeletionVector;
import org.apache.paimon.utils.OptimizedRoaringBitmap64;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.RoaringBitmap32;

public class Bitmap64DeletionVector
implements DeletionVector {
    public static final int MAGIC_NUMBER = 1681511377;
    public static final int LENGTH_SIZE_BYTES = 4;
    public static final int CRC_SIZE_BYTES = 4;
    public static final int MAGIC_NUMBER_SIZE_BYTES = 4;
    private static final int BITMAP_DATA_OFFSET = 4;
    private final OptimizedRoaringBitmap64 roaringBitmap;

    public Bitmap64DeletionVector() {
        this.roaringBitmap = new OptimizedRoaringBitmap64();
    }

    private Bitmap64DeletionVector(OptimizedRoaringBitmap64 roaringBitmap) {
        this.roaringBitmap = roaringBitmap;
    }

    public static Bitmap64DeletionVector fromBitmapDeletionVector(BitmapDeletionVector bitmapDeletionVector) {
        RoaringBitmap32 roaringBitmap32 = bitmapDeletionVector.get();
        return new Bitmap64DeletionVector(OptimizedRoaringBitmap64.fromRoaringBitmap32((RoaringBitmap32)roaringBitmap32));
    }

    @Override
    public void delete(long position) {
        this.roaringBitmap.add(position);
    }

    @Override
    public void merge(DeletionVector deletionVector) {
        if (!(deletionVector instanceof Bitmap64DeletionVector)) {
            throw new RuntimeException("Only instance with the same class type can be merged.");
        }
        this.roaringBitmap.or(((Bitmap64DeletionVector)deletionVector).roaringBitmap);
    }

    @Override
    public boolean isDeleted(long position) {
        return this.roaringBitmap.contains(position);
    }

    @Override
    public boolean isEmpty() {
        return this.roaringBitmap.isEmpty();
    }

    @Override
    public long getCardinality() {
        return this.roaringBitmap.cardinality();
    }

    @Override
    public int serializeTo(DataOutputStream out) throws IOException {
        this.roaringBitmap.runLengthEncode();
        int bitmapDataLength = Bitmap64DeletionVector.computeBitmapDataLength(this.roaringBitmap);
        byte[] bytes = new byte[4 + bitmapDataLength + 4];
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        buffer.putInt(bitmapDataLength);
        Bitmap64DeletionVector.serializeBitmapData(bytes, bitmapDataLength, this.roaringBitmap);
        int crcOffset = 4 + bitmapDataLength;
        int crc = Bitmap64DeletionVector.computeChecksum(bytes, bitmapDataLength);
        buffer.putInt(crcOffset, crc);
        buffer.rewind();
        out.write(bytes);
        return bytes.length;
    }

    public static DeletionVector deserializeFromBitmapDataBytes(byte[] bytes) {
        ByteBuffer bitmapData = ByteBuffer.wrap(bytes);
        bitmapData.order(ByteOrder.LITTLE_ENDIAN);
        OptimizedRoaringBitmap64 bitmap = OptimizedRoaringBitmap64.deserialize((ByteBuffer)bitmapData);
        return new Bitmap64DeletionVector(bitmap);
    }

    private static int computeBitmapDataLength(OptimizedRoaringBitmap64 bitmap) {
        long length = 4L + bitmap.serializedSizeInBytes();
        long bufferSize = 4L + length + 4L;
        Preconditions.checkState((bufferSize <= Integer.MAX_VALUE ? 1 : 0) != 0, (Object)"Can't serialize index > 2GB");
        return (int)length;
    }

    private static void serializeBitmapData(byte[] bytes, int bitmapDataLength, OptimizedRoaringBitmap64 bitmap) {
        ByteBuffer bitmapData = Bitmap64DeletionVector.pointToBitmapData(bytes, bitmapDataLength);
        bitmapData.putInt(1681511377);
        bitmap.serialize(bitmapData);
    }

    private static ByteBuffer pointToBitmapData(byte[] bytes, int bitmapDataLength) {
        ByteBuffer bitmapData = ByteBuffer.wrap(bytes, 4, bitmapDataLength);
        bitmapData.order(ByteOrder.LITTLE_ENDIAN);
        return bitmapData;
    }

    private static int readBitmapDataLength(ByteBuffer buffer, int size) {
        int expectedLength;
        int length = buffer.getInt();
        Preconditions.checkArgument((length == (expectedLength = size - 4 - 4) ? 1 : 0) != 0, (String)"Invalid bitmap data length: %s, expected %s", (Object[])new Object[]{length, expectedLength});
        return length;
    }

    private static OptimizedRoaringBitmap64 deserializeBitmap(byte[] bytes, int bitmapDataLength) {
        ByteBuffer bitmapData = Bitmap64DeletionVector.pointToBitmapData(bytes, bitmapDataLength);
        int magicNumber = bitmapData.getInt();
        Preconditions.checkArgument((magicNumber == 1681511377 ? 1 : 0) != 0, (String)"Invalid magic number: %s, expected %s", (Object[])new Object[]{magicNumber, 1681511377});
        return OptimizedRoaringBitmap64.deserialize((ByteBuffer)bitmapData);
    }

    private static int computeChecksum(byte[] bytes, int bitmapDataLength) {
        CRC32 crc = new CRC32();
        crc.update(bytes, 4, bitmapDataLength);
        return (int)crc.getValue();
    }

    protected static int toLittleEndianInt(int bigEndianInt) {
        byte[] bytes = ByteBuffer.allocate(4).putInt(bigEndianInt).array();
        return ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).getInt();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Bitmap64DeletionVector that = (Bitmap64DeletionVector)o;
        return Objects.equals(this.roaringBitmap, that.roaringBitmap);
    }

    public int hashCode() {
        return Objects.hashCode(this.roaringBitmap);
    }
}

