/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.utils.Preconditions;

public class SortedRun {
    private final List<DataFileMeta> files;
    private final long totalSize;

    private SortedRun(List<DataFileMeta> files) {
        this.files = Collections.unmodifiableList(files);
        long totalSize = 0L;
        for (DataFileMeta file : files) {
            totalSize += file.fileSize();
        }
        this.totalSize = totalSize;
    }

    public static SortedRun empty() {
        return new SortedRun(Collections.emptyList());
    }

    public static SortedRun fromSingle(DataFileMeta file) {
        return new SortedRun(Collections.singletonList(file));
    }

    public static SortedRun fromSorted(List<DataFileMeta> sortedFiles) {
        return new SortedRun(sortedFiles);
    }

    public static SortedRun fromUnsorted(List<DataFileMeta> unsortedFiles, Comparator<InternalRow> keyComparator) {
        unsortedFiles.sort((o1, o2) -> keyComparator.compare((InternalRow)o1.minKey(), (InternalRow)o2.minKey()));
        SortedRun run = new SortedRun(unsortedFiles);
        run.validate(keyComparator);
        return run;
    }

    public List<DataFileMeta> files() {
        return this.files;
    }

    public boolean isEmpty() {
        return this.files.isEmpty();
    }

    public boolean nonEmpty() {
        return !this.isEmpty();
    }

    public long totalSize() {
        return this.totalSize;
    }

    @VisibleForTesting
    public void validate(Comparator<InternalRow> comparator) {
        for (int i = 1; i < this.files.size(); ++i) {
            Preconditions.checkState((comparator.compare((InternalRow)this.files.get(i).minKey(), (InternalRow)this.files.get(i - 1).maxKey()) > 0 ? 1 : 0) != 0, (Object)"SortedRun is not sorted and may contain overlapping key intervals. This is a bug.");
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof SortedRun)) {
            return false;
        }
        SortedRun that = (SortedRun)o;
        return this.files.equals(that.files);
    }

    public int hashCode() {
        return Objects.hash(this.files);
    }

    public String toString() {
        return "[" + this.files.stream().map(DataFileMeta::toString).collect(Collectors.joining(", ")) + "]";
    }
}

