/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree.compact;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.stream.Collectors;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.mergetree.SortedRun;

public class IntervalPartition {
    private final List<DataFileMeta> files;
    private final Comparator<InternalRow> keyComparator;

    public IntervalPartition(List<DataFileMeta> inputFiles, Comparator<InternalRow> keyComparator) {
        this.files = new ArrayList<DataFileMeta>(inputFiles);
        this.files.sort((o1, o2) -> {
            int leftResult = keyComparator.compare((InternalRow)o1.minKey(), (InternalRow)o2.minKey());
            return leftResult == 0 ? keyComparator.compare((InternalRow)o1.maxKey(), (InternalRow)o2.maxKey()) : leftResult;
        });
        this.keyComparator = keyComparator;
    }

    public List<List<SortedRun>> partition() {
        ArrayList<List<SortedRun>> result = new ArrayList<List<SortedRun>>();
        ArrayList<DataFileMeta> section = new ArrayList<DataFileMeta>();
        BinaryRow bound = null;
        for (DataFileMeta meta : this.files) {
            if (!section.isEmpty() && this.keyComparator.compare((InternalRow)meta.minKey(), (InternalRow)bound) > 0) {
                result.add(this.partition(section));
                section.clear();
                bound = null;
            }
            section.add(meta);
            if (bound != null && this.keyComparator.compare((InternalRow)meta.maxKey(), (InternalRow)bound) <= 0) continue;
            bound = meta.maxKey();
        }
        if (!section.isEmpty()) {
            result.add(this.partition(section));
        }
        return result;
    }

    private List<SortedRun> partition(List<DataFileMeta> metas) {
        PriorityQueue<List> queue = new PriorityQueue<List>((o1, o2) -> this.keyComparator.compare((InternalRow)((DataFileMeta)o1.get(o1.size() - 1)).maxKey(), (InternalRow)((DataFileMeta)o2.get(o2.size() - 1)).maxKey()));
        ArrayList<DataFileMeta> firstRun = new ArrayList<DataFileMeta>();
        firstRun.add(metas.get(0));
        queue.add(firstRun);
        for (int i = 1; i < metas.size(); ++i) {
            DataFileMeta meta = metas.get(i);
            List top = (List)queue.poll();
            if (this.keyComparator.compare((InternalRow)meta.minKey(), (InternalRow)((DataFileMeta)top.get(top.size() - 1)).maxKey()) > 0) {
                top.add(meta);
            } else {
                ArrayList<DataFileMeta> newRun = new ArrayList<DataFileMeta>();
                newRun.add(meta);
                queue.add(newRun);
            }
            queue.add(top);
        }
        return queue.stream().map(SortedRun::fromSorted).collect(Collectors.toList());
    }
}

