/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

public final class BloomFilter64 {
    private final BitSet bitSet;
    private final int numBits;
    private final int numHashFunctions;

    public BloomFilter64(long items, double fpp) {
        int nb = (int)((double)(-items) * Math.log(fpp) / (Math.log(2.0) * Math.log(2.0)));
        this.numBits = nb + (8 - nb % 8);
        this.numHashFunctions = Math.max(1, (int)Math.round((double)this.numBits / (double)items * Math.log(2.0)));
        this.bitSet = new BitSet(new byte[this.numBits / 8], 0);
    }

    public BloomFilter64(int numHashFunctions, BitSet bitSet) {
        this.numHashFunctions = numHashFunctions;
        this.numBits = bitSet.bitSize();
        this.bitSet = bitSet;
    }

    public void addHash(long hash64) {
        int hash1 = (int)hash64;
        int hash2 = (int)(hash64 >>> 32);
        for (int i = 1; i <= this.numHashFunctions; ++i) {
            int combinedHash = hash1 + i * hash2;
            if (combinedHash < 0) {
                combinedHash ^= 0xFFFFFFFF;
            }
            int pos = combinedHash % this.numBits;
            this.bitSet.set(pos);
        }
    }

    public boolean testHash(long hash64) {
        int hash1 = (int)hash64;
        int hash2 = (int)(hash64 >>> 32);
        for (int i = 1; i <= this.numHashFunctions; ++i) {
            int pos;
            int combinedHash = hash1 + i * hash2;
            if (combinedHash < 0) {
                combinedHash ^= 0xFFFFFFFF;
            }
            if (this.bitSet.get(pos = combinedHash % this.numBits)) continue;
            return false;
        }
        return true;
    }

    public int getNumHashFunctions() {
        return this.numHashFunctions;
    }

    public BitSet getBitSet() {
        return this.bitSet;
    }

    public static class BitSet {
        private static final byte MAST = 7;
        private final byte[] data;
        private final int offset;

        public BitSet(byte[] data, int offset) {
            assert (data.length > 0) : "data length is zero!";
            assert (offset >= 0) : "offset is negative!";
            this.data = data;
            this.offset = offset;
        }

        public void set(int index) {
            int n = (index >>> 3) + this.offset;
            this.data[n] = (byte)(this.data[n] | (byte)(1 << (index & 7)));
        }

        public boolean get(int index) {
            return (this.data[(index >>> 3) + this.offset] & 1 << (index & 7)) != 0;
        }

        public int bitSize() {
            return (this.data.length - this.offset) * 8;
        }

        public void toByteArray(byte[] bytes, int offset, int length) {
            if (length >= 0) {
                System.arraycopy(this.data, this.offset, bytes, offset, length);
            }
        }
    }
}

