/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.router.webapp;

import com.sun.jersey.api.client.Client;
import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ActivitiesInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppActivitiesInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppAttemptsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppPriority;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppQueue;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppState;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppTimeoutInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppTimeoutsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ApplicationStatisticsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ApplicationSubmissionContextInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.BulkActivitiesInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ClusterInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ClusterMetricsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ClusterUserInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.DelegationToken;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.LabelsToNodesInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodeInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodeLabelsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodeToLabelsEntryList;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodeToLabelsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodesInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.RMQueueAclInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ReservationDeleteRequestInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ReservationSubmissionRequestInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ReservationUpdateRequestInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ResourceInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ResourceOptionInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.SchedulerTypeInfo;
import org.apache.hadoop.yarn.server.router.webapp.AbstractRESTRequestInterceptor;
import org.apache.hadoop.yarn.server.router.webapp.HTTPMethods;
import org.apache.hadoop.yarn.server.router.webapp.RESTRequestInterceptor;
import org.apache.hadoop.yarn.server.router.webapp.RouterWebServiceUtil;
import org.apache.hadoop.yarn.server.webapp.dao.AppAttemptInfo;
import org.apache.hadoop.yarn.server.webapp.dao.ContainerInfo;
import org.apache.hadoop.yarn.server.webapp.dao.ContainersInfo;
import org.apache.hadoop.yarn.webapp.dao.SchedConfUpdateInfo;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;

public class DefaultRequestInterceptorREST
extends AbstractRESTRequestInterceptor {
    private String webAppAddress;
    private SubClusterId subClusterId = null;
    private Client client = null;

    public void setWebAppAddress(String webAppAddress) {
        this.webAppAddress = webAppAddress;
    }

    protected String getWebAppAddress() {
        return this.webAppAddress;
    }

    protected void setSubClusterId(SubClusterId scId) {
        this.subClusterId = scId;
    }

    protected SubClusterId getSubClusterId() {
        return this.subClusterId;
    }

    @Override
    public void init(String user) {
        super.init(user);
        this.webAppAddress = WebAppUtils.getRMWebAppURLWithScheme((Configuration)this.getConf());
        this.client = RouterWebServiceUtil.createJerseyClient(this.getConf());
    }

    public ClusterInfo get() {
        return this.getClusterInfo();
    }

    public ClusterInfo getClusterInfo() {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, null, ClusterInfo.class, HTTPMethods.GET, "/ws/v1/cluster/info", null, null, this.getConf(), this.client);
    }

    public ClusterUserInfo getClusterUserInfo(HttpServletRequest hsr) {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, hsr, ClusterUserInfo.class, HTTPMethods.GET, "/ws/v1/cluster/userinfo", null, null, this.getConf(), this.client);
    }

    public ClusterMetricsInfo getClusterMetricsInfo() {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, null, ClusterMetricsInfo.class, HTTPMethods.GET, "/ws/v1/cluster/metrics", null, null, this.getConf(), this.client);
    }

    public SchedulerTypeInfo getSchedulerInfo() {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, null, SchedulerTypeInfo.class, HTTPMethods.GET, "/ws/v1/cluster/scheduler", null, null, this.getConf(), this.client);
    }

    public String dumpSchedulerLogs(String time, HttpServletRequest hsr) throws IOException {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, null, String.class, HTTPMethods.GET, "/ws/v1/cluster/scheduler/logs", null, null, this.getConf(), this.client);
    }

    public NodesInfo getNodes(String states) {
        HashMap<String, String[]> additionalParam = new HashMap<String, String[]>();
        if (states != null && !states.isEmpty()) {
            additionalParam.put("states", new String[]{states});
        }
        return RouterWebServiceUtil.genericForward(this.webAppAddress, null, NodesInfo.class, HTTPMethods.GET, "/ws/v1/cluster/nodes", null, additionalParam, this.getConf(), this.client);
    }

    public NodeInfo getNode(String nodeId) {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, null, NodeInfo.class, HTTPMethods.GET, "/ws/v1/cluster/nodes/" + nodeId, null, null, this.getConf(), this.client);
    }

    public ResourceInfo updateNodeResource(HttpServletRequest hsr, String nodeId, ResourceOptionInfo resourceOption) {
        String nodePath = "/ws/v1/cluster/nodes/" + nodeId;
        return RouterWebServiceUtil.genericForward(this.webAppAddress, hsr, ResourceInfo.class, HTTPMethods.POST, nodePath + "/resource", resourceOption, null, this.getConf(), this.client);
    }

    public AppsInfo getApps(HttpServletRequest hsr, String stateQuery, Set<String> statesQuery, String finalStatusQuery, String userQuery, String queueQuery, String count, String startedBegin, String startedEnd, String finishBegin, String finishEnd, Set<String> applicationTypes, Set<String> applicationTags, String name, Set<String> unselectedFields) {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, hsr, AppsInfo.class, HTTPMethods.GET, "/ws/v1/cluster/apps", null, null, this.getConf(), this.client);
    }

    public ActivitiesInfo getActivities(HttpServletRequest hsr, String nodeId, String groupBy) {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, hsr, ActivitiesInfo.class, HTTPMethods.GET, "/ws/v1/cluster/scheduler/activities", null, null, this.getConf(), this.client);
    }

    public BulkActivitiesInfo getBulkActivities(HttpServletRequest hsr, String groupBy, int activitiesCount) {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, hsr, BulkActivitiesInfo.class, HTTPMethods.GET, "/ws/v1/cluster/scheduler/bulk-activities", null, null, this.getConf(), this.client);
    }

    public AppActivitiesInfo getAppActivities(HttpServletRequest hsr, String appId, String time, Set<String> requestPriorities, Set<String> allocationRequestIds, String groupBy, String limit, Set<String> actions, boolean summarize) {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, hsr, AppActivitiesInfo.class, HTTPMethods.GET, "/ws/v1/cluster/scheduler/app-activities/{appid}", null, null, this.getConf(), this.client);
    }

    public ApplicationStatisticsInfo getAppStatistics(HttpServletRequest hsr, Set<String> stateQueries, Set<String> typeQueries) {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, hsr, ApplicationStatisticsInfo.class, HTTPMethods.GET, "/ws/v1/cluster/appstatistics", null, null, this.getConf(), this.client);
    }

    public AppInfo getApp(HttpServletRequest hsr, String appId, Set<String> unselectedFields) {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, hsr, AppInfo.class, HTTPMethods.GET, "/ws/v1/cluster/apps/" + appId, null, null, this.getConf(), this.client);
    }

    public AppState getAppState(HttpServletRequest hsr, String appId) throws AuthorizationException {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, hsr, AppState.class, HTTPMethods.GET, "/ws/v1/cluster/apps/" + appId + "/" + "state", null, null, this.getConf(), this.client);
    }

    public Response updateAppState(AppState targetState, HttpServletRequest hsr, String appId) throws AuthorizationException, YarnException, InterruptedException, IOException {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, hsr, Response.class, HTTPMethods.PUT, "/ws/v1/cluster/apps/" + appId + "/" + "state", targetState, null, this.getConf(), this.client);
    }

    public NodeToLabelsInfo getNodeToLabels(HttpServletRequest hsr) throws IOException {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, hsr, NodeToLabelsInfo.class, HTTPMethods.GET, "/ws/v1/cluster/get-node-to-labels", null, null, this.getConf(), this.client);
    }

    public LabelsToNodesInfo getLabelsToNodes(Set<String> labels) throws IOException {
        HashMap<String, String[]> additionalParam = new HashMap<String, String[]>();
        if (labels != null && !labels.isEmpty()) {
            additionalParam.put("labels", labels.toArray(new String[labels.size()]));
        }
        return RouterWebServiceUtil.genericForward(this.webAppAddress, null, LabelsToNodesInfo.class, HTTPMethods.GET, "/ws/v1/cluster/label-mappings", null, additionalParam, this.getConf(), this.client);
    }

    public Response replaceLabelsOnNodes(NodeToLabelsEntryList newNodeToLabels, HttpServletRequest hsr) throws IOException {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, hsr, Response.class, HTTPMethods.POST, "/ws/v1/cluster/replace-node-to-labels", newNodeToLabels, null, this.getConf(), this.client);
    }

    public Response replaceLabelsOnNode(Set<String> newNodeLabelsName, HttpServletRequest hsr, String nodeId) throws Exception {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, hsr, Response.class, HTTPMethods.POST, "/ws/v1/cluster/nodes/" + nodeId + "/replace-labels", null, null, this.getConf(), this.client);
    }

    public NodeLabelsInfo getClusterNodeLabels(HttpServletRequest hsr) throws IOException {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, hsr, NodeLabelsInfo.class, HTTPMethods.GET, "/ws/v1/cluster/get-node-labels", null, null, this.getConf(), this.client);
    }

    public Response addToClusterNodeLabels(NodeLabelsInfo newNodeLabels, HttpServletRequest hsr) throws Exception {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, hsr, Response.class, HTTPMethods.POST, "/ws/v1/cluster/add-node-labels", newNodeLabels, null, this.getConf(), this.client);
    }

    public Response removeFromClusterNodeLabels(Set<String> oldNodeLabels, HttpServletRequest hsr) throws Exception {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, hsr, Response.class, HTTPMethods.POST, "/ws/v1/cluster/remove-node-labels", null, null, this.getConf(), this.client);
    }

    public NodeLabelsInfo getLabelsOnNode(HttpServletRequest hsr, String nodeId) throws IOException {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, hsr, NodeLabelsInfo.class, HTTPMethods.GET, "/ws/v1/cluster/nodes/" + nodeId + "/get-labels", null, null, this.getConf(), this.client);
    }

    public AppPriority getAppPriority(HttpServletRequest hsr, String appId) throws AuthorizationException {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, hsr, AppPriority.class, HTTPMethods.GET, "/ws/v1/cluster/apps/" + appId + "/" + "priority", null, null, this.getConf(), this.client);
    }

    public Response updateApplicationPriority(AppPriority targetPriority, HttpServletRequest hsr, String appId) throws AuthorizationException, YarnException, InterruptedException, IOException {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, hsr, Response.class, HTTPMethods.PUT, "/ws/v1/cluster/apps/" + appId + "/" + "priority", targetPriority, null, this.getConf(), this.client);
    }

    public AppQueue getAppQueue(HttpServletRequest hsr, String appId) throws AuthorizationException {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, hsr, AppQueue.class, HTTPMethods.GET, "/ws/v1/cluster/apps/" + appId + "/" + "queue", null, null, this.getConf(), this.client);
    }

    public Response updateAppQueue(AppQueue targetQueue, HttpServletRequest hsr, String appId) throws AuthorizationException, YarnException, InterruptedException, IOException {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, hsr, Response.class, HTTPMethods.PUT, "/ws/v1/cluster/apps/" + appId + "/" + "queue", targetQueue, null, this.getConf(), this.client);
    }

    public Response createNewApplication(HttpServletRequest hsr) throws AuthorizationException, IOException, InterruptedException {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, hsr, Response.class, HTTPMethods.POST, "/ws/v1/cluster/apps/new-application", null, null, this.getConf(), this.client);
    }

    public Response submitApplication(ApplicationSubmissionContextInfo newApp, HttpServletRequest hsr) throws AuthorizationException, IOException, InterruptedException {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, hsr, Response.class, HTTPMethods.POST, "/ws/v1/cluster/apps", newApp, null, this.getConf(), this.client);
    }

    public Response postDelegationToken(DelegationToken tokenData, HttpServletRequest hsr) throws AuthorizationException, IOException, InterruptedException, Exception {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, hsr, Response.class, HTTPMethods.POST, "/ws/v1/cluster/delegation-token", tokenData, null, this.getConf(), this.client);
    }

    public Response postDelegationTokenExpiration(HttpServletRequest hsr) throws AuthorizationException, IOException, InterruptedException, Exception {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, hsr, Response.class, HTTPMethods.POST, "/ws/v1/cluster/delegation-token/expiration", null, null, this.getConf(), this.client);
    }

    public Response cancelDelegationToken(HttpServletRequest hsr) throws AuthorizationException, IOException, InterruptedException, Exception {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, hsr, Response.class, HTTPMethods.DELETE, "/ws/v1/cluster/delegation-token", null, null, this.getConf(), this.client);
    }

    public Response createNewReservation(HttpServletRequest hsr) throws AuthorizationException, IOException, InterruptedException {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, hsr, Response.class, HTTPMethods.POST, "/ws/v1/cluster/reservation/new-reservation", null, null, this.getConf(), this.client);
    }

    public Response submitReservation(ReservationSubmissionRequestInfo resContext, HttpServletRequest hsr) throws AuthorizationException, IOException, InterruptedException {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, hsr, Response.class, HTTPMethods.POST, "/ws/v1/cluster/reservation/submit", resContext, null, this.getConf(), this.client);
    }

    public Response updateReservation(ReservationUpdateRequestInfo resContext, HttpServletRequest hsr) throws AuthorizationException, IOException, InterruptedException {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, hsr, Response.class, HTTPMethods.POST, "/ws/v1/cluster/reservation/update", resContext, null, this.getConf(), this.client);
    }

    public Response deleteReservation(ReservationDeleteRequestInfo resContext, HttpServletRequest hsr) throws AuthorizationException, IOException, InterruptedException {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, hsr, Response.class, HTTPMethods.POST, "/ws/v1/cluster/reservation/delete", resContext, null, this.getConf(), this.client);
    }

    public Response listReservation(String queue, String reservationId, long startTime, long endTime, boolean includeResourceAllocations, HttpServletRequest hsr) throws Exception {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, hsr, Response.class, HTTPMethods.GET, "/ws/v1/cluster/reservation/list", null, null, this.getConf(), this.client);
    }

    public AppTimeoutInfo getAppTimeout(HttpServletRequest hsr, String appId, String type) throws AuthorizationException {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, hsr, AppTimeoutInfo.class, HTTPMethods.GET, "/ws/v1/cluster/apps/" + appId + "/" + "timeouts" + "/" + type, null, null, this.getConf(), this.client);
    }

    public AppTimeoutsInfo getAppTimeouts(HttpServletRequest hsr, String appId) throws AuthorizationException {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, hsr, AppTimeoutsInfo.class, HTTPMethods.GET, "/ws/v1/cluster/apps/" + appId + "/" + "timeouts", null, null, this.getConf(), this.client);
    }

    public Response updateApplicationTimeout(AppTimeoutInfo appTimeout, HttpServletRequest hsr, String appId) throws AuthorizationException, YarnException, InterruptedException, IOException {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, hsr, Response.class, HTTPMethods.PUT, "/ws/v1/cluster/apps/" + appId + "/" + "timeout", appTimeout, null, this.getConf(), this.client);
    }

    public AppAttemptsInfo getAppAttempts(HttpServletRequest hsr, String appId) {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, hsr, AppAttemptsInfo.class, HTTPMethods.GET, "/ws/v1/cluster/apps/" + appId + "/" + "appattempts", null, null, this.getConf(), this.client);
    }

    public RMQueueAclInfo checkUserAccessToQueue(String queue, String username, String queueAclType, HttpServletRequest hsr) throws AuthorizationException {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, hsr, RMQueueAclInfo.class, HTTPMethods.GET, "/ws/v1/cluster/queues/" + queue + "/access", null, null, this.getConf(), this.client);
    }

    @Override
    public AppAttemptInfo getAppAttempt(HttpServletRequest req, HttpServletResponse res, String appId, String appAttemptId) {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, req, AppAttemptInfo.class, HTTPMethods.GET, "/ws/v1/cluster/apps/" + appId + "/" + "appattempts" + "/" + appAttemptId, null, null, this.getConf(), this.client);
    }

    @Override
    public ContainersInfo getContainers(HttpServletRequest req, HttpServletResponse res, String appId, String appAttemptId) {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, req, ContainersInfo.class, HTTPMethods.GET, "/ws/v1/cluster/apps/" + appId + "/" + "appattempts" + "/" + appAttemptId + "/" + "containers", null, null, this.getConf(), this.client);
    }

    @Override
    public ContainerInfo getContainer(HttpServletRequest req, HttpServletResponse res, String appId, String appAttemptId, String containerId) {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, req, ContainerInfo.class, HTTPMethods.GET, "/ws/v1/cluster/apps/" + appId + "/" + "appattempts" + "/" + appAttemptId + "/" + "containers" + "/" + containerId, null, null, this.getConf(), this.client);
    }

    public Response updateSchedulerConfiguration(SchedConfUpdateInfo mutationInfo, HttpServletRequest req) throws AuthorizationException, InterruptedException {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, req, Response.class, HTTPMethods.PUT, "/ws/v1/cluster/scheduler-conf", mutationInfo, null, this.getConf(), this.client);
    }

    public Response getSchedulerConfiguration(HttpServletRequest req) throws AuthorizationException {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, req, Response.class, HTTPMethods.GET, "/ws/v1/cluster/scheduler-conf", null, null, this.getConf(), this.client);
    }

    @Override
    public void setNextInterceptor(RESTRequestInterceptor next) {
        throw new YarnRuntimeException("setNextInterceptor is being called on DefaultRequestInterceptorREST, which should be the last one in the chain. Check if the interceptor pipeline configuration is correct");
    }

    public Response signalToContainer(String containerId, String command, HttpServletRequest req) throws AuthorizationException {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, req, Response.class, HTTPMethods.POST, "/ws/v1/cluster/containers/" + containerId + "/" + "signal" + "/" + command, null, null, this.getConf(), this.client);
    }

    @VisibleForTesting
    public Client getClient() {
        return this.client;
    }

    public NodeLabelsInfo getRMNodeLabels(HttpServletRequest hsr) {
        return RouterWebServiceUtil.genericForward(this.webAppAddress, hsr, NodeLabelsInfo.class, HTTPMethods.GET, "/ws/v1/cluster/get-rm-node-labels", null, null, this.getConf(), this.client);
    }
}

