/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.metrics;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableGaugeInt;
import org.apache.hadoop.metrics2.lib.MutableQuantiles;

@InterfaceAudience.Private
@Metrics(context="yarn")
public class OpportunisticSchedulerMetrics {
    private static AtomicBoolean isInitialized = new AtomicBoolean(false);
    private static final MetricsInfo RECORD_INFO = Interns.info((String)"OpportunisticSchedulerMetrics", (String)"Metrics for the Yarn Opportunistic Scheduler");
    private static volatile OpportunisticSchedulerMetrics INSTANCE = null;
    private static MetricsRegistry registry;
    @Metric(value={"# of allocated opportunistic containers"})
    MutableGaugeInt allocatedOContainers;
    @Metric(value={"Aggregate # of allocated opportunistic containers"})
    MutableCounterLong aggregateOContainersAllocated;
    @Metric(value={"Aggregate # of released opportunistic containers"})
    MutableCounterLong aggregateOContainersReleased;
    @Metric(value={"Aggregate # of allocated node-local opportunistic containers"})
    MutableCounterLong aggregateNodeLocalOContainersAllocated;
    @Metric(value={"Aggregate # of allocated rack-local opportunistic containers"})
    MutableCounterLong aggregateRackLocalOContainersAllocated;
    @Metric(value={"Aggregate # of allocated off-switch opportunistic containers"})
    MutableCounterLong aggregateOffSwitchOContainersAllocated;
    @Metric(value={"Aggregate latency for opportunistic container allocation"})
    MutableQuantiles allocateLatencyOQuantiles;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OpportunisticSchedulerMetrics getMetrics() {
        if (isInitialized.get()) return INSTANCE;
        Class<OpportunisticSchedulerMetrics> clazz = OpportunisticSchedulerMetrics.class;
        synchronized (OpportunisticSchedulerMetrics.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new OpportunisticSchedulerMetrics();
            OpportunisticSchedulerMetrics.registerMetrics();
            isInitialized.set(true);
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public static void resetMetrics() {
        Class<OpportunisticSchedulerMetrics> clazz = OpportunisticSchedulerMetrics.class;
        synchronized (OpportunisticSchedulerMetrics.class) {
            isInitialized.set(false);
            INSTANCE = null;
            MetricsSystem ms = DefaultMetricsSystem.instance();
            if (ms != null) {
                ms.unregisterSource("OpportunisticSchedulerMetrics");
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static void registerMetrics() {
        registry = new MetricsRegistry(RECORD_INFO);
        registry.tag(RECORD_INFO, "ResourceManager");
        MetricsSystem ms = DefaultMetricsSystem.instance();
        if (ms != null) {
            ms.register("OpportunisticSchedulerMetrics", "Metrics for the Yarn Opportunistic Scheduler", (Object)INSTANCE);
        }
    }

    @VisibleForTesting
    public int getAllocatedContainers() {
        return this.allocatedOContainers.value();
    }

    @VisibleForTesting
    public long getAggregatedAllocatedContainers() {
        return this.aggregateOContainersAllocated.value();
    }

    @VisibleForTesting
    public long getAggregatedReleasedContainers() {
        return this.aggregateOContainersReleased.value();
    }

    @VisibleForTesting
    public long getAggregatedNodeLocalContainers() {
        return this.aggregateNodeLocalOContainersAllocated.value();
    }

    @VisibleForTesting
    public long getAggregatedRackLocalContainers() {
        return this.aggregateRackLocalOContainersAllocated.value();
    }

    @VisibleForTesting
    public long getAggregatedOffSwitchContainers() {
        return this.aggregateOffSwitchOContainersAllocated.value();
    }

    public void incrAllocatedOppContainers(int numContainers) {
        this.allocatedOContainers.incr(numContainers);
        this.aggregateOContainersAllocated.incr((long)numContainers);
    }

    public void incrReleasedOppContainers(int numContainers) {
        this.aggregateOContainersReleased.incr((long)numContainers);
        this.allocatedOContainers.decr(numContainers);
    }

    public void incrNodeLocalOppContainers() {
        this.aggregateNodeLocalOContainersAllocated.incr();
    }

    public void incrRackLocalOppContainers() {
        this.aggregateRackLocalOContainersAllocated.incr();
    }

    public void incrOffSwitchOppContainers() {
        this.aggregateOffSwitchOContainersAllocated.incr();
    }

    public void addAllocateOLatencyEntry(long latency) {
        this.allocateLatencyOQuantiles.add(latency);
    }
}

