/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.kdc;

import java.net.InetAddress;
import org.apache.directory.server.kerberos.KerberosConfig;
import org.apache.directory.server.kerberos.shared.crypto.encryption.CipherTextHandler;
import org.apache.directory.server.kerberos.shared.replay.ReplayCache;
import org.apache.directory.server.kerberos.shared.store.PrincipalStore;
import org.apache.directory.shared.kerberos.codec.types.EncryptionType;
import org.apache.directory.shared.kerberos.components.KdcReq;
import org.apache.directory.shared.kerberos.messages.KerberosMessage;

public abstract class KdcContext {
    private static final long serialVersionUID = 6490030984626825108L;
    private KerberosConfig config;
    private PrincipalStore store;
    private KdcReq request;
    private KerberosMessage reply;
    private InetAddress clientAddress;
    private CipherTextHandler cipherTextHandler;
    private EncryptionType encryptionType;
    private ReplayCache replayCache;

    public KerberosConfig getConfig() {
        return this.config;
    }

    public void setConfig(KerberosConfig config) {
        this.config = config;
    }

    public PrincipalStore getStore() {
        return this.store;
    }

    public void setStore(PrincipalStore store) {
        this.store = store;
    }

    public KdcReq getRequest() {
        return this.request;
    }

    public void setRequest(KdcReq request) {
        this.request = request;
    }

    public KerberosMessage getReply() {
        return this.reply;
    }

    public void setReply(KerberosMessage reply) {
        this.reply = reply;
    }

    public InetAddress getClientAddress() {
        return this.clientAddress;
    }

    public void setClientAddress(InetAddress clientAddress) {
        this.clientAddress = clientAddress;
    }

    public CipherTextHandler getCipherTextHandler() {
        return this.cipherTextHandler;
    }

    public void setCipherTextHandler(CipherTextHandler cipherTextHandler) {
        this.cipherTextHandler = cipherTextHandler;
    }

    public EncryptionType getEncryptionType() {
        return this.encryptionType;
    }

    public void setEncryptionType(EncryptionType encryptionType) {
        this.encryptionType = encryptionType;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Req : ").append(this.request.toString("    "));
        sb.append("Client address : ").append(this.clientAddress);
        if (this.encryptionType != null) {
            sb.append('\n');
            sb.append("EncryptionType : ").append(this.encryptionType);
        }
        return sb.toString();
    }

    public void setReplayCache(ReplayCache replayCache) {
        this.replayCache = replayCache;
    }

    public ReplayCache getReplayCache() {
        return this.replayCache;
    }
}

