/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.normalizers;

import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.schema.Normalizer;
import org.apache.directory.api.ldap.model.schema.SchemaManager;

public class CachingNormalizer
extends Normalizer {
    public static final int CACHE_MAX = 250;
    protected final Normalizer normalizer;

    public CachingNormalizer(Normalizer normalizer) {
        this(normalizer, 250);
    }

    public CachingNormalizer(Normalizer normalizer, int cacheSz) {
        super(normalizer.getOid());
        this.normalizer = normalizer;
    }

    @Override
    public String getOid() {
        return this.normalizer.getOid();
    }

    @Override
    public void setOid(String oid) {
        super.setOid(oid);
        this.normalizer.setOid(oid);
    }

    @Override
    public Value<?> normalize(Value<?> value) throws LdapException {
        if (value == null) {
            return null;
        }
        Value<?> normalized = this.normalizer.normalize(value);
        return normalized;
    }

    @Override
    public String normalize(String value) throws LdapException {
        if (value == null) {
            return null;
        }
        String normalized = this.normalizer.normalize(value);
        return normalized;
    }

    @Override
    public void setSchemaManager(SchemaManager schemaManager) {
        this.normalizer.setSchemaManager(schemaManager);
    }
}

