/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.checker;

import java.nio.channels.ClosedChannelException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.server.datanode.checker.DatasetVolumeChecker;
import org.apache.hadoop.hdfs.server.datanode.checker.TestDatasetVolumeChecker;
import org.apache.hadoop.hdfs.server.datanode.checker.VolumeCheckResult;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeReference;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.util.FakeTimer;
import org.apache.hadoop.util.Timer;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDatasetVolumeCheckerFailures {
    public static final Logger LOG = LoggerFactory.getLogger(TestDatasetVolumeCheckerFailures.class);
    private FakeTimer timer;
    private Configuration conf;
    private static final long MIN_DISK_CHECK_GAP_MS = 1000L;

    @Before
    public void commonInit() {
        this.timer = new FakeTimer();
        this.conf = new HdfsConfiguration();
        this.conf.setTimeDuration("dfs.datanode.disk.check.min.gap", 1000L, TimeUnit.MILLISECONDS);
    }

    @Test(timeout=60000L)
    public void testTimeout() throws Exception {
        List<FsVolumeSpi> volumes = Collections.singletonList(TestDatasetVolumeCheckerFailures.makeHungVolume());
        FsDatasetSpi<FsVolumeSpi> dataset = TestDatasetVolumeChecker.makeDataset(volumes);
        this.conf.setTimeDuration("dfs.datanode.disk.check.timeout", 1L, TimeUnit.SECONDS);
        DatasetVolumeChecker checker = new DatasetVolumeChecker(this.conf, (Timer)new FakeTimer());
        Set failedVolumes = checker.checkAllVolumes(dataset);
        Assert.assertThat((Object)failedVolumes.size(), (Matcher)Is.is((Object)1));
    }

    @Test(timeout=60000L)
    public void testCheckingClosedVolume() throws Exception {
        List<FsVolumeSpi> volumes = Collections.singletonList(TestDatasetVolumeCheckerFailures.makeClosedVolume());
        FsDatasetSpi<FsVolumeSpi> dataset = TestDatasetVolumeChecker.makeDataset(volumes);
        DatasetVolumeChecker checker = new DatasetVolumeChecker(this.conf, (Timer)this.timer);
        Set failedVolumes = checker.checkAllVolumes(dataset);
        Assert.assertThat((Object)failedVolumes.size(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)checker.getNumSyncDatasetChecks(), (Matcher)Is.is((Object)0L));
        ((FsVolumeSpi)Mockito.verify((Object)volumes.get(0), (VerificationMode)Mockito.times((int)0))).check(Mockito.any(FsVolumeSpi.VolumeCheckContext.class));
    }

    @Test(timeout=60000L)
    public void testMinGapIsEnforcedForSyncChecks() throws Exception {
        List<FsVolumeSpi> volumes = TestDatasetVolumeChecker.makeVolumes(1, VolumeCheckResult.HEALTHY);
        FsDatasetSpi<FsVolumeSpi> dataset = TestDatasetVolumeChecker.makeDataset(volumes);
        DatasetVolumeChecker checker = new DatasetVolumeChecker(this.conf, (Timer)this.timer);
        checker.checkAllVolumes(dataset);
        Assert.assertThat((Object)checker.getNumSyncDatasetChecks(), (Matcher)Is.is((Object)1L));
        checker.checkAllVolumes(dataset);
        Assert.assertThat((Object)checker.getNumSyncDatasetChecks(), (Matcher)Is.is((Object)1L));
        Assert.assertThat((Object)checker.getNumSkippedChecks(), (Matcher)Is.is((Object)1L));
        this.timer.advance(1000L);
        checker.checkAllVolumes(dataset);
        Assert.assertThat((Object)checker.getNumSyncDatasetChecks(), (Matcher)Is.is((Object)2L));
        Assert.assertThat((Object)checker.getNumSkippedChecks(), (Matcher)Is.is((Object)1L));
    }

    private static FsVolumeSpi makeHungVolume() throws Exception {
        FsVolumeSpi volume = (FsVolumeSpi)Mockito.mock(FsVolumeSpi.class);
        FsVolumeReference reference = (FsVolumeReference)Mockito.mock(FsVolumeReference.class);
        Mockito.when((Object)reference.getVolume()).thenReturn((Object)volume);
        Mockito.when((Object)volume.obtainReference()).thenReturn((Object)reference);
        Mockito.when((Object)volume.check(Mockito.any(FsVolumeSpi.VolumeCheckContext.class))).thenAnswer((Answer)new Answer<VolumeCheckResult>(){

            public VolumeCheckResult answer(InvocationOnMock invocation) throws Throwable {
                Thread.sleep(Long.MAX_VALUE);
                return VolumeCheckResult.HEALTHY;
            }
        });
        return volume;
    }

    private static FsVolumeSpi makeClosedVolume() throws Exception {
        FsVolumeSpi volume = (FsVolumeSpi)Mockito.mock(FsVolumeSpi.class);
        Mockito.when((Object)volume.obtainReference()).thenThrow(new Throwable[]{new ClosedChannelException()});
        return volume;
    }
}

