/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.changelog;

import java.util.List;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapUnwillingToPerformException;
import org.apache.directory.api.ldap.model.ldif.LdifEntry;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.LdapPrincipal;
import org.apache.directory.server.core.api.changelog.ChangeLog;
import org.apache.directory.server.core.api.changelog.ChangeLogEvent;
import org.apache.directory.server.core.api.changelog.ChangeLogSearchEngine;
import org.apache.directory.server.core.api.changelog.ChangeLogStore;
import org.apache.directory.server.core.api.changelog.SearchableChangeLogStore;
import org.apache.directory.server.core.api.changelog.Tag;
import org.apache.directory.server.core.api.changelog.TagSearchEngine;
import org.apache.directory.server.core.api.changelog.TaggableChangeLogStore;
import org.apache.directory.server.core.api.changelog.TaggableSearchableChangeLogStore;
import org.apache.directory.server.core.api.partition.Partition;
import org.apache.directory.server.core.changelog.MemoryChangeLogStore;
import org.apache.directory.server.i18n.I18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultChangeLog
implements ChangeLog {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultChangeLog.class);
    private boolean enabled;
    private Tag latest;
    private ChangeLogStore store;
    private volatile boolean storeInitialized = false;
    private boolean exposed;
    private static final String DEFAULT_PARTITION_SUFFIX = "ou=changelog";
    private static final String DEFAULT_REV_CONTAINER_NAME = "ou=revisions";
    private static final String DEFAULT_TAG_CONTAINER_NAME = "ou=tags";
    private String partitionSuffix = "ou=changelog";
    private String revContainerName = "ou=revisions";
    private String tagContainerName = "ou=tags";

    public ChangeLogStore getChangeLogStore() {
        return this.store;
    }

    public void setChangeLogStore(ChangeLogStore store) {
        if (this.storeInitialized) {
            LOG.error(I18n.err((I18n)I18n.ERR_29, (Object[])new Object[0]));
        } else {
            this.store = store;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCurrentRevision() throws LdapException {
        ChangeLogStore changeLogStore = this.store;
        synchronized (changeLogStore) {
            return this.store.getCurrentRevision();
        }
    }

    public ChangeLogEvent log(LdapPrincipal principal, LdifEntry forward, LdifEntry reverse) throws LdapException {
        if (!this.enabled) {
            throw new IllegalStateException(I18n.err((I18n)I18n.ERR_236, (Object[])new Object[0]));
        }
        try {
            ChangeLogEvent event = this.store.log(principal, forward, reverse);
            return event;
        }
        catch (Exception e) {
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, e.getMessage(), (Throwable)e);
        }
    }

    public ChangeLogEvent log(LdapPrincipal principal, LdifEntry forward, List<LdifEntry> reverses) throws LdapException {
        if (!this.enabled) {
            throw new IllegalStateException(I18n.err((I18n)I18n.ERR_236, (Object[])new Object[0]));
        }
        try {
            return this.store.log(principal, forward, reverses);
        }
        catch (Exception e) {
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, e.getMessage(), (Throwable)e);
        }
    }

    public boolean isLogSearchSupported() {
        return this.store instanceof SearchableChangeLogStore;
    }

    public boolean isTagSearchSupported() {
        return this.store instanceof TaggableSearchableChangeLogStore;
    }

    public boolean isTagStorageSupported() {
        return this.store instanceof TaggableChangeLogStore;
    }

    public ChangeLogSearchEngine getChangeLogSearchEngine() {
        if (this.isLogSearchSupported()) {
            return ((SearchableChangeLogStore)this.store).getChangeLogSearchEngine();
        }
        throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_237, (Object[])new Object[0]));
    }

    public TagSearchEngine getTagSearchEngine() {
        if (this.isTagSearchSupported()) {
            return ((TaggableSearchableChangeLogStore)this.store).getTagSearchEngine();
        }
        throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_238, (Object[])new Object[0]));
    }

    public Tag tag(long revision, String description) throws Exception {
        if (revision < 0L) {
            throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_239, (Object[])new Object[0]));
        }
        if (revision > this.store.getCurrentRevision()) {
            throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_240, (Object[])new Object[0]));
        }
        if (this.store instanceof TaggableChangeLogStore) {
            this.latest = ((TaggableChangeLogStore)this.store).tag(revision);
            return this.latest;
        }
        this.latest = new Tag(revision, description);
        return this.latest;
    }

    public Tag tag(long revision) throws Exception {
        return this.tag(revision, null);
    }

    public Tag tag(String description) throws Exception {
        return this.tag(this.store.getCurrentRevision(), description);
    }

    public Tag tag() throws Exception {
        return this.tag(this.store.getCurrentRevision(), null);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Tag getLatest() throws LdapException {
        if (this.latest != null) {
            return this.latest;
        }
        if (this.store instanceof TaggableChangeLogStore) {
            this.latest = ((TaggableChangeLogStore)this.store).getLatest();
            return this.latest;
        }
        return null;
    }

    public void init(DirectoryService service) throws Exception {
        if (this.enabled) {
            if (this.store == null) {
                this.store = new MemoryChangeLogStore();
            }
            this.store.init(service);
            if (this.exposed && this.isTagSearchSupported()) {
                TaggableSearchableChangeLogStore tmp = (TaggableSearchableChangeLogStore)this.store;
                tmp.createPartition(this.partitionSuffix, this.revContainerName, this.tagContainerName);
                Partition partition = tmp.getPartition();
                partition.initialize();
                service.addPartition(partition);
            }
        }
        this.storeInitialized = true;
    }

    public void sync() throws Exception {
        if (this.enabled) {
            this.store.sync();
        }
    }

    public void destroy() throws Exception {
        if (this.enabled) {
            this.store.destroy();
        }
        this.storeInitialized = false;
    }

    public boolean isExposed() {
        return this.exposed;
    }

    public void setExposed(boolean exposed) {
        this.exposed = exposed;
    }

    public void setPartitionSuffix(String suffix) {
        this.partitionSuffix = suffix;
    }

    public void setRevisionsContainerName(String revContainerName) {
        this.revContainerName = revContainerName;
    }

    public void setTagsContainerName(String tagContainerName) {
        this.tagContainerName = tagContainerName;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ChangeLog tag[").append(this.latest).append("]\n");
        sb.append("    store : \n").append(this.store);
        return sb.toString();
    }
}

