/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import java.io.IOException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.chaos.actions.TCCommandAction;
import org.apache.hadoop.hbase.chaos.monkies.PolicyBasedChaosMonkey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuplicatePacketsCommandAction
extends TCCommandAction {
    private static final Logger LOG = LoggerFactory.getLogger(DuplicatePacketsCommandAction.class);
    private final float ratio;
    private final long duration;

    public DuplicatePacketsCommandAction(float ratio, long duration, long timeout, String network) {
        super(timeout, network);
        this.ratio = ratio;
        this.duration = duration;
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void localPerform() throws IOException {
        this.getLogger().info("Starting to execute DuplicatePacketsCommandAction");
        ServerName server = PolicyBasedChaosMonkey.selectRandomItem(this.getCurrentServers());
        String hostname = server.getHostname();
        try {
            this.clusterManager.execSudoWithRetries(hostname, this.timeout, this.getCommand("add"));
            Thread.sleep(this.duration);
        }
        catch (InterruptedException e) {
            try {
                this.getLogger().debug("Failed to run the command for the full duration", (Throwable)e);
            }
            catch (Throwable throwable) {
                this.clusterManager.execSudoWithRetries(hostname, this.timeout, this.getCommand("del"));
                throw throwable;
            }
            this.clusterManager.execSudoWithRetries(hostname, this.timeout, this.getCommand("del"));
        }
        this.clusterManager.execSudoWithRetries(hostname, this.timeout, this.getCommand("del"));
        this.getLogger().info("Finished to execute DuplicatePacketsCommandAction");
    }

    private String getCommand(String operation) {
        return String.format("tc qdisc %s dev %s root netem duplicate %s%%", operation, this.network, Float.valueOf(this.ratio * 100.0f));
    }
}

