/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.tmpl.regionserver;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl;
import org.apache.hadoop.hbase.tmpl.regionserver.BlockCacheTmpl;
import org.apache.hadoop.hbase.tmpl.regionserver.BlockCacheViewTmpl;
import org.apache.hadoop.hbase.tmpl.regionserver.RSStatusTmpl;
import org.apache.hadoop.hbase.tmpl.regionserver.RegionListTmpl;
import org.apache.hadoop.hbase.tmpl.regionserver.ReplicationStatusTmpl;
import org.apache.hadoop.hbase.tmpl.regionserver.ServerMetricsTmpl;
import org.apache.hadoop.hbase.util.JvmVersion;
import org.apache.hadoop.hbase.util.VersionInfo;
import org.apache.hadoop.hbase.zookeeper.MasterAddressTracker;
import org.apache.zookeeper.Version;
import org.jamon.AbstractTemplateImpl;
import org.jamon.AbstractTemplateProxy;
import org.jamon.TemplateManager;
import org.jamon.emit.StandardEmitter;
import org.jamon.escaping.Escaping;

public class RSStatusTmplImpl
extends AbstractTemplateImpl
implements RSStatusTmpl.Intf {
    private final HRegionServer regionServer;
    private final String bcn;
    private final String bcv;
    private final String filter;
    private final String format;

    public String formatZKString() {
        StringBuilder quorums = new StringBuilder();
        String zkQuorum = this.regionServer.getZooKeeper().getQuorum();
        if (null == zkQuorum) {
            return quorums.toString();
        }
        String[] zks = zkQuorum.split(",");
        if (zks.length == 0) {
            return quorums.toString();
        }
        for (int i = 0; i < zks.length; ++i) {
            quorums.append(zks[i].trim());
            if (i == zks.length - 1) continue;
            quorums.append("<br/>");
        }
        return quorums.toString();
    }

    protected static RSStatusTmpl.ImplData __jamon_setOptionalArguments(RSStatusTmpl.ImplData p_implData) {
        if (!p_implData.getBcn__IsNotDefault()) {
            p_implData.setBcn("");
        }
        if (!p_implData.getBcv__IsNotDefault()) {
            p_implData.setBcv("");
        }
        if (!p_implData.getFilter__IsNotDefault()) {
            p_implData.setFilter("general");
        }
        if (!p_implData.getFormat__IsNotDefault()) {
            p_implData.setFormat("html");
        }
        return p_implData;
    }

    public RSStatusTmplImpl(TemplateManager p_templateManager, RSStatusTmpl.ImplData p_implData) {
        super(p_templateManager, (AbstractTemplateProxy.ImplData)RSStatusTmplImpl.__jamon_setOptionalArguments(p_implData));
        this.regionServer = p_implData.getRegionServer();
        this.bcn = p_implData.getBcn();
        this.bcv = p_implData.getBcv();
        this.filter = p_implData.getFilter();
        this.format = p_implData.getFormat();
    }

    @Override
    public void renderNoFlush(Writer jamonWriter) throws IOException {
        if (this.format.equals("json") && this.bcn != null && this.bcn.length() > 0) {
            jamonWriter.write("\n  ");
            BlockCacheViewTmpl __jamon__var_0 = new BlockCacheViewTmpl(this.getTemplateManager());
            __jamon__var_0.renderNoFlush(jamonWriter, new CacheConfig(this.regionServer.getConfiguration()), this.regionServer.getConfiguration(), this.bcn, this.bcv, this.regionServer.getBlockCache().orElse(null));
            jamonWriter.write("\n  ");
            return;
        }
        if (this.format.equals("json")) {
            jamonWriter.write("\n  ");
            TaskMonitorTmpl __jamon__var_1 = new TaskMonitorTmpl(this.getTemplateManager());
            __jamon__var_1.setFilter(this.filter);
            __jamon__var_1.setFormat("json");
            __jamon__var_1.renderNoFlush(jamonWriter);
            jamonWriter.write("\n  ");
            return;
        }
        jamonWriter.write("\n");
        AdminProtos.ServerInfo serverInfo = ProtobufUtil.getServerInfo(null, (AdminProtos.AdminService.BlockingInterface)this.regionServer.getRSRpcServices());
        ServerName serverName = ProtobufUtil.toServerName((HBaseProtos.ServerName)serverInfo.getServerName());
        List onlineRegions = ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)this.regionServer.getRSRpcServices());
        MasterAddressTracker masterAddressTracker = this.regionServer.getMasterAddressTracker();
        ServerName masterServerName = masterAddressTracker == null ? null : masterAddressTracker.getMasterAddress();
        int infoPort = masterAddressTracker == null ? 0 : masterAddressTracker.getMasterInfoPort();
        jamonWriter.write("<!DOCTYPE html>\n<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<html lang=\"en\">\n  <head>\n    <meta charset=\"utf-8\">\n    <title>HBase Region Server: ");
        Escaping.NONE.write(StandardEmitter.valueOf((String)serverName.getHostname()), jamonWriter);
        jamonWriter.write("</title>\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n    <meta name=\"description\" content=\"\">\n\n    <link href=\"/static/css/bootstrap.min.css\" rel=\"stylesheet\">\n    <link href=\"/static/css/hbase.css\" rel=\"stylesheet\">\n    <link rel=\"shortcut icon\" href=\"/static/favicon.ico\">\n  </head>\n\n  <body>\n\n    <nav class=\"navbar navbar-expand-md navbar-light fixed-top bg-light\">\n      <div class=\"container-fluid\">\n        <a class=\"navbar-brand\" href=\"/rs-status\">\n          <img src=\"/static/hbase_logo_small.png\" alt=\"HBase Logo\"/>\n        </a>\n        <button type=\"button\" class=\"navbar-toggler\" data-bs-toggle=\"collapse\" data-bs-target=\".navbar-collapse\">\n          <span class=\"navbar-toggler-icon\"></span>\n        </button>\n        <div class=\"collapse navbar-collapse\">\n          <ul class=\"navbar-nav\">\n            <li class=\"nav-item\"><a class=\"nav-link active\" href=\"/rs-status\">Home</a></li>\n            <li class=\"nav-item\"><a class=\"nav-link\" href=\"/processRS.jsp\">Process Metrics</a></li>\n            <li class=\"nav-item\"><a class=\"nav-link\" href=\"/logs/\">Local Logs</a></li>\n            <li class=\"nav-item\"><a class=\"nav-link\" href=\"/rsOperationDetails.jsp\">Operation Details</a></li>\n            <li class=\"nav-item\"><a class=\"nav-link\" href=\"/logLevel\">Log Level</a></li>\n            <li class=\"nav-item\"><a class=\"nav-link\" href=\"/dump\">Debug Dump</a></li>\n            <li class=\"nav-item dropdown\">\n              <a class=\"nav-link dropdown-toggle\" href=\"#\" id=\"navbarDropdownMenuLink\" data-bs-toggle=\"dropdown\" aria-haspopup=\"true\" aria-expanded=\"false\">\n                Metrics <span class=\"caret\"></span>\n              </a>\n              <div class=\"dropdown-menu\" aria-labelledby=\"navbarDropdownMenuLink\">\n                <a class=\"dropdown-item\" target=\"_blank\" href=\"/jmx\">JMX</a>\n                <a class=\"dropdown-item\" target=\"_blank\" href=\"/jmx?description=true\">JMX with description</a>\n                <a class=\"dropdown-item\" target=\"_blank\" href=\"/prometheus\">Prometheus</a>\n                <a class=\"dropdown-item\" target=\"_blank\" href=\"/prometheus?description=true\">Prometheus with description</a>\n              </div>\n            </li>\n            <li class=\"nav-item\"><a class=\"nav-link\" href=\"/prof\">Profiler</a></li>\n            ");
        if (HBaseConfiguration.isShowConfInServlet()) {
            jamonWriter.write("\n            <li class=\"nav-item\"><a class=\"nav-link\" href=\"/conf\">HBase Configuration</a></li>\n            ");
        }
        jamonWriter.write("\n          </ul>\n        </div><!--/.navbar-collapse -->\n      </div><!--/.container-fluid -->\n    </nav>\n\n  <div class=\"container-fluid content\">\n    <div class=\"row inner_header\">\n        <div class=\"page-header\">\n            <h1>RegionServer <small>");
        Escaping.NONE.write(StandardEmitter.valueOf((Object)serverName), jamonWriter);
        jamonWriter.write("</small></h1>\n        </div>\n    </div>\n    <div class=\"row\">\n\n    <section>\n    <h2>Server Metrics</h2>\n    ");
        ServerMetricsTmpl __jamon__var_2 = new ServerMetricsTmpl(this.getTemplateManager());
        __jamon__var_2.renderNoFlush(jamonWriter, this.regionServer.getMetrics().getRegionServerWrapper(), this.regionServer.getRpcServer().getMetrics().getHBaseServerWrapper(), this.regionServer.getRpcServer().getByteBuffAllocator());
        jamonWriter.write("\n    </section>\n\n    <section>\n    <h2>Block Cache</h2>\n    ");
        BlockCacheTmpl __jamon__var_3 = new BlockCacheTmpl(this.getTemplateManager());
        __jamon__var_3.renderNoFlush(jamonWriter, new CacheConfig(this.regionServer.getConfiguration()), this.regionServer.getConfiguration(), this.regionServer.getBlockCache().orElse(null));
        jamonWriter.write("\n    </section>\n\n    <section>\n    ");
        TaskMonitorTmpl __jamon__var_4 = new TaskMonitorTmpl(this.getTemplateManager());
        __jamon__var_4.setFilter(this.filter);
        __jamon__var_4.setParent("/rs-status");
        __jamon__var_4.renderNoFlush(jamonWriter);
        jamonWriter.write("\n    </section>\n\n    <section>\n    <h2>Regions</h2>\n    ");
        RegionListTmpl __jamon__var_5 = new RegionListTmpl(this.getTemplateManager());
        __jamon__var_5.renderNoFlush(jamonWriter, this.regionServer, onlineRegions);
        jamonWriter.write("\n    </section>\n\n    <section>\n    <h2>Replication Status</h1>\n    ");
        ReplicationStatusTmpl __jamon__var_6 = new ReplicationStatusTmpl(this.getTemplateManager());
        __jamon__var_6.renderNoFlush(jamonWriter, this.regionServer);
        jamonWriter.write("\n    </section>\n\n    <section>\n    <h2>Software Attributes</h2>\n    <table id=\"attributes_table\" class=\"table table-striped\">\n        <tr>\n            <th>Attribute Name</th>\n            <th>Value</th>\n            <th>Description</th>\n        </tr>\n        <tr>\n            <td>JVM Version</td>\n            <td>");
        Escaping.NONE.write(StandardEmitter.valueOf((String)JvmVersion.getVersion()), jamonWriter);
        jamonWriter.write("</td>\n            <td>JVM vendor and version</td>\n        </tr>\n        <tr>\n            <td>HBase Version</td>\n            <td>");
        Escaping.NONE.write(StandardEmitter.valueOf((String)VersionInfo.getVersion()), jamonWriter);
        jamonWriter.write(", revision=");
        Escaping.NONE.write(StandardEmitter.valueOf((String)VersionInfo.getRevision()), jamonWriter);
        jamonWriter.write("</td>\n            <td>HBase version and revision</td>\n        </tr>\n        <tr>\n            <td>HBase Compiled</td>\n            <td>");
        Escaping.NONE.write(StandardEmitter.valueOf((String)VersionInfo.getDate()), jamonWriter);
        jamonWriter.write(", ");
        Escaping.NONE.write(StandardEmitter.valueOf((String)VersionInfo.getUser()), jamonWriter);
        jamonWriter.write("</td>\n            <td>When HBase version was compiled and by whom</td>\n        </tr>\n        <tr>\n            <td>HBase Source Checksum</td>\n            <td>");
        Escaping.NONE.write(StandardEmitter.valueOf((String)VersionInfo.getSrcChecksum()), jamonWriter);
        jamonWriter.write("</td>\n            <td>HBase source SHA512 checksum</td>\n        </tr>\n        <tr>\n            <td>Hadoop Version</td>\n            <td>");
        Escaping.NONE.write(StandardEmitter.valueOf((String)org.apache.hadoop.util.VersionInfo.getVersion()), jamonWriter);
        jamonWriter.write(", revision=");
        Escaping.NONE.write(StandardEmitter.valueOf((String)org.apache.hadoop.util.VersionInfo.getRevision()), jamonWriter);
        jamonWriter.write("</td>\n            <td>Hadoop version and revision</td>\n        </tr>\n        <tr>\n            <td>Hadoop Compiled</td>\n            <td>");
        Escaping.NONE.write(StandardEmitter.valueOf((String)org.apache.hadoop.util.VersionInfo.getDate()), jamonWriter);
        jamonWriter.write(", ");
        Escaping.NONE.write(StandardEmitter.valueOf((String)org.apache.hadoop.util.VersionInfo.getUser()), jamonWriter);
        jamonWriter.write("</td>\n            <td>When Hadoop version was compiled and by whom</td>\n        </tr>\n        <tr>\n            <td>Hadoop Source Checksum</td>\n            <td>");
        Escaping.NONE.write(StandardEmitter.valueOf((String)org.apache.hadoop.util.VersionInfo.getSrcChecksum()), jamonWriter);
        jamonWriter.write("</td>\n            <td>Hadoop source MD5 checksum</td>\n        </tr>\n        <tr>\n            <td>ZooKeeper Client Version</td>\n            <td>");
        Escaping.NONE.write(StandardEmitter.valueOf((String)Version.getVersion()), jamonWriter);
        jamonWriter.write(", revision=");
        Escaping.NONE.write(StandardEmitter.valueOf((String)Version.getRevisionHash()), jamonWriter);
        jamonWriter.write("</td>\n            <td>ZooKeeper client version and revision hash</td>\n        </tr>\n        <tr>\n            <td>ZooKeeper Client Compiled</td>\n            <td>");
        Escaping.NONE.write(StandardEmitter.valueOf((String)Version.getBuildDate()), jamonWriter);
        jamonWriter.write("</td>\n            <td>When ZooKeeper client version was compiled</td>\n        </tr>\n        <tr>\n            <td>ZooKeeper Quorum</td>\n            <td>");
        Escaping.NONE.write(StandardEmitter.valueOf((String)this.formatZKString()), jamonWriter);
        jamonWriter.write("</td>\n            <td>Addresses of all registered ZK servers</td>\n        </tr>\n        <tr>\n            <td>Coprocessors</td>\n            <td>");
        Escaping.NONE.write(StandardEmitter.valueOf((String)Arrays.toString(this.regionServer.getRegionServerCoprocessors())), jamonWriter);
        jamonWriter.write("</td>\n            <td>Coprocessors currently loaded by this regionserver</td>\n        </tr>\n        <tr>\n            <td>RS Start Time</td>\n            <td>");
        Escaping.NONE.write(StandardEmitter.valueOf((Object)new Date(this.regionServer.getStartcode())), jamonWriter);
        jamonWriter.write("</td>\n            <td>Date stamp of when this region server was started</td>\n        </tr>\n        <tr>\n            <td>HBase Master</td>\n            <td>\n                ");
        if (masterServerName == null) {
            jamonWriter.write("\n                No master found\n                ");
        } else {
            jamonWriter.write("\n                ");
            String host = masterServerName.getHostname() + ":" + infoPort;
            String url = "//" + host + "/master-status";
            jamonWriter.write("<a href=\"");
            Escaping.NONE.write(StandardEmitter.valueOf((String)url), jamonWriter);
            jamonWriter.write("\">");
            Escaping.NONE.write(StandardEmitter.valueOf((String)host), jamonWriter);
            jamonWriter.write("</a>\n                ");
        }
        jamonWriter.write("\n            </td>\n            <td>Address of HBase Master</td>\n        </tr>\n    </table>\n    </section>\n    </div>\n</div>\n<script src=\"/static/js/jquery.min.js\" type=\"text/javascript\"></script>\n<script src=\"/static/js/jquery.tablesorter.min.js\" type=\"text/javascript\"></script>\n<script src=\"/static/js/bootstrap.bundle.min.js\" type=\"text/javascript\"></script>\n<script src=\"/static/js/tab.js\" type=\"text/javascript\"></script>\n<script>\n$(document).ready(function()\n    {\n        $.tablesorter.addParser({\n            id: 'filesize',\n            is: function(s) {\n                return s.match(new RegExp( /([\\.0-9]+)\\ (B|KB|MB|GB|TB)/ ));\n            },\n            format: function(s) {\n                var suf = s.match(new RegExp( /(KB|B|GB|MB|TB)$/ ))[1];\n                var num = parseFloat(s.match( new RegExp( /([\\.0-9]+)\\ (B|KB|MB|GB|TB)/ ))[0]);\n                switch(suf) {\n                    case 'B':\n                        return num;\n                    case 'KB':\n                        return num * 1024;\n                    case 'MB':\n                        return num * 1024 * 1024;\n                    case 'GB':\n                        return num * 1024 * 1024 * 1024;\n                    case 'TB':\n                        return num * 1024 * 1024 * 1024 * 1024;\n                }\n            },\n            type: 'numeric'\n        });\n        $.tablesorter.addParser(\n        {\n            id: \"separator\",\n            is: function (s) {\n                return /^[0-9]?[0-9,]*$/.test(s);\n            },\n            format: function (s) {\n                return $.tablesorter.formatFloat( s.replace(/,/g,'') );\n            },\n            type: \"numeric\"\n        });\n\n        $(\"#baseStatsTable\").tablesorter({\n            headers: {\n                '.cls_emptyMin': {empty: 'emptyMin'},\n                '.cls_emptyMax': {empty: 'emptyMax'}\n            }\n        });\n        $(\"#requestStatsTable\").tablesorter({\n            headers: {\n                '.cls_separator': {sorter: 'separator'}\n            }\n        });\n        $(\"#storeStatsTable\").tablesorter({\n            headers: {\n                '.cls_separator': {sorter: 'separator'},\n                '.cls_filesize': {sorter: 'filesize'}\n            }\n        });\n        $(\"#compactionStatsTable\").tablesorter({\n            headers: {\n                '.cls_separator': {sorter: 'separator'}\n            }\n        });\n        $(\"#memstoreStatsTable\").tablesorter({\n            headers: {\n                '.cls_filesize': {sorter: 'filesize'}\n            }\n        });\n    }\n);\n</script>\n</body>\n</html>\n");
    }
}

