/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.IOException;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.IncrementalBlockReportManager;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.MetricsAsserts;
import org.apache.hadoop.util.Time;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class TestBatchIbr {
    public static final Logger LOG = LoggerFactory.getLogger(TestBatchIbr.class);
    private static final short NUM_DATANODES = 4;
    private static final int BLOCK_SIZE = 1024;
    private static final int MAX_BLOCK_NUM = 8;
    private static final int NUM_FILES = 1000;
    private static final int NUM_THREADS = 128;
    private static final ThreadLocalBuffer IO_BUF = new ThreadLocalBuffer();
    private static final ThreadLocalBuffer VERIFY_BUF = new ThreadLocalBuffer();

    static HdfsConfiguration newConf(long ibrInterval) throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.namenode.fs-limits.min-block-size", 1024L);
        conf.setBoolean("dfs.client.block.write.replace-datanode-on-failure.best-effort", true);
        if (ibrInterval > 0L) {
            conf.setLong("dfs.blockreport.incremental.intervalMsec", ibrInterval);
        }
        return conf;
    }

    static ExecutorService createExecutor() throws Exception {
        int i;
        ExecutorService executor = Executors.newFixedThreadPool(128);
        ExecutorCompletionService<Path> completion = new ExecutorCompletionService<Path>(executor);
        for (i = 0; i < 128; ++i) {
            completion.submit(new Callable<Path>(){

                @Override
                public Path call() throws Exception {
                    IO_BUF.get();
                    VERIFY_BUF.get();
                    return null;
                }
            });
        }
        for (i = 0; i < 128; ++i) {
            completion.take().get();
        }
        return executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void runIbrTest(long ibrInterval) throws Exception {
        ExecutorService executor = TestBatchIbr.createExecutor();
        final Random ran = new Random();
        HdfsConfiguration conf = TestBatchIbr.newConf(ibrInterval);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(4).build();
        final DistributedFileSystem dfs = cluster.getFileSystem();
        try {
            int i;
            String dirPathString = "/dir";
            final Path dir = new Path("/dir");
            dfs.mkdirs(dir);
            long testStartTime = Time.monotonicNow();
            ExecutorCompletionService<Path> createService = new ExecutorCompletionService<Path>(executor);
            final AtomicLong createFileTime = new AtomicLong();
            final AtomicInteger numBlockCreated = new AtomicInteger();
            for (int i2 = 0; i2 < 1000; ++i2) {
                createService.submit(new Callable<Path>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Path call() throws Exception {
                        long start = Time.monotonicNow();
                        try {
                            long seed = ran.nextLong();
                            int numBlocks = ran.nextInt(8) + 1;
                            numBlockCreated.addAndGet(numBlocks);
                            Path path = TestBatchIbr.createFile(dir, numBlocks, seed, dfs);
                            return path;
                        }
                        finally {
                            createFileTime.addAndGet(Time.monotonicNow() - start);
                        }
                    }
                });
            }
            ExecutorCompletionService<Boolean> verifyService = new ExecutorCompletionService<Boolean>(executor);
            final AtomicLong verifyFileTime = new AtomicLong();
            for (i = 0; i < 1000; ++i) {
                final Path file = (Path)createService.take().get();
                verifyService.submit(new Callable<Boolean>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Boolean call() throws Exception {
                        long start = Time.monotonicNow();
                        try {
                            Boolean bl = TestBatchIbr.verifyFile(file, dfs);
                            return bl;
                        }
                        finally {
                            verifyFileTime.addAndGet(Time.monotonicNow() - start);
                        }
                    }
                });
            }
            for (i = 0; i < 1000; ++i) {
                Assert.assertTrue((boolean)((Boolean)verifyService.take().get()));
            }
            long testEndTime = Time.monotonicNow();
            LOG.info("ibrInterval=" + ibrInterval + " (" + TestBatchIbr.toConfString("dfs.blockreport.incremental.intervalMsec", (Configuration)conf) + "), numBlockCreated=" + numBlockCreated);
            LOG.info("duration=" + TestBatchIbr.toSecondString(testEndTime - testStartTime) + ", createFileTime=" + TestBatchIbr.toSecondString(createFileTime.get()) + ", verifyFileTime=" + TestBatchIbr.toSecondString(verifyFileTime.get()));
            LOG.info("NUM_FILES=1000, MAX_BLOCK_NUM=8, BLOCK_SIZE=1024, NUM_THREADS=128, NUM_DATANODES=4");
            TestBatchIbr.logIbrCounts(cluster.getDataNodes());
        }
        finally {
            executor.shutdown();
            cluster.shutdown();
        }
    }

    static String toConfString(String key, Configuration conf) {
        return key + "=" + conf.get(key);
    }

    static String toSecondString(long ms) {
        return (double)ms / 1000.0 + "s";
    }

    static void logIbrCounts(List<DataNode> datanodes) {
        String name = "IncrementalBlockReportsNumOps";
        for (DataNode dn : datanodes) {
            MetricsRecordBuilder m = MetricsAsserts.getMetrics((String)dn.getMetrics().name());
            long ibr = MetricsAsserts.getLongCounter((String)"IncrementalBlockReportsNumOps", (MetricsRecordBuilder)m);
            LOG.info(dn.getDisplayName() + ": " + "IncrementalBlockReportsNumOps" + "=" + ibr);
        }
    }

    static byte[] nextBytes(int blockIndex, long seed, byte[] bytes) {
        byte b = (byte)(seed ^ seed >> blockIndex);
        for (int i = 0; i < bytes.length; ++i) {
            byte by = b;
            b = (byte)(b + 1);
            bytes[i] = by;
        }
        return bytes;
    }

    static Path createFile(Path dir, int numBlocks, long seed, DistributedFileSystem dfs) throws IOException {
        Path f = new Path(dir, seed + "_" + numBlocks);
        byte[] bytes = (byte[])IO_BUF.get();
        try (FSDataOutputStream out = dfs.create(f);){
            for (int i = 0; i < numBlocks; ++i) {
                out.write(TestBatchIbr.nextBytes(i, seed, bytes));
            }
        }
        return f;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean verifyFile(Path f, DistributedFileSystem dfs) {
        String name = f.getName();
        int i = name.indexOf(95);
        long seed = Long.parseLong(name.substring(0, i));
        int numBlocks = Integer.parseInt(name.substring(i + 1));
        byte[] computed = (byte[])IO_BUF.get();
        byte[] expected = (byte[])VERIFY_BUF.get();
        try (FSDataInputStream in = dfs.open(f);){
            for (int i2 = 0; i2 < numBlocks; ++i2) {
                in.read(computed);
                TestBatchIbr.nextBytes(i2, seed, expected);
                Assert.assertArrayEquals((byte[])expected, (byte[])computed);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOG.error("Failed to verify file " + f);
            return false;
        }
    }

    @Test
    public void testIbr() throws Exception {
        TestBatchIbr.runIbrTest(0L);
        TestBatchIbr.runIbrTest(100L);
    }

    static {
        GenericTestUtils.setLogLevel((Logger)LoggerFactory.getLogger(IncrementalBlockReportManager.class), (Level)Level.TRACE);
    }

    static class ThreadLocalBuffer
    extends ThreadLocal<byte[]> {
        ThreadLocalBuffer() {
        }

        @Override
        protected byte[] initialValue() {
            return new byte[1024];
        }
    }
}

