/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.task;

import org.apache.helix.controller.dataproviders.WorkflowControllerDataProvider;
import org.apache.helix.controller.stages.CurrentStateOutput;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.Resource;
import org.apache.helix.model.ResourceAssignment;
import org.apache.helix.task.JobConfig;
import org.apache.helix.task.JobDispatcher;
import org.apache.helix.task.TaskRebalancer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobRebalancer
extends TaskRebalancer {
    private static final Logger LOG = LoggerFactory.getLogger(JobRebalancer.class);
    private JobDispatcher _jobDispatcher;

    @Override
    public ResourceAssignment computeBestPossiblePartitionState(WorkflowControllerDataProvider clusterData, IdealState taskIs, Resource resource, CurrentStateOutput currStateOutput) {
        long startTime = System.currentTimeMillis();
        String jobName = resource.getResourceName();
        JobConfig jobConfig = clusterData.getJobConfig(jobName);
        if (jobConfig == null) {
            LOG.error("Job {}'s JobConfig is missing. This job might have been deleted or purged. Skipping status update and assignment!", (Object)jobName);
            return this.buildEmptyAssignment(jobName, currStateOutput);
        }
        LOG.debug("Computer Best Partition for job: " + jobName);
        if (this._jobDispatcher == null) {
            this._jobDispatcher = new JobDispatcher();
        }
        this._jobDispatcher.init(this._manager);
        this._jobDispatcher.updateCache(clusterData);
        this._jobDispatcher.setClusterStatusMonitor(this._clusterStatusMonitor);
        ResourceAssignment resourceAssignment = this._jobDispatcher.processJobStatusUpdateAndAssignment(jobName, currStateOutput, clusterData.getWorkflowContext(jobConfig.getWorkflow()));
        LOG.debug(String.format("JobRebalancer computation takes %d ms for Job %s", System.currentTimeMillis() - startTime, jobName));
        return resourceAssignment;
    }
}

