/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.common;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Queue;

public class DedupEventBlockingQueue<T, E> {
    private final Map<T, Entry<T, E>> _eventMap = Maps.newHashMap();
    private final Queue<Entry> _eventQueue = Lists.newLinkedList();

    public synchronized void clear() {
        this._eventMap.clear();
        this._eventQueue.clear();
    }

    public synchronized void put(T type, E event) {
        boolean result;
        Entry<T, E> entry = new Entry<T, E>(type, event);
        if (!this._eventMap.containsKey(entry.getType()) && !(result = this._eventQueue.offer(entry))) {
            return;
        }
        this._eventMap.put(entry.getType(), entry);
        this.notify();
    }

    public synchronized E take() throws InterruptedException {
        while (this._eventQueue.isEmpty()) {
            this.wait();
        }
        Entry<T, E> entry = this._eventQueue.poll();
        if (entry != null) {
            entry = this._eventMap.remove(entry.getType());
            return entry.getEvent();
        }
        return null;
    }

    public synchronized E peek() {
        Entry<T, E> entry = this._eventQueue.peek();
        if (entry != null) {
            entry = this._eventMap.get(entry.getType());
            return entry.getEvent();
        }
        return null;
    }

    public int size() {
        return this._eventQueue.size();
    }

    public boolean isEmpty() {
        return this._eventQueue.isEmpty();
    }

    class Entry<T, E> {
        private T _type;
        private E _event;

        Entry(T type, E event) {
            this._type = type;
            this._event = event;
        }

        T getType() {
            return this._type;
        }

        E getEvent() {
            return this._event;
        }
    }
}

