/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.stages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.helix.HelixException;
import org.apache.helix.controller.LogUtil;
import org.apache.helix.controller.dataproviders.ResourceControllerDataProvider;
import org.apache.helix.controller.pipeline.AbstractBaseStage;
import org.apache.helix.controller.pipeline.StageException;
import org.apache.helix.controller.stages.AttributeName;
import org.apache.helix.controller.stages.ClusterEvent;
import org.apache.helix.controller.stages.CurrentStateOutput;
import org.apache.helix.controller.stages.MessageOutput;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.model.Message;
import org.apache.helix.model.Partition;
import org.apache.helix.model.Resource;
import org.apache.helix.model.StateModelDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageSelectionStage
extends AbstractBaseStage {
    private static final Logger LOG = LoggerFactory.getLogger(MessageSelectionStage.class);

    @Override
    public void process(ClusterEvent event) throws Exception {
        this._eventId = event.getEventId();
        ResourceControllerDataProvider cache = (ResourceControllerDataProvider)event.getAttribute(AttributeName.ControllerDataProvider.name());
        Map resourceMap = (Map)event.getAttribute(AttributeName.RESOURCES.name());
        CurrentStateOutput currentStateOutput = (CurrentStateOutput)event.getAttribute(AttributeName.CURRENT_STATE.name());
        MessageOutput messageGenOutput = (MessageOutput)event.getAttribute(AttributeName.MESSAGES_ALL.name());
        if (cache == null || resourceMap == null || currentStateOutput == null || messageGenOutput == null) {
            throw new StageException("Missing attributes in event:" + event + ". Requires DataCache|RESOURCES|CURRENT_STATE|MESSAGES_ALL");
        }
        MessageOutput output = new MessageOutput();
        for (String resourceName : resourceMap.keySet()) {
            Resource resource = (Resource)resourceMap.get(resourceName);
            try {
                StateModelDefinition stateModelDef = cache.getStateModelDef(resource.getStateModelDefRef());
                Map<String, Integer> stateTransitionPriorities = this.getStateTransitionPriorityMap(stateModelDef);
                IdealState idealState = cache.getIdealState(resourceName);
                Map<String, Bounds> stateConstraints = this.computeStateConstraints(stateModelDef, idealState, cache);
                for (Partition partition : resource.getPartitions()) {
                    List<Message> messages = messageGenOutput.getMessages(resourceName, partition);
                    List<Message> selectedMessages = this.selectMessages(cache.getLiveInstances(), currentStateOutput.getCurrentStateMap(resourceName, partition), currentStateOutput.getPendingMessageMap(resourceName, partition), messages, currentStateOutput.getPendingRelayMessageMap(resourceName, partition).values(), stateConstraints, stateTransitionPriorities, stateModelDef, resource.isP2PMessageEnabled());
                    output.addMessages(resourceName, partition, selectedMessages);
                }
            }
            catch (HelixException ex) {
                LogUtil.logError(LOG, this._eventId, "Failed to finish message selection for resource " + resourceName, ex);
            }
        }
        event.addAttribute(AttributeName.MESSAGES_SELECTED.name(), output);
    }

    private void increaseStateCnt(Map<String, Bounds> stateConstraints, String state, Map<String, Integer> stateCnts) {
        if (!stateConstraints.containsKey(state)) {
            return;
        }
        if (!stateCnts.containsKey(state)) {
            stateCnts.put(state, 0);
        }
        stateCnts.put(state, stateCnts.get(state) + 1);
    }

    List<Message> selectMessages(Map<String, LiveInstance> liveInstances, Map<String, String> currentStates, Map<String, Message> pendingMessages, List<Message> messages, Collection<Message> pendingRelayMessages, Map<String, Bounds> stateConstraints, Map<String, Integer> stateTransitionPriorities, StateModelDefinition stateModelDef, boolean p2pMessageEnabled) {
        if (messages == null || messages.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Message> selectedMessages = new ArrayList<Message>();
        HashMap<String, Integer> stateCnts = new HashMap<String, Integer>();
        String initialState = stateModelDef.getInitialState();
        for (String instance : liveInstances.keySet()) {
            String state = initialState;
            if (currentStates.containsKey(instance)) {
                state = currentStates.get(instance);
            }
            this.increaseStateCnt(stateConstraints, state, stateCnts);
        }
        for (String instance : pendingMessages.keySet()) {
            Message message = pendingMessages.get(instance);
            this.increaseStateCnt(stateConstraints, message.getToState(), stateCnts);
            this.increaseStateCnt(stateConstraints, message.getFromState(), stateCnts);
        }
        TreeMap messagesGroupByStateTransitPriority = new TreeMap();
        LinkedList<Message> fromTopStateMessages = new LinkedList<Message>();
        for (Message message : messages) {
            if (message.getMsgType().equals(Message.MessageType.STATE_TRANSITION_CANCELLATION.name())) {
                selectedMessages.add(message);
                continue;
            }
            String fromState = message.getFromState();
            String toState = message.getToState();
            String transition = fromState + "-" + toState;
            int priority = Integer.MAX_VALUE;
            if (stateTransitionPriorities.containsKey(transition)) {
                priority = stateTransitionPriorities.get(transition);
            }
            if (!messagesGroupByStateTransitPriority.containsKey(priority)) {
                messagesGroupByStateTransitPriority.put(priority, new ArrayList());
            }
            ((List)messagesGroupByStateTransitPriority.get(priority)).add(message);
            if (!fromState.equals(stateModelDef.getTopState())) continue;
            fromTopStateMessages.add(message);
        }
        for (List messageList : messagesGroupByStateTransitPriority.values()) {
            block4: for (Message message : messageList) {
                String toState = message.getToState();
                String fromState = message.getFromState();
                if (toState.equals(stateModelDef.getTopState())) {
                    for (Message relayMsg : pendingRelayMessages) {
                        if (!relayMsg.getToState().equals(toState) || !relayMsg.getFromState().equals(fromState)) continue;
                        LOG.info("There is pending relay message, pending relay message: {}, relay time starts {}, expiry timeout {}.", new Object[]{relayMsg.getMsgId(), relayMsg.getRelayTime(), relayMsg.getExpiryPeriod()});
                        if (relayMsg.getTgtName().equals(message.getTgtName())) continue;
                        LOG.info("The pending relay message was sent to a different host, not send message: {}, pending relay message: {}", (Object)message.getMsgId(), (Object)relayMsg.getId());
                        continue block4;
                    }
                }
                if (stateConstraints.containsKey(toState)) {
                    int newCnt;
                    int n = newCnt = stateCnts.containsKey(toState) ? (Integer)stateCnts.get(toState) + 1 : 1;
                    if (newCnt > stateConstraints.get(toState).getUpperBound()) {
                        if (p2pMessageEnabled && toState.equals(stateModelDef.getTopState()) && stateModelDef.isSingleTopStateModel()) {
                            if (fromTopStateMessages.size() <= 0) continue;
                            Message fromTopStateMsg = (Message)fromTopStateMessages.get(0);
                            fromTopStateMsg.attachRelayMessage(message.getTgtName(), message);
                            fromTopStateMessages.remove(0);
                            continue;
                        }
                        LogUtil.logInfo(LOG, this._eventId, "Reach upper_bound: " + stateConstraints.get(toState).getUpperBound() + ", not send message: " + message);
                        continue;
                    }
                }
                this.increaseStateCnt(stateConstraints, message.getToState(), stateCnts);
                selectedMessages.add(message);
            }
        }
        return selectedMessages;
    }

    private Map<String, Bounds> computeStateConstraints(StateModelDefinition stateModelDefinition, IdealState idealState, ResourceControllerDataProvider cache) {
        HashMap<String, Bounds> stateConstraints = new HashMap<String, Bounds>();
        List<String> statePriorityList = stateModelDefinition.getStatesPriorityList();
        for (String state : statePriorityList) {
            String numInstancesPerState = stateModelDefinition.getNumInstancesPerState(state);
            int max = -1;
            if ("N".equals(numInstancesPerState)) {
                max = cache.getLiveInstances().size();
            } else if (!"R".equals(numInstancesPerState)) {
                try {
                    max = Integer.parseInt(numInstancesPerState);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (max <= -1) continue;
            stateConstraints.put(state, new Bounds(0, max));
        }
        return stateConstraints;
    }

    private Map<String, Integer> getStateTransitionPriorityMap(StateModelDefinition stateModelDef) {
        HashMap<String, Integer> stateTransitionPriorities = new HashMap<String, Integer>();
        List<String> stateTransitionPriorityList = stateModelDef.getStateTransitionPriorityList();
        for (int i = 0; i < stateTransitionPriorityList.size(); ++i) {
            stateTransitionPriorities.put(stateTransitionPriorityList.get(i), i);
        }
        return stateTransitionPriorities;
    }

    protected static class Bounds {
        private int upper;
        private int lower;

        public Bounds(int lower, int upper) {
            this.lower = lower;
            this.upper = upper;
        }

        public int getUpperBound() {
            return this.upper;
        }
    }
}

