ace.define("ace/snippets",["require","exports","module","ace/lib/dom","ace/lib/oop","ace/lib/event_emitter","ace/lib/lang","ace/range","ace/range_list","ace/keyboard/hash_handler","ace/tokenizer","ace/clipboard","ace/editor"],function(v,E,z){"use strict";var L=v("./lib/dom"),R=v("./lib/oop"),_=v("./lib/event_emitter").EventEmitter,C=v("./lib/lang"),T=v("./range").Range,x=v("./range_list").RangeList,w=v("./keyboard/hash_handler").HashHandler,P=v("./tokenizer").Tokenizer,N=v("./clipboard"),k={CURRENT_WORD:function(t){return t.session.getTextRange(t.session.getWordRange())},SELECTION:function(t,e,n){var a=t.session.getTextRange();return n?a.replace(/\n\r?([ \t]*\S)/g,"\n"+n+"$1"):a},CURRENT_LINE:function(t){return t.session.getLine(t.getCursorPosition().row)},PREV_LINE:function(t){return t.session.getLine(t.getCursorPosition().row-1)},LINE_INDEX:function(t){return t.getCursorPosition().row},LINE_NUMBER:function(t){return t.getCursorPosition().row+1},SOFT_TABS:function(t){return t.session.getUseSoftTabs()?"YES":"NO"},TAB_SIZE:function(t){return t.session.getTabSize()},CLIPBOARD:function(t){return N.getText&&N.getText()},FILENAME:function(t){return/[^/\\]*$/.exec(this.FILEPATH(t))[0]},FILENAME_BASE:function(t){return/[^/\\]*$/.exec(this.FILEPATH(t))[0].replace(/\.[^.]*$/,"")},DIRECTORY:function(t){return this.FILEPATH(t).replace(/[^/\\]*$/,"")},FILEPATH:function(t){return"/not implemented.txt"},WORKSPACE_NAME:function(){return"Unknown"},FULLNAME:function(){return"Unknown"},BLOCK_COMMENT_START:function(t){var e=t.session.$mode||{};return e.blockComment&&e.blockComment.start||""},BLOCK_COMMENT_END:function(t){var e=t.session.$mode||{};return e.blockComment&&e.blockComment.end||""},LINE_COMMENT:function(t){return(t.session.$mode||{}).lineCommentStart||""},CURRENT_YEAR:b.bind(null,{year:"numeric"}),CURRENT_YEAR_SHORT:b.bind(null,{year:"2-digit"}),CURRENT_MONTH:b.bind(null,{month:"numeric"}),CURRENT_MONTH_NAME:b.bind(null,{month:"long"}),CURRENT_MONTH_NAME_SHORT:b.bind(null,{month:"short"}),CURRENT_DATE:b.bind(null,{day:"2-digit"}),CURRENT_DAY_NAME:b.bind(null,{weekday:"long"}),CURRENT_DAY_NAME_SHORT:b.bind(null,{weekday:"short"}),CURRENT_HOUR:b.bind(null,{hour:"2-digit",hour12:!1}),CURRENT_MINUTE:b.bind(null,{minute:"2-digit"}),CURRENT_SECOND:b.bind(null,{second:"2-digit"})};function b(t){var e=(new Date).toLocaleString("en-us",t);return 1==e.length?"0"+e:e}k.SELECTED_TEXT=k.SELECTION;var S=function(){this.snippetMap={},this.snippetNameMap={}};(function(){R.implement(this,_),this.getTokenizer=function(){return S.$tokenizer||this.createTokenizer()},this.createTokenizer=function(){function e(i){return i=i.substr(1),/^\d+$/.test(i)?[{tabstopId:parseInt(i,10)}]:[{text:i}]}function n(i){return"(?:[^\\\\"+i+"]|\\\\.)"}var a={regex:"/("+n("/")+"+)/",onMatch:function(i,o,r){var s=r[0];return s.fmtString=!0,s.guard=i.slice(1,-1),s.flag="",""},next:"formatString"};return S.$tokenizer=new P({start:[{regex:/\\./,onMatch:function(i,o,r){var s=i[1];return("}"==s&&r.length||-1!="`$\\".indexOf(s))&&(i=s),[i]}},{regex:/}/,onMatch:function(i,o,r){return[r.length?r.shift():i]}},{regex:/\$(?:\d+|\w+)/,onMatch:e},{regex:/\$\{[\dA-Z_a-z]+/,onMatch:function(i,o,r){var s=e(i.substr(1));return r.unshift(s[0]),s},next:"snippetVar"},{regex:/\n/,token:"newline",merge:!1}],snippetVar:[{regex:"\\|"+n("\\|")+"*\\|",onMatch:function(i,o,r){var s=i.slice(1,-1).replace(/\\[,|\\]|,/g,function(u){return 2==u.length?u[1]:"\0"}).split("\0").map(function(u){return{value:u}});return r[0].choices=s,[s[0]]},next:"start"},a,{regex:"([^:}\\\\]|\\\\.)*:?",token:"",next:"start"}],formatString:[{regex:/:/,onMatch:function(i,o,r){return r.length&&r[0].expectElse?(r[0].expectElse=!1,r[0].ifEnd={elseEnd:r[0]},[r[0].ifEnd]):":"}},{regex:/\\./,onMatch:function(i,o,r){var s=i[1];return"}"==s&&r.length||-1!="`$\\".indexOf(s)?i=s:"n"==s?i="\n":"t"==s?i="\t":-1!="ulULE".indexOf(s)&&(i={changeCase:s,local:s>"a"}),[i]}},{regex:"/\\w*}",onMatch:function(i,o,r){var s=r.shift();return s&&(s.flag=i.slice(1,-1)),this.next=s&&s.tabstopId?"start":"",[s||i]},next:"start"},{regex:/\$(?:\d+|\w+)/,onMatch:function(i,o,r){return[{text:i.slice(1)}]}},{regex:/\${\w+/,onMatch:function(i,o,r){var s={text:i.slice(2)};return r.unshift(s),[s]},next:"formatStringVar"},{regex:/\n/,token:"newline",merge:!1},{regex:/}/,onMatch:function(i,o,r){var s=r.shift();return this.next=s&&s.tabstopId?"start":"",[s||i]},next:"start"}],formatStringVar:[{regex:/:\/\w+}/,onMatch:function(i,o,r){return r[0].formatFunction=i.slice(2,-1),[r.shift()]},next:"formatString"},a,{regex:/:[\?\-+]?/,onMatch:function(i,o,r){"+"==i[1]&&(r[0].ifEnd=r[0]),"?"==i[1]&&(r[0].expectElse=!0)},next:"formatString"},{regex:"([^:}\\\\]|\\\\.)*:?",token:"",next:"formatString"}]})},this.tokenizeTmSnippet=function(e,n){return this.getTokenizer().getLineTokens(e,n).tokens.map(function(a){return a.value||a})},this.getVariableValue=function(e,n,a){if(/^\d+$/.test(n))return(this.variables.__||{})[n]||"";if(/^[A-Z]\d+$/.test(n))return(this.variables[n[0]+"__"]||{})[n.substr(1)]||"";if(n=n.replace(/^TM_/,""),!this.variables.hasOwnProperty(n))return"";var i=this.variables[n];return"function"==typeof i&&(i=this.variables[n](e,n,a)),null==i?"":i},this.variables=k,this.tmStrFormat=function(e,n,a){if(!n.fmt)return e;var o=n.guard;o=new RegExp(o,(n.flag||"").replace(/[^gim]/g,""));var r="string"==typeof n.fmt?this.tokenizeTmSnippet(n.fmt,"formatString"):n.fmt,s=this,u=e.replace(o,function(){var h=s.variables.__;s.variables.__=[].slice.call(arguments);for(var d=s.resolveVariables(r,a),y="E",m=0;m<d.length;m++){var g=d[m];if("object"==typeof g)if(d[m]="",g.changeCase&&g.local){var $=d[m+1];$&&"string"==typeof $&&(d[m]="u"==g.changeCase?$[0].toUpperCase():$[0].toLowerCase(),d[m+1]=$.substr(1))}else g.changeCase&&(y=g.changeCase);else"U"==y?d[m]=g.toUpperCase():"L"==y&&(d[m]=g.toLowerCase())}return s.variables.__=h,d.join("")});return u},this.tmFormatFunction=function(e,n,a){return"upcase"==n.formatFunction?e.toUpperCase():"downcase"==n.formatFunction?e.toLowerCase():e},this.resolveVariables=function(e,n){for(var a=[],i="",o=!0,r=0;r<e.length;r++){var s=e[r];if("string"!=typeof s){if(s){if(o=!1,s.fmtString){var u=e.indexOf(s,r+1);-1==u&&(u=e.length),s.fmt=e.slice(r+1,u),r=u}if(s.text){var h=this.getVariableValue(n,s.text,i)+"";s.fmtString&&(h=this.tmStrFormat(h,s,n)),s.formatFunction&&(h=this.tmFormatFunction(h,s,n)),h&&!s.ifEnd?(a.push(h),d(s)):!h&&s.ifEnd&&d(s.ifEnd)}else s.elseEnd?d(s.elseEnd):(null!=s.tabstopId||null!=s.changeCase)&&a.push(s)}}else a.push(s),"\n"==s?(o=!0,i=""):o&&(i=/^\t*/.exec(s)[0],o=/\S/.test(s))}function d(y){var m=e.indexOf(y,r+1);-1!=m&&(r=m)}return a};var t=function(e,n,a){var i=e.getCursorPosition(),o=e.session.getLine(i.row),r=e.session.getTabString(),s=o.match(/^\s*/)[0];i.column<s.length&&(s=s.slice(0,i.column)),n=n.replace(/\r/g,"");var u=this.tokenizeTmSnippet(n);u=(u=this.resolveVariables(u,e)).map(function(M){return"\n"==M?M+s:"string"==typeof M?M.replace(/\t/g,r):M});var h=[];u.forEach(function(M,H){if("object"==typeof M){var F=M.tabstopId,A=h[F];if(A||((A=h[F]=[]).index=F,A.value="",A.parents={}),-1===A.indexOf(M)){M.choices&&!A.choices&&(A.choices=M.choices),A.push(M);var B=u.indexOf(M,H+1);if(-1!==B){var V=u.slice(H+1,B);V.some(function(j){return"object"==typeof j})&&!A.value?A.value=V:V.length&&(!A.value||"string"!=typeof A.value)&&(A.value=V.join(""))}}}}),h.forEach(function(M){M.length=0});var d={};function y(M){for(var H=[],F=0;F<M.length;F++){var A=M[F];if("object"==typeof A){if(d[A.tabstopId])continue;A=H[M.lastIndexOf(A,F-1)]||{tabstopId:A.tabstopId}}H[F]=A}return H}for(var m=0;m<u.length;m++){var g=u[m];if("object"==typeof g){var $=g.tabstopId,O=h[$],D=u.indexOf(g,m+1);if(d[$]){d[$]===g&&(delete d[$],Object.keys(d).forEach(function(M){O.parents[M]=!0}));continue}d[$]=g;var I=O.value;"string"!=typeof I?I=y(I):g.fmt&&(I=this.tmStrFormat(I,g,e)),u.splice.apply(u,[m+1,Math.max(0,D-m)].concat(I,g)),-1===O.indexOf(g)&&O.push(g)}}var W=0,U=0,K="";return u.forEach(function(M){if("string"==typeof M){var H=M.split("\n");H.length>1?(U=H[H.length-1].length,W+=H.length-1):U+=M.length,K+=M}else M&&(M.start?M.end={row:W,column:U}:M.start={row:W,column:U})}),{text:K,tabstops:h,tokens:u}};this.getDisplayTextForSnippet=function(e,n){return t.call(this,e,n).text},this.insertSnippetForSelection=function(e,n,a){var i=t.call(this,e,n),o=e.getSelectionRange();a&&0===a.compareRange(o)&&(o=a);var r=e.session.replace(o,i.text);new p(e).addTabstops(i.tabstops,o.start,r,e.inVirtualSelectionMode&&e.selection.index)},this.insertSnippet=function(e,n,a){var i=this;if(e.inVirtualSelectionMode)return i.insertSnippetForSelection(e,n,a);e.forEachSelection(function(){i.insertSnippetForSelection(e,n,a)},null,{keepOrder:!0}),e.tabstopManager&&e.tabstopManager.tabNext()},this.$getScope=function(e){var n=e.session.$mode.$id||"";if("html"===(n=n.split("/").pop())||"php"===n){"php"===n&&!e.session.$mode.inlinePhp&&(n="html");var a=e.getCursorPosition(),i=e.session.getState(a.row);"object"==typeof i&&(i=i[0]),i.substring&&("js-"==i.substring(0,3)?n="javascript":"css-"==i.substring(0,4)?n="css":"php-"==i.substring(0,4)&&(n="php"))}return n},this.getActiveScopes=function(e){var n=this.$getScope(e),a=[n],i=this.snippetMap;return i[n]&&i[n].includeScopes&&a.push.apply(a,i[n].includeScopes),a.push("_"),a},this.expandWithTab=function(e,n){var a=this,i=e.forEachSelection(function(){return a.expandSnippetForSelection(e,n)},null,{keepOrder:!0});return i&&e.tabstopManager&&e.tabstopManager.tabNext(),i},this.expandSnippetForSelection=function(e,n){var u,a=e.getCursorPosition(),i=e.session.getLine(a.row),o=i.substring(0,a.column),r=i.substr(a.column),s=this.snippetMap;return this.getActiveScopes(e).some(function(h){var d=s[h];return d&&(u=this.findMatchingSnippet(d,o,r)),!!u},this),!!u&&(n&&n.dryRun||(e.session.doc.removeInLine(a.row,a.column-u.replaceBefore.length,a.column+u.replaceAfter.length),this.variables.M__=u.matchBefore,this.variables.T__=u.matchAfter,this.insertSnippetForSelection(e,u.content),this.variables.M__=this.variables.T__=null),!0)},this.findMatchingSnippet=function(e,n,a){for(var i=e.length;i--;){var o=e[i];if((!o.startRe||o.startRe.test(n))&&(!o.endRe||o.endRe.test(a))&&(o.startRe||o.endRe))return o.matchBefore=o.startRe?o.startRe.exec(n):[""],o.matchAfter=o.endRe?o.endRe.exec(a):[""],o.replaceBefore=o.triggerRe?o.triggerRe.exec(n)[0]:"",o.replaceAfter=o.endTriggerRe?o.endTriggerRe.exec(a)[0]:"",o}},this.snippetMap={},this.snippetNameMap={},this.register=function(e,n){var a=this.snippetMap,i=this.snippetNameMap,o=this;function r(h){return h&&!/^\^?\(.*\)\$?$|^\\b$/.test(h)&&(h="(?:"+h+")"),h||""}function s(h,d,y){return h=r(h),d=r(d),y?(h=d+h)&&"$"!=h[h.length-1]&&(h+="$"):(h+=d)&&"^"!=h[0]&&(h="^"+h),new RegExp(h)}function u(h){h.scope||(h.scope=n||"_"),a[n=h.scope]||(a[n]=[],i[n]={});var d=i[n];if(h.name){var y=d[h.name];y&&o.unregister(y),d[h.name]=h}a[n].push(h),h.prefix&&(h.tabTrigger=h.prefix),!h.content&&h.body&&(h.content=Array.isArray(h.body)?h.body.join("\n"):h.body),h.tabTrigger&&!h.trigger&&(!h.guard&&/^\w/.test(h.tabTrigger)&&(h.guard="\\b"),h.trigger=C.escapeRegExp(h.tabTrigger)),(h.trigger||h.guard||h.endTrigger||h.endGuard)&&(h.startRe=s(h.trigger,h.guard,!0),h.triggerRe=new RegExp(h.trigger),h.endRe=s(h.endTrigger,h.endGuard,!0),h.endTriggerRe=new RegExp(h.endTrigger))}e||(e=[]),Array.isArray(e)?e.forEach(u):Object.keys(e).forEach(function(h){u(e[h])}),this._signal("registerSnippets",{scope:n})},this.unregister=function(e,n){var a=this.snippetMap,i=this.snippetNameMap;function o(r){var s=i[r.scope||n];if(s&&s[r.name]){delete s[r.name];var u=a[r.scope||n],h=u&&u.indexOf(r);h>=0&&u.splice(h,1)}}e.content?o(e):Array.isArray(e)&&e.forEach(o)},this.parseSnippetFile=function(e){e=e.replace(/\r/g,"");for(var o,n=[],a={},i=/^#.*|^({[\s\S]*})\s*$|^(\S+) (.*)$|^((?:\n*\t.*)+)/gm;o=i.exec(e);){if(o[1])try{a=JSON.parse(o[1]),n.push(a)}catch(h){}if(o[4])a.content=o[4].replace(/^\t/gm,""),n.push(a),a={};else{var r=o[2],s=o[3];if("regex"==r){var u=/\/((?:[^\/\\]|\\.)*)|$/g;a.guard=u.exec(s)[1],a.trigger=u.exec(s)[1],a.endTrigger=u.exec(s)[1],a.endGuard=u.exec(s)[1]}else"snippet"==r?(a.tabTrigger=s.match(/^\S*/)[0],a.name||(a.name=s)):r&&(a[r]=s)}}return n},this.getSnippetByName=function(e,n){var i,a=this.snippetNameMap;return this.getActiveScopes(n).some(function(o){var r=a[o];return r&&(i=r[e]),!!i},this),i}}).call(S.prototype);var p=function(t){if(t.tabstopManager)return t.tabstopManager;t.tabstopManager=this,this.$onChange=this.onChange.bind(this),this.$onChangeSelection=C.delayedCall(this.onChangeSelection.bind(this)).schedule,this.$onChangeSession=this.onChangeSession.bind(this),this.$onAfterExec=this.onAfterExec.bind(this),this.attach(t)};(function(){this.attach=function(t){this.index=0,this.ranges=[],this.tabstops=[],this.$openTabstops=null,this.selectedTabstop=null,this.editor=t,this.editor.on("change",this.$onChange),this.editor.on("changeSelection",this.$onChangeSelection),this.editor.on("changeSession",this.$onChangeSession),this.editor.commands.on("afterExec",this.$onAfterExec),this.editor.keyBinding.addKeyboardHandler(this.keyboardHandler)},this.detach=function(){this.tabstops.forEach(this.removeTabstopMarkers,this),this.ranges=null,this.tabstops=null,this.selectedTabstop=null,this.editor.removeListener("change",this.$onChange),this.editor.removeListener("changeSelection",this.$onChangeSelection),this.editor.removeListener("changeSession",this.$onChangeSession),this.editor.commands.removeListener("afterExec",this.$onAfterExec),this.editor.keyBinding.removeKeyboardHandler(this.keyboardHandler),this.editor.tabstopManager=null,this.editor=null},this.onChange=function(t){for(var e="r"==t.action[0],n=this.selectedTabstop||{},a=n.parents||{},i=(this.tabstops||[]).slice(),o=0;o<i.length;o++){var r=i[o];if(r.rangeList.$bias=r==n||a[r.index]?0:1,"remove"==t.action&&r!==n){var u=r.parents&&r.parents[n.index],h=r.rangeList.pointIndex(t.start,u);h=h<0?-h-1:h+1;for(var d=r.rangeList.pointIndex(t.end,u),y=r.rangeList.ranges.slice(h,d=d<0?-d-1:d-1),m=0;m<y.length;m++)this.removeRange(y[m])}r.rangeList.$onChange(t)}var g=this.editor.session;!this.$inChange&&e&&1==g.getLength()&&!g.getValue()&&this.detach()},this.updateLinkedFields=function(){var t=this.selectedTabstop;if(t&&t.hasLinkedRanges&&t.firstNonLinked){this.$inChange=!0;for(var e=this.editor.session,n=e.getTextRange(t.firstNonLinked),a=0;a<t.length;a++){var i=t[a];if(i.linked){var r=E.snippetManager.tmStrFormat(n,i.original,this.editor);e.replace(i,r)}}this.$inChange=!1}},this.onAfterExec=function(t){t.command&&!t.command.readOnly&&this.updateLinkedFields()},this.onChangeSelection=function(){if(this.editor){for(var t=this.editor.selection.lead,e=this.editor.selection.anchor,n=this.editor.selection.isEmpty(),a=0;a<this.ranges.length;a++)if(!this.ranges[a].linked){var i=this.ranges[a].contains(t.row,t.column),o=n||this.ranges[a].contains(e.row,e.column);if(i&&o)return}this.detach()}},this.onChangeSession=function(){this.detach()},this.tabNext=function(t){var e=this.tabstops.length,n=this.index+(t||1);(n=Math.min(Math.max(n,1),e))==e&&(n=0),this.selectTabstop(n),0===n&&this.detach()},this.selectTabstop=function(t){this.$openTabstops=null;var e=this.tabstops[this.index];if(e&&this.addTabstopMarkers(e),this.index=t,(e=this.tabstops[this.index])&&e.length){this.selectedTabstop=e;var n=e.firstNonLinked||e;if(e.choices&&(n.cursor=n.start),this.editor.inVirtualSelectionMode)this.editor.selection.fromOrientedRange(n);else{var a=this.editor.multiSelect;a.toSingleRange(n);for(var i=0;i<e.length;i++)e.hasLinkedRanges&&e[i].linked||a.addRange(e[i].clone(),!0)}this.editor.keyBinding.addKeyboardHandler(this.keyboardHandler),this.selectedTabstop&&this.selectedTabstop.choices&&this.editor.execCommand("startAutocomplete",{matches:this.selectedTabstop.choices})}},this.addTabstops=function(t,e,n){var a=this.useLink||!this.editor.getOption("enableMultiselect");if(this.$openTabstops||(this.$openTabstops=[]),!t[0]){var i=T.fromPoints(n,n);l(i.start,e),l(i.end,e),t[0]=[i],t[0].index=0}var r=[this.index+1,0],s=this.ranges;t.forEach(function(u,h){for(var d=this.$openTabstops[h]||u,y=0;y<u.length;y++){var m=u[y],g=T.fromPoints(m.start,m.end||m.start);f(g.start,e),f(g.end,e),g.original=m,g.tabstop=d,s.push(g),d!=u?d.unshift(g):d[y]=g,m.fmtString||d.firstNonLinked&&a?(g.linked=!0,d.hasLinkedRanges=!0):d.firstNonLinked||(d.firstNonLinked=g)}d.firstNonLinked||(d.hasLinkedRanges=!1),d===u&&(r.push(d),this.$openTabstops[h]=d),this.addTabstopMarkers(d),d.rangeList=d.rangeList||new x,d.rangeList.$bias=0,d.rangeList.addList(d)},this),r.length>2&&(this.tabstops.length&&r.push(r.splice(2,1)[0]),this.tabstops.splice.apply(this.tabstops,r))},this.addTabstopMarkers=function(t){var e=this.editor.session;t.forEach(function(n){n.markerId||(n.markerId=e.addMarker(n,"ace_snippet-marker","text"))})},this.removeTabstopMarkers=function(t){var e=this.editor.session;t.forEach(function(n){e.removeMarker(n.markerId),n.markerId=null})},this.removeRange=function(t){var e=t.tabstop.indexOf(t);-1!=e&&t.tabstop.splice(e,1),-1!=(e=this.ranges.indexOf(t))&&this.ranges.splice(e,1),-1!=(e=t.tabstop.rangeList.ranges.indexOf(t))&&t.tabstop.splice(e,1),this.editor.session.removeMarker(t.markerId),t.tabstop.length||(-1!=(e=this.tabstops.indexOf(t.tabstop))&&this.tabstops.splice(e,1),this.tabstops.length||this.detach())},this.keyboardHandler=new w,this.keyboardHandler.bindKeys({Tab:function(t){E.snippetManager&&E.snippetManager.expandWithTab(t)||(t.tabstopManager.tabNext(1),t.renderer.scrollCursorIntoView())},"Shift-Tab":function(t){t.tabstopManager.tabNext(-1),t.renderer.scrollCursorIntoView()},Esc:function(t){t.tabstopManager.detach()}})}).call(p.prototype);var f=function(t,e){0==t.row&&(t.column+=e.column),t.row+=e.row},l=function(t,e){t.row==e.row&&(t.column-=e.column),t.row-=e.row};L.importCssString("\n.ace_snippet-marker {\n    -moz-box-sizing: border-box;\n    box-sizing: border-box;\n    background: rgba(194, 193, 208, 0.09);\n    border: 1px dotted rgba(211, 208, 235, 0.62);\n    position: absolute;\n}","snippets.css",!1),E.snippetManager=new S;var c=v("./editor").Editor;(function(){this.insertSnippet=function(t,e){return E.snippetManager.insertSnippet(this,t,e)},this.expandSnippet=function(t){return E.snippetManager.expandWithTab(this,t)}}).call(c.prototype)}),ace.define("ace/autocomplete/popup",["require","exports","module","ace/virtual_renderer","ace/editor","ace/range","ace/lib/event","ace/lib/lang","ace/lib/dom"],function(v,E,z){"use strict";var L=v("../virtual_renderer").VirtualRenderer,R=v("../editor").Editor,_=v("../range").Range,C=v("../lib/event"),T=v("../lib/lang"),x=v("../lib/dom"),w=function(k){return"suggest-aria-id:".concat(k)},P=function(k){var b=new L(k);b.$maxLines=4;var S=new R(b);return S.setHighlightActiveLine(!1),S.setShowPrintMargin(!1),S.renderer.setShowGutter(!1),S.renderer.setHighlightGutterLine(!1),S.$mouseHandler.$focusTimeout=0,S.$highlightTagPending=!0,S};x.importCssString("\n.ace_editor.ace_autocomplete .ace_marker-layer .ace_active-line {\n    background-color: #CAD6FA;\n    z-index: 1;\n}\n.ace_dark.ace_editor.ace_autocomplete .ace_marker-layer .ace_active-line {\n    background-color: #3a674e;\n}\n.ace_editor.ace_autocomplete .ace_line-hover {\n    border: 1px solid #abbffe;\n    margin-top: -1px;\n    background: rgba(233,233,253,0.4);\n    position: absolute;\n    z-index: 2;\n}\n.ace_dark.ace_editor.ace_autocomplete .ace_line-hover {\n    border: 1px solid rgba(109, 150, 13, 0.8);\n    background: rgba(58, 103, 78, 0.62);\n}\n.ace_completion-meta {\n    opacity: 0.5;\n    margin: 0 0.9em;\n}\n.ace_completion-message {\n    color: blue;\n}\n.ace_editor.ace_autocomplete .ace_completion-highlight{\n    color: #2d69c7;\n}\n.ace_dark.ace_editor.ace_autocomplete .ace_completion-highlight{\n    color: #93ca12;\n}\n.ace_editor.ace_autocomplete {\n    width: 300px;\n    z-index: 200000;\n    border: 1px lightgray solid;\n    position: fixed;\n    box-shadow: 2px 3px 5px rgba(0,0,0,.2);\n    line-height: 1.4;\n    background: #fefefe;\n    color: #111;\n}\n.ace_dark.ace_editor.ace_autocomplete {\n    border: 1px #484747 solid;\n    box-shadow: 2px 3px 5px rgba(0, 0, 0, 0.51);\n    line-height: 1.4;\n    background: #25282c;\n    color: #c1c1c1;\n}\n.ace_autocomplete_right .ace_text-layer  {\n    width: calc(100% - 8px);\n}\n.ace_autocomplete_right .ace_line {\n    display: flex;\n}\n.ace_autocomplete_right .ace_completion-meta {\n    flex: 1;\n    text-align: right;\n}\n","autocompletion.css",!1),E.AcePopup=function k(b){var S=x.createElement("div"),p=new P(S);b&&b.appendChild(S),S.style.display="none",p.renderer.content.style.cursor="default",p.renderer.setStyle("ace_autocomplete"),p.renderer.container.setAttribute("role","listbox"),p.renderer.container.setAttribute("aria-label","Autocomplete suggestions"),p.setOption("displayIndentGuides",!1),p.setOption("dragDelay",150);var f=function(){};p.focus=f,p.$isFocused=!0,p.renderer.$cursorLayer.restartTimer=f,p.renderer.$cursorLayer.element.style.opacity=0,p.renderer.$maxLines=8,p.renderer.$keepTextAreaAtCursor=!1,p.setHighlightActiveLine(!1),p.session.highlight(""),p.session.$searchHighlight.clazz="ace_highlight-marker",p.on("mousedown",function(i){var o=i.getDocumentPosition();p.selection.moveToPosition(o),t.start.row=t.end.row=o.row,i.stop()});var l,c=new _(-1,0,-1,1/0),t=new _(-1,0,-1,1/0);t.id=p.session.addMarker(t,"ace_active-line","fullLine"),p.setSelectOnHover=function(i){i?c.id&&(p.session.removeMarker(c.id),c.id=null):c.id=p.session.addMarker(c,"ace_line-hover","fullLine")},p.setSelectOnHover(!1),p.on("mousemove",function(i){if(l){if(l.x!=i.x||l.y!=i.y){(l=i).scrollTop=p.renderer.scrollTop;var o=l.getDocumentPosition().row;c.start.row!=o&&(c.id||p.setRow(o),n(o))}}else l=i}),p.renderer.on("beforeRender",function(){if(l&&-1!=c.start.row){l.$pos=null;var i=l.getDocumentPosition().row;c.id||p.setRow(i),n(i,!0)}}),p.renderer.on("afterRender",function(){var i=p.getRow(),o=p.renderer.$textLayer,r=o.element.childNodes[i-o.config.firstRow],s=document.activeElement;if(r!==o.selectedNode&&o.selectedNode&&(x.removeCssClass(o.selectedNode,"ace_selected"),s.removeAttribute("aria-activedescendant"),o.selectedNode.removeAttribute("id")),o.selectedNode=r,r){x.addCssClass(r,"ace_selected");var u=w(i);r.id=u,p.renderer.container.setAttribute("aria-activedescendant",u),s.setAttribute("aria-activedescendant",u),r.setAttribute("role","option"),r.setAttribute("aria-label",p.getData(i).value),r.setAttribute("aria-setsize",p.data.length),r.setAttribute("aria-posinset",i)}});var e=function(){n(-1)},n=function(i,o){i!==c.start.row&&(c.start.row=c.end.row=i,o||p.session._emit("changeBackMarker"),p._emit("changeHoverMarker"))};p.getHoveredRow=function(){return c.start.row},C.addListener(p.container,"mouseout",e),p.on("hide",e),p.on("changeSelection",e),p.session.doc.getLength=function(){return p.data.length},p.session.doc.getLine=function(i){var o=p.data[i];return"string"==typeof o?o:o&&o.value||""};var a=p.session.bgTokenizer;return a.$tokenizeRow=function(i){var o=p.data[i],r=[];if(!o)return r;"string"==typeof o&&(o={value:o});var s=o.caption||o.value||o.name;function u(D,I){D&&r.push({type:(o.className||"")+(I||""),value:D})}for(var h=s.toLowerCase(),d=(p.filterText||"").toLowerCase(),y=0,m=0,g=0;g<=d.length;g++)if(g!=m&&(o.matchMask&1<<g||g==d.length)){var $=d.slice(m,g);m=g;var O=h.indexOf($,y);if(-1==O)continue;u(s.slice(y,O),""),u(s.slice(O,y=O+$.length),"completion-highlight")}return u(s.slice(y,s.length),""),o.meta&&r.push({type:"completion-meta",value:o.meta}),o.message&&r.push({type:"completion-message",value:o.message}),r},a.$updateOnChange=f,a.start=f,p.session.$computeWidth=function(){return this.screenWidth=0},p.isOpen=!1,p.isTopdown=!1,p.autoSelect=!0,p.filterText="",p.data=[],p.setData=function(i,o){p.filterText=o||"",p.setValue(T.stringRepeat("\n",i.length),-1),p.data=i||[],p.setRow(0)},p.getData=function(i){return p.data[i]},p.getRow=function(){return t.start.row},p.setRow=function(i){i=Math.max(this.autoSelect?0:-1,Math.min(this.data.length,i)),t.start.row!=i&&(p.selection.clearSelection(),t.start.row=t.end.row=i||0,p.session._emit("changeBackMarker"),p.moveCursorTo(i||0,0),p.isOpen&&p._signal("select"))},p.on("changeSelection",function(){p.isOpen&&p.setRow(p.selection.lead.row),p.renderer.scrollCursorIntoView()}),p.hide=function(){this.container.style.display="none",p.anchorPos=null,p.anchor=null,p.isOpen&&(p.isOpen=!1,this._signal("hide"))},p.tryShow=function(i,o,r,s){if(!s&&p.isOpen&&p.anchorPos&&p.anchor&&p.anchorPos.top===i.top&&p.anchorPos.left===i.left&&p.anchor===r)return!0;var u=this.container,h=window.innerHeight,d=window.innerWidth,y=this.renderer,m=y.$maxLines*o*1.4,g={top:0,bottom:0,left:0},$=h-i.top-3*this.$borderSize-o,O=i.top-3*this.$borderSize;r||(r=O<=$||$>=m?"bottom":"top"),"top"===r?(g.bottom=i.top-this.$borderSize,g.top=g.bottom-m):"bottom"===r&&(g.top=i.top+o+this.$borderSize,g.bottom=g.top+m);var D=g.top>=0&&g.bottom<=h;if(!s&&!D)return!1;y.$maxPixelHeight=D?null:"top"===r?O:$,"top"===r?(u.style.top="",u.style.bottom=h-g.bottom+"px",p.isTopdown=!1):(u.style.top=g.top+"px",u.style.bottom="",p.isTopdown=!0),u.style.display="";var I=i.left;return I+u.offsetWidth>d&&(I=d-u.offsetWidth),u.style.left=I+"px",u.style.right="",p.isOpen||(p.isOpen=!0,this._signal("show"),l=null),p.anchorPos=i,p.anchor=r,!0},p.show=function(i,o,r){this.tryShow(i,o,r?"bottom":void 0,!0)},p.goTo=function(i){var o=this.getRow(),r=this.session.getLength()-1;switch(i){case"up":o=o<=0?r:o-1;break;case"down":o=o>=r?-1:o+1;break;case"start":o=0;break;case"end":o=r}this.setRow(o)},p.getTextLeftOffset=function(){return this.$borderSize+this.renderer.$padding+this.$imageSize},p.$imageSize=0,p.$borderSize=1,p},E.$singleLineEditor=P,E.getAriaId=w}),ace.define("ace/autocomplete/inline",["require","exports","module","ace/snippets"],function(v,E,z){"use strict";var L=v("../snippets").snippetManager,R=function(){function _(){this.editor=null}return _.prototype.show=function(C,T,x){if(x=x||"",C&&this.editor&&this.editor!==C&&(this.hide(),this.editor=null),!C||!T)return!1;var w=T.snippet?L.getDisplayTextForSnippet(C,T.snippet):T.value;return!(!w||!w.startsWith(x)||(this.editor=C,""===(w=w.slice(x.length))?C.removeGhostText():C.setGhostText(w),0))},_.prototype.isOpen=function(){return!!this.editor&&!!this.editor.renderer.$ghostText},_.prototype.hide=function(){return!!this.editor&&(this.editor.removeGhostText(),!0)},_.prototype.destroy=function(){this.hide(),this.editor=null},_}();E.AceInline=R}),ace.define("ace/autocomplete/util",["require","exports","module"],function(v,E,z){"use strict";E.parForEach=function(R,_,C){var T=0,x=R.length;0===x&&C();for(var w=0;w<x;w++)_(R[w],function(P,N){++T===x&&C(P,N)})};var L=/[a-zA-Z_0-9\$\-\u00A2-\u2000\u2070-\uFFFF]/;E.retrievePrecedingIdentifier=function(R,_,C){C=C||L;for(var T=[],x=_-1;x>=0&&C.test(R[x]);x--)T.push(R[x]);return T.reverse().join("")},E.retrieveFollowingIdentifier=function(R,_,C){C=C||L;for(var T=[],x=_;x<R.length&&C.test(R[x]);x++)T.push(R[x]);return T},E.getCompletionPrefix=function(R){var T,_=R.getCursorPosition(),C=R.session.getLine(_.row);return R.completers.forEach(function(x){x.identifierRegexps&&x.identifierRegexps.forEach(function(w){!T&&w&&(T=this.retrievePrecedingIdentifier(C,_.column,w))}.bind(this))}.bind(this)),T||this.retrievePrecedingIdentifier(C,_.column)}}),ace.define("ace/autocomplete",["require","exports","module","ace/keyboard/hash_handler","ace/autocomplete/popup","ace/autocomplete/inline","ace/autocomplete/popup","ace/autocomplete/util","ace/lib/lang","ace/lib/dom","ace/snippets","ace/config"],function(v,E,z){"use strict";var L=v("./keyboard/hash_handler").HashHandler,R=v("./autocomplete/popup").AcePopup,_=v("./autocomplete/inline").AceInline,C=v("./autocomplete/popup").getAriaId,T=v("./autocomplete/util"),x=v("./lib/lang"),w=v("./lib/dom"),P=v("./snippets").snippetManager,N=v("./config"),k=function(f,l){l.completer&&l.completer.destroy()},b=function(){function f(){this.autoInsert=!1,this.autoSelect=!0,this.exactMatch=!1,this.inlineEnabled=!1,this.keyboardHandler=new L,this.keyboardHandler.bindKeys(this.commands),this.blurListener=this.blurListener.bind(this),this.changeListener=this.changeListener.bind(this),this.mousedownListener=this.mousedownListener.bind(this),this.mousewheelListener=this.mousewheelListener.bind(this),this.changeTimer=x.delayedCall(function(){this.updateCompletions(!0)}.bind(this)),this.tooltipTimer=x.delayedCall(this.updateDocTooltip.bind(this),50)}return f.prototype.$init=function(){return this.popup=new R(document.body||document.documentElement),this.popup.on("click",function(l){this.insertMatch(),l.stop()}.bind(this)),this.popup.focus=this.editor.focus.bind(this.editor),this.popup.on("show",this.$onPopupChange.bind(this)),this.popup.on("hide",this.$onHidePopup.bind(this)),this.popup.on("select",this.$onPopupChange.bind(this)),this.popup.on("changeHoverMarker",this.tooltipTimer.bind(null,null)),this.popup},f.prototype.$initInline=function(){if(this.inlineEnabled&&!this.inlineRenderer)return this.inlineRenderer=new _,this.inlineRenderer},f.prototype.getPopup=function(){return this.popup||this.$init()},f.prototype.$onHidePopup=function(){this.inlineRenderer&&this.inlineRenderer.hide(),this.hideDocTooltip()},f.prototype.$onPopupChange=function(l){if(this.inlineRenderer&&this.inlineEnabled){var c=l?null:this.popup.getData(this.popup.getRow()),t=T.getCompletionPrefix(this.editor);this.inlineRenderer.show(this.editor,c,t)||this.inlineRenderer.hide(),this.$updatePopupPosition()}this.tooltipTimer.call(null,null)},f.prototype.$updatePopupPosition=function(){var l=this.editor,c=l.renderer,t=c.layerConfig.lineHeight,e=c.$cursorLayer.getPixelPosition(this.base,!0);e.left-=this.popup.getTextLeftOffset();var n=l.container.getBoundingClientRect();e.top+=n.top-c.layerConfig.offset,e.left+=n.left-l.renderer.scrollLeft,e.left+=c.gutterWidth;var a={top:e.top,left:e.left};c.$ghostText&&c.$ghostTextWidget&&this.base.row===c.$ghostText.position.row&&(a.top+=c.$ghostTextWidget.el.offsetHeight),!this.popup.tryShow(a,t,"bottom")&&(this.popup.tryShow(e,t,"top")||this.popup.show(e,t))},f.prototype.openPopup=function(l,c,t){this.popup||this.$init(),this.inlineEnabled&&!this.inlineRenderer&&this.$initInline(),this.popup.autoSelect=this.autoSelect,this.popup.setData(this.completions.filtered,this.completions.filterText),this.editor.textInput.setAriaOptions&&this.editor.textInput.setAriaOptions({activeDescendant:C(this.popup.getRow()),inline:this.inlineEnabled}),l.keyBinding.addKeyboardHandler(this.keyboardHandler),this.popup.setRow(this.autoSelect?0:-1),t?t&&!c&&this.detach():(this.popup.setTheme(l.getTheme()),this.popup.setFontSize(l.getFontSize()),this.$updatePopupPosition(),this.tooltipNode&&this.updateDocTooltip()),this.changeTimer.cancel()},f.prototype.detach=function(){this.editor&&(this.editor.keyBinding.removeKeyboardHandler(this.keyboardHandler),this.editor.off("changeSelection",this.changeListener),this.editor.off("blur",this.blurListener),this.editor.off("mousedown",this.mousedownListener),this.editor.off("mousewheel",this.mousewheelListener)),this.changeTimer.cancel(),this.hideDocTooltip(),this.completionProvider&&this.completionProvider.detach(),this.popup&&this.popup.isOpen&&this.popup.hide(),this.base&&this.base.detach(),this.activated=!1,this.completionProvider=this.completions=this.base=null},f.prototype.changeListener=function(l){var c=this.editor.selection.lead;(c.row!=this.base.row||c.column<this.base.column)&&this.detach(),this.activated?this.changeTimer.schedule():this.detach()},f.prototype.blurListener=function(l){var c=document.activeElement,t=this.editor.textInput.getElement(),e=l.relatedTarget&&this.tooltipNode&&this.tooltipNode.contains(l.relatedTarget);c!=t&&c.parentNode!=(this.popup&&this.popup.container)&&!e&&c!=this.tooltipNode&&l.relatedTarget!=t&&this.detach()},f.prototype.mousedownListener=function(l){this.detach()},f.prototype.mousewheelListener=function(l){this.detach()},f.prototype.goTo=function(l){this.popup.goTo(l)},f.prototype.insertMatch=function(l,c){if(l||(l=this.popup.getData(this.popup.getRow())),!l)return!1;var t=this.completions,e=this.getCompletionProvider().insertMatch(this.editor,l,t.filterText,c);return this.completions==t&&this.detach(),e},f.prototype.showPopup=function(l,c){this.editor&&this.detach(),this.activated=!0,this.editor=l,l.completer!=this&&(l.completer&&l.completer.detach(),l.completer=this),l.on("changeSelection",this.changeListener),l.on("blur",this.blurListener),l.on("mousedown",this.mousedownListener),l.on("mousewheel",this.mousewheelListener),this.updateCompletions(!1,c)},f.prototype.getCompletionProvider=function(){return this.completionProvider||(this.completionProvider=new S),this.completionProvider},f.prototype.gatherCompletions=function(l,c){return this.getCompletionProvider().gatherCompletions(l,c)},f.prototype.updateCompletions=function(l,c){if(l&&this.base&&this.completions){var e=this.editor.getCursorPosition();if((n=this.editor.session.getTextRange({start:this.base,end:e}))==this.completions.filterText)return;return this.completions.setFilter(n),this.completions.filtered.length&&(1!=this.completions.filtered.length||this.completions.filtered[0].value!=n||this.completions.filtered[0].snippet)?void this.openPopup(this.editor,n,l):this.detach()}if(c&&c.matches)return e=this.editor.getSelectionRange().start,this.base=this.editor.session.doc.createAnchor(e.row,e.column),this.base.$insertRight=!0,this.completions=new p(c.matches),this.openPopup(this.editor,"",l);var t=this.editor.getSession(),n=(e=this.editor.getCursorPosition(),T.getCompletionPrefix(this.editor));this.base=t.doc.createAnchor(e.row,e.column-n.length),this.base.$insertRight=!0;var a={exactMatch:this.exactMatch};this.getCompletionProvider().provideCompletions(this.editor,a,function(i,o,r){var s=o.filtered,u=T.getCompletionPrefix(this.editor);if(r){if(!s.length)return this.detach();if(1==s.length&&s[0].value==u&&!s[0].snippet)return this.detach();if(this.autoInsert&&1==s.length)return this.insertMatch(s[0])}this.completions=o,this.openPopup(this.editor,u,l)}.bind(this))},f.prototype.cancelContextMenu=function(){this.editor.$mouseHandler.cancelContextMenu()},f.prototype.updateDocTooltip=function(){var l=this.popup,c=l.data,t=c&&(c[l.getHoveredRow()]||c[l.getRow()]),e=null;if(!t||!this.editor||!this.popup.isOpen)return this.hideDocTooltip();for(var n=this.editor.completers.length,a=0;a<n;a++){var i=this.editor.completers[a];if(i.getDocTooltip&&t.completerId===i.id){e=i.getDocTooltip(t);break}}if(!e&&"string"!=typeof t&&(e=t),"string"==typeof e&&(e={docText:e}),!e||!e.docHTML&&!e.docText)return this.hideDocTooltip();this.showDocTooltip(e)},f.prototype.showDocTooltip=function(l){this.tooltipNode||(this.tooltipNode=w.createElement("div"),this.tooltipNode.style.margin=0,this.tooltipNode.style.pointerEvents="auto",this.tooltipNode.tabIndex=-1,this.tooltipNode.onblur=this.blurListener.bind(this),this.tooltipNode.onclick=this.onTooltipClick.bind(this));var c=this.editor.renderer.theme;this.tooltipNode.className="ace_tooltip ace_doc-tooltip "+(c.isDark?"ace_dark ":"")+(c.cssClass||"");var t=this.tooltipNode;l.docHTML?t.innerHTML=l.docHTML:l.docText&&(t.textContent=l.docText),t.parentNode||document.body.appendChild(t);var e=this.popup,n=e.container.getBoundingClientRect();t.style.top=e.container.style.top,t.style.bottom=e.container.style.bottom,t.style.display="block",window.innerWidth-n.right<320?n.left<320?e.isTopdown?(t.style.top=n.bottom+"px",t.style.left=n.left+"px",t.style.right="",t.style.bottom=""):(t.style.top=e.container.offsetTop-t.offsetHeight+"px",t.style.left=n.left+"px",t.style.right="",t.style.bottom=""):(t.style.right=window.innerWidth-n.left+"px",t.style.left=""):(t.style.left=n.right+1+"px",t.style.right="")},f.prototype.hideDocTooltip=function(){if(this.tooltipTimer.cancel(),this.tooltipNode){var l=this.tooltipNode;!this.editor.isFocused()&&document.activeElement==l&&this.editor.focus(),this.tooltipNode=null,l.parentNode&&l.parentNode.removeChild(l)}},f.prototype.onTooltipClick=function(l){for(var c=l.target;c&&c!=this.tooltipNode;){if("A"==c.nodeName&&c.href){c.rel="noreferrer",c.target="_blank";break}c=c.parentNode}},f.prototype.destroy=function(){if(this.detach(),this.popup){this.popup.destroy();var l=this.popup.container;l&&l.parentNode&&l.parentNode.removeChild(l)}this.editor&&this.editor.completer==this&&(this.editor.off("destroy",k),this.editor.completer=null),this.inlineRenderer=this.popup=this.editor=null},f}();b.prototype.commands={Up:function(f){f.completer.goTo("up")},Down:function(f){f.completer.goTo("down")},"Ctrl-Up|Ctrl-Home":function(f){f.completer.goTo("start")},"Ctrl-Down|Ctrl-End":function(f){f.completer.goTo("end")},Esc:function(f){f.completer.detach()},Return:function(f){return f.completer.insertMatch()},"Shift-Return":function(f){f.completer.insertMatch(null,{deleteSuffix:!0})},Tab:function(f){var l=f.completer.insertMatch();if(l||f.tabstopManager)return l;f.completer.goTo("down")},PageUp:function(f){f.completer.popup.gotoPageUp()},PageDown:function(f){f.completer.popup.gotoPageDown()}},b.for=function(f){return f.completer instanceof b||(f.completer&&(f.completer.destroy(),f.completer=null),N.get("sharedPopups")?(b.$sharedInstance||(b.$sharedInstance=new b),f.completer=b.$sharedInstance):(f.completer=new b,f.once("destroy",k))),f.completer},b.startCommand={name:"startAutocomplete",exec:function(f,l){var c=b.for(f);c.autoInsert=!1,c.autoSelect=!0,c.showPopup(f,l),c.cancelContextMenu()},bindKey:"Ctrl-Space|Ctrl-Shift-Space|Alt-Space"};var S=function(){function f(){this.active=!0}return f.prototype.insertByIndex=function(l,c,t){return!(!this.completions||!this.completions.filtered)&&this.insertMatch(l,this.completions.filtered[c],t)},f.prototype.insertMatch=function(l,c,t){if(!c)return!1;if(l.startOperation({command:{name:"insertMatch"}}),c.completer&&c.completer.insertMatch)c.completer.insertMatch(l,c);else{if(!this.completions)return!1;if(this.completions.filterText)for(var a,e=l.selection.getAllRanges(),n=0;a=e[n];n++)a.start.column-=this.completions.filterText.length,l.session.remove(a);c.snippet?P.insertSnippet(l,c.snippet,c.range):this.$insertString(l,c),c.command&&"startAutocomplete"===c.command&&l.execCommand(c.command)}return l.endOperation(),!0},f.prototype.$insertString=function(l,c){var t=c.value||c;if(c.range){if(l.inVirtualSelectionMode)return l.session.replace(c.range,t);l.forEachSelection(function(){var e=l.getSelectionRange();0===c.range.compareRange(e)?l.session.replace(c.range,t):l.insert(t)},null,{keepOrder:!0})}else l.execCommand("insertstring",t)},f.prototype.gatherCompletions=function(l,c){var t=l.getSession(),e=l.getCursorPosition(),n=T.getCompletionPrefix(l),a=[],i=l.completers.length;return l.completers.forEach(function(o,r){o.getCompletions(l,t,e,n,function(s,u){!s&&u&&(a=a.concat(u)),c(null,{prefix:T.getCompletionPrefix(l),matches:a,finished:0==--i})})}),!0},f.prototype.provideCompletions=function(l,c,t){var e=function(o){var r=o.prefix;this.completions=new p(o.matches),c.exactMatch&&(this.completions.exactMatch=!0),c.ignoreCaption&&(this.completions.ignoreCaption=!0),this.completions.setFilter(r),(o.finished||this.completions.filtered.length)&&t(null,this.completions,o.finished)}.bind(this),n=!0,a=null;if(this.gatherCompletions(l,function(o,r){if(this.active&&(o&&(t(o,[],!0),this.detach()),0===r.prefix.indexOf(r.prefix))){if(n)return void(a=r);e(r)}}.bind(this)),n=!1,a){var i=a;a=null,e(i)}},f.prototype.detach=function(){this.active=!1},f}(),p=function(){function f(l,c){this.all=l,this.filtered=l,this.filterText=c||"",this.exactMatch=!1,this.ignoreCaption=!1}return f.prototype.setFilter=function(l){if(l.length>this.filterText&&0===l.lastIndexOf(this.filterText,0))var c=this.filtered;else c=this.all;this.filterText=l,c=(c=this.filterCompletions(c,this.filterText)).sort(function(e,n){return n.exactMatch-e.exactMatch||n.$score-e.$score||(e.caption||e.value).localeCompare(n.caption||n.value)});var t=null;c=c.filter(function(e){var n=e.snippet||e.caption||e.value;return n!==t&&(t=n,!0)}),this.filtered=c},f.prototype.filterCompletions=function(l,c){var t=[],e=c.toUpperCase(),n=c.toLowerCase();e:for(var i,a=0;i=l[a];a++){var o=!this.ignoreCaption&&i.caption||i.value||i.snippet;if(o){var h,d,r=-1,s=0,u=0;if(this.exactMatch){if(c!==o.substr(0,c.length))continue e}else{var y=o.toLowerCase().indexOf(n);if(y>-1)u=y;else for(var m=0;m<c.length;m++){var g=o.indexOf(n[m],r+1),$=o.indexOf(e[m],r+1);if((h=g>=0&&($<0||g<$)?g:$)<0)continue e;(d=h-r-1)>0&&(-1===r&&(u+=10),u+=d,s|=1<<m),r=h}}i.matchMask=s,i.exactMatch=u?0:1,i.$score=(i.score||0)-u,t.push(i)}}return t},f}();E.Autocomplete=b,E.CompletionProvider=S,E.FilteredList=p}),ace.define("ace/autocomplete/text_completer",["require","exports","module","ace/range"],function(v,E,z){var L=v("../range").Range,R=/[^a-zA-Z_0-9\$\-\u00C0-\u1FFF\u2C00-\uD7FF\w]+/;E.getCompletions=function(T,x,w,P,N){var k=function C(T,x){var w=function _(T,x){return T.getTextRange(L.fromPoints({row:0,column:0},x)).split(R).length-1}(T,x),P=T.getValue().split(R),N=Object.create(null),k=P[w];return P.forEach(function(b,S){if(b&&b!==k){var p=Math.abs(w-S),f=P.length-p;N[b]=N[b]?Math.max(f,N[b]):f}}),N}(x,w);N(null,Object.keys(k).map(function(S){return{caption:S,value:S,score:k[S],meta:"local"}}))}}),ace.define("ace/ext/language_tools",["require","exports","module","ace/snippets","ace/autocomplete","ace/config","ace/lib/lang","ace/autocomplete/util","ace/autocomplete/text_completer","ace/editor","ace/config"],function(v,E,z){"use strict";var L=v("../snippets").snippetManager,R=v("../autocomplete").Autocomplete,_=v("../config"),C=v("../lib/lang"),T=v("../autocomplete/util"),x=v("../autocomplete/text_completer"),w={getCompletions:function(t,e,n,a,i){if(e.$mode.completer)return e.$mode.completer.getCompletions(t,e,n,a,i);var o=t.session.getState(n.row),r=e.$mode.getCompletions(o,e,n,a);i(null,r=r.map(function(s){return s.completerId=w.id,s}))},id:"keywordCompleter"},P=function(t){var e={};return t.replace(/\${(\d+)(:(.*?))?}/g,function(n,a,i,o){return e[a]=o||""}).replace(/\$(\d+?)/g,function(n,a){return e[a]})},N={getCompletions:function(t,e,n,a,i){var o=[],r=e.getTokenAt(n.row,n.column);r&&r.type.match(/(tag-name|tag-open|tag-whitespace|attribute-name|attribute-value)\.xml$/)?o.push("html-tag"):o=L.getActiveScopes(t);var s=L.snippetMap,u=[];o.forEach(function(h){for(var d=s[h]||[],y=d.length;y--;){var m=d[y],g=m.name||m.tabTrigger;!g||u.push({caption:g,snippet:m.content,meta:m.tabTrigger&&!m.name?m.tabTrigger+"\u21e5 ":"snippet",completerId:N.id})}},this),i(null,u)},getDocTooltip:function(t){t.snippet&&!t.docHTML&&(t.docHTML=["<b>",C.escapeHTML(t.caption),"</b>","<hr></hr>",C.escapeHTML(P(t.snippet))].join(""))},id:"snippetCompleter"},k=[N,x,w];E.setCompleters=function(t){k.length=0,t&&k.push.apply(k,t)},E.addCompleter=function(t){k.push(t)},E.textCompleter=x,E.keyWordCompleter=w,E.snippetCompleter=N;var b={name:"expandSnippet",exec:function(t){return L.expandWithTab(t)},bindKey:"Tab"},S=function(t,e){p(e.session.$mode)},p=function(t){"string"==typeof t&&(t=_.$modes[t]),t&&(L.files||(L.files={}),f(t.$id,t.snippetFileId),t.modes&&t.modes.forEach(p))},f=function(t,e){!e||!t||L.files[t]||(L.files[t]={},_.loadModule(e,function(n){!n||(L.files[t]=n,!n.snippets&&n.snippetText&&(n.snippets=L.parseSnippetFile(n.snippetText)),L.register(n.snippets||[],n.scope),n.includeScopes&&(L.snippetMap[n.scope].includeScopes=n.includeScopes,n.includeScopes.forEach(function(a){p("ace/mode/"+a)})))}))},l=function(t){var e=t.editor,n=e.completer&&e.completer.activated;if("backspace"===t.command.name)n&&!T.getCompletionPrefix(e)&&e.completer.detach();else if("insertstring"===t.command.name&&T.getCompletionPrefix(e)&&!n){var i=R.for(e);i.autoInsert=!1,i.showPopup(e)}},c=v("../editor").Editor;v("../config").defineOptions(c.prototype,"editor",{enableBasicAutocompletion:{set:function(t){t?(this.completers||(this.completers=Array.isArray(t)?t:k),this.commands.addCommand(R.startCommand)):this.commands.removeCommand(R.startCommand)},value:!1},enableLiveAutocompletion:{set:function(t){t?(this.completers||(this.completers=Array.isArray(t)?t:k),this.commands.on("afterExec",l)):this.commands.removeListener("afterExec",l)},value:!1},enableSnippets:{set:function(t){t?(this.commands.addCommand(b),this.on("changeMode",S),S(0,this)):(this.commands.removeCommand(b),this.off("changeMode",S))},value:!1}})}),ace.require(["ace/ext/language_tools"],function(v){"object"==typeof module&&"object"==typeof exports&&module&&(module.exports=v)});