/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.type;

import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.time.Instant;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexSubQuery;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlCollation;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlQuantifyOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.ArraySqlType;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.ConversionUtil;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.NlsString;
import org.apache.calcite.util.TimestampString;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.common.type.HiveIntervalYearMonth;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.common.type.TimestampTZ;
import org.apache.hadoop.hive.common.type.TimestampTZUtil;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.optimizer.calcite.CalciteSemanticException;
import org.apache.hadoop.hive.ql.optimizer.calcite.CalciteSubquerySemanticException;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveCalciteUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveComponentAccess;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveRexExprList;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.TypeConverter;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.QBSubQueryParseInfo;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.type.ExprFactory;
import org.apache.hadoop.hive.ql.parse.type.FunctionHelper;
import org.apache.hadoop.hive.ql.parse.type.HiveFunctionHelper;
import org.apache.hadoop.hive.ql.parse.type.TypeCheckCtx;
import org.apache.hadoop.hive.ql.plan.SubqueryType;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RexNodeExprFactory
extends ExprFactory<RexNode> {
    private static final Logger LOG = LoggerFactory.getLogger(RexNodeExprFactory.class);
    private final RexBuilder rexBuilder;
    private final FunctionHelper functionHelper;

    public RexNodeExprFactory(RexBuilder rexBuilder) {
        this.rexBuilder = rexBuilder;
        this.functionHelper = new HiveFunctionHelper(rexBuilder);
    }

    @Override
    protected boolean isExprInstance(Object o) {
        return o instanceof RexNode;
    }

    @Override
    protected RexNode toExpr(ColumnInfo colInfo, RowResolver rowResolver, int offset) throws CalciteSemanticException {
        ObjectInspector inspector = colInfo.getObjectInspector();
        if (inspector instanceof ConstantObjectInspector && inspector instanceof PrimitiveObjectInspector) {
            return RexNodeExprFactory.toPrimitiveConstDesc(colInfo, inspector, this.rexBuilder);
        }
        int index = rowResolver.getPosition(colInfo.getInternalName());
        if (index < 0) {
            throw new CalciteSemanticException("Unexpected error: Cannot find column");
        }
        return this.rexBuilder.makeInputRef(TypeConverter.convert(colInfo.getType(), colInfo.isNullable(), this.rexBuilder.getTypeFactory()), index + offset);
    }

    private static RexNode toPrimitiveConstDesc(ColumnInfo colInfo, ObjectInspector inspector, RexBuilder rexBuilder) throws CalciteSemanticException {
        Object constant = ((ConstantObjectInspector)inspector).getWritableConstantValue();
        return rexBuilder.makeLiteral(constant, TypeConverter.convert(colInfo.getType(), rexBuilder.getTypeFactory()), false);
    }

    @Override
    protected RexNode createColumnRefExpr(ColumnInfo colInfo, RowResolver rowResolver, int offset) throws CalciteSemanticException {
        int index = rowResolver.getPosition(colInfo.getInternalName());
        return this.rexBuilder.makeInputRef(TypeConverter.convert(colInfo.getType(), this.rexBuilder.getTypeFactory()), index + offset);
    }

    @Override
    protected RexNode createColumnRefExpr(ColumnInfo colInfo, List<RowResolver> rowResolverList) throws SemanticException {
        int index = this.getPosition(colInfo, rowResolverList);
        return this.rexBuilder.makeInputRef(TypeConverter.convert(colInfo.getType(), this.rexBuilder.getTypeFactory()), index);
    }

    private int getPosition(ColumnInfo colInfo, List<RowResolver> rowResolverList) throws SemanticException {
        int position = 0;
        for (RowResolver rr : rowResolverList) {
            ColumnInfo tmp = rr.get(colInfo.getTabAlias(), colInfo.getAlias());
            if (tmp == null) {
                position += rr.getColumnInfos().size();
                continue;
            }
            return position += rr.getPosition(tmp.getInternalName());
        }
        throw new CalciteSemanticException("Could not resolve column name");
    }

    @Override
    protected RexNode createNullConstantExpr() {
        return this.rexBuilder.makeNullLiteral(this.rexBuilder.getTypeFactory().createSqlType(SqlTypeName.NULL));
    }

    @Override
    protected RexNode createDynamicParamExpr(int index) {
        return this.rexBuilder.makeDynamicParam(this.rexBuilder.getTypeFactory().createSqlType(SqlTypeName.NULL), index);
    }

    @Override
    protected RexNode createBooleanConstantExpr(String value) {
        Boolean b = value != null ? Boolean.valueOf(value) : null;
        return this.rexBuilder.makeLiteral((Object)b, this.rexBuilder.getTypeFactory().createSqlType(SqlTypeName.BOOLEAN), false);
    }

    @Override
    protected RexNode createBigintConstantExpr(String value) {
        return this.rexBuilder.makeLiteral((Object)new BigDecimal(Long.valueOf(value)), this.rexBuilder.getTypeFactory().createSqlType(SqlTypeName.BIGINT), false);
    }

    @Override
    protected RexNode createIntConstantExpr(String value) {
        return this.rexBuilder.makeLiteral((Object)new BigDecimal(Integer.valueOf(value)), this.rexBuilder.getTypeFactory().createSqlType(SqlTypeName.INTEGER), false);
    }

    @Override
    protected RexNode createSmallintConstantExpr(String value) {
        return this.rexBuilder.makeLiteral((Object)new BigDecimal(Short.valueOf(value).shortValue()), this.rexBuilder.getTypeFactory().createSqlType(SqlTypeName.SMALLINT), false);
    }

    @Override
    protected RexNode createTinyintConstantExpr(String value) {
        return this.rexBuilder.makeLiteral((Object)new BigDecimal(Byte.valueOf(value).byteValue()), this.rexBuilder.getTypeFactory().createSqlType(SqlTypeName.TINYINT), false);
    }

    @Override
    protected RexNode createFloatConstantExpr(String value) {
        Float f = Float.valueOf(value);
        return this.rexBuilder.makeApproxLiteral(new BigDecimal(Float.toString(f.floatValue())), this.rexBuilder.getTypeFactory().createSqlType(SqlTypeName.FLOAT));
    }

    @Override
    protected RexNode createDoubleConstantExpr(String value) throws SemanticException {
        Double d = Double.valueOf(value);
        if (Double.isNaN(d)) {
            throw new CalciteSemanticException("NaN", CalciteSemanticException.UnsupportedFeature.Invalid_decimal);
        }
        return this.rexBuilder.makeApproxLiteral(new BigDecimal(Double.toString(d)), this.rexBuilder.getTypeFactory().createSqlType(SqlTypeName.DOUBLE));
    }

    @Override
    protected RexNode createDecimalConstantExpr(String value, boolean allowNullValueConstantExpr) {
        HiveDecimal hd = HiveDecimal.create((String)value);
        if (!allowNullValueConstantExpr && hd == null) {
            return null;
        }
        BigDecimal bd = hd != null ? hd.bigDecimalValue() : null;
        DecimalTypeInfo type = this.adjustType(bd);
        return this.rexBuilder.makeExactLiteral(bd, TypeConverter.convert((PrimitiveTypeInfo)type, this.rexBuilder.getTypeFactory()));
    }

    @Override
    protected TypeInfo adjustConstantType(PrimitiveTypeInfo targetType, Object constantValue) {
        if (PrimitiveObjectInspectorUtils.decimalTypeEntry.equals(targetType.getPrimitiveTypeEntry())) {
            return this.adjustType((BigDecimal)constantValue);
        }
        return targetType;
    }

    private DecimalTypeInfo adjustType(BigDecimal bd) {
        int prec = 1;
        int scale = 0;
        if (bd != null && (prec = bd.precision()) < (scale = bd.scale())) {
            prec = scale;
        }
        return TypeInfoFactory.getDecimalTypeInfo((int)prec, (int)scale);
    }

    @Override
    protected Object interpretConstantAsPrimitive(PrimitiveTypeInfo targetType, Object constantValue, PrimitiveTypeInfo sourceType, boolean isEqual) {
        Object constantToInterpret = constantValue;
        if (constantValue instanceof NlsString) {
            constantToInterpret = ((NlsString)constantValue).getValue();
        }
        if (constantToInterpret instanceof Number || constantToInterpret instanceof String) {
            try {
                PrimitiveObjectInspectorUtils.PrimitiveTypeEntry primitiveTypeEntry = targetType.getPrimitiveTypeEntry();
                if (PrimitiveObjectInspectorUtils.intTypeEntry.equals(primitiveTypeEntry)) {
                    return this.toBigDecimal(constantToInterpret.toString()).intValueExact();
                }
                if (PrimitiveObjectInspectorUtils.longTypeEntry.equals(primitiveTypeEntry)) {
                    return this.toBigDecimal(constantToInterpret.toString()).longValueExact();
                }
                if (PrimitiveObjectInspectorUtils.doubleTypeEntry.equals(primitiveTypeEntry)) {
                    return this.toBigDecimal(constantToInterpret.toString());
                }
                if (PrimitiveObjectInspectorUtils.floatTypeEntry.equals(primitiveTypeEntry)) {
                    return this.toBigDecimal(constantToInterpret.toString());
                }
                if (PrimitiveObjectInspectorUtils.byteTypeEntry.equals(primitiveTypeEntry)) {
                    return this.toBigDecimal(constantToInterpret.toString()).byteValueExact();
                }
                if (PrimitiveObjectInspectorUtils.shortTypeEntry.equals(primitiveTypeEntry)) {
                    return this.toBigDecimal(constantToInterpret.toString()).shortValueExact();
                }
                if (PrimitiveObjectInspectorUtils.decimalTypeEntry.equals(primitiveTypeEntry)) {
                    HiveDecimal decimal = HiveDecimal.create((String)constantToInterpret.toString());
                    return decimal != null ? decimal.bigDecimalValue() : null;
                }
            }
            catch (ArithmeticException | NumberFormatException nfe) {
                if (!isEqual && (constantToInterpret instanceof Number || NumberUtils.isNumber((String)constantToInterpret.toString()))) {
                    return constantToInterpret;
                }
                LOG.trace("Failed to narrow type of constant", (Throwable)nfe);
                return null;
            }
        }
        if (constantToInterpret instanceof BigDecimal) {
            return constantToInterpret;
        }
        String constTypeInfoName = sourceType.getTypeName();
        if (constTypeInfoName.equalsIgnoreCase("string")) {
            if (targetType instanceof CharTypeInfo) {
                int length;
                HiveChar newValue;
                String constValue = constantToInterpret.toString();
                HiveChar maxCharConst = new HiveChar(constValue, 255);
                if (maxCharConst.equals((Object)(newValue = new HiveChar(constValue, length = TypeInfoUtils.getCharacterLengthForType((PrimitiveTypeInfo)targetType))))) {
                    return RexNodeExprFactory.makeHiveUnicodeString(newValue.getValue());
                }
                return null;
            }
            if (targetType instanceof VarcharTypeInfo) {
                int length;
                HiveVarchar newValue;
                String constValue = constantToInterpret.toString();
                HiveVarchar maxCharConst = new HiveVarchar(constValue, 65535);
                if (maxCharConst.equals((Object)(newValue = new HiveVarchar(constValue, length = TypeInfoUtils.getCharacterLengthForType((PrimitiveTypeInfo)targetType))))) {
                    return RexNodeExprFactory.makeHiveUnicodeString(newValue.getValue());
                }
                return null;
            }
        }
        return constantValue;
    }

    private BigDecimal toBigDecimal(String val) {
        if (!NumberUtils.isNumber((String)val)) {
            throw new NumberFormatException("The given string is not a valid number: " + val);
        }
        return new BigDecimal(val.replaceAll("[dDfFlL]$", ""));
    }

    @Override
    protected RexLiteral createStringConstantExpr(String value) {
        RelDataType stringType = this.rexBuilder.getTypeFactory().createTypeWithCharsetAndCollation(this.rexBuilder.getTypeFactory().createSqlType(SqlTypeName.VARCHAR, Integer.MAX_VALUE), Charset.forName(ConversionUtil.NATIVE_UTF16_CHARSET_NAME), SqlCollation.IMPLICIT);
        return (RexLiteral)this.rexBuilder.makeLiteral((Object)RexNodeExprFactory.makeHiveUnicodeString(value), stringType, true);
    }

    @Override
    protected RexLiteral createDateConstantExpr(String value) {
        Date d = Date.valueOf((String)value);
        return this.rexBuilder.makeDateLiteral(DateString.fromDaysSinceEpoch((int)d.toEpochDay()));
    }

    @Override
    protected RexLiteral createTimestampConstantExpr(String value) {
        Timestamp t = Timestamp.valueOf((String)value);
        return (RexLiteral)this.rexBuilder.makeLiteral((Object)TimestampString.fromMillisSinceEpoch((long)t.toEpochMilli()).withNanos(t.getNanos()), this.rexBuilder.getTypeFactory().createSqlType(SqlTypeName.TIMESTAMP, this.rexBuilder.getTypeFactory().getTypeSystem().getDefaultPrecision(SqlTypeName.TIMESTAMP)), false);
    }

    @Override
    protected RexLiteral createTimestampLocalTimeZoneConstantExpr(String value, ZoneId zoneId) {
        TimestampString tsLocalTZString;
        TimestampTZ t = TimestampTZUtil.parse((String)value);
        if (value == null) {
            tsLocalTZString = null;
        } else {
            Instant i = t.getZonedDateTime().toInstant();
            tsLocalTZString = TimestampString.fromMillisSinceEpoch((long)i.toEpochMilli()).withNanos(i.getNano());
        }
        return this.rexBuilder.makeTimestampWithLocalTimeZoneLiteral(tsLocalTZString, this.rexBuilder.getTypeFactory().getTypeSystem().getDefaultPrecision(SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE));
    }

    @Override
    protected RexLiteral createIntervalYearMonthConstantExpr(String value) {
        BigDecimal totalMonths = BigDecimal.valueOf(HiveIntervalYearMonth.valueOf((String)value).getTotalMonths());
        return this.rexBuilder.makeIntervalLiteral(totalMonths, new SqlIntervalQualifier(TimeUnit.YEAR, TimeUnit.MONTH, new SqlParserPos(1, 1)));
    }

    @Override
    protected RexLiteral createIntervalDayTimeConstantExpr(String value) {
        HiveIntervalDayTime v = HiveIntervalDayTime.valueOf((String)value);
        BigDecimal secsValueBd = BigDecimal.valueOf(v.getTotalSeconds() * 1000L);
        BigDecimal nanosValueBd = BigDecimal.valueOf(v.getNanos(), 6);
        return this.rexBuilder.makeIntervalLiteral(secsValueBd.add(nanosValueBd), new SqlIntervalQualifier(TimeUnit.MILLISECOND, null, new SqlParserPos(1, 1)));
    }

    @Override
    protected RexLiteral createIntervalYearConstantExpr(String value) {
        HiveIntervalYearMonth v = new HiveIntervalYearMonth(Integer.parseInt(value), 0);
        BigDecimal totalMonths = BigDecimal.valueOf(v.getTotalMonths());
        return this.rexBuilder.makeIntervalLiteral(totalMonths, new SqlIntervalQualifier(TimeUnit.YEAR, TimeUnit.MONTH, new SqlParserPos(1, 1)));
    }

    @Override
    protected RexLiteral createIntervalMonthConstantExpr(String value) {
        BigDecimal totalMonths = BigDecimal.valueOf(Integer.parseInt(value));
        return this.rexBuilder.makeIntervalLiteral(totalMonths, new SqlIntervalQualifier(TimeUnit.YEAR, TimeUnit.MONTH, new SqlParserPos(1, 1)));
    }

    @Override
    protected RexLiteral createIntervalDayConstantExpr(String value) {
        HiveIntervalDayTime v = new HiveIntervalDayTime(Integer.parseInt(value), 0, 0, 0, 0);
        BigDecimal secsValueBd = BigDecimal.valueOf(v.getTotalSeconds() * 1000L);
        BigDecimal nanosValueBd = BigDecimal.valueOf(v.getNanos(), 6);
        return this.rexBuilder.makeIntervalLiteral(secsValueBd.add(nanosValueBd), new SqlIntervalQualifier(TimeUnit.MILLISECOND, null, new SqlParserPos(1, 1)));
    }

    @Override
    protected RexLiteral createIntervalHourConstantExpr(String value) {
        HiveIntervalDayTime v = new HiveIntervalDayTime(0, Integer.parseInt(value), 0, 0, 0);
        BigDecimal secsValueBd = BigDecimal.valueOf(v.getTotalSeconds() * 1000L);
        BigDecimal nanosValueBd = BigDecimal.valueOf(v.getNanos(), 6);
        return this.rexBuilder.makeIntervalLiteral(secsValueBd.add(nanosValueBd), new SqlIntervalQualifier(TimeUnit.MILLISECOND, null, new SqlParserPos(1, 1)));
    }

    @Override
    protected RexLiteral createIntervalMinuteConstantExpr(String value) {
        HiveIntervalDayTime v = new HiveIntervalDayTime(0, 0, Integer.parseInt(value), 0, 0);
        BigDecimal secsValueBd = BigDecimal.valueOf(v.getTotalSeconds() * 1000L);
        BigDecimal nanosValueBd = BigDecimal.valueOf(v.getNanos(), 6);
        return this.rexBuilder.makeIntervalLiteral(secsValueBd.add(nanosValueBd), new SqlIntervalQualifier(TimeUnit.MILLISECOND, null, new SqlParserPos(1, 1)));
    }

    @Override
    protected RexLiteral createIntervalSecondConstantExpr(String value) {
        BigDecimal bd = new BigDecimal(value);
        BigDecimal bdSeconds = new BigDecimal(bd.toBigInteger());
        BigDecimal bdNanos = bd.subtract(bdSeconds);
        HiveIntervalDayTime v = new HiveIntervalDayTime(0, 0, 0, bdSeconds.intValueExact(), bdNanos.multiply(NANOS_PER_SEC_BD).intValue());
        BigDecimal secsValueBd = BigDecimal.valueOf(v.getTotalSeconds() * 1000L);
        BigDecimal nanosValueBd = BigDecimal.valueOf(v.getNanos(), 6);
        return this.rexBuilder.makeIntervalLiteral(secsValueBd.add(nanosValueBd), new SqlIntervalQualifier(TimeUnit.MILLISECOND, null, new SqlParserPos(1, 1)));
    }

    @Override
    protected RexNode createStructExpr(TypeInfo typeInfo, List<RexNode> operands) throws CalciteSemanticException {
        assert (typeInfo instanceof StructTypeInfo);
        return this.rexBuilder.makeCall(TypeConverter.convert(typeInfo, this.rexBuilder.getTypeFactory()), (SqlOperator)SqlStdOperatorTable.ROW, operands);
    }

    @Override
    protected RexNode createConstantExpr(TypeInfo typeInfo, Object constantValue) throws CalciteSemanticException {
        if (typeInfo instanceof StructTypeInfo) {
            List typeList = ((StructTypeInfo)typeInfo).getAllStructFieldTypeInfos();
            List objectList = (List)constantValue;
            ArrayList<RexNode> operands = new ArrayList<RexNode>();
            for (int i = 0; i < typeList.size(); ++i) {
                operands.add(this.rexBuilder.makeLiteral(objectList.get(i), TypeConverter.convert((TypeInfo)typeList.get(i), this.rexBuilder.getTypeFactory()), false));
            }
            return this.rexBuilder.makeCall(TypeConverter.convert(typeInfo, this.rexBuilder.getTypeFactory()), (SqlOperator)SqlStdOperatorTable.ROW, operands);
        }
        RelDataType finalType = TypeConverter.convert(typeInfo, this.rexBuilder.getTypeFactory());
        boolean allowCast = finalType.getFamily() == SqlTypeFamily.CHARACTER;
        return this.rexBuilder.makeLiteral(constantValue, finalType, allowCast);
    }

    @Override
    protected RexNode createNestedColumnRefExpr(TypeInfo typeInfo, RexNode expr, String fieldName, Boolean isList) throws CalciteSemanticException {
        if (expr.getType().isStruct()) {
            return this.rexBuilder.makeFieldAccess(expr, fieldName, true);
        }
        if (expr.getType().getComponentType() != null) {
            RexNode wrap = this.rexBuilder.makeCall(expr.getType().getComponentType(), HiveComponentAccess.COMPONENT_ACCESS, Collections.singletonList(expr));
            return this.createNestedColumnRefExpr(typeInfo, wrap, fieldName, (Boolean)(expr.getType().getComponentType() instanceof ArraySqlType));
        }
        throw new CalciteSemanticException("Unexpected rexnode : " + expr.getClass().getCanonicalName());
    }

    @Override
    protected RexNode createFuncCallExpr(TypeInfo typeInfo, FunctionInfo functionInfo, String funcText, List<RexNode> inputs) throws SemanticException {
        RelDataType returnType = typeInfo != null ? TypeConverter.convert(typeInfo, this.rexBuilder.getTypeFactory()) : this.functionHelper.getReturnType(functionInfo, inputs);
        List<RexNode> newInputs = this.functionHelper.convertInputs(functionInfo, inputs, returnType);
        return this.functionHelper.getExpression(funcText, functionInfo, newInputs, returnType);
    }

    @Override
    protected RexNode createExprsListExpr() {
        return new HiveRexExprList();
    }

    @Override
    protected void addExprToExprsList(RexNode columnList, RexNode expr) {
        HiveRexExprList l = (HiveRexExprList)columnList;
        l.addExpression(expr);
    }

    @Override
    protected boolean isConstantExpr(Object o) {
        return o instanceof RexLiteral;
    }

    @Override
    protected boolean isFuncCallExpr(Object o) {
        return o instanceof RexCall;
    }

    @Override
    protected Object getConstantValue(RexNode expr) {
        if (expr.getType().getSqlTypeName() == SqlTypeName.ROW) {
            ArrayList<Comparable> res = new ArrayList<Comparable>();
            for (RexNode node : ((RexCall)expr).getOperands()) {
                res.add(((RexLiteral)node).getValue4());
            }
            return res;
        }
        return ((RexLiteral)expr).getValue4();
    }

    @Override
    protected String getConstantValueAsString(RexNode expr) {
        return (String)((RexLiteral)expr).getValueAs(String.class);
    }

    @Override
    protected boolean isColumnRefExpr(Object o) {
        return o instanceof RexNode && RexUtil.isReferenceOrAccess((RexNode)((RexNode)o), (boolean)true);
    }

    @Override
    protected String getColumnName(RexNode expr, RowResolver rowResolver) {
        int index = ((RexInputRef)expr).getIndex();
        return rowResolver.getColumnInfos().get(index).getInternalName();
    }

    @Override
    protected boolean isExprsListExpr(Object o) {
        return o instanceof HiveRexExprList;
    }

    @Override
    protected List<RexNode> getExprChildren(RexNode expr) {
        if (expr instanceof RexCall) {
            return ((RexCall)expr).getOperands();
        }
        if (expr instanceof HiveRexExprList) {
            return ((HiveRexExprList)expr).getExpressions();
        }
        return new ArrayList<RexNode>();
    }

    @Override
    protected TypeInfo getTypeInfo(RexNode expr) {
        return expr.isA(SqlKind.LITERAL) ? TypeConverter.convertLiteralType((RexLiteral)expr) : TypeConverter.convert(expr.getType());
    }

    @Override
    protected List<TypeInfo> getStructTypeInfoList(RexNode expr) {
        StructTypeInfo structTypeInfo = (StructTypeInfo)TypeConverter.convert(expr.getType());
        return structTypeInfo.getAllStructFieldTypeInfos();
    }

    @Override
    protected List<String> getStructNameList(RexNode expr) {
        StructTypeInfo structTypeInfo = (StructTypeInfo)TypeConverter.convert(expr.getType());
        return structTypeInfo.getAllStructFieldNames();
    }

    @Override
    protected boolean isORFuncCallExpr(RexNode expr) {
        return expr.isA(SqlKind.OR);
    }

    @Override
    protected boolean isANDFuncCallExpr(RexNode expr) {
        return expr.isA(SqlKind.AND);
    }

    @Override
    protected boolean isConsistentWithinQuery(FunctionInfo fi) {
        return this.functionHelper.isConsistentWithinQuery(fi);
    }

    @Override
    protected boolean isStateful(FunctionInfo fi) {
        return this.functionHelper.isStateful(fi);
    }

    @Override
    protected boolean isPOSITIVEFuncCallExpr(RexNode expr) {
        return expr.isA(SqlKind.PLUS_PREFIX);
    }

    @Override
    protected boolean isNEGATIVEFuncCallExpr(RexNode expr) {
        return expr.isA(SqlKind.MINUS_PREFIX);
    }

    @Override
    protected RexNode setTypeInfo(RexNode expr, TypeInfo type) throws CalciteSemanticException {
        RelDataType t = TypeConverter.convert(type, this.rexBuilder.getTypeFactory());
        if (expr instanceof RexCall) {
            RexCall call = (RexCall)expr;
            return this.rexBuilder.makeCall(t, call.getOperator(), call.getOperands());
        }
        if (expr instanceof RexInputRef) {
            RexInputRef inputRef = (RexInputRef)expr;
            return this.rexBuilder.makeInputRef(t, inputRef.getIndex());
        }
        if (expr instanceof RexLiteral) {
            RexLiteral literal = (RexLiteral)expr;
            return this.rexBuilder.makeLiteral((Object)RexLiteral.value((RexNode)literal), t, false);
        }
        throw new RuntimeException("Unsupported expression type: " + expr.getClass().getCanonicalName());
    }

    @Override
    protected boolean convertCASEIntoCOALESCEFuncCallExpr(FunctionInfo fi, List<RexNode> inputs) {
        return false;
    }

    @Override
    protected RexNode foldExpr(RexNode expr) {
        return this.functionHelper.foldExpression(expr);
    }

    @Override
    protected boolean isSTRUCTFuncCallExpr(RexNode expr) {
        return expr instanceof RexCall && ((RexCall)expr).getOperator() == SqlStdOperatorTable.ROW;
    }

    @Override
    protected boolean isAndFunction(FunctionInfo fi) {
        return this.functionHelper.isAndFunction(fi);
    }

    @Override
    protected boolean isOrFunction(FunctionInfo fi) {
        return this.functionHelper.isOrFunction(fi);
    }

    @Override
    protected boolean isInFunction(FunctionInfo fi) {
        return this.functionHelper.isInFunction(fi);
    }

    @Override
    protected boolean isCompareFunction(FunctionInfo fi) {
        return this.functionHelper.isCompareFunction(fi);
    }

    @Override
    protected boolean isEqualFunction(FunctionInfo fi) {
        return this.functionHelper.isEqualFunction(fi);
    }

    @Override
    protected boolean isNSCompareFunction(FunctionInfo fi) {
        return this.functionHelper.isNSCompareFunction(fi);
    }

    @Override
    protected boolean isConstantStruct(RexNode expr) {
        return expr.getType().getSqlTypeName() == SqlTypeName.ROW && HiveCalciteUtil.isLiteral(expr);
    }

    @Override
    protected RexNode createSubqueryExpr(TypeCheckCtx ctx, ASTNode expr, SubqueryType subqueryType, Object[] inputs) throws SemanticException {
        Map<ASTNode, QBSubQueryParseInfo> subqueryToRelNode = ctx.getSubqueryToRelNode();
        if (subqueryToRelNode == null) {
            throw new CalciteSubquerySemanticException(ErrorMsg.UNSUPPORTED_SUBQUERY_EXPRESSION.getMsg(" Currently SubQuery expressions are only allowed as Where and Having Clause predicates"));
        }
        ASTNode subqueryOp = (ASTNode)expr.getChild(0);
        RelNode subqueryRel = subqueryToRelNode.get(expr).getSubQueryRelNode();
        switch (subqueryType) {
            case EXISTS: {
                if (subqueryToRelNode.get(expr).hasFullAggregate()) {
                    return this.createConstantExpr((TypeInfo)TypeInfoFactory.booleanTypeInfo, true);
                }
                return RexSubQuery.exists((RelNode)subqueryRel);
            }
            case IN: {
                assert (inputs[2] != null);
                if (subqueryRel.getRowType().getFieldCount() > 1) {
                    throw new CalciteSubquerySemanticException(ErrorMsg.INVALID_SUBQUERY_EXPRESSION.getMsg("SubQuery can contain only 1 item in Select List."));
                }
                RexNode lhs = (RexNode)inputs[2];
                return RexSubQuery.in((RelNode)subqueryRel, (ImmutableList)ImmutableList.of((Object)lhs));
            }
            case SCALAR: {
                if (subqueryRel.getRowType().getFieldCount() != 1) {
                    throw new CalciteSubquerySemanticException(ErrorMsg.INVALID_SUBQUERY_EXPRESSION.getMsg("More than one column expression in subquery"));
                }
                if (subqueryRel.getRowType().getFieldCount() > 1) {
                    throw new CalciteSubquerySemanticException(ErrorMsg.INVALID_SUBQUERY_EXPRESSION.getMsg("SubQuery can contain only 1 item in Select List."));
                }
                return RexSubQuery.scalar((RelNode)subqueryRel);
            }
            case SOME: 
            case ALL: {
                assert (inputs[2] != null);
                RexNode lhs = (RexNode)inputs[2];
                return RexNodeExprFactory.convertSubquerySomeAll(subqueryRel.getCluster(), (ASTNode)subqueryOp.getChild(1), subqueryType, subqueryRel, lhs);
            }
        }
        return null;
    }

    @Override
    protected FunctionInfo getFunctionInfo(String funcName) throws SemanticException {
        return this.functionHelper.getFunctionInfo(funcName);
    }

    @Override
    protected RexNode replaceFieldNamesInStruct(RexNode expr, List<String> newFieldNames) {
        if (newFieldNames.isEmpty()) {
            return expr;
        }
        RexCall structCall = (RexCall)expr;
        List newTypes = structCall.operands.stream().map(RexNode::getType).collect(Collectors.toList());
        RelDataType newType = this.rexBuilder.getTypeFactory().createStructType(newTypes, newFieldNames);
        return this.rexBuilder.makeCall(newType, structCall.op, (List)structCall.operands);
    }

    private static void throwInvalidSubqueryError(ASTNode comparisonOp) throws SemanticException {
        throw new CalciteSubquerySemanticException(ErrorMsg.INVALID_SUBQUERY_EXPRESSION.getMsg("Invalid operator:" + comparisonOp.toString()));
    }

    public static RexNode convertSubquerySomeAll(RelOptCluster cluster, ASTNode comparisonOp, SubqueryType subqueryType, RelNode subqueryRel, RexNode rexNodeLhs) throws SemanticException {
        SqlQuantifyOperator quantifyOperator = null;
        switch (comparisonOp.getType()) {
            case 18: {
                if (subqueryType == SubqueryType.ALL) {
                    RexNodeExprFactory.throwInvalidSubqueryError(comparisonOp);
                }
                quantifyOperator = SqlStdOperatorTable.SOME_EQ;
                break;
            }
            case 418: {
                quantifyOperator = SqlStdOperatorTable.SOME_LT;
                break;
            }
            case 419: {
                quantifyOperator = SqlStdOperatorTable.SOME_LE;
                break;
            }
            case 21: {
                quantifyOperator = SqlStdOperatorTable.SOME_GT;
                break;
            }
            case 22: {
                quantifyOperator = SqlStdOperatorTable.SOME_GE;
                break;
            }
            case 426: {
                if (subqueryType == SubqueryType.SOME) {
                    RexNodeExprFactory.throwInvalidSubqueryError(comparisonOp);
                }
                quantifyOperator = SqlStdOperatorTable.SOME_NE;
                break;
            }
            default: {
                throw new CalciteSubquerySemanticException(ErrorMsg.INVALID_SUBQUERY_EXPRESSION.getMsg("Invalid operator:" + comparisonOp.toString()));
            }
        }
        if (subqueryType == SubqueryType.ALL) {
            quantifyOperator = SqlStdOperatorTable.some((SqlKind)quantifyOperator.comparisonKind.negateNullSafe());
        }
        RexNode someQuery = RexNodeExprFactory.getSomeSubquery(cluster, subqueryRel, rexNodeLhs, quantifyOperator);
        if (subqueryType == SubqueryType.ALL) {
            return cluster.getRexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.NOT, new RexNode[]{someQuery});
        }
        return someQuery;
    }

    private static RexNode getSomeSubquery(RelOptCluster cluster, RelNode subqueryRel, RexNode lhs, SqlQuantifyOperator quantifyOperator) {
        if (quantifyOperator == SqlStdOperatorTable.SOME_EQ) {
            return RexSubQuery.in((RelNode)subqueryRel, (ImmutableList)ImmutableList.of((Object)lhs));
        }
        if (quantifyOperator == SqlStdOperatorTable.SOME_NE) {
            RexSubQuery subQuery = RexSubQuery.in((RelNode)subqueryRel, (ImmutableList)ImmutableList.of((Object)lhs));
            return cluster.getRexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.NOT, new RexNode[]{subQuery});
        }
        return RexSubQuery.some((RelNode)subqueryRel, (ImmutableList)ImmutableList.of((Object)lhs), (SqlQuantifyOperator)quantifyOperator);
    }

    public static NlsString makeHiveUnicodeString(String text) {
        return new NlsString(text, ConversionUtil.NATIVE_UTF16_CHARSET_NAME, SqlCollation.IMPLICIT);
    }
}

