/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization.plugin.metastore;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.metastore.HMSHandler;
import org.apache.hadoop.hive.metastore.events.PreEventContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.security.UserGroupInformation;

public class HiveMetaStoreAuthzInfo {
    private final PreEventContext preEventContext;
    private final HiveOperationType operationType;
    private final List<HivePrivilegeObject> inputHObjs;
    private final List<HivePrivilegeObject> outputHObjs;
    private final String commandString;
    private final HiveAuthzContext hiveAuthzContext;

    public HiveMetaStoreAuthzInfo(PreEventContext preEventContext, HiveOperationType operationType, List<HivePrivilegeObject> inputHObjs, List<HivePrivilegeObject> outputHObjs, String commandString) {
        this.preEventContext = preEventContext;
        this.operationType = operationType;
        this.inputHObjs = inputHObjs;
        this.outputHObjs = outputHObjs;
        this.commandString = commandString;
        this.hiveAuthzContext = this.createHiveAuthzContext();
    }

    public HiveMetaStoreAuthzInfo(PreEventContext preEventContext, HiveOperationType operationType, List<HivePrivilegeObject> inputHObjs, List<HivePrivilegeObject> outputHObjs, String commandString, HiveAuthzContext hiveAuthzContext) {
        this.preEventContext = preEventContext;
        this.operationType = operationType;
        this.inputHObjs = inputHObjs;
        this.outputHObjs = outputHObjs;
        this.commandString = commandString;
        this.hiveAuthzContext = hiveAuthzContext;
    }

    public HiveOperationType getOperationType() {
        return this.operationType;
    }

    public List<HivePrivilegeObject> getInputHObjs() {
        return this.inputHObjs;
    }

    public List<HivePrivilegeObject> getOutputHObjs() {
        return this.outputHObjs;
    }

    public String getCommandString() {
        return this.commandString;
    }

    public HiveAuthzContext getHiveAuthzContext() {
        return this.hiveAuthzContext;
    }

    public PreEventContext getPreEventContext() {
        return this.preEventContext;
    }

    public UserGroupInformation getUGI() {
        try {
            return UserGroupInformation.getCurrentUser();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("HiveMetaStoreAuthzInfo= ").append("{");
        String eventType = this.preEventContext != null ? this.preEventContext.getEventType().name() : "";
        sb.append("eventType=").append(eventType);
        sb.append(", operationType=").append(this.operationType.name());
        sb.append(", commandString=").append(this.commandString);
        sb.append(", inputHObjs=").append(this.inputHObjs);
        sb.append(", outputHObjs=").append(this.outputHObjs);
        sb.append(" }");
        return sb.toString();
    }

    private HiveAuthzContext createHiveAuthzContext() {
        HiveAuthzContext.Builder builder = new HiveAuthzContext.Builder();
        builder.setCommandString(this.commandString);
        builder.setForwardedAddresses(new ArrayList<String>());
        String ipAddress = HMSHandler.getIPAddress();
        builder.setUserIpAddress(ipAddress);
        HiveAuthzContext ret = builder.build();
        return ret;
    }
}

