/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor.handler;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.ql.txn.compactor.FSRemover;
import org.apache.hadoop.hive.ql.txn.compactor.MetadataCache;
import org.apache.hadoop.hive.ql.txn.compactor.handler.AbortedTxnCleaner;
import org.apache.hadoop.hive.ql.txn.compactor.handler.CompactionCleaner;
import org.apache.hadoop.hive.ql.txn.compactor.handler.TaskHandler;

public class TaskHandlerFactory {
    private static final TaskHandlerFactory INSTANCE = new TaskHandlerFactory();

    public static TaskHandlerFactory getInstance() {
        return INSTANCE;
    }

    private TaskHandlerFactory() {
    }

    public List<TaskHandler> getHandlers(HiveConf conf, TxnStore txnHandler, MetadataCache metadataCache, boolean metricsEnabled, FSRemover fsRemover) {
        boolean useAbortHandler = MetastoreConf.getBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_CLEAN_ABORTS_USING_CLEANER);
        ArrayList<TaskHandler> taskHandlers = new ArrayList<TaskHandler>();
        taskHandlers.add(new CompactionCleaner(conf, txnHandler, metadataCache, metricsEnabled, fsRemover));
        if (useAbortHandler) {
            taskHandlers.add(new AbortedTxnCleaner(conf, txnHandler, metadataCache, metricsEnabled, fsRemover));
        }
        return taskHandlers;
    }
}

