/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.columnstats.merge;

import com.google.common.base.MoreObjects;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.hadoop.hive.common.histogram.KllHistogramEstimator;
import org.apache.hadoop.hive.common.ndv.NumDistinctValueEstimator;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Date;
import org.apache.hadoop.hive.metastore.api.DateColumnStatsData;
import org.apache.hadoop.hive.metastore.columnstats.ColumnsStatsUtils;
import org.apache.hadoop.hive.metastore.columnstats.cache.DateColumnStatsDataInspector;
import org.apache.hadoop.hive.metastore.columnstats.merge.ColumnStatsMerger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateColumnStatsMerger
extends ColumnStatsMerger<Date> {
    private static final Logger LOG = LoggerFactory.getLogger(DateColumnStatsMerger.class);

    @Override
    public void merge(ColumnStatisticsObj aggregateColStats, ColumnStatisticsObj newColStats) {
        Date highValue;
        LOG.debug("Merging statistics: [aggregateColStats:{}, newColStats: {}]", (Object)aggregateColStats, (Object)newColStats);
        DateColumnStatsDataInspector aggregateData = ColumnsStatsUtils.dateInspectorFromStats(aggregateColStats);
        DateColumnStatsDataInspector newData = ColumnsStatsUtils.dateInspectorFromStats(newColStats);
        Date lowValue = this.mergeLowValue(this.getLowValue(aggregateData), this.getLowValue(newData));
        if (lowValue != null) {
            aggregateData.setLowValue(lowValue);
        }
        if ((highValue = this.mergeHighValue(this.getHighValue(aggregateData), this.getHighValue(newData))) != null) {
            aggregateData.setHighValue(highValue);
        }
        aggregateData.setNumNulls(this.mergeNumNulls(aggregateData.getNumNulls(), newData.getNumNulls()));
        NumDistinctValueEstimator oldNDVEst = aggregateData.getNdvEstimator();
        NumDistinctValueEstimator newNDVEst = newData.getNdvEstimator();
        List<NumDistinctValueEstimator> ndvEstimatorsList = Arrays.asList(oldNDVEst, newNDVEst);
        aggregateData.setNumDVs(this.mergeNumDistinctValueEstimator(aggregateColStats.getColName(), ndvEstimatorsList, aggregateData.getNumDVs(), newData.getNumDVs()));
        aggregateData.setNdvEstimator(ndvEstimatorsList.get(0));
        KllHistogramEstimator oldKllEst = aggregateData.getHistogramEstimator();
        KllHistogramEstimator newKllEst = newData.getHistogramEstimator();
        aggregateData.setHistogramEstimator(this.mergeHistogramEstimator(aggregateColStats.getColName(), oldKllEst, newKllEst));
        aggregateColStats.getStatsData().setDateStats((DateColumnStatsData)aggregateData);
    }

    public Date getLowValue(DateColumnStatsDataInspector data) {
        return data.isSetLowValue() ? data.getLowValue() : null;
    }

    public Date getHighValue(DateColumnStatsDataInspector data) {
        return data.isSetHighValue() ? data.getHighValue() : null;
    }

    @Override
    public Date mergeLowValue(Date oldValue, Date newValue) {
        if (oldValue != null && newValue != null) {
            return (Date)ObjectUtils.min((Comparable[])new Date[]{oldValue, newValue});
        }
        if (oldValue != null || newValue != null) {
            return (Date)MoreObjects.firstNonNull((Object)oldValue, (Object)newValue);
        }
        return null;
    }

    @Override
    public Date mergeHighValue(Date oldValue, Date newValue) {
        if (oldValue != null && newValue != null) {
            return (Date)ObjectUtils.max((Comparable[])new Date[]{oldValue, newValue});
        }
        if (oldValue != null || newValue != null) {
            return (Date)MoreObjects.firstNonNull((Object)oldValue, (Object)newValue);
        }
        return null;
    }
}

