/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.parser;

import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.parser.ExpressionTree;
import org.apache.hadoop.hive.metastore.parser.PartFilterVisitor;
import org.apache.hadoop.hive.metastore.parser.PartitionFilterLexer;
import org.apache.hadoop.hive.metastore.parser.PartitionFilterParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartFilterParser {
    private static final Logger LOG = LoggerFactory.getLogger(PartFilterParser.class);

    public static ExpressionTree parseFilter(String filter) throws MetaException {
        LOG.debug("Parsing filter: " + filter);
        UpperCaseCharStream upperCaseCharStream = new UpperCaseCharStream(CharStreams.fromString((String)filter));
        PartitionFilterLexer lexer = new PartitionFilterLexer(upperCaseCharStream);
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)ParseErrorListener.INSTANCE);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        PartitionFilterParser parser = new PartitionFilterParser((TokenStream)tokenStream);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)ParseErrorListener.INSTANCE);
        PartFilterVisitor visitor = new PartFilterVisitor();
        try {
            return visitor.visitFilter(parser.filter());
        }
        catch (ParseCancellationException e) {
            throw new MetaException("Error parsing partition filter: " + e.getMessage());
        }
    }

    private static class UpperCaseCharStream
    implements CharStream {
        private CodePointCharStream wrapped;

        UpperCaseCharStream(CodePointCharStream wrapped) {
            this.wrapped = wrapped;
        }

        public String getText(Interval interval) {
            return this.wrapped.getText(interval);
        }

        public void consume() {
            this.wrapped.consume();
        }

        public int LA(int i) {
            int la = this.wrapped.LA(i);
            if (la == 0 || la == -1) {
                return la;
            }
            return Character.toUpperCase(la);
        }

        public int mark() {
            return this.wrapped.mark();
        }

        public void release(int i) {
            this.wrapped.release(i);
        }

        public int index() {
            return this.wrapped.index();
        }

        public void seek(int i) {
            this.wrapped.seek(i);
        }

        public int size() {
            return this.wrapped.size();
        }

        public String getSourceName() {
            return this.wrapped.getSourceName();
        }
    }

    private static class ParseErrorListener
    extends BaseErrorListener {
        public static final ParseErrorListener INSTANCE = new ParseErrorListener();

        private ParseErrorListener() {
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) throws ParseCancellationException {
            throw new ParseCancellationException("lexer error: " + msg);
        }
    }
}

