/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.parser.impl;

import com.google.common.collect.ImmutableList;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.calcite.avatica.util.Casing;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.runtime.CalciteContextException;
import org.apache.calcite.sql.JoinConditionType;
import org.apache.calcite.sql.JoinType;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlAlter;
import org.apache.calcite.sql.SqlBasicTypeNameSpec;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlBinaryStringLiteral;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlCollation;
import org.apache.calcite.sql.SqlCollectionTypeNameSpec;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlDelete;
import org.apache.calcite.sql.SqlDescribeSchema;
import org.apache.calcite.sql.SqlDescribeTable;
import org.apache.calcite.sql.SqlDynamicParam;
import org.apache.calcite.sql.SqlExplain;
import org.apache.calcite.sql.SqlExplainFormat;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlGroupedWindowFunction;
import org.apache.calcite.sql.SqlHint;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlInsert;
import org.apache.calcite.sql.SqlInsertKeyword;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlJdbcDataTypeName;
import org.apache.calcite.sql.SqlJdbcFunctionCall;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlJsonConstructorNullClause;
import org.apache.calcite.sql.SqlJsonEmptyOrError;
import org.apache.calcite.sql.SqlJsonEncoding;
import org.apache.calcite.sql.SqlJsonExistsErrorBehavior;
import org.apache.calcite.sql.SqlJsonQueryEmptyOrErrorBehavior;
import org.apache.calcite.sql.SqlJsonQueryWrapperBehavior;
import org.apache.calcite.sql.SqlJsonValueEmptyOrErrorBehavior;
import org.apache.calcite.sql.SqlJsonValueReturning;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlMatchRecognize;
import org.apache.calcite.sql.SqlMerge;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlNumericLiteral;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOrderBy;
import org.apache.calcite.sql.SqlPivot;
import org.apache.calcite.sql.SqlPostfixOperator;
import org.apache.calcite.sql.SqlPrefixOperator;
import org.apache.calcite.sql.SqlRowTypeNameSpec;
import org.apache.calcite.sql.SqlSampleSpec;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlSelectKeyword;
import org.apache.calcite.sql.SqlSetOption;
import org.apache.calcite.sql.SqlSnapshot;
import org.apache.calcite.sql.SqlTableRef;
import org.apache.calcite.sql.SqlTypeNameSpec;
import org.apache.calcite.sql.SqlUnnestOperator;
import org.apache.calcite.sql.SqlUnpivot;
import org.apache.calcite.sql.SqlUpdate;
import org.apache.calcite.sql.SqlUserDefinedTypeNameSpec;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.SqlWindow;
import org.apache.calcite.sql.SqlWith;
import org.apache.calcite.sql.SqlWithItem;
import org.apache.calcite.sql.fun.SqlCase;
import org.apache.calcite.sql.fun.SqlInternalOperators;
import org.apache.calcite.sql.fun.SqlLibraryOperators;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.fun.SqlTrimFunction;
import org.apache.calcite.sql.parser.Span;
import org.apache.calcite.sql.parser.SqlAbstractParserImpl;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParserImplFactory;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.parser.SqlParserUtil;
import org.apache.calcite.sql.parser.impl.ParseException;
import org.apache.calcite.sql.parser.impl.SimpleCharStream;
import org.apache.calcite.sql.parser.impl.SqlParserImplConstants;
import org.apache.calcite.sql.parser.impl.SqlParserImplTokenManager;
import org.apache.calcite.sql.parser.impl.Token;
import org.apache.calcite.sql.parser.impl.TokenMgrError;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.SourceStringReader;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.trace.CalciteTrace;
import org.slf4j.Logger;

public class SqlParserImpl
extends SqlAbstractParserImpl
implements SqlParserImplConstants {
    private static final Logger LOGGER = CalciteTrace.getParserTracer();
    private static final char BACKSLASH = '\\';
    private static final char DOUBLE_QUOTE = '\"';
    private static final String DQ = "\"";
    private static final String DQDQ = "\"\"";
    private static final SqlLiteral LITERAL_ZERO = SqlLiteral.createExactNumeric("0", SqlParserPos.ZERO);
    private static final SqlLiteral LITERAL_ONE = SqlLiteral.createExactNumeric("1", SqlParserPos.ZERO);
    private static final SqlLiteral LITERAL_MINUS_ONE = SqlLiteral.createExactNumeric("-1", SqlParserPos.ZERO);
    private static SqlAbstractParserImpl.Metadata metadata;
    private Casing unquotedCasing;
    private Casing quotedCasing;
    private int identifierMaxLength;
    private SqlConformance conformance;
    public static final SqlParserImplFactory FACTORY;
    public SqlParserImplTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[411];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private static int[] jj_la1_3;
    private static int[] jj_la1_4;
    private static int[] jj_la1_5;
    private static int[] jj_la1_6;
    private static int[] jj_la1_7;
    private static int[] jj_la1_8;
    private static int[] jj_la1_9;
    private static int[] jj_la1_10;
    private static int[] jj_la1_11;
    private static int[] jj_la1_12;
    private static int[] jj_la1_13;
    private static int[] jj_la1_14;
    private static int[] jj_la1_15;
    private static int[] jj_la1_16;
    private static int[] jj_la1_17;
    private static int[] jj_la1_18;
    private static int[] jj_la1_19;
    private static int[] jj_la1_20;
    private static int[] jj_la1_21;
    private static int[] jj_la1_22;
    private static int[] jj_la1_23;
    private static int[] jj_la1_24;
    private final JJCalls[] jj_2_rtns = new JJCalls[105];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    @Override
    public SqlParseException normalizeException(Throwable ex) {
        try {
            if (ex instanceof ParseException) {
                ex = this.cleanupParseException((ParseException)ex);
            }
            return this.convertException(ex);
        }
        catch (ParseException e) {
            throw new AssertionError((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqlAbstractParserImpl.Metadata getMetadata() {
        Class<SqlParserImpl> clazz = SqlParserImpl.class;
        synchronized (SqlParserImpl.class) {
            if (metadata == null) {
                metadata = new SqlAbstractParserImpl.MetadataImpl(new SqlParserImpl(new StringReader("")));
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return metadata;
        }
    }

    @Override
    public void setTabSize(int tabSize) {
        this.jj_input_stream.setTabSize(tabSize);
    }

    @Override
    public void switchTo(SqlAbstractParserImpl.LexicalState state) {
        int stateOrdinal = Arrays.asList(SqlParserImplTokenManager.lexStateNames).indexOf(state.name());
        this.token_source.SwitchTo(stateOrdinal);
    }

    @Override
    public void setQuotedCasing(Casing quotedCasing) {
        this.quotedCasing = quotedCasing;
    }

    @Override
    public void setUnquotedCasing(Casing unquotedCasing) {
        this.unquotedCasing = unquotedCasing;
    }

    @Override
    public void setIdentifierMaxLength(int identifierMaxLength) {
        this.identifierMaxLength = identifierMaxLength;
    }

    @Override
    public void setConformance(SqlConformance conformance) {
        this.conformance = conformance;
    }

    @Override
    public SqlNode parseSqlExpressionEof() throws Exception {
        return this.SqlExpressionEof();
    }

    @Override
    public SqlNode parseSqlStmtEof() throws Exception {
        return this.SqlStmtEof();
    }

    @Override
    public SqlNodeList parseSqlStmtList() throws Exception {
        return this.SqlStmtList();
    }

    @Override
    public SqlNode parseArray() throws SqlParseException {
        this.switchTo(SqlAbstractParserImpl.LexicalState.BQID);
        try {
            return this.ArrayLiteral();
        }
        catch (ParseException ex) {
            throw this.normalizeException(ex);
        }
        catch (TokenMgrError ex) {
            throw this.normalizeException(ex);
        }
    }

    private SqlNode extend(SqlNode table, SqlNodeList extendList) {
        return SqlStdOperatorTable.EXTEND.createCall(Span.of(table, extendList).pos(), table, extendList);
    }

    private TimeUnit warn(TimeUnit timeUnit) throws ParseException {
        String token = this.getToken((int)0).image.toUpperCase(Locale.ROOT);
        this.warnings.add(SqlUtil.newContextException(this.getPos(), Static.RESOURCE.nonStandardFeatureUsed(token)));
        return timeUnit;
    }

    void debug_message1() throws ParseException {
        LOGGER.info("{} , {}", (Object)this.getToken((int)0).image, (Object)this.getToken((int)1).image);
    }

    String unquotedIdentifier() throws ParseException {
        return SqlParserUtil.toCase(this.getToken((int)0).image, this.unquotedCasing);
    }

    public final SqlNode ExtendedTableRef() throws ParseException {
        this.UnusedExtension();
        return null;
    }

    public final SqlNode TableOverOpt() throws ParseException {
        return null;
    }

    public final void SqlSelectKeywords(List<SqlLiteral> keywords) throws ParseException {
        this.E();
    }

    public final void SqlInsertKeywords(List<SqlLiteral> keywords) throws ParseException {
        this.E();
    }

    public final SqlNode FloorCeilOptions(Span s, boolean floorFlag) throws ParseException {
        SqlNode node = this.StandardFloorCeilOptions(s, floorFlag);
        return node;
    }

    void E() throws ParseException {
    }

    List startList(Object o) throws ParseException {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(o);
        return list;
    }

    @Override
    protected SqlParserPos getPos() throws ParseException {
        return new SqlParserPos(this.token.beginLine, this.token.beginColumn, this.token.endLine, this.token.endColumn);
    }

    Span span() throws ParseException {
        return Span.of(this.getPos());
    }

    void checkQueryExpression(SqlAbstractParserImpl.ExprContext exprContext) throws ParseException {
        switch (exprContext) {
            case ACCEPT_NON_QUERY: 
            case ACCEPT_SUB_QUERY: 
            case ACCEPT_CURSOR: {
                throw SqlUtil.newContextException(this.getPos(), Static.RESOURCE.illegalQueryExpression());
            }
        }
    }

    void checkNonQueryExpression(SqlAbstractParserImpl.ExprContext exprContext) throws ParseException {
        switch (exprContext) {
            case ACCEPT_QUERY: {
                throw SqlUtil.newContextException(this.getPos(), Static.RESOURCE.illegalNonQueryExpression());
            }
        }
    }

    SqlNode checkNotJoin(SqlNode e) throws ParseException {
        if (e instanceof SqlJoin) {
            throw SqlUtil.newContextException(e.getParserPosition(), Static.RESOURCE.illegalJoinExpression());
        }
        return e;
    }

    SqlParseException convertException(Throwable ex) throws ParseException {
        if (ex instanceof SqlParseException) {
            return (SqlParseException)ex;
        }
        SqlParserPos pos = null;
        int[][] expectedTokenSequences = null;
        String[] tokenImage = null;
        if (ex instanceof ParseException) {
            ParseException pex = (ParseException)ex;
            expectedTokenSequences = pex.expectedTokenSequences;
            tokenImage = pex.tokenImage;
            if (pex.currentToken != null) {
                Token token = pex.currentToken.next;
                if (!token.image.equals("1") && this.getMetadata().isKeyword(token.image) && SqlParserUtil.allowsIdentifier(tokenImage, expectedTokenSequences)) {
                    String expecting = ex.getMessage().substring(ex.getMessage().indexOf("Was expecting"));
                    String errorMsg = String.format("Incorrect syntax near the keyword '%s' at line %d, column %d.\n%s", token.image, token.beginLine, token.beginColumn, expecting);
                    ex = new ParseException(errorMsg);
                }
                pos = new SqlParserPos(token.beginLine, token.beginColumn, token.endLine, token.endColumn);
            }
        } else if (ex instanceof TokenMgrError) {
            expectedTokenSequences = null;
            tokenImage = null;
            Pattern pattern = Pattern.compile("(?s)Lexical error at line ([0-9]+), column ([0-9]+).*");
            Matcher matcher = pattern.matcher(ex.getMessage());
            if (matcher.matches()) {
                int line = Integer.parseInt(matcher.group(1));
                int column = Integer.parseInt(matcher.group(2));
                pos = new SqlParserPos(line, column, line, column);
            }
        } else if (ex instanceof CalciteContextException) {
            CalciteContextException ece = (CalciteContextException)ex;
            pos = new SqlParserPos(ece.getPosLine(), ece.getPosColumn(), ece.getEndPosLine(), ece.getEndPosColumn());
            ex = ece.getCause();
        }
        return new SqlParseException(ex.getMessage(), pos, expectedTokenSequences, tokenImage, ex);
    }

    ParseException cleanupParseException(ParseException ex) throws ParseException {
        if (ex.expectedTokenSequences == null) {
            return ex;
        }
        int iIdentifier = Arrays.asList(ex.tokenImage).indexOf("<IDENTIFIER>");
        ArrayList<int[]> prefixList = new ArrayList<int[]>();
        for (int i = 0; i < ex.expectedTokenSequences.length; ++i) {
            int[] seq = ex.expectedTokenSequences[i];
            int j = seq.length - 1;
            int i1 = seq[j];
            if (i1 != iIdentifier) continue;
            int[] prefix = new int[j];
            System.arraycopy(seq, 0, prefix, 0, j);
            prefixList.add(prefix);
        }
        if (prefixList.isEmpty()) {
            return ex;
        }
        int[][] prefixes = (int[][])prefixList.toArray((T[])new int[prefixList.size()][]);
        ArrayList<int[]> list = new ArrayList<int[]>();
        SqlAbstractParserImpl.Metadata metadata = this.getMetadata();
        for (int i = 0; i < ex.expectedTokenSequences.length; ++i) {
            int[] seq = ex.expectedTokenSequences[i];
            String tokenImage = ex.tokenImage[seq[seq.length - 1]];
            String token = SqlParserUtil.getTokenVal(tokenImage);
            if (token == null || !metadata.isNonReservedKeyword(token)) {
                list.add(seq);
                continue;
            }
            boolean match = this.matchesPrefix(seq, prefixes);
            if (match) continue;
            list.add(seq);
        }
        ex.expectedTokenSequences = (int[][])list.toArray((T[])new int[list.size()][]);
        return ex;
    }

    boolean matchesPrefix(int[] seq, int[][] prefixes) throws ParseException {
        block0: for (int[] prefix : prefixes) {
            if (seq.length != prefix.length + 1) continue;
            for (int k = 0; k < prefix.length; ++k) {
                if (prefix[k] != seq[k]) continue block0;
            }
            return true;
        }
        return false;
    }

    public final SqlNode ExprOrJoinOrOrderedQuery(SqlAbstractParserImpl.ExprContext exprContext) throws ParseException {
        ArrayList<Object> list = new ArrayList<Object>();
        if (this.jj_2_1(2)) {
            SqlNode e = this.Query(exprContext);
            e = this.OrderByLimitOpt(e);
            return e;
        }
        if (this.jj_2_2(1)) {
            SqlNode e = this.TableRef1(SqlAbstractParserImpl.ExprContext.ACCEPT_QUERY_OR_JOIN);
            block6: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 112: 
                    case 221: 
                    case 258: 
                    case 277: 
                    case 299: 
                    case 348: 
                    case 387: 
                    case 472: {
                        break;
                    }
                    default: {
                        this.jj_la1[0] = this.jj_gen;
                        break block6;
                    }
                }
                e = this.JoinTable(e);
            }
            list.add(e);
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 190: 
                    case 267: 
                    case 515: 
                    case 652: {
                        break;
                    }
                    default: {
                        this.jj_la1[1] = this.jj_gen;
                        break block7;
                    }
                }
                this.AddSetOpQuery(list, exprContext);
            }
            return SqlParserUtil.toTree(list);
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SqlNode OrderedQueryOrExpr(SqlAbstractParserImpl.ExprContext exprContext) throws ParseException {
        SqlNode e = this.QueryOrExpr(exprContext);
        e = this.OrderByLimitOpt(e);
        return e;
    }

    public final SqlNode OrderByLimitOpt(SqlNode e) throws ParseException {
        SqlNodeList orderBy;
        Span s = Span.of();
        SqlNode[] offsetFetch = new SqlNode[]{null, null};
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 382: {
                orderBy = this.OrderBy(e.isA(SqlKind.QUERY));
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
                orderBy = null;
            }
        }
        block3 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 203: 
            case 305: 
            case 372: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 305: {
                        this.LimitClause(s, offsetFetch);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 372: {
                                this.OffsetClause(s, offsetFetch);
                                break block3;
                            }
                        }
                        this.jj_la1[3] = this.jj_gen;
                        break block3;
                    }
                    case 372: {
                        this.OffsetClause(s, offsetFetch);
                        block14 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 203: 
                            case 305: {
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 305: {
                                        this.LimitClause(s, offsetFetch);
                                        if (this.conformance.isOffsetLimitAllowed()) break block3;
                                        throw SqlUtil.newContextException(s.end(this), Static.RESOURCE.offsetLimitNotAllowed());
                                    }
                                    case 203: {
                                        this.FetchClause(offsetFetch);
                                        break block14;
                                    }
                                    default: {
                                        this.jj_la1[4] = this.jj_gen;
                                        this.jj_consume_token(-1);
                                        throw new ParseException();
                                    }
                                }
                            }
                            default: {
                                this.jj_la1[5] = this.jj_gen;
                                break;
                            }
                        }
                        break block3;
                    }
                    case 203: {
                        this.FetchClause(offsetFetch);
                        break block3;
                    }
                    default: {
                        this.jj_la1[6] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
            }
        }
        if (orderBy != null || offsetFetch[0] != null || offsetFetch[1] != null) {
            return new SqlOrderBy(this.getPos(), e, Util.first(orderBy, SqlNodeList.EMPTY), offsetFetch[0], offsetFetch[1]);
        }
        return e;
    }

    public final void OffsetClause(Span s, SqlNode[] offsetFetch) throws ParseException {
        this.jj_consume_token(372);
        s.add(this);
        offsetFetch[0] = this.UnsignedNumericLiteralOrParam();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 481: 
            case 484: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 481: {
                        this.jj_consume_token(481);
                        break block0;
                    }
                    case 484: {
                        this.jj_consume_token(484);
                        break block0;
                    }
                }
                this.jj_la1[8] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[9] = this.jj_gen;
            }
        }
    }

    public final void FetchClause(SqlNode[] offsetFetch) throws ParseException {
        this.jj_consume_token(203);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 206: {
                this.jj_consume_token(206);
                break;
            }
            case 353: {
                this.jj_consume_token(353);
                break;
            }
            default: {
                this.jj_la1[10] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        offsetFetch[1] = this.UnsignedNumericLiteralOrParam();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 481: {
                this.jj_consume_token(481);
                break;
            }
            case 484: {
                this.jj_consume_token(484);
                break;
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(377);
    }

    public final void LimitClause(Span s, SqlNode[] offsetFetch) throws ParseException {
        this.jj_consume_token(305);
        s.add(this);
        if (this.jj_2_3(2)) {
            offsetFetch[0] = this.UnsignedNumericLiteralOrParam();
            this.jj_consume_token(727);
            offsetFetch[1] = this.UnsignedNumericLiteralOrParam();
            if (!this.conformance.isLimitStartCountAllowed()) {
                throw SqlUtil.newContextException(s.end(this), Static.RESOURCE.limitStartCountNotAllowed());
            }
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 700: 
                case 701: 
                case 702: 
                case 731: {
                    offsetFetch[1] = this.UnsignedNumericLiteralOrParam();
                    break;
                }
                case 10: {
                    this.jj_consume_token(10);
                    break;
                }
                default: {
                    this.jj_la1[12] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    public final SqlNode LeafQuery(SqlAbstractParserImpl.ExprContext exprContext) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 503: {
                this.checkQueryExpression(exprContext);
                SqlSelect e = this.SqlSelect();
                return e;
            }
            case 671: 
            case 672: {
                SqlNode e = this.TableConstructor();
                return e;
            }
            case 605: {
                SqlNode e = this.ExplicitTable(this.getPos());
                return e;
            }
        }
        this.jj_la1[13] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SqlNode ParenthesizedExpression(SqlAbstractParserImpl.ExprContext exprContext) throws ParseException {
        this.jj_consume_token(715);
        switch (exprContext) {
            case ACCEPT_SUB_QUERY: {
                exprContext = SqlAbstractParserImpl.ExprContext.ACCEPT_NONCURSOR;
                break;
            }
            case ACCEPT_CURSOR: {
                exprContext = SqlAbstractParserImpl.ExprContext.ACCEPT_ALL;
            }
        }
        SqlNode e = this.ExprOrJoinOrOrderedQuery(exprContext);
        this.jj_consume_token(716);
        exprContext.throwIfNotCompatible(e);
        return e;
    }

    public final SqlNodeList ParenthesizedQueryOrCommaList(SqlAbstractParserImpl.ExprContext exprContext) throws ParseException {
        ArrayList<SqlNode> list = new ArrayList<SqlNode>();
        SqlAbstractParserImpl.ExprContext firstExprContext = exprContext;
        this.jj_consume_token(715);
        Span s = this.span();
        switch (exprContext) {
            case ACCEPT_SUB_QUERY: {
                firstExprContext = SqlAbstractParserImpl.ExprContext.ACCEPT_NONCURSOR;
                break;
            }
            case ACCEPT_CURSOR: {
                firstExprContext = SqlAbstractParserImpl.ExprContext.ACCEPT_ALL;
            }
        }
        SqlNode e = this.OrderedQueryOrExpr(firstExprContext);
        list.add(e);
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 727: {
                    break;
                }
                default: {
                    this.jj_la1[14] = this.jj_gen;
                    break block7;
                }
            }
            this.jj_consume_token(727);
            this.checkNonQueryExpression(exprContext);
            this.AddExpression(list, exprContext);
        }
        this.jj_consume_token(716);
        return new SqlNodeList(list, s.end(this));
    }

    public final SqlNodeList ParenthesizedQueryOrCommaListWithDefault(SqlAbstractParserImpl.ExprContext exprContext) throws ParseException {
        Span s;
        ArrayList<SqlNode> list;
        block16: {
            SqlNode e;
            list = new ArrayList<SqlNode>();
            SqlAbstractParserImpl.ExprContext firstExprContext = exprContext;
            this.jj_consume_token(715);
            s = this.span();
            switch (exprContext) {
                case ACCEPT_SUB_QUERY: {
                    firstExprContext = SqlAbstractParserImpl.ExprContext.ACCEPT_NONCURSOR;
                    break;
                }
                case ACCEPT_CURSOR: {
                    firstExprContext = SqlAbstractParserImpl.ExprContext.ACCEPT_ALL;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 14: 
                case 17: 
                case 19: 
                case 20: 
                case 21: 
                case 24: 
                case 26: 
                case 27: 
                case 31: 
                case 32: 
                case 34: 
                case 35: 
                case 39: 
                case 47: 
                case 49: 
                case 52: 
                case 53: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 73: 
                case 74: 
                case 77: 
                case 78: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 86: 
                case 87: 
                case 88: 
                case 90: 
                case 92: 
                case 93: 
                case 95: 
                case 96: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 104: 
                case 105: 
                case 108: 
                case 109: 
                case 110: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 122: 
                case 123: 
                case 124: 
                case 126: 
                case 127: 
                case 128: 
                case 130: 
                case 131: 
                case 132: 
                case 133: 
                case 134: 
                case 135: 
                case 136: 
                case 138: 
                case 141: 
                case 145: 
                case 146: 
                case 147: 
                case 149: 
                case 150: 
                case 151: 
                case 153: 
                case 154: 
                case 156: 
                case 157: 
                case 159: 
                case 160: 
                case 162: 
                case 165: 
                case 167: 
                case 168: 
                case 170: 
                case 171: 
                case 174: 
                case 175: 
                case 177: 
                case 180: 
                case 185: 
                case 187: 
                case 189: 
                case 191: 
                case 192: 
                case 193: 
                case 196: 
                case 197: 
                case 201: 
                case 202: 
                case 205: 
                case 206: 
                case 207: 
                case 209: 
                case 210: 
                case 212: 
                case 214: 
                case 215: 
                case 216: 
                case 223: 
                case 224: 
                case 225: 
                case 226: 
                case 227: 
                case 230: 
                case 231: 
                case 233: 
                case 235: 
                case 236: 
                case 239: 
                case 241: 
                case 242: 
                case 243: 
                case 245: 
                case 246: 
                case 247: 
                case 248: 
                case 249: 
                case 252: 
                case 253: 
                case 254: 
                case 257: 
                case 260: 
                case 263: 
                case 264: 
                case 268: 
                case 269: 
                case 271: 
                case 273: 
                case 274: 
                case 275: 
                case 276: 
                case 278: 
                case 279: 
                case 280: 
                case 281: 
                case 282: 
                case 283: 
                case 284: 
                case 285: 
                case 286: 
                case 287: 
                case 288: 
                case 289: 
                case 290: 
                case 291: 
                case 294: 
                case 295: 
                case 297: 
                case 299: 
                case 300: 
                case 301: 
                case 302: 
                case 306: 
                case 308: 
                case 309: 
                case 310: 
                case 311: 
                case 312: 
                case 313: 
                case 315: 
                case 317: 
                case 319: 
                case 320: 
                case 324: 
                case 325: 
                case 326: 
                case 328: 
                case 329: 
                case 330: 
                case 331: 
                case 332: 
                case 333: 
                case 334: 
                case 335: 
                case 339: 
                case 340: 
                case 341: 
                case 342: 
                case 343: 
                case 344: 
                case 345: 
                case 346: 
                case 351: 
                case 352: 
                case 353: 
                case 357: 
                case 358: 
                case 359: 
                case 360: 
                case 361: 
                case 362: 
                case 363: 
                case 364: 
                case 365: 
                case 367: 
                case 369: 
                case 370: 
                case 379: 
                case 380: 
                case 383: 
                case 384: 
                case 385: 
                case 388: 
                case 391: 
                case 392: 
                case 393: 
                case 395: 
                case 396: 
                case 397: 
                case 398: 
                case 399: 
                case 400: 
                case 401: 
                case 403: 
                case 404: 
                case 405: 
                case 406: 
                case 407: 
                case 411: 
                case 412: 
                case 413: 
                case 414: 
                case 416: 
                case 417: 
                case 418: 
                case 419: 
                case 421: 
                case 423: 
                case 425: 
                case 428: 
                case 429: 
                case 431: 
                case 432: 
                case 434: 
                case 435: 
                case 436: 
                case 438: 
                case 439: 
                case 448: 
                case 452: 
                case 454: 
                case 455: 
                case 457: 
                case 458: 
                case 460: 
                case 461: 
                case 462: 
                case 465: 
                case 466: 
                case 467: 
                case 468: 
                case 469: 
                case 472: 
                case 473: 
                case 474: 
                case 477: 
                case 478: 
                case 479: 
                case 480: 
                case 481: 
                case 482: 
                case 483: 
                case 485: 
                case 488: 
                case 489: 
                case 490: 
                case 491: 
                case 493: 
                case 494: 
                case 495: 
                case 498: 
                case 499: 
                case 500: 
                case 501: 
                case 503: 
                case 504: 
                case 506: 
                case 507: 
                case 508: 
                case 509: 
                case 510: 
                case 511: 
                case 512: 
                case 514: 
                case 518: 
                case 519: 
                case 522: 
                case 523: 
                case 524: 
                case 525: 
                case 526: 
                case 532: 
                case 533: 
                case 534: 
                case 535: 
                case 536: 
                case 537: 
                case 538: 
                case 539: 
                case 540: 
                case 541: 
                case 542: 
                case 543: 
                case 544: 
                case 545: 
                case 546: 
                case 547: 
                case 548: 
                case 549: 
                case 550: 
                case 551: 
                case 552: 
                case 553: 
                case 554: 
                case 555: 
                case 556: 
                case 557: 
                case 558: 
                case 559: 
                case 560: 
                case 561: 
                case 562: 
                case 563: 
                case 564: 
                case 565: 
                case 566: 
                case 567: 
                case 568: 
                case 569: 
                case 570: 
                case 571: 
                case 572: 
                case 573: 
                case 574: 
                case 575: 
                case 576: 
                case 577: 
                case 578: 
                case 579: 
                case 580: 
                case 581: 
                case 583: 
                case 584: 
                case 586: 
                case 587: 
                case 589: 
                case 590: 
                case 591: 
                case 592: 
                case 595: 
                case 596: 
                case 599: 
                case 604: 
                case 605: 
                case 606: 
                case 608: 
                case 611: 
                case 612: 
                case 613: 
                case 614: 
                case 615: 
                case 616: 
                case 617: 
                case 618: 
                case 619: 
                case 624: 
                case 626: 
                case 627: 
                case 628: 
                case 629: 
                case 630: 
                case 631: 
                case 632: 
                case 637: 
                case 638: 
                case 639: 
                case 640: 
                case 642: 
                case 643: 
                case 645: 
                case 646: 
                case 648: 
                case 649: 
                case 650: 
                case 651: 
                case 653: 
                case 654: 
                case 655: 
                case 656: 
                case 659: 
                case 661: 
                case 662: 
                case 663: 
                case 664: 
                case 665: 
                case 666: 
                case 668: 
                case 669: 
                case 670: 
                case 671: 
                case 672: 
                case 674: 
                case 675: 
                case 679: 
                case 681: 
                case 683: 
                case 684: 
                case 690: 
                case 693: 
                case 694: 
                case 695: 
                case 696: 
                case 697: 
                case 698: 
                case 699: 
                case 700: 
                case 701: 
                case 702: 
                case 706: 
                case 707: 
                case 708: 
                case 709: 
                case 710: 
                case 712: 
                case 713: 
                case 715: 
                case 717: 
                case 718: 
                case 719: 
                case 720: 
                case 731: 
                case 737: 
                case 738: 
                case 763: 
                case 764: 
                case 765: 
                case 766: 
                case 767: 
                case 768: 
                case 770: {
                    e = this.OrderedQueryOrExpr(firstExprContext);
                    list.add(e);
                    break;
                }
                case 144: {
                    e = this.Default();
                    list.add(e);
                    break;
                }
                default: {
                    this.jj_la1[15] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            block15: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 727: {
                        break;
                    }
                    default: {
                        this.jj_la1[16] = this.jj_gen;
                        break block16;
                    }
                }
                this.jj_consume_token(727);
                this.checkNonQueryExpression(exprContext);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 14: 
                    case 17: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 24: 
                    case 26: 
                    case 27: 
                    case 31: 
                    case 32: 
                    case 34: 
                    case 35: 
                    case 39: 
                    case 47: 
                    case 49: 
                    case 52: 
                    case 53: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 73: 
                    case 74: 
                    case 77: 
                    case 78: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 86: 
                    case 87: 
                    case 88: 
                    case 90: 
                    case 92: 
                    case 93: 
                    case 95: 
                    case 96: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 104: 
                    case 105: 
                    case 108: 
                    case 109: 
                    case 110: 
                    case 114: 
                    case 115: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 119: 
                    case 120: 
                    case 122: 
                    case 123: 
                    case 124: 
                    case 126: 
                    case 127: 
                    case 128: 
                    case 130: 
                    case 131: 
                    case 132: 
                    case 133: 
                    case 134: 
                    case 135: 
                    case 136: 
                    case 138: 
                    case 141: 
                    case 145: 
                    case 146: 
                    case 147: 
                    case 149: 
                    case 150: 
                    case 151: 
                    case 153: 
                    case 154: 
                    case 156: 
                    case 157: 
                    case 159: 
                    case 160: 
                    case 162: 
                    case 165: 
                    case 167: 
                    case 168: 
                    case 170: 
                    case 171: 
                    case 174: 
                    case 175: 
                    case 177: 
                    case 180: 
                    case 185: 
                    case 187: 
                    case 189: 
                    case 191: 
                    case 192: 
                    case 193: 
                    case 196: 
                    case 197: 
                    case 201: 
                    case 202: 
                    case 205: 
                    case 206: 
                    case 207: 
                    case 209: 
                    case 210: 
                    case 212: 
                    case 214: 
                    case 215: 
                    case 216: 
                    case 223: 
                    case 224: 
                    case 225: 
                    case 226: 
                    case 227: 
                    case 230: 
                    case 231: 
                    case 233: 
                    case 235: 
                    case 236: 
                    case 239: 
                    case 241: 
                    case 242: 
                    case 243: 
                    case 245: 
                    case 246: 
                    case 247: 
                    case 248: 
                    case 249: 
                    case 252: 
                    case 253: 
                    case 254: 
                    case 257: 
                    case 260: 
                    case 263: 
                    case 264: 
                    case 268: 
                    case 269: 
                    case 271: 
                    case 273: 
                    case 274: 
                    case 275: 
                    case 276: 
                    case 278: 
                    case 279: 
                    case 280: 
                    case 281: 
                    case 282: 
                    case 283: 
                    case 284: 
                    case 285: 
                    case 286: 
                    case 287: 
                    case 288: 
                    case 289: 
                    case 290: 
                    case 291: 
                    case 294: 
                    case 295: 
                    case 297: 
                    case 299: 
                    case 300: 
                    case 301: 
                    case 302: 
                    case 306: 
                    case 308: 
                    case 309: 
                    case 310: 
                    case 311: 
                    case 312: 
                    case 313: 
                    case 315: 
                    case 317: 
                    case 319: 
                    case 320: 
                    case 324: 
                    case 325: 
                    case 326: 
                    case 328: 
                    case 329: 
                    case 330: 
                    case 331: 
                    case 332: 
                    case 333: 
                    case 334: 
                    case 335: 
                    case 339: 
                    case 340: 
                    case 341: 
                    case 342: 
                    case 343: 
                    case 344: 
                    case 345: 
                    case 346: 
                    case 351: 
                    case 352: 
                    case 353: 
                    case 357: 
                    case 358: 
                    case 359: 
                    case 360: 
                    case 361: 
                    case 362: 
                    case 363: 
                    case 364: 
                    case 365: 
                    case 367: 
                    case 369: 
                    case 370: 
                    case 379: 
                    case 380: 
                    case 383: 
                    case 384: 
                    case 385: 
                    case 388: 
                    case 391: 
                    case 392: 
                    case 393: 
                    case 395: 
                    case 396: 
                    case 397: 
                    case 398: 
                    case 399: 
                    case 400: 
                    case 401: 
                    case 403: 
                    case 404: 
                    case 405: 
                    case 406: 
                    case 407: 
                    case 411: 
                    case 412: 
                    case 413: 
                    case 414: 
                    case 416: 
                    case 417: 
                    case 418: 
                    case 419: 
                    case 421: 
                    case 423: 
                    case 425: 
                    case 428: 
                    case 429: 
                    case 431: 
                    case 432: 
                    case 434: 
                    case 435: 
                    case 436: 
                    case 438: 
                    case 439: 
                    case 448: 
                    case 452: 
                    case 454: 
                    case 455: 
                    case 457: 
                    case 458: 
                    case 460: 
                    case 461: 
                    case 462: 
                    case 465: 
                    case 466: 
                    case 467: 
                    case 468: 
                    case 469: 
                    case 472: 
                    case 473: 
                    case 474: 
                    case 477: 
                    case 478: 
                    case 479: 
                    case 480: 
                    case 481: 
                    case 482: 
                    case 483: 
                    case 485: 
                    case 488: 
                    case 489: 
                    case 490: 
                    case 491: 
                    case 493: 
                    case 494: 
                    case 495: 
                    case 498: 
                    case 499: 
                    case 500: 
                    case 501: 
                    case 504: 
                    case 506: 
                    case 507: 
                    case 508: 
                    case 509: 
                    case 510: 
                    case 511: 
                    case 512: 
                    case 514: 
                    case 518: 
                    case 519: 
                    case 522: 
                    case 523: 
                    case 524: 
                    case 525: 
                    case 526: 
                    case 532: 
                    case 533: 
                    case 534: 
                    case 535: 
                    case 536: 
                    case 537: 
                    case 538: 
                    case 539: 
                    case 540: 
                    case 541: 
                    case 542: 
                    case 543: 
                    case 544: 
                    case 545: 
                    case 546: 
                    case 547: 
                    case 548: 
                    case 549: 
                    case 550: 
                    case 551: 
                    case 552: 
                    case 553: 
                    case 554: 
                    case 555: 
                    case 556: 
                    case 557: 
                    case 558: 
                    case 559: 
                    case 560: 
                    case 561: 
                    case 562: 
                    case 563: 
                    case 564: 
                    case 565: 
                    case 566: 
                    case 567: 
                    case 568: 
                    case 569: 
                    case 570: 
                    case 571: 
                    case 572: 
                    case 573: 
                    case 574: 
                    case 575: 
                    case 576: 
                    case 577: 
                    case 578: 
                    case 579: 
                    case 580: 
                    case 581: 
                    case 583: 
                    case 584: 
                    case 586: 
                    case 587: 
                    case 589: 
                    case 590: 
                    case 591: 
                    case 592: 
                    case 595: 
                    case 596: 
                    case 599: 
                    case 604: 
                    case 606: 
                    case 608: 
                    case 611: 
                    case 612: 
                    case 613: 
                    case 614: 
                    case 615: 
                    case 616: 
                    case 617: 
                    case 618: 
                    case 619: 
                    case 624: 
                    case 626: 
                    case 627: 
                    case 628: 
                    case 629: 
                    case 630: 
                    case 631: 
                    case 632: 
                    case 637: 
                    case 638: 
                    case 639: 
                    case 640: 
                    case 642: 
                    case 643: 
                    case 645: 
                    case 646: 
                    case 648: 
                    case 649: 
                    case 650: 
                    case 651: 
                    case 653: 
                    case 654: 
                    case 655: 
                    case 656: 
                    case 659: 
                    case 661: 
                    case 662: 
                    case 663: 
                    case 664: 
                    case 665: 
                    case 666: 
                    case 668: 
                    case 669: 
                    case 670: 
                    case 674: 
                    case 675: 
                    case 679: 
                    case 681: 
                    case 683: 
                    case 684: 
                    case 693: 
                    case 694: 
                    case 695: 
                    case 696: 
                    case 697: 
                    case 698: 
                    case 699: 
                    case 700: 
                    case 701: 
                    case 702: 
                    case 706: 
                    case 707: 
                    case 708: 
                    case 709: 
                    case 710: 
                    case 712: 
                    case 713: 
                    case 715: 
                    case 717: 
                    case 718: 
                    case 719: 
                    case 720: 
                    case 731: 
                    case 737: 
                    case 738: 
                    case 763: 
                    case 764: 
                    case 765: 
                    case 766: 
                    case 767: 
                    case 768: 
                    case 770: {
                        e = this.Expression(exprContext);
                        list.add(e);
                        continue block15;
                    }
                    case 144: {
                        e = this.Default();
                        list.add(e);
                        continue block15;
                    }
                }
                break;
            }
            this.jj_la1[17] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(716);
        return new SqlNodeList(list, s.end(this));
    }

    public final List<SqlNode> UnquantifiedFunctionParameterList(SqlAbstractParserImpl.ExprContext exprContext) throws ParseException {
        List<SqlNode> args = this.FunctionParameterList(exprContext);
        args.remove(0);
        return args;
    }

    public final List<SqlNode> FunctionParameterList(SqlAbstractParserImpl.ExprContext exprContext) throws ParseException {
        ArrayList<SqlNode> list = new ArrayList<SqlNode>();
        this.jj_consume_token(715);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 10: 
            case 166: {
                SqlLiteral qualifier = this.AllOrDistinct();
                list.add(qualifier);
                break;
            }
            default: {
                this.jj_la1[18] = this.jj_gen;
                list.add(null);
            }
        }
        this.AddArg0(list, exprContext);
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 727: {
                    break;
                }
                default: {
                    this.jj_la1[19] = this.jj_gen;
                    break block6;
                }
            }
            this.jj_consume_token(727);
            this.checkNonQueryExpression(exprContext);
            this.AddArg(list, exprContext);
        }
        this.jj_consume_token(716);
        return list;
    }

    public final SqlLiteral AllOrDistinct() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 166: {
                this.jj_consume_token(166);
                return SqlSelectKeyword.DISTINCT.symbol(this.getPos());
            }
            case 10: {
                this.jj_consume_token(10);
                return SqlSelectKeyword.ALL.symbol(this.getPos());
            }
        }
        this.jj_la1[20] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final void AddArg0(List<SqlNode> list, SqlAbstractParserImpl.ExprContext exprContext) throws ParseException {
        SqlNode e;
        SqlIdentifier name;
        SqlAbstractParserImpl.ExprContext firstExprContext;
        switch (exprContext) {
            case ACCEPT_SUB_QUERY: {
                firstExprContext = SqlAbstractParserImpl.ExprContext.ACCEPT_NONCURSOR;
                break;
            }
            case ACCEPT_CURSOR: {
                firstExprContext = SqlAbstractParserImpl.ExprContext.ACCEPT_ALL;
                break;
            }
            default: {
                firstExprContext = exprContext;
            }
        }
        if (this.jj_2_4(2)) {
            name = this.SimpleIdentifier();
            this.jj_consume_token(743);
        } else {
            name = null;
        }
        block4 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 144: {
                e = this.Default();
                break;
            }
            default: {
                this.jj_la1[21] = this.jj_gen;
                if (this.jj_2_5(3)) {
                    e = this.TableParam();
                    break;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 14: 
                    case 17: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 24: 
                    case 26: 
                    case 27: 
                    case 31: 
                    case 32: 
                    case 34: 
                    case 35: 
                    case 39: 
                    case 47: 
                    case 49: 
                    case 52: 
                    case 53: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 73: 
                    case 74: 
                    case 77: 
                    case 78: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 86: 
                    case 87: 
                    case 88: 
                    case 90: 
                    case 92: 
                    case 93: 
                    case 95: 
                    case 96: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 104: 
                    case 105: 
                    case 108: 
                    case 109: 
                    case 110: 
                    case 114: 
                    case 115: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 119: 
                    case 120: 
                    case 122: 
                    case 123: 
                    case 124: 
                    case 126: 
                    case 127: 
                    case 128: 
                    case 130: 
                    case 131: 
                    case 132: 
                    case 133: 
                    case 134: 
                    case 135: 
                    case 136: 
                    case 138: 
                    case 141: 
                    case 145: 
                    case 146: 
                    case 147: 
                    case 149: 
                    case 150: 
                    case 151: 
                    case 153: 
                    case 154: 
                    case 156: 
                    case 157: 
                    case 159: 
                    case 160: 
                    case 162: 
                    case 165: 
                    case 167: 
                    case 168: 
                    case 170: 
                    case 171: 
                    case 174: 
                    case 175: 
                    case 177: 
                    case 180: 
                    case 185: 
                    case 187: 
                    case 189: 
                    case 191: 
                    case 192: 
                    case 193: 
                    case 196: 
                    case 197: 
                    case 201: 
                    case 202: 
                    case 205: 
                    case 206: 
                    case 207: 
                    case 209: 
                    case 210: 
                    case 212: 
                    case 214: 
                    case 215: 
                    case 216: 
                    case 223: 
                    case 224: 
                    case 225: 
                    case 226: 
                    case 227: 
                    case 230: 
                    case 231: 
                    case 233: 
                    case 235: 
                    case 236: 
                    case 239: 
                    case 241: 
                    case 242: 
                    case 243: 
                    case 245: 
                    case 246: 
                    case 247: 
                    case 248: 
                    case 249: 
                    case 252: 
                    case 253: 
                    case 254: 
                    case 257: 
                    case 260: 
                    case 263: 
                    case 264: 
                    case 268: 
                    case 269: 
                    case 271: 
                    case 273: 
                    case 274: 
                    case 275: 
                    case 276: 
                    case 278: 
                    case 279: 
                    case 280: 
                    case 281: 
                    case 282: 
                    case 283: 
                    case 284: 
                    case 285: 
                    case 286: 
                    case 287: 
                    case 288: 
                    case 289: 
                    case 290: 
                    case 291: 
                    case 294: 
                    case 295: 
                    case 297: 
                    case 299: 
                    case 300: 
                    case 301: 
                    case 302: 
                    case 306: 
                    case 308: 
                    case 309: 
                    case 310: 
                    case 311: 
                    case 312: 
                    case 313: 
                    case 315: 
                    case 317: 
                    case 319: 
                    case 320: 
                    case 324: 
                    case 325: 
                    case 326: 
                    case 328: 
                    case 329: 
                    case 330: 
                    case 331: 
                    case 332: 
                    case 333: 
                    case 334: 
                    case 335: 
                    case 339: 
                    case 340: 
                    case 341: 
                    case 342: 
                    case 343: 
                    case 344: 
                    case 345: 
                    case 346: 
                    case 351: 
                    case 352: 
                    case 353: 
                    case 357: 
                    case 358: 
                    case 359: 
                    case 360: 
                    case 361: 
                    case 362: 
                    case 363: 
                    case 364: 
                    case 365: 
                    case 367: 
                    case 369: 
                    case 370: 
                    case 379: 
                    case 380: 
                    case 383: 
                    case 384: 
                    case 385: 
                    case 388: 
                    case 391: 
                    case 392: 
                    case 393: 
                    case 395: 
                    case 396: 
                    case 397: 
                    case 398: 
                    case 399: 
                    case 400: 
                    case 401: 
                    case 403: 
                    case 404: 
                    case 405: 
                    case 406: 
                    case 407: 
                    case 411: 
                    case 412: 
                    case 413: 
                    case 414: 
                    case 416: 
                    case 417: 
                    case 418: 
                    case 419: 
                    case 421: 
                    case 423: 
                    case 425: 
                    case 428: 
                    case 429: 
                    case 431: 
                    case 432: 
                    case 434: 
                    case 435: 
                    case 436: 
                    case 438: 
                    case 439: 
                    case 448: 
                    case 452: 
                    case 454: 
                    case 455: 
                    case 457: 
                    case 458: 
                    case 460: 
                    case 461: 
                    case 462: 
                    case 465: 
                    case 466: 
                    case 467: 
                    case 468: 
                    case 469: 
                    case 472: 
                    case 473: 
                    case 474: 
                    case 477: 
                    case 478: 
                    case 479: 
                    case 480: 
                    case 481: 
                    case 482: 
                    case 483: 
                    case 485: 
                    case 488: 
                    case 489: 
                    case 490: 
                    case 491: 
                    case 493: 
                    case 494: 
                    case 495: 
                    case 498: 
                    case 499: 
                    case 500: 
                    case 501: 
                    case 503: 
                    case 504: 
                    case 506: 
                    case 507: 
                    case 508: 
                    case 509: 
                    case 510: 
                    case 511: 
                    case 512: 
                    case 514: 
                    case 518: 
                    case 519: 
                    case 522: 
                    case 523: 
                    case 524: 
                    case 525: 
                    case 526: 
                    case 532: 
                    case 533: 
                    case 534: 
                    case 535: 
                    case 536: 
                    case 537: 
                    case 538: 
                    case 539: 
                    case 540: 
                    case 541: 
                    case 542: 
                    case 543: 
                    case 544: 
                    case 545: 
                    case 546: 
                    case 547: 
                    case 548: 
                    case 549: 
                    case 550: 
                    case 551: 
                    case 552: 
                    case 553: 
                    case 554: 
                    case 555: 
                    case 556: 
                    case 557: 
                    case 558: 
                    case 559: 
                    case 560: 
                    case 561: 
                    case 562: 
                    case 563: 
                    case 564: 
                    case 565: 
                    case 566: 
                    case 567: 
                    case 568: 
                    case 569: 
                    case 570: 
                    case 571: 
                    case 572: 
                    case 573: 
                    case 574: 
                    case 575: 
                    case 576: 
                    case 577: 
                    case 578: 
                    case 579: 
                    case 580: 
                    case 581: 
                    case 583: 
                    case 584: 
                    case 586: 
                    case 587: 
                    case 589: 
                    case 590: 
                    case 591: 
                    case 592: 
                    case 595: 
                    case 596: 
                    case 599: 
                    case 604: 
                    case 605: 
                    case 606: 
                    case 608: 
                    case 611: 
                    case 612: 
                    case 613: 
                    case 614: 
                    case 615: 
                    case 616: 
                    case 617: 
                    case 618: 
                    case 619: 
                    case 624: 
                    case 626: 
                    case 627: 
                    case 628: 
                    case 629: 
                    case 630: 
                    case 631: 
                    case 632: 
                    case 637: 
                    case 638: 
                    case 639: 
                    case 640: 
                    case 642: 
                    case 643: 
                    case 645: 
                    case 646: 
                    case 648: 
                    case 649: 
                    case 650: 
                    case 651: 
                    case 653: 
                    case 654: 
                    case 655: 
                    case 656: 
                    case 659: 
                    case 661: 
                    case 662: 
                    case 663: 
                    case 664: 
                    case 665: 
                    case 666: 
                    case 668: 
                    case 669: 
                    case 670: 
                    case 671: 
                    case 672: 
                    case 674: 
                    case 675: 
                    case 679: 
                    case 681: 
                    case 683: 
                    case 684: 
                    case 690: 
                    case 693: 
                    case 694: 
                    case 695: 
                    case 696: 
                    case 697: 
                    case 698: 
                    case 699: 
                    case 700: 
                    case 701: 
                    case 702: 
                    case 706: 
                    case 707: 
                    case 708: 
                    case 709: 
                    case 710: 
                    case 712: 
                    case 713: 
                    case 715: 
                    case 717: 
                    case 718: 
                    case 719: 
                    case 720: 
                    case 731: 
                    case 737: 
                    case 738: 
                    case 763: 
                    case 764: 
                    case 765: 
                    case 766: 
                    case 767: 
                    case 768: 
                    case 770: {
                        e = this.PartitionedQueryOrQueryOrExpr(firstExprContext);
                        break block4;
                    }
                }
                this.jj_la1[22] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (name != null) {
            e = SqlStdOperatorTable.ARGUMENT_ASSIGNMENT.createCall(Span.of(name, e).pos(), e, name);
        }
        list.add(e);
    }

    public final void AddArg(List<SqlNode> list, SqlAbstractParserImpl.ExprContext exprContext) throws ParseException {
        SqlNode e;
        SqlIdentifier name;
        if (this.jj_2_6(2)) {
            name = this.SimpleIdentifier();
            this.jj_consume_token(743);
        } else {
            name = null;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 144: {
                e = this.Default();
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 39: 
            case 47: 
            case 49: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 74: 
            case 77: 
            case 78: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 86: 
            case 87: 
            case 88: 
            case 90: 
            case 92: 
            case 93: 
            case 95: 
            case 96: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 104: 
            case 105: 
            case 108: 
            case 109: 
            case 110: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 122: 
            case 123: 
            case 124: 
            case 126: 
            case 127: 
            case 128: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 138: 
            case 141: 
            case 145: 
            case 146: 
            case 147: 
            case 149: 
            case 150: 
            case 151: 
            case 153: 
            case 154: 
            case 156: 
            case 157: 
            case 159: 
            case 160: 
            case 162: 
            case 165: 
            case 167: 
            case 168: 
            case 170: 
            case 171: 
            case 174: 
            case 175: 
            case 177: 
            case 180: 
            case 185: 
            case 187: 
            case 189: 
            case 191: 
            case 192: 
            case 193: 
            case 196: 
            case 197: 
            case 201: 
            case 202: 
            case 205: 
            case 206: 
            case 207: 
            case 209: 
            case 210: 
            case 212: 
            case 214: 
            case 215: 
            case 216: 
            case 223: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 230: 
            case 231: 
            case 233: 
            case 235: 
            case 236: 
            case 239: 
            case 241: 
            case 242: 
            case 243: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 252: 
            case 253: 
            case 254: 
            case 257: 
            case 260: 
            case 263: 
            case 264: 
            case 268: 
            case 269: 
            case 271: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 278: 
            case 279: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 284: 
            case 285: 
            case 286: 
            case 287: 
            case 288: 
            case 289: 
            case 290: 
            case 291: 
            case 294: 
            case 295: 
            case 297: 
            case 299: 
            case 300: 
            case 301: 
            case 302: 
            case 306: 
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 313: 
            case 315: 
            case 317: 
            case 319: 
            case 320: 
            case 324: 
            case 325: 
            case 326: 
            case 328: 
            case 329: 
            case 330: 
            case 331: 
            case 332: 
            case 333: 
            case 334: 
            case 335: 
            case 339: 
            case 340: 
            case 341: 
            case 342: 
            case 343: 
            case 344: 
            case 345: 
            case 346: 
            case 351: 
            case 352: 
            case 353: 
            case 357: 
            case 358: 
            case 359: 
            case 360: 
            case 361: 
            case 362: 
            case 363: 
            case 364: 
            case 365: 
            case 367: 
            case 369: 
            case 370: 
            case 379: 
            case 380: 
            case 383: 
            case 384: 
            case 385: 
            case 388: 
            case 391: 
            case 392: 
            case 393: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 399: 
            case 400: 
            case 401: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 411: 
            case 412: 
            case 413: 
            case 414: 
            case 416: 
            case 417: 
            case 418: 
            case 419: 
            case 421: 
            case 423: 
            case 425: 
            case 428: 
            case 429: 
            case 431: 
            case 432: 
            case 434: 
            case 435: 
            case 436: 
            case 438: 
            case 439: 
            case 448: 
            case 452: 
            case 454: 
            case 455: 
            case 457: 
            case 458: 
            case 460: 
            case 461: 
            case 462: 
            case 465: 
            case 466: 
            case 467: 
            case 468: 
            case 469: 
            case 472: 
            case 473: 
            case 474: 
            case 477: 
            case 478: 
            case 479: 
            case 480: 
            case 481: 
            case 482: 
            case 483: 
            case 485: 
            case 488: 
            case 489: 
            case 490: 
            case 491: 
            case 493: 
            case 494: 
            case 495: 
            case 498: 
            case 499: 
            case 500: 
            case 501: 
            case 504: 
            case 506: 
            case 507: 
            case 508: 
            case 509: 
            case 510: 
            case 511: 
            case 512: 
            case 514: 
            case 518: 
            case 519: 
            case 522: 
            case 523: 
            case 524: 
            case 525: 
            case 526: 
            case 532: 
            case 533: 
            case 534: 
            case 535: 
            case 536: 
            case 537: 
            case 538: 
            case 539: 
            case 540: 
            case 541: 
            case 542: 
            case 543: 
            case 544: 
            case 545: 
            case 546: 
            case 547: 
            case 548: 
            case 549: 
            case 550: 
            case 551: 
            case 552: 
            case 553: 
            case 554: 
            case 555: 
            case 556: 
            case 557: 
            case 558: 
            case 559: 
            case 560: 
            case 561: 
            case 562: 
            case 563: 
            case 564: 
            case 565: 
            case 566: 
            case 567: 
            case 568: 
            case 569: 
            case 570: 
            case 571: 
            case 572: 
            case 573: 
            case 574: 
            case 575: 
            case 576: 
            case 577: 
            case 578: 
            case 579: 
            case 580: 
            case 581: 
            case 583: 
            case 584: 
            case 586: 
            case 587: 
            case 589: 
            case 590: 
            case 591: 
            case 592: 
            case 595: 
            case 596: 
            case 599: 
            case 604: 
            case 606: 
            case 608: 
            case 611: 
            case 612: 
            case 613: 
            case 614: 
            case 615: 
            case 616: 
            case 617: 
            case 618: 
            case 619: 
            case 624: 
            case 626: 
            case 627: 
            case 628: 
            case 629: 
            case 630: 
            case 631: 
            case 632: 
            case 637: 
            case 638: 
            case 639: 
            case 640: 
            case 642: 
            case 643: 
            case 645: 
            case 646: 
            case 648: 
            case 649: 
            case 650: 
            case 651: 
            case 653: 
            case 654: 
            case 655: 
            case 656: 
            case 659: 
            case 661: 
            case 662: 
            case 663: 
            case 664: 
            case 665: 
            case 666: 
            case 668: 
            case 669: 
            case 670: 
            case 674: 
            case 675: 
            case 679: 
            case 681: 
            case 683: 
            case 684: 
            case 693: 
            case 694: 
            case 695: 
            case 696: 
            case 697: 
            case 698: 
            case 699: 
            case 700: 
            case 701: 
            case 702: 
            case 706: 
            case 707: 
            case 708: 
            case 709: 
            case 710: 
            case 712: 
            case 713: 
            case 715: 
            case 717: 
            case 718: 
            case 719: 
            case 720: 
            case 731: 
            case 737: 
            case 738: 
            case 763: 
            case 764: 
            case 765: 
            case 766: 
            case 767: 
            case 768: 
            case 770: {
                e = this.Expression(exprContext);
                break;
            }
            case 605: {
                e = this.TableParam();
                break;
            }
            default: {
                this.jj_la1[23] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (name != null) {
            e = SqlStdOperatorTable.ARGUMENT_ASSIGNMENT.createCall(Span.of(name, e).pos(), e, name);
        }
        list.add(e);
    }

    public final SqlNode Default() throws ParseException {
        this.jj_consume_token(144);
        return SqlStdOperatorTable.DEFAULT.createCall(this.getPos(), new SqlNode[0]);
    }

    public final SqlNode SqlQueryEof() throws ParseException {
        SqlNode query = this.OrderedQueryOrExpr(SqlAbstractParserImpl.ExprContext.ACCEPT_QUERY);
        this.jj_consume_token(0);
        return query;
    }

    public final SqlNodeList SqlStmtList() throws ParseException {
        ArrayList<SqlNode> stmtList = new ArrayList<SqlNode>();
        SqlNode stmt = this.SqlStmt();
        stmtList.add(stmt);
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 725: {
                    break;
                }
                default: {
                    this.jj_la1[24] = this.jj_gen;
                    break block6;
                }
            }
            this.jj_consume_token(725);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 13: 
                case 14: 
                case 17: 
                case 19: 
                case 20: 
                case 21: 
                case 24: 
                case 26: 
                case 27: 
                case 31: 
                case 32: 
                case 34: 
                case 35: 
                case 39: 
                case 47: 
                case 49: 
                case 50: 
                case 52: 
                case 53: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 73: 
                case 74: 
                case 77: 
                case 78: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 86: 
                case 87: 
                case 88: 
                case 90: 
                case 92: 
                case 93: 
                case 95: 
                case 96: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 104: 
                case 105: 
                case 108: 
                case 109: 
                case 110: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 122: 
                case 123: 
                case 124: 
                case 126: 
                case 127: 
                case 128: 
                case 130: 
                case 131: 
                case 132: 
                case 133: 
                case 134: 
                case 135: 
                case 136: 
                case 138: 
                case 141: 
                case 145: 
                case 146: 
                case 147: 
                case 149: 
                case 150: 
                case 151: 
                case 152: 
                case 153: 
                case 154: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 162: 
                case 165: 
                case 167: 
                case 168: 
                case 170: 
                case 171: 
                case 174: 
                case 175: 
                case 177: 
                case 180: 
                case 185: 
                case 187: 
                case 189: 
                case 191: 
                case 192: 
                case 193: 
                case 196: 
                case 197: 
                case 198: 
                case 201: 
                case 202: 
                case 205: 
                case 206: 
                case 207: 
                case 209: 
                case 210: 
                case 212: 
                case 214: 
                case 215: 
                case 216: 
                case 223: 
                case 224: 
                case 225: 
                case 226: 
                case 227: 
                case 230: 
                case 231: 
                case 233: 
                case 235: 
                case 236: 
                case 239: 
                case 241: 
                case 242: 
                case 243: 
                case 245: 
                case 246: 
                case 247: 
                case 248: 
                case 249: 
                case 252: 
                case 253: 
                case 254: 
                case 257: 
                case 260: 
                case 262: 
                case 263: 
                case 264: 
                case 268: 
                case 269: 
                case 271: 
                case 273: 
                case 274: 
                case 275: 
                case 276: 
                case 278: 
                case 279: 
                case 280: 
                case 281: 
                case 282: 
                case 283: 
                case 284: 
                case 285: 
                case 286: 
                case 287: 
                case 288: 
                case 289: 
                case 290: 
                case 291: 
                case 294: 
                case 295: 
                case 297: 
                case 299: 
                case 300: 
                case 301: 
                case 302: 
                case 306: 
                case 308: 
                case 309: 
                case 310: 
                case 311: 
                case 312: 
                case 313: 
                case 315: 
                case 317: 
                case 319: 
                case 320: 
                case 323: 
                case 324: 
                case 325: 
                case 326: 
                case 328: 
                case 329: 
                case 330: 
                case 331: 
                case 332: 
                case 333: 
                case 334: 
                case 335: 
                case 339: 
                case 340: 
                case 341: 
                case 342: 
                case 343: 
                case 344: 
                case 345: 
                case 346: 
                case 351: 
                case 352: 
                case 353: 
                case 357: 
                case 358: 
                case 359: 
                case 360: 
                case 361: 
                case 362: 
                case 363: 
                case 364: 
                case 365: 
                case 367: 
                case 369: 
                case 370: 
                case 379: 
                case 380: 
                case 383: 
                case 384: 
                case 385: 
                case 388: 
                case 391: 
                case 392: 
                case 393: 
                case 395: 
                case 396: 
                case 397: 
                case 398: 
                case 399: 
                case 400: 
                case 401: 
                case 403: 
                case 404: 
                case 405: 
                case 406: 
                case 407: 
                case 411: 
                case 412: 
                case 413: 
                case 414: 
                case 416: 
                case 417: 
                case 418: 
                case 419: 
                case 421: 
                case 423: 
                case 425: 
                case 428: 
                case 429: 
                case 431: 
                case 432: 
                case 434: 
                case 435: 
                case 436: 
                case 438: 
                case 439: 
                case 448: 
                case 452: 
                case 454: 
                case 455: 
                case 457: 
                case 458: 
                case 459: 
                case 460: 
                case 461: 
                case 462: 
                case 465: 
                case 466: 
                case 467: 
                case 468: 
                case 469: 
                case 472: 
                case 473: 
                case 474: 
                case 477: 
                case 478: 
                case 479: 
                case 480: 
                case 481: 
                case 482: 
                case 483: 
                case 485: 
                case 488: 
                case 489: 
                case 490: 
                case 491: 
                case 493: 
                case 494: 
                case 495: 
                case 498: 
                case 499: 
                case 500: 
                case 501: 
                case 503: 
                case 504: 
                case 506: 
                case 507: 
                case 508: 
                case 509: 
                case 510: 
                case 511: 
                case 512: 
                case 513: 
                case 514: 
                case 518: 
                case 519: 
                case 522: 
                case 523: 
                case 524: 
                case 525: 
                case 526: 
                case 532: 
                case 533: 
                case 534: 
                case 535: 
                case 536: 
                case 537: 
                case 538: 
                case 539: 
                case 540: 
                case 541: 
                case 542: 
                case 543: 
                case 544: 
                case 545: 
                case 546: 
                case 547: 
                case 548: 
                case 549: 
                case 550: 
                case 551: 
                case 552: 
                case 553: 
                case 554: 
                case 555: 
                case 556: 
                case 557: 
                case 558: 
                case 559: 
                case 560: 
                case 561: 
                case 562: 
                case 563: 
                case 564: 
                case 565: 
                case 566: 
                case 567: 
                case 568: 
                case 569: 
                case 570: 
                case 571: 
                case 572: 
                case 573: 
                case 574: 
                case 575: 
                case 576: 
                case 577: 
                case 578: 
                case 579: 
                case 580: 
                case 581: 
                case 583: 
                case 584: 
                case 586: 
                case 587: 
                case 589: 
                case 590: 
                case 591: 
                case 592: 
                case 595: 
                case 596: 
                case 599: 
                case 604: 
                case 605: 
                case 606: 
                case 608: 
                case 611: 
                case 612: 
                case 613: 
                case 614: 
                case 615: 
                case 616: 
                case 617: 
                case 618: 
                case 619: 
                case 624: 
                case 626: 
                case 627: 
                case 628: 
                case 629: 
                case 630: 
                case 631: 
                case 632: 
                case 637: 
                case 638: 
                case 639: 
                case 640: 
                case 642: 
                case 643: 
                case 645: 
                case 646: 
                case 648: 
                case 649: 
                case 650: 
                case 651: 
                case 653: 
                case 654: 
                case 655: 
                case 656: 
                case 658: 
                case 659: 
                case 660: 
                case 661: 
                case 662: 
                case 663: 
                case 664: 
                case 665: 
                case 666: 
                case 668: 
                case 669: 
                case 670: 
                case 671: 
                case 672: 
                case 674: 
                case 675: 
                case 679: 
                case 681: 
                case 683: 
                case 684: 
                case 690: 
                case 693: 
                case 694: 
                case 695: 
                case 696: 
                case 697: 
                case 698: 
                case 699: 
                case 700: 
                case 701: 
                case 702: 
                case 706: 
                case 707: 
                case 708: 
                case 709: 
                case 710: 
                case 712: 
                case 713: 
                case 715: 
                case 717: 
                case 718: 
                case 719: 
                case 720: 
                case 731: 
                case 737: 
                case 738: 
                case 763: 
                case 764: 
                case 765: 
                case 766: 
                case 767: 
                case 768: 
                case 770: {
                    stmt = this.SqlStmt();
                    stmtList.add(stmt);
                    continue block6;
                }
            }
            this.jj_la1[25] = this.jj_gen;
        }
        this.jj_consume_token(0);
        return new SqlNodeList(stmtList, Span.of(stmtList).pos());
    }

    public final SqlNode SqlStmt() throws ParseException {
        SqlNode stmt;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 459: 
            case 513: {
                stmt = this.SqlSetOption(Span.of(), null);
                break;
            }
            case 13: {
                stmt = this.SqlAlter();
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 39: 
            case 47: 
            case 49: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 74: 
            case 77: 
            case 78: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 86: 
            case 87: 
            case 88: 
            case 90: 
            case 92: 
            case 93: 
            case 95: 
            case 96: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 104: 
            case 105: 
            case 108: 
            case 109: 
            case 110: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 122: 
            case 123: 
            case 124: 
            case 126: 
            case 127: 
            case 128: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 138: 
            case 141: 
            case 145: 
            case 146: 
            case 147: 
            case 149: 
            case 150: 
            case 151: 
            case 153: 
            case 154: 
            case 156: 
            case 157: 
            case 159: 
            case 160: 
            case 162: 
            case 165: 
            case 167: 
            case 168: 
            case 170: 
            case 171: 
            case 174: 
            case 175: 
            case 177: 
            case 180: 
            case 185: 
            case 187: 
            case 189: 
            case 191: 
            case 192: 
            case 193: 
            case 196: 
            case 197: 
            case 201: 
            case 202: 
            case 205: 
            case 206: 
            case 207: 
            case 209: 
            case 210: 
            case 212: 
            case 214: 
            case 215: 
            case 216: 
            case 223: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 230: 
            case 231: 
            case 233: 
            case 235: 
            case 236: 
            case 239: 
            case 241: 
            case 242: 
            case 243: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 252: 
            case 253: 
            case 254: 
            case 257: 
            case 260: 
            case 263: 
            case 264: 
            case 268: 
            case 269: 
            case 271: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 278: 
            case 279: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 284: 
            case 285: 
            case 286: 
            case 287: 
            case 288: 
            case 289: 
            case 290: 
            case 291: 
            case 294: 
            case 295: 
            case 297: 
            case 299: 
            case 300: 
            case 301: 
            case 302: 
            case 306: 
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 313: 
            case 315: 
            case 317: 
            case 319: 
            case 320: 
            case 324: 
            case 325: 
            case 326: 
            case 328: 
            case 329: 
            case 330: 
            case 331: 
            case 332: 
            case 333: 
            case 334: 
            case 335: 
            case 339: 
            case 340: 
            case 341: 
            case 342: 
            case 343: 
            case 344: 
            case 345: 
            case 346: 
            case 351: 
            case 352: 
            case 353: 
            case 357: 
            case 358: 
            case 359: 
            case 360: 
            case 361: 
            case 362: 
            case 363: 
            case 364: 
            case 365: 
            case 367: 
            case 369: 
            case 370: 
            case 379: 
            case 380: 
            case 383: 
            case 384: 
            case 385: 
            case 388: 
            case 391: 
            case 392: 
            case 393: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 399: 
            case 400: 
            case 401: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 411: 
            case 412: 
            case 413: 
            case 414: 
            case 416: 
            case 417: 
            case 418: 
            case 419: 
            case 421: 
            case 423: 
            case 425: 
            case 428: 
            case 429: 
            case 431: 
            case 432: 
            case 434: 
            case 435: 
            case 436: 
            case 438: 
            case 439: 
            case 448: 
            case 452: 
            case 454: 
            case 455: 
            case 457: 
            case 458: 
            case 460: 
            case 461: 
            case 462: 
            case 465: 
            case 466: 
            case 467: 
            case 468: 
            case 469: 
            case 472: 
            case 473: 
            case 474: 
            case 477: 
            case 478: 
            case 479: 
            case 480: 
            case 481: 
            case 482: 
            case 483: 
            case 485: 
            case 488: 
            case 489: 
            case 490: 
            case 491: 
            case 493: 
            case 494: 
            case 495: 
            case 498: 
            case 499: 
            case 500: 
            case 501: 
            case 503: 
            case 504: 
            case 506: 
            case 507: 
            case 508: 
            case 509: 
            case 510: 
            case 511: 
            case 512: 
            case 514: 
            case 518: 
            case 519: 
            case 522: 
            case 523: 
            case 524: 
            case 525: 
            case 526: 
            case 532: 
            case 533: 
            case 534: 
            case 535: 
            case 536: 
            case 537: 
            case 538: 
            case 539: 
            case 540: 
            case 541: 
            case 542: 
            case 543: 
            case 544: 
            case 545: 
            case 546: 
            case 547: 
            case 548: 
            case 549: 
            case 550: 
            case 551: 
            case 552: 
            case 553: 
            case 554: 
            case 555: 
            case 556: 
            case 557: 
            case 558: 
            case 559: 
            case 560: 
            case 561: 
            case 562: 
            case 563: 
            case 564: 
            case 565: 
            case 566: 
            case 567: 
            case 568: 
            case 569: 
            case 570: 
            case 571: 
            case 572: 
            case 573: 
            case 574: 
            case 575: 
            case 576: 
            case 577: 
            case 578: 
            case 579: 
            case 580: 
            case 581: 
            case 583: 
            case 584: 
            case 586: 
            case 587: 
            case 589: 
            case 590: 
            case 591: 
            case 592: 
            case 595: 
            case 596: 
            case 599: 
            case 604: 
            case 605: 
            case 606: 
            case 608: 
            case 611: 
            case 612: 
            case 613: 
            case 614: 
            case 615: 
            case 616: 
            case 617: 
            case 618: 
            case 619: 
            case 624: 
            case 626: 
            case 627: 
            case 628: 
            case 629: 
            case 630: 
            case 631: 
            case 632: 
            case 637: 
            case 638: 
            case 639: 
            case 640: 
            case 642: 
            case 643: 
            case 645: 
            case 646: 
            case 648: 
            case 649: 
            case 650: 
            case 651: 
            case 653: 
            case 654: 
            case 655: 
            case 656: 
            case 659: 
            case 661: 
            case 662: 
            case 663: 
            case 664: 
            case 665: 
            case 666: 
            case 668: 
            case 669: 
            case 670: 
            case 671: 
            case 672: 
            case 674: 
            case 675: 
            case 679: 
            case 681: 
            case 683: 
            case 684: 
            case 690: 
            case 693: 
            case 694: 
            case 695: 
            case 696: 
            case 697: 
            case 698: 
            case 699: 
            case 700: 
            case 701: 
            case 702: 
            case 706: 
            case 707: 
            case 708: 
            case 709: 
            case 710: 
            case 712: 
            case 713: 
            case 715: 
            case 717: 
            case 718: 
            case 719: 
            case 720: 
            case 731: 
            case 737: 
            case 738: 
            case 763: 
            case 764: 
            case 765: 
            case 766: 
            case 767: 
            case 768: 
            case 770: {
                stmt = this.OrderedQueryOrExpr(SqlAbstractParserImpl.ExprContext.ACCEPT_QUERY);
                break;
            }
            case 198: {
                stmt = this.SqlExplain();
                break;
            }
            case 158: {
                stmt = this.SqlDescribe();
                break;
            }
            case 262: 
            case 660: {
                stmt = this.SqlInsert();
                break;
            }
            case 152: {
                stmt = this.SqlDelete();
                break;
            }
            case 658: {
                stmt = this.SqlUpdate();
                break;
            }
            case 323: {
                stmt = this.SqlMerge();
                break;
            }
            case 50: {
                stmt = this.SqlProcedureCall();
                break;
            }
            default: {
                this.jj_la1[26] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return stmt;
    }

    public final SqlNode SqlStmtEof() throws ParseException {
        SqlNode stmt = this.SqlStmt();
        this.jj_consume_token(0);
        return stmt;
    }

    public final SqlNodeList ParenthesizedKeyValueOptionCommaList() throws ParseException {
        ArrayList<SqlNode> list = new ArrayList<SqlNode>();
        Span s = this.span();
        this.jj_consume_token(715);
        this.AddKeyValueOption(list);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 727: {
                    break;
                }
                default: {
                    this.jj_la1[27] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(727);
            this.AddKeyValueOption(list);
        }
        this.jj_consume_token(716);
        return new SqlNodeList(list, s.end(this));
    }

    public final void AddKeyValueOption(List<SqlNode> list) throws ParseException {
        SqlNode key;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 24: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 35: 
            case 39: 
            case 47: 
            case 49: 
            case 53: 
            case 57: 
            case 58: 
            case 61: 
            case 62: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 74: 
            case 78: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 86: 
            case 87: 
            case 88: 
            case 90: 
            case 92: 
            case 93: 
            case 95: 
            case 96: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 104: 
            case 128: 
            case 130: 
            case 131: 
            case 133: 
            case 135: 
            case 136: 
            case 138: 
            case 141: 
            case 145: 
            case 146: 
            case 147: 
            case 149: 
            case 150: 
            case 151: 
            case 154: 
            case 156: 
            case 157: 
            case 159: 
            case 160: 
            case 162: 
            case 165: 
            case 167: 
            case 168: 
            case 170: 
            case 171: 
            case 174: 
            case 175: 
            case 180: 
            case 185: 
            case 187: 
            case 191: 
            case 192: 
            case 193: 
            case 205: 
            case 206: 
            case 210: 
            case 212: 
            case 214: 
            case 215: 
            case 216: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 230: 
            case 231: 
            case 233: 
            case 235: 
            case 239: 
            case 241: 
            case 243: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 252: 
            case 253: 
            case 254: 
            case 257: 
            case 260: 
            case 263: 
            case 264: 
            case 271: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 278: 
            case 286: 
            case 287: 
            case 288: 
            case 289: 
            case 290: 
            case 294: 
            case 300: 
            case 301: 
            case 302: 
            case 310: 
            case 312: 
            case 313: 
            case 315: 
            case 320: 
            case 324: 
            case 325: 
            case 326: 
            case 328: 
            case 329: 
            case 330: 
            case 333: 
            case 334: 
            case 340: 
            case 341: 
            case 343: 
            case 344: 
            case 345: 
            case 346: 
            case 351: 
            case 357: 
            case 362: 
            case 364: 
            case 365: 
            case 367: 
            case 370: 
            case 379: 
            case 380: 
            case 383: 
            case 384: 
            case 385: 
            case 388: 
            case 392: 
            case 393: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 399: 
            case 400: 
            case 401: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 416: 
            case 417: 
            case 418: 
            case 419: 
            case 425: 
            case 428: 
            case 431: 
            case 432: 
            case 434: 
            case 435: 
            case 436: 
            case 439: 
            case 455: 
            case 457: 
            case 458: 
            case 460: 
            case 461: 
            case 462: 
            case 465: 
            case 466: 
            case 467: 
            case 468: 
            case 469: 
            case 473: 
            case 474: 
            case 477: 
            case 478: 
            case 479: 
            case 480: 
            case 482: 
            case 488: 
            case 489: 
            case 490: 
            case 491: 
            case 493: 
            case 494: 
            case 495: 
            case 499: 
            case 500: 
            case 501: 
            case 504: 
            case 506: 
            case 507: 
            case 508: 
            case 509: 
            case 510: 
            case 511: 
            case 514: 
            case 518: 
            case 519: 
            case 523: 
            case 524: 
            case 526: 
            case 532: 
            case 533: 
            case 534: 
            case 535: 
            case 536: 
            case 537: 
            case 538: 
            case 539: 
            case 540: 
            case 541: 
            case 542: 
            case 543: 
            case 544: 
            case 545: 
            case 546: 
            case 547: 
            case 548: 
            case 549: 
            case 550: 
            case 551: 
            case 552: 
            case 553: 
            case 554: 
            case 555: 
            case 556: 
            case 557: 
            case 558: 
            case 559: 
            case 560: 
            case 561: 
            case 562: 
            case 563: 
            case 564: 
            case 565: 
            case 566: 
            case 567: 
            case 568: 
            case 569: 
            case 570: 
            case 571: 
            case 572: 
            case 573: 
            case 574: 
            case 575: 
            case 576: 
            case 577: 
            case 578: 
            case 579: 
            case 580: 
            case 583: 
            case 584: 
            case 589: 
            case 590: 
            case 591: 
            case 592: 
            case 595: 
            case 606: 
            case 608: 
            case 611: 
            case 613: 
            case 614: 
            case 616: 
            case 617: 
            case 618: 
            case 619: 
            case 624: 
            case 626: 
            case 627: 
            case 628: 
            case 629: 
            case 630: 
            case 631: 
            case 637: 
            case 638: 
            case 639: 
            case 645: 
            case 646: 
            case 648: 
            case 649: 
            case 650: 
            case 651: 
            case 655: 
            case 656: 
            case 661: 
            case 663: 
            case 664: 
            case 665: 
            case 666: 
            case 668: 
            case 669: 
            case 670: 
            case 679: 
            case 681: 
            case 683: 
            case 684: 
            case 693: 
            case 694: 
            case 695: 
            case 696: 
            case 698: 
            case 699: 
            case 763: 
            case 764: 
            case 765: 
            case 766: 
            case 767: 
            case 768: 
            case 770: {
                key = this.SimpleIdentifier();
                break;
            }
            case 706: 
            case 707: 
            case 708: 
            case 709: 
            case 710: 
            case 712: 
            case 713: {
                key = this.StringLiteral();
                break;
            }
            default: {
                this.jj_la1[28] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(728);
        SqlNode value = this.StringLiteral();
        list.add(key);
        list.add(value);
    }

    public final void AddOptionValue(List<SqlNode> list) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 700: 
            case 701: 
            case 702: 
            case 737: 
            case 738: {
                SqlLiteral value = this.NumericLiteral();
                list.add(value);
                break;
            }
            case 706: 
            case 707: 
            case 708: 
            case 709: 
            case 710: 
            case 712: 
            case 713: {
                SqlNode value = this.StringLiteral();
                list.add(value);
                break;
            }
            default: {
                this.jj_la1[29] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final SqlNodeList ParenthesizedLiteralOptionCommaList() throws ParseException {
        ArrayList<SqlNode> list = new ArrayList<SqlNode>();
        Span s = this.span();
        this.jj_consume_token(715);
        this.AddOptionValue(list);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 727: {
                    break;
                }
                default: {
                    this.jj_la1[30] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(727);
            this.AddOptionValue(list);
        }
        this.jj_consume_token(716);
        return new SqlNodeList(list, s.end(this));
    }

    public final void AddHint(List<SqlNode> hints) throws ParseException {
        SqlHint.HintOptionFormat optionFormat;
        SqlNodeList hintOptions;
        SqlIdentifier hintName = this.SimpleIdentifier();
        if (this.jj_2_7(5)) {
            hintOptions = this.ParenthesizedKeyValueOptionCommaList();
            optionFormat = SqlHint.HintOptionFormat.KV_LIST;
        } else if (this.jj_2_8(3)) {
            hintOptions = this.ParenthesizedSimpleIdentifierList();
            optionFormat = SqlHint.HintOptionFormat.ID_LIST;
        } else if (this.jj_2_9(3)) {
            hintOptions = this.ParenthesizedLiteralOptionCommaList();
            optionFormat = SqlHint.HintOptionFormat.LITERAL_LIST;
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 715: {
                    this.jj_consume_token(715);
                    this.jj_consume_token(716);
                    break;
                }
                default: {
                    this.jj_la1[31] = this.jj_gen;
                }
            }
            hintOptions = SqlNodeList.EMPTY;
            optionFormat = SqlHint.HintOptionFormat.EMPTY;
        }
        hints.add(new SqlHint(Span.of(hintOptions).end(this), hintName, hintOptions, optionFormat));
    }

    public final SqlNode TableHints(SqlIdentifier tableName) throws ParseException {
        ArrayList<SqlNode> hints = new ArrayList<SqlNode>();
        this.jj_consume_token(755);
        this.AddHint(hints);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 727: {
                    break;
                }
                default: {
                    this.jj_la1[32] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(727);
            this.AddHint(hints);
        }
        this.jj_consume_token(756);
        SqlParserPos pos = Span.of(tableName).addAll(hints).end(this);
        SqlNodeList hintList = new SqlNodeList(hints, pos);
        return new SqlTableRef(pos, tableName, hintList);
    }

    public final SqlSelect SqlSelect() throws ParseException {
        SqlNodeList windowDecls;
        SqlNode having;
        SqlNodeList groupBy;
        SqlNode where;
        SqlNode fromClause;
        ArrayList<SqlLiteral> keywords = new ArrayList<SqlLiteral>();
        ArrayList<SqlNode> selectList = new ArrayList<SqlNode>();
        ArrayList<SqlNode> hints = new ArrayList<SqlNode>();
        this.jj_consume_token(503);
        Span s = this.span();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 755: {
                this.jj_consume_token(755);
                this.AddHint(hints);
                block30: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 727: {
                            break;
                        }
                        default: {
                            this.jj_la1[33] = this.jj_gen;
                            break block30;
                        }
                    }
                    this.jj_consume_token(727);
                    this.AddHint(hints);
                }
                this.jj_consume_token(756);
                break;
            }
            default: {
                this.jj_la1[34] = this.jj_gen;
            }
        }
        this.SqlSelectKeywords(keywords);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 588: {
                this.jj_consume_token(588);
                keywords.add(SqlSelectKeyword.STREAM.symbol(this.getPos()));
                break;
            }
            default: {
                this.jj_la1[35] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 10: 
            case 166: {
                SqlLiteral keyword = this.AllOrDistinct();
                keywords.add(keyword);
                break;
            }
            default: {
                this.jj_la1[36] = this.jj_gen;
            }
        }
        SqlNodeList keywordList = new SqlNodeList(keywords, s.addAll(keywords).pos());
        this.AddSelectItem(selectList);
        block31: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 727: {
                    break;
                }
                default: {
                    this.jj_la1[37] = this.jj_gen;
                    break block31;
                }
            }
            this.jj_consume_token(727);
            this.AddSelectItem(selectList);
        }
        block15 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 220: {
                this.jj_consume_token(220);
                fromClause = this.FromClause();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 687: {
                        where = this.Where();
                        break;
                    }
                    default: {
                        this.jj_la1[38] = this.jj_gen;
                        where = null;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 234: {
                        groupBy = this.GroupBy();
                        break;
                    }
                    default: {
                        this.jj_la1[39] = this.jj_gen;
                        groupBy = null;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 238: {
                        having = this.Having();
                        break;
                    }
                    default: {
                        this.jj_la1[40] = this.jj_gen;
                        having = null;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 689: {
                        windowDecls = this.Window();
                        break block15;
                    }
                }
                this.jj_la1[41] = this.jj_gen;
                windowDecls = null;
                break;
            }
            default: {
                this.jj_la1[42] = this.jj_gen;
                this.E();
                fromClause = null;
                where = null;
                groupBy = null;
                having = null;
                windowDecls = null;
            }
        }
        return new SqlSelect(s.end(this), keywordList, new SqlNodeList(selectList, Span.of(selectList).pos()), fromClause, where, groupBy, having, windowDecls, null, null, null, new SqlNodeList(hints, this.getPos()));
    }

    public final SqlNode SqlExplain() throws ParseException {
        SqlExplainFormat format;
        SqlExplainLevel detailLevel = SqlExplainLevel.EXPPLAN_ATTRIBUTES;
        this.jj_consume_token(198);
        this.jj_consume_token(418);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 193: 
            case 253: {
                detailLevel = this.ExplainDetailLevel();
                break;
            }
            default: {
                this.jj_la1[43] = this.jj_gen;
            }
        }
        SqlExplain.Depth depth = this.ExplainDepth();
        if (this.jj_2_10(2)) {
            this.jj_consume_token(23);
            this.jj_consume_token(696);
            format = SqlExplainFormat.XML;
        } else if (this.jj_2_11(2)) {
            this.jj_consume_token(23);
            this.jj_consume_token(278);
            format = SqlExplainFormat.JSON;
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 23: {
                    this.jj_consume_token(23);
                    this.jj_consume_token(168);
                    format = SqlExplainFormat.DOT;
                    break;
                }
                default: {
                    this.jj_la1[44] = this.jj_gen;
                    format = SqlExplainFormat.TEXT;
                }
            }
        }
        this.jj_consume_token(211);
        SqlNode stmt = this.SqlQueryOrDml();
        return new SqlExplain(this.getPos(), stmt, detailLevel.symbol(SqlParserPos.ZERO), depth.symbol(SqlParserPos.ZERO), format.symbol(SqlParserPos.ZERO), this.nDynamicParams);
    }

    public final SqlNode SqlQueryOrDml() throws ParseException {
        SqlNode stmt;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 39: 
            case 47: 
            case 49: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 74: 
            case 77: 
            case 78: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 86: 
            case 87: 
            case 88: 
            case 90: 
            case 92: 
            case 93: 
            case 95: 
            case 96: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 104: 
            case 105: 
            case 108: 
            case 109: 
            case 110: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 122: 
            case 123: 
            case 124: 
            case 126: 
            case 127: 
            case 128: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 138: 
            case 141: 
            case 145: 
            case 146: 
            case 147: 
            case 149: 
            case 150: 
            case 151: 
            case 153: 
            case 154: 
            case 156: 
            case 157: 
            case 159: 
            case 160: 
            case 162: 
            case 165: 
            case 167: 
            case 168: 
            case 170: 
            case 171: 
            case 174: 
            case 175: 
            case 177: 
            case 180: 
            case 185: 
            case 187: 
            case 189: 
            case 191: 
            case 192: 
            case 193: 
            case 196: 
            case 197: 
            case 201: 
            case 202: 
            case 205: 
            case 206: 
            case 207: 
            case 209: 
            case 210: 
            case 212: 
            case 214: 
            case 215: 
            case 216: 
            case 223: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 230: 
            case 231: 
            case 233: 
            case 235: 
            case 236: 
            case 239: 
            case 241: 
            case 242: 
            case 243: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 252: 
            case 253: 
            case 254: 
            case 257: 
            case 260: 
            case 263: 
            case 264: 
            case 268: 
            case 269: 
            case 271: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 278: 
            case 279: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 284: 
            case 285: 
            case 286: 
            case 287: 
            case 288: 
            case 289: 
            case 290: 
            case 291: 
            case 294: 
            case 295: 
            case 297: 
            case 299: 
            case 300: 
            case 301: 
            case 302: 
            case 306: 
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 313: 
            case 315: 
            case 317: 
            case 319: 
            case 320: 
            case 324: 
            case 325: 
            case 326: 
            case 328: 
            case 329: 
            case 330: 
            case 331: 
            case 332: 
            case 333: 
            case 334: 
            case 335: 
            case 339: 
            case 340: 
            case 341: 
            case 342: 
            case 343: 
            case 344: 
            case 345: 
            case 346: 
            case 351: 
            case 352: 
            case 353: 
            case 357: 
            case 358: 
            case 359: 
            case 360: 
            case 361: 
            case 362: 
            case 363: 
            case 364: 
            case 365: 
            case 367: 
            case 369: 
            case 370: 
            case 379: 
            case 380: 
            case 383: 
            case 384: 
            case 385: 
            case 388: 
            case 391: 
            case 392: 
            case 393: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 399: 
            case 400: 
            case 401: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 411: 
            case 412: 
            case 413: 
            case 414: 
            case 416: 
            case 417: 
            case 418: 
            case 419: 
            case 421: 
            case 423: 
            case 425: 
            case 428: 
            case 429: 
            case 431: 
            case 432: 
            case 434: 
            case 435: 
            case 436: 
            case 438: 
            case 439: 
            case 448: 
            case 452: 
            case 454: 
            case 455: 
            case 457: 
            case 458: 
            case 460: 
            case 461: 
            case 462: 
            case 465: 
            case 466: 
            case 467: 
            case 468: 
            case 469: 
            case 472: 
            case 473: 
            case 474: 
            case 477: 
            case 478: 
            case 479: 
            case 480: 
            case 481: 
            case 482: 
            case 483: 
            case 485: 
            case 488: 
            case 489: 
            case 490: 
            case 491: 
            case 493: 
            case 494: 
            case 495: 
            case 498: 
            case 499: 
            case 500: 
            case 501: 
            case 503: 
            case 504: 
            case 506: 
            case 507: 
            case 508: 
            case 509: 
            case 510: 
            case 511: 
            case 512: 
            case 514: 
            case 518: 
            case 519: 
            case 522: 
            case 523: 
            case 524: 
            case 525: 
            case 526: 
            case 532: 
            case 533: 
            case 534: 
            case 535: 
            case 536: 
            case 537: 
            case 538: 
            case 539: 
            case 540: 
            case 541: 
            case 542: 
            case 543: 
            case 544: 
            case 545: 
            case 546: 
            case 547: 
            case 548: 
            case 549: 
            case 550: 
            case 551: 
            case 552: 
            case 553: 
            case 554: 
            case 555: 
            case 556: 
            case 557: 
            case 558: 
            case 559: 
            case 560: 
            case 561: 
            case 562: 
            case 563: 
            case 564: 
            case 565: 
            case 566: 
            case 567: 
            case 568: 
            case 569: 
            case 570: 
            case 571: 
            case 572: 
            case 573: 
            case 574: 
            case 575: 
            case 576: 
            case 577: 
            case 578: 
            case 579: 
            case 580: 
            case 581: 
            case 583: 
            case 584: 
            case 586: 
            case 587: 
            case 589: 
            case 590: 
            case 591: 
            case 592: 
            case 595: 
            case 596: 
            case 599: 
            case 604: 
            case 605: 
            case 606: 
            case 608: 
            case 611: 
            case 612: 
            case 613: 
            case 614: 
            case 615: 
            case 616: 
            case 617: 
            case 618: 
            case 619: 
            case 624: 
            case 626: 
            case 627: 
            case 628: 
            case 629: 
            case 630: 
            case 631: 
            case 632: 
            case 637: 
            case 638: 
            case 639: 
            case 640: 
            case 642: 
            case 643: 
            case 645: 
            case 646: 
            case 648: 
            case 649: 
            case 650: 
            case 651: 
            case 653: 
            case 654: 
            case 655: 
            case 656: 
            case 659: 
            case 661: 
            case 662: 
            case 663: 
            case 664: 
            case 665: 
            case 666: 
            case 668: 
            case 669: 
            case 670: 
            case 671: 
            case 672: 
            case 674: 
            case 675: 
            case 679: 
            case 681: 
            case 683: 
            case 684: 
            case 690: 
            case 693: 
            case 694: 
            case 695: 
            case 696: 
            case 697: 
            case 698: 
            case 699: 
            case 700: 
            case 701: 
            case 702: 
            case 706: 
            case 707: 
            case 708: 
            case 709: 
            case 710: 
            case 712: 
            case 713: 
            case 715: 
            case 717: 
            case 718: 
            case 719: 
            case 720: 
            case 731: 
            case 737: 
            case 738: 
            case 763: 
            case 764: 
            case 765: 
            case 766: 
            case 767: 
            case 768: 
            case 770: {
                stmt = this.OrderedQueryOrExpr(SqlAbstractParserImpl.ExprContext.ACCEPT_QUERY);
                break;
            }
            case 262: 
            case 660: {
                stmt = this.SqlInsert();
                break;
            }
            case 152: {
                stmt = this.SqlDelete();
                break;
            }
            case 658: {
                stmt = this.SqlUpdate();
                break;
            }
            case 323: {
                stmt = this.SqlMerge();
                break;
            }
            default: {
                this.jj_la1[45] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return stmt;
    }

    public final SqlExplain.Depth ExplainDepth() throws ParseException {
        if (this.jj_2_12(2)) {
            this.jj_consume_token(690);
            this.jj_consume_token(646);
            return SqlExplain.Depth.TYPE;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 690: {
                this.jj_consume_token(690);
                this.jj_consume_token(249);
                return SqlExplain.Depth.PHYSICAL;
            }
            case 692: {
                this.jj_consume_token(692);
                this.jj_consume_token(249);
                return SqlExplain.Depth.LOGICAL;
            }
        }
        this.jj_la1[46] = this.jj_gen;
        return SqlExplain.Depth.PHYSICAL;
    }

    public final SqlExplainLevel ExplainDetailLevel() throws ParseException {
        SqlExplainLevel level = SqlExplainLevel.EXPPLAN_ATTRIBUTES;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 193: {
                this.jj_consume_token(193);
                this.jj_consume_token(32);
                level = SqlExplainLevel.NO_ATTRIBUTES;
                break;
            }
            case 253: {
                this.jj_consume_token(253);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 10: {
                        this.jj_consume_token(10);
                        level = SqlExplainLevel.ALL_ATTRIBUTES;
                        break;
                    }
                    default: {
                        this.jj_la1[47] = this.jj_gen;
                    }
                }
                this.jj_consume_token(32);
                break;
            }
            default: {
                this.jj_la1[48] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return level;
    }

    public final SqlNode SqlDescribe() throws ParseException {
        this.jj_consume_token(158);
        Span s = this.span();
        if (this.jj_2_13(2)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 131: {
                    this.jj_consume_token(131);
                    break;
                }
                case 57: {
                    this.jj_consume_token(57);
                    break;
                }
                case 490: {
                    this.jj_consume_token(490);
                    break;
                }
                default: {
                    this.jj_la1[49] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            SqlIdentifier id = this.CompoundIdentifier();
            return new SqlDescribeSchema(s.end(id), id);
        }
        if (this.jj_2_14(Integer.MAX_VALUE)) {
            SqlIdentifier column;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 605: {
                    this.jj_consume_token(605);
                    break;
                }
                default: {
                    this.jj_la1[50] = this.jj_gen;
                }
            }
            SqlIdentifier table = this.CompoundIdentifier();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 14: 
                case 17: 
                case 20: 
                case 21: 
                case 24: 
                case 26: 
                case 27: 
                case 31: 
                case 32: 
                case 35: 
                case 39: 
                case 47: 
                case 49: 
                case 53: 
                case 57: 
                case 58: 
                case 61: 
                case 62: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 74: 
                case 78: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 86: 
                case 87: 
                case 88: 
                case 90: 
                case 92: 
                case 93: 
                case 95: 
                case 96: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 104: 
                case 128: 
                case 130: 
                case 131: 
                case 133: 
                case 135: 
                case 136: 
                case 138: 
                case 141: 
                case 145: 
                case 146: 
                case 147: 
                case 149: 
                case 150: 
                case 151: 
                case 154: 
                case 156: 
                case 157: 
                case 159: 
                case 160: 
                case 162: 
                case 165: 
                case 167: 
                case 168: 
                case 170: 
                case 171: 
                case 174: 
                case 175: 
                case 180: 
                case 185: 
                case 187: 
                case 191: 
                case 192: 
                case 193: 
                case 205: 
                case 206: 
                case 210: 
                case 212: 
                case 214: 
                case 215: 
                case 216: 
                case 224: 
                case 225: 
                case 226: 
                case 227: 
                case 230: 
                case 231: 
                case 233: 
                case 235: 
                case 239: 
                case 241: 
                case 243: 
                case 245: 
                case 246: 
                case 247: 
                case 248: 
                case 249: 
                case 252: 
                case 253: 
                case 254: 
                case 257: 
                case 260: 
                case 263: 
                case 264: 
                case 271: 
                case 273: 
                case 274: 
                case 275: 
                case 276: 
                case 278: 
                case 286: 
                case 287: 
                case 288: 
                case 289: 
                case 290: 
                case 294: 
                case 300: 
                case 301: 
                case 302: 
                case 310: 
                case 312: 
                case 313: 
                case 315: 
                case 320: 
                case 324: 
                case 325: 
                case 326: 
                case 328: 
                case 329: 
                case 330: 
                case 333: 
                case 334: 
                case 340: 
                case 341: 
                case 343: 
                case 344: 
                case 345: 
                case 346: 
                case 351: 
                case 357: 
                case 362: 
                case 364: 
                case 365: 
                case 367: 
                case 370: 
                case 379: 
                case 380: 
                case 383: 
                case 384: 
                case 385: 
                case 388: 
                case 392: 
                case 393: 
                case 395: 
                case 396: 
                case 397: 
                case 398: 
                case 399: 
                case 400: 
                case 401: 
                case 403: 
                case 404: 
                case 405: 
                case 406: 
                case 407: 
                case 416: 
                case 417: 
                case 418: 
                case 419: 
                case 425: 
                case 428: 
                case 431: 
                case 432: 
                case 434: 
                case 435: 
                case 436: 
                case 439: 
                case 455: 
                case 457: 
                case 458: 
                case 460: 
                case 461: 
                case 462: 
                case 465: 
                case 466: 
                case 467: 
                case 468: 
                case 469: 
                case 473: 
                case 474: 
                case 477: 
                case 478: 
                case 479: 
                case 480: 
                case 482: 
                case 488: 
                case 489: 
                case 490: 
                case 491: 
                case 493: 
                case 494: 
                case 495: 
                case 499: 
                case 500: 
                case 501: 
                case 504: 
                case 506: 
                case 507: 
                case 508: 
                case 509: 
                case 510: 
                case 511: 
                case 514: 
                case 518: 
                case 519: 
                case 523: 
                case 524: 
                case 526: 
                case 532: 
                case 533: 
                case 534: 
                case 535: 
                case 536: 
                case 537: 
                case 538: 
                case 539: 
                case 540: 
                case 541: 
                case 542: 
                case 543: 
                case 544: 
                case 545: 
                case 546: 
                case 547: 
                case 548: 
                case 549: 
                case 550: 
                case 551: 
                case 552: 
                case 553: 
                case 554: 
                case 555: 
                case 556: 
                case 557: 
                case 558: 
                case 559: 
                case 560: 
                case 561: 
                case 562: 
                case 563: 
                case 564: 
                case 565: 
                case 566: 
                case 567: 
                case 568: 
                case 569: 
                case 570: 
                case 571: 
                case 572: 
                case 573: 
                case 574: 
                case 575: 
                case 576: 
                case 577: 
                case 578: 
                case 579: 
                case 580: 
                case 583: 
                case 584: 
                case 589: 
                case 590: 
                case 591: 
                case 592: 
                case 595: 
                case 606: 
                case 608: 
                case 611: 
                case 613: 
                case 614: 
                case 616: 
                case 617: 
                case 618: 
                case 619: 
                case 624: 
                case 626: 
                case 627: 
                case 628: 
                case 629: 
                case 630: 
                case 631: 
                case 637: 
                case 638: 
                case 639: 
                case 645: 
                case 646: 
                case 648: 
                case 649: 
                case 650: 
                case 651: 
                case 655: 
                case 656: 
                case 661: 
                case 663: 
                case 664: 
                case 665: 
                case 666: 
                case 668: 
                case 669: 
                case 670: 
                case 679: 
                case 681: 
                case 683: 
                case 684: 
                case 693: 
                case 694: 
                case 695: 
                case 696: 
                case 698: 
                case 699: 
                case 763: 
                case 764: 
                case 765: 
                case 766: 
                case 767: 
                case 768: 
                case 770: {
                    column = this.SimpleIdentifier();
                    break;
                }
                default: {
                    this.jj_la1[51] = this.jj_gen;
                    column = null;
                }
            }
            return new SqlDescribeTable(s.add(table).addIf(column).pos(), table, column);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 39: 
            case 47: 
            case 49: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 74: 
            case 77: 
            case 78: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 86: 
            case 87: 
            case 88: 
            case 90: 
            case 92: 
            case 93: 
            case 95: 
            case 96: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 104: 
            case 105: 
            case 108: 
            case 109: 
            case 110: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 122: 
            case 123: 
            case 124: 
            case 126: 
            case 127: 
            case 128: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 138: 
            case 141: 
            case 145: 
            case 146: 
            case 147: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 156: 
            case 157: 
            case 159: 
            case 160: 
            case 162: 
            case 165: 
            case 167: 
            case 168: 
            case 170: 
            case 171: 
            case 174: 
            case 175: 
            case 177: 
            case 180: 
            case 185: 
            case 187: 
            case 189: 
            case 191: 
            case 192: 
            case 193: 
            case 196: 
            case 197: 
            case 201: 
            case 202: 
            case 205: 
            case 206: 
            case 207: 
            case 209: 
            case 210: 
            case 212: 
            case 214: 
            case 215: 
            case 216: 
            case 223: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 230: 
            case 231: 
            case 233: 
            case 235: 
            case 236: 
            case 239: 
            case 241: 
            case 242: 
            case 243: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 252: 
            case 253: 
            case 254: 
            case 257: 
            case 260: 
            case 262: 
            case 263: 
            case 264: 
            case 268: 
            case 269: 
            case 271: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 278: 
            case 279: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 284: 
            case 285: 
            case 286: 
            case 287: 
            case 288: 
            case 289: 
            case 290: 
            case 291: 
            case 294: 
            case 295: 
            case 297: 
            case 299: 
            case 300: 
            case 301: 
            case 302: 
            case 306: 
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 313: 
            case 315: 
            case 317: 
            case 319: 
            case 320: 
            case 323: 
            case 324: 
            case 325: 
            case 326: 
            case 328: 
            case 329: 
            case 330: 
            case 331: 
            case 332: 
            case 333: 
            case 334: 
            case 335: 
            case 339: 
            case 340: 
            case 341: 
            case 342: 
            case 343: 
            case 344: 
            case 345: 
            case 346: 
            case 351: 
            case 352: 
            case 353: 
            case 357: 
            case 358: 
            case 359: 
            case 360: 
            case 361: 
            case 362: 
            case 363: 
            case 364: 
            case 365: 
            case 367: 
            case 369: 
            case 370: 
            case 379: 
            case 380: 
            case 383: 
            case 384: 
            case 385: 
            case 388: 
            case 391: 
            case 392: 
            case 393: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 399: 
            case 400: 
            case 401: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 411: 
            case 412: 
            case 413: 
            case 414: 
            case 416: 
            case 417: 
            case 418: 
            case 419: 
            case 421: 
            case 423: 
            case 425: 
            case 428: 
            case 429: 
            case 431: 
            case 432: 
            case 434: 
            case 435: 
            case 436: 
            case 438: 
            case 439: 
            case 448: 
            case 452: 
            case 454: 
            case 455: 
            case 457: 
            case 458: 
            case 460: 
            case 461: 
            case 462: 
            case 465: 
            case 466: 
            case 467: 
            case 468: 
            case 469: 
            case 472: 
            case 473: 
            case 474: 
            case 477: 
            case 478: 
            case 479: 
            case 480: 
            case 481: 
            case 482: 
            case 483: 
            case 485: 
            case 488: 
            case 489: 
            case 490: 
            case 491: 
            case 493: 
            case 494: 
            case 495: 
            case 498: 
            case 499: 
            case 500: 
            case 501: 
            case 503: 
            case 504: 
            case 506: 
            case 507: 
            case 508: 
            case 509: 
            case 510: 
            case 511: 
            case 512: 
            case 514: 
            case 518: 
            case 519: 
            case 522: 
            case 523: 
            case 524: 
            case 525: 
            case 526: 
            case 532: 
            case 533: 
            case 534: 
            case 535: 
            case 536: 
            case 537: 
            case 538: 
            case 539: 
            case 540: 
            case 541: 
            case 542: 
            case 543: 
            case 544: 
            case 545: 
            case 546: 
            case 547: 
            case 548: 
            case 549: 
            case 550: 
            case 551: 
            case 552: 
            case 553: 
            case 554: 
            case 555: 
            case 556: 
            case 557: 
            case 558: 
            case 559: 
            case 560: 
            case 561: 
            case 562: 
            case 563: 
            case 564: 
            case 565: 
            case 566: 
            case 567: 
            case 568: 
            case 569: 
            case 570: 
            case 571: 
            case 572: 
            case 573: 
            case 574: 
            case 575: 
            case 576: 
            case 577: 
            case 578: 
            case 579: 
            case 580: 
            case 581: 
            case 583: 
            case 584: 
            case 586: 
            case 587: 
            case 589: 
            case 590: 
            case 591: 
            case 592: 
            case 595: 
            case 596: 
            case 599: 
            case 604: 
            case 605: 
            case 606: 
            case 608: 
            case 611: 
            case 612: 
            case 613: 
            case 614: 
            case 615: 
            case 616: 
            case 617: 
            case 618: 
            case 619: 
            case 624: 
            case 626: 
            case 627: 
            case 628: 
            case 629: 
            case 630: 
            case 631: 
            case 632: 
            case 637: 
            case 638: 
            case 639: 
            case 640: 
            case 642: 
            case 643: 
            case 645: 
            case 646: 
            case 648: 
            case 649: 
            case 650: 
            case 651: 
            case 653: 
            case 654: 
            case 655: 
            case 656: 
            case 658: 
            case 659: 
            case 660: 
            case 661: 
            case 662: 
            case 663: 
            case 664: 
            case 665: 
            case 666: 
            case 668: 
            case 669: 
            case 670: 
            case 671: 
            case 672: 
            case 674: 
            case 675: 
            case 679: 
            case 681: 
            case 683: 
            case 684: 
            case 690: 
            case 693: 
            case 694: 
            case 695: 
            case 696: 
            case 697: 
            case 698: 
            case 699: 
            case 700: 
            case 701: 
            case 702: 
            case 706: 
            case 707: 
            case 708: 
            case 709: 
            case 710: 
            case 712: 
            case 713: 
            case 715: 
            case 717: 
            case 718: 
            case 719: 
            case 720: 
            case 731: 
            case 737: 
            case 738: 
            case 763: 
            case 764: 
            case 765: 
            case 766: 
            case 767: 
            case 768: 
            case 770: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 584: {
                        this.jj_consume_token(584);
                        break;
                    }
                    default: {
                        this.jj_la1[52] = this.jj_gen;
                    }
                }
                SqlNode stmt = this.SqlQueryOrDml();
                SqlExplainLevel detailLevel = SqlExplainLevel.EXPPLAN_ATTRIBUTES;
                SqlExplain.Depth depth = SqlExplain.Depth.PHYSICAL;
                SqlExplainFormat format = SqlExplainFormat.TEXT;
                return new SqlExplain(s.end(stmt), stmt, detailLevel.symbol(SqlParserPos.ZERO), depth.symbol(SqlParserPos.ZERO), format.symbol(SqlParserPos.ZERO), this.nDynamicParams);
            }
        }
        this.jj_la1[53] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SqlNode SqlProcedureCall() throws ParseException {
        this.jj_consume_token(50);
        Span s = this.span();
        SqlNode routineCall = this.NamedRoutineCall(SqlFunctionCategory.USER_DEFINED_PROCEDURE, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        return SqlStdOperatorTable.PROCEDURE_CALL.createCall(s.end(routineCall), routineCall);
    }

    public final SqlNode NamedRoutineCall(SqlFunctionCategory routineType, SqlAbstractParserImpl.ExprContext exprContext) throws ParseException {
        ArrayList<SqlNode> list = new ArrayList<SqlNode>();
        SqlIdentifier name = this.CompoundIdentifier();
        Span s = this.span();
        this.jj_consume_token(715);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 39: 
            case 47: 
            case 49: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 74: 
            case 77: 
            case 78: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 86: 
            case 87: 
            case 88: 
            case 90: 
            case 92: 
            case 93: 
            case 95: 
            case 96: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 104: 
            case 105: 
            case 108: 
            case 109: 
            case 110: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 122: 
            case 123: 
            case 124: 
            case 126: 
            case 127: 
            case 128: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 138: 
            case 141: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 149: 
            case 150: 
            case 151: 
            case 153: 
            case 154: 
            case 156: 
            case 157: 
            case 159: 
            case 160: 
            case 162: 
            case 165: 
            case 167: 
            case 168: 
            case 170: 
            case 171: 
            case 174: 
            case 175: 
            case 177: 
            case 180: 
            case 185: 
            case 187: 
            case 189: 
            case 191: 
            case 192: 
            case 193: 
            case 196: 
            case 197: 
            case 201: 
            case 202: 
            case 205: 
            case 206: 
            case 207: 
            case 209: 
            case 210: 
            case 212: 
            case 214: 
            case 215: 
            case 216: 
            case 223: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 230: 
            case 231: 
            case 233: 
            case 235: 
            case 236: 
            case 239: 
            case 241: 
            case 242: 
            case 243: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 252: 
            case 253: 
            case 254: 
            case 257: 
            case 260: 
            case 263: 
            case 264: 
            case 268: 
            case 269: 
            case 271: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 278: 
            case 279: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 284: 
            case 285: 
            case 286: 
            case 287: 
            case 288: 
            case 289: 
            case 290: 
            case 291: 
            case 294: 
            case 295: 
            case 297: 
            case 299: 
            case 300: 
            case 301: 
            case 302: 
            case 306: 
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 313: 
            case 315: 
            case 317: 
            case 319: 
            case 320: 
            case 324: 
            case 325: 
            case 326: 
            case 328: 
            case 329: 
            case 330: 
            case 331: 
            case 332: 
            case 333: 
            case 334: 
            case 335: 
            case 339: 
            case 340: 
            case 341: 
            case 342: 
            case 343: 
            case 344: 
            case 345: 
            case 346: 
            case 351: 
            case 352: 
            case 353: 
            case 357: 
            case 358: 
            case 359: 
            case 360: 
            case 361: 
            case 362: 
            case 363: 
            case 364: 
            case 365: 
            case 367: 
            case 369: 
            case 370: 
            case 379: 
            case 380: 
            case 383: 
            case 384: 
            case 385: 
            case 388: 
            case 391: 
            case 392: 
            case 393: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 399: 
            case 400: 
            case 401: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 411: 
            case 412: 
            case 413: 
            case 414: 
            case 416: 
            case 417: 
            case 418: 
            case 419: 
            case 421: 
            case 423: 
            case 425: 
            case 428: 
            case 429: 
            case 431: 
            case 432: 
            case 434: 
            case 435: 
            case 436: 
            case 438: 
            case 439: 
            case 448: 
            case 452: 
            case 454: 
            case 455: 
            case 457: 
            case 458: 
            case 460: 
            case 461: 
            case 462: 
            case 465: 
            case 466: 
            case 467: 
            case 468: 
            case 469: 
            case 472: 
            case 473: 
            case 474: 
            case 477: 
            case 478: 
            case 479: 
            case 480: 
            case 481: 
            case 482: 
            case 483: 
            case 485: 
            case 488: 
            case 489: 
            case 490: 
            case 491: 
            case 493: 
            case 494: 
            case 495: 
            case 498: 
            case 499: 
            case 500: 
            case 501: 
            case 503: 
            case 504: 
            case 506: 
            case 507: 
            case 508: 
            case 509: 
            case 510: 
            case 511: 
            case 512: 
            case 514: 
            case 518: 
            case 519: 
            case 522: 
            case 523: 
            case 524: 
            case 525: 
            case 526: 
            case 532: 
            case 533: 
            case 534: 
            case 535: 
            case 536: 
            case 537: 
            case 538: 
            case 539: 
            case 540: 
            case 541: 
            case 542: 
            case 543: 
            case 544: 
            case 545: 
            case 546: 
            case 547: 
            case 548: 
            case 549: 
            case 550: 
            case 551: 
            case 552: 
            case 553: 
            case 554: 
            case 555: 
            case 556: 
            case 557: 
            case 558: 
            case 559: 
            case 560: 
            case 561: 
            case 562: 
            case 563: 
            case 564: 
            case 565: 
            case 566: 
            case 567: 
            case 568: 
            case 569: 
            case 570: 
            case 571: 
            case 572: 
            case 573: 
            case 574: 
            case 575: 
            case 576: 
            case 577: 
            case 578: 
            case 579: 
            case 580: 
            case 581: 
            case 583: 
            case 584: 
            case 586: 
            case 587: 
            case 589: 
            case 590: 
            case 591: 
            case 592: 
            case 595: 
            case 596: 
            case 599: 
            case 604: 
            case 605: 
            case 606: 
            case 608: 
            case 611: 
            case 612: 
            case 613: 
            case 614: 
            case 615: 
            case 616: 
            case 617: 
            case 618: 
            case 619: 
            case 624: 
            case 626: 
            case 627: 
            case 628: 
            case 629: 
            case 630: 
            case 631: 
            case 632: 
            case 637: 
            case 638: 
            case 639: 
            case 640: 
            case 642: 
            case 643: 
            case 645: 
            case 646: 
            case 648: 
            case 649: 
            case 650: 
            case 651: 
            case 653: 
            case 654: 
            case 655: 
            case 656: 
            case 659: 
            case 661: 
            case 662: 
            case 663: 
            case 664: 
            case 665: 
            case 666: 
            case 668: 
            case 669: 
            case 670: 
            case 671: 
            case 672: 
            case 674: 
            case 675: 
            case 679: 
            case 681: 
            case 683: 
            case 684: 
            case 690: 
            case 693: 
            case 694: 
            case 695: 
            case 696: 
            case 697: 
            case 698: 
            case 699: 
            case 700: 
            case 701: 
            case 702: 
            case 706: 
            case 707: 
            case 708: 
            case 709: 
            case 710: 
            case 712: 
            case 713: 
            case 715: 
            case 717: 
            case 718: 
            case 719: 
            case 720: 
            case 731: 
            case 737: 
            case 738: 
            case 763: 
            case 764: 
            case 765: 
            case 766: 
            case 767: 
            case 768: 
            case 770: {
                this.AddArg0(list, exprContext);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 727: {
                            break;
                        }
                        default: {
                            this.jj_la1[54] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(727);
                    this.checkNonQueryExpression(exprContext);
                    this.AddArg(list, exprContext);
                }
            }
            default: {
                this.jj_la1[55] = this.jj_gen;
            }
        }
        this.jj_consume_token(716);
        return this.createCall(name, s.end(this), routineType, null, list);
    }

    public final SqlNode TableParam() throws ParseException {
        SqlNodeList orderList;
        SqlNodeList partitionList;
        Span s = this.span();
        SqlNode tableRef = this.ExplicitTable(this.getPos());
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 402: {
                this.jj_consume_token(402);
                this.jj_consume_token(48);
                partitionList = this.SimpleIdentifierOrList();
                break;
            }
            default: {
                this.jj_la1[56] = this.jj_gen;
                partitionList = SqlNodeList.EMPTY;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 382: {
                orderList = this.OrderByOfSetSemanticsTable();
                break;
            }
            default: {
                this.jj_la1[57] = this.jj_gen;
                orderList = SqlNodeList.EMPTY;
            }
        }
        return this.CreateSetSemanticsTableIfNeeded(s, tableRef, partitionList, orderList);
    }

    public final SqlNode PartitionedQueryOrQueryOrExpr(SqlAbstractParserImpl.ExprContext exprContext) throws ParseException {
        SqlNode e = this.OrderedQueryOrExpr(exprContext);
        e = this.PartitionedByAndOrderBy(e);
        return e;
    }

    public final SqlNode PartitionedByAndOrderBy(SqlNode e) throws ParseException {
        SqlNodeList orderList;
        SqlNodeList partitionList;
        Span s = this.span();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 402: {
                this.jj_consume_token(402);
                this.jj_consume_token(48);
                partitionList = this.SimpleIdentifierOrList();
                break;
            }
            default: {
                this.jj_la1[58] = this.jj_gen;
                partitionList = SqlNodeList.EMPTY;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 382: {
                orderList = this.OrderByOfSetSemanticsTable();
                break;
            }
            default: {
                this.jj_la1[59] = this.jj_gen;
                orderList = SqlNodeList.EMPTY;
            }
        }
        return this.CreateSetSemanticsTableIfNeeded(s, e, partitionList, orderList);
    }

    public final SqlNodeList OrderByOfSetSemanticsTable() throws ParseException {
        ArrayList<SqlNode> list = new ArrayList<SqlNode>();
        this.jj_consume_token(382);
        Span s = this.span();
        this.jj_consume_token(48);
        if (this.jj_2_16(2)) {
            this.jj_consume_token(715);
            this.AddOrderItem(list);
            while (this.jj_2_15(2)) {
                this.jj_consume_token(727);
                this.AddOrderItem(list);
            }
            this.jj_consume_token(716);
            return new SqlNodeList(list, s.addAll(list).pos());
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 39: 
            case 47: 
            case 49: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 74: 
            case 77: 
            case 78: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 86: 
            case 87: 
            case 88: 
            case 90: 
            case 92: 
            case 93: 
            case 95: 
            case 96: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 104: 
            case 105: 
            case 108: 
            case 109: 
            case 110: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 122: 
            case 123: 
            case 124: 
            case 126: 
            case 127: 
            case 128: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 138: 
            case 141: 
            case 145: 
            case 146: 
            case 147: 
            case 149: 
            case 150: 
            case 151: 
            case 153: 
            case 154: 
            case 156: 
            case 157: 
            case 159: 
            case 160: 
            case 162: 
            case 165: 
            case 167: 
            case 168: 
            case 170: 
            case 171: 
            case 174: 
            case 175: 
            case 177: 
            case 180: 
            case 185: 
            case 187: 
            case 189: 
            case 191: 
            case 192: 
            case 193: 
            case 196: 
            case 197: 
            case 201: 
            case 202: 
            case 205: 
            case 206: 
            case 207: 
            case 209: 
            case 210: 
            case 212: 
            case 214: 
            case 215: 
            case 216: 
            case 223: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 230: 
            case 231: 
            case 233: 
            case 235: 
            case 236: 
            case 239: 
            case 241: 
            case 242: 
            case 243: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 252: 
            case 253: 
            case 254: 
            case 257: 
            case 260: 
            case 263: 
            case 264: 
            case 268: 
            case 269: 
            case 271: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 278: 
            case 279: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 284: 
            case 285: 
            case 286: 
            case 287: 
            case 288: 
            case 289: 
            case 290: 
            case 291: 
            case 294: 
            case 295: 
            case 297: 
            case 299: 
            case 300: 
            case 301: 
            case 302: 
            case 306: 
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 313: 
            case 315: 
            case 317: 
            case 319: 
            case 320: 
            case 324: 
            case 325: 
            case 326: 
            case 328: 
            case 329: 
            case 330: 
            case 331: 
            case 332: 
            case 333: 
            case 334: 
            case 335: 
            case 339: 
            case 340: 
            case 341: 
            case 342: 
            case 343: 
            case 344: 
            case 345: 
            case 346: 
            case 351: 
            case 352: 
            case 353: 
            case 357: 
            case 358: 
            case 359: 
            case 360: 
            case 361: 
            case 362: 
            case 363: 
            case 364: 
            case 365: 
            case 367: 
            case 369: 
            case 370: 
            case 379: 
            case 380: 
            case 383: 
            case 384: 
            case 385: 
            case 388: 
            case 391: 
            case 392: 
            case 393: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 399: 
            case 400: 
            case 401: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 411: 
            case 412: 
            case 413: 
            case 414: 
            case 416: 
            case 417: 
            case 418: 
            case 419: 
            case 421: 
            case 423: 
            case 425: 
            case 428: 
            case 429: 
            case 431: 
            case 432: 
            case 434: 
            case 435: 
            case 436: 
            case 438: 
            case 439: 
            case 448: 
            case 452: 
            case 454: 
            case 455: 
            case 457: 
            case 458: 
            case 460: 
            case 461: 
            case 462: 
            case 465: 
            case 466: 
            case 467: 
            case 468: 
            case 469: 
            case 472: 
            case 473: 
            case 474: 
            case 477: 
            case 478: 
            case 479: 
            case 480: 
            case 481: 
            case 482: 
            case 483: 
            case 485: 
            case 488: 
            case 489: 
            case 490: 
            case 491: 
            case 493: 
            case 494: 
            case 495: 
            case 498: 
            case 499: 
            case 500: 
            case 501: 
            case 504: 
            case 506: 
            case 507: 
            case 508: 
            case 509: 
            case 510: 
            case 511: 
            case 512: 
            case 514: 
            case 518: 
            case 519: 
            case 522: 
            case 523: 
            case 524: 
            case 525: 
            case 526: 
            case 532: 
            case 533: 
            case 534: 
            case 535: 
            case 536: 
            case 537: 
            case 538: 
            case 539: 
            case 540: 
            case 541: 
            case 542: 
            case 543: 
            case 544: 
            case 545: 
            case 546: 
            case 547: 
            case 548: 
            case 549: 
            case 550: 
            case 551: 
            case 552: 
            case 553: 
            case 554: 
            case 555: 
            case 556: 
            case 557: 
            case 558: 
            case 559: 
            case 560: 
            case 561: 
            case 562: 
            case 563: 
            case 564: 
            case 565: 
            case 566: 
            case 567: 
            case 568: 
            case 569: 
            case 570: 
            case 571: 
            case 572: 
            case 573: 
            case 574: 
            case 575: 
            case 576: 
            case 577: 
            case 578: 
            case 579: 
            case 580: 
            case 581: 
            case 583: 
            case 584: 
            case 586: 
            case 587: 
            case 589: 
            case 590: 
            case 591: 
            case 592: 
            case 595: 
            case 596: 
            case 599: 
            case 604: 
            case 606: 
            case 608: 
            case 611: 
            case 612: 
            case 613: 
            case 614: 
            case 615: 
            case 616: 
            case 617: 
            case 618: 
            case 619: 
            case 624: 
            case 626: 
            case 627: 
            case 628: 
            case 629: 
            case 630: 
            case 631: 
            case 632: 
            case 637: 
            case 638: 
            case 639: 
            case 640: 
            case 642: 
            case 643: 
            case 645: 
            case 646: 
            case 648: 
            case 649: 
            case 650: 
            case 651: 
            case 653: 
            case 654: 
            case 655: 
            case 656: 
            case 659: 
            case 661: 
            case 662: 
            case 663: 
            case 664: 
            case 665: 
            case 666: 
            case 668: 
            case 669: 
            case 670: 
            case 674: 
            case 675: 
            case 679: 
            case 681: 
            case 683: 
            case 684: 
            case 693: 
            case 694: 
            case 695: 
            case 696: 
            case 697: 
            case 698: 
            case 699: 
            case 700: 
            case 701: 
            case 702: 
            case 706: 
            case 707: 
            case 708: 
            case 709: 
            case 710: 
            case 712: 
            case 713: 
            case 715: 
            case 717: 
            case 718: 
            case 719: 
            case 720: 
            case 731: 
            case 737: 
            case 738: 
            case 763: 
            case 764: 
            case 765: 
            case 766: 
            case 767: 
            case 768: 
            case 770: {
                this.AddOrderItem(list);
                return new SqlNodeList(list, s.addAll(list).pos());
            }
        }
        this.jj_la1[60] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SqlNode CreateSetSemanticsTableIfNeeded(Span s, SqlNode e, SqlNodeList partitionList, SqlNodeList orderList) throws ParseException {
        if (partitionList.isEmpty() && orderList.isEmpty()) {
            return e;
        }
        return SqlStdOperatorTable.SET_SEMANTICS_TABLE.createCall(s.pos(), e, partitionList, orderList);
    }

    public final SqlNode SqlInsert() throws ParseException {
        SqlNodeList columnList;
        SqlNode tableRef;
        ArrayList<SqlLiteral> keywords = new ArrayList<SqlLiteral>();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 262: {
                this.jj_consume_token(262);
                break;
            }
            case 660: {
                this.jj_consume_token(660);
                keywords.add(SqlInsertKeyword.UPSERT.symbol(this.getPos()));
                break;
            }
            default: {
                this.jj_la1[61] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        Span s = this.span();
        this.SqlInsertKeywords(keywords);
        SqlNodeList keywordList = new SqlNodeList(keywords, s.addAll(keywords).pos());
        this.jj_consume_token(270);
        SqlIdentifier tableName = this.CompoundTableIdentifier();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 755: {
                tableRef = this.TableHints(tableName);
                break;
            }
            default: {
                this.jj_la1[62] = this.jj_gen;
                tableRef = tableName;
            }
        }
        if (this.jj_2_17(5)) {
            tableRef = this.ExtendTable(tableRef);
        }
        if (this.jj_2_18(2)) {
            Pair<SqlNodeList, SqlNodeList> p = this.ParenthesizedCompoundIdentifierList();
            if (((SqlNodeList)p.right).size() > 0) {
                tableRef = this.extend(tableRef, (SqlNodeList)p.right);
            }
            columnList = ((SqlNodeList)p.left).size() > 0 ? (SqlNodeList)p.left : null;
        } else {
            columnList = null;
        }
        SqlNode source = this.OrderedQueryOrExpr(SqlAbstractParserImpl.ExprContext.ACCEPT_QUERY);
        return new SqlInsert(s.end(source), keywordList, tableRef, source, columnList);
    }

    public final SqlNode SqlDelete() throws ParseException {
        SqlNode where;
        SqlIdentifier alias;
        SqlNode tableRef;
        this.jj_consume_token(152);
        Span s = this.span();
        this.jj_consume_token(220);
        SqlIdentifier tableName = this.CompoundTableIdentifier();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 755: {
                tableRef = this.TableHints(tableName);
                break;
            }
            default: {
                this.jj_la1[63] = this.jj_gen;
                tableRef = tableName;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 199: 
            case 715: {
                tableRef = this.ExtendTable(tableRef);
                break;
            }
            default: {
                this.jj_la1[64] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 35: 
            case 39: 
            case 47: 
            case 49: 
            case 53: 
            case 57: 
            case 58: 
            case 61: 
            case 62: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 74: 
            case 78: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 86: 
            case 87: 
            case 88: 
            case 90: 
            case 92: 
            case 93: 
            case 95: 
            case 96: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 104: 
            case 128: 
            case 130: 
            case 131: 
            case 133: 
            case 135: 
            case 136: 
            case 138: 
            case 141: 
            case 145: 
            case 146: 
            case 147: 
            case 149: 
            case 150: 
            case 151: 
            case 154: 
            case 156: 
            case 157: 
            case 159: 
            case 160: 
            case 162: 
            case 165: 
            case 167: 
            case 168: 
            case 170: 
            case 171: 
            case 174: 
            case 175: 
            case 180: 
            case 185: 
            case 187: 
            case 191: 
            case 192: 
            case 193: 
            case 205: 
            case 206: 
            case 210: 
            case 212: 
            case 214: 
            case 215: 
            case 216: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 230: 
            case 231: 
            case 233: 
            case 235: 
            case 239: 
            case 241: 
            case 243: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 252: 
            case 253: 
            case 254: 
            case 257: 
            case 260: 
            case 263: 
            case 264: 
            case 271: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 278: 
            case 286: 
            case 287: 
            case 288: 
            case 289: 
            case 290: 
            case 294: 
            case 300: 
            case 301: 
            case 302: 
            case 310: 
            case 312: 
            case 313: 
            case 315: 
            case 320: 
            case 324: 
            case 325: 
            case 326: 
            case 328: 
            case 329: 
            case 330: 
            case 333: 
            case 334: 
            case 340: 
            case 341: 
            case 343: 
            case 344: 
            case 345: 
            case 346: 
            case 351: 
            case 357: 
            case 362: 
            case 364: 
            case 365: 
            case 367: 
            case 370: 
            case 379: 
            case 380: 
            case 383: 
            case 384: 
            case 385: 
            case 388: 
            case 392: 
            case 393: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 399: 
            case 400: 
            case 401: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 416: 
            case 417: 
            case 418: 
            case 419: 
            case 425: 
            case 428: 
            case 431: 
            case 432: 
            case 434: 
            case 435: 
            case 436: 
            case 439: 
            case 455: 
            case 457: 
            case 458: 
            case 460: 
            case 461: 
            case 462: 
            case 465: 
            case 466: 
            case 467: 
            case 468: 
            case 469: 
            case 473: 
            case 474: 
            case 477: 
            case 478: 
            case 479: 
            case 480: 
            case 482: 
            case 488: 
            case 489: 
            case 490: 
            case 491: 
            case 493: 
            case 494: 
            case 495: 
            case 499: 
            case 500: 
            case 501: 
            case 504: 
            case 506: 
            case 507: 
            case 508: 
            case 509: 
            case 510: 
            case 511: 
            case 514: 
            case 518: 
            case 519: 
            case 523: 
            case 524: 
            case 526: 
            case 532: 
            case 533: 
            case 534: 
            case 535: 
            case 536: 
            case 537: 
            case 538: 
            case 539: 
            case 540: 
            case 541: 
            case 542: 
            case 543: 
            case 544: 
            case 545: 
            case 546: 
            case 547: 
            case 548: 
            case 549: 
            case 550: 
            case 551: 
            case 552: 
            case 553: 
            case 554: 
            case 555: 
            case 556: 
            case 557: 
            case 558: 
            case 559: 
            case 560: 
            case 561: 
            case 562: 
            case 563: 
            case 564: 
            case 565: 
            case 566: 
            case 567: 
            case 568: 
            case 569: 
            case 570: 
            case 571: 
            case 572: 
            case 573: 
            case 574: 
            case 575: 
            case 576: 
            case 577: 
            case 578: 
            case 579: 
            case 580: 
            case 583: 
            case 584: 
            case 589: 
            case 590: 
            case 591: 
            case 592: 
            case 595: 
            case 606: 
            case 608: 
            case 611: 
            case 613: 
            case 614: 
            case 616: 
            case 617: 
            case 618: 
            case 619: 
            case 624: 
            case 626: 
            case 627: 
            case 628: 
            case 629: 
            case 630: 
            case 631: 
            case 637: 
            case 638: 
            case 639: 
            case 645: 
            case 646: 
            case 648: 
            case 649: 
            case 650: 
            case 651: 
            case 655: 
            case 656: 
            case 661: 
            case 663: 
            case 664: 
            case 665: 
            case 666: 
            case 668: 
            case 669: 
            case 670: 
            case 679: 
            case 681: 
            case 683: 
            case 684: 
            case 693: 
            case 694: 
            case 695: 
            case 696: 
            case 698: 
            case 699: 
            case 763: 
            case 764: 
            case 765: 
            case 766: 
            case 767: 
            case 768: 
            case 770: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 23: {
                        this.jj_consume_token(23);
                        break;
                    }
                    default: {
                        this.jj_la1[65] = this.jj_gen;
                    }
                }
                alias = this.SimpleIdentifier();
                break;
            }
            default: {
                this.jj_la1[66] = this.jj_gen;
                alias = null;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 687: {
                where = this.Where();
                break;
            }
            default: {
                this.jj_la1[67] = this.jj_gen;
                where = null;
            }
        }
        return new SqlDelete(s.add(tableRef).addIf(alias).addIf(where).pos(), tableRef, where, null, alias);
    }

    public final SqlNode SqlUpdate() throws ParseException {
        SqlNode where;
        SqlIdentifier alias;
        SqlNode tableRef;
        this.jj_consume_token(658);
        Span s = this.span();
        SqlNodeList targetColumnList = new SqlNodeList(s.pos());
        SqlNodeList sourceExpressionList = new SqlNodeList(s.pos());
        SqlIdentifier tableName = this.CompoundTableIdentifier();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 755: {
                tableRef = this.TableHints(tableName);
                break;
            }
            default: {
                this.jj_la1[68] = this.jj_gen;
                tableRef = tableName;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 199: 
            case 715: {
                tableRef = this.ExtendTable(tableRef);
                break;
            }
            default: {
                this.jj_la1[69] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 35: 
            case 39: 
            case 47: 
            case 49: 
            case 53: 
            case 57: 
            case 58: 
            case 61: 
            case 62: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 74: 
            case 78: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 86: 
            case 87: 
            case 88: 
            case 90: 
            case 92: 
            case 93: 
            case 95: 
            case 96: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 104: 
            case 128: 
            case 130: 
            case 131: 
            case 133: 
            case 135: 
            case 136: 
            case 138: 
            case 141: 
            case 145: 
            case 146: 
            case 147: 
            case 149: 
            case 150: 
            case 151: 
            case 154: 
            case 156: 
            case 157: 
            case 159: 
            case 160: 
            case 162: 
            case 165: 
            case 167: 
            case 168: 
            case 170: 
            case 171: 
            case 174: 
            case 175: 
            case 180: 
            case 185: 
            case 187: 
            case 191: 
            case 192: 
            case 193: 
            case 205: 
            case 206: 
            case 210: 
            case 212: 
            case 214: 
            case 215: 
            case 216: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 230: 
            case 231: 
            case 233: 
            case 235: 
            case 239: 
            case 241: 
            case 243: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 252: 
            case 253: 
            case 254: 
            case 257: 
            case 260: 
            case 263: 
            case 264: 
            case 271: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 278: 
            case 286: 
            case 287: 
            case 288: 
            case 289: 
            case 290: 
            case 294: 
            case 300: 
            case 301: 
            case 302: 
            case 310: 
            case 312: 
            case 313: 
            case 315: 
            case 320: 
            case 324: 
            case 325: 
            case 326: 
            case 328: 
            case 329: 
            case 330: 
            case 333: 
            case 334: 
            case 340: 
            case 341: 
            case 343: 
            case 344: 
            case 345: 
            case 346: 
            case 351: 
            case 357: 
            case 362: 
            case 364: 
            case 365: 
            case 367: 
            case 370: 
            case 379: 
            case 380: 
            case 383: 
            case 384: 
            case 385: 
            case 388: 
            case 392: 
            case 393: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 399: 
            case 400: 
            case 401: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 416: 
            case 417: 
            case 418: 
            case 419: 
            case 425: 
            case 428: 
            case 431: 
            case 432: 
            case 434: 
            case 435: 
            case 436: 
            case 439: 
            case 455: 
            case 457: 
            case 458: 
            case 460: 
            case 461: 
            case 462: 
            case 465: 
            case 466: 
            case 467: 
            case 468: 
            case 469: 
            case 473: 
            case 474: 
            case 477: 
            case 478: 
            case 479: 
            case 480: 
            case 482: 
            case 488: 
            case 489: 
            case 490: 
            case 491: 
            case 493: 
            case 494: 
            case 495: 
            case 499: 
            case 500: 
            case 501: 
            case 504: 
            case 506: 
            case 507: 
            case 508: 
            case 509: 
            case 510: 
            case 511: 
            case 514: 
            case 518: 
            case 519: 
            case 523: 
            case 524: 
            case 526: 
            case 532: 
            case 533: 
            case 534: 
            case 535: 
            case 536: 
            case 537: 
            case 538: 
            case 539: 
            case 540: 
            case 541: 
            case 542: 
            case 543: 
            case 544: 
            case 545: 
            case 546: 
            case 547: 
            case 548: 
            case 549: 
            case 550: 
            case 551: 
            case 552: 
            case 553: 
            case 554: 
            case 555: 
            case 556: 
            case 557: 
            case 558: 
            case 559: 
            case 560: 
            case 561: 
            case 562: 
            case 563: 
            case 564: 
            case 565: 
            case 566: 
            case 567: 
            case 568: 
            case 569: 
            case 570: 
            case 571: 
            case 572: 
            case 573: 
            case 574: 
            case 575: 
            case 576: 
            case 577: 
            case 578: 
            case 579: 
            case 580: 
            case 583: 
            case 584: 
            case 589: 
            case 590: 
            case 591: 
            case 592: 
            case 595: 
            case 606: 
            case 608: 
            case 611: 
            case 613: 
            case 614: 
            case 616: 
            case 617: 
            case 618: 
            case 619: 
            case 624: 
            case 626: 
            case 627: 
            case 628: 
            case 629: 
            case 630: 
            case 631: 
            case 637: 
            case 638: 
            case 639: 
            case 645: 
            case 646: 
            case 648: 
            case 649: 
            case 650: 
            case 651: 
            case 655: 
            case 656: 
            case 661: 
            case 663: 
            case 664: 
            case 665: 
            case 666: 
            case 668: 
            case 669: 
            case 670: 
            case 679: 
            case 681: 
            case 683: 
            case 684: 
            case 693: 
            case 694: 
            case 695: 
            case 696: 
            case 698: 
            case 699: 
            case 763: 
            case 764: 
            case 765: 
            case 766: 
            case 767: 
            case 768: 
            case 770: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 23: {
                        this.jj_consume_token(23);
                        break;
                    }
                    default: {
                        this.jj_la1[70] = this.jj_gen;
                    }
                }
                alias = this.SimpleIdentifier();
                break;
            }
            default: {
                this.jj_la1[71] = this.jj_gen;
                alias = null;
            }
        }
        this.jj_consume_token(513);
        SqlIdentifier id = this.SimpleIdentifier();
        targetColumnList.add(id);
        this.jj_consume_token(728);
        this.AddExpression(sourceExpressionList, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        block18: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 727: {
                    break;
                }
                default: {
                    this.jj_la1[72] = this.jj_gen;
                    break block18;
                }
            }
            this.jj_consume_token(727);
            id = this.SimpleIdentifier();
            targetColumnList.add(id);
            this.jj_consume_token(728);
            this.AddExpression(sourceExpressionList, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 687: {
                where = this.Where();
                break;
            }
            default: {
                this.jj_la1[73] = this.jj_gen;
                where = null;
            }
        }
        SqlParserPos pos = s.addAll(targetColumnList).addAll(sourceExpressionList).addIf(where).pos();
        return new SqlUpdate(pos, tableRef, targetColumnList, sourceExpressionList, where, null, alias);
    }

    public final SqlNode SqlMerge() throws ParseException {
        SqlInsert insertCall;
        SqlUpdate updateCall;
        SqlIdentifier alias;
        SqlNode tableRef;
        this.jj_consume_token(323);
        Span s = this.span();
        this.jj_consume_token(270);
        SqlIdentifier tableName = this.CompoundTableIdentifier();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 755: {
                tableRef = this.TableHints(tableName);
                break;
            }
            default: {
                this.jj_la1[74] = this.jj_gen;
                tableRef = tableName;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 199: 
            case 715: {
                tableRef = this.ExtendTable(tableRef);
                break;
            }
            default: {
                this.jj_la1[75] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 35: 
            case 39: 
            case 47: 
            case 49: 
            case 53: 
            case 57: 
            case 58: 
            case 61: 
            case 62: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 74: 
            case 78: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 86: 
            case 87: 
            case 88: 
            case 90: 
            case 92: 
            case 93: 
            case 95: 
            case 96: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 104: 
            case 128: 
            case 130: 
            case 131: 
            case 133: 
            case 135: 
            case 136: 
            case 138: 
            case 141: 
            case 145: 
            case 146: 
            case 147: 
            case 149: 
            case 150: 
            case 151: 
            case 154: 
            case 156: 
            case 157: 
            case 159: 
            case 160: 
            case 162: 
            case 165: 
            case 167: 
            case 168: 
            case 170: 
            case 171: 
            case 174: 
            case 175: 
            case 180: 
            case 185: 
            case 187: 
            case 191: 
            case 192: 
            case 193: 
            case 205: 
            case 206: 
            case 210: 
            case 212: 
            case 214: 
            case 215: 
            case 216: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 230: 
            case 231: 
            case 233: 
            case 235: 
            case 239: 
            case 241: 
            case 243: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 252: 
            case 253: 
            case 254: 
            case 257: 
            case 260: 
            case 263: 
            case 264: 
            case 271: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 278: 
            case 286: 
            case 287: 
            case 288: 
            case 289: 
            case 290: 
            case 294: 
            case 300: 
            case 301: 
            case 302: 
            case 310: 
            case 312: 
            case 313: 
            case 315: 
            case 320: 
            case 324: 
            case 325: 
            case 326: 
            case 328: 
            case 329: 
            case 330: 
            case 333: 
            case 334: 
            case 340: 
            case 341: 
            case 343: 
            case 344: 
            case 345: 
            case 346: 
            case 351: 
            case 357: 
            case 362: 
            case 364: 
            case 365: 
            case 367: 
            case 370: 
            case 379: 
            case 380: 
            case 383: 
            case 384: 
            case 385: 
            case 388: 
            case 392: 
            case 393: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 399: 
            case 400: 
            case 401: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 416: 
            case 417: 
            case 418: 
            case 419: 
            case 425: 
            case 428: 
            case 431: 
            case 432: 
            case 434: 
            case 435: 
            case 436: 
            case 439: 
            case 455: 
            case 457: 
            case 458: 
            case 460: 
            case 461: 
            case 462: 
            case 465: 
            case 466: 
            case 467: 
            case 468: 
            case 469: 
            case 473: 
            case 474: 
            case 477: 
            case 478: 
            case 479: 
            case 480: 
            case 482: 
            case 488: 
            case 489: 
            case 490: 
            case 491: 
            case 493: 
            case 494: 
            case 495: 
            case 499: 
            case 500: 
            case 501: 
            case 504: 
            case 506: 
            case 507: 
            case 508: 
            case 509: 
            case 510: 
            case 511: 
            case 514: 
            case 518: 
            case 519: 
            case 523: 
            case 524: 
            case 526: 
            case 532: 
            case 533: 
            case 534: 
            case 535: 
            case 536: 
            case 537: 
            case 538: 
            case 539: 
            case 540: 
            case 541: 
            case 542: 
            case 543: 
            case 544: 
            case 545: 
            case 546: 
            case 547: 
            case 548: 
            case 549: 
            case 550: 
            case 551: 
            case 552: 
            case 553: 
            case 554: 
            case 555: 
            case 556: 
            case 557: 
            case 558: 
            case 559: 
            case 560: 
            case 561: 
            case 562: 
            case 563: 
            case 564: 
            case 565: 
            case 566: 
            case 567: 
            case 568: 
            case 569: 
            case 570: 
            case 571: 
            case 572: 
            case 573: 
            case 574: 
            case 575: 
            case 576: 
            case 577: 
            case 578: 
            case 579: 
            case 580: 
            case 583: 
            case 584: 
            case 589: 
            case 590: 
            case 591: 
            case 592: 
            case 595: 
            case 606: 
            case 608: 
            case 611: 
            case 613: 
            case 614: 
            case 616: 
            case 617: 
            case 618: 
            case 619: 
            case 624: 
            case 626: 
            case 627: 
            case 628: 
            case 629: 
            case 630: 
            case 631: 
            case 637: 
            case 638: 
            case 639: 
            case 645: 
            case 646: 
            case 648: 
            case 649: 
            case 650: 
            case 651: 
            case 655: 
            case 656: 
            case 661: 
            case 663: 
            case 664: 
            case 665: 
            case 666: 
            case 668: 
            case 669: 
            case 670: 
            case 679: 
            case 681: 
            case 683: 
            case 684: 
            case 693: 
            case 694: 
            case 695: 
            case 696: 
            case 698: 
            case 699: 
            case 763: 
            case 764: 
            case 765: 
            case 766: 
            case 767: 
            case 768: 
            case 770: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 23: {
                        this.jj_consume_token(23);
                        break;
                    }
                    default: {
                        this.jj_la1[76] = this.jj_gen;
                    }
                }
                alias = this.SimpleIdentifier();
                break;
            }
            default: {
                this.jj_la1[77] = this.jj_gen;
                alias = null;
            }
        }
        this.jj_consume_token(667);
        SqlNode sourceTableRef = this.TableRef();
        this.jj_consume_token(375);
        SqlNode condition = this.Expression(SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        if (this.jj_2_19(2)) {
            updateCall = this.WhenMatchedClause(tableRef, alias);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 685: {
                    insertCall = this.WhenNotMatchedClause(tableRef);
                    break;
                }
                default: {
                    this.jj_la1[78] = this.jj_gen;
                    insertCall = null;
                    break;
                }
            }
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 685: {
                    updateCall = null;
                    insertCall = this.WhenNotMatchedClause(tableRef);
                    break;
                }
                default: {
                    this.jj_la1[79] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        SqlParserPos pos = s.addIf(updateCall).addIf(insertCall).pos();
        return new SqlMerge(pos, tableRef, condition, sourceTableRef, updateCall, insertCall, null, alias);
    }

    public final SqlUpdate WhenMatchedClause(SqlNode table, SqlIdentifier alias) throws ParseException {
        SqlNodeList updateColumnList = new SqlNodeList(SqlParserPos.ZERO);
        SqlNodeList updateExprList = new SqlNodeList(SqlParserPos.ZERO);
        this.jj_consume_token(685);
        Span s = this.span();
        this.jj_consume_token(315);
        this.jj_consume_token(609);
        this.jj_consume_token(658);
        this.jj_consume_token(513);
        SqlIdentifier id = this.CompoundIdentifier();
        updateColumnList.add(id);
        this.jj_consume_token(728);
        this.AddExpression(updateExprList, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 727: {
                    break;
                }
                default: {
                    this.jj_la1[80] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(727);
            id = this.CompoundIdentifier();
            updateColumnList.add(id);
            this.jj_consume_token(728);
            this.AddExpression(updateExprList, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        }
        return new SqlUpdate(s.addAll(updateExprList).pos(), table, updateColumnList, updateExprList, null, null, alias);
    }

    public final SqlInsert WhenNotMatchedClause(SqlNode table) throws ParseException {
        SqlNode rowConstructor;
        Span valuesSpan;
        ArrayList<SqlLiteral> keywords = new ArrayList<SqlLiteral>();
        this.jj_consume_token(685);
        this.jj_consume_token(358);
        this.jj_consume_token(315);
        this.jj_consume_token(609);
        this.jj_consume_token(262);
        Span insertSpan = this.span();
        this.SqlInsertKeywords(keywords);
        SqlNodeList keywordList = new SqlNodeList(keywords, insertSpan.end(this));
        SqlNodeList insertColumnList = this.jj_2_20(2) ? this.ParenthesizedSimpleIdentifierList() : null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 715: {
                this.jj_consume_token(715);
                this.jj_consume_token(672);
                valuesSpan = this.span();
                rowConstructor = this.RowConstructor();
                this.jj_consume_token(716);
                break;
            }
            case 672: {
                this.jj_consume_token(672);
                valuesSpan = this.span();
                rowConstructor = this.RowConstructor();
                break;
            }
            default: {
                this.jj_la1[81] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        SqlCall insertValues = SqlStdOperatorTable.VALUES.createCall(valuesSpan.end(this), rowConstructor);
        return new SqlInsert(insertSpan.end(this), keywordList, table, insertValues, insertColumnList);
    }

    public final void AddSelectItem(List<SqlNode> list) throws ParseException {
        SqlNode e = this.SelectExpression();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 35: 
            case 39: 
            case 47: 
            case 49: 
            case 53: 
            case 57: 
            case 58: 
            case 61: 
            case 62: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 74: 
            case 78: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 86: 
            case 87: 
            case 88: 
            case 90: 
            case 92: 
            case 93: 
            case 95: 
            case 96: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 104: 
            case 128: 
            case 130: 
            case 131: 
            case 133: 
            case 135: 
            case 136: 
            case 138: 
            case 141: 
            case 145: 
            case 146: 
            case 147: 
            case 149: 
            case 150: 
            case 151: 
            case 154: 
            case 156: 
            case 157: 
            case 159: 
            case 160: 
            case 162: 
            case 165: 
            case 167: 
            case 168: 
            case 170: 
            case 171: 
            case 174: 
            case 175: 
            case 180: 
            case 185: 
            case 187: 
            case 191: 
            case 192: 
            case 193: 
            case 205: 
            case 206: 
            case 210: 
            case 212: 
            case 214: 
            case 215: 
            case 216: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 230: 
            case 231: 
            case 233: 
            case 235: 
            case 239: 
            case 241: 
            case 243: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 252: 
            case 253: 
            case 254: 
            case 257: 
            case 260: 
            case 263: 
            case 264: 
            case 271: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 278: 
            case 286: 
            case 287: 
            case 288: 
            case 289: 
            case 290: 
            case 294: 
            case 300: 
            case 301: 
            case 302: 
            case 310: 
            case 312: 
            case 313: 
            case 315: 
            case 320: 
            case 324: 
            case 325: 
            case 326: 
            case 328: 
            case 329: 
            case 330: 
            case 333: 
            case 334: 
            case 340: 
            case 341: 
            case 343: 
            case 344: 
            case 345: 
            case 346: 
            case 351: 
            case 357: 
            case 362: 
            case 364: 
            case 365: 
            case 367: 
            case 370: 
            case 379: 
            case 380: 
            case 383: 
            case 384: 
            case 385: 
            case 388: 
            case 392: 
            case 393: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 399: 
            case 400: 
            case 401: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 416: 
            case 417: 
            case 418: 
            case 419: 
            case 425: 
            case 428: 
            case 431: 
            case 432: 
            case 434: 
            case 435: 
            case 436: 
            case 439: 
            case 455: 
            case 457: 
            case 458: 
            case 460: 
            case 461: 
            case 462: 
            case 465: 
            case 466: 
            case 467: 
            case 468: 
            case 469: 
            case 473: 
            case 474: 
            case 477: 
            case 478: 
            case 479: 
            case 480: 
            case 482: 
            case 488: 
            case 489: 
            case 490: 
            case 491: 
            case 493: 
            case 494: 
            case 495: 
            case 499: 
            case 500: 
            case 501: 
            case 504: 
            case 506: 
            case 507: 
            case 508: 
            case 509: 
            case 510: 
            case 511: 
            case 514: 
            case 518: 
            case 519: 
            case 523: 
            case 524: 
            case 526: 
            case 532: 
            case 533: 
            case 534: 
            case 535: 
            case 536: 
            case 537: 
            case 538: 
            case 539: 
            case 540: 
            case 541: 
            case 542: 
            case 543: 
            case 544: 
            case 545: 
            case 546: 
            case 547: 
            case 548: 
            case 549: 
            case 550: 
            case 551: 
            case 552: 
            case 553: 
            case 554: 
            case 555: 
            case 556: 
            case 557: 
            case 558: 
            case 559: 
            case 560: 
            case 561: 
            case 562: 
            case 563: 
            case 564: 
            case 565: 
            case 566: 
            case 567: 
            case 568: 
            case 569: 
            case 570: 
            case 571: 
            case 572: 
            case 573: 
            case 574: 
            case 575: 
            case 576: 
            case 577: 
            case 578: 
            case 579: 
            case 580: 
            case 583: 
            case 584: 
            case 589: 
            case 590: 
            case 591: 
            case 592: 
            case 595: 
            case 606: 
            case 608: 
            case 611: 
            case 613: 
            case 614: 
            case 616: 
            case 617: 
            case 618: 
            case 619: 
            case 624: 
            case 626: 
            case 627: 
            case 628: 
            case 629: 
            case 630: 
            case 631: 
            case 637: 
            case 638: 
            case 639: 
            case 645: 
            case 646: 
            case 648: 
            case 649: 
            case 650: 
            case 651: 
            case 655: 
            case 656: 
            case 661: 
            case 663: 
            case 664: 
            case 665: 
            case 666: 
            case 668: 
            case 669: 
            case 670: 
            case 679: 
            case 681: 
            case 683: 
            case 684: 
            case 693: 
            case 694: 
            case 695: 
            case 696: 
            case 698: 
            case 699: 
            case 707: 
            case 763: 
            case 764: 
            case 765: 
            case 766: 
            case 767: 
            case 768: 
            case 770: {
                SqlIdentifier id;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 23: {
                        this.jj_consume_token(23);
                        break;
                    }
                    default: {
                        this.jj_la1[82] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 14: 
                    case 17: 
                    case 20: 
                    case 21: 
                    case 24: 
                    case 26: 
                    case 27: 
                    case 31: 
                    case 32: 
                    case 35: 
                    case 39: 
                    case 47: 
                    case 49: 
                    case 53: 
                    case 57: 
                    case 58: 
                    case 61: 
                    case 62: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 74: 
                    case 78: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 86: 
                    case 87: 
                    case 88: 
                    case 90: 
                    case 92: 
                    case 93: 
                    case 95: 
                    case 96: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 104: 
                    case 128: 
                    case 130: 
                    case 131: 
                    case 133: 
                    case 135: 
                    case 136: 
                    case 138: 
                    case 141: 
                    case 145: 
                    case 146: 
                    case 147: 
                    case 149: 
                    case 150: 
                    case 151: 
                    case 154: 
                    case 156: 
                    case 157: 
                    case 159: 
                    case 160: 
                    case 162: 
                    case 165: 
                    case 167: 
                    case 168: 
                    case 170: 
                    case 171: 
                    case 174: 
                    case 175: 
                    case 180: 
                    case 185: 
                    case 187: 
                    case 191: 
                    case 192: 
                    case 193: 
                    case 205: 
                    case 206: 
                    case 210: 
                    case 212: 
                    case 214: 
                    case 215: 
                    case 216: 
                    case 224: 
                    case 225: 
                    case 226: 
                    case 227: 
                    case 230: 
                    case 231: 
                    case 233: 
                    case 235: 
                    case 239: 
                    case 241: 
                    case 243: 
                    case 245: 
                    case 246: 
                    case 247: 
                    case 248: 
                    case 249: 
                    case 252: 
                    case 253: 
                    case 254: 
                    case 257: 
                    case 260: 
                    case 263: 
                    case 264: 
                    case 271: 
                    case 273: 
                    case 274: 
                    case 275: 
                    case 276: 
                    case 278: 
                    case 286: 
                    case 287: 
                    case 288: 
                    case 289: 
                    case 290: 
                    case 294: 
                    case 300: 
                    case 301: 
                    case 302: 
                    case 310: 
                    case 312: 
                    case 313: 
                    case 315: 
                    case 320: 
                    case 324: 
                    case 325: 
                    case 326: 
                    case 328: 
                    case 329: 
                    case 330: 
                    case 333: 
                    case 334: 
                    case 340: 
                    case 341: 
                    case 343: 
                    case 344: 
                    case 345: 
                    case 346: 
                    case 351: 
                    case 357: 
                    case 362: 
                    case 364: 
                    case 365: 
                    case 367: 
                    case 370: 
                    case 379: 
                    case 380: 
                    case 383: 
                    case 384: 
                    case 385: 
                    case 388: 
                    case 392: 
                    case 393: 
                    case 395: 
                    case 396: 
                    case 397: 
                    case 398: 
                    case 399: 
                    case 400: 
                    case 401: 
                    case 403: 
                    case 404: 
                    case 405: 
                    case 406: 
                    case 407: 
                    case 416: 
                    case 417: 
                    case 418: 
                    case 419: 
                    case 425: 
                    case 428: 
                    case 431: 
                    case 432: 
                    case 434: 
                    case 435: 
                    case 436: 
                    case 439: 
                    case 455: 
                    case 457: 
                    case 458: 
                    case 460: 
                    case 461: 
                    case 462: 
                    case 465: 
                    case 466: 
                    case 467: 
                    case 468: 
                    case 469: 
                    case 473: 
                    case 474: 
                    case 477: 
                    case 478: 
                    case 479: 
                    case 480: 
                    case 482: 
                    case 488: 
                    case 489: 
                    case 490: 
                    case 491: 
                    case 493: 
                    case 494: 
                    case 495: 
                    case 499: 
                    case 500: 
                    case 501: 
                    case 504: 
                    case 506: 
                    case 507: 
                    case 508: 
                    case 509: 
                    case 510: 
                    case 511: 
                    case 514: 
                    case 518: 
                    case 519: 
                    case 523: 
                    case 524: 
                    case 526: 
                    case 532: 
                    case 533: 
                    case 534: 
                    case 535: 
                    case 536: 
                    case 537: 
                    case 538: 
                    case 539: 
                    case 540: 
                    case 541: 
                    case 542: 
                    case 543: 
                    case 544: 
                    case 545: 
                    case 546: 
                    case 547: 
                    case 548: 
                    case 549: 
                    case 550: 
                    case 551: 
                    case 552: 
                    case 553: 
                    case 554: 
                    case 555: 
                    case 556: 
                    case 557: 
                    case 558: 
                    case 559: 
                    case 560: 
                    case 561: 
                    case 562: 
                    case 563: 
                    case 564: 
                    case 565: 
                    case 566: 
                    case 567: 
                    case 568: 
                    case 569: 
                    case 570: 
                    case 571: 
                    case 572: 
                    case 573: 
                    case 574: 
                    case 575: 
                    case 576: 
                    case 577: 
                    case 578: 
                    case 579: 
                    case 580: 
                    case 583: 
                    case 584: 
                    case 589: 
                    case 590: 
                    case 591: 
                    case 592: 
                    case 595: 
                    case 606: 
                    case 608: 
                    case 611: 
                    case 613: 
                    case 614: 
                    case 616: 
                    case 617: 
                    case 618: 
                    case 619: 
                    case 624: 
                    case 626: 
                    case 627: 
                    case 628: 
                    case 629: 
                    case 630: 
                    case 631: 
                    case 637: 
                    case 638: 
                    case 639: 
                    case 645: 
                    case 646: 
                    case 648: 
                    case 649: 
                    case 650: 
                    case 651: 
                    case 655: 
                    case 656: 
                    case 661: 
                    case 663: 
                    case 664: 
                    case 665: 
                    case 666: 
                    case 668: 
                    case 669: 
                    case 670: 
                    case 679: 
                    case 681: 
                    case 683: 
                    case 684: 
                    case 693: 
                    case 694: 
                    case 695: 
                    case 696: 
                    case 698: 
                    case 699: 
                    case 763: 
                    case 764: 
                    case 765: 
                    case 766: 
                    case 767: 
                    case 768: 
                    case 770: {
                        id = this.SimpleIdentifier();
                        break;
                    }
                    case 707: {
                        id = this.SimpleIdentifierFromStringLiteral();
                        break;
                    }
                    default: {
                        this.jj_la1[83] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                list.add(SqlStdOperatorTable.AS.createCall(this.span().end(e), e, id));
                break;
            }
            default: {
                this.jj_la1[84] = this.jj_gen;
                list.add(e);
            }
        }
    }

    public final SqlNode SelectExpression() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 739: {
                this.jj_consume_token(739);
                return SqlIdentifier.star(this.getPos());
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 39: 
            case 47: 
            case 49: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 74: 
            case 77: 
            case 78: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 86: 
            case 87: 
            case 88: 
            case 90: 
            case 92: 
            case 93: 
            case 95: 
            case 96: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 104: 
            case 105: 
            case 108: 
            case 109: 
            case 110: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 122: 
            case 123: 
            case 124: 
            case 126: 
            case 127: 
            case 128: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 138: 
            case 141: 
            case 145: 
            case 146: 
            case 147: 
            case 149: 
            case 150: 
            case 151: 
            case 153: 
            case 154: 
            case 156: 
            case 157: 
            case 159: 
            case 160: 
            case 162: 
            case 165: 
            case 167: 
            case 168: 
            case 170: 
            case 171: 
            case 174: 
            case 175: 
            case 177: 
            case 180: 
            case 185: 
            case 187: 
            case 189: 
            case 191: 
            case 192: 
            case 193: 
            case 196: 
            case 197: 
            case 201: 
            case 202: 
            case 205: 
            case 206: 
            case 207: 
            case 209: 
            case 210: 
            case 212: 
            case 214: 
            case 215: 
            case 216: 
            case 223: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 230: 
            case 231: 
            case 233: 
            case 235: 
            case 236: 
            case 239: 
            case 241: 
            case 242: 
            case 243: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 252: 
            case 253: 
            case 254: 
            case 257: 
            case 260: 
            case 263: 
            case 264: 
            case 268: 
            case 269: 
            case 271: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 278: 
            case 279: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 284: 
            case 285: 
            case 286: 
            case 287: 
            case 288: 
            case 289: 
            case 290: 
            case 291: 
            case 294: 
            case 295: 
            case 297: 
            case 299: 
            case 300: 
            case 301: 
            case 302: 
            case 306: 
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 313: 
            case 315: 
            case 317: 
            case 319: 
            case 320: 
            case 324: 
            case 325: 
            case 326: 
            case 328: 
            case 329: 
            case 330: 
            case 331: 
            case 332: 
            case 333: 
            case 334: 
            case 335: 
            case 339: 
            case 340: 
            case 341: 
            case 342: 
            case 343: 
            case 344: 
            case 345: 
            case 346: 
            case 351: 
            case 352: 
            case 353: 
            case 357: 
            case 358: 
            case 359: 
            case 360: 
            case 361: 
            case 362: 
            case 363: 
            case 364: 
            case 365: 
            case 367: 
            case 369: 
            case 370: 
            case 379: 
            case 380: 
            case 383: 
            case 384: 
            case 385: 
            case 388: 
            case 391: 
            case 392: 
            case 393: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 399: 
            case 400: 
            case 401: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 411: 
            case 412: 
            case 413: 
            case 414: 
            case 416: 
            case 417: 
            case 418: 
            case 419: 
            case 421: 
            case 423: 
            case 425: 
            case 428: 
            case 429: 
            case 431: 
            case 432: 
            case 434: 
            case 435: 
            case 436: 
            case 438: 
            case 439: 
            case 448: 
            case 452: 
            case 454: 
            case 455: 
            case 457: 
            case 458: 
            case 460: 
            case 461: 
            case 462: 
            case 465: 
            case 466: 
            case 467: 
            case 468: 
            case 469: 
            case 472: 
            case 473: 
            case 474: 
            case 477: 
            case 478: 
            case 479: 
            case 480: 
            case 481: 
            case 482: 
            case 483: 
            case 485: 
            case 488: 
            case 489: 
            case 490: 
            case 491: 
            case 493: 
            case 494: 
            case 495: 
            case 498: 
            case 499: 
            case 500: 
            case 501: 
            case 504: 
            case 506: 
            case 507: 
            case 508: 
            case 509: 
            case 510: 
            case 511: 
            case 512: 
            case 514: 
            case 518: 
            case 519: 
            case 522: 
            case 523: 
            case 524: 
            case 525: 
            case 526: 
            case 532: 
            case 533: 
            case 534: 
            case 535: 
            case 536: 
            case 537: 
            case 538: 
            case 539: 
            case 540: 
            case 541: 
            case 542: 
            case 543: 
            case 544: 
            case 545: 
            case 546: 
            case 547: 
            case 548: 
            case 549: 
            case 550: 
            case 551: 
            case 552: 
            case 553: 
            case 554: 
            case 555: 
            case 556: 
            case 557: 
            case 558: 
            case 559: 
            case 560: 
            case 561: 
            case 562: 
            case 563: 
            case 564: 
            case 565: 
            case 566: 
            case 567: 
            case 568: 
            case 569: 
            case 570: 
            case 571: 
            case 572: 
            case 573: 
            case 574: 
            case 575: 
            case 576: 
            case 577: 
            case 578: 
            case 579: 
            case 580: 
            case 581: 
            case 583: 
            case 584: 
            case 586: 
            case 587: 
            case 589: 
            case 590: 
            case 591: 
            case 592: 
            case 595: 
            case 596: 
            case 599: 
            case 604: 
            case 606: 
            case 608: 
            case 611: 
            case 612: 
            case 613: 
            case 614: 
            case 615: 
            case 616: 
            case 617: 
            case 618: 
            case 619: 
            case 624: 
            case 626: 
            case 627: 
            case 628: 
            case 629: 
            case 630: 
            case 631: 
            case 632: 
            case 637: 
            case 638: 
            case 639: 
            case 640: 
            case 642: 
            case 643: 
            case 645: 
            case 646: 
            case 648: 
            case 649: 
            case 650: 
            case 651: 
            case 653: 
            case 654: 
            case 655: 
            case 656: 
            case 659: 
            case 661: 
            case 662: 
            case 663: 
            case 664: 
            case 665: 
            case 666: 
            case 668: 
            case 669: 
            case 670: 
            case 674: 
            case 675: 
            case 679: 
            case 681: 
            case 683: 
            case 684: 
            case 693: 
            case 694: 
            case 695: 
            case 696: 
            case 697: 
            case 698: 
            case 699: 
            case 700: 
            case 701: 
            case 702: 
            case 706: 
            case 707: 
            case 708: 
            case 709: 
            case 710: 
            case 712: 
            case 713: 
            case 715: 
            case 717: 
            case 718: 
            case 719: 
            case 720: 
            case 731: 
            case 737: 
            case 738: 
            case 763: 
            case 764: 
            case 765: 
            case 766: 
            case 767: 
            case 768: 
            case 770: {
                SqlNode e = this.Expression(SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                return e;
            }
        }
        this.jj_la1[85] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SqlLiteral Natural() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 348: {
                this.jj_consume_token(348);
                return SqlLiteral.createBoolean(true, this.getPos());
            }
        }
        this.jj_la1[86] = this.jj_gen;
        return SqlLiteral.createBoolean(false, this.getPos());
    }

    public final SqlLiteral JoinType() throws ParseException {
        JoinType joinType;
        if (this.jj_2_21(3)) {
            this.jj_consume_token(277);
            joinType = JoinType.INNER;
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 258: {
                    this.jj_consume_token(258);
                    this.jj_consume_token(277);
                    joinType = JoinType.INNER;
                    break;
                }
                case 299: {
                    this.jj_consume_token(299);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 387: {
                            this.jj_consume_token(387);
                            break;
                        }
                        default: {
                            this.jj_la1[87] = this.jj_gen;
                        }
                    }
                    this.jj_consume_token(277);
                    joinType = JoinType.LEFT;
                    break;
                }
                case 472: {
                    this.jj_consume_token(472);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 387: {
                            this.jj_consume_token(387);
                            break;
                        }
                        default: {
                            this.jj_la1[88] = this.jj_gen;
                        }
                    }
                    this.jj_consume_token(277);
                    joinType = JoinType.RIGHT;
                    break;
                }
                case 221: {
                    this.jj_consume_token(221);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 387: {
                            this.jj_consume_token(387);
                            break;
                        }
                        default: {
                            this.jj_la1[89] = this.jj_gen;
                        }
                    }
                    this.jj_consume_token(277);
                    joinType = JoinType.FULL;
                    break;
                }
                case 112: {
                    this.jj_consume_token(112);
                    this.jj_consume_token(277);
                    joinType = JoinType.CROSS;
                    break;
                }
                default: {
                    this.jj_la1[90] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return joinType.symbol(this.getPos());
    }

    public final SqlNode FromClause() throws ParseException {
        SqlNode e = this.Join();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 727: {
                    break;
                }
                default: {
                    this.jj_la1[91] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(727);
            SqlLiteral joinType = JoinType.COMMA.symbol(this.getPos());
            SqlNode e2 = this.Join();
            e = new SqlJoin(joinType.getParserPosition(), e, SqlLiteral.createBoolean(false, joinType.getParserPosition()), joinType, e2, JoinConditionType.NONE.symbol(SqlParserPos.ZERO), null);
        }
        return e;
    }

    public final SqlNode Join() throws ParseException {
        SqlNode e = this.TableRef1(SqlAbstractParserImpl.ExprContext.ACCEPT_QUERY_OR_JOIN);
        while (this.jj_2_22(2)) {
            e = this.JoinTable(e);
        }
        return e;
    }

    public final SqlNode JoinTable(SqlNode e) throws ParseException {
        if (this.jj_2_23(3)) {
            SqlLiteral natural = this.Natural();
            SqlLiteral joinType = this.JoinType();
            SqlNode e2 = this.TableRef1(SqlAbstractParserImpl.ExprContext.ACCEPT_QUERY_OR_JOIN);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 375: {
                    this.jj_consume_token(375);
                    SqlLiteral on = JoinConditionType.ON.symbol(this.getPos());
                    SqlNode condition = this.Expression(SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                    return new SqlJoin(joinType.getParserPosition(), e, natural, joinType, e2, on, condition);
                }
                case 667: {
                    this.jj_consume_token(667);
                    SqlLiteral using = JoinConditionType.USING.symbol(this.getPos());
                    SqlNodeList list = this.ParenthesizedSimpleIdentifierList();
                    return new SqlJoin(joinType.getParserPosition(), e, natural, joinType, e2, using, new SqlNodeList(list, Span.of(using).end(this)));
                }
            }
            this.jj_la1[92] = this.jj_gen;
            return new SqlJoin(joinType.getParserPosition(), e, natural, joinType, e2, JoinConditionType.NONE.symbol(joinType.getParserPosition()), null);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 112: {
                this.jj_consume_token(112);
                SqlLiteral joinType = JoinType.CROSS.symbol(this.getPos());
                this.jj_consume_token(17);
                SqlNode e2 = this.TableRef2(true);
                if (!this.conformance.isApplyAllowed()) {
                    throw SqlUtil.newContextException(this.getPos(), Static.RESOURCE.applyNotAllowed());
                }
                return new SqlJoin(joinType.getParserPosition(), e, SqlLiteral.createBoolean(false, joinType.getParserPosition()), joinType, e2, JoinConditionType.NONE.symbol(SqlParserPos.ZERO), null);
            }
            case 387: {
                this.jj_consume_token(387);
                SqlLiteral joinType = JoinType.LEFT.symbol(this.getPos());
                this.jj_consume_token(17);
                SqlNode e2 = this.TableRef2(true);
                if (!this.conformance.isApplyAllowed()) {
                    throw SqlUtil.newContextException(this.getPos(), Static.RESOURCE.applyNotAllowed());
                }
                return new SqlJoin(joinType.getParserPosition(), e, SqlLiteral.createBoolean(false, joinType.getParserPosition()), joinType, e2, JoinConditionType.ON.symbol(SqlParserPos.ZERO), SqlLiteral.createBoolean(true, joinType.getParserPosition()));
            }
        }
        this.jj_la1[93] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SqlNode TableRef() throws ParseException {
        SqlNode e = this.TableRef3(SqlAbstractParserImpl.ExprContext.ACCEPT_QUERY, false);
        return e;
    }

    public final SqlNode TableRef1(SqlAbstractParserImpl.ExprContext exprContext) throws ParseException {
        SqlNode e = this.TableRef3(exprContext, false);
        return e;
    }

    public final SqlNode TableRef2(boolean lateral) throws ParseException {
        SqlNode e = this.TableRef3(SqlAbstractParserImpl.ExprContext.ACCEPT_QUERY, lateral);
        return e;
    }

    public final SqlNode TableRef3(SqlAbstractParserImpl.ExprContext exprContext, boolean lateral) throws ParseException {
        SqlNode tableRef;
        SqlUnnestOperator unnestOp = SqlStdOperatorTable.UNNEST;
        if (this.jj_2_24(2)) {
            SqlIdentifier tableName = this.CompoundTableIdentifier();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 755: {
                    tableRef = this.TableHints(tableName);
                    break;
                }
                default: {
                    this.jj_la1[94] = this.jj_gen;
                    tableRef = tableName;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 199: 
                case 715: {
                    tableRef = this.ExtendTable(tableRef);
                    break;
                }
                default: {
                    this.jj_la1[95] = this.jj_gen;
                }
            }
            tableRef = this.Over(tableRef);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 211: {
                    tableRef = this.Snapshot(tableRef);
                    break;
                }
                default: {
                    this.jj_la1[96] = this.jj_gen;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 318: {
                    tableRef = this.MatchRecognize(tableRef);
                    break;
                }
                default: {
                    this.jj_la1[97] = this.jj_gen;
                    break;
                }
            }
        } else if (this.jj_2_25(2)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 296: {
                    this.jj_consume_token(296);
                    lateral = true;
                    break;
                }
                default: {
                    this.jj_la1[98] = this.jj_gen;
                }
            }
            tableRef = this.ParenthesizedExpression(exprContext);
            tableRef = this.Over(tableRef);
            tableRef = this.addLateral(tableRef, lateral);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 318: {
                    tableRef = this.MatchRecognize(tableRef);
                    break;
                }
                default: {
                    this.jj_la1[99] = this.jj_gen;
                    break;
                }
            }
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 657: {
                    this.jj_consume_token(657);
                    Span s = this.span();
                    SqlNodeList args = this.ParenthesizedQueryOrCommaList(SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 690: {
                            this.jj_consume_token(690);
                            this.jj_consume_token(384);
                            unnestOp = SqlStdOperatorTable.UNNEST_WITH_ORDINALITY;
                            break;
                        }
                        default: {
                            this.jj_la1[100] = this.jj_gen;
                        }
                    }
                    tableRef = unnestOp.createCall(s.end(this), (List<? extends SqlNode>)args);
                    break;
                }
                case 296: 
                case 605: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 296: {
                            this.jj_consume_token(296);
                            lateral = true;
                            break;
                        }
                        default: {
                            this.jj_la1[101] = this.jj_gen;
                        }
                    }
                    tableRef = this.TableFunctionCall();
                    tableRef = this.addLateral(tableRef, lateral);
                    break;
                }
                default: {
                    this.jj_la1[102] = this.jj_gen;
                    if (this.jj_2_26(1)) {
                        tableRef = this.ExtendedTableRef();
                        break;
                    }
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        if (this.jj_2_27(2)) {
            tableRef = this.Pivot(tableRef);
        }
        if (this.jj_2_28(2)) {
            tableRef = this.Unpivot(tableRef);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 35: 
            case 39: 
            case 47: 
            case 49: 
            case 53: 
            case 57: 
            case 58: 
            case 61: 
            case 62: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 74: 
            case 78: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 86: 
            case 87: 
            case 88: 
            case 90: 
            case 92: 
            case 93: 
            case 95: 
            case 96: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 104: 
            case 128: 
            case 130: 
            case 131: 
            case 133: 
            case 135: 
            case 136: 
            case 138: 
            case 141: 
            case 145: 
            case 146: 
            case 147: 
            case 149: 
            case 150: 
            case 151: 
            case 154: 
            case 156: 
            case 157: 
            case 159: 
            case 160: 
            case 162: 
            case 165: 
            case 167: 
            case 168: 
            case 170: 
            case 171: 
            case 174: 
            case 175: 
            case 180: 
            case 185: 
            case 187: 
            case 191: 
            case 192: 
            case 193: 
            case 205: 
            case 206: 
            case 210: 
            case 212: 
            case 214: 
            case 215: 
            case 216: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 230: 
            case 231: 
            case 233: 
            case 235: 
            case 239: 
            case 241: 
            case 243: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 252: 
            case 253: 
            case 254: 
            case 257: 
            case 260: 
            case 263: 
            case 264: 
            case 271: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 278: 
            case 286: 
            case 287: 
            case 288: 
            case 289: 
            case 290: 
            case 294: 
            case 300: 
            case 301: 
            case 302: 
            case 310: 
            case 312: 
            case 313: 
            case 315: 
            case 320: 
            case 324: 
            case 325: 
            case 326: 
            case 328: 
            case 329: 
            case 330: 
            case 333: 
            case 334: 
            case 340: 
            case 341: 
            case 343: 
            case 344: 
            case 345: 
            case 346: 
            case 351: 
            case 357: 
            case 362: 
            case 364: 
            case 365: 
            case 367: 
            case 370: 
            case 379: 
            case 380: 
            case 383: 
            case 384: 
            case 385: 
            case 388: 
            case 392: 
            case 393: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 399: 
            case 400: 
            case 401: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 416: 
            case 417: 
            case 418: 
            case 419: 
            case 425: 
            case 428: 
            case 431: 
            case 432: 
            case 434: 
            case 435: 
            case 436: 
            case 439: 
            case 455: 
            case 457: 
            case 458: 
            case 460: 
            case 461: 
            case 462: 
            case 465: 
            case 466: 
            case 467: 
            case 468: 
            case 469: 
            case 473: 
            case 474: 
            case 477: 
            case 478: 
            case 479: 
            case 480: 
            case 482: 
            case 488: 
            case 489: 
            case 490: 
            case 491: 
            case 493: 
            case 494: 
            case 495: 
            case 499: 
            case 500: 
            case 501: 
            case 504: 
            case 506: 
            case 507: 
            case 508: 
            case 509: 
            case 510: 
            case 511: 
            case 514: 
            case 518: 
            case 519: 
            case 523: 
            case 524: 
            case 526: 
            case 532: 
            case 533: 
            case 534: 
            case 535: 
            case 536: 
            case 537: 
            case 538: 
            case 539: 
            case 540: 
            case 541: 
            case 542: 
            case 543: 
            case 544: 
            case 545: 
            case 546: 
            case 547: 
            case 548: 
            case 549: 
            case 550: 
            case 551: 
            case 552: 
            case 553: 
            case 554: 
            case 555: 
            case 556: 
            case 557: 
            case 558: 
            case 559: 
            case 560: 
            case 561: 
            case 562: 
            case 563: 
            case 564: 
            case 565: 
            case 566: 
            case 567: 
            case 568: 
            case 569: 
            case 570: 
            case 571: 
            case 572: 
            case 573: 
            case 574: 
            case 575: 
            case 576: 
            case 577: 
            case 578: 
            case 579: 
            case 580: 
            case 583: 
            case 584: 
            case 589: 
            case 590: 
            case 591: 
            case 592: 
            case 595: 
            case 606: 
            case 608: 
            case 611: 
            case 613: 
            case 614: 
            case 616: 
            case 617: 
            case 618: 
            case 619: 
            case 624: 
            case 626: 
            case 627: 
            case 628: 
            case 629: 
            case 630: 
            case 631: 
            case 637: 
            case 638: 
            case 639: 
            case 645: 
            case 646: 
            case 648: 
            case 649: 
            case 650: 
            case 651: 
            case 655: 
            case 656: 
            case 661: 
            case 663: 
            case 664: 
            case 665: 
            case 666: 
            case 668: 
            case 669: 
            case 670: 
            case 679: 
            case 681: 
            case 683: 
            case 684: 
            case 693: 
            case 694: 
            case 695: 
            case 696: 
            case 698: 
            case 699: 
            case 763: 
            case 764: 
            case 765: 
            case 766: 
            case 767: 
            case 768: 
            case 770: {
                SqlNodeList columnAliasList;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 23: {
                        this.jj_consume_token(23);
                        break;
                    }
                    default: {
                        this.jj_la1[103] = this.jj_gen;
                    }
                }
                SqlIdentifier alias = this.SimpleIdentifier();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 715: {
                        columnAliasList = this.ParenthesizedSimpleIdentifierList();
                        break;
                    }
                    default: {
                        this.jj_la1[104] = this.jj_gen;
                        columnAliasList = null;
                    }
                }
                this.checkNotJoin(tableRef);
                if (columnAliasList == null) {
                    tableRef = SqlStdOperatorTable.AS.createCall(Span.of(tableRef).end(this), tableRef, alias);
                    break;
                }
                ArrayList<SqlNode> idList = new ArrayList<SqlNode>();
                idList.add(tableRef);
                idList.add(alias);
                idList.addAll(columnAliasList.getList());
                tableRef = SqlStdOperatorTable.AS.createCall(Span.of(tableRef).end(this), idList);
                break;
            }
            default: {
                this.jj_la1[105] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 607: {
                tableRef = this.Tablesample(tableRef);
                break;
            }
            default: {
                this.jj_la1[106] = this.jj_gen;
            }
        }
        return tableRef;
    }

    public final SqlNode Tablesample(SqlNode tableRef) throws ParseException {
        boolean isRepeatable = false;
        int repeatableSeed = 0;
        this.jj_consume_token(607);
        Span s = this.span();
        this.checkNotJoin(tableRef);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 595: {
                this.jj_consume_token(595);
                this.jj_consume_token(715);
                SqlNode sample = this.StringLiteral();
                this.jj_consume_token(716);
                String sampleName = SqlLiteral.unchain(sample).getValueAs(String.class);
                SqlSampleSpec sampleSpec = SqlSampleSpec.createNamed(sampleName);
                SqlLiteral sampleLiteral = SqlLiteral.createSample(sampleSpec, s.end(this));
                tableRef = SqlStdOperatorTable.TABLESAMPLE.createCall(s.add(tableRef).end(this), tableRef, sampleLiteral);
                break;
            }
            case 39: 
            case 602: {
                boolean isBernoulli;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 39: {
                        this.jj_consume_token(39);
                        isBernoulli = true;
                        break;
                    }
                    case 602: {
                        this.jj_consume_token(602);
                        isBernoulli = false;
                        break;
                    }
                    default: {
                        this.jj_la1[107] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_consume_token(715);
                SqlNumericLiteral samplePercentage = this.UnsignedNumericLiteral();
                this.jj_consume_token(716);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 457: {
                        this.jj_consume_token(457);
                        this.jj_consume_token(715);
                        repeatableSeed = this.IntLiteral();
                        this.jj_consume_token(716);
                        isRepeatable = true;
                        break;
                    }
                    default: {
                        this.jj_la1[108] = this.jj_gen;
                    }
                }
                BigDecimal ONE_HUNDRED = BigDecimal.valueOf(100L);
                BigDecimal rate = samplePercentage.bigDecimalValue();
                if (rate.compareTo(BigDecimal.ZERO) < 0 || rate.compareTo(ONE_HUNDRED) > 0) {
                    throw SqlUtil.newContextException(this.getPos(), Static.RESOURCE.invalidSampleSize());
                }
                float fRate = rate.divide(ONE_HUNDRED).floatValue();
                if (!(fRate > 0.0f) || !(fRate < 1.0f)) break;
                SqlSampleSpec tableSampleSpec = isRepeatable ? SqlSampleSpec.createTableSample(isBernoulli, fRate, repeatableSeed) : SqlSampleSpec.createTableSample(isBernoulli, fRate);
                SqlLiteral tableSampleLiteral = SqlLiteral.createSample(tableSampleSpec, s.end(this));
                tableRef = SqlStdOperatorTable.TABLESAMPLE.createCall(s.end(this), tableRef, tableSampleLiteral);
                break;
            }
            default: {
                this.jj_la1[109] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return tableRef;
    }

    public final SqlNode ExtendTable(SqlNode tableRef) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 199: {
                this.jj_consume_token(199);
                break;
            }
            default: {
                this.jj_la1[110] = this.jj_gen;
            }
        }
        SqlNodeList extendList = this.ExtendList();
        return this.extend(tableRef, extendList);
    }

    public final SqlNodeList ExtendList() throws ParseException {
        ArrayList<SqlNode> list = new ArrayList<SqlNode>();
        this.jj_consume_token(715);
        Span s = this.span();
        this.AddColumnType(list);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 727: {
                    break;
                }
                default: {
                    this.jj_la1[111] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(727);
            this.AddColumnType(list);
        }
        this.jj_consume_token(716);
        return new SqlNodeList(list, s.end(this));
    }

    public final void AddColumnType(List<SqlNode> list) throws ParseException {
        SqlIdentifier name = this.CompoundIdentifier();
        SqlDataTypeSpec type = this.DataType();
        boolean nullable = this.NotNullOpt();
        list.add(name);
        list.add(type.withNullable(nullable, this.getPos()));
    }

    public final void AddCompoundIdentifierType(List<SqlNode> list, List<SqlNode> extendList) throws ParseException {
        boolean nullable;
        SqlDataTypeSpec type;
        SqlIdentifier name = this.CompoundIdentifier();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 24: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 35: 
            case 39: 
            case 41: 
            case 42: 
            case 45: 
            case 47: 
            case 49: 
            case 53: 
            case 57: 
            case 58: 
            case 61: 
            case 62: 
            case 63: 
            case 65: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 74: 
            case 78: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 86: 
            case 87: 
            case 88: 
            case 90: 
            case 92: 
            case 93: 
            case 95: 
            case 96: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 104: 
            case 128: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 135: 
            case 136: 
            case 138: 
            case 140: 
            case 141: 
            case 142: 
            case 145: 
            case 146: 
            case 147: 
            case 149: 
            case 150: 
            case 151: 
            case 154: 
            case 156: 
            case 157: 
            case 159: 
            case 160: 
            case 162: 
            case 165: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 174: 
            case 175: 
            case 180: 
            case 185: 
            case 187: 
            case 191: 
            case 192: 
            case 193: 
            case 205: 
            case 206: 
            case 208: 
            case 210: 
            case 212: 
            case 214: 
            case 215: 
            case 216: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 230: 
            case 231: 
            case 233: 
            case 235: 
            case 239: 
            case 241: 
            case 243: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 252: 
            case 253: 
            case 254: 
            case 257: 
            case 260: 
            case 263: 
            case 264: 
            case 265: 
            case 266: 
            case 271: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 278: 
            case 286: 
            case 287: 
            case 288: 
            case 289: 
            case 290: 
            case 294: 
            case 300: 
            case 301: 
            case 302: 
            case 310: 
            case 312: 
            case 313: 
            case 315: 
            case 320: 
            case 324: 
            case 325: 
            case 326: 
            case 328: 
            case 329: 
            case 330: 
            case 333: 
            case 334: 
            case 340: 
            case 341: 
            case 343: 
            case 344: 
            case 345: 
            case 346: 
            case 351: 
            case 357: 
            case 362: 
            case 364: 
            case 365: 
            case 366: 
            case 367: 
            case 370: 
            case 379: 
            case 380: 
            case 383: 
            case 384: 
            case 385: 
            case 388: 
            case 392: 
            case 393: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 399: 
            case 400: 
            case 401: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 416: 
            case 417: 
            case 418: 
            case 419: 
            case 425: 
            case 428: 
            case 431: 
            case 432: 
            case 434: 
            case 435: 
            case 436: 
            case 439: 
            case 441: 
            case 455: 
            case 457: 
            case 458: 
            case 460: 
            case 461: 
            case 462: 
            case 465: 
            case 466: 
            case 467: 
            case 468: 
            case 469: 
            case 473: 
            case 474: 
            case 477: 
            case 478: 
            case 479: 
            case 480: 
            case 481: 
            case 482: 
            case 488: 
            case 489: 
            case 490: 
            case 491: 
            case 493: 
            case 494: 
            case 495: 
            case 499: 
            case 500: 
            case 501: 
            case 504: 
            case 506: 
            case 507: 
            case 508: 
            case 509: 
            case 510: 
            case 511: 
            case 514: 
            case 518: 
            case 519: 
            case 521: 
            case 523: 
            case 524: 
            case 526: 
            case 532: 
            case 533: 
            case 534: 
            case 535: 
            case 536: 
            case 537: 
            case 538: 
            case 539: 
            case 540: 
            case 541: 
            case 542: 
            case 543: 
            case 544: 
            case 545: 
            case 546: 
            case 547: 
            case 548: 
            case 549: 
            case 550: 
            case 551: 
            case 552: 
            case 553: 
            case 554: 
            case 555: 
            case 556: 
            case 557: 
            case 558: 
            case 559: 
            case 560: 
            case 561: 
            case 562: 
            case 563: 
            case 564: 
            case 565: 
            case 566: 
            case 567: 
            case 568: 
            case 569: 
            case 570: 
            case 571: 
            case 572: 
            case 573: 
            case 574: 
            case 575: 
            case 576: 
            case 577: 
            case 578: 
            case 579: 
            case 580: 
            case 583: 
            case 584: 
            case 589: 
            case 590: 
            case 591: 
            case 592: 
            case 595: 
            case 606: 
            case 608: 
            case 611: 
            case 612: 
            case 613: 
            case 614: 
            case 615: 
            case 616: 
            case 617: 
            case 618: 
            case 619: 
            case 622: 
            case 624: 
            case 626: 
            case 627: 
            case 628: 
            case 629: 
            case 630: 
            case 631: 
            case 637: 
            case 638: 
            case 639: 
            case 645: 
            case 646: 
            case 648: 
            case 649: 
            case 650: 
            case 651: 
            case 655: 
            case 656: 
            case 661: 
            case 663: 
            case 664: 
            case 665: 
            case 666: 
            case 668: 
            case 669: 
            case 670: 
            case 676: 
            case 677: 
            case 679: 
            case 681: 
            case 683: 
            case 684: 
            case 693: 
            case 694: 
            case 695: 
            case 696: 
            case 698: 
            case 699: 
            case 763: 
            case 764: 
            case 765: 
            case 766: 
            case 767: 
            case 768: 
            case 770: {
                type = this.DataType();
                nullable = this.NotNullOpt();
                break;
            }
            default: {
                this.jj_la1[112] = this.jj_gen;
                type = null;
                nullable = true;
            }
        }
        if (type != null) {
            if (!this.conformance.allowExtend()) {
                throw SqlUtil.newContextException(type.getParserPosition(), Static.RESOURCE.extendNotAllowed());
            }
            extendList.add(name);
            extendList.add(type.withNullable(nullable, this.getPos()));
        }
        list.add(name);
    }

    public final SqlNode TableFunctionCall() throws ParseException {
        SqlFunctionCategory funcType = SqlFunctionCategory.USER_DEFINED_TABLE_FUNCTION;
        this.jj_consume_token(605);
        Span s = this.span();
        this.jj_consume_token(715);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 525: {
                this.jj_consume_token(525);
                funcType = SqlFunctionCategory.USER_DEFINED_TABLE_SPECIFIC_FUNCTION;
                break;
            }
            default: {
                this.jj_la1[113] = this.jj_gen;
            }
        }
        SqlNode call = this.NamedRoutineCall(funcType, SqlAbstractParserImpl.ExprContext.ACCEPT_CURSOR);
        this.jj_consume_token(716);
        return SqlStdOperatorTable.COLLECTION_TABLE.createCall(s.end(this), call);
    }

    public final SqlNode ExplicitTable(SqlParserPos pos) throws ParseException {
        this.jj_consume_token(605);
        SqlIdentifier tableRef = this.CompoundIdentifier();
        return SqlStdOperatorTable.EXPLICIT_TABLE.createCall(pos, tableRef);
    }

    public final SqlNode TableConstructor() throws ParseException {
        Span s;
        ArrayList<SqlNode> list = new ArrayList<SqlNode>();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 672: {
                this.jj_consume_token(672);
                s = this.span();
                break;
            }
            case 671: {
                this.jj_consume_token(671);
                s = this.span();
                if (this.conformance.isValueAllowed()) break;
                throw SqlUtil.newContextException(this.getPos(), Static.RESOURCE.valueNotAllowed());
            }
            default: {
                this.jj_la1[114] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.AddRowConstructor(list);
        while (this.jj_2_29(2)) {
            this.jj_consume_token(727);
            this.AddRowConstructor(list);
        }
        return SqlStdOperatorTable.VALUES.createCall(s.end(this), list);
    }

    public final void AddRowConstructor(List<SqlNode> list) throws ParseException {
        SqlNode e = this.RowConstructor();
        list.add(e);
    }

    public final SqlNode RowConstructor() throws ParseException {
        SqlNodeList valueList;
        Span s;
        if (this.jj_2_30(3)) {
            this.jj_consume_token(715);
            s = this.span();
            this.jj_consume_token(481);
            valueList = this.ParenthesizedQueryOrCommaListWithDefault(SqlAbstractParserImpl.ExprContext.ACCEPT_NONCURSOR);
            this.jj_consume_token(716);
            s.add(this);
        } else if (this.jj_2_31(3)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 481: {
                    this.jj_consume_token(481);
                    s = this.span();
                    break;
                }
                default: {
                    this.jj_la1[115] = this.jj_gen;
                    s = Span.of();
                }
            }
            valueList = this.ParenthesizedQueryOrCommaListWithDefault(SqlAbstractParserImpl.ExprContext.ACCEPT_NONCURSOR);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 14: 
                case 17: 
                case 19: 
                case 20: 
                case 21: 
                case 24: 
                case 26: 
                case 27: 
                case 31: 
                case 32: 
                case 34: 
                case 35: 
                case 39: 
                case 47: 
                case 49: 
                case 52: 
                case 53: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 73: 
                case 74: 
                case 77: 
                case 78: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 86: 
                case 87: 
                case 88: 
                case 90: 
                case 92: 
                case 93: 
                case 95: 
                case 96: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 104: 
                case 105: 
                case 108: 
                case 109: 
                case 110: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 122: 
                case 123: 
                case 124: 
                case 126: 
                case 127: 
                case 128: 
                case 130: 
                case 131: 
                case 132: 
                case 133: 
                case 134: 
                case 135: 
                case 136: 
                case 138: 
                case 141: 
                case 145: 
                case 146: 
                case 147: 
                case 149: 
                case 150: 
                case 151: 
                case 153: 
                case 154: 
                case 156: 
                case 157: 
                case 159: 
                case 160: 
                case 162: 
                case 165: 
                case 167: 
                case 168: 
                case 170: 
                case 171: 
                case 174: 
                case 175: 
                case 177: 
                case 180: 
                case 185: 
                case 187: 
                case 189: 
                case 191: 
                case 192: 
                case 193: 
                case 196: 
                case 197: 
                case 201: 
                case 202: 
                case 205: 
                case 206: 
                case 207: 
                case 209: 
                case 210: 
                case 212: 
                case 214: 
                case 215: 
                case 216: 
                case 223: 
                case 224: 
                case 225: 
                case 226: 
                case 227: 
                case 230: 
                case 231: 
                case 233: 
                case 235: 
                case 236: 
                case 239: 
                case 241: 
                case 242: 
                case 243: 
                case 245: 
                case 246: 
                case 247: 
                case 248: 
                case 249: 
                case 252: 
                case 253: 
                case 254: 
                case 257: 
                case 260: 
                case 263: 
                case 264: 
                case 268: 
                case 269: 
                case 271: 
                case 273: 
                case 274: 
                case 275: 
                case 276: 
                case 278: 
                case 279: 
                case 280: 
                case 281: 
                case 282: 
                case 283: 
                case 284: 
                case 285: 
                case 286: 
                case 287: 
                case 288: 
                case 289: 
                case 290: 
                case 291: 
                case 294: 
                case 295: 
                case 297: 
                case 299: 
                case 300: 
                case 301: 
                case 302: 
                case 306: 
                case 308: 
                case 309: 
                case 310: 
                case 311: 
                case 312: 
                case 313: 
                case 315: 
                case 317: 
                case 319: 
                case 320: 
                case 324: 
                case 325: 
                case 326: 
                case 328: 
                case 329: 
                case 330: 
                case 331: 
                case 332: 
                case 333: 
                case 334: 
                case 335: 
                case 339: 
                case 340: 
                case 341: 
                case 342: 
                case 343: 
                case 344: 
                case 345: 
                case 346: 
                case 351: 
                case 352: 
                case 353: 
                case 357: 
                case 358: 
                case 359: 
                case 360: 
                case 361: 
                case 362: 
                case 363: 
                case 364: 
                case 365: 
                case 367: 
                case 369: 
                case 370: 
                case 379: 
                case 380: 
                case 383: 
                case 384: 
                case 385: 
                case 388: 
                case 391: 
                case 392: 
                case 393: 
                case 395: 
                case 396: 
                case 397: 
                case 398: 
                case 399: 
                case 400: 
                case 401: 
                case 403: 
                case 404: 
                case 405: 
                case 406: 
                case 407: 
                case 411: 
                case 412: 
                case 413: 
                case 414: 
                case 416: 
                case 417: 
                case 418: 
                case 419: 
                case 421: 
                case 423: 
                case 425: 
                case 428: 
                case 429: 
                case 431: 
                case 432: 
                case 434: 
                case 435: 
                case 436: 
                case 438: 
                case 439: 
                case 448: 
                case 452: 
                case 454: 
                case 455: 
                case 457: 
                case 458: 
                case 460: 
                case 461: 
                case 462: 
                case 465: 
                case 466: 
                case 467: 
                case 468: 
                case 469: 
                case 472: 
                case 473: 
                case 474: 
                case 477: 
                case 478: 
                case 479: 
                case 480: 
                case 481: 
                case 482: 
                case 483: 
                case 485: 
                case 488: 
                case 489: 
                case 490: 
                case 491: 
                case 493: 
                case 494: 
                case 495: 
                case 498: 
                case 499: 
                case 500: 
                case 501: 
                case 504: 
                case 506: 
                case 507: 
                case 508: 
                case 509: 
                case 510: 
                case 511: 
                case 512: 
                case 514: 
                case 518: 
                case 519: 
                case 522: 
                case 523: 
                case 524: 
                case 525: 
                case 526: 
                case 532: 
                case 533: 
                case 534: 
                case 535: 
                case 536: 
                case 537: 
                case 538: 
                case 539: 
                case 540: 
                case 541: 
                case 542: 
                case 543: 
                case 544: 
                case 545: 
                case 546: 
                case 547: 
                case 548: 
                case 549: 
                case 550: 
                case 551: 
                case 552: 
                case 553: 
                case 554: 
                case 555: 
                case 556: 
                case 557: 
                case 558: 
                case 559: 
                case 560: 
                case 561: 
                case 562: 
                case 563: 
                case 564: 
                case 565: 
                case 566: 
                case 567: 
                case 568: 
                case 569: 
                case 570: 
                case 571: 
                case 572: 
                case 573: 
                case 574: 
                case 575: 
                case 576: 
                case 577: 
                case 578: 
                case 579: 
                case 580: 
                case 581: 
                case 583: 
                case 584: 
                case 586: 
                case 587: 
                case 589: 
                case 590: 
                case 591: 
                case 592: 
                case 595: 
                case 596: 
                case 599: 
                case 604: 
                case 606: 
                case 608: 
                case 611: 
                case 612: 
                case 613: 
                case 614: 
                case 615: 
                case 616: 
                case 617: 
                case 618: 
                case 619: 
                case 624: 
                case 626: 
                case 627: 
                case 628: 
                case 629: 
                case 630: 
                case 631: 
                case 632: 
                case 637: 
                case 638: 
                case 639: 
                case 640: 
                case 642: 
                case 643: 
                case 645: 
                case 646: 
                case 648: 
                case 649: 
                case 650: 
                case 651: 
                case 653: 
                case 654: 
                case 655: 
                case 656: 
                case 659: 
                case 661: 
                case 662: 
                case 663: 
                case 664: 
                case 665: 
                case 666: 
                case 668: 
                case 669: 
                case 670: 
                case 674: 
                case 675: 
                case 679: 
                case 681: 
                case 683: 
                case 684: 
                case 693: 
                case 694: 
                case 695: 
                case 696: 
                case 697: 
                case 698: 
                case 699: 
                case 700: 
                case 701: 
                case 702: 
                case 706: 
                case 707: 
                case 708: 
                case 709: 
                case 710: 
                case 712: 
                case 713: 
                case 715: 
                case 717: 
                case 718: 
                case 719: 
                case 720: 
                case 731: 
                case 737: 
                case 738: 
                case 763: 
                case 764: 
                case 765: 
                case 766: 
                case 767: 
                case 768: 
                case 770: {
                    SqlNode value = this.Expression(SqlAbstractParserImpl.ExprContext.ACCEPT_NONCURSOR);
                    s = Span.of(value);
                    valueList = new SqlNodeList((Collection<? extends SqlNode>)ImmutableList.of((Object)value), value.getParserPosition());
                    break;
                }
                default: {
                    this.jj_la1[116] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return SqlStdOperatorTable.ROW.createCall(s.end(valueList), (List<? extends SqlNode>)valueList);
    }

    public final SqlNode Where() throws ParseException {
        this.jj_consume_token(687);
        SqlNode condition = this.Expression(SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        return condition;
    }

    public final SqlNodeList GroupBy() throws ParseException {
        boolean distinct;
        this.jj_consume_token(234);
        Span s = this.span();
        this.jj_consume_token(48);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 166: {
                this.jj_consume_token(166);
                distinct = true;
                break;
            }
            case 10: {
                this.jj_consume_token(10);
                distinct = false;
                break;
            }
            default: {
                this.jj_la1[117] = this.jj_gen;
                distinct = false;
            }
        }
        ImmutableList list = this.GroupingElementList();
        SqlParserPos pos = s.end(this);
        ImmutableList list2 = distinct ? ImmutableList.of((Object)SqlInternalOperators.GROUP_BY_DISTINCT.createCall(pos, (List<? extends SqlNode>)list)) : list;
        return new SqlNodeList((Collection<? extends SqlNode>)list2, pos);
    }

    public final List<SqlNode> GroupingElementList() throws ParseException {
        ArrayList<SqlNode> list = new ArrayList<SqlNode>();
        this.AddGroupingElement(list);
        while (this.jj_2_32(2)) {
            this.jj_consume_token(727);
            this.AddGroupingElement(list);
        }
        return list;
    }

    public final void AddGroupingElement(List<SqlNode> list) throws ParseException {
        if (this.jj_2_33(2)) {
            this.jj_consume_token(236);
            Span s = this.span();
            this.jj_consume_token(514);
            this.jj_consume_token(715);
            List<SqlNode> subList = this.GroupingElementList();
            this.jj_consume_token(716);
            list.add(SqlStdOperatorTable.GROUPING_SETS.createCall(s.end(this), subList));
        } else {
            block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 476: {
                    this.jj_consume_token(476);
                    Span s = this.span();
                    this.jj_consume_token(715);
                    SqlNodeList nodes = this.ExpressionCommaList(s, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                    this.jj_consume_token(716);
                    list.add(SqlStdOperatorTable.ROLLUP.createCall(s.end(this), nodes.getList()));
                    break;
                }
                case 113: {
                    this.jj_consume_token(113);
                    Span s = this.span();
                    this.jj_consume_token(715);
                    SqlNodeList nodes = this.ExpressionCommaList(s, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                    this.jj_consume_token(716);
                    list.add(SqlStdOperatorTable.CUBE.createCall(s.end(this), nodes.getList()));
                    break;
                }
                default: {
                    this.jj_la1[118] = this.jj_gen;
                    if (this.jj_2_34(3)) {
                        this.jj_consume_token(715);
                        Span s = this.span();
                        this.jj_consume_token(716);
                        list.add(new SqlNodeList(s.end(this)));
                        break;
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 14: 
                        case 17: 
                        case 19: 
                        case 20: 
                        case 21: 
                        case 24: 
                        case 26: 
                        case 27: 
                        case 31: 
                        case 32: 
                        case 34: 
                        case 35: 
                        case 39: 
                        case 47: 
                        case 49: 
                        case 52: 
                        case 53: 
                        case 55: 
                        case 56: 
                        case 57: 
                        case 58: 
                        case 59: 
                        case 60: 
                        case 61: 
                        case 62: 
                        case 63: 
                        case 64: 
                        case 66: 
                        case 67: 
                        case 68: 
                        case 69: 
                        case 70: 
                        case 71: 
                        case 73: 
                        case 74: 
                        case 77: 
                        case 78: 
                        case 80: 
                        case 81: 
                        case 82: 
                        case 83: 
                        case 84: 
                        case 86: 
                        case 87: 
                        case 88: 
                        case 90: 
                        case 92: 
                        case 93: 
                        case 95: 
                        case 96: 
                        case 98: 
                        case 99: 
                        case 100: 
                        case 101: 
                        case 102: 
                        case 104: 
                        case 105: 
                        case 108: 
                        case 109: 
                        case 110: 
                        case 114: 
                        case 115: 
                        case 116: 
                        case 117: 
                        case 118: 
                        case 119: 
                        case 120: 
                        case 122: 
                        case 123: 
                        case 124: 
                        case 126: 
                        case 127: 
                        case 128: 
                        case 130: 
                        case 131: 
                        case 132: 
                        case 133: 
                        case 134: 
                        case 135: 
                        case 136: 
                        case 138: 
                        case 141: 
                        case 145: 
                        case 146: 
                        case 147: 
                        case 149: 
                        case 150: 
                        case 151: 
                        case 153: 
                        case 154: 
                        case 156: 
                        case 157: 
                        case 159: 
                        case 160: 
                        case 162: 
                        case 165: 
                        case 167: 
                        case 168: 
                        case 170: 
                        case 171: 
                        case 174: 
                        case 175: 
                        case 177: 
                        case 180: 
                        case 185: 
                        case 187: 
                        case 189: 
                        case 191: 
                        case 192: 
                        case 193: 
                        case 196: 
                        case 197: 
                        case 201: 
                        case 202: 
                        case 205: 
                        case 206: 
                        case 207: 
                        case 209: 
                        case 210: 
                        case 212: 
                        case 214: 
                        case 215: 
                        case 216: 
                        case 223: 
                        case 224: 
                        case 225: 
                        case 226: 
                        case 227: 
                        case 230: 
                        case 231: 
                        case 233: 
                        case 235: 
                        case 236: 
                        case 239: 
                        case 241: 
                        case 242: 
                        case 243: 
                        case 245: 
                        case 246: 
                        case 247: 
                        case 248: 
                        case 249: 
                        case 252: 
                        case 253: 
                        case 254: 
                        case 257: 
                        case 260: 
                        case 263: 
                        case 264: 
                        case 268: 
                        case 269: 
                        case 271: 
                        case 273: 
                        case 274: 
                        case 275: 
                        case 276: 
                        case 278: 
                        case 279: 
                        case 280: 
                        case 281: 
                        case 282: 
                        case 283: 
                        case 284: 
                        case 285: 
                        case 286: 
                        case 287: 
                        case 288: 
                        case 289: 
                        case 290: 
                        case 291: 
                        case 294: 
                        case 295: 
                        case 297: 
                        case 299: 
                        case 300: 
                        case 301: 
                        case 302: 
                        case 306: 
                        case 308: 
                        case 309: 
                        case 310: 
                        case 311: 
                        case 312: 
                        case 313: 
                        case 315: 
                        case 317: 
                        case 319: 
                        case 320: 
                        case 324: 
                        case 325: 
                        case 326: 
                        case 328: 
                        case 329: 
                        case 330: 
                        case 331: 
                        case 332: 
                        case 333: 
                        case 334: 
                        case 335: 
                        case 339: 
                        case 340: 
                        case 341: 
                        case 342: 
                        case 343: 
                        case 344: 
                        case 345: 
                        case 346: 
                        case 351: 
                        case 352: 
                        case 353: 
                        case 357: 
                        case 358: 
                        case 359: 
                        case 360: 
                        case 361: 
                        case 362: 
                        case 363: 
                        case 364: 
                        case 365: 
                        case 367: 
                        case 369: 
                        case 370: 
                        case 379: 
                        case 380: 
                        case 383: 
                        case 384: 
                        case 385: 
                        case 388: 
                        case 391: 
                        case 392: 
                        case 393: 
                        case 395: 
                        case 396: 
                        case 397: 
                        case 398: 
                        case 399: 
                        case 400: 
                        case 401: 
                        case 403: 
                        case 404: 
                        case 405: 
                        case 406: 
                        case 407: 
                        case 411: 
                        case 412: 
                        case 413: 
                        case 414: 
                        case 416: 
                        case 417: 
                        case 418: 
                        case 419: 
                        case 421: 
                        case 423: 
                        case 425: 
                        case 428: 
                        case 429: 
                        case 431: 
                        case 432: 
                        case 434: 
                        case 435: 
                        case 436: 
                        case 438: 
                        case 439: 
                        case 448: 
                        case 452: 
                        case 454: 
                        case 455: 
                        case 457: 
                        case 458: 
                        case 460: 
                        case 461: 
                        case 462: 
                        case 465: 
                        case 466: 
                        case 467: 
                        case 468: 
                        case 469: 
                        case 472: 
                        case 473: 
                        case 474: 
                        case 477: 
                        case 478: 
                        case 479: 
                        case 480: 
                        case 481: 
                        case 482: 
                        case 483: 
                        case 485: 
                        case 488: 
                        case 489: 
                        case 490: 
                        case 491: 
                        case 493: 
                        case 494: 
                        case 495: 
                        case 498: 
                        case 499: 
                        case 500: 
                        case 501: 
                        case 504: 
                        case 506: 
                        case 507: 
                        case 508: 
                        case 509: 
                        case 510: 
                        case 511: 
                        case 512: 
                        case 514: 
                        case 518: 
                        case 519: 
                        case 522: 
                        case 523: 
                        case 524: 
                        case 525: 
                        case 526: 
                        case 532: 
                        case 533: 
                        case 534: 
                        case 535: 
                        case 536: 
                        case 537: 
                        case 538: 
                        case 539: 
                        case 540: 
                        case 541: 
                        case 542: 
                        case 543: 
                        case 544: 
                        case 545: 
                        case 546: 
                        case 547: 
                        case 548: 
                        case 549: 
                        case 550: 
                        case 551: 
                        case 552: 
                        case 553: 
                        case 554: 
                        case 555: 
                        case 556: 
                        case 557: 
                        case 558: 
                        case 559: 
                        case 560: 
                        case 561: 
                        case 562: 
                        case 563: 
                        case 564: 
                        case 565: 
                        case 566: 
                        case 567: 
                        case 568: 
                        case 569: 
                        case 570: 
                        case 571: 
                        case 572: 
                        case 573: 
                        case 574: 
                        case 575: 
                        case 576: 
                        case 577: 
                        case 578: 
                        case 579: 
                        case 580: 
                        case 581: 
                        case 583: 
                        case 584: 
                        case 586: 
                        case 587: 
                        case 589: 
                        case 590: 
                        case 591: 
                        case 592: 
                        case 595: 
                        case 596: 
                        case 599: 
                        case 604: 
                        case 606: 
                        case 608: 
                        case 611: 
                        case 612: 
                        case 613: 
                        case 614: 
                        case 615: 
                        case 616: 
                        case 617: 
                        case 618: 
                        case 619: 
                        case 624: 
                        case 626: 
                        case 627: 
                        case 628: 
                        case 629: 
                        case 630: 
                        case 631: 
                        case 632: 
                        case 637: 
                        case 638: 
                        case 639: 
                        case 640: 
                        case 642: 
                        case 643: 
                        case 645: 
                        case 646: 
                        case 648: 
                        case 649: 
                        case 650: 
                        case 651: 
                        case 653: 
                        case 654: 
                        case 655: 
                        case 656: 
                        case 659: 
                        case 661: 
                        case 662: 
                        case 663: 
                        case 664: 
                        case 665: 
                        case 666: 
                        case 668: 
                        case 669: 
                        case 670: 
                        case 674: 
                        case 675: 
                        case 679: 
                        case 681: 
                        case 683: 
                        case 684: 
                        case 693: 
                        case 694: 
                        case 695: 
                        case 696: 
                        case 697: 
                        case 698: 
                        case 699: 
                        case 700: 
                        case 701: 
                        case 702: 
                        case 706: 
                        case 707: 
                        case 708: 
                        case 709: 
                        case 710: 
                        case 712: 
                        case 713: 
                        case 715: 
                        case 717: 
                        case 718: 
                        case 719: 
                        case 720: 
                        case 731: 
                        case 737: 
                        case 738: 
                        case 763: 
                        case 764: 
                        case 765: 
                        case 766: 
                        case 767: 
                        case 768: 
                        case 770: {
                            this.AddExpression(list, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                            break block0;
                        }
                    }
                    this.jj_la1[119] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    public final SqlNodeList ExpressionCommaList(Span s, SqlAbstractParserImpl.ExprContext exprContext) throws ParseException {
        ArrayList<SqlNode> list = new ArrayList<SqlNode>();
        this.AddExpressions(list, exprContext);
        return new SqlNodeList(list, s.addAll(list).pos());
    }

    public final void AddExpressions(List<SqlNode> list, SqlAbstractParserImpl.ExprContext exprContext) throws ParseException {
        this.AddExpression(list, exprContext);
        while (this.jj_2_35(2)) {
            this.jj_consume_token(727);
            this.AddExpression(list, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        }
    }

    public final SqlNode Having() throws ParseException {
        this.jj_consume_token(238);
        SqlNode e = this.Expression(SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        return e;
    }

    public final SqlNodeList Window() throws ParseException {
        ArrayList<SqlNode> list = new ArrayList<SqlNode>();
        this.jj_consume_token(689);
        Span s = this.span();
        this.AddWindowSpec(list);
        while (this.jj_2_36(2)) {
            this.jj_consume_token(727);
            this.AddWindowSpec(list);
        }
        return new SqlNodeList(list, s.addAll(list).pos());
    }

    public final void AddWindowSpec(List<SqlNode> list) throws ParseException {
        SqlIdentifier id = this.SimpleIdentifier();
        this.jj_consume_token(23);
        SqlWindow e = this.WindowSpecification();
        e.setDeclName(id);
        list.add(e);
    }

    public final SqlWindow WindowSpecification() throws ParseException {
        SqlLiteral allowPartial;
        SqlNode upperBound;
        SqlNode lowerBound;
        SqlLiteral isRows;
        SqlNodeList orderList;
        SqlNodeList partitionList;
        SqlIdentifier id;
        this.jj_consume_token(715);
        Span s = this.span();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 24: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 35: 
            case 39: 
            case 47: 
            case 49: 
            case 53: 
            case 57: 
            case 58: 
            case 61: 
            case 62: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 74: 
            case 78: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 86: 
            case 87: 
            case 88: 
            case 90: 
            case 92: 
            case 93: 
            case 95: 
            case 96: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 104: 
            case 128: 
            case 130: 
            case 131: 
            case 133: 
            case 135: 
            case 136: 
            case 138: 
            case 141: 
            case 145: 
            case 146: 
            case 147: 
            case 149: 
            case 150: 
            case 151: 
            case 154: 
            case 156: 
            case 157: 
            case 159: 
            case 160: 
            case 162: 
            case 165: 
            case 167: 
            case 168: 
            case 170: 
            case 171: 
            case 174: 
            case 175: 
            case 180: 
            case 185: 
            case 187: 
            case 191: 
            case 192: 
            case 193: 
            case 205: 
            case 206: 
            case 210: 
            case 212: 
            case 214: 
            case 215: 
            case 216: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 230: 
            case 231: 
            case 233: 
            case 235: 
            case 239: 
            case 241: 
            case 243: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 252: 
            case 253: 
            case 254: 
            case 257: 
            case 260: 
            case 263: 
            case 264: 
            case 271: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 278: 
            case 286: 
            case 287: 
            case 288: 
            case 289: 
            case 290: 
            case 294: 
            case 300: 
            case 301: 
            case 302: 
            case 310: 
            case 312: 
            case 313: 
            case 315: 
            case 320: 
            case 324: 
            case 325: 
            case 326: 
            case 328: 
            case 329: 
            case 330: 
            case 333: 
            case 334: 
            case 340: 
            case 341: 
            case 343: 
            case 344: 
            case 345: 
            case 346: 
            case 351: 
            case 357: 
            case 362: 
            case 364: 
            case 365: 
            case 367: 
            case 370: 
            case 379: 
            case 380: 
            case 383: 
            case 384: 
            case 385: 
            case 388: 
            case 392: 
            case 393: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 399: 
            case 400: 
            case 401: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 416: 
            case 417: 
            case 418: 
            case 419: 
            case 425: 
            case 428: 
            case 431: 
            case 432: 
            case 434: 
            case 435: 
            case 436: 
            case 439: 
            case 455: 
            case 457: 
            case 458: 
            case 460: 
            case 461: 
            case 462: 
            case 465: 
            case 466: 
            case 467: 
            case 468: 
            case 469: 
            case 473: 
            case 474: 
            case 477: 
            case 478: 
            case 479: 
            case 480: 
            case 482: 
            case 488: 
            case 489: 
            case 490: 
            case 491: 
            case 493: 
            case 494: 
            case 495: 
            case 499: 
            case 500: 
            case 501: 
            case 504: 
            case 506: 
            case 507: 
            case 508: 
            case 509: 
            case 510: 
            case 511: 
            case 514: 
            case 518: 
            case 519: 
            case 523: 
            case 524: 
            case 526: 
            case 532: 
            case 533: 
            case 534: 
            case 535: 
            case 536: 
            case 537: 
            case 538: 
            case 539: 
            case 540: 
            case 541: 
            case 542: 
            case 543: 
            case 544: 
            case 545: 
            case 546: 
            case 547: 
            case 548: 
            case 549: 
            case 550: 
            case 551: 
            case 552: 
            case 553: 
            case 554: 
            case 555: 
            case 556: 
            case 557: 
            case 558: 
            case 559: 
            case 560: 
            case 561: 
            case 562: 
            case 563: 
            case 564: 
            case 565: 
            case 566: 
            case 567: 
            case 568: 
            case 569: 
            case 570: 
            case 571: 
            case 572: 
            case 573: 
            case 574: 
            case 575: 
            case 576: 
            case 577: 
            case 578: 
            case 579: 
            case 580: 
            case 583: 
            case 584: 
            case 589: 
            case 590: 
            case 591: 
            case 592: 
            case 595: 
            case 606: 
            case 608: 
            case 611: 
            case 613: 
            case 614: 
            case 616: 
            case 617: 
            case 618: 
            case 619: 
            case 624: 
            case 626: 
            case 627: 
            case 628: 
            case 629: 
            case 630: 
            case 631: 
            case 637: 
            case 638: 
            case 639: 
            case 645: 
            case 646: 
            case 648: 
            case 649: 
            case 650: 
            case 651: 
            case 655: 
            case 656: 
            case 661: 
            case 663: 
            case 664: 
            case 665: 
            case 666: 
            case 668: 
            case 669: 
            case 670: 
            case 679: 
            case 681: 
            case 683: 
            case 684: 
            case 693: 
            case 694: 
            case 695: 
            case 696: 
            case 698: 
            case 699: 
            case 763: 
            case 764: 
            case 765: 
            case 766: 
            case 767: 
            case 768: 
            case 770: {
                id = this.SimpleIdentifier();
                break;
            }
            default: {
                this.jj_la1[120] = this.jj_gen;
                id = null;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 402: {
                this.jj_consume_token(402);
                Span s1 = this.span();
                this.jj_consume_token(48);
                partitionList = this.ExpressionCommaList(s1, SqlAbstractParserImpl.ExprContext.ACCEPT_NON_QUERY);
                break;
            }
            default: {
                this.jj_la1[121] = this.jj_gen;
                partitionList = SqlNodeList.EMPTY;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 382: {
                orderList = this.OrderBy(true);
                break;
            }
            default: {
                this.jj_la1[122] = this.jj_gen;
                orderList = SqlNodeList.EMPTY;
            }
        }
        block9 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 437: 
            case 484: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 484: {
                        this.jj_consume_token(484);
                        isRows = SqlLiteral.createBoolean(true, this.getPos());
                        break;
                    }
                    case 437: {
                        this.jj_consume_token(437);
                        isRows = SqlLiteral.createBoolean(false, this.getPos());
                        break;
                    }
                    default: {
                        this.jj_la1[123] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 40: {
                        this.jj_consume_token(40);
                        lowerBound = this.WindowRange();
                        this.jj_consume_token(15);
                        upperBound = this.WindowRange();
                        break block9;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 14: 
                    case 17: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 24: 
                    case 26: 
                    case 27: 
                    case 31: 
                    case 32: 
                    case 34: 
                    case 35: 
                    case 39: 
                    case 47: 
                    case 49: 
                    case 52: 
                    case 53: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 73: 
                    case 74: 
                    case 77: 
                    case 78: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 86: 
                    case 87: 
                    case 88: 
                    case 90: 
                    case 92: 
                    case 93: 
                    case 95: 
                    case 96: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 104: 
                    case 105: 
                    case 108: 
                    case 109: 
                    case 110: 
                    case 114: 
                    case 115: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 119: 
                    case 120: 
                    case 122: 
                    case 123: 
                    case 124: 
                    case 126: 
                    case 127: 
                    case 128: 
                    case 130: 
                    case 131: 
                    case 132: 
                    case 133: 
                    case 134: 
                    case 135: 
                    case 136: 
                    case 138: 
                    case 141: 
                    case 145: 
                    case 146: 
                    case 147: 
                    case 149: 
                    case 150: 
                    case 151: 
                    case 153: 
                    case 154: 
                    case 156: 
                    case 157: 
                    case 159: 
                    case 160: 
                    case 162: 
                    case 165: 
                    case 167: 
                    case 168: 
                    case 170: 
                    case 171: 
                    case 174: 
                    case 175: 
                    case 177: 
                    case 180: 
                    case 185: 
                    case 187: 
                    case 189: 
                    case 191: 
                    case 192: 
                    case 193: 
                    case 196: 
                    case 197: 
                    case 201: 
                    case 202: 
                    case 205: 
                    case 206: 
                    case 207: 
                    case 209: 
                    case 210: 
                    case 212: 
                    case 214: 
                    case 215: 
                    case 216: 
                    case 223: 
                    case 224: 
                    case 225: 
                    case 226: 
                    case 227: 
                    case 230: 
                    case 231: 
                    case 233: 
                    case 235: 
                    case 236: 
                    case 239: 
                    case 241: 
                    case 242: 
                    case 243: 
                    case 245: 
                    case 246: 
                    case 247: 
                    case 248: 
                    case 249: 
                    case 252: 
                    case 253: 
                    case 254: 
                    case 257: 
                    case 260: 
                    case 263: 
                    case 264: 
                    case 268: 
                    case 269: 
                    case 271: 
                    case 273: 
                    case 274: 
                    case 275: 
                    case 276: 
                    case 278: 
                    case 279: 
                    case 280: 
                    case 281: 
                    case 282: 
                    case 283: 
                    case 284: 
                    case 285: 
                    case 286: 
                    case 287: 
                    case 288: 
                    case 289: 
                    case 290: 
                    case 291: 
                    case 294: 
                    case 295: 
                    case 297: 
                    case 299: 
                    case 300: 
                    case 301: 
                    case 302: 
                    case 306: 
                    case 308: 
                    case 309: 
                    case 310: 
                    case 311: 
                    case 312: 
                    case 313: 
                    case 315: 
                    case 317: 
                    case 319: 
                    case 320: 
                    case 324: 
                    case 325: 
                    case 326: 
                    case 328: 
                    case 329: 
                    case 330: 
                    case 331: 
                    case 332: 
                    case 333: 
                    case 334: 
                    case 335: 
                    case 339: 
                    case 340: 
                    case 341: 
                    case 342: 
                    case 343: 
                    case 344: 
                    case 345: 
                    case 346: 
                    case 351: 
                    case 352: 
                    case 353: 
                    case 357: 
                    case 358: 
                    case 359: 
                    case 360: 
                    case 361: 
                    case 362: 
                    case 363: 
                    case 364: 
                    case 365: 
                    case 367: 
                    case 369: 
                    case 370: 
                    case 379: 
                    case 380: 
                    case 383: 
                    case 384: 
                    case 385: 
                    case 388: 
                    case 391: 
                    case 392: 
                    case 393: 
                    case 395: 
                    case 396: 
                    case 397: 
                    case 398: 
                    case 399: 
                    case 400: 
                    case 401: 
                    case 403: 
                    case 404: 
                    case 405: 
                    case 406: 
                    case 407: 
                    case 411: 
                    case 412: 
                    case 413: 
                    case 414: 
                    case 416: 
                    case 417: 
                    case 418: 
                    case 419: 
                    case 421: 
                    case 423: 
                    case 425: 
                    case 428: 
                    case 429: 
                    case 431: 
                    case 432: 
                    case 434: 
                    case 435: 
                    case 436: 
                    case 438: 
                    case 439: 
                    case 448: 
                    case 452: 
                    case 454: 
                    case 455: 
                    case 457: 
                    case 458: 
                    case 460: 
                    case 461: 
                    case 462: 
                    case 465: 
                    case 466: 
                    case 467: 
                    case 468: 
                    case 469: 
                    case 472: 
                    case 473: 
                    case 474: 
                    case 477: 
                    case 478: 
                    case 479: 
                    case 480: 
                    case 481: 
                    case 482: 
                    case 483: 
                    case 485: 
                    case 488: 
                    case 489: 
                    case 490: 
                    case 491: 
                    case 493: 
                    case 494: 
                    case 495: 
                    case 498: 
                    case 499: 
                    case 500: 
                    case 501: 
                    case 504: 
                    case 506: 
                    case 507: 
                    case 508: 
                    case 509: 
                    case 510: 
                    case 511: 
                    case 512: 
                    case 514: 
                    case 518: 
                    case 519: 
                    case 522: 
                    case 523: 
                    case 524: 
                    case 525: 
                    case 526: 
                    case 532: 
                    case 533: 
                    case 534: 
                    case 535: 
                    case 536: 
                    case 537: 
                    case 538: 
                    case 539: 
                    case 540: 
                    case 541: 
                    case 542: 
                    case 543: 
                    case 544: 
                    case 545: 
                    case 546: 
                    case 547: 
                    case 548: 
                    case 549: 
                    case 550: 
                    case 551: 
                    case 552: 
                    case 553: 
                    case 554: 
                    case 555: 
                    case 556: 
                    case 557: 
                    case 558: 
                    case 559: 
                    case 560: 
                    case 561: 
                    case 562: 
                    case 563: 
                    case 564: 
                    case 565: 
                    case 566: 
                    case 567: 
                    case 568: 
                    case 569: 
                    case 570: 
                    case 571: 
                    case 572: 
                    case 573: 
                    case 574: 
                    case 575: 
                    case 576: 
                    case 577: 
                    case 578: 
                    case 579: 
                    case 580: 
                    case 581: 
                    case 583: 
                    case 584: 
                    case 586: 
                    case 587: 
                    case 589: 
                    case 590: 
                    case 591: 
                    case 592: 
                    case 595: 
                    case 596: 
                    case 599: 
                    case 604: 
                    case 606: 
                    case 608: 
                    case 611: 
                    case 612: 
                    case 613: 
                    case 614: 
                    case 615: 
                    case 616: 
                    case 617: 
                    case 618: 
                    case 619: 
                    case 624: 
                    case 626: 
                    case 627: 
                    case 628: 
                    case 629: 
                    case 630: 
                    case 631: 
                    case 632: 
                    case 637: 
                    case 638: 
                    case 639: 
                    case 640: 
                    case 642: 
                    case 643: 
                    case 645: 
                    case 646: 
                    case 648: 
                    case 649: 
                    case 650: 
                    case 651: 
                    case 653: 
                    case 654: 
                    case 655: 
                    case 656: 
                    case 659: 
                    case 661: 
                    case 662: 
                    case 663: 
                    case 664: 
                    case 665: 
                    case 666: 
                    case 668: 
                    case 669: 
                    case 670: 
                    case 674: 
                    case 675: 
                    case 679: 
                    case 681: 
                    case 683: 
                    case 684: 
                    case 693: 
                    case 694: 
                    case 695: 
                    case 696: 
                    case 697: 
                    case 698: 
                    case 699: 
                    case 700: 
                    case 701: 
                    case 702: 
                    case 706: 
                    case 707: 
                    case 708: 
                    case 709: 
                    case 710: 
                    case 712: 
                    case 713: 
                    case 715: 
                    case 717: 
                    case 718: 
                    case 719: 
                    case 720: 
                    case 731: 
                    case 737: 
                    case 738: 
                    case 763: 
                    case 764: 
                    case 765: 
                    case 766: 
                    case 767: 
                    case 768: 
                    case 770: {
                        lowerBound = this.WindowRange();
                        upperBound = null;
                        break block9;
                    }
                }
                this.jj_la1[124] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[125] = this.jj_gen;
                isRows = SqlLiteral.createBoolean(false, SqlParserPos.ZERO);
                upperBound = null;
                lowerBound = null;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 12: {
                this.jj_consume_token(12);
                Span s2 = this.span();
                this.jj_consume_token(401);
                allowPartial = SqlLiteral.createBoolean(true, s2.end(this));
                break;
            }
            case 163: {
                this.jj_consume_token(163);
                Span s2 = this.span();
                this.jj_consume_token(401);
                allowPartial = SqlLiteral.createBoolean(false, s2.end(this));
                break;
            }
            default: {
                this.jj_la1[126] = this.jj_gen;
                allowPartial = null;
            }
        }
        this.jj_consume_token(716);
        return SqlWindow.create(null, id, partitionList, orderList, isRows, lowerBound, upperBound, allowPartial, s.end(this));
    }

    public final SqlNode WindowRange() throws ParseException {
        if (this.jj_2_37(2)) {
            this.jj_consume_token(115);
            Span s = this.span();
            this.jj_consume_token(481);
            return SqlWindow.createCurrentRow(s.end(this));
        }
        if (this.jj_2_38(2)) {
            this.jj_consume_token(648);
            Span s = this.span();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 425: {
                    this.jj_consume_token(425);
                    return SqlWindow.createUnboundedPreceding(s.end(this));
                }
                case 210: {
                    this.jj_consume_token(210);
                    return SqlWindow.createUnboundedFollowing(s.end(this));
                }
            }
            this.jj_la1[127] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 39: 
            case 47: 
            case 49: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 74: 
            case 77: 
            case 78: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 86: 
            case 87: 
            case 88: 
            case 90: 
            case 92: 
            case 93: 
            case 95: 
            case 96: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 104: 
            case 105: 
            case 108: 
            case 109: 
            case 110: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 122: 
            case 123: 
            case 124: 
            case 126: 
            case 127: 
            case 128: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 138: 
            case 141: 
            case 145: 
            case 146: 
            case 147: 
            case 149: 
            case 150: 
            case 151: 
            case 153: 
            case 154: 
            case 156: 
            case 157: 
            case 159: 
            case 160: 
            case 162: 
            case 165: 
            case 167: 
            case 168: 
            case 170: 
            case 171: 
            case 174: 
            case 175: 
            case 177: 
            case 180: 
            case 185: 
            case 187: 
            case 189: 
            case 191: 
            case 192: 
            case 193: 
            case 196: 
            case 197: 
            case 201: 
            case 202: 
            case 205: 
            case 206: 
            case 207: 
            case 209: 
            case 210: 
            case 212: 
            case 214: 
            case 215: 
            case 216: 
            case 223: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 230: 
            case 231: 
            case 233: 
            case 235: 
            case 236: 
            case 239: 
            case 241: 
            case 242: 
            case 243: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 252: 
            case 253: 
            case 254: 
            case 257: 
            case 260: 
            case 263: 
            case 264: 
            case 268: 
            case 269: 
            case 271: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 278: 
            case 279: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 284: 
            case 285: 
            case 286: 
            case 287: 
            case 288: 
            case 289: 
            case 290: 
            case 291: 
            case 294: 
            case 295: 
            case 297: 
            case 299: 
            case 300: 
            case 301: 
            case 302: 
            case 306: 
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 313: 
            case 315: 
            case 317: 
            case 319: 
            case 320: 
            case 324: 
            case 325: 
            case 326: 
            case 328: 
            case 329: 
            case 330: 
            case 331: 
            case 332: 
            case 333: 
            case 334: 
            case 335: 
            case 339: 
            case 340: 
            case 341: 
            case 342: 
            case 343: 
            case 344: 
            case 345: 
            case 346: 
            case 351: 
            case 352: 
            case 353: 
            case 357: 
            case 358: 
            case 359: 
            case 360: 
            case 361: 
            case 362: 
            case 363: 
            case 364: 
            case 365: 
            case 367: 
            case 369: 
            case 370: 
            case 379: 
            case 380: 
            case 383: 
            case 384: 
            case 385: 
            case 388: 
            case 391: 
            case 392: 
            case 393: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 399: 
            case 400: 
            case 401: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 411: 
            case 412: 
            case 413: 
            case 414: 
            case 416: 
            case 417: 
            case 418: 
            case 419: 
            case 421: 
            case 423: 
            case 425: 
            case 428: 
            case 429: 
            case 431: 
            case 432: 
            case 434: 
            case 435: 
            case 436: 
            case 438: 
            case 439: 
            case 448: 
            case 452: 
            case 454: 
            case 455: 
            case 457: 
            case 458: 
            case 460: 
            case 461: 
            case 462: 
            case 465: 
            case 466: 
            case 467: 
            case 468: 
            case 469: 
            case 472: 
            case 473: 
            case 474: 
            case 477: 
            case 478: 
            case 479: 
            case 480: 
            case 481: 
            case 482: 
            case 483: 
            case 485: 
            case 488: 
            case 489: 
            case 490: 
            case 491: 
            case 493: 
            case 494: 
            case 495: 
            case 498: 
            case 499: 
            case 500: 
            case 501: 
            case 504: 
            case 506: 
            case 507: 
            case 508: 
            case 509: 
            case 510: 
            case 511: 
            case 512: 
            case 514: 
            case 518: 
            case 519: 
            case 522: 
            case 523: 
            case 524: 
            case 525: 
            case 526: 
            case 532: 
            case 533: 
            case 534: 
            case 535: 
            case 536: 
            case 537: 
            case 538: 
            case 539: 
            case 540: 
            case 541: 
            case 542: 
            case 543: 
            case 544: 
            case 545: 
            case 546: 
            case 547: 
            case 548: 
            case 549: 
            case 550: 
            case 551: 
            case 552: 
            case 553: 
            case 554: 
            case 555: 
            case 556: 
            case 557: 
            case 558: 
            case 559: 
            case 560: 
            case 561: 
            case 562: 
            case 563: 
            case 564: 
            case 565: 
            case 566: 
            case 567: 
            case 568: 
            case 569: 
            case 570: 
            case 571: 
            case 572: 
            case 573: 
            case 574: 
            case 575: 
            case 576: 
            case 577: 
            case 578: 
            case 579: 
            case 580: 
            case 581: 
            case 583: 
            case 584: 
            case 586: 
            case 587: 
            case 589: 
            case 590: 
            case 591: 
            case 592: 
            case 595: 
            case 596: 
            case 599: 
            case 604: 
            case 606: 
            case 608: 
            case 611: 
            case 612: 
            case 613: 
            case 614: 
            case 615: 
            case 616: 
            case 617: 
            case 618: 
            case 619: 
            case 624: 
            case 626: 
            case 627: 
            case 628: 
            case 629: 
            case 630: 
            case 631: 
            case 632: 
            case 637: 
            case 638: 
            case 639: 
            case 640: 
            case 642: 
            case 643: 
            case 645: 
            case 646: 
            case 648: 
            case 649: 
            case 650: 
            case 651: 
            case 653: 
            case 654: 
            case 655: 
            case 656: 
            case 659: 
            case 661: 
            case 662: 
            case 663: 
            case 664: 
            case 665: 
            case 666: 
            case 668: 
            case 669: 
            case 670: 
            case 674: 
            case 675: 
            case 679: 
            case 681: 
            case 683: 
            case 684: 
            case 693: 
            case 694: 
            case 695: 
            case 696: 
            case 697: 
            case 698: 
            case 699: 
            case 700: 
            case 701: 
            case 702: 
            case 706: 
            case 707: 
            case 708: 
            case 709: 
            case 710: 
            case 712: 
            case 713: 
            case 715: 
            case 717: 
            case 718: 
            case 719: 
            case 720: 
            case 731: 
            case 737: 
            case 738: 
            case 763: 
            case 764: 
            case 765: 
            case 766: 
            case 767: 
            case 768: 
            case 770: {
                SqlNode e = this.Expression(SqlAbstractParserImpl.ExprContext.ACCEPT_NON_QUERY);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 425: {
                        this.jj_consume_token(425);
                        return SqlWindow.createPreceding(e, this.getPos());
                    }
                    case 210: {
                        this.jj_consume_token(210);
                        return SqlWindow.createFollowing(e, this.getPos());
                    }
                }
                this.jj_la1[128] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_la1[129] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SqlNodeList OrderBy(boolean accept) throws ParseException {
        ArrayList<SqlNode> list = new ArrayList<SqlNode>();
        this.jj_consume_token(382);
        Span s = this.span();
        if (!accept) {
            throw SqlUtil.newContextException(s.pos(), Static.RESOURCE.illegalOrderBy());
        }
        this.jj_consume_token(48);
        this.AddOrderItem(list);
        while (this.jj_2_39(2)) {
            this.jj_consume_token(727);
            this.AddOrderItem(list);
        }
        return new SqlNodeList(list, s.addAll(list).pos());
    }

    public final void AddOrderItem(List<SqlNode> list) throws ParseException {
        SqlNode e = this.Expression(SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 24: 
            case 157: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 24: {
                        this.jj_consume_token(24);
                        break block0;
                    }
                    case 157: {
                        this.jj_consume_token(157);
                        e = SqlStdOperatorTable.DESC.createCall(this.getPos(), e);
                        break block0;
                    }
                }
                this.jj_la1[130] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[131] = this.jj_gen;
            }
        }
        block7 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 364: {
                if (this.jj_2_40(2)) {
                    this.jj_consume_token(364);
                    this.jj_consume_token(206);
                    e = SqlStdOperatorTable.NULLS_FIRST.createCall(this.getPos(), e);
                    break;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 364: {
                        this.jj_consume_token(364);
                        this.jj_consume_token(294);
                        e = SqlStdOperatorTable.NULLS_LAST.createCall(this.getPos(), e);
                        break block7;
                    }
                }
                this.jj_la1[132] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[133] = this.jj_gen;
            }
        }
        list.add(e);
    }

    public final SqlNode Over(SqlNode tableRef) throws ParseException {
        SqlNode over = this.TableOverOpt();
        if (over != null) {
            return SqlStdOperatorTable.OVER.createCall(this.getPos(), this.checkNotJoin(tableRef), over);
        }
        return tableRef;
    }

    SqlNode addLateral(SqlNode tableRef, boolean lateral) throws ParseException {
        return lateral ? SqlStdOperatorTable.LATERAL.createCall(this.getPos(), this.checkNotJoin(tableRef)) : tableRef;
    }

    public final SqlSnapshot Snapshot(SqlNode tableRef) throws ParseException {
        Span s = this.span();
        this.jj_consume_token(211);
        this.jj_consume_token(603);
        this.jj_consume_token(23);
        this.jj_consume_token(371);
        SqlNode e = this.Expression(SqlAbstractParserImpl.ExprContext.ACCEPT_NON_QUERY);
        return new SqlSnapshot(s.end(this), tableRef, e);
    }

    public final SqlNode Pivot(SqlNode tableRef) throws ParseException {
        ArrayList<SqlNode> aggList = new ArrayList<SqlNode>();
        ArrayList<SqlNode> valueList = new ArrayList<SqlNode>();
        this.jj_consume_token(416);
        Span s = this.span();
        this.checkNotJoin(tableRef);
        this.jj_consume_token(715);
        this.AddPivotAgg(aggList);
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 727: {
                    break;
                }
                default: {
                    this.jj_la1[134] = this.jj_gen;
                    break block9;
                }
            }
            this.jj_consume_token(727);
            this.AddPivotAgg(aggList);
        }
        this.jj_consume_token(211);
        SqlNodeList axisList = this.SimpleIdentifierOrList();
        this.jj_consume_token(251);
        this.jj_consume_token(715);
        Span s2 = this.span();
        block3 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 39: 
            case 47: 
            case 49: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 74: 
            case 77: 
            case 78: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 86: 
            case 87: 
            case 88: 
            case 90: 
            case 92: 
            case 93: 
            case 95: 
            case 96: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 104: 
            case 105: 
            case 108: 
            case 109: 
            case 110: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 122: 
            case 123: 
            case 124: 
            case 126: 
            case 127: 
            case 128: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 138: 
            case 141: 
            case 145: 
            case 146: 
            case 147: 
            case 149: 
            case 150: 
            case 151: 
            case 153: 
            case 154: 
            case 156: 
            case 157: 
            case 159: 
            case 160: 
            case 162: 
            case 165: 
            case 167: 
            case 168: 
            case 170: 
            case 171: 
            case 174: 
            case 175: 
            case 177: 
            case 180: 
            case 185: 
            case 187: 
            case 189: 
            case 191: 
            case 192: 
            case 193: 
            case 196: 
            case 197: 
            case 201: 
            case 202: 
            case 205: 
            case 206: 
            case 207: 
            case 209: 
            case 210: 
            case 212: 
            case 214: 
            case 215: 
            case 216: 
            case 223: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 230: 
            case 231: 
            case 233: 
            case 235: 
            case 236: 
            case 239: 
            case 241: 
            case 242: 
            case 243: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 252: 
            case 253: 
            case 254: 
            case 257: 
            case 260: 
            case 263: 
            case 264: 
            case 268: 
            case 269: 
            case 271: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 278: 
            case 279: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 284: 
            case 285: 
            case 286: 
            case 287: 
            case 288: 
            case 289: 
            case 290: 
            case 291: 
            case 294: 
            case 295: 
            case 297: 
            case 299: 
            case 300: 
            case 301: 
            case 302: 
            case 306: 
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 313: 
            case 315: 
            case 317: 
            case 319: 
            case 320: 
            case 324: 
            case 325: 
            case 326: 
            case 328: 
            case 329: 
            case 330: 
            case 331: 
            case 332: 
            case 333: 
            case 334: 
            case 335: 
            case 339: 
            case 340: 
            case 341: 
            case 342: 
            case 343: 
            case 344: 
            case 345: 
            case 346: 
            case 351: 
            case 352: 
            case 353: 
            case 357: 
            case 358: 
            case 359: 
            case 360: 
            case 361: 
            case 362: 
            case 363: 
            case 364: 
            case 365: 
            case 367: 
            case 369: 
            case 370: 
            case 379: 
            case 380: 
            case 383: 
            case 384: 
            case 385: 
            case 388: 
            case 391: 
            case 392: 
            case 393: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 399: 
            case 400: 
            case 401: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 411: 
            case 412: 
            case 413: 
            case 414: 
            case 416: 
            case 417: 
            case 418: 
            case 419: 
            case 421: 
            case 423: 
            case 425: 
            case 428: 
            case 429: 
            case 431: 
            case 432: 
            case 434: 
            case 435: 
            case 436: 
            case 438: 
            case 439: 
            case 448: 
            case 452: 
            case 454: 
            case 455: 
            case 457: 
            case 458: 
            case 460: 
            case 461: 
            case 462: 
            case 465: 
            case 466: 
            case 467: 
            case 468: 
            case 469: 
            case 472: 
            case 473: 
            case 474: 
            case 477: 
            case 478: 
            case 479: 
            case 480: 
            case 481: 
            case 482: 
            case 483: 
            case 485: 
            case 488: 
            case 489: 
            case 490: 
            case 491: 
            case 493: 
            case 494: 
            case 495: 
            case 498: 
            case 499: 
            case 500: 
            case 501: 
            case 504: 
            case 506: 
            case 507: 
            case 508: 
            case 509: 
            case 510: 
            case 511: 
            case 512: 
            case 514: 
            case 518: 
            case 519: 
            case 522: 
            case 523: 
            case 524: 
            case 525: 
            case 526: 
            case 532: 
            case 533: 
            case 534: 
            case 535: 
            case 536: 
            case 537: 
            case 538: 
            case 539: 
            case 540: 
            case 541: 
            case 542: 
            case 543: 
            case 544: 
            case 545: 
            case 546: 
            case 547: 
            case 548: 
            case 549: 
            case 550: 
            case 551: 
            case 552: 
            case 553: 
            case 554: 
            case 555: 
            case 556: 
            case 557: 
            case 558: 
            case 559: 
            case 560: 
            case 561: 
            case 562: 
            case 563: 
            case 564: 
            case 565: 
            case 566: 
            case 567: 
            case 568: 
            case 569: 
            case 570: 
            case 571: 
            case 572: 
            case 573: 
            case 574: 
            case 575: 
            case 576: 
            case 577: 
            case 578: 
            case 579: 
            case 580: 
            case 581: 
            case 583: 
            case 584: 
            case 586: 
            case 587: 
            case 589: 
            case 590: 
            case 591: 
            case 592: 
            case 595: 
            case 596: 
            case 599: 
            case 604: 
            case 606: 
            case 608: 
            case 611: 
            case 612: 
            case 613: 
            case 614: 
            case 615: 
            case 616: 
            case 617: 
            case 618: 
            case 619: 
            case 624: 
            case 626: 
            case 627: 
            case 628: 
            case 629: 
            case 630: 
            case 631: 
            case 632: 
            case 637: 
            case 638: 
            case 639: 
            case 640: 
            case 642: 
            case 643: 
            case 645: 
            case 646: 
            case 648: 
            case 649: 
            case 650: 
            case 651: 
            case 653: 
            case 654: 
            case 655: 
            case 656: 
            case 659: 
            case 661: 
            case 662: 
            case 663: 
            case 664: 
            case 665: 
            case 666: 
            case 668: 
            case 669: 
            case 670: 
            case 674: 
            case 675: 
            case 679: 
            case 681: 
            case 683: 
            case 684: 
            case 693: 
            case 694: 
            case 695: 
            case 696: 
            case 697: 
            case 698: 
            case 699: 
            case 700: 
            case 701: 
            case 702: 
            case 706: 
            case 707: 
            case 708: 
            case 709: 
            case 710: 
            case 712: 
            case 713: 
            case 715: 
            case 717: 
            case 718: 
            case 719: 
            case 720: 
            case 731: 
            case 737: 
            case 738: 
            case 763: 
            case 764: 
            case 765: 
            case 766: 
            case 767: 
            case 768: 
            case 770: {
                this.AddPivotValue(valueList);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 727: {
                            break;
                        }
                        default: {
                            this.jj_la1[135] = this.jj_gen;
                            break block3;
                        }
                    }
                    this.jj_consume_token(727);
                    this.AddPivotValue(valueList);
                }
            }
            default: {
                this.jj_la1[136] = this.jj_gen;
            }
        }
        this.jj_consume_token(716);
        SqlNodeList inList = new SqlNodeList(valueList, s2.end(this));
        this.jj_consume_token(716);
        return new SqlPivot(s.end(this), tableRef, new SqlNodeList(aggList, SqlParserPos.sum(aggList)), axisList, inList);
    }

    public final void AddPivotAgg(List<SqlNode> list) throws ParseException {
        SqlNode e = this.NamedFunctionCall();
        if (this.getToken((int)1).kind != 727 && this.getToken((int)1).kind != 211) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 23: {
                    this.jj_consume_token(23);
                    break;
                }
                default: {
                    this.jj_la1[137] = this.jj_gen;
                }
            }
            SqlIdentifier alias = this.SimpleIdentifier();
            list.add(SqlStdOperatorTable.AS.createCall(Span.of(e).end(this), e, alias));
        } else {
            list.add(e);
        }
    }

    public final void AddPivotValue(List<SqlNode> list) throws ParseException {
        SqlNode e = this.RowConstructor();
        SqlNodeList tuple = SqlParserUtil.stripRow(e);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 35: 
            case 39: 
            case 47: 
            case 49: 
            case 53: 
            case 57: 
            case 58: 
            case 61: 
            case 62: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 74: 
            case 78: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 86: 
            case 87: 
            case 88: 
            case 90: 
            case 92: 
            case 93: 
            case 95: 
            case 96: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 104: 
            case 128: 
            case 130: 
            case 131: 
            case 133: 
            case 135: 
            case 136: 
            case 138: 
            case 141: 
            case 145: 
            case 146: 
            case 147: 
            case 149: 
            case 150: 
            case 151: 
            case 154: 
            case 156: 
            case 157: 
            case 159: 
            case 160: 
            case 162: 
            case 165: 
            case 167: 
            case 168: 
            case 170: 
            case 171: 
            case 174: 
            case 175: 
            case 180: 
            case 185: 
            case 187: 
            case 191: 
            case 192: 
            case 193: 
            case 205: 
            case 206: 
            case 210: 
            case 212: 
            case 214: 
            case 215: 
            case 216: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 230: 
            case 231: 
            case 233: 
            case 235: 
            case 239: 
            case 241: 
            case 243: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 252: 
            case 253: 
            case 254: 
            case 257: 
            case 260: 
            case 263: 
            case 264: 
            case 271: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 278: 
            case 286: 
            case 287: 
            case 288: 
            case 289: 
            case 290: 
            case 294: 
            case 300: 
            case 301: 
            case 302: 
            case 310: 
            case 312: 
            case 313: 
            case 315: 
            case 320: 
            case 324: 
            case 325: 
            case 326: 
            case 328: 
            case 329: 
            case 330: 
            case 333: 
            case 334: 
            case 340: 
            case 341: 
            case 343: 
            case 344: 
            case 345: 
            case 346: 
            case 351: 
            case 357: 
            case 362: 
            case 364: 
            case 365: 
            case 367: 
            case 370: 
            case 379: 
            case 380: 
            case 383: 
            case 384: 
            case 385: 
            case 388: 
            case 392: 
            case 393: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 399: 
            case 400: 
            case 401: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 416: 
            case 417: 
            case 418: 
            case 419: 
            case 425: 
            case 428: 
            case 431: 
            case 432: 
            case 434: 
            case 435: 
            case 436: 
            case 439: 
            case 455: 
            case 457: 
            case 458: 
            case 460: 
            case 461: 
            case 462: 
            case 465: 
            case 466: 
            case 467: 
            case 468: 
            case 469: 
            case 473: 
            case 474: 
            case 477: 
            case 478: 
            case 479: 
            case 480: 
            case 482: 
            case 488: 
            case 489: 
            case 490: 
            case 491: 
            case 493: 
            case 494: 
            case 495: 
            case 499: 
            case 500: 
            case 501: 
            case 504: 
            case 506: 
            case 507: 
            case 508: 
            case 509: 
            case 510: 
            case 511: 
            case 514: 
            case 518: 
            case 519: 
            case 523: 
            case 524: 
            case 526: 
            case 532: 
            case 533: 
            case 534: 
            case 535: 
            case 536: 
            case 537: 
            case 538: 
            case 539: 
            case 540: 
            case 541: 
            case 542: 
            case 543: 
            case 544: 
            case 545: 
            case 546: 
            case 547: 
            case 548: 
            case 549: 
            case 550: 
            case 551: 
            case 552: 
            case 553: 
            case 554: 
            case 555: 
            case 556: 
            case 557: 
            case 558: 
            case 559: 
            case 560: 
            case 561: 
            case 562: 
            case 563: 
            case 564: 
            case 565: 
            case 566: 
            case 567: 
            case 568: 
            case 569: 
            case 570: 
            case 571: 
            case 572: 
            case 573: 
            case 574: 
            case 575: 
            case 576: 
            case 577: 
            case 578: 
            case 579: 
            case 580: 
            case 583: 
            case 584: 
            case 589: 
            case 590: 
            case 591: 
            case 592: 
            case 595: 
            case 606: 
            case 608: 
            case 611: 
            case 613: 
            case 614: 
            case 616: 
            case 617: 
            case 618: 
            case 619: 
            case 624: 
            case 626: 
            case 627: 
            case 628: 
            case 629: 
            case 630: 
            case 631: 
            case 637: 
            case 638: 
            case 639: 
            case 645: 
            case 646: 
            case 648: 
            case 649: 
            case 650: 
            case 651: 
            case 655: 
            case 656: 
            case 661: 
            case 663: 
            case 664: 
            case 665: 
            case 666: 
            case 668: 
            case 669: 
            case 670: 
            case 679: 
            case 681: 
            case 683: 
            case 684: 
            case 693: 
            case 694: 
            case 695: 
            case 696: 
            case 698: 
            case 699: 
            case 763: 
            case 764: 
            case 765: 
            case 766: 
            case 767: 
            case 768: 
            case 770: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 23: {
                        this.jj_consume_token(23);
                        break;
                    }
                    default: {
                        this.jj_la1[138] = this.jj_gen;
                    }
                }
                SqlIdentifier alias = this.SimpleIdentifier();
                list.add(SqlStdOperatorTable.AS.createCall(Span.of(tuple).end(this), tuple, alias));
                break;
            }
            default: {
                this.jj_la1[139] = this.jj_gen;
                list.add(tuple);
            }
        }
    }

    public final SqlNode Unpivot(SqlNode tableRef) throws ParseException {
        boolean includeNulls;
        ArrayList<SqlNode> values = new ArrayList<SqlNode>();
        this.jj_consume_token(655);
        Span s = this.span();
        this.checkNotJoin(tableRef);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 252: {
                this.jj_consume_token(252);
                this.jj_consume_token(364);
                includeNulls = true;
                break;
            }
            case 192: {
                this.jj_consume_token(192);
                this.jj_consume_token(364);
                includeNulls = false;
                break;
            }
            default: {
                this.jj_la1[140] = this.jj_gen;
                includeNulls = false;
            }
        }
        this.jj_consume_token(715);
        SqlNodeList measureList = this.SimpleIdentifierOrList();
        this.jj_consume_token(211);
        SqlNodeList axisList = this.SimpleIdentifierOrList();
        this.jj_consume_token(251);
        this.jj_consume_token(715);
        Span s2 = this.span();
        this.AddUnpivotValue(values);
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 727: {
                    break;
                }
                default: {
                    this.jj_la1[141] = this.jj_gen;
                    break block7;
                }
            }
            this.jj_consume_token(727);
            this.AddUnpivotValue(values);
        }
        this.jj_consume_token(716);
        SqlNodeList inList = new SqlNodeList(values, s2.end(this));
        this.jj_consume_token(716);
        return new SqlUnpivot(s.end(this), tableRef, includeNulls, measureList, axisList, inList);
    }

    public final void AddUnpivotValue(List<SqlNode> list) throws ParseException {
        SqlNodeList columnList = this.SimpleIdentifierOrList();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 23: {
                this.jj_consume_token(23);
                SqlNode values = this.RowConstructor();
                SqlNodeList valueList = SqlParserUtil.stripRow(values);
                list.add(SqlStdOperatorTable.AS.createCall(Span.of(columnList).end(this), columnList, valueList));
                break;
            }
            default: {
                this.jj_la1[142] = this.jj_gen;
                list.add(columnList);
            }
        }
    }

    public final SqlMatchRecognize MatchRecognize(SqlNode tableRef) throws ParseException {
        SqlNodeList subsetList;
        SqlLiteral interval;
        SqlLiteral isStrictEnds;
        SqlLiteral isStrictStarts;
        SqlNode after;
        SqlLiteral rowsPerMatch;
        SqlNodeList measureList;
        SqlNodeList orderList;
        SqlNodeList partitionList;
        this.jj_consume_token(318);
        Span s = this.span();
        this.checkNotJoin(tableRef);
        this.jj_consume_token(715);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 402: {
                this.jj_consume_token(402);
                Span s2 = this.span();
                this.jj_consume_token(48);
                partitionList = this.ExpressionCommaList(s2, SqlAbstractParserImpl.ExprContext.ACCEPT_NON_QUERY);
                break;
            }
            default: {
                this.jj_la1[143] = this.jj_gen;
                partitionList = SqlNodeList.EMPTY;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 382: {
                orderList = this.OrderBy(true);
                break;
            }
            default: {
                this.jj_la1[144] = this.jj_gen;
                orderList = SqlNodeList.EMPTY;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 321: {
                this.jj_consume_token(321);
                measureList = this.MeasureColumnCommaList(this.span());
                break;
            }
            default: {
                this.jj_la1[145] = this.jj_gen;
                measureList = SqlNodeList.EMPTY;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 376: {
                this.jj_consume_token(376);
                Span s0 = this.span();
                this.jj_consume_token(481);
                this.jj_consume_token(409);
                this.jj_consume_token(314);
                rowsPerMatch = SqlMatchRecognize.RowsPerMatchOption.ONE_ROW.symbol(s0.end(this));
                break;
            }
            case 10: {
                this.jj_consume_token(10);
                Span s0 = this.span();
                this.jj_consume_token(484);
                this.jj_consume_token(409);
                this.jj_consume_token(314);
                rowsPerMatch = SqlMatchRecognize.RowsPerMatchOption.ALL_ROWS.symbol(s0.end(this));
                break;
            }
            default: {
                this.jj_la1[146] = this.jj_gen;
                rowsPerMatch = null;
            }
        }
        block13 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 9: {
                this.jj_consume_token(9);
                Span s1 = this.span();
                this.jj_consume_token(314);
                this.jj_consume_token(520);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 623: {
                        this.jj_consume_token(623);
                        if (this.jj_2_42(2)) {
                            this.jj_consume_token(353);
                            this.jj_consume_token(481);
                            after = SqlMatchRecognize.AfterOption.SKIP_TO_NEXT_ROW.symbol(s1.end(this));
                            break block13;
                        }
                        if (this.jj_2_43(2)) {
                            this.jj_consume_token(206);
                            SqlIdentifier var = this.SimpleIdentifier();
                            after = SqlMatchRecognize.SKIP_TO_FIRST.createCall(s1.end(var), var);
                            break block13;
                        }
                        if (this.jj_2_41(2)) {
                            this.jj_consume_token(294);
                        }
                        SqlIdentifier var = this.SimpleIdentifier();
                        after = SqlMatchRecognize.SKIP_TO_LAST.createCall(s1.end(var), var);
                        break block13;
                    }
                    case 406: {
                        this.jj_consume_token(406);
                        this.jj_consume_token(294);
                        this.jj_consume_token(481);
                        after = SqlMatchRecognize.AfterOption.SKIP_PAST_LAST_ROW.symbol(s1.end(this));
                        break block13;
                    }
                }
                this.jj_la1[147] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[148] = this.jj_gen;
                after = null;
            }
        }
        this.jj_consume_token(408);
        this.jj_consume_token(715);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 748: {
                this.jj_consume_token(748);
                isStrictStarts = SqlLiteral.createBoolean(true, this.getPos());
                break;
            }
            default: {
                this.jj_la1[149] = this.jj_gen;
                isStrictStarts = SqlLiteral.createBoolean(false, this.getPos());
            }
        }
        SqlNode pattern = this.PatternExpression();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 749: {
                this.jj_consume_token(749);
                isStrictEnds = SqlLiteral.createBoolean(true, this.getPos());
                break;
            }
            default: {
                this.jj_la1[150] = this.jj_gen;
                isStrictEnds = SqlLiteral.createBoolean(false, this.getPos());
            }
        }
        this.jj_consume_token(716);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 691: {
                this.jj_consume_token(691);
                interval = this.IntervalLiteral();
                break;
            }
            default: {
                this.jj_la1[151] = this.jj_gen;
                interval = null;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 594: {
                this.jj_consume_token(594);
                subsetList = this.SubsetDefinitionCommaList(this.span());
                break;
            }
            default: {
                this.jj_la1[152] = this.jj_gen;
                subsetList = SqlNodeList.EMPTY;
            }
        }
        this.jj_consume_token(148);
        SqlNodeList patternDefList = this.PatternDefinitionCommaList(this.span());
        this.jj_consume_token(716);
        return new SqlMatchRecognize(s.end(this), tableRef, pattern, isStrictStarts, isStrictEnds, patternDefList, measureList, after, subsetList, rowsPerMatch, partitionList, orderList, interval);
    }

    public final SqlNodeList MeasureColumnCommaList(Span s) throws ParseException {
        ArrayList<SqlNode> list = new ArrayList<SqlNode>();
        this.AddMeasureColumn(list);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 727: {
                    break;
                }
                default: {
                    this.jj_la1[153] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(727);
            this.AddMeasureColumn(list);
        }
        return new SqlNodeList(list, s.addAll(list).pos());
    }

    public final void AddMeasureColumn(List<SqlNode> list) throws ParseException {
        SqlNode e = this.Expression(SqlAbstractParserImpl.ExprContext.ACCEPT_NON_QUERY);
        this.jj_consume_token(23);
        SqlIdentifier alias = this.SimpleIdentifier();
        list.add(SqlStdOperatorTable.AS.createCall(Span.of(e).end(this), e, alias));
    }

    public final SqlNode PatternExpression() throws ParseException {
        SqlNode left = this.PatternTerm();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 747: {
                    break;
                }
                default: {
                    this.jj_la1[154] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(747);
            SqlNode right = this.PatternTerm();
            left = SqlStdOperatorTable.PATTERN_ALTER.createCall(Span.of(left).end(right), left, right);
        }
        return left;
    }

    public final SqlNode PatternTerm() throws ParseException {
        SqlNode left = this.PatternFactor();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 14: 
                case 17: 
                case 20: 
                case 21: 
                case 24: 
                case 26: 
                case 27: 
                case 31: 
                case 32: 
                case 35: 
                case 39: 
                case 47: 
                case 49: 
                case 53: 
                case 57: 
                case 58: 
                case 61: 
                case 62: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 74: 
                case 78: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 86: 
                case 87: 
                case 88: 
                case 90: 
                case 92: 
                case 93: 
                case 95: 
                case 96: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 104: 
                case 128: 
                case 130: 
                case 131: 
                case 133: 
                case 135: 
                case 136: 
                case 138: 
                case 141: 
                case 145: 
                case 146: 
                case 147: 
                case 149: 
                case 150: 
                case 151: 
                case 154: 
                case 156: 
                case 157: 
                case 159: 
                case 160: 
                case 162: 
                case 165: 
                case 167: 
                case 168: 
                case 170: 
                case 171: 
                case 174: 
                case 175: 
                case 180: 
                case 185: 
                case 187: 
                case 191: 
                case 192: 
                case 193: 
                case 205: 
                case 206: 
                case 210: 
                case 212: 
                case 214: 
                case 215: 
                case 216: 
                case 224: 
                case 225: 
                case 226: 
                case 227: 
                case 230: 
                case 231: 
                case 233: 
                case 235: 
                case 239: 
                case 241: 
                case 243: 
                case 245: 
                case 246: 
                case 247: 
                case 248: 
                case 249: 
                case 252: 
                case 253: 
                case 254: 
                case 257: 
                case 260: 
                case 263: 
                case 264: 
                case 271: 
                case 273: 
                case 274: 
                case 275: 
                case 276: 
                case 278: 
                case 286: 
                case 287: 
                case 288: 
                case 289: 
                case 290: 
                case 294: 
                case 300: 
                case 301: 
                case 302: 
                case 310: 
                case 312: 
                case 313: 
                case 315: 
                case 320: 
                case 324: 
                case 325: 
                case 326: 
                case 328: 
                case 329: 
                case 330: 
                case 333: 
                case 334: 
                case 340: 
                case 341: 
                case 343: 
                case 344: 
                case 345: 
                case 346: 
                case 351: 
                case 357: 
                case 362: 
                case 364: 
                case 365: 
                case 367: 
                case 370: 
                case 379: 
                case 380: 
                case 383: 
                case 384: 
                case 385: 
                case 388: 
                case 392: 
                case 393: 
                case 395: 
                case 396: 
                case 397: 
                case 398: 
                case 399: 
                case 400: 
                case 401: 
                case 403: 
                case 404: 
                case 405: 
                case 406: 
                case 407: 
                case 415: 
                case 416: 
                case 417: 
                case 418: 
                case 419: 
                case 425: 
                case 428: 
                case 431: 
                case 432: 
                case 434: 
                case 435: 
                case 436: 
                case 439: 
                case 455: 
                case 457: 
                case 458: 
                case 460: 
                case 461: 
                case 462: 
                case 465: 
                case 466: 
                case 467: 
                case 468: 
                case 469: 
                case 473: 
                case 474: 
                case 477: 
                case 478: 
                case 479: 
                case 480: 
                case 482: 
                case 488: 
                case 489: 
                case 490: 
                case 491: 
                case 493: 
                case 494: 
                case 495: 
                case 499: 
                case 500: 
                case 501: 
                case 504: 
                case 506: 
                case 507: 
                case 508: 
                case 509: 
                case 510: 
                case 511: 
                case 514: 
                case 518: 
                case 519: 
                case 523: 
                case 524: 
                case 526: 
                case 532: 
                case 533: 
                case 534: 
                case 535: 
                case 536: 
                case 537: 
                case 538: 
                case 539: 
                case 540: 
                case 541: 
                case 542: 
                case 543: 
                case 544: 
                case 545: 
                case 546: 
                case 547: 
                case 548: 
                case 549: 
                case 550: 
                case 551: 
                case 552: 
                case 553: 
                case 554: 
                case 555: 
                case 556: 
                case 557: 
                case 558: 
                case 559: 
                case 560: 
                case 561: 
                case 562: 
                case 563: 
                case 564: 
                case 565: 
                case 566: 
                case 567: 
                case 568: 
                case 569: 
                case 570: 
                case 571: 
                case 572: 
                case 573: 
                case 574: 
                case 575: 
                case 576: 
                case 577: 
                case 578: 
                case 579: 
                case 580: 
                case 583: 
                case 584: 
                case 589: 
                case 590: 
                case 591: 
                case 592: 
                case 595: 
                case 606: 
                case 608: 
                case 611: 
                case 613: 
                case 614: 
                case 616: 
                case 617: 
                case 618: 
                case 619: 
                case 624: 
                case 626: 
                case 627: 
                case 628: 
                case 629: 
                case 630: 
                case 631: 
                case 637: 
                case 638: 
                case 639: 
                case 645: 
                case 646: 
                case 648: 
                case 649: 
                case 650: 
                case 651: 
                case 655: 
                case 656: 
                case 661: 
                case 663: 
                case 664: 
                case 665: 
                case 666: 
                case 668: 
                case 669: 
                case 670: 
                case 679: 
                case 681: 
                case 683: 
                case 684: 
                case 693: 
                case 694: 
                case 695: 
                case 696: 
                case 698: 
                case 699: 
                case 715: 
                case 721: 
                case 763: 
                case 764: 
                case 765: 
                case 766: 
                case 767: 
                case 768: 
                case 770: {
                    break;
                }
                default: {
                    this.jj_la1[155] = this.jj_gen;
                    break block3;
                }
            }
            SqlNode right = this.PatternFactor();
            left = SqlStdOperatorTable.PATTERN_CONCAT.createCall(Span.of(left).end(right), left, right);
        }
        return left;
    }

    public final SqlNode PatternFactor() throws ParseException {
        SqlLiteral reluctant;
        SqlLiteral endNum;
        SqlLiteral startNum;
        SqlNode e = this.PatternPrimary();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 721: 
            case 731: 
            case 737: 
            case 739: {
                block3 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 739: {
                        this.jj_consume_token(739);
                        startNum = LITERAL_ZERO;
                        endNum = LITERAL_MINUS_ONE;
                        break;
                    }
                    case 737: {
                        this.jj_consume_token(737);
                        startNum = LITERAL_ONE;
                        endNum = LITERAL_MINUS_ONE;
                        break;
                    }
                    case 731: {
                        this.jj_consume_token(731);
                        startNum = LITERAL_ZERO;
                        endNum = LITERAL_ONE;
                        break;
                    }
                    case 721: {
                        this.jj_consume_token(721);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 700: 
                            case 701: 
                            case 702: {
                                startNum = this.UnsignedNumericLiteral();
                                block14 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 727: {
                                        this.jj_consume_token(727);
                                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                            case 700: 
                                            case 701: 
                                            case 702: {
                                                endNum = this.UnsignedNumericLiteral();
                                                break block14;
                                            }
                                        }
                                        this.jj_la1[156] = this.jj_gen;
                                        endNum = LITERAL_MINUS_ONE;
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[157] = this.jj_gen;
                                        endNum = startNum;
                                    }
                                }
                                this.jj_consume_token(722);
                                break block3;
                            }
                            case 727: {
                                this.jj_consume_token(727);
                                endNum = this.UnsignedNumericLiteral();
                                this.jj_consume_token(722);
                                startNum = LITERAL_MINUS_ONE;
                                break block3;
                            }
                            case 738: {
                                this.jj_consume_token(738);
                                SqlNode extra = this.PatternExpression();
                                this.jj_consume_token(738);
                                this.jj_consume_token(722);
                                return SqlStdOperatorTable.PATTERN_CONCAT.createCall(Span.of(e).end(this), e, SqlStdOperatorTable.PATTERN_EXCLUDE.createCall(Span.of(extra).end(this), extra));
                            }
                        }
                        this.jj_la1[158] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        this.jj_la1[159] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 731: {
                        this.jj_consume_token(731);
                        reluctant = SqlLiteral.createBoolean(startNum.intValue(true) != endNum.intValue(true), SqlParserPos.ZERO);
                        break block0;
                    }
                }
                this.jj_la1[160] = this.jj_gen;
                reluctant = SqlLiteral.createBoolean(false, SqlParserPos.ZERO);
                break;
            }
            default: {
                this.jj_la1[161] = this.jj_gen;
                return e;
            }
        }
        return SqlStdOperatorTable.PATTERN_QUANTIFIER.createCall(this.span().end(e), e, startNum, endNum, reluctant);
    }

    public final SqlNode PatternPrimary() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 24: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 35: 
            case 39: 
            case 47: 
            case 49: 
            case 53: 
            case 57: 
            case 58: 
            case 61: 
            case 62: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 74: 
            case 78: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 86: 
            case 87: 
            case 88: 
            case 90: 
            case 92: 
            case 93: 
            case 95: 
            case 96: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 104: 
            case 128: 
            case 130: 
            case 131: 
            case 133: 
            case 135: 
            case 136: 
            case 138: 
            case 141: 
            case 145: 
            case 146: 
            case 147: 
            case 149: 
            case 150: 
            case 151: 
            case 154: 
            case 156: 
            case 157: 
            case 159: 
            case 160: 
            case 162: 
            case 165: 
            case 167: 
            case 168: 
            case 170: 
            case 171: 
            case 174: 
            case 175: 
            case 180: 
            case 185: 
            case 187: 
            case 191: 
            case 192: 
            case 193: 
            case 205: 
            case 206: 
            case 210: 
            case 212: 
            case 214: 
            case 215: 
            case 216: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 230: 
            case 231: 
            case 233: 
            case 235: 
            case 239: 
            case 241: 
            case 243: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 252: 
            case 253: 
            case 254: 
            case 257: 
            case 260: 
            case 263: 
            case 264: 
            case 271: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 278: 
            case 286: 
            case 287: 
            case 288: 
            case 289: 
            case 290: 
            case 294: 
            case 300: 
            case 301: 
            case 302: 
            case 310: 
            case 312: 
            case 313: 
            case 315: 
            case 320: 
            case 324: 
            case 325: 
            case 326: 
            case 328: 
            case 329: 
            case 330: 
            case 333: 
            case 334: 
            case 340: 
            case 341: 
            case 343: 
            case 344: 
            case 345: 
            case 346: 
            case 351: 
            case 357: 
            case 362: 
            case 364: 
            case 365: 
            case 367: 
            case 370: 
            case 379: 
            case 380: 
            case 383: 
            case 384: 
            case 385: 
            case 388: 
            case 392: 
            case 393: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 399: 
            case 400: 
            case 401: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 416: 
            case 417: 
            case 418: 
            case 419: 
            case 425: 
            case 428: 
            case 431: 
            case 432: 
            case 434: 
            case 435: 
            case 436: 
            case 439: 
            case 455: 
            case 457: 
            case 458: 
            case 460: 
            case 461: 
            case 462: 
            case 465: 
            case 466: 
            case 467: 
            case 468: 
            case 469: 
            case 473: 
            case 474: 
            case 477: 
            case 478: 
            case 479: 
            case 480: 
            case 482: 
            case 488: 
            case 489: 
            case 490: 
            case 491: 
            case 493: 
            case 494: 
            case 495: 
            case 499: 
            case 500: 
            case 501: 
            case 504: 
            case 506: 
            case 507: 
            case 508: 
            case 509: 
            case 510: 
            case 511: 
            case 514: 
            case 518: 
            case 519: 
            case 523: 
            case 524: 
            case 526: 
            case 532: 
            case 533: 
            case 534: 
            case 535: 
            case 536: 
            case 537: 
            case 538: 
            case 539: 
            case 540: 
            case 541: 
            case 542: 
            case 543: 
            case 544: 
            case 545: 
            case 546: 
            case 547: 
            case 548: 
            case 549: 
            case 550: 
            case 551: 
            case 552: 
            case 553: 
            case 554: 
            case 555: 
            case 556: 
            case 557: 
            case 558: 
            case 559: 
            case 560: 
            case 561: 
            case 562: 
            case 563: 
            case 564: 
            case 565: 
            case 566: 
            case 567: 
            case 568: 
            case 569: 
            case 570: 
            case 571: 
            case 572: 
            case 573: 
            case 574: 
            case 575: 
            case 576: 
            case 577: 
            case 578: 
            case 579: 
            case 580: 
            case 583: 
            case 584: 
            case 589: 
            case 590: 
            case 591: 
            case 592: 
            case 595: 
            case 606: 
            case 608: 
            case 611: 
            case 613: 
            case 614: 
            case 616: 
            case 617: 
            case 618: 
            case 619: 
            case 624: 
            case 626: 
            case 627: 
            case 628: 
            case 629: 
            case 630: 
            case 631: 
            case 637: 
            case 638: 
            case 639: 
            case 645: 
            case 646: 
            case 648: 
            case 649: 
            case 650: 
            case 651: 
            case 655: 
            case 656: 
            case 661: 
            case 663: 
            case 664: 
            case 665: 
            case 666: 
            case 668: 
            case 669: 
            case 670: 
            case 679: 
            case 681: 
            case 683: 
            case 684: 
            case 693: 
            case 694: 
            case 695: 
            case 696: 
            case 698: 
            case 699: 
            case 763: 
            case 764: 
            case 765: 
            case 766: 
            case 767: 
            case 768: 
            case 770: {
                SqlIdentifier e = this.SimpleIdentifier();
                return e;
            }
            case 715: {
                this.jj_consume_token(715);
                SqlNode e = this.PatternExpression();
                this.jj_consume_token(716);
                return e;
            }
            case 721: {
                this.jj_consume_token(721);
                Span s = this.span();
                this.jj_consume_token(738);
                SqlNode e = this.PatternExpression();
                this.jj_consume_token(738);
                this.jj_consume_token(722);
                return SqlStdOperatorTable.PATTERN_EXCLUDE.createCall(s.end(this), e);
            }
            case 415: {
                this.jj_consume_token(415);
                Span s = this.span();
                ArrayList<SqlNode> list = new ArrayList<SqlNode>();
                this.jj_consume_token(715);
                SqlNode e = this.PatternExpression();
                list.add(e);
                block9: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 727: {
                            break;
                        }
                        default: {
                            this.jj_la1[162] = this.jj_gen;
                            break block9;
                        }
                    }
                    this.jj_consume_token(727);
                    e = this.PatternExpression();
                    list.add(e);
                }
                this.jj_consume_token(716);
                return SqlStdOperatorTable.PATTERN_PERMUTE.createCall(s.end(this), list);
            }
        }
        this.jj_la1[163] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SqlNodeList SubsetDefinitionCommaList(Span s) throws ParseException {
        ArrayList<SqlNode> list = new ArrayList<SqlNode>();
        this.AddSubsetDefinition(list);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 727: {
                    break;
                }
                default: {
                    this.jj_la1[164] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(727);
            this.AddSubsetDefinition(list);
        }
        return new SqlNodeList(list, s.addAll(list).pos());
    }

    public final void AddSubsetDefinition(List<SqlNode> list) throws ParseException {
        SqlIdentifier var = this.SimpleIdentifier();
        this.jj_consume_token(728);
        this.jj_consume_token(715);
        SqlNodeList varList = this.ExpressionCommaList(this.span(), SqlAbstractParserImpl.ExprContext.ACCEPT_NON_QUERY);
        this.jj_consume_token(716);
        list.add(SqlStdOperatorTable.EQUALS.createCall(this.span().end(var), var, varList));
    }

    public final SqlNodeList PatternDefinitionCommaList(Span s) throws ParseException {
        ArrayList<SqlNode> eList = new ArrayList<SqlNode>();
        SqlNode e = this.PatternDefinition();
        eList.add(e);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 727: {
                    break;
                }
                default: {
                    this.jj_la1[165] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(727);
            e = this.PatternDefinition();
            eList.add(e);
        }
        return new SqlNodeList(eList, s.addAll(eList).pos());
    }

    public final SqlNode PatternDefinition() throws ParseException {
        SqlIdentifier var = this.SimpleIdentifier();
        this.jj_consume_token(23);
        SqlNode e = this.Expression(SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        return SqlStdOperatorTable.AS.createCall(Span.of(var, e).pos(), e, var);
    }

    public final SqlNode SqlExpressionEof() throws ParseException {
        SqlNode e = this.Expression(SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        this.jj_consume_token(0);
        return e;
    }

    public final SqlNode QueryOrExpr(SqlAbstractParserImpl.ExprContext exprContext) throws ParseException {
        SqlNodeList withList = null;
        ArrayList<Object> list = new ArrayList<Object>();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 690: {
                withList = this.WithList();
                break;
            }
            default: {
                this.jj_la1[166] = this.jj_gen;
            }
        }
        SqlNode e = this.LeafQueryOrExpr(exprContext);
        list.add(e);
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 190: 
                case 267: 
                case 515: 
                case 652: {
                    break;
                }
                default: {
                    this.jj_la1[167] = this.jj_gen;
                    break block6;
                }
            }
            this.AddSetOpQuery(list, exprContext);
        }
        return this.addWith(withList, SqlParserUtil.toTree(list));
    }

    public final SqlNode Query(SqlAbstractParserImpl.ExprContext exprContext) throws ParseException {
        SqlNodeList withList = null;
        ArrayList<Object> list = new ArrayList<Object>();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 690: {
                withList = this.WithList();
                break;
            }
            default: {
                this.jj_la1[168] = this.jj_gen;
            }
        }
        SqlNode e = this.LeafQuery(exprContext);
        list.add(e);
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 190: 
                case 267: 
                case 515: 
                case 652: {
                    break;
                }
                default: {
                    this.jj_la1[169] = this.jj_gen;
                    break block6;
                }
            }
            this.AddSetOpQuery(list, exprContext);
        }
        return this.addWith(withList, SqlParserUtil.toTree(list));
    }

    SqlNode addWith(SqlNodeList withList, SqlNode e) throws ParseException {
        return withList == null ? e : new SqlWith(withList.getParserPosition(), withList, e);
    }

    public final void AddSetOpQueryOrExpr(List<Object> list, SqlAbstractParserImpl.ExprContext exprContext) throws ParseException {
        if (list.size() == 1 && !((SqlNode)list.get(0)).isA(SqlKind.QUERY)) {
            this.checkNonQueryExpression(SqlAbstractParserImpl.ExprContext.ACCEPT_QUERY);
        }
        SqlBinaryOperator op = this.BinaryQueryOperator();
        SqlParserPos pos = this.getPos();
        this.checkQueryExpression(exprContext);
        SqlNode e = this.LeafQueryOrExpr(SqlAbstractParserImpl.ExprContext.ACCEPT_QUERY);
        list.add(new SqlParserUtil.ToTreeListItem(op, pos));
        list.add(e);
    }

    public final void AddSetOpQuery(List<Object> list, SqlAbstractParserImpl.ExprContext exprContext) throws ParseException {
        if (list.size() == 1 && !((SqlNode)list.get(0)).isA(SqlKind.QUERY)) {
            this.checkNonQueryExpression(SqlAbstractParserImpl.ExprContext.ACCEPT_QUERY);
        }
        SqlBinaryOperator op = this.BinaryQueryOperator();
        SqlParserPos pos = this.getPos();
        this.checkQueryExpression(exprContext);
        SqlNode e = this.LeafQueryOrExpr(SqlAbstractParserImpl.ExprContext.ACCEPT_QUERY);
        list.add(new SqlParserUtil.ToTreeListItem(op, pos));
        list.add(e);
    }

    public final SqlNodeList WithList() throws ParseException {
        ArrayList<SqlWithItem> list = new ArrayList<SqlWithItem>();
        this.jj_consume_token(690);
        Span s = this.span();
        this.AddWithItem(list);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 727: {
                    break;
                }
                default: {
                    this.jj_la1[170] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(727);
            this.AddWithItem(list);
        }
        return new SqlNodeList(list, s.end(this));
    }

    public final void AddWithItem(List<SqlWithItem> list) throws ParseException {
        SqlNodeList columnList;
        SqlIdentifier id = this.SimpleIdentifier();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 715: {
                columnList = this.ParenthesizedSimpleIdentifierList();
                break;
            }
            default: {
                this.jj_la1[171] = this.jj_gen;
                columnList = null;
            }
        }
        this.jj_consume_token(23);
        SqlNode definition = this.ParenthesizedExpression(SqlAbstractParserImpl.ExprContext.ACCEPT_QUERY);
        list.add(new SqlWithItem(id.getParserPosition(), id, columnList, definition));
    }

    public final SqlNode LeafQueryOrExpr(SqlAbstractParserImpl.ExprContext exprContext) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 503: 
            case 605: 
            case 671: 
            case 672: {
                SqlNode e = this.LeafQuery(exprContext);
                return e;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 39: 
            case 47: 
            case 49: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 74: 
            case 77: 
            case 78: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 86: 
            case 87: 
            case 88: 
            case 90: 
            case 92: 
            case 93: 
            case 95: 
            case 96: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 104: 
            case 105: 
            case 108: 
            case 109: 
            case 110: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 122: 
            case 123: 
            case 124: 
            case 126: 
            case 127: 
            case 128: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 138: 
            case 141: 
            case 145: 
            case 146: 
            case 147: 
            case 149: 
            case 150: 
            case 151: 
            case 153: 
            case 154: 
            case 156: 
            case 157: 
            case 159: 
            case 160: 
            case 162: 
            case 165: 
            case 167: 
            case 168: 
            case 170: 
            case 171: 
            case 174: 
            case 175: 
            case 177: 
            case 180: 
            case 185: 
            case 187: 
            case 189: 
            case 191: 
            case 192: 
            case 193: 
            case 196: 
            case 197: 
            case 201: 
            case 202: 
            case 205: 
            case 206: 
            case 207: 
            case 209: 
            case 210: 
            case 212: 
            case 214: 
            case 215: 
            case 216: 
            case 223: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 230: 
            case 231: 
            case 233: 
            case 235: 
            case 236: 
            case 239: 
            case 241: 
            case 242: 
            case 243: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 252: 
            case 253: 
            case 254: 
            case 257: 
            case 260: 
            case 263: 
            case 264: 
            case 268: 
            case 269: 
            case 271: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 278: 
            case 279: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 284: 
            case 285: 
            case 286: 
            case 287: 
            case 288: 
            case 289: 
            case 290: 
            case 291: 
            case 294: 
            case 295: 
            case 297: 
            case 299: 
            case 300: 
            case 301: 
            case 302: 
            case 306: 
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 313: 
            case 315: 
            case 317: 
            case 319: 
            case 320: 
            case 324: 
            case 325: 
            case 326: 
            case 328: 
            case 329: 
            case 330: 
            case 331: 
            case 332: 
            case 333: 
            case 334: 
            case 335: 
            case 339: 
            case 340: 
            case 341: 
            case 342: 
            case 343: 
            case 344: 
            case 345: 
            case 346: 
            case 351: 
            case 352: 
            case 353: 
            case 357: 
            case 358: 
            case 359: 
            case 360: 
            case 361: 
            case 362: 
            case 363: 
            case 364: 
            case 365: 
            case 367: 
            case 369: 
            case 370: 
            case 379: 
            case 380: 
            case 383: 
            case 384: 
            case 385: 
            case 388: 
            case 391: 
            case 392: 
            case 393: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 399: 
            case 400: 
            case 401: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 411: 
            case 412: 
            case 413: 
            case 414: 
            case 416: 
            case 417: 
            case 418: 
            case 419: 
            case 421: 
            case 423: 
            case 425: 
            case 428: 
            case 429: 
            case 431: 
            case 432: 
            case 434: 
            case 435: 
            case 436: 
            case 438: 
            case 439: 
            case 448: 
            case 452: 
            case 454: 
            case 455: 
            case 457: 
            case 458: 
            case 460: 
            case 461: 
            case 462: 
            case 465: 
            case 466: 
            case 467: 
            case 468: 
            case 469: 
            case 472: 
            case 473: 
            case 474: 
            case 477: 
            case 478: 
            case 479: 
            case 480: 
            case 481: 
            case 482: 
            case 483: 
            case 485: 
            case 488: 
            case 489: 
            case 490: 
            case 491: 
            case 493: 
            case 494: 
            case 495: 
            case 498: 
            case 499: 
            case 500: 
            case 501: 
            case 504: 
            case 506: 
            case 507: 
            case 508: 
            case 509: 
            case 510: 
            case 511: 
            case 512: 
            case 514: 
            case 518: 
            case 519: 
            case 522: 
            case 523: 
            case 524: 
            case 525: 
            case 526: 
            case 532: 
            case 533: 
            case 534: 
            case 535: 
            case 536: 
            case 537: 
            case 538: 
            case 539: 
            case 540: 
            case 541: 
            case 542: 
            case 543: 
            case 544: 
            case 545: 
            case 546: 
            case 547: 
            case 548: 
            case 549: 
            case 550: 
            case 551: 
            case 552: 
            case 553: 
            case 554: 
            case 555: 
            case 556: 
            case 557: 
            case 558: 
            case 559: 
            case 560: 
            case 561: 
            case 562: 
            case 563: 
            case 564: 
            case 565: 
            case 566: 
            case 567: 
            case 568: 
            case 569: 
            case 570: 
            case 571: 
            case 572: 
            case 573: 
            case 574: 
            case 575: 
            case 576: 
            case 577: 
            case 578: 
            case 579: 
            case 580: 
            case 581: 
            case 583: 
            case 584: 
            case 586: 
            case 587: 
            case 589: 
            case 590: 
            case 591: 
            case 592: 
            case 595: 
            case 596: 
            case 599: 
            case 604: 
            case 606: 
            case 608: 
            case 611: 
            case 612: 
            case 613: 
            case 614: 
            case 615: 
            case 616: 
            case 617: 
            case 618: 
            case 619: 
            case 624: 
            case 626: 
            case 627: 
            case 628: 
            case 629: 
            case 630: 
            case 631: 
            case 632: 
            case 637: 
            case 638: 
            case 639: 
            case 640: 
            case 642: 
            case 643: 
            case 645: 
            case 646: 
            case 648: 
            case 649: 
            case 650: 
            case 651: 
            case 653: 
            case 654: 
            case 655: 
            case 656: 
            case 659: 
            case 661: 
            case 662: 
            case 663: 
            case 664: 
            case 665: 
            case 666: 
            case 668: 
            case 669: 
            case 670: 
            case 674: 
            case 675: 
            case 679: 
            case 681: 
            case 683: 
            case 684: 
            case 693: 
            case 694: 
            case 695: 
            case 696: 
            case 697: 
            case 698: 
            case 699: 
            case 700: 
            case 701: 
            case 702: 
            case 706: 
            case 707: 
            case 708: 
            case 709: 
            case 710: 
            case 712: 
            case 713: 
            case 715: 
            case 717: 
            case 718: 
            case 719: 
            case 720: 
            case 731: 
            case 737: 
            case 738: 
            case 763: 
            case 764: 
            case 765: 
            case 766: 
            case 767: 
            case 768: 
            case 770: {
                SqlNode e = this.Expression(exprContext);
                return e;
            }
        }
        this.jj_la1[172] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final void AddExpression(List<SqlNode> list, SqlAbstractParserImpl.ExprContext exprContext) throws ParseException {
        SqlNode e = this.Expression(exprContext);
        list.add(e);
    }

    public final SqlNode Expression(SqlAbstractParserImpl.ExprContext exprContext) throws ParseException {
        List<Object> list = this.Expression2(exprContext);
        return SqlParserUtil.toTree(list);
    }

    public final void AddExpression2b(List<Object> list, SqlAbstractParserImpl.ExprContext exprContext) throws ParseException {
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 196: 
                case 358: 
                case 653: 
                case 737: 
                case 738: {
                    break;
                }
                default: {
                    this.jj_la1[173] = this.jj_gen;
                    break block3;
                }
            }
            SqlPrefixOperator op = this.PrefixRowOperator();
            this.checkNonQueryExpression(exprContext);
            list.add(new SqlParserUtil.ToTreeListItem(op, this.getPos()));
        }
        SqlNode e = this.Expression3(exprContext);
        list.add(e);
        while (this.jj_2_44(2)) {
            this.jj_consume_token(726);
            SqlNode ext = this.RowExpressionExtension();
            list.add(new SqlParserUtil.ToTreeListItem(SqlStdOperatorTable.DOT, this.getPos()));
            list.add(ext);
        }
    }

    public final List<Object> Expression2(SqlAbstractParserImpl.ExprContext exprContext) throws ParseException {
        ArrayList<Object> list = new ArrayList<Object>();
        ArrayList<Object> list3 = new ArrayList<Object>();
        Span s = this.span();
        this.AddExpression2b(list, exprContext);
        if (this.jj_2_52(2)) {
            block45: do {
                SqlNode e;
                SqlOperator op;
                if (this.jj_2_47(2)) {
                    this.checkNonQueryExpression(exprContext);
                    block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 358: {
                            this.jj_consume_token(358);
                            this.jj_consume_token(251);
                            op = SqlStdOperatorTable.NOT_IN;
                            break;
                        }
                        case 251: {
                            this.jj_consume_token(251);
                            op = SqlStdOperatorTable.IN;
                            break;
                        }
                        case 728: 
                        case 729: 
                        case 730: 
                        case 733: 
                        case 734: 
                        case 735: 
                        case 736: {
                            SqlKind k = this.comp();
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 522: {
                                    this.jj_consume_token(522);
                                    op = SqlStdOperatorTable.some(k);
                                    break block0;
                                }
                                case 16: {
                                    this.jj_consume_token(16);
                                    op = SqlStdOperatorTable.some(k);
                                    break block0;
                                }
                                case 10: {
                                    this.jj_consume_token(10);
                                    op = SqlStdOperatorTable.all(k);
                                    break block0;
                                }
                            }
                            this.jj_la1[174] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                        default: {
                            this.jj_la1[175] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    s.clear().add(this);
                    SqlNodeList nodeList = this.ParenthesizedQueryOrCommaList(SqlAbstractParserImpl.ExprContext.ACCEPT_NONCURSOR);
                    list.add(new SqlParserUtil.ToTreeListItem(op, s.pos()));
                    s.add(nodeList);
                    if (nodeList.size() == 1) {
                        SqlNode item = nodeList.get(0);
                        if (item.isA(SqlKind.QUERY)) {
                            list.add(item);
                            continue;
                        }
                        list.add(nodeList);
                        continue;
                    }
                    list.add(nodeList);
                    continue;
                }
                if (this.jj_2_48(2)) {
                    this.checkNonQueryExpression(exprContext);
                    block10 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 358: {
                            this.jj_consume_token(358);
                            this.jj_consume_token(40);
                            op = SqlStdOperatorTable.NOT_BETWEEN;
                            s.clear().add(this);
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 28: 
                                case 601: {
                                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                        case 601: {
                                            this.jj_consume_token(601);
                                            op = SqlStdOperatorTable.SYMMETRIC_NOT_BETWEEN;
                                            break block10;
                                        }
                                        case 28: {
                                            this.jj_consume_token(28);
                                            break block10;
                                        }
                                    }
                                    this.jj_la1[176] = this.jj_gen;
                                    this.jj_consume_token(-1);
                                    throw new ParseException();
                                }
                            }
                            this.jj_la1[177] = this.jj_gen;
                            break;
                        }
                        case 40: {
                            this.jj_consume_token(40);
                            op = SqlStdOperatorTable.BETWEEN;
                            s.clear().add(this);
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 28: 
                                case 601: {
                                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                        case 601: {
                                            this.jj_consume_token(601);
                                            op = SqlStdOperatorTable.SYMMETRIC_BETWEEN;
                                            break block10;
                                        }
                                        case 28: {
                                            this.jj_consume_token(28);
                                            break block10;
                                        }
                                    }
                                    this.jj_la1[178] = this.jj_gen;
                                    this.jj_consume_token(-1);
                                    throw new ParseException();
                                }
                            }
                            this.jj_la1[179] = this.jj_gen;
                            break;
                        }
                        default: {
                            this.jj_la1[180] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    this.AddExpression2b(list3, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                    list.add(new SqlParserUtil.ToTreeListItem(op, s.pos()));
                    list.addAll(list3);
                    list3.clear();
                    continue;
                }
                if (this.jj_2_49(2)) {
                    this.checkNonQueryExpression(exprContext);
                    s.clear().add(this);
                    block28 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 358: {
                            this.jj_consume_token(358);
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 303: {
                                    this.jj_consume_token(303);
                                    op = SqlStdOperatorTable.NOT_LIKE;
                                    break block28;
                                }
                                case 246: {
                                    this.jj_consume_token(246);
                                    op = SqlLibraryOperators.NOT_ILIKE;
                                    break block28;
                                }
                                case 473: {
                                    this.jj_consume_token(473);
                                    op = SqlLibraryOperators.NOT_RLIKE;
                                    break block28;
                                }
                                case 517: {
                                    this.jj_consume_token(517);
                                    this.jj_consume_token(623);
                                    op = SqlStdOperatorTable.NOT_SIMILAR_TO;
                                    break block28;
                                }
                            }
                            this.jj_la1[181] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                        case 303: {
                            this.jj_consume_token(303);
                            op = SqlStdOperatorTable.LIKE;
                            break;
                        }
                        case 246: {
                            this.jj_consume_token(246);
                            op = SqlLibraryOperators.ILIKE;
                            break;
                        }
                        case 473: {
                            this.jj_consume_token(473);
                            op = SqlLibraryOperators.RLIKE;
                            break;
                        }
                        case 517: {
                            this.jj_consume_token(517);
                            this.jj_consume_token(623);
                            op = SqlStdOperatorTable.SIMILAR_TO;
                            break;
                        }
                        default: {
                            this.jj_la1[182] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    List<Object> list2 = this.Expression2(SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                    list.add(new SqlParserUtil.ToTreeListItem(op, s.pos()));
                    list.addAll(list2);
                    if (!this.jj_2_45(2)) continue;
                    this.jj_consume_token(188);
                    e = this.Expression3(SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                    s.clear().add(this);
                    list.add(new SqlParserUtil.ToTreeListItem(SqlStdOperatorTable.ESCAPE, s.pos()));
                    list.add(e);
                    continue;
                }
                if (this.jj_2_50(3)) {
                    op = this.BinaryRowOperator();
                    this.checkNonQueryExpression(exprContext);
                    list.add(new SqlParserUtil.ToTreeListItem(op, this.getPos()));
                    this.AddExpression2b(list, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                    continue;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 723: {
                        this.jj_consume_token(723);
                        e = this.Expression(SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                        this.jj_consume_token(724);
                        list.add(new SqlParserUtil.ToTreeListItem(SqlStdOperatorTable.ITEM, this.getPos()));
                        list.add(e);
                        while (this.jj_2_46(2)) {
                            this.jj_consume_token(726);
                            SqlIdentifier p = this.SimpleIdentifier();
                            list.add(new SqlParserUtil.ToTreeListItem(SqlStdOperatorTable.DOT, this.getPos()));
                            list.add(p);
                        }
                        continue block45;
                    }
                    case 212: 
                    case 272: {
                        this.checkNonQueryExpression(exprContext);
                        op = this.PostfixRowOperator();
                        list.add(new SqlParserUtil.ToTreeListItem(op, this.getPos()));
                        break;
                    }
                    default: {
                        this.jj_la1[183] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            } while (this.jj_2_51(2));
            return list;
        }
        return list;
    }

    public final SqlKind comp() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 730: {
                this.jj_consume_token(730);
                return SqlKind.LESS_THAN;
            }
            case 733: {
                this.jj_consume_token(733);
                return SqlKind.LESS_THAN_OR_EQUAL;
            }
            case 729: {
                this.jj_consume_token(729);
                return SqlKind.GREATER_THAN;
            }
            case 734: {
                this.jj_consume_token(734);
                return SqlKind.GREATER_THAN_OR_EQUAL;
            }
            case 728: {
                this.jj_consume_token(728);
                return SqlKind.EQUALS;
            }
            case 735: {
                this.jj_consume_token(735);
                return SqlKind.NOT_EQUALS;
            }
            case 736: {
                this.jj_consume_token(736);
                if (!this.conformance.isBangEqualAllowed()) {
                    throw SqlUtil.newContextException(this.getPos(), Static.RESOURCE.bangEqualNotAllowed());
                }
                return SqlKind.NOT_EQUALS;
            }
        }
        this.jj_la1[184] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SqlNode Expression3(SqlAbstractParserImpl.ExprContext exprContext) throws ParseException {
        if (this.jj_2_54(2)) {
            SqlNode e = this.AtomicRowExpression();
            this.checkNonQueryExpression(exprContext);
            return e;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 127: {
                SqlNode e = this.CursorExpression(exprContext);
                return e;
            }
        }
        this.jj_la1[186] = this.jj_gen;
        if (this.jj_2_55(3)) {
            this.jj_consume_token(481);
            Span s = this.span();
            SqlNodeList list = this.ParenthesizedQueryOrCommaList(exprContext);
            if (exprContext != SqlAbstractParserImpl.ExprContext.ACCEPT_ALL && exprContext != SqlAbstractParserImpl.ExprContext.ACCEPT_CURSOR && !this.conformance.allowExplicitRowValueConstructor()) {
                throw SqlUtil.newContextException(s.end(list), Static.RESOURCE.illegalRowExpression());
            }
            return SqlStdOperatorTable.ROW.createCall(list);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 481: 
            case 715: {
                Span rowSpan;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 481: {
                        this.jj_consume_token(481);
                        rowSpan = this.span();
                        break;
                    }
                    default: {
                        this.jj_la1[185] = this.jj_gen;
                        rowSpan = null;
                    }
                }
                SqlNodeList list1 = this.ParenthesizedQueryOrCommaList(exprContext);
                if (rowSpan != null) {
                    return SqlStdOperatorTable.ROW.createCall(rowSpan.end(list1), (List<? extends SqlNode>)list1);
                }
                if (this.jj_2_53(2)) {
                    SqlCall call;
                    SqlIntervalQualifier e = this.IntervalQualifier();
                    if (list1.size() == 1 && list1.get(0) instanceof SqlCall && (call = (SqlCall)list1.get(0)).getKind() == SqlKind.MINUS && call.operandCount() == 2) {
                        return SqlStdOperatorTable.MINUS_DATE.createCall(Span.of(list1).end(this), new SqlNode[]{call.operand(0), call.operand(1), e});
                    }
                    throw SqlUtil.newContextException(this.span().end(list1), Static.RESOURCE.illegalMinusDate());
                }
                if (list1.size() == 1) {
                    return list1.get(0);
                }
                return SqlStdOperatorTable.ROW.createCall(this.span().end(list1), (List<? extends SqlNode>)list1);
            }
        }
        this.jj_la1[187] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SqlOperator periodOperator() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 390: {
                this.jj_consume_token(390);
                return SqlStdOperatorTable.OVERLAPS;
            }
        }
        this.jj_la1[188] = this.jj_gen;
        if (this.jj_2_56(2)) {
            this.jj_consume_token(248);
            this.jj_consume_token(424);
            return SqlStdOperatorTable.IMMEDIATELY_PRECEDES;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 424: {
                this.jj_consume_token(424);
                return SqlStdOperatorTable.PRECEDES;
            }
            case 248: {
                this.jj_consume_token(248);
                this.jj_consume_token(598);
                return SqlStdOperatorTable.IMMEDIATELY_SUCCEEDS;
            }
            case 598: {
                this.jj_consume_token(598);
                return SqlStdOperatorTable.SUCCEEDS;
            }
            case 186: {
                this.jj_consume_token(186);
                return SqlStdOperatorTable.PERIOD_EQUALS;
            }
        }
        this.jj_la1[189] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SqlCollation CollateClause() throws ParseException {
        this.jj_consume_token(79);
        this.jj_consume_token(769);
        return new SqlCollation(this.getToken((int)0).image, SqlCollation.Coercibility.EXPLICIT);
    }

    public final SqlNode UnsignedNumericLiteralOrParam() throws ParseException {
        SqlNode e;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 700: 
            case 701: 
            case 702: {
                e = this.UnsignedNumericLiteral();
                break;
            }
            case 731: {
                e = this.DynamicParam();
                break;
            }
            default: {
                this.jj_la1[190] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return e;
    }

    public final SqlNode RowExpressionExtension() throws ParseException {
        SqlFunctionCategory funcType = SqlFunctionCategory.USER_DEFINED_FUNCTION;
        SqlIdentifier p = this.SimpleIdentifier();
        if (this.jj_2_59(Integer.MAX_VALUE)) {
            Object args;
            SqlLiteral quantifier;
            Span s = this.span();
            if (this.jj_2_57(2)) {
                this.jj_consume_token(715);
                this.jj_consume_token(739);
                quantifier = null;
                args = ImmutableList.of((Object)SqlIdentifier.star(this.getPos()));
                this.jj_consume_token(716);
            } else if (this.jj_2_58(2)) {
                this.jj_consume_token(715);
                this.jj_consume_token(716);
                quantifier = null;
                args = ImmutableList.of();
            } else {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 715: {
                        args = this.FunctionParameterList(SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                        quantifier = (SqlLiteral)args.get(0);
                        args.remove(0);
                        break;
                    }
                    default: {
                        this.jj_la1[191] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            return this.createCall(p, s.end(this), funcType, quantifier, (Iterable<? extends SqlNode>)args);
        }
        return p;
    }

    public final SqlCall StringAggFunctionCall() throws ParseException {
        Pair<SqlParserPos, SqlOperator> nullTreatment;
        SqlLiteral qualifier;
        SqlAggFunction op;
        Span s;
        ArrayList<SqlNode> args = new ArrayList<SqlNode>();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 20: {
                this.jj_consume_token(20);
                s = this.span();
                op = SqlLibraryOperators.ARRAY_AGG;
                break;
            }
            case 21: {
                this.jj_consume_token(21);
                s = this.span();
                op = SqlLibraryOperators.ARRAY_CONCAT_AGG;
                break;
            }
            case 235: {
                this.jj_consume_token(235);
                s = this.span();
                op = SqlLibraryOperators.GROUP_CONCAT;
                break;
            }
            case 589: {
                this.jj_consume_token(589);
                s = this.span();
                op = SqlLibraryOperators.STRING_AGG;
                break;
            }
            default: {
                this.jj_la1[192] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(715);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 10: 
            case 166: {
                qualifier = this.AllOrDistinct();
                break;
            }
            default: {
                this.jj_la1[193] = this.jj_gen;
                qualifier = null;
            }
        }
        this.AddArg(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        block21: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 727: {
                    break;
                }
                default: {
                    this.jj_la1[194] = this.jj_gen;
                    break block21;
                }
            }
            this.jj_consume_token(727);
            this.checkNonQueryExpression(SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
            this.AddArg(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 245: 
            case 460: {
                nullTreatment = this.NullTreatment();
                break;
            }
            default: {
                this.jj_la1[195] = this.jj_gen;
                nullTreatment = null;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 382: {
                SqlNodeList orderBy = this.OrderBy(true);
                args.add(orderBy);
                break;
            }
            default: {
                this.jj_la1[196] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 506: {
                this.jj_consume_token(506);
                Span s2 = this.span();
                SqlNode separator = this.StringLiteral();
                args.add(SqlInternalOperators.SEPARATOR.createCall(s2.end(this), separator));
                break;
            }
            default: {
                this.jj_la1[197] = this.jj_gen;
            }
        }
        this.jj_consume_token(716);
        SqlCall call = op.createCall(qualifier, s.end(this), args);
        if (nullTreatment != null) {
            call = ((SqlOperator)nullTreatment.right).createCall((SqlParserPos)nullTreatment.left, call);
        }
        return call;
    }

    public final SqlNode AtomicRowExpression() throws ParseException {
        SqlNode e;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 132: 
            case 134: 
            case 202: 
            case 269: 
            case 361: 
            case 612: 
            case 615: 
            case 642: 
            case 654: 
            case 700: 
            case 701: 
            case 702: 
            case 706: 
            case 707: 
            case 708: 
            case 709: 
            case 710: 
            case 712: 
            case 713: 
            case 717: 
            case 718: 
            case 719: 
            case 737: 
            case 738: {
                e = this.LiteralOrIntervalExpression();
                break;
            }
            case 731: {
                e = this.DynamicParam();
                break;
            }
            default: {
                this.jj_la1[198] = this.jj_gen;
                if (this.jj_2_60(2)) {
                    e = this.BuiltinFunctionCall();
                    break;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 720: {
                        e = this.JdbcFunctionCall();
                        break block0;
                    }
                    case 342: {
                        e = this.MultisetConstructor();
                        break block0;
                    }
                    case 19: {
                        e = this.ArrayConstructor();
                        break block0;
                    }
                }
                this.jj_la1[199] = this.jj_gen;
                if (this.jj_2_61(3)) {
                    e = this.MapConstructor();
                    break;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 414: {
                        e = this.PeriodConstructor();
                        break block0;
                    }
                }
                this.jj_la1[200] = this.jj_gen;
                if (this.jj_2_62(Integer.MAX_VALUE)) {
                    e = this.NamedFunctionCall();
                    break;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 116: 
                    case 117: 
                    case 118: 
                    case 119: 
                    case 120: 
                    case 122: 
                    case 123: 
                    case 124: 
                    case 126: 
                    case 308: 
                    case 309: 
                    case 512: 
                    case 604: 
                    case 662: {
                        e = this.ContextVariable();
                        break block0;
                    }
                    case 1: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 14: 
                    case 17: 
                    case 20: 
                    case 21: 
                    case 24: 
                    case 26: 
                    case 27: 
                    case 31: 
                    case 32: 
                    case 35: 
                    case 39: 
                    case 47: 
                    case 49: 
                    case 53: 
                    case 57: 
                    case 58: 
                    case 61: 
                    case 62: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 74: 
                    case 78: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 86: 
                    case 87: 
                    case 88: 
                    case 90: 
                    case 92: 
                    case 93: 
                    case 95: 
                    case 96: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 104: 
                    case 128: 
                    case 130: 
                    case 131: 
                    case 133: 
                    case 135: 
                    case 136: 
                    case 138: 
                    case 141: 
                    case 145: 
                    case 146: 
                    case 147: 
                    case 149: 
                    case 150: 
                    case 151: 
                    case 154: 
                    case 156: 
                    case 157: 
                    case 159: 
                    case 160: 
                    case 162: 
                    case 165: 
                    case 167: 
                    case 168: 
                    case 170: 
                    case 171: 
                    case 174: 
                    case 175: 
                    case 180: 
                    case 185: 
                    case 187: 
                    case 191: 
                    case 192: 
                    case 193: 
                    case 205: 
                    case 206: 
                    case 210: 
                    case 212: 
                    case 214: 
                    case 215: 
                    case 216: 
                    case 224: 
                    case 225: 
                    case 226: 
                    case 227: 
                    case 230: 
                    case 231: 
                    case 233: 
                    case 235: 
                    case 239: 
                    case 241: 
                    case 243: 
                    case 245: 
                    case 246: 
                    case 247: 
                    case 248: 
                    case 249: 
                    case 252: 
                    case 253: 
                    case 254: 
                    case 257: 
                    case 260: 
                    case 263: 
                    case 264: 
                    case 271: 
                    case 273: 
                    case 274: 
                    case 275: 
                    case 276: 
                    case 278: 
                    case 286: 
                    case 287: 
                    case 288: 
                    case 289: 
                    case 290: 
                    case 294: 
                    case 300: 
                    case 301: 
                    case 302: 
                    case 310: 
                    case 312: 
                    case 313: 
                    case 315: 
                    case 320: 
                    case 324: 
                    case 325: 
                    case 326: 
                    case 328: 
                    case 329: 
                    case 330: 
                    case 333: 
                    case 334: 
                    case 340: 
                    case 341: 
                    case 343: 
                    case 344: 
                    case 345: 
                    case 346: 
                    case 351: 
                    case 357: 
                    case 362: 
                    case 364: 
                    case 365: 
                    case 367: 
                    case 370: 
                    case 379: 
                    case 380: 
                    case 383: 
                    case 384: 
                    case 385: 
                    case 388: 
                    case 392: 
                    case 393: 
                    case 395: 
                    case 396: 
                    case 397: 
                    case 398: 
                    case 399: 
                    case 400: 
                    case 401: 
                    case 403: 
                    case 404: 
                    case 405: 
                    case 406: 
                    case 407: 
                    case 416: 
                    case 417: 
                    case 418: 
                    case 419: 
                    case 425: 
                    case 428: 
                    case 431: 
                    case 432: 
                    case 434: 
                    case 435: 
                    case 436: 
                    case 439: 
                    case 455: 
                    case 457: 
                    case 458: 
                    case 460: 
                    case 461: 
                    case 462: 
                    case 465: 
                    case 466: 
                    case 467: 
                    case 468: 
                    case 469: 
                    case 473: 
                    case 474: 
                    case 477: 
                    case 478: 
                    case 479: 
                    case 480: 
                    case 482: 
                    case 488: 
                    case 489: 
                    case 490: 
                    case 491: 
                    case 493: 
                    case 494: 
                    case 495: 
                    case 499: 
                    case 500: 
                    case 501: 
                    case 504: 
                    case 506: 
                    case 507: 
                    case 508: 
                    case 509: 
                    case 510: 
                    case 511: 
                    case 514: 
                    case 518: 
                    case 519: 
                    case 523: 
                    case 524: 
                    case 526: 
                    case 532: 
                    case 533: 
                    case 534: 
                    case 535: 
                    case 536: 
                    case 537: 
                    case 538: 
                    case 539: 
                    case 540: 
                    case 541: 
                    case 542: 
                    case 543: 
                    case 544: 
                    case 545: 
                    case 546: 
                    case 547: 
                    case 548: 
                    case 549: 
                    case 550: 
                    case 551: 
                    case 552: 
                    case 553: 
                    case 554: 
                    case 555: 
                    case 556: 
                    case 557: 
                    case 558: 
                    case 559: 
                    case 560: 
                    case 561: 
                    case 562: 
                    case 563: 
                    case 564: 
                    case 565: 
                    case 566: 
                    case 567: 
                    case 568: 
                    case 569: 
                    case 570: 
                    case 571: 
                    case 572: 
                    case 573: 
                    case 574: 
                    case 575: 
                    case 576: 
                    case 577: 
                    case 578: 
                    case 579: 
                    case 580: 
                    case 583: 
                    case 584: 
                    case 589: 
                    case 590: 
                    case 591: 
                    case 592: 
                    case 595: 
                    case 606: 
                    case 608: 
                    case 611: 
                    case 613: 
                    case 614: 
                    case 616: 
                    case 617: 
                    case 618: 
                    case 619: 
                    case 624: 
                    case 626: 
                    case 627: 
                    case 628: 
                    case 629: 
                    case 630: 
                    case 631: 
                    case 637: 
                    case 638: 
                    case 639: 
                    case 645: 
                    case 646: 
                    case 648: 
                    case 649: 
                    case 650: 
                    case 651: 
                    case 655: 
                    case 656: 
                    case 661: 
                    case 663: 
                    case 664: 
                    case 665: 
                    case 666: 
                    case 668: 
                    case 669: 
                    case 670: 
                    case 679: 
                    case 681: 
                    case 683: 
                    case 684: 
                    case 693: 
                    case 694: 
                    case 695: 
                    case 696: 
                    case 698: 
                    case 699: 
                    case 763: 
                    case 764: 
                    case 765: 
                    case 766: 
                    case 767: 
                    case 768: 
                    case 770: {
                        e = this.CompoundIdentifier();
                        break block0;
                    }
                    case 352: {
                        e = this.NewSpecification();
                        break block0;
                    }
                    case 55: {
                        e = this.CaseExpression();
                        break block0;
                    }
                    case 115: 
                    case 353: {
                        e = this.SequenceExpression();
                        break block0;
                    }
                }
                this.jj_la1[201] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return e;
    }

    public final SqlNode CaseExpression() throws ParseException {
        SqlNode elseClause;
        SqlNode caseIdentifier;
        Span whenSpan = Span.of();
        Span thenSpan = Span.of();
        ArrayList<SqlNodeList> whenList = new ArrayList<SqlNodeList>();
        ArrayList<SqlNodeList> thenList = new ArrayList<SqlNodeList>();
        this.jj_consume_token(55);
        Span s = this.span();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 39: 
            case 47: 
            case 49: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 74: 
            case 77: 
            case 78: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 86: 
            case 87: 
            case 88: 
            case 90: 
            case 92: 
            case 93: 
            case 95: 
            case 96: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 104: 
            case 105: 
            case 108: 
            case 109: 
            case 110: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 122: 
            case 123: 
            case 124: 
            case 126: 
            case 127: 
            case 128: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 138: 
            case 141: 
            case 145: 
            case 146: 
            case 147: 
            case 149: 
            case 150: 
            case 151: 
            case 153: 
            case 154: 
            case 156: 
            case 157: 
            case 159: 
            case 160: 
            case 162: 
            case 165: 
            case 167: 
            case 168: 
            case 170: 
            case 171: 
            case 174: 
            case 175: 
            case 177: 
            case 180: 
            case 185: 
            case 187: 
            case 189: 
            case 191: 
            case 192: 
            case 193: 
            case 196: 
            case 197: 
            case 201: 
            case 202: 
            case 205: 
            case 206: 
            case 207: 
            case 209: 
            case 210: 
            case 212: 
            case 214: 
            case 215: 
            case 216: 
            case 223: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 230: 
            case 231: 
            case 233: 
            case 235: 
            case 236: 
            case 239: 
            case 241: 
            case 242: 
            case 243: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 252: 
            case 253: 
            case 254: 
            case 257: 
            case 260: 
            case 263: 
            case 264: 
            case 268: 
            case 269: 
            case 271: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 278: 
            case 279: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 284: 
            case 285: 
            case 286: 
            case 287: 
            case 288: 
            case 289: 
            case 290: 
            case 291: 
            case 294: 
            case 295: 
            case 297: 
            case 299: 
            case 300: 
            case 301: 
            case 302: 
            case 306: 
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 313: 
            case 315: 
            case 317: 
            case 319: 
            case 320: 
            case 324: 
            case 325: 
            case 326: 
            case 328: 
            case 329: 
            case 330: 
            case 331: 
            case 332: 
            case 333: 
            case 334: 
            case 335: 
            case 339: 
            case 340: 
            case 341: 
            case 342: 
            case 343: 
            case 344: 
            case 345: 
            case 346: 
            case 351: 
            case 352: 
            case 353: 
            case 357: 
            case 358: 
            case 359: 
            case 360: 
            case 361: 
            case 362: 
            case 363: 
            case 364: 
            case 365: 
            case 367: 
            case 369: 
            case 370: 
            case 379: 
            case 380: 
            case 383: 
            case 384: 
            case 385: 
            case 388: 
            case 391: 
            case 392: 
            case 393: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 399: 
            case 400: 
            case 401: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 411: 
            case 412: 
            case 413: 
            case 414: 
            case 416: 
            case 417: 
            case 418: 
            case 419: 
            case 421: 
            case 423: 
            case 425: 
            case 428: 
            case 429: 
            case 431: 
            case 432: 
            case 434: 
            case 435: 
            case 436: 
            case 438: 
            case 439: 
            case 448: 
            case 452: 
            case 454: 
            case 455: 
            case 457: 
            case 458: 
            case 460: 
            case 461: 
            case 462: 
            case 465: 
            case 466: 
            case 467: 
            case 468: 
            case 469: 
            case 472: 
            case 473: 
            case 474: 
            case 477: 
            case 478: 
            case 479: 
            case 480: 
            case 481: 
            case 482: 
            case 483: 
            case 485: 
            case 488: 
            case 489: 
            case 490: 
            case 491: 
            case 493: 
            case 494: 
            case 495: 
            case 498: 
            case 499: 
            case 500: 
            case 501: 
            case 504: 
            case 506: 
            case 507: 
            case 508: 
            case 509: 
            case 510: 
            case 511: 
            case 512: 
            case 514: 
            case 518: 
            case 519: 
            case 522: 
            case 523: 
            case 524: 
            case 525: 
            case 526: 
            case 532: 
            case 533: 
            case 534: 
            case 535: 
            case 536: 
            case 537: 
            case 538: 
            case 539: 
            case 540: 
            case 541: 
            case 542: 
            case 543: 
            case 544: 
            case 545: 
            case 546: 
            case 547: 
            case 548: 
            case 549: 
            case 550: 
            case 551: 
            case 552: 
            case 553: 
            case 554: 
            case 555: 
            case 556: 
            case 557: 
            case 558: 
            case 559: 
            case 560: 
            case 561: 
            case 562: 
            case 563: 
            case 564: 
            case 565: 
            case 566: 
            case 567: 
            case 568: 
            case 569: 
            case 570: 
            case 571: 
            case 572: 
            case 573: 
            case 574: 
            case 575: 
            case 576: 
            case 577: 
            case 578: 
            case 579: 
            case 580: 
            case 581: 
            case 583: 
            case 584: 
            case 586: 
            case 587: 
            case 589: 
            case 590: 
            case 591: 
            case 592: 
            case 595: 
            case 596: 
            case 599: 
            case 604: 
            case 606: 
            case 608: 
            case 611: 
            case 612: 
            case 613: 
            case 614: 
            case 615: 
            case 616: 
            case 617: 
            case 618: 
            case 619: 
            case 624: 
            case 626: 
            case 627: 
            case 628: 
            case 629: 
            case 630: 
            case 631: 
            case 632: 
            case 637: 
            case 638: 
            case 639: 
            case 640: 
            case 642: 
            case 643: 
            case 645: 
            case 646: 
            case 648: 
            case 649: 
            case 650: 
            case 651: 
            case 653: 
            case 654: 
            case 655: 
            case 656: 
            case 659: 
            case 661: 
            case 662: 
            case 663: 
            case 664: 
            case 665: 
            case 666: 
            case 668: 
            case 669: 
            case 670: 
            case 674: 
            case 675: 
            case 679: 
            case 681: 
            case 683: 
            case 684: 
            case 693: 
            case 694: 
            case 695: 
            case 696: 
            case 697: 
            case 698: 
            case 699: 
            case 700: 
            case 701: 
            case 702: 
            case 706: 
            case 707: 
            case 708: 
            case 709: 
            case 710: 
            case 712: 
            case 713: 
            case 715: 
            case 717: 
            case 718: 
            case 719: 
            case 720: 
            case 731: 
            case 737: 
            case 738: 
            case 763: 
            case 764: 
            case 765: 
            case 766: 
            case 767: 
            case 768: 
            case 770: {
                caseIdentifier = this.Expression(SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                break;
            }
            default: {
                this.jj_la1[202] = this.jj_gen;
                caseIdentifier = null;
            }
        }
        block9: while (true) {
            this.jj_consume_token(685);
            whenSpan.add(this);
            SqlNode e = this.ExpressionCommaList(s, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
            if (e.size() == 1) {
                e = e.get(0);
            }
            whenList.add((SqlNodeList)e);
            this.jj_consume_token(609);
            thenSpan.add(this);
            e = this.Expression(SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
            thenList.add((SqlNodeList)e);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 685: {
                    continue block9;
                }
            }
            break;
        }
        this.jj_la1[203] = this.jj_gen;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 178: {
                this.jj_consume_token(178);
                elseClause = this.Expression(SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                break;
            }
            default: {
                this.jj_la1[204] = this.jj_gen;
                elseClause = null;
            }
        }
        this.jj_consume_token(181);
        return SqlCase.createSwitched(s.end(this), caseIdentifier, new SqlNodeList(whenList, whenSpan.addAll(whenList).pos()), new SqlNodeList(thenList, thenSpan.addAll(thenList).pos()), elseClause);
    }

    public final SqlCall SequenceExpression() throws ParseException {
        Span s;
        SqlOperator f;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 353: {
                this.jj_consume_token(353);
                f = SqlStdOperatorTable.NEXT_VALUE;
                s = this.span();
                break;
            }
            default: {
                this.jj_la1[205] = this.jj_gen;
                if (this.jj_2_63(3)) {
                    this.jj_consume_token(115);
                    f = SqlStdOperatorTable.CURRENT_VALUE;
                    s = this.span();
                    break;
                }
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(671);
        this.jj_consume_token(211);
        SqlIdentifier sequenceRef = this.CompoundIdentifier();
        return f.createCall(s.end(sequenceRef), sequenceRef);
    }

    public final SqlSetOption SqlSetOption(Span s, String scope) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 513: {
                SqlNode val;
                this.jj_consume_token(513);
                s.add(this);
                SqlIdentifier name = this.CompoundIdentifier();
                this.jj_consume_token(728);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 132: 
                    case 134: 
                    case 202: 
                    case 269: 
                    case 361: 
                    case 612: 
                    case 615: 
                    case 642: 
                    case 654: 
                    case 700: 
                    case 701: 
                    case 702: 
                    case 706: 
                    case 707: 
                    case 708: 
                    case 709: 
                    case 710: 
                    case 712: 
                    case 713: 
                    case 717: 
                    case 718: 
                    case 719: 
                    case 737: 
                    case 738: {
                        val = this.Literal();
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 14: 
                    case 17: 
                    case 20: 
                    case 21: 
                    case 24: 
                    case 26: 
                    case 27: 
                    case 31: 
                    case 32: 
                    case 35: 
                    case 39: 
                    case 47: 
                    case 49: 
                    case 53: 
                    case 57: 
                    case 58: 
                    case 61: 
                    case 62: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 74: 
                    case 78: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 86: 
                    case 87: 
                    case 88: 
                    case 90: 
                    case 92: 
                    case 93: 
                    case 95: 
                    case 96: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 104: 
                    case 128: 
                    case 130: 
                    case 131: 
                    case 133: 
                    case 135: 
                    case 136: 
                    case 138: 
                    case 141: 
                    case 145: 
                    case 146: 
                    case 147: 
                    case 149: 
                    case 150: 
                    case 151: 
                    case 154: 
                    case 156: 
                    case 157: 
                    case 159: 
                    case 160: 
                    case 162: 
                    case 165: 
                    case 167: 
                    case 168: 
                    case 170: 
                    case 171: 
                    case 174: 
                    case 175: 
                    case 180: 
                    case 185: 
                    case 187: 
                    case 191: 
                    case 192: 
                    case 193: 
                    case 205: 
                    case 206: 
                    case 210: 
                    case 212: 
                    case 214: 
                    case 215: 
                    case 216: 
                    case 224: 
                    case 225: 
                    case 226: 
                    case 227: 
                    case 230: 
                    case 231: 
                    case 233: 
                    case 235: 
                    case 239: 
                    case 241: 
                    case 243: 
                    case 245: 
                    case 246: 
                    case 247: 
                    case 248: 
                    case 249: 
                    case 252: 
                    case 253: 
                    case 254: 
                    case 257: 
                    case 260: 
                    case 263: 
                    case 264: 
                    case 271: 
                    case 273: 
                    case 274: 
                    case 275: 
                    case 276: 
                    case 278: 
                    case 286: 
                    case 287: 
                    case 288: 
                    case 289: 
                    case 290: 
                    case 294: 
                    case 300: 
                    case 301: 
                    case 302: 
                    case 310: 
                    case 312: 
                    case 313: 
                    case 315: 
                    case 320: 
                    case 324: 
                    case 325: 
                    case 326: 
                    case 328: 
                    case 329: 
                    case 330: 
                    case 333: 
                    case 334: 
                    case 340: 
                    case 341: 
                    case 343: 
                    case 344: 
                    case 345: 
                    case 346: 
                    case 351: 
                    case 357: 
                    case 362: 
                    case 364: 
                    case 365: 
                    case 367: 
                    case 370: 
                    case 379: 
                    case 380: 
                    case 383: 
                    case 384: 
                    case 385: 
                    case 388: 
                    case 392: 
                    case 393: 
                    case 395: 
                    case 396: 
                    case 397: 
                    case 398: 
                    case 399: 
                    case 400: 
                    case 401: 
                    case 403: 
                    case 404: 
                    case 405: 
                    case 406: 
                    case 407: 
                    case 416: 
                    case 417: 
                    case 418: 
                    case 419: 
                    case 425: 
                    case 428: 
                    case 431: 
                    case 432: 
                    case 434: 
                    case 435: 
                    case 436: 
                    case 439: 
                    case 455: 
                    case 457: 
                    case 458: 
                    case 460: 
                    case 461: 
                    case 462: 
                    case 465: 
                    case 466: 
                    case 467: 
                    case 468: 
                    case 469: 
                    case 473: 
                    case 474: 
                    case 477: 
                    case 478: 
                    case 479: 
                    case 480: 
                    case 482: 
                    case 488: 
                    case 489: 
                    case 490: 
                    case 491: 
                    case 493: 
                    case 494: 
                    case 495: 
                    case 499: 
                    case 500: 
                    case 501: 
                    case 504: 
                    case 506: 
                    case 507: 
                    case 508: 
                    case 509: 
                    case 510: 
                    case 511: 
                    case 514: 
                    case 518: 
                    case 519: 
                    case 523: 
                    case 524: 
                    case 526: 
                    case 532: 
                    case 533: 
                    case 534: 
                    case 535: 
                    case 536: 
                    case 537: 
                    case 538: 
                    case 539: 
                    case 540: 
                    case 541: 
                    case 542: 
                    case 543: 
                    case 544: 
                    case 545: 
                    case 546: 
                    case 547: 
                    case 548: 
                    case 549: 
                    case 550: 
                    case 551: 
                    case 552: 
                    case 553: 
                    case 554: 
                    case 555: 
                    case 556: 
                    case 557: 
                    case 558: 
                    case 559: 
                    case 560: 
                    case 561: 
                    case 562: 
                    case 563: 
                    case 564: 
                    case 565: 
                    case 566: 
                    case 567: 
                    case 568: 
                    case 569: 
                    case 570: 
                    case 571: 
                    case 572: 
                    case 573: 
                    case 574: 
                    case 575: 
                    case 576: 
                    case 577: 
                    case 578: 
                    case 579: 
                    case 580: 
                    case 583: 
                    case 584: 
                    case 589: 
                    case 590: 
                    case 591: 
                    case 592: 
                    case 595: 
                    case 606: 
                    case 608: 
                    case 611: 
                    case 613: 
                    case 614: 
                    case 616: 
                    case 617: 
                    case 618: 
                    case 619: 
                    case 624: 
                    case 626: 
                    case 627: 
                    case 628: 
                    case 629: 
                    case 630: 
                    case 631: 
                    case 637: 
                    case 638: 
                    case 639: 
                    case 645: 
                    case 646: 
                    case 648: 
                    case 649: 
                    case 650: 
                    case 651: 
                    case 655: 
                    case 656: 
                    case 661: 
                    case 663: 
                    case 664: 
                    case 665: 
                    case 666: 
                    case 668: 
                    case 669: 
                    case 670: 
                    case 679: 
                    case 681: 
                    case 683: 
                    case 684: 
                    case 693: 
                    case 694: 
                    case 695: 
                    case 696: 
                    case 698: 
                    case 699: 
                    case 763: 
                    case 764: 
                    case 765: 
                    case 766: 
                    case 767: 
                    case 768: 
                    case 770: {
                        val = this.SimpleIdentifier();
                        break;
                    }
                    case 375: {
                        this.jj_consume_token(375);
                        val = new SqlIdentifier(this.token.image.toUpperCase(Locale.ROOT), this.getPos());
                        break;
                    }
                    default: {
                        this.jj_la1[206] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return new SqlSetOption(s.end(val), scope, name, val);
            }
            case 459: {
                SqlIdentifier name;
                this.jj_consume_token(459);
                s.add(this);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 14: 
                    case 17: 
                    case 20: 
                    case 21: 
                    case 24: 
                    case 26: 
                    case 27: 
                    case 31: 
                    case 32: 
                    case 35: 
                    case 39: 
                    case 47: 
                    case 49: 
                    case 53: 
                    case 57: 
                    case 58: 
                    case 61: 
                    case 62: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 74: 
                    case 78: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 86: 
                    case 87: 
                    case 88: 
                    case 90: 
                    case 92: 
                    case 93: 
                    case 95: 
                    case 96: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 104: 
                    case 128: 
                    case 130: 
                    case 131: 
                    case 133: 
                    case 135: 
                    case 136: 
                    case 138: 
                    case 141: 
                    case 145: 
                    case 146: 
                    case 147: 
                    case 149: 
                    case 150: 
                    case 151: 
                    case 154: 
                    case 156: 
                    case 157: 
                    case 159: 
                    case 160: 
                    case 162: 
                    case 165: 
                    case 167: 
                    case 168: 
                    case 170: 
                    case 171: 
                    case 174: 
                    case 175: 
                    case 180: 
                    case 185: 
                    case 187: 
                    case 191: 
                    case 192: 
                    case 193: 
                    case 205: 
                    case 206: 
                    case 210: 
                    case 212: 
                    case 214: 
                    case 215: 
                    case 216: 
                    case 224: 
                    case 225: 
                    case 226: 
                    case 227: 
                    case 230: 
                    case 231: 
                    case 233: 
                    case 235: 
                    case 239: 
                    case 241: 
                    case 243: 
                    case 245: 
                    case 246: 
                    case 247: 
                    case 248: 
                    case 249: 
                    case 252: 
                    case 253: 
                    case 254: 
                    case 257: 
                    case 260: 
                    case 263: 
                    case 264: 
                    case 271: 
                    case 273: 
                    case 274: 
                    case 275: 
                    case 276: 
                    case 278: 
                    case 286: 
                    case 287: 
                    case 288: 
                    case 289: 
                    case 290: 
                    case 294: 
                    case 300: 
                    case 301: 
                    case 302: 
                    case 310: 
                    case 312: 
                    case 313: 
                    case 315: 
                    case 320: 
                    case 324: 
                    case 325: 
                    case 326: 
                    case 328: 
                    case 329: 
                    case 330: 
                    case 333: 
                    case 334: 
                    case 340: 
                    case 341: 
                    case 343: 
                    case 344: 
                    case 345: 
                    case 346: 
                    case 351: 
                    case 357: 
                    case 362: 
                    case 364: 
                    case 365: 
                    case 367: 
                    case 370: 
                    case 379: 
                    case 380: 
                    case 383: 
                    case 384: 
                    case 385: 
                    case 388: 
                    case 392: 
                    case 393: 
                    case 395: 
                    case 396: 
                    case 397: 
                    case 398: 
                    case 399: 
                    case 400: 
                    case 401: 
                    case 403: 
                    case 404: 
                    case 405: 
                    case 406: 
                    case 407: 
                    case 416: 
                    case 417: 
                    case 418: 
                    case 419: 
                    case 425: 
                    case 428: 
                    case 431: 
                    case 432: 
                    case 434: 
                    case 435: 
                    case 436: 
                    case 439: 
                    case 455: 
                    case 457: 
                    case 458: 
                    case 460: 
                    case 461: 
                    case 462: 
                    case 465: 
                    case 466: 
                    case 467: 
                    case 468: 
                    case 469: 
                    case 473: 
                    case 474: 
                    case 477: 
                    case 478: 
                    case 479: 
                    case 480: 
                    case 482: 
                    case 488: 
                    case 489: 
                    case 490: 
                    case 491: 
                    case 493: 
                    case 494: 
                    case 495: 
                    case 499: 
                    case 500: 
                    case 501: 
                    case 504: 
                    case 506: 
                    case 507: 
                    case 508: 
                    case 509: 
                    case 510: 
                    case 511: 
                    case 514: 
                    case 518: 
                    case 519: 
                    case 523: 
                    case 524: 
                    case 526: 
                    case 532: 
                    case 533: 
                    case 534: 
                    case 535: 
                    case 536: 
                    case 537: 
                    case 538: 
                    case 539: 
                    case 540: 
                    case 541: 
                    case 542: 
                    case 543: 
                    case 544: 
                    case 545: 
                    case 546: 
                    case 547: 
                    case 548: 
                    case 549: 
                    case 550: 
                    case 551: 
                    case 552: 
                    case 553: 
                    case 554: 
                    case 555: 
                    case 556: 
                    case 557: 
                    case 558: 
                    case 559: 
                    case 560: 
                    case 561: 
                    case 562: 
                    case 563: 
                    case 564: 
                    case 565: 
                    case 566: 
                    case 567: 
                    case 568: 
                    case 569: 
                    case 570: 
                    case 571: 
                    case 572: 
                    case 573: 
                    case 574: 
                    case 575: 
                    case 576: 
                    case 577: 
                    case 578: 
                    case 579: 
                    case 580: 
                    case 583: 
                    case 584: 
                    case 589: 
                    case 590: 
                    case 591: 
                    case 592: 
                    case 595: 
                    case 606: 
                    case 608: 
                    case 611: 
                    case 613: 
                    case 614: 
                    case 616: 
                    case 617: 
                    case 618: 
                    case 619: 
                    case 624: 
                    case 626: 
                    case 627: 
                    case 628: 
                    case 629: 
                    case 630: 
                    case 631: 
                    case 637: 
                    case 638: 
                    case 639: 
                    case 645: 
                    case 646: 
                    case 648: 
                    case 649: 
                    case 650: 
                    case 651: 
                    case 655: 
                    case 656: 
                    case 661: 
                    case 663: 
                    case 664: 
                    case 665: 
                    case 666: 
                    case 668: 
                    case 669: 
                    case 670: 
                    case 679: 
                    case 681: 
                    case 683: 
                    case 684: 
                    case 693: 
                    case 694: 
                    case 695: 
                    case 696: 
                    case 698: 
                    case 699: 
                    case 763: 
                    case 764: 
                    case 765: 
                    case 766: 
                    case 767: 
                    case 768: 
                    case 770: {
                        name = this.CompoundIdentifier();
                        break;
                    }
                    case 10: {
                        this.jj_consume_token(10);
                        name = new SqlIdentifier(this.token.image.toUpperCase(Locale.ROOT), this.getPos());
                        break;
                    }
                    default: {
                        this.jj_la1[207] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return new SqlSetOption(s.end(name), scope, name, null);
            }
        }
        this.jj_la1[208] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SqlAlter SqlAlter() throws ParseException {
        this.jj_consume_token(13);
        Span s = this.span();
        String scope = this.Scope();
        SqlSetOption alterNode = this.SqlSetOption(s, scope);
        return alterNode;
    }

    public final String Scope() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 602: {
                this.jj_consume_token(602);
                break;
            }
            case 511: {
                this.jj_consume_token(511);
                break;
            }
            default: {
                this.jj_la1[209] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return this.token.image.toUpperCase(Locale.ROOT);
    }

    public final SqlNode Literal() throws ParseException {
        SqlNode e;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 132: 
            case 134: 
            case 202: 
            case 361: 
            case 612: 
            case 615: 
            case 642: 
            case 654: 
            case 700: 
            case 701: 
            case 702: 
            case 706: 
            case 707: 
            case 708: 
            case 709: 
            case 710: 
            case 712: 
            case 713: 
            case 717: 
            case 718: 
            case 719: 
            case 737: 
            case 738: {
                e = this.NonIntervalLiteral();
                break;
            }
            case 269: {
                e = this.IntervalLiteral();
                break;
            }
            default: {
                this.jj_la1[210] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return e;
    }

    public final SqlNode NonIntervalLiteral() throws ParseException {
        SqlNode e;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 700: 
            case 701: 
            case 702: 
            case 737: 
            case 738: {
                e = this.NumericLiteral();
                break;
            }
            case 706: 
            case 707: 
            case 708: 
            case 709: 
            case 710: 
            case 712: 
            case 713: {
                e = this.StringLiteral();
                break;
            }
            case 202: 
            case 361: 
            case 642: 
            case 654: {
                e = this.SpecialLiteral();
                break;
            }
            case 132: 
            case 134: 
            case 612: 
            case 615: 
            case 717: 
            case 718: 
            case 719: {
                e = this.DateTimeLiteral();
                break;
            }
            default: {
                this.jj_la1[211] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return e;
    }

    public final SqlNode LiteralOrIntervalExpression() throws ParseException {
        SqlNode e;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 269: {
                e = this.IntervalLiteralOrExpression();
                break;
            }
            case 132: 
            case 134: 
            case 202: 
            case 361: 
            case 612: 
            case 615: 
            case 642: 
            case 654: 
            case 700: 
            case 701: 
            case 702: 
            case 706: 
            case 707: 
            case 708: 
            case 709: 
            case 710: 
            case 712: 
            case 713: 
            case 717: 
            case 718: 
            case 719: 
            case 737: 
            case 738: {
                e = this.NonIntervalLiteral();
                break;
            }
            default: {
                this.jj_la1[212] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return e;
    }

    public final SqlNumericLiteral UnsignedNumericLiteral() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 700: {
                this.jj_consume_token(700);
                return SqlLiteral.createExactNumeric(this.token.image, this.getPos());
            }
            case 702: {
                this.jj_consume_token(702);
                return SqlLiteral.createExactNumeric(this.token.image, this.getPos());
            }
            case 701: {
                this.jj_consume_token(701);
                return SqlLiteral.createApproxNumeric(this.token.image, this.getPos());
            }
        }
        this.jj_la1[213] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SqlLiteral NumericLiteral() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 737: {
                this.jj_consume_token(737);
                SqlNumericLiteral num = this.UnsignedNumericLiteral();
                return num;
            }
            case 738: {
                this.jj_consume_token(738);
                Span s = this.span();
                SqlNumericLiteral num = this.UnsignedNumericLiteral();
                return SqlLiteral.createNegative(num, s.end(this));
            }
            case 700: 
            case 701: 
            case 702: {
                SqlNumericLiteral num = this.UnsignedNumericLiteral();
                return num;
            }
        }
        this.jj_la1[214] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SqlLiteral SpecialLiteral() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 642: {
                this.jj_consume_token(642);
                return SqlLiteral.createBoolean(true, this.getPos());
            }
            case 202: {
                this.jj_consume_token(202);
                return SqlLiteral.createBoolean(false, this.getPos());
            }
            case 654: {
                this.jj_consume_token(654);
                return SqlLiteral.createUnknown(this.getPos());
            }
            case 361: {
                this.jj_consume_token(361);
                return SqlLiteral.createNull(this.getPos());
            }
        }
        this.jj_la1[215] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SqlNode StringLiteral() throws ParseException {
        char unicodeEscapeChar = '\u0000';
        String charSet = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 706: {
                String p;
                this.jj_consume_token(706);
                ArrayList<SqlBinaryStringLiteral> frags = new ArrayList<SqlBinaryStringLiteral>();
                try {
                    p = SqlParserUtil.trim(this.token.image, "xX'");
                    frags.add(SqlLiteral.createBinaryString(p, this.getPos()));
                }
                catch (NumberFormatException ex) {
                    throw SqlUtil.newContextException(this.getPos(), Static.RESOURCE.illegalBinaryString(this.token.image));
                }
                block35: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 707: {
                            break;
                        }
                        default: {
                            this.jj_la1[216] = this.jj_gen;
                            break block35;
                        }
                    }
                    this.jj_consume_token(707);
                    try {
                        p = SqlParserUtil.trim(this.token.image, "'");
                        frags.add(SqlLiteral.createBinaryString(p, this.getPos()));
                    }
                    catch (NumberFormatException ex) {
                        throw SqlUtil.newContextException(this.getPos(), Static.RESOURCE.illegalBinaryString(this.token.image));
                    }
                }
                assert (!frags.isEmpty());
                if (frags.size() == 1) {
                    return (SqlNode)frags.get(0);
                }
                SqlParserPos pos2 = SqlParserPos.sum(frags);
                return SqlStdOperatorTable.LITERAL_CHAIN.createCall(pos2, frags);
            }
            case 707: 
            case 708: 
            case 709: {
                SqlCharStringLiteral literal;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 708: {
                        this.jj_consume_token(708);
                        charSet = SqlParserUtil.getCharacterSet(this.token.image);
                        break;
                    }
                    case 707: {
                        this.jj_consume_token(707);
                        break;
                    }
                    case 709: {
                        this.jj_consume_token(709);
                        unicodeEscapeChar = '\\';
                        charSet = "UTF16";
                        break;
                    }
                    default: {
                        this.jj_la1[217] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                ArrayList<SqlCharStringLiteral> frags = new ArrayList<SqlCharStringLiteral>();
                String p = SqlParserUtil.parseString(this.token.image);
                try {
                    literal = SqlLiteral.createCharString(p, charSet, this.getPos());
                    frags.add(literal);
                }
                catch (UnsupportedCharsetException e) {
                    throw SqlUtil.newContextException(this.getPos(), Static.RESOURCE.unknownCharacterSet(charSet));
                }
                block36: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 707: {
                            break;
                        }
                        default: {
                            this.jj_la1[218] = this.jj_gen;
                            break block36;
                        }
                    }
                    this.jj_consume_token(707);
                    p = SqlParserUtil.parseString(this.token.image);
                    try {
                        literal = SqlLiteral.createCharString(p, charSet, this.getPos());
                        frags.add(literal);
                    }
                    catch (UnsupportedCharsetException e) {
                        throw SqlUtil.newContextException(this.getPos(), Static.RESOURCE.unknownCharacterSet(charSet));
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 647: {
                        this.jj_consume_token(647);
                        this.jj_consume_token(707);
                        if (unicodeEscapeChar == '\u0000') {
                            throw SqlUtil.newContextException(this.getPos(), Static.RESOURCE.unicodeEscapeUnexpected());
                        }
                        String s = SqlParserUtil.parseString(this.token.image);
                        unicodeEscapeChar = SqlParserUtil.checkUnicodeEscapeChar(s);
                        break;
                    }
                    default: {
                        this.jj_la1[219] = this.jj_gen;
                    }
                }
                assert (!frags.isEmpty());
                if (frags.size() == 1) {
                    SqlLiteral lit = (SqlLiteral)frags.get(0);
                    return lit.unescapeUnicode(unicodeEscapeChar);
                }
                SqlNode[] rands = frags.toArray(new SqlNode[0]);
                for (int i = 0; i < rands.length; ++i) {
                    rands[i] = ((SqlLiteral)rands[i]).unescapeUnicode(unicodeEscapeChar);
                }
                SqlParserPos pos2 = SqlParserPos.sum(rands);
                return SqlStdOperatorTable.LITERAL_CHAIN.createCall(pos2, rands);
            }
            case 710: {
                String p;
                this.jj_consume_token(710);
                try {
                    p = SqlParserUtil.parseCString(this.getToken((int)0).image);
                }
                catch (SqlParserUtil.MalformedUnicodeEscape e) {
                    throw SqlUtil.newContextException(this.getPos(), Static.RESOURCE.unicodeEscapeMalformed(e.i));
                }
                return SqlLiteral.createCharString(p, "UTF16", this.getPos());
            }
            case 712: {
                this.jj_consume_token(712);
                String p = SqlParserUtil.stripQuotes(this.getToken((int)0).image, DQ, DQ, "\\\"", Casing.UNCHANGED);
                try {
                    return SqlLiteral.createCharString(p, charSet, this.getPos());
                }
                catch (UnsupportedCharsetException e) {
                    throw SqlUtil.newContextException(this.getPos(), Static.RESOURCE.unknownCharacterSet(charSet));
                }
            }
            case 713: {
                this.jj_consume_token(713);
                String p = SqlParserUtil.stripQuotes(this.getToken((int)0).image, "'", "'", "\\'", Casing.UNCHANGED);
                try {
                    return SqlLiteral.createCharString(p, charSet, this.getPos());
                }
                catch (UnsupportedCharsetException e) {
                    throw SqlUtil.newContextException(this.getPos(), Static.RESOURCE.unknownCharacterSet(charSet));
                }
            }
        }
        this.jj_la1[220] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String SimpleStringLiteral() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 707: {
                this.jj_consume_token(707);
                return SqlParserUtil.parseString(this.token.image);
            }
            case 713: {
                this.jj_consume_token(713);
                return SqlParserUtil.stripQuotes(this.token.image, "'", "'", "\\'", Casing.UNCHANGED);
            }
            case 712: {
                this.jj_consume_token(712);
                return SqlParserUtil.stripQuotes(this.token.image, DQ, DQ, "\\\"", Casing.UNCHANGED);
            }
        }
        this.jj_la1[221] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SqlLiteral DateTimeLiteral() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 717: {
                this.jj_consume_token(717);
                this.jj_consume_token(707);
                String p = SqlParserUtil.parseString(this.token.image);
                this.jj_consume_token(722);
                return SqlParserUtil.parseDateLiteral(p, this.getPos());
            }
            case 718: {
                this.jj_consume_token(718);
                this.jj_consume_token(707);
                String p = SqlParserUtil.parseString(this.token.image);
                this.jj_consume_token(722);
                return SqlParserUtil.parseTimeLiteral(p, this.getPos());
            }
            case 719: {
                this.jj_consume_token(719);
                Span s = this.span();
                this.jj_consume_token(707);
                String p = SqlParserUtil.parseString(this.token.image);
                this.jj_consume_token(722);
                return SqlParserUtil.parseTimestampLiteral(p, s.end(this));
            }
            case 132: {
                this.jj_consume_token(132);
                Span s = this.span();
                String p = this.SimpleStringLiteral();
                return SqlLiteral.createUnknown("DATE", p, s.end(this));
            }
            case 134: {
                this.jj_consume_token(134);
                Span s = this.span();
                String p = this.SimpleStringLiteral();
                return SqlLiteral.createUnknown("DATETIME", p, s.end(this));
            }
            case 612: {
                this.jj_consume_token(612);
                Span s = this.span();
                String p = this.SimpleStringLiteral();
                return SqlLiteral.createUnknown("TIME", p, s.end(this));
            }
        }
        this.jj_la1[222] = this.jj_gen;
        if (this.jj_2_64(2)) {
            this.jj_consume_token(615);
            Span s = this.span();
            String p = this.SimpleStringLiteral();
            return SqlLiteral.createUnknown("TIMESTAMP", p, s.end(this));
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 615: {
                this.jj_consume_token(615);
                Span s = this.span();
                this.jj_consume_token(690);
                this.jj_consume_token(307);
                this.jj_consume_token(612);
                this.jj_consume_token(699);
                String p = this.SimpleStringLiteral();
                return SqlLiteral.createUnknown("TIMESTAMP WITH LOCAL TIME ZONE", p, s.end(this));
            }
        }
        this.jj_la1[223] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SqlNode MultisetConstructor() throws ParseException {
        ArrayList<SqlNode> args = new ArrayList<SqlNode>();
        this.jj_consume_token(342);
        Span s = this.span();
        if (this.jj_2_65(2)) {
            this.jj_consume_token(715);
            SqlNode e = this.LeafQueryOrExpr(SqlAbstractParserImpl.ExprContext.ACCEPT_QUERY);
            this.jj_consume_token(716);
            return SqlStdOperatorTable.MULTISET_QUERY.createCall(s.end(this), e);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 723: {
                this.jj_consume_token(723);
                this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_NON_QUERY);
                block6: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 727: {
                            break;
                        }
                        default: {
                            this.jj_la1[224] = this.jj_gen;
                            break block6;
                        }
                    }
                    this.jj_consume_token(727);
                    this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_NON_QUERY);
                }
                this.jj_consume_token(724);
                return SqlStdOperatorTable.MULTISET_VALUE.createCall(s.end(this), args);
            }
        }
        this.jj_la1[225] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SqlNode ArrayConstructor() throws ParseException {
        this.jj_consume_token(19);
        Span s = this.span();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 715: {
                this.jj_consume_token(715);
                SqlNode e = this.OrderedQueryOrExpr(SqlAbstractParserImpl.ExprContext.ACCEPT_QUERY);
                this.jj_consume_token(716);
                return SqlStdOperatorTable.ARRAY_QUERY.createCall(s.end(this), e);
            }
            case 723: {
                SqlNodeList args;
                this.jj_consume_token(723);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 14: 
                    case 17: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 24: 
                    case 26: 
                    case 27: 
                    case 31: 
                    case 32: 
                    case 34: 
                    case 35: 
                    case 39: 
                    case 47: 
                    case 49: 
                    case 52: 
                    case 53: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 73: 
                    case 74: 
                    case 77: 
                    case 78: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 86: 
                    case 87: 
                    case 88: 
                    case 90: 
                    case 92: 
                    case 93: 
                    case 95: 
                    case 96: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 104: 
                    case 105: 
                    case 108: 
                    case 109: 
                    case 110: 
                    case 114: 
                    case 115: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 119: 
                    case 120: 
                    case 122: 
                    case 123: 
                    case 124: 
                    case 126: 
                    case 127: 
                    case 128: 
                    case 130: 
                    case 131: 
                    case 132: 
                    case 133: 
                    case 134: 
                    case 135: 
                    case 136: 
                    case 138: 
                    case 141: 
                    case 145: 
                    case 146: 
                    case 147: 
                    case 149: 
                    case 150: 
                    case 151: 
                    case 153: 
                    case 154: 
                    case 156: 
                    case 157: 
                    case 159: 
                    case 160: 
                    case 162: 
                    case 165: 
                    case 167: 
                    case 168: 
                    case 170: 
                    case 171: 
                    case 174: 
                    case 175: 
                    case 177: 
                    case 180: 
                    case 185: 
                    case 187: 
                    case 189: 
                    case 191: 
                    case 192: 
                    case 193: 
                    case 196: 
                    case 197: 
                    case 201: 
                    case 202: 
                    case 205: 
                    case 206: 
                    case 207: 
                    case 209: 
                    case 210: 
                    case 212: 
                    case 214: 
                    case 215: 
                    case 216: 
                    case 223: 
                    case 224: 
                    case 225: 
                    case 226: 
                    case 227: 
                    case 230: 
                    case 231: 
                    case 233: 
                    case 235: 
                    case 236: 
                    case 239: 
                    case 241: 
                    case 242: 
                    case 243: 
                    case 245: 
                    case 246: 
                    case 247: 
                    case 248: 
                    case 249: 
                    case 252: 
                    case 253: 
                    case 254: 
                    case 257: 
                    case 260: 
                    case 263: 
                    case 264: 
                    case 268: 
                    case 269: 
                    case 271: 
                    case 273: 
                    case 274: 
                    case 275: 
                    case 276: 
                    case 278: 
                    case 279: 
                    case 280: 
                    case 281: 
                    case 282: 
                    case 283: 
                    case 284: 
                    case 285: 
                    case 286: 
                    case 287: 
                    case 288: 
                    case 289: 
                    case 290: 
                    case 291: 
                    case 294: 
                    case 295: 
                    case 297: 
                    case 299: 
                    case 300: 
                    case 301: 
                    case 302: 
                    case 306: 
                    case 308: 
                    case 309: 
                    case 310: 
                    case 311: 
                    case 312: 
                    case 313: 
                    case 315: 
                    case 317: 
                    case 319: 
                    case 320: 
                    case 324: 
                    case 325: 
                    case 326: 
                    case 328: 
                    case 329: 
                    case 330: 
                    case 331: 
                    case 332: 
                    case 333: 
                    case 334: 
                    case 335: 
                    case 339: 
                    case 340: 
                    case 341: 
                    case 342: 
                    case 343: 
                    case 344: 
                    case 345: 
                    case 346: 
                    case 351: 
                    case 352: 
                    case 353: 
                    case 357: 
                    case 358: 
                    case 359: 
                    case 360: 
                    case 361: 
                    case 362: 
                    case 363: 
                    case 364: 
                    case 365: 
                    case 367: 
                    case 369: 
                    case 370: 
                    case 379: 
                    case 380: 
                    case 383: 
                    case 384: 
                    case 385: 
                    case 388: 
                    case 391: 
                    case 392: 
                    case 393: 
                    case 395: 
                    case 396: 
                    case 397: 
                    case 398: 
                    case 399: 
                    case 400: 
                    case 401: 
                    case 403: 
                    case 404: 
                    case 405: 
                    case 406: 
                    case 407: 
                    case 411: 
                    case 412: 
                    case 413: 
                    case 414: 
                    case 416: 
                    case 417: 
                    case 418: 
                    case 419: 
                    case 421: 
                    case 423: 
                    case 425: 
                    case 428: 
                    case 429: 
                    case 431: 
                    case 432: 
                    case 434: 
                    case 435: 
                    case 436: 
                    case 438: 
                    case 439: 
                    case 448: 
                    case 452: 
                    case 454: 
                    case 455: 
                    case 457: 
                    case 458: 
                    case 460: 
                    case 461: 
                    case 462: 
                    case 465: 
                    case 466: 
                    case 467: 
                    case 468: 
                    case 469: 
                    case 472: 
                    case 473: 
                    case 474: 
                    case 477: 
                    case 478: 
                    case 479: 
                    case 480: 
                    case 481: 
                    case 482: 
                    case 483: 
                    case 485: 
                    case 488: 
                    case 489: 
                    case 490: 
                    case 491: 
                    case 493: 
                    case 494: 
                    case 495: 
                    case 498: 
                    case 499: 
                    case 500: 
                    case 501: 
                    case 504: 
                    case 506: 
                    case 507: 
                    case 508: 
                    case 509: 
                    case 510: 
                    case 511: 
                    case 512: 
                    case 514: 
                    case 518: 
                    case 519: 
                    case 522: 
                    case 523: 
                    case 524: 
                    case 525: 
                    case 526: 
                    case 532: 
                    case 533: 
                    case 534: 
                    case 535: 
                    case 536: 
                    case 537: 
                    case 538: 
                    case 539: 
                    case 540: 
                    case 541: 
                    case 542: 
                    case 543: 
                    case 544: 
                    case 545: 
                    case 546: 
                    case 547: 
                    case 548: 
                    case 549: 
                    case 550: 
                    case 551: 
                    case 552: 
                    case 553: 
                    case 554: 
                    case 555: 
                    case 556: 
                    case 557: 
                    case 558: 
                    case 559: 
                    case 560: 
                    case 561: 
                    case 562: 
                    case 563: 
                    case 564: 
                    case 565: 
                    case 566: 
                    case 567: 
                    case 568: 
                    case 569: 
                    case 570: 
                    case 571: 
                    case 572: 
                    case 573: 
                    case 574: 
                    case 575: 
                    case 576: 
                    case 577: 
                    case 578: 
                    case 579: 
                    case 580: 
                    case 581: 
                    case 583: 
                    case 584: 
                    case 586: 
                    case 587: 
                    case 589: 
                    case 590: 
                    case 591: 
                    case 592: 
                    case 595: 
                    case 596: 
                    case 599: 
                    case 604: 
                    case 606: 
                    case 608: 
                    case 611: 
                    case 612: 
                    case 613: 
                    case 614: 
                    case 615: 
                    case 616: 
                    case 617: 
                    case 618: 
                    case 619: 
                    case 624: 
                    case 626: 
                    case 627: 
                    case 628: 
                    case 629: 
                    case 630: 
                    case 631: 
                    case 632: 
                    case 637: 
                    case 638: 
                    case 639: 
                    case 640: 
                    case 642: 
                    case 643: 
                    case 645: 
                    case 646: 
                    case 648: 
                    case 649: 
                    case 650: 
                    case 651: 
                    case 653: 
                    case 654: 
                    case 655: 
                    case 656: 
                    case 659: 
                    case 661: 
                    case 662: 
                    case 663: 
                    case 664: 
                    case 665: 
                    case 666: 
                    case 668: 
                    case 669: 
                    case 670: 
                    case 674: 
                    case 675: 
                    case 679: 
                    case 681: 
                    case 683: 
                    case 684: 
                    case 693: 
                    case 694: 
                    case 695: 
                    case 696: 
                    case 697: 
                    case 698: 
                    case 699: 
                    case 700: 
                    case 701: 
                    case 702: 
                    case 706: 
                    case 707: 
                    case 708: 
                    case 709: 
                    case 710: 
                    case 712: 
                    case 713: 
                    case 715: 
                    case 717: 
                    case 718: 
                    case 719: 
                    case 720: 
                    case 731: 
                    case 737: 
                    case 738: 
                    case 763: 
                    case 764: 
                    case 765: 
                    case 766: 
                    case 767: 
                    case 768: 
                    case 770: {
                        args = this.ExpressionCommaList(s, SqlAbstractParserImpl.ExprContext.ACCEPT_NON_QUERY);
                        break;
                    }
                    default: {
                        this.jj_la1[226] = this.jj_gen;
                        args = SqlNodeList.EMPTY;
                    }
                }
                this.jj_consume_token(724);
                return SqlStdOperatorTable.ARRAY_VALUE_CONSTRUCTOR.createCall(s.end(this), args.getList());
            }
        }
        this.jj_la1[227] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SqlCall ArrayLiteral() throws ParseException {
        List list;
        this.jj_consume_token(721);
        Span s = this.span();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 132: 
            case 134: 
            case 202: 
            case 269: 
            case 361: 
            case 612: 
            case 615: 
            case 642: 
            case 654: 
            case 700: 
            case 701: 
            case 702: 
            case 706: 
            case 707: 
            case 708: 
            case 709: 
            case 710: 
            case 712: 
            case 713: 
            case 717: 
            case 718: 
            case 719: 
            case 737: 
            case 738: {
                SqlNode e = this.Literal();
                list = this.startList(e);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 727: {
                            break;
                        }
                        default: {
                            this.jj_la1[228] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(727);
                    e = this.Literal();
                    list.add(e);
                }
            }
            case 721: {
                SqlCall e = this.ArrayLiteral();
                list = this.startList(e);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 727: {
                            break;
                        }
                        default: {
                            this.jj_la1[229] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(727);
                    e = this.ArrayLiteral();
                    list.add(e);
                }
            }
            default: {
                this.jj_la1[230] = this.jj_gen;
                list = Collections.emptyList();
            }
        }
        this.jj_consume_token(722);
        return SqlStdOperatorTable.ARRAY_VALUE_CONSTRUCTOR.createCall(s.end(this), list);
    }

    public final SqlNode MapConstructor() throws ParseException {
        this.jj_consume_token(313);
        Span s = this.span();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 715: {
                this.jj_consume_token(715);
                SqlNode e = this.LeafQueryOrExpr(SqlAbstractParserImpl.ExprContext.ACCEPT_QUERY);
                this.jj_consume_token(716);
                return SqlStdOperatorTable.MAP_QUERY.createCall(s.end(this), e);
            }
            case 723: {
                SqlNodeList args;
                this.jj_consume_token(723);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 14: 
                    case 17: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 24: 
                    case 26: 
                    case 27: 
                    case 31: 
                    case 32: 
                    case 34: 
                    case 35: 
                    case 39: 
                    case 47: 
                    case 49: 
                    case 52: 
                    case 53: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 73: 
                    case 74: 
                    case 77: 
                    case 78: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 86: 
                    case 87: 
                    case 88: 
                    case 90: 
                    case 92: 
                    case 93: 
                    case 95: 
                    case 96: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 104: 
                    case 105: 
                    case 108: 
                    case 109: 
                    case 110: 
                    case 114: 
                    case 115: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 119: 
                    case 120: 
                    case 122: 
                    case 123: 
                    case 124: 
                    case 126: 
                    case 127: 
                    case 128: 
                    case 130: 
                    case 131: 
                    case 132: 
                    case 133: 
                    case 134: 
                    case 135: 
                    case 136: 
                    case 138: 
                    case 141: 
                    case 145: 
                    case 146: 
                    case 147: 
                    case 149: 
                    case 150: 
                    case 151: 
                    case 153: 
                    case 154: 
                    case 156: 
                    case 157: 
                    case 159: 
                    case 160: 
                    case 162: 
                    case 165: 
                    case 167: 
                    case 168: 
                    case 170: 
                    case 171: 
                    case 174: 
                    case 175: 
                    case 177: 
                    case 180: 
                    case 185: 
                    case 187: 
                    case 189: 
                    case 191: 
                    case 192: 
                    case 193: 
                    case 196: 
                    case 197: 
                    case 201: 
                    case 202: 
                    case 205: 
                    case 206: 
                    case 207: 
                    case 209: 
                    case 210: 
                    case 212: 
                    case 214: 
                    case 215: 
                    case 216: 
                    case 223: 
                    case 224: 
                    case 225: 
                    case 226: 
                    case 227: 
                    case 230: 
                    case 231: 
                    case 233: 
                    case 235: 
                    case 236: 
                    case 239: 
                    case 241: 
                    case 242: 
                    case 243: 
                    case 245: 
                    case 246: 
                    case 247: 
                    case 248: 
                    case 249: 
                    case 252: 
                    case 253: 
                    case 254: 
                    case 257: 
                    case 260: 
                    case 263: 
                    case 264: 
                    case 268: 
                    case 269: 
                    case 271: 
                    case 273: 
                    case 274: 
                    case 275: 
                    case 276: 
                    case 278: 
                    case 279: 
                    case 280: 
                    case 281: 
                    case 282: 
                    case 283: 
                    case 284: 
                    case 285: 
                    case 286: 
                    case 287: 
                    case 288: 
                    case 289: 
                    case 290: 
                    case 291: 
                    case 294: 
                    case 295: 
                    case 297: 
                    case 299: 
                    case 300: 
                    case 301: 
                    case 302: 
                    case 306: 
                    case 308: 
                    case 309: 
                    case 310: 
                    case 311: 
                    case 312: 
                    case 313: 
                    case 315: 
                    case 317: 
                    case 319: 
                    case 320: 
                    case 324: 
                    case 325: 
                    case 326: 
                    case 328: 
                    case 329: 
                    case 330: 
                    case 331: 
                    case 332: 
                    case 333: 
                    case 334: 
                    case 335: 
                    case 339: 
                    case 340: 
                    case 341: 
                    case 342: 
                    case 343: 
                    case 344: 
                    case 345: 
                    case 346: 
                    case 351: 
                    case 352: 
                    case 353: 
                    case 357: 
                    case 358: 
                    case 359: 
                    case 360: 
                    case 361: 
                    case 362: 
                    case 363: 
                    case 364: 
                    case 365: 
                    case 367: 
                    case 369: 
                    case 370: 
                    case 379: 
                    case 380: 
                    case 383: 
                    case 384: 
                    case 385: 
                    case 388: 
                    case 391: 
                    case 392: 
                    case 393: 
                    case 395: 
                    case 396: 
                    case 397: 
                    case 398: 
                    case 399: 
                    case 400: 
                    case 401: 
                    case 403: 
                    case 404: 
                    case 405: 
                    case 406: 
                    case 407: 
                    case 411: 
                    case 412: 
                    case 413: 
                    case 414: 
                    case 416: 
                    case 417: 
                    case 418: 
                    case 419: 
                    case 421: 
                    case 423: 
                    case 425: 
                    case 428: 
                    case 429: 
                    case 431: 
                    case 432: 
                    case 434: 
                    case 435: 
                    case 436: 
                    case 438: 
                    case 439: 
                    case 448: 
                    case 452: 
                    case 454: 
                    case 455: 
                    case 457: 
                    case 458: 
                    case 460: 
                    case 461: 
                    case 462: 
                    case 465: 
                    case 466: 
                    case 467: 
                    case 468: 
                    case 469: 
                    case 472: 
                    case 473: 
                    case 474: 
                    case 477: 
                    case 478: 
                    case 479: 
                    case 480: 
                    case 481: 
                    case 482: 
                    case 483: 
                    case 485: 
                    case 488: 
                    case 489: 
                    case 490: 
                    case 491: 
                    case 493: 
                    case 494: 
                    case 495: 
                    case 498: 
                    case 499: 
                    case 500: 
                    case 501: 
                    case 504: 
                    case 506: 
                    case 507: 
                    case 508: 
                    case 509: 
                    case 510: 
                    case 511: 
                    case 512: 
                    case 514: 
                    case 518: 
                    case 519: 
                    case 522: 
                    case 523: 
                    case 524: 
                    case 525: 
                    case 526: 
                    case 532: 
                    case 533: 
                    case 534: 
                    case 535: 
                    case 536: 
                    case 537: 
                    case 538: 
                    case 539: 
                    case 540: 
                    case 541: 
                    case 542: 
                    case 543: 
                    case 544: 
                    case 545: 
                    case 546: 
                    case 547: 
                    case 548: 
                    case 549: 
                    case 550: 
                    case 551: 
                    case 552: 
                    case 553: 
                    case 554: 
                    case 555: 
                    case 556: 
                    case 557: 
                    case 558: 
                    case 559: 
                    case 560: 
                    case 561: 
                    case 562: 
                    case 563: 
                    case 564: 
                    case 565: 
                    case 566: 
                    case 567: 
                    case 568: 
                    case 569: 
                    case 570: 
                    case 571: 
                    case 572: 
                    case 573: 
                    case 574: 
                    case 575: 
                    case 576: 
                    case 577: 
                    case 578: 
                    case 579: 
                    case 580: 
                    case 581: 
                    case 583: 
                    case 584: 
                    case 586: 
                    case 587: 
                    case 589: 
                    case 590: 
                    case 591: 
                    case 592: 
                    case 595: 
                    case 596: 
                    case 599: 
                    case 604: 
                    case 606: 
                    case 608: 
                    case 611: 
                    case 612: 
                    case 613: 
                    case 614: 
                    case 615: 
                    case 616: 
                    case 617: 
                    case 618: 
                    case 619: 
                    case 624: 
                    case 626: 
                    case 627: 
                    case 628: 
                    case 629: 
                    case 630: 
                    case 631: 
                    case 632: 
                    case 637: 
                    case 638: 
                    case 639: 
                    case 640: 
                    case 642: 
                    case 643: 
                    case 645: 
                    case 646: 
                    case 648: 
                    case 649: 
                    case 650: 
                    case 651: 
                    case 653: 
                    case 654: 
                    case 655: 
                    case 656: 
                    case 659: 
                    case 661: 
                    case 662: 
                    case 663: 
                    case 664: 
                    case 665: 
                    case 666: 
                    case 668: 
                    case 669: 
                    case 670: 
                    case 674: 
                    case 675: 
                    case 679: 
                    case 681: 
                    case 683: 
                    case 684: 
                    case 693: 
                    case 694: 
                    case 695: 
                    case 696: 
                    case 697: 
                    case 698: 
                    case 699: 
                    case 700: 
                    case 701: 
                    case 702: 
                    case 706: 
                    case 707: 
                    case 708: 
                    case 709: 
                    case 710: 
                    case 712: 
                    case 713: 
                    case 715: 
                    case 717: 
                    case 718: 
                    case 719: 
                    case 720: 
                    case 731: 
                    case 737: 
                    case 738: 
                    case 763: 
                    case 764: 
                    case 765: 
                    case 766: 
                    case 767: 
                    case 768: 
                    case 770: {
                        args = this.ExpressionCommaList(s, SqlAbstractParserImpl.ExprContext.ACCEPT_NON_QUERY);
                        break;
                    }
                    default: {
                        this.jj_la1[231] = this.jj_gen;
                        args = SqlNodeList.EMPTY;
                    }
                }
                this.jj_consume_token(724);
                return SqlStdOperatorTable.MAP_VALUE_CONSTRUCTOR.createCall(s.end(this), args.getList());
            }
        }
        this.jj_la1[232] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SqlNode PeriodConstructor() throws ParseException {
        ArrayList<SqlNode> args = new ArrayList<SqlNode>();
        this.jj_consume_token(414);
        Span s = this.span();
        this.jj_consume_token(715);
        this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        this.jj_consume_token(727);
        this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        this.jj_consume_token(716);
        return SqlStdOperatorTable.ROW.createCall(s.end(this), args);
    }

    public final SqlLiteral IntervalLiteral() throws ParseException {
        int sign = 1;
        this.jj_consume_token(269);
        Span s = this.span();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 737: 
            case 738: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 738: {
                        this.jj_consume_token(738);
                        sign = -1;
                        break block0;
                    }
                    case 737: {
                        this.jj_consume_token(737);
                        sign = 1;
                        break block0;
                    }
                }
                this.jj_la1[233] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[234] = this.jj_gen;
            }
        }
        String p = this.SimpleStringLiteral();
        SqlIntervalQualifier intervalQualifier = this.IntervalQualifier();
        return SqlParserUtil.parseIntervalLiteral(s.end(intervalQualifier), sign, p, intervalQualifier);
    }

    public final SqlNode IntervalLiteralOrExpression() throws ParseException {
        int sign = 1;
        this.jj_consume_token(269);
        Span s = this.span();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 737: 
            case 738: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 738: {
                        this.jj_consume_token(738);
                        sign = -1;
                        break block0;
                    }
                    case 737: {
                        this.jj_consume_token(737);
                        sign = 1;
                        break block0;
                    }
                }
                this.jj_la1[235] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[236] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 707: 
            case 712: 
            case 713: {
                String p = this.SimpleStringLiteral();
                SqlIntervalQualifier intervalQualifier = this.IntervalQualifier();
                return SqlParserUtil.parseIntervalLiteral(s.end(intervalQualifier), sign, p, intervalQualifier);
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 24: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 35: 
            case 39: 
            case 47: 
            case 49: 
            case 53: 
            case 57: 
            case 58: 
            case 61: 
            case 62: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 74: 
            case 78: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 86: 
            case 87: 
            case 88: 
            case 90: 
            case 92: 
            case 93: 
            case 95: 
            case 96: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 104: 
            case 128: 
            case 130: 
            case 131: 
            case 133: 
            case 135: 
            case 136: 
            case 138: 
            case 141: 
            case 145: 
            case 146: 
            case 147: 
            case 149: 
            case 150: 
            case 151: 
            case 154: 
            case 156: 
            case 157: 
            case 159: 
            case 160: 
            case 162: 
            case 165: 
            case 167: 
            case 168: 
            case 170: 
            case 171: 
            case 174: 
            case 175: 
            case 180: 
            case 185: 
            case 187: 
            case 191: 
            case 192: 
            case 193: 
            case 205: 
            case 206: 
            case 210: 
            case 212: 
            case 214: 
            case 215: 
            case 216: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 230: 
            case 231: 
            case 233: 
            case 235: 
            case 239: 
            case 241: 
            case 243: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 252: 
            case 253: 
            case 254: 
            case 257: 
            case 260: 
            case 263: 
            case 264: 
            case 271: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 278: 
            case 286: 
            case 287: 
            case 288: 
            case 289: 
            case 290: 
            case 294: 
            case 300: 
            case 301: 
            case 302: 
            case 310: 
            case 312: 
            case 313: 
            case 315: 
            case 320: 
            case 324: 
            case 325: 
            case 326: 
            case 328: 
            case 329: 
            case 330: 
            case 333: 
            case 334: 
            case 340: 
            case 341: 
            case 343: 
            case 344: 
            case 345: 
            case 346: 
            case 351: 
            case 357: 
            case 362: 
            case 364: 
            case 365: 
            case 367: 
            case 370: 
            case 379: 
            case 380: 
            case 383: 
            case 384: 
            case 385: 
            case 388: 
            case 392: 
            case 393: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 399: 
            case 400: 
            case 401: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 416: 
            case 417: 
            case 418: 
            case 419: 
            case 425: 
            case 428: 
            case 431: 
            case 432: 
            case 434: 
            case 435: 
            case 436: 
            case 439: 
            case 455: 
            case 457: 
            case 458: 
            case 460: 
            case 461: 
            case 462: 
            case 465: 
            case 466: 
            case 467: 
            case 468: 
            case 469: 
            case 473: 
            case 474: 
            case 477: 
            case 478: 
            case 479: 
            case 480: 
            case 482: 
            case 488: 
            case 489: 
            case 490: 
            case 491: 
            case 493: 
            case 494: 
            case 495: 
            case 499: 
            case 500: 
            case 501: 
            case 504: 
            case 506: 
            case 507: 
            case 508: 
            case 509: 
            case 510: 
            case 511: 
            case 514: 
            case 518: 
            case 519: 
            case 523: 
            case 524: 
            case 526: 
            case 532: 
            case 533: 
            case 534: 
            case 535: 
            case 536: 
            case 537: 
            case 538: 
            case 539: 
            case 540: 
            case 541: 
            case 542: 
            case 543: 
            case 544: 
            case 545: 
            case 546: 
            case 547: 
            case 548: 
            case 549: 
            case 550: 
            case 551: 
            case 552: 
            case 553: 
            case 554: 
            case 555: 
            case 556: 
            case 557: 
            case 558: 
            case 559: 
            case 560: 
            case 561: 
            case 562: 
            case 563: 
            case 564: 
            case 565: 
            case 566: 
            case 567: 
            case 568: 
            case 569: 
            case 570: 
            case 571: 
            case 572: 
            case 573: 
            case 574: 
            case 575: 
            case 576: 
            case 577: 
            case 578: 
            case 579: 
            case 580: 
            case 583: 
            case 584: 
            case 589: 
            case 590: 
            case 591: 
            case 592: 
            case 595: 
            case 606: 
            case 608: 
            case 611: 
            case 613: 
            case 614: 
            case 616: 
            case 617: 
            case 618: 
            case 619: 
            case 624: 
            case 626: 
            case 627: 
            case 628: 
            case 629: 
            case 630: 
            case 631: 
            case 637: 
            case 638: 
            case 639: 
            case 645: 
            case 646: 
            case 648: 
            case 649: 
            case 650: 
            case 651: 
            case 655: 
            case 656: 
            case 661: 
            case 663: 
            case 664: 
            case 665: 
            case 666: 
            case 668: 
            case 669: 
            case 670: 
            case 679: 
            case 681: 
            case 683: 
            case 684: 
            case 693: 
            case 694: 
            case 695: 
            case 696: 
            case 698: 
            case 699: 
            case 700: 
            case 701: 
            case 702: 
            case 715: 
            case 763: 
            case 764: 
            case 765: 
            case 766: 
            case 767: 
            case 768: 
            case 770: {
                SqlNode e;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 715: {
                        this.jj_consume_token(715);
                        e = this.Expression(SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                        this.jj_consume_token(716);
                        break;
                    }
                    case 700: 
                    case 701: 
                    case 702: {
                        e = this.UnsignedNumericLiteral();
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 14: 
                    case 17: 
                    case 20: 
                    case 21: 
                    case 24: 
                    case 26: 
                    case 27: 
                    case 31: 
                    case 32: 
                    case 35: 
                    case 39: 
                    case 47: 
                    case 49: 
                    case 53: 
                    case 57: 
                    case 58: 
                    case 61: 
                    case 62: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 74: 
                    case 78: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 86: 
                    case 87: 
                    case 88: 
                    case 90: 
                    case 92: 
                    case 93: 
                    case 95: 
                    case 96: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 104: 
                    case 128: 
                    case 130: 
                    case 131: 
                    case 133: 
                    case 135: 
                    case 136: 
                    case 138: 
                    case 141: 
                    case 145: 
                    case 146: 
                    case 147: 
                    case 149: 
                    case 150: 
                    case 151: 
                    case 154: 
                    case 156: 
                    case 157: 
                    case 159: 
                    case 160: 
                    case 162: 
                    case 165: 
                    case 167: 
                    case 168: 
                    case 170: 
                    case 171: 
                    case 174: 
                    case 175: 
                    case 180: 
                    case 185: 
                    case 187: 
                    case 191: 
                    case 192: 
                    case 193: 
                    case 205: 
                    case 206: 
                    case 210: 
                    case 212: 
                    case 214: 
                    case 215: 
                    case 216: 
                    case 224: 
                    case 225: 
                    case 226: 
                    case 227: 
                    case 230: 
                    case 231: 
                    case 233: 
                    case 235: 
                    case 239: 
                    case 241: 
                    case 243: 
                    case 245: 
                    case 246: 
                    case 247: 
                    case 248: 
                    case 249: 
                    case 252: 
                    case 253: 
                    case 254: 
                    case 257: 
                    case 260: 
                    case 263: 
                    case 264: 
                    case 271: 
                    case 273: 
                    case 274: 
                    case 275: 
                    case 276: 
                    case 278: 
                    case 286: 
                    case 287: 
                    case 288: 
                    case 289: 
                    case 290: 
                    case 294: 
                    case 300: 
                    case 301: 
                    case 302: 
                    case 310: 
                    case 312: 
                    case 313: 
                    case 315: 
                    case 320: 
                    case 324: 
                    case 325: 
                    case 326: 
                    case 328: 
                    case 329: 
                    case 330: 
                    case 333: 
                    case 334: 
                    case 340: 
                    case 341: 
                    case 343: 
                    case 344: 
                    case 345: 
                    case 346: 
                    case 351: 
                    case 357: 
                    case 362: 
                    case 364: 
                    case 365: 
                    case 367: 
                    case 370: 
                    case 379: 
                    case 380: 
                    case 383: 
                    case 384: 
                    case 385: 
                    case 388: 
                    case 392: 
                    case 393: 
                    case 395: 
                    case 396: 
                    case 397: 
                    case 398: 
                    case 399: 
                    case 400: 
                    case 401: 
                    case 403: 
                    case 404: 
                    case 405: 
                    case 406: 
                    case 407: 
                    case 416: 
                    case 417: 
                    case 418: 
                    case 419: 
                    case 425: 
                    case 428: 
                    case 431: 
                    case 432: 
                    case 434: 
                    case 435: 
                    case 436: 
                    case 439: 
                    case 455: 
                    case 457: 
                    case 458: 
                    case 460: 
                    case 461: 
                    case 462: 
                    case 465: 
                    case 466: 
                    case 467: 
                    case 468: 
                    case 469: 
                    case 473: 
                    case 474: 
                    case 477: 
                    case 478: 
                    case 479: 
                    case 480: 
                    case 482: 
                    case 488: 
                    case 489: 
                    case 490: 
                    case 491: 
                    case 493: 
                    case 494: 
                    case 495: 
                    case 499: 
                    case 500: 
                    case 501: 
                    case 504: 
                    case 506: 
                    case 507: 
                    case 508: 
                    case 509: 
                    case 510: 
                    case 511: 
                    case 514: 
                    case 518: 
                    case 519: 
                    case 523: 
                    case 524: 
                    case 526: 
                    case 532: 
                    case 533: 
                    case 534: 
                    case 535: 
                    case 536: 
                    case 537: 
                    case 538: 
                    case 539: 
                    case 540: 
                    case 541: 
                    case 542: 
                    case 543: 
                    case 544: 
                    case 545: 
                    case 546: 
                    case 547: 
                    case 548: 
                    case 549: 
                    case 550: 
                    case 551: 
                    case 552: 
                    case 553: 
                    case 554: 
                    case 555: 
                    case 556: 
                    case 557: 
                    case 558: 
                    case 559: 
                    case 560: 
                    case 561: 
                    case 562: 
                    case 563: 
                    case 564: 
                    case 565: 
                    case 566: 
                    case 567: 
                    case 568: 
                    case 569: 
                    case 570: 
                    case 571: 
                    case 572: 
                    case 573: 
                    case 574: 
                    case 575: 
                    case 576: 
                    case 577: 
                    case 578: 
                    case 579: 
                    case 580: 
                    case 583: 
                    case 584: 
                    case 589: 
                    case 590: 
                    case 591: 
                    case 592: 
                    case 595: 
                    case 606: 
                    case 608: 
                    case 611: 
                    case 613: 
                    case 614: 
                    case 616: 
                    case 617: 
                    case 618: 
                    case 619: 
                    case 624: 
                    case 626: 
                    case 627: 
                    case 628: 
                    case 629: 
                    case 630: 
                    case 631: 
                    case 637: 
                    case 638: 
                    case 639: 
                    case 645: 
                    case 646: 
                    case 648: 
                    case 649: 
                    case 650: 
                    case 651: 
                    case 655: 
                    case 656: 
                    case 661: 
                    case 663: 
                    case 664: 
                    case 665: 
                    case 666: 
                    case 668: 
                    case 669: 
                    case 670: 
                    case 679: 
                    case 681: 
                    case 683: 
                    case 684: 
                    case 693: 
                    case 694: 
                    case 695: 
                    case 696: 
                    case 698: 
                    case 699: 
                    case 763: 
                    case 764: 
                    case 765: 
                    case 766: 
                    case 767: 
                    case 768: 
                    case 770: {
                        e = this.CompoundIdentifier();
                        break;
                    }
                    default: {
                        this.jj_la1[237] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                SqlIntervalQualifier intervalQualifier = this.IntervalQualifierStart();
                if (sign == -1) {
                    e = SqlStdOperatorTable.UNARY_MINUS.createCall(e.getParserPosition(), e);
                }
                return SqlStdOperatorTable.INTERVAL.createCall(s.end(this), e, intervalQualifier);
            }
        }
        this.jj_la1[238] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final TimeUnit Year() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 697: {
                this.jj_consume_token(697);
                return TimeUnit.YEAR;
            }
            case 698: {
                this.jj_consume_token(698);
                return this.warn(TimeUnit.YEAR);
            }
        }
        this.jj_la1[239] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final TimeUnit Quarter() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 435: {
                this.jj_consume_token(435);
                return TimeUnit.QUARTER;
            }
            case 436: {
                this.jj_consume_token(436);
                return this.warn(TimeUnit.QUARTER);
            }
        }
        this.jj_la1[240] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final TimeUnit Month() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 339: {
                this.jj_consume_token(339);
                return TimeUnit.MONTH;
            }
            case 340: {
                this.jj_consume_token(340);
                return this.warn(TimeUnit.MONTH);
            }
        }
        this.jj_la1[241] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final TimeUnit Week() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 683: {
                this.jj_consume_token(683);
                return TimeUnit.WEEK;
            }
            case 684: {
                this.jj_consume_token(684);
                return this.warn(TimeUnit.WEEK);
            }
        }
        this.jj_la1[242] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final TimeUnit Day() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 137: {
                this.jj_consume_token(137);
                return TimeUnit.DAY;
            }
            case 138: {
                this.jj_consume_token(138);
                return this.warn(TimeUnit.DAY);
            }
        }
        this.jj_la1[243] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final TimeUnit Hour() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 242: {
                this.jj_consume_token(242);
                return TimeUnit.HOUR;
            }
            case 243: {
                this.jj_consume_token(243);
                return this.warn(TimeUnit.HOUR);
            }
        }
        this.jj_la1[244] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final TimeUnit Minute() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 332: {
                this.jj_consume_token(332);
                return TimeUnit.MINUTE;
            }
            case 333: {
                this.jj_consume_token(333);
                return this.warn(TimeUnit.MINUTE);
            }
        }
        this.jj_la1[245] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final TimeUnit Second() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 498: {
                this.jj_consume_token(498);
                return TimeUnit.SECOND;
            }
            case 499: {
                this.jj_consume_token(499);
                return this.warn(TimeUnit.SECOND);
            }
        }
        this.jj_la1[246] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SqlIntervalQualifier IntervalQualifier() throws ParseException {
        TimeUnit end;
        int startPrec;
        Span s;
        TimeUnit start;
        int secondFracPrec = -1;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 697: 
            case 698: {
                start = this.Year();
                s = this.span();
                startPrec = this.PrecisionOpt();
                if (this.jj_2_66(2)) {
                    this.jj_consume_token(623);
                    end = this.Month();
                    break;
                }
                end = null;
                break;
            }
            case 435: 
            case 436: {
                start = this.Quarter();
                s = this.span();
                startPrec = this.PrecisionOpt();
                end = null;
                break;
            }
            case 339: 
            case 340: {
                start = this.Month();
                s = this.span();
                startPrec = this.PrecisionOpt();
                end = null;
                break;
            }
            case 683: 
            case 684: {
                start = this.Week();
                s = this.span();
                startPrec = this.PrecisionOpt();
                end = null;
                break;
            }
            case 137: 
            case 138: {
                start = this.Day();
                s = this.span();
                startPrec = this.PrecisionOpt();
                if (this.jj_2_67(2)) {
                    this.jj_consume_token(623);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 242: 
                        case 243: {
                            end = this.Hour();
                            break block0;
                        }
                        case 332: 
                        case 333: {
                            end = this.Minute();
                            break block0;
                        }
                        case 498: 
                        case 499: {
                            end = this.Second();
                            secondFracPrec = this.PrecisionOpt();
                            break block0;
                        }
                    }
                    this.jj_la1[247] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                end = null;
                break;
            }
            case 242: 
            case 243: {
                start = this.Hour();
                s = this.span();
                startPrec = this.PrecisionOpt();
                if (this.jj_2_68(2)) {
                    this.jj_consume_token(623);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 332: 
                        case 333: {
                            end = this.Minute();
                            break block0;
                        }
                        case 498: 
                        case 499: {
                            end = this.Second();
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 715: {
                                    this.jj_consume_token(715);
                                    secondFracPrec = this.UnsignedIntLiteral();
                                    this.jj_consume_token(716);
                                    break block0;
                                }
                            }
                            this.jj_la1[248] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_la1[249] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                end = null;
                break;
            }
            case 332: 
            case 333: {
                start = this.Minute();
                s = this.span();
                startPrec = this.PrecisionOpt();
                if (this.jj_2_69(2)) {
                    this.jj_consume_token(623);
                    end = this.Second();
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 715: {
                            this.jj_consume_token(715);
                            secondFracPrec = this.UnsignedIntLiteral();
                            this.jj_consume_token(716);
                            break block0;
                        }
                    }
                    this.jj_la1[250] = this.jj_gen;
                    break;
                }
                end = null;
                break;
            }
            case 498: 
            case 499: {
                start = this.Second();
                s = this.span();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 715: {
                        this.jj_consume_token(715);
                        startPrec = this.UnsignedIntLiteral();
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 727: {
                                this.jj_consume_token(727);
                                secondFracPrec = this.UnsignedIntLiteral();
                                break;
                            }
                            default: {
                                this.jj_la1[251] = this.jj_gen;
                            }
                        }
                        this.jj_consume_token(716);
                        break;
                    }
                    default: {
                        this.jj_la1[252] = this.jj_gen;
                        startPrec = -1;
                    }
                }
                end = null;
                break;
            }
            default: {
                this.jj_la1[253] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return new SqlIntervalQualifier(start, startPrec, end, secondFracPrec, s.end(this));
    }

    public final SqlIntervalQualifier IntervalQualifierStart() throws ParseException {
        Span s;
        TimeUnit start;
        int startPrec = -1;
        int secondFracPrec = -1;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 137: 
            case 138: 
            case 242: 
            case 243: 
            case 332: 
            case 333: 
            case 339: 
            case 340: 
            case 435: 
            case 436: 
            case 683: 
            case 684: 
            case 697: 
            case 698: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 697: 
                    case 698: {
                        start = this.Year();
                        break;
                    }
                    case 435: 
                    case 436: {
                        start = this.Quarter();
                        break;
                    }
                    case 339: 
                    case 340: {
                        start = this.Month();
                        break;
                    }
                    case 683: 
                    case 684: {
                        start = this.Week();
                        break;
                    }
                    case 137: 
                    case 138: {
                        start = this.Day();
                        break;
                    }
                    case 242: 
                    case 243: {
                        start = this.Hour();
                        break;
                    }
                    case 332: 
                    case 333: {
                        start = this.Minute();
                        break;
                    }
                    default: {
                        this.jj_la1[254] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                s = this.span();
                startPrec = this.PrecisionOpt();
                break;
            }
            case 498: 
            case 499: {
                start = this.Second();
                s = this.span();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 715: {
                        this.jj_consume_token(715);
                        startPrec = this.UnsignedIntLiteral();
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 727: {
                                this.jj_consume_token(727);
                                secondFracPrec = this.UnsignedIntLiteral();
                                break;
                            }
                            default: {
                                this.jj_la1[255] = this.jj_gen;
                            }
                        }
                        this.jj_consume_token(716);
                        break block0;
                    }
                }
                this.jj_la1[256] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[257] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return new SqlIntervalQualifier(start, startPrec, null, secondFracPrec, s.end(this));
    }

    public final SqlIntervalQualifier TimeUnitOrName() throws ParseException {
        if (this.jj_2_71(2)) {
            this.jj_consume_token(346);
            return new SqlIntervalQualifier(TimeUnit.NANOSECOND, null, this.getPos());
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 328: {
                this.jj_consume_token(328);
                return new SqlIntervalQualifier(TimeUnit.MICROSECOND, null, this.getPos());
            }
            case 329: {
                this.jj_consume_token(329);
                return new SqlIntervalQualifier(TimeUnit.MILLISECOND, null, this.getPos());
            }
            case 498: {
                this.jj_consume_token(498);
                return new SqlIntervalQualifier(TimeUnit.SECOND, null, this.getPos());
            }
            case 332: {
                this.jj_consume_token(332);
                return new SqlIntervalQualifier(TimeUnit.MINUTE, null, this.getPos());
            }
            case 242: {
                this.jj_consume_token(242);
                return new SqlIntervalQualifier(TimeUnit.HOUR, null, this.getPos());
            }
            case 137: {
                this.jj_consume_token(137);
                return new SqlIntervalQualifier(TimeUnit.DAY, null, this.getPos());
            }
            case 170: {
                this.jj_consume_token(170);
                return new SqlIntervalQualifier(TimeUnit.DOW, null, this.getPos());
            }
            case 171: {
                this.jj_consume_token(171);
                return new SqlIntervalQualifier(TimeUnit.DOY, null, this.getPos());
            }
            case 273: {
                this.jj_consume_token(273);
                return new SqlIntervalQualifier(TimeUnit.ISODOW, null, this.getPos());
            }
            case 274: {
                this.jj_consume_token(274);
                return new SqlIntervalQualifier(TimeUnit.ISOYEAR, null, this.getPos());
            }
            case 683: {
                this.jj_consume_token(683);
                Span span = this.span();
                if (this.jj_2_70(2)) {
                    this.jj_consume_token(715);
                    String w = this.weekdayName();
                    this.jj_consume_token(716);
                    return new SqlIntervalQualifier(w, span.end(this));
                }
                return new SqlIntervalQualifier(TimeUnit.WEEK, null, this.getPos());
            }
            case 339: {
                this.jj_consume_token(339);
                return new SqlIntervalQualifier(TimeUnit.MONTH, null, this.getPos());
            }
            case 435: {
                this.jj_consume_token(435);
                return new SqlIntervalQualifier(TimeUnit.QUARTER, null, this.getPos());
            }
            case 697: {
                this.jj_consume_token(697);
                return new SqlIntervalQualifier(TimeUnit.YEAR, null, this.getPos());
            }
            case 185: {
                this.jj_consume_token(185);
                return new SqlIntervalQualifier(TimeUnit.EPOCH, null, this.getPos());
            }
            case 141: {
                this.jj_consume_token(141);
                return new SqlIntervalQualifier(TimeUnit.DECADE, null, this.getPos());
            }
            case 61: {
                this.jj_consume_token(61);
                return new SqlIntervalQualifier(TimeUnit.CENTURY, null, this.getPos());
            }
            case 330: {
                this.jj_consume_token(330);
                return new SqlIntervalQualifier(TimeUnit.MILLENNIUM, null, this.getPos());
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 24: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 35: 
            case 39: 
            case 47: 
            case 49: 
            case 53: 
            case 57: 
            case 58: 
            case 62: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 74: 
            case 78: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 86: 
            case 87: 
            case 88: 
            case 90: 
            case 92: 
            case 93: 
            case 95: 
            case 96: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 104: 
            case 128: 
            case 130: 
            case 131: 
            case 133: 
            case 135: 
            case 136: 
            case 138: 
            case 145: 
            case 146: 
            case 147: 
            case 149: 
            case 150: 
            case 151: 
            case 154: 
            case 156: 
            case 157: 
            case 159: 
            case 160: 
            case 162: 
            case 165: 
            case 167: 
            case 168: 
            case 174: 
            case 175: 
            case 180: 
            case 187: 
            case 191: 
            case 192: 
            case 193: 
            case 205: 
            case 206: 
            case 210: 
            case 212: 
            case 214: 
            case 215: 
            case 216: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 230: 
            case 231: 
            case 233: 
            case 235: 
            case 239: 
            case 241: 
            case 243: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 252: 
            case 253: 
            case 254: 
            case 257: 
            case 260: 
            case 263: 
            case 264: 
            case 271: 
            case 275: 
            case 276: 
            case 278: 
            case 286: 
            case 287: 
            case 288: 
            case 289: 
            case 290: 
            case 294: 
            case 300: 
            case 301: 
            case 302: 
            case 310: 
            case 312: 
            case 313: 
            case 315: 
            case 320: 
            case 324: 
            case 325: 
            case 326: 
            case 333: 
            case 334: 
            case 340: 
            case 341: 
            case 343: 
            case 344: 
            case 345: 
            case 346: 
            case 351: 
            case 357: 
            case 362: 
            case 364: 
            case 365: 
            case 367: 
            case 370: 
            case 379: 
            case 380: 
            case 383: 
            case 384: 
            case 385: 
            case 388: 
            case 392: 
            case 393: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 399: 
            case 400: 
            case 401: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 416: 
            case 417: 
            case 418: 
            case 419: 
            case 425: 
            case 428: 
            case 431: 
            case 432: 
            case 434: 
            case 436: 
            case 439: 
            case 455: 
            case 457: 
            case 458: 
            case 460: 
            case 461: 
            case 462: 
            case 465: 
            case 466: 
            case 467: 
            case 468: 
            case 469: 
            case 473: 
            case 474: 
            case 477: 
            case 478: 
            case 479: 
            case 480: 
            case 482: 
            case 488: 
            case 489: 
            case 490: 
            case 491: 
            case 493: 
            case 494: 
            case 495: 
            case 499: 
            case 500: 
            case 501: 
            case 504: 
            case 506: 
            case 507: 
            case 508: 
            case 509: 
            case 510: 
            case 511: 
            case 514: 
            case 518: 
            case 519: 
            case 523: 
            case 524: 
            case 526: 
            case 532: 
            case 533: 
            case 534: 
            case 535: 
            case 536: 
            case 537: 
            case 538: 
            case 539: 
            case 540: 
            case 541: 
            case 542: 
            case 543: 
            case 544: 
            case 545: 
            case 546: 
            case 547: 
            case 548: 
            case 549: 
            case 550: 
            case 551: 
            case 552: 
            case 553: 
            case 554: 
            case 555: 
            case 556: 
            case 557: 
            case 558: 
            case 559: 
            case 560: 
            case 561: 
            case 562: 
            case 563: 
            case 564: 
            case 565: 
            case 566: 
            case 567: 
            case 568: 
            case 569: 
            case 570: 
            case 571: 
            case 572: 
            case 573: 
            case 574: 
            case 575: 
            case 576: 
            case 577: 
            case 578: 
            case 579: 
            case 580: 
            case 583: 
            case 584: 
            case 589: 
            case 590: 
            case 591: 
            case 592: 
            case 595: 
            case 606: 
            case 608: 
            case 611: 
            case 613: 
            case 614: 
            case 616: 
            case 617: 
            case 618: 
            case 619: 
            case 624: 
            case 626: 
            case 627: 
            case 628: 
            case 629: 
            case 630: 
            case 631: 
            case 637: 
            case 638: 
            case 639: 
            case 645: 
            case 646: 
            case 648: 
            case 649: 
            case 650: 
            case 651: 
            case 655: 
            case 656: 
            case 661: 
            case 663: 
            case 664: 
            case 665: 
            case 666: 
            case 668: 
            case 669: 
            case 670: 
            case 679: 
            case 681: 
            case 684: 
            case 693: 
            case 694: 
            case 695: 
            case 696: 
            case 698: 
            case 699: 
            case 763: 
            case 764: 
            case 765: 
            case 766: 
            case 767: 
            case 768: 
            case 770: {
                SqlIdentifier unitName = this.SimpleIdentifier();
                return new SqlIntervalQualifier(unitName.getSimple(), unitName.getParserPosition());
            }
        }
        this.jj_la1[258] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String weekdayName() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 600: {
                this.jj_consume_token(600);
                return "WEEK_SUNDAY";
            }
            case 338: {
                this.jj_consume_token(338);
                return "WEEK_MONDAY";
            }
            case 644: {
                this.jj_consume_token(644);
                return "WEEK_TUESDAY";
            }
            case 682: {
                this.jj_consume_token(682);
                return "WEEK_WEDNESDAY";
            }
            case 610: {
                this.jj_consume_token(610);
                return "WEEK_THURSDAY";
            }
            case 219: {
                this.jj_consume_token(219);
                return "WEEK_FRIDAY";
            }
            case 486: {
                this.jj_consume_token(486);
                return "WEEK_SATURDAY";
            }
        }
        this.jj_la1[259] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SqlDynamicParam DynamicParam() throws ParseException {
        this.jj_consume_token(731);
        return new SqlDynamicParam(this.nDynamicParams++, this.getPos());
    }

    public final void AddIdentifierSegment(List<String> names, List<SqlParserPos> positions) throws ParseException {
        SqlParserPos pos;
        String id;
        char unicodeEscapeChar = '\\';
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 768: {
                this.jj_consume_token(768);
                id = this.unquotedIdentifier();
                pos = this.getPos();
                break;
            }
            case 767: {
                this.jj_consume_token(767);
                id = this.unquotedIdentifier();
                pos = this.getPos();
                break;
            }
            case 764: {
                this.jj_consume_token(764);
                id = SqlParserUtil.stripQuotes(this.getToken((int)0).image, DQ, DQ, DQDQ, this.quotedCasing);
                pos = this.getPos().withQuoting(true);
                break;
            }
            case 765: {
                this.jj_consume_token(765);
                id = SqlParserUtil.stripQuotes(this.getToken((int)0).image, "`", "`", "``", this.quotedCasing);
                pos = this.getPos().withQuoting(true);
                break;
            }
            case 766: {
                this.jj_consume_token(766);
                id = SqlParserUtil.stripQuotes(this.getToken((int)0).image, "`", "`", "\\`", this.quotedCasing);
                pos = this.getPos().withQuoting(true);
                break;
            }
            case 763: {
                this.jj_consume_token(763);
                id = SqlParserUtil.stripQuotes(this.getToken((int)0).image, "[", "]", "]]", this.quotedCasing);
                pos = this.getPos().withQuoting(true);
                break;
            }
            case 770: {
                this.jj_consume_token(770);
                Span span = this.span();
                String image = this.getToken((int)0).image;
                image = image.substring(image.indexOf(34));
                image = SqlParserUtil.stripQuotes(image, DQ, DQ, DQDQ, this.quotedCasing);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 647: {
                        this.jj_consume_token(647);
                        this.jj_consume_token(707);
                        String s = SqlParserUtil.parseString(this.token.image);
                        unicodeEscapeChar = SqlParserUtil.checkUnicodeEscapeChar(s);
                        break;
                    }
                    default: {
                        this.jj_la1[260] = this.jj_gen;
                    }
                }
                pos = span.end(this).withQuoting(true);
                SqlLiteral lit = SqlLiteral.createCharString(image, "UTF16", pos);
                lit = lit.unescapeUnicode(unicodeEscapeChar);
                id = lit.toValue();
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 24: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 35: 
            case 39: 
            case 47: 
            case 49: 
            case 53: 
            case 57: 
            case 58: 
            case 61: 
            case 62: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 74: 
            case 78: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 86: 
            case 87: 
            case 88: 
            case 90: 
            case 92: 
            case 93: 
            case 95: 
            case 96: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 104: 
            case 128: 
            case 130: 
            case 131: 
            case 133: 
            case 135: 
            case 136: 
            case 138: 
            case 141: 
            case 145: 
            case 146: 
            case 147: 
            case 149: 
            case 150: 
            case 151: 
            case 154: 
            case 156: 
            case 157: 
            case 159: 
            case 160: 
            case 162: 
            case 165: 
            case 167: 
            case 168: 
            case 170: 
            case 171: 
            case 174: 
            case 175: 
            case 180: 
            case 185: 
            case 187: 
            case 191: 
            case 192: 
            case 193: 
            case 205: 
            case 206: 
            case 210: 
            case 212: 
            case 214: 
            case 215: 
            case 216: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 230: 
            case 231: 
            case 233: 
            case 235: 
            case 239: 
            case 241: 
            case 243: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 252: 
            case 253: 
            case 254: 
            case 257: 
            case 260: 
            case 263: 
            case 264: 
            case 271: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 278: 
            case 286: 
            case 287: 
            case 288: 
            case 289: 
            case 290: 
            case 294: 
            case 300: 
            case 301: 
            case 302: 
            case 310: 
            case 312: 
            case 313: 
            case 315: 
            case 320: 
            case 324: 
            case 325: 
            case 326: 
            case 328: 
            case 329: 
            case 330: 
            case 333: 
            case 334: 
            case 340: 
            case 341: 
            case 343: 
            case 344: 
            case 345: 
            case 346: 
            case 351: 
            case 357: 
            case 362: 
            case 364: 
            case 365: 
            case 367: 
            case 370: 
            case 379: 
            case 380: 
            case 383: 
            case 384: 
            case 385: 
            case 388: 
            case 392: 
            case 393: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 399: 
            case 400: 
            case 401: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 416: 
            case 417: 
            case 418: 
            case 419: 
            case 425: 
            case 428: 
            case 431: 
            case 432: 
            case 434: 
            case 435: 
            case 436: 
            case 439: 
            case 455: 
            case 457: 
            case 458: 
            case 460: 
            case 461: 
            case 462: 
            case 465: 
            case 466: 
            case 467: 
            case 468: 
            case 469: 
            case 473: 
            case 474: 
            case 477: 
            case 478: 
            case 479: 
            case 480: 
            case 482: 
            case 488: 
            case 489: 
            case 490: 
            case 491: 
            case 493: 
            case 494: 
            case 495: 
            case 499: 
            case 500: 
            case 501: 
            case 504: 
            case 506: 
            case 507: 
            case 508: 
            case 509: 
            case 510: 
            case 511: 
            case 514: 
            case 518: 
            case 519: 
            case 523: 
            case 524: 
            case 526: 
            case 532: 
            case 533: 
            case 534: 
            case 535: 
            case 536: 
            case 537: 
            case 538: 
            case 539: 
            case 540: 
            case 541: 
            case 542: 
            case 543: 
            case 544: 
            case 545: 
            case 546: 
            case 547: 
            case 548: 
            case 549: 
            case 550: 
            case 551: 
            case 552: 
            case 553: 
            case 554: 
            case 555: 
            case 556: 
            case 557: 
            case 558: 
            case 559: 
            case 560: 
            case 561: 
            case 562: 
            case 563: 
            case 564: 
            case 565: 
            case 566: 
            case 567: 
            case 568: 
            case 569: 
            case 570: 
            case 571: 
            case 572: 
            case 573: 
            case 574: 
            case 575: 
            case 576: 
            case 577: 
            case 578: 
            case 579: 
            case 580: 
            case 583: 
            case 584: 
            case 589: 
            case 590: 
            case 591: 
            case 592: 
            case 595: 
            case 606: 
            case 608: 
            case 611: 
            case 613: 
            case 614: 
            case 616: 
            case 617: 
            case 618: 
            case 619: 
            case 624: 
            case 626: 
            case 627: 
            case 628: 
            case 629: 
            case 630: 
            case 631: 
            case 637: 
            case 638: 
            case 639: 
            case 645: 
            case 646: 
            case 648: 
            case 649: 
            case 650: 
            case 651: 
            case 655: 
            case 656: 
            case 661: 
            case 663: 
            case 664: 
            case 665: 
            case 666: 
            case 668: 
            case 669: 
            case 670: 
            case 679: 
            case 681: 
            case 683: 
            case 684: 
            case 693: 
            case 694: 
            case 695: 
            case 696: 
            case 698: 
            case 699: {
                id = this.NonReservedKeyWord();
                pos = this.getPos();
                break;
            }
            default: {
                this.jj_la1[261] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (id.length() > this.identifierMaxLength) {
            throw SqlUtil.newContextException(pos, Static.RESOURCE.identifierTooLong(id, this.identifierMaxLength));
        }
        names.add(id);
        if (positions != null) {
            positions.add(pos);
        }
    }

    public final void AddTableIdentifierSegment(List<String> names, List<SqlParserPos> positions) throws ParseException {
        this.AddIdentifierSegment(names, positions);
        int n = names.size();
        if (n > 0 && positions.size() == n && names.get(n - 1).contains(".") && positions.get(n - 1).isQuoted() && this.conformance.splitQuotedTableName()) {
            String[] splitNames;
            String name = names.remove(n - 1);
            SqlParserPos pos = positions.remove(n - 1);
            for (String splitName : splitNames = name.split("\\.")) {
                names.add(splitName);
                positions.add(pos);
            }
        }
    }

    public final String Identifier() throws ParseException {
        ArrayList<String> names = new ArrayList<String>();
        this.AddIdentifierSegment(names, null);
        return (String)names.get(0);
    }

    public final SqlIdentifier SimpleIdentifier() throws ParseException {
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<SqlParserPos> positions = new ArrayList<SqlParserPos>();
        this.AddIdentifierSegment(names, positions);
        return new SqlIdentifier((String)names.get(0), (SqlParserPos)positions.get(0));
    }

    public final SqlIdentifier SimpleIdentifierFromStringLiteral() throws ParseException {
        this.jj_consume_token(707);
        if (!this.conformance.allowCharLiteralAlias()) {
            throw SqlUtil.newContextException(this.getPos(), Static.RESOURCE.charLiteralAliasNotValid());
        }
        String s = SqlParserUtil.parseString(this.token.image);
        return new SqlIdentifier(s, this.getPos());
    }

    public final void AddSimpleIdentifiers(List<SqlNode> list) throws ParseException {
        SqlIdentifier id = this.SimpleIdentifier();
        list.add(id);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 727: {
                    break;
                }
                default: {
                    this.jj_la1[262] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(727);
            id = this.SimpleIdentifier();
            list.add(id);
        }
    }

    public final SqlNodeList ParenthesizedSimpleIdentifierList() throws ParseException {
        ArrayList<SqlNode> list = new ArrayList<SqlNode>();
        this.jj_consume_token(715);
        Span s = this.span();
        this.AddSimpleIdentifiers(list);
        this.jj_consume_token(716);
        return new SqlNodeList(list, s.end(this));
    }

    public final SqlNodeList SimpleIdentifierOrList() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 24: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 35: 
            case 39: 
            case 47: 
            case 49: 
            case 53: 
            case 57: 
            case 58: 
            case 61: 
            case 62: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 74: 
            case 78: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 86: 
            case 87: 
            case 88: 
            case 90: 
            case 92: 
            case 93: 
            case 95: 
            case 96: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 104: 
            case 128: 
            case 130: 
            case 131: 
            case 133: 
            case 135: 
            case 136: 
            case 138: 
            case 141: 
            case 145: 
            case 146: 
            case 147: 
            case 149: 
            case 150: 
            case 151: 
            case 154: 
            case 156: 
            case 157: 
            case 159: 
            case 160: 
            case 162: 
            case 165: 
            case 167: 
            case 168: 
            case 170: 
            case 171: 
            case 174: 
            case 175: 
            case 180: 
            case 185: 
            case 187: 
            case 191: 
            case 192: 
            case 193: 
            case 205: 
            case 206: 
            case 210: 
            case 212: 
            case 214: 
            case 215: 
            case 216: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 230: 
            case 231: 
            case 233: 
            case 235: 
            case 239: 
            case 241: 
            case 243: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 252: 
            case 253: 
            case 254: 
            case 257: 
            case 260: 
            case 263: 
            case 264: 
            case 271: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 278: 
            case 286: 
            case 287: 
            case 288: 
            case 289: 
            case 290: 
            case 294: 
            case 300: 
            case 301: 
            case 302: 
            case 310: 
            case 312: 
            case 313: 
            case 315: 
            case 320: 
            case 324: 
            case 325: 
            case 326: 
            case 328: 
            case 329: 
            case 330: 
            case 333: 
            case 334: 
            case 340: 
            case 341: 
            case 343: 
            case 344: 
            case 345: 
            case 346: 
            case 351: 
            case 357: 
            case 362: 
            case 364: 
            case 365: 
            case 367: 
            case 370: 
            case 379: 
            case 380: 
            case 383: 
            case 384: 
            case 385: 
            case 388: 
            case 392: 
            case 393: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 399: 
            case 400: 
            case 401: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 416: 
            case 417: 
            case 418: 
            case 419: 
            case 425: 
            case 428: 
            case 431: 
            case 432: 
            case 434: 
            case 435: 
            case 436: 
            case 439: 
            case 455: 
            case 457: 
            case 458: 
            case 460: 
            case 461: 
            case 462: 
            case 465: 
            case 466: 
            case 467: 
            case 468: 
            case 469: 
            case 473: 
            case 474: 
            case 477: 
            case 478: 
            case 479: 
            case 480: 
            case 482: 
            case 488: 
            case 489: 
            case 490: 
            case 491: 
            case 493: 
            case 494: 
            case 495: 
            case 499: 
            case 500: 
            case 501: 
            case 504: 
            case 506: 
            case 507: 
            case 508: 
            case 509: 
            case 510: 
            case 511: 
            case 514: 
            case 518: 
            case 519: 
            case 523: 
            case 524: 
            case 526: 
            case 532: 
            case 533: 
            case 534: 
            case 535: 
            case 536: 
            case 537: 
            case 538: 
            case 539: 
            case 540: 
            case 541: 
            case 542: 
            case 543: 
            case 544: 
            case 545: 
            case 546: 
            case 547: 
            case 548: 
            case 549: 
            case 550: 
            case 551: 
            case 552: 
            case 553: 
            case 554: 
            case 555: 
            case 556: 
            case 557: 
            case 558: 
            case 559: 
            case 560: 
            case 561: 
            case 562: 
            case 563: 
            case 564: 
            case 565: 
            case 566: 
            case 567: 
            case 568: 
            case 569: 
            case 570: 
            case 571: 
            case 572: 
            case 573: 
            case 574: 
            case 575: 
            case 576: 
            case 577: 
            case 578: 
            case 579: 
            case 580: 
            case 583: 
            case 584: 
            case 589: 
            case 590: 
            case 591: 
            case 592: 
            case 595: 
            case 606: 
            case 608: 
            case 611: 
            case 613: 
            case 614: 
            case 616: 
            case 617: 
            case 618: 
            case 619: 
            case 624: 
            case 626: 
            case 627: 
            case 628: 
            case 629: 
            case 630: 
            case 631: 
            case 637: 
            case 638: 
            case 639: 
            case 645: 
            case 646: 
            case 648: 
            case 649: 
            case 650: 
            case 651: 
            case 655: 
            case 656: 
            case 661: 
            case 663: 
            case 664: 
            case 665: 
            case 666: 
            case 668: 
            case 669: 
            case 670: 
            case 679: 
            case 681: 
            case 683: 
            case 684: 
            case 693: 
            case 694: 
            case 695: 
            case 696: 
            case 698: 
            case 699: 
            case 763: 
            case 764: 
            case 765: 
            case 766: 
            case 767: 
            case 768: 
            case 770: {
                SqlIdentifier id = this.SimpleIdentifier();
                return new SqlNodeList(Collections.singletonList(id), id.getParserPosition());
            }
            case 715: {
                SqlNodeList list = this.ParenthesizedSimpleIdentifierList();
                return list;
            }
        }
        this.jj_la1[263] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SqlIdentifier CompoundIdentifier() throws ParseException {
        ArrayList<String> nameList = new ArrayList<String>();
        ArrayList<SqlParserPos> posList = new ArrayList<SqlParserPos>();
        boolean star = false;
        this.AddIdentifierSegment(nameList, posList);
        while (this.jj_2_72(2)) {
            this.jj_consume_token(726);
            this.AddIdentifierSegment(nameList, posList);
        }
        if (this.jj_2_73(2)) {
            this.jj_consume_token(726);
            this.jj_consume_token(739);
            star = true;
            nameList.add("");
            posList.add(this.getPos());
        }
        SqlParserPos pos = SqlParserPos.sum(posList);
        if (star) {
            return SqlIdentifier.star(nameList, pos, posList);
        }
        return new SqlIdentifier(nameList, null, pos, posList);
    }

    public final SqlIdentifier CompoundTableIdentifier() throws ParseException {
        ArrayList<String> nameList = new ArrayList<String>();
        ArrayList<SqlParserPos> posList = new ArrayList<SqlParserPos>();
        this.AddTableIdentifierSegment(nameList, posList);
        while (this.jj_2_74(2)) {
            this.jj_consume_token(726);
            this.AddTableIdentifierSegment(nameList, posList);
        }
        SqlParserPos pos = SqlParserPos.sum(posList);
        return new SqlIdentifier(nameList, null, pos, posList);
    }

    public final void AddCompoundIdentifierTypes(List<SqlNode> list, List<SqlNode> extendList) throws ParseException {
        this.AddCompoundIdentifierType(list, extendList);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 727: {
                    break;
                }
                default: {
                    this.jj_la1[264] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(727);
            this.AddCompoundIdentifierType(list, extendList);
        }
    }

    public final Pair<SqlNodeList, SqlNodeList> ParenthesizedCompoundIdentifierList() throws ParseException {
        ArrayList<SqlNode> list = new ArrayList<SqlNode>();
        ArrayList<SqlNode> extendList = new ArrayList<SqlNode>();
        this.jj_consume_token(715);
        Span s = this.span();
        this.AddCompoundIdentifierTypes(list, extendList);
        this.jj_consume_token(716);
        return Pair.of(new SqlNodeList(list, s.end(this)), new SqlNodeList(extendList, s.end(this)));
    }

    public final SqlNode NewSpecification() throws ParseException {
        this.jj_consume_token(352);
        Span s = this.span();
        SqlNode routineCall = this.NamedRoutineCall(SqlFunctionCategory.USER_DEFINED_CONSTRUCTOR, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        return SqlStdOperatorTable.NEW.createCall(s.end(routineCall), routineCall);
    }

    public final int UnsignedIntLiteral() throws ParseException {
        Token t = this.jj_consume_token(700);
        try {
            return Integer.parseInt(t.image);
        }
        catch (NumberFormatException ex) {
            throw SqlUtil.newContextException(this.getPos(), Static.RESOURCE.invalidLiteral(t.image, Integer.class.getCanonicalName()));
        }
    }

    public final int IntLiteral() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 700: 
            case 737: {
                Token t;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 700: {
                        t = this.jj_consume_token(700);
                        break;
                    }
                    case 737: {
                        this.jj_consume_token(737);
                        t = this.jj_consume_token(700);
                        break;
                    }
                    default: {
                        this.jj_la1[265] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                try {
                    return Integer.parseInt(t.image);
                }
                catch (NumberFormatException ex) {
                    throw SqlUtil.newContextException(this.getPos(), Static.RESOURCE.invalidLiteral(t.image, Integer.class.getCanonicalName()));
                }
            }
            case 738: {
                this.jj_consume_token(738);
                Token t = this.jj_consume_token(700);
                try {
                    return -Integer.parseInt(t.image);
                }
                catch (NumberFormatException ex) {
                    throw SqlUtil.newContextException(this.getPos(), Static.RESOURCE.invalidLiteral(t.image, Integer.class.getCanonicalName()));
                }
            }
        }
        this.jj_la1[266] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SqlDataTypeSpec DataType() throws ParseException {
        SqlTypeNameSpec typeName = this.TypeName();
        Span s = Span.of(typeName.getParserPos());
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 19: 
                case 342: {
                    break;
                }
                default: {
                    this.jj_la1[267] = this.jj_gen;
                    break block3;
                }
            }
            typeName = this.CollectionsTypeName(typeName);
        }
        return new SqlDataTypeSpec(typeName, s.add(typeName.getParserPos()).pos());
    }

    public final SqlTypeNameSpec TypeName() throws ParseException {
        SqlTypeNameSpec typeNameSpec;
        Span s = Span.of();
        if (this.jj_2_75(2)) {
            typeNameSpec = this.SqlTypeName(s);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 481: {
                    typeNameSpec = this.RowTypeName();
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 14: 
                case 17: 
                case 20: 
                case 21: 
                case 24: 
                case 26: 
                case 27: 
                case 31: 
                case 32: 
                case 35: 
                case 39: 
                case 47: 
                case 49: 
                case 53: 
                case 57: 
                case 58: 
                case 61: 
                case 62: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 74: 
                case 78: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 86: 
                case 87: 
                case 88: 
                case 90: 
                case 92: 
                case 93: 
                case 95: 
                case 96: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 104: 
                case 128: 
                case 130: 
                case 131: 
                case 133: 
                case 135: 
                case 136: 
                case 138: 
                case 141: 
                case 145: 
                case 146: 
                case 147: 
                case 149: 
                case 150: 
                case 151: 
                case 154: 
                case 156: 
                case 157: 
                case 159: 
                case 160: 
                case 162: 
                case 165: 
                case 167: 
                case 168: 
                case 170: 
                case 171: 
                case 174: 
                case 175: 
                case 180: 
                case 185: 
                case 187: 
                case 191: 
                case 192: 
                case 193: 
                case 205: 
                case 206: 
                case 210: 
                case 212: 
                case 214: 
                case 215: 
                case 216: 
                case 224: 
                case 225: 
                case 226: 
                case 227: 
                case 230: 
                case 231: 
                case 233: 
                case 235: 
                case 239: 
                case 241: 
                case 243: 
                case 245: 
                case 246: 
                case 247: 
                case 248: 
                case 249: 
                case 252: 
                case 253: 
                case 254: 
                case 257: 
                case 260: 
                case 263: 
                case 264: 
                case 271: 
                case 273: 
                case 274: 
                case 275: 
                case 276: 
                case 278: 
                case 286: 
                case 287: 
                case 288: 
                case 289: 
                case 290: 
                case 294: 
                case 300: 
                case 301: 
                case 302: 
                case 310: 
                case 312: 
                case 313: 
                case 315: 
                case 320: 
                case 324: 
                case 325: 
                case 326: 
                case 328: 
                case 329: 
                case 330: 
                case 333: 
                case 334: 
                case 340: 
                case 341: 
                case 343: 
                case 344: 
                case 345: 
                case 346: 
                case 351: 
                case 357: 
                case 362: 
                case 364: 
                case 365: 
                case 367: 
                case 370: 
                case 379: 
                case 380: 
                case 383: 
                case 384: 
                case 385: 
                case 388: 
                case 392: 
                case 393: 
                case 395: 
                case 396: 
                case 397: 
                case 398: 
                case 399: 
                case 400: 
                case 401: 
                case 403: 
                case 404: 
                case 405: 
                case 406: 
                case 407: 
                case 416: 
                case 417: 
                case 418: 
                case 419: 
                case 425: 
                case 428: 
                case 431: 
                case 432: 
                case 434: 
                case 435: 
                case 436: 
                case 439: 
                case 455: 
                case 457: 
                case 458: 
                case 460: 
                case 461: 
                case 462: 
                case 465: 
                case 466: 
                case 467: 
                case 468: 
                case 469: 
                case 473: 
                case 474: 
                case 477: 
                case 478: 
                case 479: 
                case 480: 
                case 482: 
                case 488: 
                case 489: 
                case 490: 
                case 491: 
                case 493: 
                case 494: 
                case 495: 
                case 499: 
                case 500: 
                case 501: 
                case 504: 
                case 506: 
                case 507: 
                case 508: 
                case 509: 
                case 510: 
                case 511: 
                case 514: 
                case 518: 
                case 519: 
                case 523: 
                case 524: 
                case 526: 
                case 532: 
                case 533: 
                case 534: 
                case 535: 
                case 536: 
                case 537: 
                case 538: 
                case 539: 
                case 540: 
                case 541: 
                case 542: 
                case 543: 
                case 544: 
                case 545: 
                case 546: 
                case 547: 
                case 548: 
                case 549: 
                case 550: 
                case 551: 
                case 552: 
                case 553: 
                case 554: 
                case 555: 
                case 556: 
                case 557: 
                case 558: 
                case 559: 
                case 560: 
                case 561: 
                case 562: 
                case 563: 
                case 564: 
                case 565: 
                case 566: 
                case 567: 
                case 568: 
                case 569: 
                case 570: 
                case 571: 
                case 572: 
                case 573: 
                case 574: 
                case 575: 
                case 576: 
                case 577: 
                case 578: 
                case 579: 
                case 580: 
                case 583: 
                case 584: 
                case 589: 
                case 590: 
                case 591: 
                case 592: 
                case 595: 
                case 606: 
                case 608: 
                case 611: 
                case 613: 
                case 614: 
                case 616: 
                case 617: 
                case 618: 
                case 619: 
                case 624: 
                case 626: 
                case 627: 
                case 628: 
                case 629: 
                case 630: 
                case 631: 
                case 637: 
                case 638: 
                case 639: 
                case 645: 
                case 646: 
                case 648: 
                case 649: 
                case 650: 
                case 651: 
                case 655: 
                case 656: 
                case 661: 
                case 663: 
                case 664: 
                case 665: 
                case 666: 
                case 668: 
                case 669: 
                case 670: 
                case 679: 
                case 681: 
                case 683: 
                case 684: 
                case 693: 
                case 694: 
                case 695: 
                case 696: 
                case 698: 
                case 699: 
                case 763: 
                case 764: 
                case 765: 
                case 766: 
                case 767: 
                case 768: 
                case 770: {
                    SqlIdentifier typeName = this.CompoundIdentifier();
                    typeNameSpec = new SqlUserDefinedTypeNameSpec(typeName, s.end(this));
                    break;
                }
                default: {
                    this.jj_la1[268] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return typeNameSpec;
    }

    public final SqlTypeNameSpec SqlTypeName(Span s) throws ParseException {
        SqlTypeNameSpec sqlTypeNameSpec;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 41: 
            case 45: 
            case 169: 
            case 208: 
            case 227: 
            case 265: 
            case 266: 
            case 441: 
            case 521: 
            case 622: {
                sqlTypeNameSpec = this.SqlTypeName1(s);
                break;
            }
            case 42: 
            case 676: {
                sqlTypeNameSpec = this.SqlTypeName2(s);
                break;
            }
            case 16: 
            case 140: 
            case 142: 
            case 366: {
                sqlTypeNameSpec = this.SqlTypeName3(s);
                break;
            }
            case 63: 
            case 65: 
            case 677: {
                sqlTypeNameSpec = this.CharacterTypeName(s);
                break;
            }
            case 132: 
            case 612: 
            case 615: {
                sqlTypeNameSpec = this.DateTimeTypeName();
                break;
            }
            default: {
                this.jj_la1[269] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return sqlTypeNameSpec;
    }

    public final SqlTypeNameSpec SqlTypeName1(Span s) throws ParseException {
        SqlTypeName sqlTypeName;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 227: {
                this.jj_consume_token(227);
                if (!this.conformance.allowGeometry()) {
                    throw SqlUtil.newContextException(this.getPos(), Static.RESOURCE.geometryDisabled());
                }
                s.add(this);
                sqlTypeName = SqlTypeName.GEOMETRY;
                break;
            }
            case 45: {
                this.jj_consume_token(45);
                s.add(this);
                sqlTypeName = SqlTypeName.BOOLEAN;
                break;
            }
            case 265: 
            case 266: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 266: {
                        this.jj_consume_token(266);
                        break;
                    }
                    case 265: {
                        this.jj_consume_token(265);
                        break;
                    }
                    default: {
                        this.jj_la1[270] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                s.add(this);
                sqlTypeName = SqlTypeName.INTEGER;
                break;
            }
            case 622: {
                this.jj_consume_token(622);
                s.add(this);
                sqlTypeName = SqlTypeName.TINYINT;
                break;
            }
            case 521: {
                this.jj_consume_token(521);
                s.add(this);
                sqlTypeName = SqlTypeName.SMALLINT;
                break;
            }
            case 41: {
                this.jj_consume_token(41);
                s.add(this);
                sqlTypeName = SqlTypeName.BIGINT;
                break;
            }
            case 441: {
                this.jj_consume_token(441);
                s.add(this);
                sqlTypeName = SqlTypeName.REAL;
                break;
            }
            case 169: {
                this.jj_consume_token(169);
                s.add(this);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 426: {
                        this.jj_consume_token(426);
                        break;
                    }
                    default: {
                        this.jj_la1[271] = this.jj_gen;
                    }
                }
                sqlTypeName = SqlTypeName.DOUBLE;
                break;
            }
            case 208: {
                this.jj_consume_token(208);
                s.add(this);
                sqlTypeName = SqlTypeName.FLOAT;
                break;
            }
            default: {
                this.jj_la1[272] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return new SqlBasicTypeNameSpec(sqlTypeName, s.end(this));
    }

    public final SqlTypeNameSpec SqlTypeName2(Span s) throws ParseException {
        SqlTypeName sqlTypeName;
        int precision = -1;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 42: {
                this.jj_consume_token(42);
                s.add(this);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 678: {
                        this.jj_consume_token(678);
                        sqlTypeName = SqlTypeName.VARBINARY;
                        break block0;
                    }
                }
                this.jj_la1[273] = this.jj_gen;
                sqlTypeName = SqlTypeName.BINARY;
                break;
            }
            case 676: {
                this.jj_consume_token(676);
                s.add(this);
                sqlTypeName = SqlTypeName.VARBINARY;
                break;
            }
            default: {
                this.jj_la1[274] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        precision = this.PrecisionOpt();
        return new SqlBasicTypeNameSpec(sqlTypeName, precision, s.end(this));
    }

    public final SqlTypeNameSpec SqlTypeName3(Span s) throws ParseException {
        SqlTypeName sqlTypeName;
        int precision = -1;
        int scale = -1;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 140: 
            case 142: 
            case 366: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 142: {
                        this.jj_consume_token(142);
                        break;
                    }
                    case 140: {
                        this.jj_consume_token(140);
                        break;
                    }
                    case 366: {
                        this.jj_consume_token(366);
                        break;
                    }
                    default: {
                        this.jj_la1[275] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                s.add(this);
                sqlTypeName = SqlTypeName.DECIMAL;
                break;
            }
            case 16: {
                this.jj_consume_token(16);
                s.add(this);
                sqlTypeName = SqlTypeName.ANY;
                break;
            }
            default: {
                this.jj_la1[276] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 715: {
                this.jj_consume_token(715);
                precision = this.UnsignedIntLiteral();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 727: {
                        this.jj_consume_token(727);
                        scale = this.UnsignedIntLiteral();
                        break;
                    }
                    default: {
                        this.jj_la1[277] = this.jj_gen;
                    }
                }
                this.jj_consume_token(716);
                break;
            }
            default: {
                this.jj_la1[278] = this.jj_gen;
            }
        }
        return new SqlBasicTypeNameSpec(sqlTypeName, precision, scale, s.end(this));
    }

    public final SqlJdbcDataTypeName JdbcOdbcDataTypeName() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 63: 
            case 537: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 537: {
                        this.jj_consume_token(537);
                        break;
                    }
                    case 63: {
                        this.jj_consume_token(63);
                        break;
                    }
                    default: {
                        this.jj_la1[279] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return SqlJdbcDataTypeName.SQL_CHAR;
            }
            case 580: 
            case 677: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 580: {
                        this.jj_consume_token(580);
                        break;
                    }
                    case 677: {
                        this.jj_consume_token(677);
                        break;
                    }
                    default: {
                        this.jj_la1[280] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return SqlJdbcDataTypeName.SQL_VARCHAR;
            }
            case 132: 
            case 539: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 539: {
                        this.jj_consume_token(539);
                        break;
                    }
                    case 132: {
                        this.jj_consume_token(132);
                        break;
                    }
                    default: {
                        this.jj_la1[281] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return SqlJdbcDataTypeName.SQL_DATE;
            }
            case 566: 
            case 612: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 566: {
                        this.jj_consume_token(566);
                        break;
                    }
                    case 612: {
                        this.jj_consume_token(612);
                        break;
                    }
                    default: {
                        this.jj_la1[282] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return SqlJdbcDataTypeName.SQL_TIME;
            }
            case 567: 
            case 615: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 567: {
                        this.jj_consume_token(567);
                        break;
                    }
                    case 615: {
                        this.jj_consume_token(615);
                        break;
                    }
                    default: {
                        this.jj_la1[283] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return SqlJdbcDataTypeName.SQL_TIMESTAMP;
            }
            case 142: 
            case 540: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 540: {
                        this.jj_consume_token(540);
                        break;
                    }
                    case 142: {
                        this.jj_consume_token(142);
                        break;
                    }
                    default: {
                        this.jj_la1[284] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return SqlJdbcDataTypeName.SQL_DECIMAL;
            }
            case 366: 
            case 562: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 562: {
                        this.jj_consume_token(562);
                        break;
                    }
                    case 366: {
                        this.jj_consume_token(366);
                        break;
                    }
                    default: {
                        this.jj_la1[285] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return SqlJdbcDataTypeName.SQL_NUMERIC;
            }
            case 45: 
            case 536: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 536: {
                        this.jj_consume_token(536);
                        break;
                    }
                    case 45: {
                        this.jj_consume_token(45);
                        break;
                    }
                    default: {
                        this.jj_la1[286] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return SqlJdbcDataTypeName.SQL_BOOLEAN;
            }
            case 266: 
            case 543: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 543: {
                        this.jj_consume_token(543);
                        break;
                    }
                    case 266: {
                        this.jj_consume_token(266);
                        break;
                    }
                    default: {
                        this.jj_la1[287] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return SqlJdbcDataTypeName.SQL_INTEGER;
            }
            case 42: 
            case 533: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 533: {
                        this.jj_consume_token(533);
                        break;
                    }
                    case 42: {
                        this.jj_consume_token(42);
                        break;
                    }
                    default: {
                        this.jj_la1[288] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return SqlJdbcDataTypeName.SQL_BINARY;
            }
            case 579: 
            case 676: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 579: {
                        this.jj_consume_token(579);
                        break;
                    }
                    case 676: {
                        this.jj_consume_token(676);
                        break;
                    }
                    default: {
                        this.jj_la1[289] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return SqlJdbcDataTypeName.SQL_VARBINARY;
            }
            case 568: 
            case 622: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 568: {
                        this.jj_consume_token(568);
                        break;
                    }
                    case 622: {
                        this.jj_consume_token(622);
                        break;
                    }
                    default: {
                        this.jj_la1[290] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return SqlJdbcDataTypeName.SQL_TINYINT;
            }
            case 521: 
            case 565: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 565: {
                        this.jj_consume_token(565);
                        break;
                    }
                    case 521: {
                        this.jj_consume_token(521);
                        break;
                    }
                    default: {
                        this.jj_la1[291] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return SqlJdbcDataTypeName.SQL_SMALLINT;
            }
            case 41: 
            case 532: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 532: {
                        this.jj_consume_token(532);
                        break;
                    }
                    case 41: {
                        this.jj_consume_token(41);
                        break;
                    }
                    default: {
                        this.jj_la1[292] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return SqlJdbcDataTypeName.SQL_BIGINT;
            }
            case 441: 
            case 564: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 564: {
                        this.jj_consume_token(564);
                        break;
                    }
                    case 441: {
                        this.jj_consume_token(441);
                        break;
                    }
                    default: {
                        this.jj_la1[293] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return SqlJdbcDataTypeName.SQL_REAL;
            }
            case 169: 
            case 541: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 541: {
                        this.jj_consume_token(541);
                        break;
                    }
                    case 169: {
                        this.jj_consume_token(169);
                        break;
                    }
                    default: {
                        this.jj_la1[294] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return SqlJdbcDataTypeName.SQL_DOUBLE;
            }
            case 208: 
            case 542: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 542: {
                        this.jj_consume_token(542);
                        break;
                    }
                    case 208: {
                        this.jj_consume_token(208);
                        break;
                    }
                    default: {
                        this.jj_la1[295] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return SqlJdbcDataTypeName.SQL_FLOAT;
            }
            case 555: {
                this.jj_consume_token(555);
                return SqlJdbcDataTypeName.SQL_INTERVAL_YEAR;
            }
            case 556: {
                this.jj_consume_token(556);
                return SqlJdbcDataTypeName.SQL_INTERVAL_YEAR_TO_MONTH;
            }
            case 553: {
                this.jj_consume_token(553);
                return SqlJdbcDataTypeName.SQL_INTERVAL_MONTH;
            }
            case 544: {
                this.jj_consume_token(544);
                return SqlJdbcDataTypeName.SQL_INTERVAL_DAY;
            }
            case 545: {
                this.jj_consume_token(545);
                return SqlJdbcDataTypeName.SQL_INTERVAL_DAY_TO_HOUR;
            }
            case 546: {
                this.jj_consume_token(546);
                return SqlJdbcDataTypeName.SQL_INTERVAL_DAY_TO_MINUTE;
            }
            case 547: {
                this.jj_consume_token(547);
                return SqlJdbcDataTypeName.SQL_INTERVAL_DAY_TO_SECOND;
            }
            case 548: {
                this.jj_consume_token(548);
                return SqlJdbcDataTypeName.SQL_INTERVAL_HOUR;
            }
            case 549: {
                this.jj_consume_token(549);
                return SqlJdbcDataTypeName.SQL_INTERVAL_HOUR_TO_MINUTE;
            }
            case 550: {
                this.jj_consume_token(550);
                return SqlJdbcDataTypeName.SQL_INTERVAL_HOUR_TO_SECOND;
            }
            case 551: {
                this.jj_consume_token(551);
                return SqlJdbcDataTypeName.SQL_INTERVAL_MINUTE;
            }
            case 552: {
                this.jj_consume_token(552);
                return SqlJdbcDataTypeName.SQL_INTERVAL_MINUTE_TO_SECOND;
            }
            case 554: {
                this.jj_consume_token(554);
                return SqlJdbcDataTypeName.SQL_INTERVAL_SECOND;
            }
        }
        this.jj_la1[296] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SqlLiteral JdbcOdbcDataType() throws ParseException {
        SqlJdbcDataTypeName typeName = this.JdbcOdbcDataTypeName();
        return typeName.symbol(this.getPos());
    }

    public final SqlTypeNameSpec CollectionsTypeName(SqlTypeNameSpec elementTypeName) throws ParseException {
        SqlTypeName collectionTypeName;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 342: {
                this.jj_consume_token(342);
                collectionTypeName = SqlTypeName.MULTISET;
                break;
            }
            case 19: {
                this.jj_consume_token(19);
                collectionTypeName = SqlTypeName.ARRAY;
                break;
            }
            default: {
                this.jj_la1[297] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return new SqlCollectionTypeNameSpec(elementTypeName, collectionTypeName, this.getPos());
    }

    public final boolean NullableOptDefaultTrue() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 361: {
                this.jj_consume_token(361);
                return true;
            }
            case 358: {
                this.jj_consume_token(358);
                this.jj_consume_token(361);
                return false;
            }
        }
        this.jj_la1[298] = this.jj_gen;
        return true;
    }

    public final boolean NullableOptDefaultFalse() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 361: {
                this.jj_consume_token(361);
                return true;
            }
            case 358: {
                this.jj_consume_token(358);
                this.jj_consume_token(361);
                return false;
            }
        }
        this.jj_la1[299] = this.jj_gen;
        return false;
    }

    public final boolean NotNullOpt() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 358: {
                this.jj_consume_token(358);
                this.jj_consume_token(361);
                return false;
            }
        }
        this.jj_la1[300] = this.jj_gen;
        return true;
    }

    public final void AddFieldNameTypes(List<SqlIdentifier> fieldNames, List<SqlDataTypeSpec> fieldTypes) throws ParseException {
        this.AddFieldNameType(fieldNames, fieldTypes);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 727: {
                    break;
                }
                default: {
                    this.jj_la1[301] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(727);
            this.AddFieldNameType(fieldNames, fieldTypes);
        }
    }

    public final void AddFieldNameType(List<SqlIdentifier> fieldNames, List<SqlDataTypeSpec> fieldTypes) throws ParseException {
        SqlIdentifier fName = this.SimpleIdentifier();
        SqlDataTypeSpec fType = this.DataType();
        boolean nullable = this.NullableOptDefaultFalse();
        fieldNames.add(fName);
        fieldTypes.add(fType.withNullable(nullable, this.getPos()));
    }

    public final SqlTypeNameSpec RowTypeName() throws ParseException {
        ArrayList<SqlIdentifier> fieldNames = new ArrayList<SqlIdentifier>();
        ArrayList<SqlDataTypeSpec> fieldTypes = new ArrayList<SqlDataTypeSpec>();
        this.jj_consume_token(481);
        this.jj_consume_token(715);
        this.AddFieldNameTypes(fieldNames, fieldTypes);
        this.jj_consume_token(716);
        return new SqlRowTypeNameSpec(this.getPos(), fieldNames, fieldTypes);
    }

    public final SqlTypeNameSpec CharacterTypeName(Span s) throws ParseException {
        SqlTypeName sqlTypeName;
        int precision = -1;
        String charSetName = null;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 63: 
            case 65: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 65: {
                        this.jj_consume_token(65);
                        break;
                    }
                    case 63: {
                        this.jj_consume_token(63);
                        break;
                    }
                    default: {
                        this.jj_la1[302] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                s.add(this);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 678: {
                        this.jj_consume_token(678);
                        sqlTypeName = SqlTypeName.VARCHAR;
                        break block0;
                    }
                }
                this.jj_la1[303] = this.jj_gen;
                sqlTypeName = SqlTypeName.CHAR;
                break;
            }
            case 677: {
                this.jj_consume_token(677);
                s.add(this);
                sqlTypeName = SqlTypeName.VARCHAR;
                break;
            }
            default: {
                this.jj_la1[304] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        precision = this.PrecisionOpt();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 65: {
                this.jj_consume_token(65);
                this.jj_consume_token(513);
                charSetName = this.Identifier();
                break;
            }
            default: {
                this.jj_la1[305] = this.jj_gen;
            }
        }
        return new SqlBasicTypeNameSpec(sqlTypeName, precision, charSetName, s.end(this));
    }

    public final SqlTypeNameSpec DateTimeTypeName() throws ParseException {
        int precision = -1;
        boolean withLocalTimeZone = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 132: {
                this.jj_consume_token(132);
                SqlTypeName typeName = SqlTypeName.DATE;
                return new SqlBasicTypeNameSpec(typeName, this.getPos());
            }
        }
        this.jj_la1[306] = this.jj_gen;
        if (this.jj_2_76(2)) {
            this.jj_consume_token(612);
            Span s = this.span();
            precision = this.PrecisionOpt();
            withLocalTimeZone = this.TimeZoneOpt();
            SqlTypeName typeName = withLocalTimeZone ? SqlTypeName.TIME_WITH_LOCAL_TIME_ZONE : SqlTypeName.TIME;
            return new SqlBasicTypeNameSpec(typeName, precision, s.end(this));
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 615: {
                this.jj_consume_token(615);
                Span s = this.span();
                precision = this.PrecisionOpt();
                withLocalTimeZone = this.TimeZoneOpt();
                SqlTypeName typeName = withLocalTimeZone ? SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE : SqlTypeName.TIMESTAMP;
                return new SqlBasicTypeNameSpec(typeName, precision, s.end(this));
            }
        }
        this.jj_la1[307] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final int PrecisionOpt() throws ParseException {
        int precision = -1;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 715: {
                this.jj_consume_token(715);
                precision = this.UnsignedIntLiteral();
                this.jj_consume_token(716);
                return precision;
            }
        }
        this.jj_la1[308] = this.jj_gen;
        return -1;
    }

    public final boolean TimeZoneOpt() throws ParseException {
        if (this.jj_2_77(3)) {
            this.jj_consume_token(692);
            this.jj_consume_token(612);
            this.jj_consume_token(699);
            return false;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 690: {
                this.jj_consume_token(690);
                this.jj_consume_token(307);
                this.jj_consume_token(612);
                this.jj_consume_token(699);
                return true;
            }
        }
        this.jj_la1[309] = this.jj_gen;
        return false;
    }

    public final SqlNode CursorExpression(SqlAbstractParserImpl.ExprContext exprContext) throws ParseException {
        this.jj_consume_token(127);
        Span s = this.span();
        if (exprContext != SqlAbstractParserImpl.ExprContext.ACCEPT_ALL && exprContext != SqlAbstractParserImpl.ExprContext.ACCEPT_CURSOR) {
            throw SqlUtil.newContextException(s.end(this), Static.RESOURCE.illegalCursorExpression());
        }
        SqlNode e = this.Expression(SqlAbstractParserImpl.ExprContext.ACCEPT_QUERY);
        return SqlStdOperatorTable.CURSOR.createCall(s.end(e), e);
    }

    public final SqlNode BuiltinFunctionCall() throws ParseException {
        ArrayList<SqlNode> args = new ArrayList<SqlNode>();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 56: {
                this.jj_consume_token(56);
                Span s = this.span();
                this.jj_consume_token(715);
                this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                this.jj_consume_token(23);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 14: 
                    case 16: 
                    case 17: 
                    case 20: 
                    case 21: 
                    case 24: 
                    case 26: 
                    case 27: 
                    case 31: 
                    case 32: 
                    case 35: 
                    case 39: 
                    case 41: 
                    case 42: 
                    case 45: 
                    case 47: 
                    case 49: 
                    case 53: 
                    case 57: 
                    case 58: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 65: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 74: 
                    case 78: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 86: 
                    case 87: 
                    case 88: 
                    case 90: 
                    case 92: 
                    case 93: 
                    case 95: 
                    case 96: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 104: 
                    case 128: 
                    case 130: 
                    case 131: 
                    case 132: 
                    case 133: 
                    case 135: 
                    case 136: 
                    case 138: 
                    case 140: 
                    case 141: 
                    case 142: 
                    case 145: 
                    case 146: 
                    case 147: 
                    case 149: 
                    case 150: 
                    case 151: 
                    case 154: 
                    case 156: 
                    case 157: 
                    case 159: 
                    case 160: 
                    case 162: 
                    case 165: 
                    case 167: 
                    case 168: 
                    case 169: 
                    case 170: 
                    case 171: 
                    case 174: 
                    case 175: 
                    case 180: 
                    case 185: 
                    case 187: 
                    case 191: 
                    case 192: 
                    case 193: 
                    case 205: 
                    case 206: 
                    case 208: 
                    case 210: 
                    case 212: 
                    case 214: 
                    case 215: 
                    case 216: 
                    case 224: 
                    case 225: 
                    case 226: 
                    case 227: 
                    case 230: 
                    case 231: 
                    case 233: 
                    case 235: 
                    case 239: 
                    case 241: 
                    case 243: 
                    case 245: 
                    case 246: 
                    case 247: 
                    case 248: 
                    case 249: 
                    case 252: 
                    case 253: 
                    case 254: 
                    case 257: 
                    case 260: 
                    case 263: 
                    case 264: 
                    case 265: 
                    case 266: 
                    case 271: 
                    case 273: 
                    case 274: 
                    case 275: 
                    case 276: 
                    case 278: 
                    case 286: 
                    case 287: 
                    case 288: 
                    case 289: 
                    case 290: 
                    case 294: 
                    case 300: 
                    case 301: 
                    case 302: 
                    case 310: 
                    case 312: 
                    case 313: 
                    case 315: 
                    case 320: 
                    case 324: 
                    case 325: 
                    case 326: 
                    case 328: 
                    case 329: 
                    case 330: 
                    case 333: 
                    case 334: 
                    case 340: 
                    case 341: 
                    case 343: 
                    case 344: 
                    case 345: 
                    case 346: 
                    case 351: 
                    case 357: 
                    case 362: 
                    case 364: 
                    case 365: 
                    case 366: 
                    case 367: 
                    case 370: 
                    case 379: 
                    case 380: 
                    case 383: 
                    case 384: 
                    case 385: 
                    case 388: 
                    case 392: 
                    case 393: 
                    case 395: 
                    case 396: 
                    case 397: 
                    case 398: 
                    case 399: 
                    case 400: 
                    case 401: 
                    case 403: 
                    case 404: 
                    case 405: 
                    case 406: 
                    case 407: 
                    case 416: 
                    case 417: 
                    case 418: 
                    case 419: 
                    case 425: 
                    case 428: 
                    case 431: 
                    case 432: 
                    case 434: 
                    case 435: 
                    case 436: 
                    case 439: 
                    case 441: 
                    case 455: 
                    case 457: 
                    case 458: 
                    case 460: 
                    case 461: 
                    case 462: 
                    case 465: 
                    case 466: 
                    case 467: 
                    case 468: 
                    case 469: 
                    case 473: 
                    case 474: 
                    case 477: 
                    case 478: 
                    case 479: 
                    case 480: 
                    case 481: 
                    case 482: 
                    case 488: 
                    case 489: 
                    case 490: 
                    case 491: 
                    case 493: 
                    case 494: 
                    case 495: 
                    case 499: 
                    case 500: 
                    case 501: 
                    case 504: 
                    case 506: 
                    case 507: 
                    case 508: 
                    case 509: 
                    case 510: 
                    case 511: 
                    case 514: 
                    case 518: 
                    case 519: 
                    case 521: 
                    case 523: 
                    case 524: 
                    case 526: 
                    case 532: 
                    case 533: 
                    case 534: 
                    case 535: 
                    case 536: 
                    case 537: 
                    case 538: 
                    case 539: 
                    case 540: 
                    case 541: 
                    case 542: 
                    case 543: 
                    case 544: 
                    case 545: 
                    case 546: 
                    case 547: 
                    case 548: 
                    case 549: 
                    case 550: 
                    case 551: 
                    case 552: 
                    case 553: 
                    case 554: 
                    case 555: 
                    case 556: 
                    case 557: 
                    case 558: 
                    case 559: 
                    case 560: 
                    case 561: 
                    case 562: 
                    case 563: 
                    case 564: 
                    case 565: 
                    case 566: 
                    case 567: 
                    case 568: 
                    case 569: 
                    case 570: 
                    case 571: 
                    case 572: 
                    case 573: 
                    case 574: 
                    case 575: 
                    case 576: 
                    case 577: 
                    case 578: 
                    case 579: 
                    case 580: 
                    case 583: 
                    case 584: 
                    case 589: 
                    case 590: 
                    case 591: 
                    case 592: 
                    case 595: 
                    case 606: 
                    case 608: 
                    case 611: 
                    case 612: 
                    case 613: 
                    case 614: 
                    case 615: 
                    case 616: 
                    case 617: 
                    case 618: 
                    case 619: 
                    case 622: 
                    case 624: 
                    case 626: 
                    case 627: 
                    case 628: 
                    case 629: 
                    case 630: 
                    case 631: 
                    case 637: 
                    case 638: 
                    case 639: 
                    case 645: 
                    case 646: 
                    case 648: 
                    case 649: 
                    case 650: 
                    case 651: 
                    case 655: 
                    case 656: 
                    case 661: 
                    case 663: 
                    case 664: 
                    case 665: 
                    case 666: 
                    case 668: 
                    case 669: 
                    case 670: 
                    case 676: 
                    case 677: 
                    case 679: 
                    case 681: 
                    case 683: 
                    case 684: 
                    case 693: 
                    case 694: 
                    case 695: 
                    case 696: 
                    case 698: 
                    case 699: 
                    case 763: 
                    case 764: 
                    case 765: 
                    case 766: 
                    case 767: 
                    case 768: 
                    case 770: {
                        SqlDataTypeSpec dt = this.DataType();
                        args.add(dt);
                        break;
                    }
                    case 269: {
                        this.jj_consume_token(269);
                        SqlIntervalQualifier e = this.IntervalQualifier();
                        args.add(e);
                        break;
                    }
                    default: {
                        this.jj_la1[310] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_consume_token(716);
                return SqlStdOperatorTable.CAST.createCall(s.end(this), args);
            }
            case 201: {
                this.jj_consume_token(201);
                Span s = this.span();
                this.jj_consume_token(715);
                SqlIntervalQualifier unit = this.TimeUnitOrName();
                args.add(unit);
                this.jj_consume_token(220);
                this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                this.jj_consume_token(716);
                return SqlStdOperatorTable.EXTRACT.createCall(s.end(this), args);
            }
            case 421: {
                this.jj_consume_token(421);
                Span s = this.span();
                this.jj_consume_token(715);
                SqlNode e = this.AtomicRowExpression();
                args.add(e);
                this.jj_consume_token(251);
                this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 220: {
                        this.jj_consume_token(220);
                        this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                        break;
                    }
                    default: {
                        this.jj_la1[311] = this.jj_gen;
                    }
                }
                this.jj_consume_token(716);
                return SqlStdOperatorTable.POSITION.createCall(s.end(this), args);
            }
            case 105: {
                this.jj_consume_token(105);
                Span s = this.span();
                this.jj_consume_token(715);
                this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                this.jj_consume_token(667);
                SqlIdentifier name = this.SimpleIdentifier();
                args.add(name);
                this.jj_consume_token(716);
                return SqlStdOperatorTable.CONVERT.createCall(s.end(this), args);
            }
            case 632: {
                this.jj_consume_token(632);
                Span s = this.span();
                this.jj_consume_token(715);
                this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 667: {
                        this.jj_consume_token(667);
                        SqlIdentifier name = this.SimpleIdentifier();
                        args.add(name);
                        this.jj_consume_token(716);
                        return SqlStdOperatorTable.TRANSLATE.createCall(s.end(this), args);
                    }
                    case 716: 
                    case 727: {
                        block75: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 727: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[312] = this.jj_gen;
                                    break block75;
                                }
                            }
                            this.jj_consume_token(727);
                            this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                        }
                        this.jj_consume_token(716);
                        return SqlLibraryOperators.TRANSLATE3.createCall(s.end(this), args);
                    }
                }
                this.jj_la1[313] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 391: {
                this.jj_consume_token(391);
                Span s = this.span();
                this.jj_consume_token(715);
                this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                this.jj_consume_token(417);
                this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                this.jj_consume_token(220);
                this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 211: {
                        this.jj_consume_token(211);
                        this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                        break;
                    }
                    default: {
                        this.jj_la1[314] = this.jj_gen;
                    }
                }
                this.jj_consume_token(716);
                return SqlStdOperatorTable.OVERLAY.createCall(s.end(this), args);
            }
            case 209: {
                this.jj_consume_token(209);
                Span s = this.span();
                SqlNode e = this.FloorCeilOptions(s, true);
                return e;
            }
            case 59: 
            case 60: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 59: {
                        this.jj_consume_token(59);
                        break;
                    }
                    case 60: {
                        this.jj_consume_token(60);
                        break;
                    }
                    default: {
                        this.jj_la1[315] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                Span s = this.span();
                SqlNode e = this.FloorCeilOptions(s, false);
                return e;
            }
            case 596: {
                this.jj_consume_token(596);
                Span s = this.span();
                this.jj_consume_token(715);
                this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 220: {
                        this.jj_consume_token(220);
                        break;
                    }
                    case 727: {
                        this.jj_consume_token(727);
                        break;
                    }
                    default: {
                        this.jj_la1[316] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 211: 
                    case 727: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 211: {
                                this.jj_consume_token(211);
                                break;
                            }
                            case 727: {
                                this.jj_consume_token(727);
                                break;
                            }
                            default: {
                                this.jj_la1[317] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                        break;
                    }
                    default: {
                        this.jj_la1[318] = this.jj_gen;
                    }
                }
                this.jj_consume_token(716);
                return SqlStdOperatorTable.SUBSTRING.createCall(s.end(this), args);
            }
            case 640: {
                this.jj_consume_token(640);
                SqlLiteral flag = null;
                SqlNode trimChars = null;
                Span s = this.span();
                this.jj_consume_token(715);
                if (this.jj_2_78(2)) {
                    block60 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 46: 
                        case 298: 
                        case 625: {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 46: {
                                    this.jj_consume_token(46);
                                    s.add(this);
                                    flag = SqlTrimFunction.Flag.BOTH.symbol(this.getPos());
                                    break block60;
                                }
                                case 625: {
                                    this.jj_consume_token(625);
                                    s.add(this);
                                    flag = SqlTrimFunction.Flag.TRAILING.symbol(this.getPos());
                                    break block60;
                                }
                                case 298: {
                                    this.jj_consume_token(298);
                                    s.add(this);
                                    flag = SqlTrimFunction.Flag.LEADING.symbol(this.getPos());
                                    break block60;
                                }
                            }
                            this.jj_la1[319] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                        default: {
                            this.jj_la1[320] = this.jj_gen;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 14: 
                        case 17: 
                        case 19: 
                        case 20: 
                        case 21: 
                        case 24: 
                        case 26: 
                        case 27: 
                        case 31: 
                        case 32: 
                        case 34: 
                        case 35: 
                        case 39: 
                        case 47: 
                        case 49: 
                        case 52: 
                        case 53: 
                        case 55: 
                        case 56: 
                        case 57: 
                        case 58: 
                        case 59: 
                        case 60: 
                        case 61: 
                        case 62: 
                        case 63: 
                        case 64: 
                        case 66: 
                        case 67: 
                        case 68: 
                        case 69: 
                        case 70: 
                        case 71: 
                        case 73: 
                        case 74: 
                        case 77: 
                        case 78: 
                        case 80: 
                        case 81: 
                        case 82: 
                        case 83: 
                        case 84: 
                        case 86: 
                        case 87: 
                        case 88: 
                        case 90: 
                        case 92: 
                        case 93: 
                        case 95: 
                        case 96: 
                        case 98: 
                        case 99: 
                        case 100: 
                        case 101: 
                        case 102: 
                        case 104: 
                        case 105: 
                        case 108: 
                        case 109: 
                        case 110: 
                        case 114: 
                        case 115: 
                        case 116: 
                        case 117: 
                        case 118: 
                        case 119: 
                        case 120: 
                        case 122: 
                        case 123: 
                        case 124: 
                        case 126: 
                        case 127: 
                        case 128: 
                        case 130: 
                        case 131: 
                        case 132: 
                        case 133: 
                        case 134: 
                        case 135: 
                        case 136: 
                        case 138: 
                        case 141: 
                        case 145: 
                        case 146: 
                        case 147: 
                        case 149: 
                        case 150: 
                        case 151: 
                        case 153: 
                        case 154: 
                        case 156: 
                        case 157: 
                        case 159: 
                        case 160: 
                        case 162: 
                        case 165: 
                        case 167: 
                        case 168: 
                        case 170: 
                        case 171: 
                        case 174: 
                        case 175: 
                        case 177: 
                        case 180: 
                        case 185: 
                        case 187: 
                        case 189: 
                        case 191: 
                        case 192: 
                        case 193: 
                        case 196: 
                        case 197: 
                        case 201: 
                        case 202: 
                        case 205: 
                        case 206: 
                        case 207: 
                        case 209: 
                        case 210: 
                        case 212: 
                        case 214: 
                        case 215: 
                        case 216: 
                        case 223: 
                        case 224: 
                        case 225: 
                        case 226: 
                        case 227: 
                        case 230: 
                        case 231: 
                        case 233: 
                        case 235: 
                        case 236: 
                        case 239: 
                        case 241: 
                        case 242: 
                        case 243: 
                        case 245: 
                        case 246: 
                        case 247: 
                        case 248: 
                        case 249: 
                        case 252: 
                        case 253: 
                        case 254: 
                        case 257: 
                        case 260: 
                        case 263: 
                        case 264: 
                        case 268: 
                        case 269: 
                        case 271: 
                        case 273: 
                        case 274: 
                        case 275: 
                        case 276: 
                        case 278: 
                        case 279: 
                        case 280: 
                        case 281: 
                        case 282: 
                        case 283: 
                        case 284: 
                        case 285: 
                        case 286: 
                        case 287: 
                        case 288: 
                        case 289: 
                        case 290: 
                        case 291: 
                        case 294: 
                        case 295: 
                        case 297: 
                        case 299: 
                        case 300: 
                        case 301: 
                        case 302: 
                        case 306: 
                        case 308: 
                        case 309: 
                        case 310: 
                        case 311: 
                        case 312: 
                        case 313: 
                        case 315: 
                        case 317: 
                        case 319: 
                        case 320: 
                        case 324: 
                        case 325: 
                        case 326: 
                        case 328: 
                        case 329: 
                        case 330: 
                        case 331: 
                        case 332: 
                        case 333: 
                        case 334: 
                        case 335: 
                        case 339: 
                        case 340: 
                        case 341: 
                        case 342: 
                        case 343: 
                        case 344: 
                        case 345: 
                        case 346: 
                        case 351: 
                        case 352: 
                        case 353: 
                        case 357: 
                        case 358: 
                        case 359: 
                        case 360: 
                        case 361: 
                        case 362: 
                        case 363: 
                        case 364: 
                        case 365: 
                        case 367: 
                        case 369: 
                        case 370: 
                        case 379: 
                        case 380: 
                        case 383: 
                        case 384: 
                        case 385: 
                        case 388: 
                        case 391: 
                        case 392: 
                        case 393: 
                        case 395: 
                        case 396: 
                        case 397: 
                        case 398: 
                        case 399: 
                        case 400: 
                        case 401: 
                        case 403: 
                        case 404: 
                        case 405: 
                        case 406: 
                        case 407: 
                        case 411: 
                        case 412: 
                        case 413: 
                        case 414: 
                        case 416: 
                        case 417: 
                        case 418: 
                        case 419: 
                        case 421: 
                        case 423: 
                        case 425: 
                        case 428: 
                        case 429: 
                        case 431: 
                        case 432: 
                        case 434: 
                        case 435: 
                        case 436: 
                        case 438: 
                        case 439: 
                        case 448: 
                        case 452: 
                        case 454: 
                        case 455: 
                        case 457: 
                        case 458: 
                        case 460: 
                        case 461: 
                        case 462: 
                        case 465: 
                        case 466: 
                        case 467: 
                        case 468: 
                        case 469: 
                        case 472: 
                        case 473: 
                        case 474: 
                        case 477: 
                        case 478: 
                        case 479: 
                        case 480: 
                        case 481: 
                        case 482: 
                        case 483: 
                        case 485: 
                        case 488: 
                        case 489: 
                        case 490: 
                        case 491: 
                        case 493: 
                        case 494: 
                        case 495: 
                        case 498: 
                        case 499: 
                        case 500: 
                        case 501: 
                        case 504: 
                        case 506: 
                        case 507: 
                        case 508: 
                        case 509: 
                        case 510: 
                        case 511: 
                        case 512: 
                        case 514: 
                        case 518: 
                        case 519: 
                        case 522: 
                        case 523: 
                        case 524: 
                        case 525: 
                        case 526: 
                        case 532: 
                        case 533: 
                        case 534: 
                        case 535: 
                        case 536: 
                        case 537: 
                        case 538: 
                        case 539: 
                        case 540: 
                        case 541: 
                        case 542: 
                        case 543: 
                        case 544: 
                        case 545: 
                        case 546: 
                        case 547: 
                        case 548: 
                        case 549: 
                        case 550: 
                        case 551: 
                        case 552: 
                        case 553: 
                        case 554: 
                        case 555: 
                        case 556: 
                        case 557: 
                        case 558: 
                        case 559: 
                        case 560: 
                        case 561: 
                        case 562: 
                        case 563: 
                        case 564: 
                        case 565: 
                        case 566: 
                        case 567: 
                        case 568: 
                        case 569: 
                        case 570: 
                        case 571: 
                        case 572: 
                        case 573: 
                        case 574: 
                        case 575: 
                        case 576: 
                        case 577: 
                        case 578: 
                        case 579: 
                        case 580: 
                        case 581: 
                        case 583: 
                        case 584: 
                        case 586: 
                        case 587: 
                        case 589: 
                        case 590: 
                        case 591: 
                        case 592: 
                        case 595: 
                        case 596: 
                        case 599: 
                        case 604: 
                        case 606: 
                        case 608: 
                        case 611: 
                        case 612: 
                        case 613: 
                        case 614: 
                        case 615: 
                        case 616: 
                        case 617: 
                        case 618: 
                        case 619: 
                        case 624: 
                        case 626: 
                        case 627: 
                        case 628: 
                        case 629: 
                        case 630: 
                        case 631: 
                        case 632: 
                        case 637: 
                        case 638: 
                        case 639: 
                        case 640: 
                        case 642: 
                        case 643: 
                        case 645: 
                        case 646: 
                        case 648: 
                        case 649: 
                        case 650: 
                        case 651: 
                        case 653: 
                        case 654: 
                        case 655: 
                        case 656: 
                        case 659: 
                        case 661: 
                        case 662: 
                        case 663: 
                        case 664: 
                        case 665: 
                        case 666: 
                        case 668: 
                        case 669: 
                        case 670: 
                        case 674: 
                        case 675: 
                        case 679: 
                        case 681: 
                        case 683: 
                        case 684: 
                        case 693: 
                        case 694: 
                        case 695: 
                        case 696: 
                        case 697: 
                        case 698: 
                        case 699: 
                        case 700: 
                        case 701: 
                        case 702: 
                        case 706: 
                        case 707: 
                        case 708: 
                        case 709: 
                        case 710: 
                        case 712: 
                        case 713: 
                        case 715: 
                        case 717: 
                        case 718: 
                        case 719: 
                        case 720: 
                        case 731: 
                        case 737: 
                        case 738: 
                        case 763: 
                        case 764: 
                        case 765: 
                        case 766: 
                        case 767: 
                        case 768: 
                        case 770: {
                            trimChars = this.Expression(SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                            break;
                        }
                        default: {
                            this.jj_la1[321] = this.jj_gen;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 220: {
                            this.jj_consume_token(220);
                            if (null != flag || null != trimChars) break;
                            throw SqlUtil.newContextException(this.getPos(), Static.RESOURCE.illegalFromEmpty());
                        }
                        case 716: {
                            this.jj_consume_token(716);
                            if (flag == null) {
                                flag = SqlTrimFunction.Flag.BOTH.symbol(SqlParserPos.ZERO);
                            }
                            args.add(flag);
                            args.add(null);
                            args.add(trimChars);
                            return SqlStdOperatorTable.TRIM.createCall(s.end(this), args);
                        }
                        default: {
                            this.jj_la1[322] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                }
                SqlNode e = this.Expression(SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                if (flag == null) {
                    flag = SqlTrimFunction.Flag.BOTH.symbol(SqlParserPos.ZERO);
                }
                args.add(flag);
                args.add(trimChars);
                args.add(e);
                this.jj_consume_token(716);
                return SqlStdOperatorTable.TRIM.createCall(s.end(this), args);
            }
            case 133: {
                SqlCall node = this.DateTruncFunctionCall();
                return node;
            }
            case 616: {
                SqlCall node = this.TimestampAddFunctionCall();
                return node;
            }
            case 617: {
                SqlCall node = this.TimestampDiffFunctionCall();
                return node;
            }
            case 618: {
                SqlCall node = this.TimestampDiff3FunctionCall();
                return node;
            }
            case 619: {
                SqlCall node = this.TimestampTruncFunctionCall();
                return node;
            }
            case 613: {
                SqlCall node = this.TimeDiffFunctionCall();
                return node;
            }
            case 614: {
                SqlCall node = this.TimeTruncFunctionCall();
                return node;
            }
            case 73: 
            case 205: 
            case 206: 
            case 294: 
            case 317: 
            case 353: 
            case 429: 
            case 485: {
                SqlCall node = this.MatchRecognizeFunctionCall();
                return node;
            }
            case 281: {
                SqlCall node = this.JsonExistsFunctionCall();
                return node;
            }
            case 285: {
                SqlCall node = this.JsonValueFunctionCall();
                return node;
            }
            case 284: {
                SqlCall node = this.JsonQueryFunctionCall();
                return node;
            }
            case 282: {
                SqlCall node = this.JsonObjectFunctionCall();
                return node;
            }
            case 283: {
                SqlCall node = this.JsonObjectAggFunctionCall();
                return node;
            }
            case 279: {
                SqlCall node = this.JsonArrayFunctionCall();
                return node;
            }
            case 280: {
                SqlCall node = this.JsonArrayAggFunctionCall();
                return node;
            }
            case 241: 
            case 511: 
            case 645: {
                SqlCall node = this.GroupByWindowingCall();
                return node;
            }
        }
        this.jj_la1[323] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SqlJsonEncoding JsonRepresentation() throws ParseException {
        this.jj_consume_token(278);
        if (this.jj_2_79(2)) {
            this.jj_consume_token(180);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 668: {
                    this.jj_consume_token(668);
                    return SqlJsonEncoding.UTF8;
                }
                case 669: {
                    this.jj_consume_token(669);
                    return SqlJsonEncoding.UTF16;
                }
                case 670: {
                    this.jj_consume_token(670);
                    return SqlJsonEncoding.UTF32;
                }
            }
            this.jj_la1[324] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return SqlJsonEncoding.UTF8;
    }

    public final void JsonInputClause() throws ParseException {
        this.jj_consume_token(212);
        this.JsonRepresentation();
    }

    public final SqlDataTypeSpec JsonReturningClause() throws ParseException {
        this.jj_consume_token(469);
        SqlDataTypeSpec dt = this.DataType();
        return dt;
    }

    public final SqlDataTypeSpec JsonOutputClause() throws ParseException {
        SqlDataTypeSpec dataType = this.JsonReturningClause();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 212: {
                this.jj_consume_token(212);
                this.JsonRepresentation();
                break;
            }
            default: {
                this.jj_la1[325] = this.jj_gen;
            }
        }
        return dataType;
    }

    public final SqlNode JsonPathSpec() throws ParseException {
        SqlNode e = this.StringLiteral();
        return e;
    }

    public final List<SqlNode> JsonApiCommonSyntax() throws ParseException {
        ArrayList<SqlNode> args = new ArrayList<SqlNode>();
        this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_NON_QUERY);
        this.jj_consume_token(727);
        this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_NON_QUERY);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 404: {
                this.jj_consume_token(404);
                SqlNode e = this.Expression(SqlAbstractParserImpl.ExprContext.ACCEPT_NON_QUERY);
                this.jj_consume_token(23);
                e = this.SimpleIdentifier();
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 727: {
                            break;
                        }
                        default: {
                            this.jj_la1[326] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(727);
                    e = this.Expression(SqlAbstractParserImpl.ExprContext.ACCEPT_NON_QUERY);
                    this.jj_consume_token(23);
                    e = this.SimpleIdentifier();
                }
            }
            default: {
                this.jj_la1[327] = this.jj_gen;
            }
        }
        return args;
    }

    public final SqlJsonExistsErrorBehavior JsonExistsErrorBehavior() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 642: {
                this.jj_consume_token(642);
                return SqlJsonExistsErrorBehavior.TRUE;
            }
            case 202: {
                this.jj_consume_token(202);
                return SqlJsonExistsErrorBehavior.FALSE;
            }
            case 654: {
                this.jj_consume_token(654);
                return SqlJsonExistsErrorBehavior.UNKNOWN;
            }
            case 187: {
                this.jj_consume_token(187);
                return SqlJsonExistsErrorBehavior.ERROR;
            }
        }
        this.jj_la1[328] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SqlCall JsonExistsFunctionCall() throws ParseException {
        ArrayList<SqlNode> args = new ArrayList<SqlNode>();
        this.jj_consume_token(281);
        Span span = this.span();
        this.jj_consume_token(715);
        List<SqlNode> commonSyntax = this.JsonApiCommonSyntax();
        args.addAll(commonSyntax);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 187: 
            case 202: 
            case 642: 
            case 654: {
                SqlJsonExistsErrorBehavior errorBehavior = this.JsonExistsErrorBehavior();
                args.add(errorBehavior.symbol(this.getPos()));
                this.jj_consume_token(375);
                this.jj_consume_token(187);
                break;
            }
            default: {
                this.jj_la1[329] = this.jj_gen;
            }
        }
        this.jj_consume_token(716);
        return SqlStdOperatorTable.JSON_EXISTS.createCall(span.end(this), args);
    }

    public final List<SqlNode> JsonValueEmptyOrErrorBehavior() throws ParseException {
        ArrayList<SqlNode> list = new ArrayList<SqlNode>();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 187: {
                this.jj_consume_token(187);
                list.add(SqlJsonValueEmptyOrErrorBehavior.ERROR.symbol(this.getPos()));
                break;
            }
            case 361: {
                this.jj_consume_token(361);
                list.add(SqlJsonValueEmptyOrErrorBehavior.NULL.symbol(this.getPos()));
                break;
            }
            case 144: {
                this.jj_consume_token(144);
                list.add(SqlJsonValueEmptyOrErrorBehavior.DEFAULT.symbol(this.getPos()));
                this.AddExpression(list, SqlAbstractParserImpl.ExprContext.ACCEPT_NON_QUERY);
                break;
            }
            default: {
                this.jj_la1[330] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(375);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 179: {
                this.jj_consume_token(179);
                list.add(SqlJsonEmptyOrError.EMPTY.symbol(this.getPos()));
                break;
            }
            case 187: {
                this.jj_consume_token(187);
                list.add(SqlJsonEmptyOrError.ERROR.symbol(this.getPos()));
                break;
            }
            default: {
                this.jj_la1[331] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return list;
    }

    public final SqlCall JsonValueFunctionCall() throws ParseException {
        ArrayList<SqlNode> args = new ArrayList<SqlNode>(7);
        this.jj_consume_token(285);
        Span span = this.span();
        this.jj_consume_token(715);
        List<SqlNode> commonSyntax = this.JsonApiCommonSyntax();
        args.addAll(commonSyntax);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 469: {
                SqlDataTypeSpec e = this.JsonReturningClause();
                args.add(SqlJsonValueReturning.RETURNING.symbol(this.getPos()));
                args.add(e);
                break;
            }
            default: {
                this.jj_la1[332] = this.jj_gen;
            }
        }
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 144: 
                case 187: 
                case 361: {
                    break;
                }
                default: {
                    this.jj_la1[333] = this.jj_gen;
                    break block6;
                }
            }
            List<SqlNode> behavior = this.JsonValueEmptyOrErrorBehavior();
            args.addAll(behavior);
        }
        this.jj_consume_token(716);
        return SqlStdOperatorTable.JSON_VALUE.createCall(span.end(this), args);
    }

    public final List<SqlNode> JsonQueryEmptyOrErrorBehavior() throws ParseException {
        ArrayList<SqlNode> list = new ArrayList<SqlNode>();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 187: {
                this.jj_consume_token(187);
                list.add(SqlLiteral.createSymbol(SqlJsonQueryEmptyOrErrorBehavior.ERROR, this.getPos()));
                break;
            }
            case 361: {
                this.jj_consume_token(361);
                list.add(SqlLiteral.createSymbol(SqlJsonQueryEmptyOrErrorBehavior.NULL, this.getPos()));
                break;
            }
            default: {
                this.jj_la1[334] = this.jj_gen;
                if (this.jj_2_80(2)) {
                    this.jj_consume_token(179);
                    this.jj_consume_token(19);
                    list.add(SqlLiteral.createSymbol(SqlJsonQueryEmptyOrErrorBehavior.EMPTY_ARRAY, this.getPos()));
                    break;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 179: {
                        this.jj_consume_token(179);
                        this.jj_consume_token(367);
                        list.add(SqlLiteral.createSymbol(SqlJsonQueryEmptyOrErrorBehavior.EMPTY_OBJECT, this.getPos()));
                        break block0;
                    }
                }
                this.jj_la1[335] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(375);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 179: {
                this.jj_consume_token(179);
                list.add(SqlLiteral.createSymbol(SqlJsonEmptyOrError.EMPTY, this.getPos()));
                break;
            }
            case 187: {
                this.jj_consume_token(187);
                list.add(SqlLiteral.createSymbol(SqlJsonEmptyOrError.ERROR, this.getPos()));
                break;
            }
            default: {
                this.jj_la1[336] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return list;
    }

    public final SqlNode JsonQueryWrapperBehavior() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 692: {
                this.jj_consume_token(692);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 19: {
                        this.jj_consume_token(19);
                        break;
                    }
                    default: {
                        this.jj_la1[337] = this.jj_gen;
                    }
                }
                return SqlLiteral.createSymbol(SqlJsonQueryWrapperBehavior.WITHOUT_ARRAY, this.getPos());
            }
        }
        this.jj_la1[341] = this.jj_gen;
        if (this.jj_2_81(2)) {
            this.jj_consume_token(690);
            this.jj_consume_token(92);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 19: {
                    this.jj_consume_token(19);
                    break;
                }
                default: {
                    this.jj_la1[338] = this.jj_gen;
                }
            }
            return SqlLiteral.createSymbol(SqlJsonQueryWrapperBehavior.WITH_CONDITIONAL_ARRAY, this.getPos());
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 690: {
                this.jj_consume_token(690);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 650: {
                        this.jj_consume_token(650);
                        break;
                    }
                    default: {
                        this.jj_la1[339] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 19: {
                        this.jj_consume_token(19);
                        break;
                    }
                    default: {
                        this.jj_la1[340] = this.jj_gen;
                    }
                }
                return SqlLiteral.createSymbol(SqlJsonQueryWrapperBehavior.WITH_UNCONDITIONAL_ARRAY, this.getPos());
            }
        }
        this.jj_la1[342] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SqlCall JsonQueryFunctionCall() throws ParseException {
        SqlNode[] args = new SqlNode[5];
        this.jj_consume_token(284);
        Span span = this.span();
        this.jj_consume_token(715);
        List<SqlNode> commonSyntax = this.JsonApiCommonSyntax();
        args[0] = commonSyntax.get(0);
        args[1] = commonSyntax.get(1);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 690: 
            case 692: {
                SqlNode e = this.JsonQueryWrapperBehavior();
                this.jj_consume_token(694);
                args[2] = e;
                break;
            }
            default: {
                this.jj_la1[343] = this.jj_gen;
            }
        }
        block10: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 179: 
                case 187: 
                case 361: {
                    break;
                }
                default: {
                    this.jj_la1[344] = this.jj_gen;
                    break block10;
                }
            }
            List<SqlNode> behavior = this.JsonQueryEmptyOrErrorBehavior();
            SqlJsonEmptyOrError symbol = ((SqlLiteral)behavior.get(1)).getValueAs(SqlJsonEmptyOrError.class);
            switch (symbol) {
                case EMPTY: {
                    args[3] = behavior.get(0);
                    break;
                }
                case ERROR: {
                    args[4] = behavior.get(0);
                }
            }
        }
        this.jj_consume_token(716);
        return SqlStdOperatorTable.JSON_QUERY.createCall(span.end(this), args);
    }

    public final SqlNode JsonName() throws ParseException {
        SqlNode e = this.Expression(SqlAbstractParserImpl.ExprContext.ACCEPT_NON_QUERY);
        return e;
    }

    public final List<SqlNode> JsonNameAndValue() throws ParseException {
        ArrayList<SqlNode> list = new ArrayList<SqlNode>();
        boolean kvMode = false;
        if (this.jj_2_82(2)) {
            this.jj_consume_token(287);
            kvMode = true;
        }
        SqlNode e = this.JsonName();
        list.add(e);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 671: {
                this.jj_consume_token(671);
                break;
            }
            case 732: {
                this.jj_consume_token(732);
                if (!kvMode) break;
                throw SqlUtil.newContextException(this.getPos(), Static.RESOURCE.illegalColon());
            }
            default: {
                this.jj_la1[345] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.AddExpression(list, SqlAbstractParserImpl.ExprContext.ACCEPT_NON_QUERY);
        return list;
    }

    public final SqlNode JsonConstructorNullClause() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 361: {
                this.jj_consume_token(361);
                this.jj_consume_token(375);
                this.jj_consume_token(361);
                return SqlLiteral.createSymbol(SqlJsonConstructorNullClause.NULL_ON_NULL, this.getPos());
            }
            case 3: {
                this.jj_consume_token(3);
                this.jj_consume_token(375);
                this.jj_consume_token(361);
                return SqlLiteral.createSymbol(SqlJsonConstructorNullClause.ABSENT_ON_NULL, this.getPos());
            }
        }
        this.jj_la1[346] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SqlCall JsonObjectFunctionCall() throws ParseException {
        ArrayList<SqlNode> nvArgs = new ArrayList<SqlNode>();
        SqlNode[] otherArgs = new SqlNode[1];
        this.jj_consume_token(282);
        Span span = this.span();
        this.jj_consume_token(715);
        if (this.jj_2_83(2)) {
            List<SqlNode> list = this.JsonNameAndValue();
            nvArgs.addAll(list);
            block6: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 727: {
                        break;
                    }
                    default: {
                        this.jj_la1[347] = this.jj_gen;
                        break block6;
                    }
                }
                this.jj_consume_token(727);
                list = this.JsonNameAndValue();
                nvArgs.addAll(list);
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 3: 
            case 361: {
                SqlNode e;
                otherArgs[0] = e = this.JsonConstructorNullClause();
                break;
            }
            default: {
                this.jj_la1[348] = this.jj_gen;
            }
        }
        this.jj_consume_token(716);
        ArrayList<SqlNode> args = new ArrayList<SqlNode>();
        args.addAll(Arrays.asList(otherArgs));
        args.addAll(nvArgs);
        return SqlStdOperatorTable.JSON_OBJECT.createCall(span.end(this), args);
    }

    public final SqlCall JsonObjectAggFunctionCall() throws ParseException {
        SqlNode[] args = new SqlNode[2];
        SqlJsonConstructorNullClause nullClause = SqlJsonConstructorNullClause.NULL_ON_NULL;
        this.jj_consume_token(283);
        Span span = this.span();
        this.jj_consume_token(715);
        List<SqlNode> list = this.JsonNameAndValue();
        args[0] = list.get(0);
        args[1] = list.get(1);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 3: 
            case 361: {
                SqlNode e = this.JsonConstructorNullClause();
                nullClause = (SqlJsonConstructorNullClause)((Object)((SqlLiteral)e).getValue());
                break;
            }
            default: {
                this.jj_la1[349] = this.jj_gen;
            }
        }
        this.jj_consume_token(716);
        return SqlStdOperatorTable.JSON_OBJECTAGG.with(nullClause).createCall(span.end(this), args);
    }

    public final SqlCall JsonArrayFunctionCall() throws ParseException {
        ArrayList<SqlNode> elements = new ArrayList<SqlNode>();
        SqlNode[] otherArgs = new SqlNode[1];
        this.jj_consume_token(279);
        Span span = this.span();
        this.jj_consume_token(715);
        if (this.jj_2_84(2)) {
            this.AddExpression(elements, SqlAbstractParserImpl.ExprContext.ACCEPT_NON_QUERY);
            block6: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 727: {
                        break;
                    }
                    default: {
                        this.jj_la1[350] = this.jj_gen;
                        break block6;
                    }
                }
                this.jj_consume_token(727);
                this.AddExpression(elements, SqlAbstractParserImpl.ExprContext.ACCEPT_NON_QUERY);
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 3: 
            case 361: {
                SqlNode e;
                otherArgs[0] = e = this.JsonConstructorNullClause();
                break;
            }
            default: {
                this.jj_la1[351] = this.jj_gen;
            }
        }
        this.jj_consume_token(716);
        ArrayList<SqlNode> args = new ArrayList<SqlNode>();
        args.addAll(Arrays.asList(otherArgs));
        args.addAll(elements);
        return SqlStdOperatorTable.JSON_ARRAY.createCall(span.end(this), args);
    }

    public final SqlNodeList JsonArrayAggOrderByClause() throws ParseException {
        SqlNodeList orderList = this.OrderBy(true);
        return orderList;
    }

    public final SqlCall JsonArrayAggFunctionCall() throws ParseException {
        SqlJsonConstructorNullClause nullClause;
        SqlNodeList orderList;
        SqlNode e;
        this.jj_consume_token(280);
        Span span = this.span();
        this.jj_consume_token(715);
        SqlNode valueExpr = e = this.Expression(SqlAbstractParserImpl.ExprContext.ACCEPT_NON_QUERY);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 382: {
                orderList = this.JsonArrayAggOrderByClause();
                break;
            }
            default: {
                this.jj_la1[352] = this.jj_gen;
                orderList = null;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 3: 
            case 361: {
                e = this.JsonConstructorNullClause();
                nullClause = (SqlJsonConstructorNullClause)((Object)((SqlLiteral)e).getValue());
                break;
            }
            default: {
                this.jj_la1[353] = this.jj_gen;
                nullClause = SqlJsonConstructorNullClause.ABSENT_ON_NULL;
            }
        }
        this.jj_consume_token(716);
        SqlCall aggCall = SqlStdOperatorTable.JSON_ARRAYAGG.with(nullClause).createCall(span.end(this), valueExpr, orderList);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 691: {
                e = this.withinGroup(aggCall);
                if (orderList != null) {
                    throw SqlUtil.newContextException(span.pos().plus(e.getParserPosition()), Static.RESOURCE.ambiguousSortOrderInJsonArrayAggFunc());
                }
                return (SqlCall)e;
            }
        }
        this.jj_la1[354] = this.jj_gen;
        if (orderList == null) {
            return SqlStdOperatorTable.JSON_ARRAYAGG.with(nullClause).createCall(span.end(this), valueExpr);
        }
        return SqlStdOperatorTable.JSON_ARRAYAGG.with(nullClause).createCall(span.end(this), valueExpr, orderList);
    }

    public final SqlCall TimestampAddFunctionCall() throws ParseException {
        ArrayList<SqlNode> args = new ArrayList<SqlNode>();
        this.jj_consume_token(616);
        Span s = this.span();
        this.jj_consume_token(715);
        SqlIntervalQualifier unit = this.TimeUnitOrName();
        args.add(unit);
        this.jj_consume_token(727);
        this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        this.jj_consume_token(727);
        this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        this.jj_consume_token(716);
        return SqlStdOperatorTable.TIMESTAMP_ADD.createCall(s.end(this), args);
    }

    public final SqlCall TimestampDiffFunctionCall() throws ParseException {
        ArrayList<SqlNode> args = new ArrayList<SqlNode>();
        this.jj_consume_token(617);
        Span s = this.span();
        this.jj_consume_token(715);
        SqlIntervalQualifier unit = this.TimeUnitOrName();
        args.add(unit);
        this.jj_consume_token(727);
        this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        this.jj_consume_token(727);
        this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        this.jj_consume_token(716);
        return SqlStdOperatorTable.TIMESTAMP_DIFF.createCall(s.end(this), args);
    }

    public final SqlCall TimestampDiff3FunctionCall() throws ParseException {
        ArrayList<SqlNode> args = new ArrayList<SqlNode>();
        this.jj_consume_token(618);
        Span s = this.span();
        this.jj_consume_token(715);
        this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        this.jj_consume_token(727);
        this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        this.jj_consume_token(727);
        SqlIntervalQualifier unit = this.TimeUnitOrName();
        args.add(unit);
        this.jj_consume_token(716);
        return SqlLibraryOperators.TIMESTAMP_DIFF3.createCall(s.end(this), args);
    }

    public final SqlCall DateTruncFunctionCall() throws ParseException {
        ArrayList<SqlNode> args = new ArrayList<SqlNode>();
        this.jj_consume_token(133);
        Span s = this.span();
        this.jj_consume_token(715);
        this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        this.jj_consume_token(727);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 24: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 35: 
            case 39: 
            case 47: 
            case 49: 
            case 53: 
            case 57: 
            case 58: 
            case 61: 
            case 62: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 74: 
            case 78: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 86: 
            case 87: 
            case 88: 
            case 90: 
            case 92: 
            case 93: 
            case 95: 
            case 96: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 104: 
            case 128: 
            case 130: 
            case 131: 
            case 133: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 141: 
            case 145: 
            case 146: 
            case 147: 
            case 149: 
            case 150: 
            case 151: 
            case 154: 
            case 156: 
            case 157: 
            case 159: 
            case 160: 
            case 162: 
            case 165: 
            case 167: 
            case 168: 
            case 170: 
            case 171: 
            case 174: 
            case 175: 
            case 180: 
            case 185: 
            case 187: 
            case 191: 
            case 192: 
            case 193: 
            case 205: 
            case 206: 
            case 210: 
            case 212: 
            case 214: 
            case 215: 
            case 216: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 230: 
            case 231: 
            case 233: 
            case 235: 
            case 239: 
            case 241: 
            case 242: 
            case 243: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 252: 
            case 253: 
            case 254: 
            case 257: 
            case 260: 
            case 263: 
            case 264: 
            case 271: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 278: 
            case 286: 
            case 287: 
            case 288: 
            case 289: 
            case 290: 
            case 294: 
            case 300: 
            case 301: 
            case 302: 
            case 310: 
            case 312: 
            case 313: 
            case 315: 
            case 320: 
            case 324: 
            case 325: 
            case 326: 
            case 328: 
            case 329: 
            case 330: 
            case 332: 
            case 333: 
            case 334: 
            case 339: 
            case 340: 
            case 341: 
            case 343: 
            case 344: 
            case 345: 
            case 346: 
            case 351: 
            case 357: 
            case 362: 
            case 364: 
            case 365: 
            case 367: 
            case 370: 
            case 379: 
            case 380: 
            case 383: 
            case 384: 
            case 385: 
            case 388: 
            case 392: 
            case 393: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 399: 
            case 400: 
            case 401: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 416: 
            case 417: 
            case 418: 
            case 419: 
            case 425: 
            case 428: 
            case 431: 
            case 432: 
            case 434: 
            case 435: 
            case 436: 
            case 439: 
            case 455: 
            case 457: 
            case 458: 
            case 460: 
            case 461: 
            case 462: 
            case 465: 
            case 466: 
            case 467: 
            case 468: 
            case 469: 
            case 473: 
            case 474: 
            case 477: 
            case 478: 
            case 479: 
            case 480: 
            case 482: 
            case 488: 
            case 489: 
            case 490: 
            case 491: 
            case 493: 
            case 494: 
            case 495: 
            case 498: 
            case 499: 
            case 500: 
            case 501: 
            case 504: 
            case 506: 
            case 507: 
            case 508: 
            case 509: 
            case 510: 
            case 511: 
            case 514: 
            case 518: 
            case 519: 
            case 523: 
            case 524: 
            case 526: 
            case 532: 
            case 533: 
            case 534: 
            case 535: 
            case 536: 
            case 537: 
            case 538: 
            case 539: 
            case 540: 
            case 541: 
            case 542: 
            case 543: 
            case 544: 
            case 545: 
            case 546: 
            case 547: 
            case 548: 
            case 549: 
            case 550: 
            case 551: 
            case 552: 
            case 553: 
            case 554: 
            case 555: 
            case 556: 
            case 557: 
            case 558: 
            case 559: 
            case 560: 
            case 561: 
            case 562: 
            case 563: 
            case 564: 
            case 565: 
            case 566: 
            case 567: 
            case 568: 
            case 569: 
            case 570: 
            case 571: 
            case 572: 
            case 573: 
            case 574: 
            case 575: 
            case 576: 
            case 577: 
            case 578: 
            case 579: 
            case 580: 
            case 583: 
            case 584: 
            case 589: 
            case 590: 
            case 591: 
            case 592: 
            case 595: 
            case 606: 
            case 608: 
            case 611: 
            case 613: 
            case 614: 
            case 616: 
            case 617: 
            case 618: 
            case 619: 
            case 624: 
            case 626: 
            case 627: 
            case 628: 
            case 629: 
            case 630: 
            case 631: 
            case 637: 
            case 638: 
            case 639: 
            case 645: 
            case 646: 
            case 648: 
            case 649: 
            case 650: 
            case 651: 
            case 655: 
            case 656: 
            case 661: 
            case 663: 
            case 664: 
            case 665: 
            case 666: 
            case 668: 
            case 669: 
            case 670: 
            case 679: 
            case 681: 
            case 683: 
            case 684: 
            case 693: 
            case 694: 
            case 695: 
            case 696: 
            case 697: 
            case 698: 
            case 699: 
            case 763: 
            case 764: 
            case 765: 
            case 766: 
            case 767: 
            case 768: 
            case 770: {
                SqlIntervalQualifier unit = this.TimeUnitOrName();
                args.add(unit);
                break;
            }
            case 2: 
            case 19: 
            case 34: 
            case 52: 
            case 55: 
            case 56: 
            case 59: 
            case 60: 
            case 63: 
            case 64: 
            case 66: 
            case 73: 
            case 77: 
            case 84: 
            case 105: 
            case 108: 
            case 109: 
            case 110: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 122: 
            case 123: 
            case 124: 
            case 126: 
            case 127: 
            case 132: 
            case 134: 
            case 153: 
            case 177: 
            case 189: 
            case 196: 
            case 197: 
            case 201: 
            case 202: 
            case 207: 
            case 209: 
            case 223: 
            case 236: 
            case 268: 
            case 269: 
            case 279: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 284: 
            case 285: 
            case 291: 
            case 295: 
            case 297: 
            case 299: 
            case 306: 
            case 308: 
            case 309: 
            case 311: 
            case 317: 
            case 319: 
            case 331: 
            case 335: 
            case 342: 
            case 352: 
            case 353: 
            case 358: 
            case 359: 
            case 360: 
            case 361: 
            case 363: 
            case 369: 
            case 391: 
            case 411: 
            case 412: 
            case 413: 
            case 414: 
            case 421: 
            case 423: 
            case 429: 
            case 438: 
            case 448: 
            case 452: 
            case 454: 
            case 472: 
            case 481: 
            case 483: 
            case 485: 
            case 512: 
            case 522: 
            case 525: 
            case 581: 
            case 586: 
            case 587: 
            case 596: 
            case 599: 
            case 604: 
            case 612: 
            case 615: 
            case 632: 
            case 640: 
            case 642: 
            case 643: 
            case 653: 
            case 654: 
            case 659: 
            case 662: 
            case 674: 
            case 675: 
            case 700: 
            case 701: 
            case 702: 
            case 706: 
            case 707: 
            case 708: 
            case 709: 
            case 710: 
            case 712: 
            case 713: 
            case 715: 
            case 717: 
            case 718: 
            case 719: 
            case 720: 
            case 731: 
            case 737: 
            case 738: {
                this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                break;
            }
            default: {
                this.jj_la1[355] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(716);
        return SqlLibraryOperators.DATE_TRUNC.createCall(s.end(this), args);
    }

    public final SqlCall TimestampTruncFunctionCall() throws ParseException {
        ArrayList<SqlNode> args = new ArrayList<SqlNode>();
        this.jj_consume_token(619);
        Span s = this.span();
        this.jj_consume_token(715);
        this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        this.jj_consume_token(727);
        SqlIntervalQualifier unit = this.TimeUnitOrName();
        args.add(unit);
        this.jj_consume_token(716);
        return SqlLibraryOperators.TIMESTAMP_TRUNC.createCall(s.end(this), args);
    }

    public final SqlCall TimeDiffFunctionCall() throws ParseException {
        ArrayList<SqlNode> args = new ArrayList<SqlNode>();
        this.jj_consume_token(613);
        Span s = this.span();
        this.jj_consume_token(715);
        this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        this.jj_consume_token(727);
        this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        this.jj_consume_token(727);
        SqlIntervalQualifier unit = this.TimeUnitOrName();
        args.add(unit);
        this.jj_consume_token(716);
        return SqlLibraryOperators.TIME_DIFF.createCall(s.end(this), args);
    }

    public final SqlCall TimeTruncFunctionCall() throws ParseException {
        ArrayList<SqlNode> args = new ArrayList<SqlNode>();
        this.jj_consume_token(614);
        Span s = this.span();
        this.jj_consume_token(715);
        this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        this.jj_consume_token(727);
        SqlIntervalQualifier unit = this.TimeUnitOrName();
        args.add(unit);
        this.jj_consume_token(716);
        return SqlLibraryOperators.TIME_TRUNC.createCall(s.end(this), args);
    }

    public final SqlCall GroupByWindowingCall() throws ParseException {
        SqlGroupedWindowFunction op;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 645: {
                this.jj_consume_token(645);
                op = SqlStdOperatorTable.TUMBLE_OLD;
                break;
            }
            case 241: {
                this.jj_consume_token(241);
                op = SqlStdOperatorTable.HOP_OLD;
                break;
            }
            case 511: {
                this.jj_consume_token(511);
                op = SqlStdOperatorTable.SESSION_OLD;
                break;
            }
            default: {
                this.jj_la1[356] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        Span s = this.span();
        List<SqlNode> args = this.UnquantifiedFunctionParameterList(SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        return op.createCall(s.end(this), args);
    }

    public final SqlCall MatchRecognizeFunctionCall() throws ParseException {
        SqlCall func;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 73: {
                this.jj_consume_token(73);
                Span s = this.span();
                this.jj_consume_token(715);
                this.jj_consume_token(716);
                func = SqlStdOperatorTable.CLASSIFIER.createCall(s.end(this), new SqlNode[0]);
                break;
            }
            case 317: {
                this.jj_consume_token(317);
                Span s = this.span();
                this.jj_consume_token(715);
                this.jj_consume_token(716);
                func = SqlStdOperatorTable.MATCH_NUMBER.createCall(s.end(this), new SqlNode[0]);
                break;
            }
            default: {
                this.jj_la1[357] = this.jj_gen;
                if (this.jj_2_85(3)) {
                    func = this.MatchRecognizeNavigationLogical();
                    break;
                }
                if (this.jj_2_86(2)) {
                    func = this.MatchRecognizeNavigationPhysical();
                    break;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 205: 
                    case 485: {
                        func = this.MatchRecognizeCallWithModifier();
                        break block0;
                    }
                }
                this.jj_la1[358] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return func;
    }

    public final SqlCall MatchRecognizeCallWithModifier() throws ParseException {
        SqlPrefixOperator runningOp;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 485: {
                this.jj_consume_token(485);
                runningOp = SqlStdOperatorTable.RUNNING;
                break;
            }
            case 205: {
                this.jj_consume_token(205);
                runningOp = SqlStdOperatorTable.FINAL;
                break;
            }
            default: {
                this.jj_la1[359] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        Span s = this.span();
        SqlNode func = this.NamedFunctionCall();
        return runningOp.createCall(s.end(func), func);
    }

    public final SqlCall MatchRecognizeNavigationLogical() throws ParseException {
        SqlFunction funcOp;
        SqlPrefixOperator runningOp;
        Span s = Span.of();
        ArrayList<SqlNode> args = new ArrayList<SqlNode>();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 485: {
                this.jj_consume_token(485);
                runningOp = SqlStdOperatorTable.RUNNING;
                s.add(this);
                break;
            }
            case 205: {
                this.jj_consume_token(205);
                runningOp = SqlStdOperatorTable.FINAL;
                s.add(this);
                break;
            }
            default: {
                this.jj_la1[360] = this.jj_gen;
                runningOp = null;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 206: {
                this.jj_consume_token(206);
                funcOp = SqlStdOperatorTable.FIRST;
                break;
            }
            case 294: {
                this.jj_consume_token(294);
                funcOp = SqlStdOperatorTable.LAST;
                break;
            }
            default: {
                this.jj_la1[361] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        s.add(this);
        this.jj_consume_token(715);
        this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 727: {
                this.jj_consume_token(727);
                SqlLiteral e = this.NumericLiteral();
                args.add(e);
                break;
            }
            default: {
                this.jj_la1[362] = this.jj_gen;
                args.add(LITERAL_ZERO);
            }
        }
        this.jj_consume_token(716);
        SqlCall func = funcOp.createCall(s.end(this), args);
        if (runningOp != null) {
            return runningOp.createCall(s.end(this), func);
        }
        return func;
    }

    public final SqlCall MatchRecognizeNavigationPhysical() throws ParseException {
        SqlFunction funcOp;
        ArrayList<SqlNode> args = new ArrayList<SqlNode>();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 429: {
                this.jj_consume_token(429);
                funcOp = SqlStdOperatorTable.PREV;
                break;
            }
            case 353: {
                this.jj_consume_token(353);
                funcOp = SqlStdOperatorTable.NEXT;
                break;
            }
            default: {
                this.jj_la1[363] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        Span s = this.span();
        this.jj_consume_token(715);
        this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 727: {
                this.jj_consume_token(727);
                SqlLiteral e = this.NumericLiteral();
                args.add(e);
                break;
            }
            default: {
                this.jj_la1[364] = this.jj_gen;
                args.add(LITERAL_ONE);
            }
        }
        this.jj_consume_token(716);
        return funcOp.createCall(s.end(this), args);
    }

    public final SqlCall withinDistinct(SqlNode arg) throws ParseException {
        this.jj_consume_token(691);
        Span s = this.span();
        this.jj_consume_token(166);
        this.jj_consume_token(715);
        SqlNodeList distinctList = this.ExpressionCommaList(s, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        this.jj_consume_token(716);
        return SqlStdOperatorTable.WITHIN_DISTINCT.createCall(s.end(this), arg, distinctList);
    }

    public final SqlCall withinGroup(SqlNode arg) throws ParseException {
        this.jj_consume_token(691);
        Span s = this.span();
        this.jj_consume_token(234);
        this.jj_consume_token(715);
        SqlNodeList orderList = this.OrderBy(true);
        this.jj_consume_token(716);
        return SqlStdOperatorTable.WITHIN_GROUP.createCall(s.end(this), arg, orderList);
    }

    public final Pair<SqlParserPos, SqlOperator> NullTreatment() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 245: {
                this.jj_consume_token(245);
                Span span = this.span();
                this.jj_consume_token(364);
                return Pair.of(span.end(this), SqlStdOperatorTable.IGNORE_NULLS);
            }
            case 460: {
                this.jj_consume_token(460);
                Span span = this.span();
                this.jj_consume_token(364);
                return Pair.of(span.end(this), SqlStdOperatorTable.RESPECT_NULLS);
            }
        }
        this.jj_la1[365] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SqlCall nullTreatment(SqlCall arg) throws ParseException {
        Pair<SqlParserPos, SqlOperator> pair = this.NullTreatment();
        return ((SqlOperator)pair.right).createCall((SqlParserPos)pair.left, arg);
    }

    public final SqlNode NamedFunctionCall() throws ParseException {
        SqlCall call;
        if (this.jj_2_87(2)) {
            call = this.StringAggFunctionCall();
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 14: 
                case 17: 
                case 20: 
                case 21: 
                case 24: 
                case 26: 
                case 27: 
                case 31: 
                case 32: 
                case 34: 
                case 35: 
                case 39: 
                case 47: 
                case 49: 
                case 52: 
                case 53: 
                case 57: 
                case 58: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 74: 
                case 77: 
                case 78: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 86: 
                case 87: 
                case 88: 
                case 90: 
                case 92: 
                case 93: 
                case 95: 
                case 96: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 104: 
                case 108: 
                case 109: 
                case 110: 
                case 114: 
                case 117: 
                case 123: 
                case 124: 
                case 128: 
                case 130: 
                case 131: 
                case 133: 
                case 135: 
                case 136: 
                case 138: 
                case 141: 
                case 145: 
                case 146: 
                case 147: 
                case 149: 
                case 150: 
                case 151: 
                case 153: 
                case 154: 
                case 156: 
                case 157: 
                case 159: 
                case 160: 
                case 162: 
                case 165: 
                case 167: 
                case 168: 
                case 170: 
                case 171: 
                case 174: 
                case 175: 
                case 177: 
                case 180: 
                case 185: 
                case 187: 
                case 189: 
                case 191: 
                case 192: 
                case 193: 
                case 197: 
                case 205: 
                case 206: 
                case 207: 
                case 209: 
                case 210: 
                case 212: 
                case 214: 
                case 215: 
                case 216: 
                case 223: 
                case 224: 
                case 225: 
                case 226: 
                case 227: 
                case 230: 
                case 231: 
                case 233: 
                case 235: 
                case 236: 
                case 239: 
                case 241: 
                case 242: 
                case 243: 
                case 245: 
                case 246: 
                case 247: 
                case 248: 
                case 249: 
                case 252: 
                case 253: 
                case 254: 
                case 257: 
                case 260: 
                case 263: 
                case 264: 
                case 268: 
                case 271: 
                case 273: 
                case 274: 
                case 275: 
                case 276: 
                case 278: 
                case 286: 
                case 287: 
                case 288: 
                case 289: 
                case 290: 
                case 291: 
                case 294: 
                case 295: 
                case 297: 
                case 299: 
                case 300: 
                case 301: 
                case 302: 
                case 306: 
                case 308: 
                case 309: 
                case 310: 
                case 311: 
                case 312: 
                case 313: 
                case 315: 
                case 319: 
                case 320: 
                case 324: 
                case 325: 
                case 326: 
                case 328: 
                case 329: 
                case 330: 
                case 331: 
                case 332: 
                case 333: 
                case 334: 
                case 335: 
                case 339: 
                case 340: 
                case 341: 
                case 343: 
                case 344: 
                case 345: 
                case 346: 
                case 351: 
                case 357: 
                case 359: 
                case 360: 
                case 362: 
                case 363: 
                case 364: 
                case 365: 
                case 367: 
                case 369: 
                case 370: 
                case 379: 
                case 380: 
                case 383: 
                case 384: 
                case 385: 
                case 388: 
                case 392: 
                case 393: 
                case 395: 
                case 396: 
                case 397: 
                case 398: 
                case 399: 
                case 400: 
                case 401: 
                case 403: 
                case 404: 
                case 405: 
                case 406: 
                case 407: 
                case 411: 
                case 412: 
                case 413: 
                case 416: 
                case 417: 
                case 418: 
                case 419: 
                case 423: 
                case 425: 
                case 428: 
                case 431: 
                case 432: 
                case 434: 
                case 435: 
                case 436: 
                case 438: 
                case 439: 
                case 448: 
                case 452: 
                case 454: 
                case 455: 
                case 457: 
                case 458: 
                case 460: 
                case 461: 
                case 462: 
                case 465: 
                case 466: 
                case 467: 
                case 468: 
                case 469: 
                case 472: 
                case 473: 
                case 474: 
                case 477: 
                case 478: 
                case 479: 
                case 480: 
                case 482: 
                case 483: 
                case 488: 
                case 489: 
                case 490: 
                case 491: 
                case 493: 
                case 494: 
                case 495: 
                case 498: 
                case 499: 
                case 500: 
                case 501: 
                case 504: 
                case 506: 
                case 507: 
                case 508: 
                case 509: 
                case 510: 
                case 511: 
                case 514: 
                case 518: 
                case 519: 
                case 522: 
                case 523: 
                case 524: 
                case 525: 
                case 526: 
                case 532: 
                case 533: 
                case 534: 
                case 535: 
                case 536: 
                case 537: 
                case 538: 
                case 539: 
                case 540: 
                case 541: 
                case 542: 
                case 543: 
                case 544: 
                case 545: 
                case 546: 
                case 547: 
                case 548: 
                case 549: 
                case 550: 
                case 551: 
                case 552: 
                case 553: 
                case 554: 
                case 555: 
                case 556: 
                case 557: 
                case 558: 
                case 559: 
                case 560: 
                case 561: 
                case 562: 
                case 563: 
                case 564: 
                case 565: 
                case 566: 
                case 567: 
                case 568: 
                case 569: 
                case 570: 
                case 571: 
                case 572: 
                case 573: 
                case 574: 
                case 575: 
                case 576: 
                case 577: 
                case 578: 
                case 579: 
                case 580: 
                case 581: 
                case 583: 
                case 584: 
                case 586: 
                case 587: 
                case 589: 
                case 590: 
                case 591: 
                case 592: 
                case 595: 
                case 599: 
                case 606: 
                case 608: 
                case 611: 
                case 613: 
                case 614: 
                case 616: 
                case 617: 
                case 618: 
                case 619: 
                case 624: 
                case 626: 
                case 627: 
                case 628: 
                case 629: 
                case 630: 
                case 631: 
                case 637: 
                case 638: 
                case 639: 
                case 643: 
                case 645: 
                case 646: 
                case 648: 
                case 649: 
                case 650: 
                case 651: 
                case 655: 
                case 656: 
                case 659: 
                case 661: 
                case 662: 
                case 663: 
                case 664: 
                case 665: 
                case 666: 
                case 668: 
                case 669: 
                case 670: 
                case 674: 
                case 675: 
                case 679: 
                case 681: 
                case 683: 
                case 684: 
                case 693: 
                case 694: 
                case 695: 
                case 696: 
                case 697: 
                case 698: 
                case 699: 
                case 763: 
                case 764: 
                case 765: 
                case 766: 
                case 767: 
                case 768: 
                case 770: {
                    call = this.NamedCall();
                    break;
                }
                default: {
                    this.jj_la1[366] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        if (this.jj_2_88(2)) {
            call = this.nullTreatment(call);
        }
        if (this.jj_2_89(2)) {
            call = this.withinDistinct(call);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 691: {
                call = this.withinGroup(call);
                break;
            }
            default: {
                this.jj_la1[367] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 204: {
                this.jj_consume_token(204);
                Span filterSpan = this.span();
                this.jj_consume_token(715);
                this.jj_consume_token(687);
                SqlNode filter = this.Expression(SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                this.jj_consume_token(716);
                call = SqlStdOperatorTable.FILTER.createCall(filterSpan.end(this), call, filter);
                break;
            }
            default: {
                this.jj_la1[368] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 389: {
                SqlNode over;
                this.jj_consume_token(389);
                Span overSpan = this.span();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 14: 
                    case 17: 
                    case 20: 
                    case 21: 
                    case 24: 
                    case 26: 
                    case 27: 
                    case 31: 
                    case 32: 
                    case 35: 
                    case 39: 
                    case 47: 
                    case 49: 
                    case 53: 
                    case 57: 
                    case 58: 
                    case 61: 
                    case 62: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 74: 
                    case 78: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 86: 
                    case 87: 
                    case 88: 
                    case 90: 
                    case 92: 
                    case 93: 
                    case 95: 
                    case 96: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 104: 
                    case 128: 
                    case 130: 
                    case 131: 
                    case 133: 
                    case 135: 
                    case 136: 
                    case 138: 
                    case 141: 
                    case 145: 
                    case 146: 
                    case 147: 
                    case 149: 
                    case 150: 
                    case 151: 
                    case 154: 
                    case 156: 
                    case 157: 
                    case 159: 
                    case 160: 
                    case 162: 
                    case 165: 
                    case 167: 
                    case 168: 
                    case 170: 
                    case 171: 
                    case 174: 
                    case 175: 
                    case 180: 
                    case 185: 
                    case 187: 
                    case 191: 
                    case 192: 
                    case 193: 
                    case 205: 
                    case 206: 
                    case 210: 
                    case 212: 
                    case 214: 
                    case 215: 
                    case 216: 
                    case 224: 
                    case 225: 
                    case 226: 
                    case 227: 
                    case 230: 
                    case 231: 
                    case 233: 
                    case 235: 
                    case 239: 
                    case 241: 
                    case 243: 
                    case 245: 
                    case 246: 
                    case 247: 
                    case 248: 
                    case 249: 
                    case 252: 
                    case 253: 
                    case 254: 
                    case 257: 
                    case 260: 
                    case 263: 
                    case 264: 
                    case 271: 
                    case 273: 
                    case 274: 
                    case 275: 
                    case 276: 
                    case 278: 
                    case 286: 
                    case 287: 
                    case 288: 
                    case 289: 
                    case 290: 
                    case 294: 
                    case 300: 
                    case 301: 
                    case 302: 
                    case 310: 
                    case 312: 
                    case 313: 
                    case 315: 
                    case 320: 
                    case 324: 
                    case 325: 
                    case 326: 
                    case 328: 
                    case 329: 
                    case 330: 
                    case 333: 
                    case 334: 
                    case 340: 
                    case 341: 
                    case 343: 
                    case 344: 
                    case 345: 
                    case 346: 
                    case 351: 
                    case 357: 
                    case 362: 
                    case 364: 
                    case 365: 
                    case 367: 
                    case 370: 
                    case 379: 
                    case 380: 
                    case 383: 
                    case 384: 
                    case 385: 
                    case 388: 
                    case 392: 
                    case 393: 
                    case 395: 
                    case 396: 
                    case 397: 
                    case 398: 
                    case 399: 
                    case 400: 
                    case 401: 
                    case 403: 
                    case 404: 
                    case 405: 
                    case 406: 
                    case 407: 
                    case 416: 
                    case 417: 
                    case 418: 
                    case 419: 
                    case 425: 
                    case 428: 
                    case 431: 
                    case 432: 
                    case 434: 
                    case 435: 
                    case 436: 
                    case 439: 
                    case 455: 
                    case 457: 
                    case 458: 
                    case 460: 
                    case 461: 
                    case 462: 
                    case 465: 
                    case 466: 
                    case 467: 
                    case 468: 
                    case 469: 
                    case 473: 
                    case 474: 
                    case 477: 
                    case 478: 
                    case 479: 
                    case 480: 
                    case 482: 
                    case 488: 
                    case 489: 
                    case 490: 
                    case 491: 
                    case 493: 
                    case 494: 
                    case 495: 
                    case 499: 
                    case 500: 
                    case 501: 
                    case 504: 
                    case 506: 
                    case 507: 
                    case 508: 
                    case 509: 
                    case 510: 
                    case 511: 
                    case 514: 
                    case 518: 
                    case 519: 
                    case 523: 
                    case 524: 
                    case 526: 
                    case 532: 
                    case 533: 
                    case 534: 
                    case 535: 
                    case 536: 
                    case 537: 
                    case 538: 
                    case 539: 
                    case 540: 
                    case 541: 
                    case 542: 
                    case 543: 
                    case 544: 
                    case 545: 
                    case 546: 
                    case 547: 
                    case 548: 
                    case 549: 
                    case 550: 
                    case 551: 
                    case 552: 
                    case 553: 
                    case 554: 
                    case 555: 
                    case 556: 
                    case 557: 
                    case 558: 
                    case 559: 
                    case 560: 
                    case 561: 
                    case 562: 
                    case 563: 
                    case 564: 
                    case 565: 
                    case 566: 
                    case 567: 
                    case 568: 
                    case 569: 
                    case 570: 
                    case 571: 
                    case 572: 
                    case 573: 
                    case 574: 
                    case 575: 
                    case 576: 
                    case 577: 
                    case 578: 
                    case 579: 
                    case 580: 
                    case 583: 
                    case 584: 
                    case 589: 
                    case 590: 
                    case 591: 
                    case 592: 
                    case 595: 
                    case 606: 
                    case 608: 
                    case 611: 
                    case 613: 
                    case 614: 
                    case 616: 
                    case 617: 
                    case 618: 
                    case 619: 
                    case 624: 
                    case 626: 
                    case 627: 
                    case 628: 
                    case 629: 
                    case 630: 
                    case 631: 
                    case 637: 
                    case 638: 
                    case 639: 
                    case 645: 
                    case 646: 
                    case 648: 
                    case 649: 
                    case 650: 
                    case 651: 
                    case 655: 
                    case 656: 
                    case 661: 
                    case 663: 
                    case 664: 
                    case 665: 
                    case 666: 
                    case 668: 
                    case 669: 
                    case 670: 
                    case 679: 
                    case 681: 
                    case 683: 
                    case 684: 
                    case 693: 
                    case 694: 
                    case 695: 
                    case 696: 
                    case 698: 
                    case 699: 
                    case 763: 
                    case 764: 
                    case 765: 
                    case 766: 
                    case 767: 
                    case 768: 
                    case 770: {
                        over = this.SimpleIdentifier();
                        break;
                    }
                    case 715: {
                        over = this.WindowSpecification();
                        break;
                    }
                    default: {
                        this.jj_la1[369] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                call = SqlStdOperatorTable.OVER.createCall(overSpan.end(over), call, over);
                break;
            }
            default: {
                this.jj_la1[370] = this.jj_gen;
            }
        }
        return call;
    }

    public final SqlCall NamedCall() throws ParseException {
        Object args;
        SqlFunctionCategory funcType;
        SqlLiteral quantifier = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 525: {
                this.jj_consume_token(525);
                funcType = SqlFunctionCategory.USER_DEFINED_SPECIFIC_FUNCTION;
                break;
            }
            default: {
                this.jj_la1[371] = this.jj_gen;
                funcType = SqlFunctionCategory.USER_DEFINED_FUNCTION;
            }
        }
        SqlIdentifier qualifiedName = this.FunctionName();
        Span s = this.span();
        if (this.jj_2_90(2)) {
            this.jj_consume_token(715);
            this.jj_consume_token(739);
            args = ImmutableList.of((Object)SqlIdentifier.star(this.getPos()));
            this.jj_consume_token(716);
        } else if (this.jj_2_91(2)) {
            this.jj_consume_token(715);
            this.jj_consume_token(716);
            args = ImmutableList.of();
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 715: {
                    args = this.FunctionParameterList(SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                    quantifier = (SqlLiteral)args.get(0);
                    args.remove(0);
                    break;
                }
                default: {
                    this.jj_la1[372] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return this.createCall(qualifiedName, s.end(this), funcType, quantifier, (Iterable<? extends SqlNode>)args);
    }

    public final SqlNode StandardFloorCeilOptions(Span s, boolean floorFlag) throws ParseException {
        ArrayList<SqlNode> args = new ArrayList<SqlNode>();
        this.jj_consume_token(715);
        this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 623: {
                this.jj_consume_token(623);
                SqlIntervalQualifier unit = this.TimeUnitOrName();
                args.add(unit);
                break;
            }
            default: {
                this.jj_la1[373] = this.jj_gen;
            }
        }
        this.jj_consume_token(716);
        SqlFunction op = floorFlag ? SqlStdOperatorTable.FLOOR : SqlStdOperatorTable.CEIL;
        SqlCall function = op.createCall(s.end(this), args);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 389: {
                SqlNode e;
                this.jj_consume_token(389);
                Span s1 = this.span();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 14: 
                    case 17: 
                    case 20: 
                    case 21: 
                    case 24: 
                    case 26: 
                    case 27: 
                    case 31: 
                    case 32: 
                    case 35: 
                    case 39: 
                    case 47: 
                    case 49: 
                    case 53: 
                    case 57: 
                    case 58: 
                    case 61: 
                    case 62: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 74: 
                    case 78: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 86: 
                    case 87: 
                    case 88: 
                    case 90: 
                    case 92: 
                    case 93: 
                    case 95: 
                    case 96: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 104: 
                    case 128: 
                    case 130: 
                    case 131: 
                    case 133: 
                    case 135: 
                    case 136: 
                    case 138: 
                    case 141: 
                    case 145: 
                    case 146: 
                    case 147: 
                    case 149: 
                    case 150: 
                    case 151: 
                    case 154: 
                    case 156: 
                    case 157: 
                    case 159: 
                    case 160: 
                    case 162: 
                    case 165: 
                    case 167: 
                    case 168: 
                    case 170: 
                    case 171: 
                    case 174: 
                    case 175: 
                    case 180: 
                    case 185: 
                    case 187: 
                    case 191: 
                    case 192: 
                    case 193: 
                    case 205: 
                    case 206: 
                    case 210: 
                    case 212: 
                    case 214: 
                    case 215: 
                    case 216: 
                    case 224: 
                    case 225: 
                    case 226: 
                    case 227: 
                    case 230: 
                    case 231: 
                    case 233: 
                    case 235: 
                    case 239: 
                    case 241: 
                    case 243: 
                    case 245: 
                    case 246: 
                    case 247: 
                    case 248: 
                    case 249: 
                    case 252: 
                    case 253: 
                    case 254: 
                    case 257: 
                    case 260: 
                    case 263: 
                    case 264: 
                    case 271: 
                    case 273: 
                    case 274: 
                    case 275: 
                    case 276: 
                    case 278: 
                    case 286: 
                    case 287: 
                    case 288: 
                    case 289: 
                    case 290: 
                    case 294: 
                    case 300: 
                    case 301: 
                    case 302: 
                    case 310: 
                    case 312: 
                    case 313: 
                    case 315: 
                    case 320: 
                    case 324: 
                    case 325: 
                    case 326: 
                    case 328: 
                    case 329: 
                    case 330: 
                    case 333: 
                    case 334: 
                    case 340: 
                    case 341: 
                    case 343: 
                    case 344: 
                    case 345: 
                    case 346: 
                    case 351: 
                    case 357: 
                    case 362: 
                    case 364: 
                    case 365: 
                    case 367: 
                    case 370: 
                    case 379: 
                    case 380: 
                    case 383: 
                    case 384: 
                    case 385: 
                    case 388: 
                    case 392: 
                    case 393: 
                    case 395: 
                    case 396: 
                    case 397: 
                    case 398: 
                    case 399: 
                    case 400: 
                    case 401: 
                    case 403: 
                    case 404: 
                    case 405: 
                    case 406: 
                    case 407: 
                    case 416: 
                    case 417: 
                    case 418: 
                    case 419: 
                    case 425: 
                    case 428: 
                    case 431: 
                    case 432: 
                    case 434: 
                    case 435: 
                    case 436: 
                    case 439: 
                    case 455: 
                    case 457: 
                    case 458: 
                    case 460: 
                    case 461: 
                    case 462: 
                    case 465: 
                    case 466: 
                    case 467: 
                    case 468: 
                    case 469: 
                    case 473: 
                    case 474: 
                    case 477: 
                    case 478: 
                    case 479: 
                    case 480: 
                    case 482: 
                    case 488: 
                    case 489: 
                    case 490: 
                    case 491: 
                    case 493: 
                    case 494: 
                    case 495: 
                    case 499: 
                    case 500: 
                    case 501: 
                    case 504: 
                    case 506: 
                    case 507: 
                    case 508: 
                    case 509: 
                    case 510: 
                    case 511: 
                    case 514: 
                    case 518: 
                    case 519: 
                    case 523: 
                    case 524: 
                    case 526: 
                    case 532: 
                    case 533: 
                    case 534: 
                    case 535: 
                    case 536: 
                    case 537: 
                    case 538: 
                    case 539: 
                    case 540: 
                    case 541: 
                    case 542: 
                    case 543: 
                    case 544: 
                    case 545: 
                    case 546: 
                    case 547: 
                    case 548: 
                    case 549: 
                    case 550: 
                    case 551: 
                    case 552: 
                    case 553: 
                    case 554: 
                    case 555: 
                    case 556: 
                    case 557: 
                    case 558: 
                    case 559: 
                    case 560: 
                    case 561: 
                    case 562: 
                    case 563: 
                    case 564: 
                    case 565: 
                    case 566: 
                    case 567: 
                    case 568: 
                    case 569: 
                    case 570: 
                    case 571: 
                    case 572: 
                    case 573: 
                    case 574: 
                    case 575: 
                    case 576: 
                    case 577: 
                    case 578: 
                    case 579: 
                    case 580: 
                    case 583: 
                    case 584: 
                    case 589: 
                    case 590: 
                    case 591: 
                    case 592: 
                    case 595: 
                    case 606: 
                    case 608: 
                    case 611: 
                    case 613: 
                    case 614: 
                    case 616: 
                    case 617: 
                    case 618: 
                    case 619: 
                    case 624: 
                    case 626: 
                    case 627: 
                    case 628: 
                    case 629: 
                    case 630: 
                    case 631: 
                    case 637: 
                    case 638: 
                    case 639: 
                    case 645: 
                    case 646: 
                    case 648: 
                    case 649: 
                    case 650: 
                    case 651: 
                    case 655: 
                    case 656: 
                    case 661: 
                    case 663: 
                    case 664: 
                    case 665: 
                    case 666: 
                    case 668: 
                    case 669: 
                    case 670: 
                    case 679: 
                    case 681: 
                    case 683: 
                    case 684: 
                    case 693: 
                    case 694: 
                    case 695: 
                    case 696: 
                    case 698: 
                    case 699: 
                    case 763: 
                    case 764: 
                    case 765: 
                    case 766: 
                    case 767: 
                    case 768: 
                    case 770: {
                        e = this.SimpleIdentifier();
                        break;
                    }
                    case 715: {
                        e = this.WindowSpecification();
                        break;
                    }
                    default: {
                        this.jj_la1[374] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return SqlStdOperatorTable.OVER.createCall(s1.end(this), function, e);
            }
        }
        this.jj_la1[375] = this.jj_gen;
        return function;
    }

    public final String NonReservedJdbcFunctionName() throws ParseException {
        this.jj_consume_token(596);
        return this.unquotedIdentifier();
    }

    public final SqlIdentifier FunctionName() throws ParseException {
        SqlIdentifier qualifiedName;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 24: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 35: 
            case 39: 
            case 47: 
            case 49: 
            case 53: 
            case 57: 
            case 58: 
            case 61: 
            case 62: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 74: 
            case 78: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 86: 
            case 87: 
            case 88: 
            case 90: 
            case 92: 
            case 93: 
            case 95: 
            case 96: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 104: 
            case 128: 
            case 130: 
            case 131: 
            case 133: 
            case 135: 
            case 136: 
            case 138: 
            case 141: 
            case 145: 
            case 146: 
            case 147: 
            case 149: 
            case 150: 
            case 151: 
            case 154: 
            case 156: 
            case 157: 
            case 159: 
            case 160: 
            case 162: 
            case 165: 
            case 167: 
            case 168: 
            case 170: 
            case 171: 
            case 174: 
            case 175: 
            case 180: 
            case 185: 
            case 187: 
            case 191: 
            case 192: 
            case 193: 
            case 205: 
            case 206: 
            case 210: 
            case 212: 
            case 214: 
            case 215: 
            case 216: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 230: 
            case 231: 
            case 233: 
            case 235: 
            case 239: 
            case 241: 
            case 243: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 252: 
            case 253: 
            case 254: 
            case 257: 
            case 260: 
            case 263: 
            case 264: 
            case 271: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 278: 
            case 286: 
            case 287: 
            case 288: 
            case 289: 
            case 290: 
            case 294: 
            case 300: 
            case 301: 
            case 302: 
            case 310: 
            case 312: 
            case 313: 
            case 315: 
            case 320: 
            case 324: 
            case 325: 
            case 326: 
            case 328: 
            case 329: 
            case 330: 
            case 333: 
            case 334: 
            case 340: 
            case 341: 
            case 343: 
            case 344: 
            case 345: 
            case 346: 
            case 351: 
            case 357: 
            case 362: 
            case 364: 
            case 365: 
            case 367: 
            case 370: 
            case 379: 
            case 380: 
            case 383: 
            case 384: 
            case 385: 
            case 388: 
            case 392: 
            case 393: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 399: 
            case 400: 
            case 401: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 416: 
            case 417: 
            case 418: 
            case 419: 
            case 425: 
            case 428: 
            case 431: 
            case 432: 
            case 434: 
            case 435: 
            case 436: 
            case 439: 
            case 455: 
            case 457: 
            case 458: 
            case 460: 
            case 461: 
            case 462: 
            case 465: 
            case 466: 
            case 467: 
            case 468: 
            case 469: 
            case 473: 
            case 474: 
            case 477: 
            case 478: 
            case 479: 
            case 480: 
            case 482: 
            case 488: 
            case 489: 
            case 490: 
            case 491: 
            case 493: 
            case 494: 
            case 495: 
            case 499: 
            case 500: 
            case 501: 
            case 504: 
            case 506: 
            case 507: 
            case 508: 
            case 509: 
            case 510: 
            case 511: 
            case 514: 
            case 518: 
            case 519: 
            case 523: 
            case 524: 
            case 526: 
            case 532: 
            case 533: 
            case 534: 
            case 535: 
            case 536: 
            case 537: 
            case 538: 
            case 539: 
            case 540: 
            case 541: 
            case 542: 
            case 543: 
            case 544: 
            case 545: 
            case 546: 
            case 547: 
            case 548: 
            case 549: 
            case 550: 
            case 551: 
            case 552: 
            case 553: 
            case 554: 
            case 555: 
            case 556: 
            case 557: 
            case 558: 
            case 559: 
            case 560: 
            case 561: 
            case 562: 
            case 563: 
            case 564: 
            case 565: 
            case 566: 
            case 567: 
            case 568: 
            case 569: 
            case 570: 
            case 571: 
            case 572: 
            case 573: 
            case 574: 
            case 575: 
            case 576: 
            case 577: 
            case 578: 
            case 579: 
            case 580: 
            case 583: 
            case 584: 
            case 589: 
            case 590: 
            case 591: 
            case 592: 
            case 595: 
            case 606: 
            case 608: 
            case 611: 
            case 613: 
            case 614: 
            case 616: 
            case 617: 
            case 618: 
            case 619: 
            case 624: 
            case 626: 
            case 627: 
            case 628: 
            case 629: 
            case 630: 
            case 631: 
            case 637: 
            case 638: 
            case 639: 
            case 645: 
            case 646: 
            case 648: 
            case 649: 
            case 650: 
            case 651: 
            case 655: 
            case 656: 
            case 661: 
            case 663: 
            case 664: 
            case 665: 
            case 666: 
            case 668: 
            case 669: 
            case 670: 
            case 679: 
            case 681: 
            case 683: 
            case 684: 
            case 693: 
            case 694: 
            case 695: 
            case 696: 
            case 698: 
            case 699: 
            case 763: 
            case 764: 
            case 765: 
            case 766: 
            case 767: 
            case 768: 
            case 770: {
                qualifiedName = this.CompoundIdentifier();
                break;
            }
            case 2: 
            case 34: 
            case 52: 
            case 60: 
            case 63: 
            case 64: 
            case 66: 
            case 77: 
            case 84: 
            case 108: 
            case 109: 
            case 110: 
            case 114: 
            case 117: 
            case 123: 
            case 124: 
            case 153: 
            case 177: 
            case 189: 
            case 197: 
            case 207: 
            case 209: 
            case 223: 
            case 236: 
            case 242: 
            case 268: 
            case 291: 
            case 295: 
            case 297: 
            case 299: 
            case 306: 
            case 308: 
            case 309: 
            case 311: 
            case 319: 
            case 331: 
            case 332: 
            case 335: 
            case 339: 
            case 359: 
            case 360: 
            case 363: 
            case 369: 
            case 411: 
            case 412: 
            case 413: 
            case 423: 
            case 438: 
            case 448: 
            case 452: 
            case 454: 
            case 472: 
            case 483: 
            case 498: 
            case 522: 
            case 581: 
            case 586: 
            case 587: 
            case 599: 
            case 643: 
            case 659: 
            case 662: 
            case 674: 
            case 675: 
            case 697: {
                qualifiedName = this.ReservedFunctionName();
                break;
            }
            default: {
                this.jj_la1[376] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return qualifiedName;
    }

    public final SqlIdentifier ReservedFunctionName() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 2: {
                this.jj_consume_token(2);
                break;
            }
            case 34: {
                this.jj_consume_token(34);
                break;
            }
            case 52: {
                this.jj_consume_token(52);
                break;
            }
            case 60: {
                this.jj_consume_token(60);
                break;
            }
            case 63: {
                this.jj_consume_token(63);
                break;
            }
            case 64: {
                this.jj_consume_token(64);
                break;
            }
            case 66: {
                this.jj_consume_token(66);
                break;
            }
            case 77: {
                this.jj_consume_token(77);
                break;
            }
            case 84: {
                this.jj_consume_token(84);
                break;
            }
            case 109: {
                this.jj_consume_token(109);
                break;
            }
            case 110: {
                this.jj_consume_token(110);
                break;
            }
            case 114: {
                this.jj_consume_token(114);
                break;
            }
            case 108: {
                this.jj_consume_token(108);
                break;
            }
            case 117: {
                this.jj_consume_token(117);
                break;
            }
            case 123: {
                this.jj_consume_token(123);
                break;
            }
            case 124: {
                this.jj_consume_token(124);
                break;
            }
            case 153: {
                this.jj_consume_token(153);
                break;
            }
            case 177: {
                this.jj_consume_token(177);
                break;
            }
            case 189: {
                this.jj_consume_token(189);
                break;
            }
            case 197: {
                this.jj_consume_token(197);
                break;
            }
            case 207: {
                this.jj_consume_token(207);
                break;
            }
            case 209: {
                this.jj_consume_token(209);
                break;
            }
            case 223: {
                this.jj_consume_token(223);
                break;
            }
            case 268: {
                this.jj_consume_token(268);
                break;
            }
            case 236: {
                this.jj_consume_token(236);
                break;
            }
            case 242: {
                this.jj_consume_token(242);
                break;
            }
            case 291: {
                this.jj_consume_token(291);
                break;
            }
            case 297: {
                this.jj_consume_token(297);
                break;
            }
            case 299: {
                this.jj_consume_token(299);
                break;
            }
            case 295: {
                this.jj_consume_token(295);
                break;
            }
            case 306: {
                this.jj_consume_token(306);
                break;
            }
            case 308: {
                this.jj_consume_token(308);
                break;
            }
            case 309: {
                this.jj_consume_token(309);
                break;
            }
            case 311: {
                this.jj_consume_token(311);
                break;
            }
            case 319: {
                this.jj_consume_token(319);
                break;
            }
            case 331: {
                this.jj_consume_token(331);
                break;
            }
            case 332: {
                this.jj_consume_token(332);
                break;
            }
            case 335: {
                this.jj_consume_token(335);
                break;
            }
            case 339: {
                this.jj_consume_token(339);
                break;
            }
            case 359: {
                this.jj_consume_token(359);
                break;
            }
            case 360: {
                this.jj_consume_token(360);
                break;
            }
            case 363: {
                this.jj_consume_token(363);
                break;
            }
            case 369: {
                this.jj_consume_token(369);
                break;
            }
            case 413: {
                this.jj_consume_token(413);
                break;
            }
            case 411: {
                this.jj_consume_token(411);
                break;
            }
            case 412: {
                this.jj_consume_token(412);
                break;
            }
            case 423: {
                this.jj_consume_token(423);
                break;
            }
            case 438: {
                this.jj_consume_token(438);
                break;
            }
            case 448: {
                this.jj_consume_token(448);
                break;
            }
            case 452: {
                this.jj_consume_token(452);
                break;
            }
            case 454: {
                this.jj_consume_token(454);
                break;
            }
            case 472: {
                this.jj_consume_token(472);
                break;
            }
            case 483: {
                this.jj_consume_token(483);
                break;
            }
            case 498: {
                this.jj_consume_token(498);
                break;
            }
            case 522: {
                this.jj_consume_token(522);
                break;
            }
            case 581: {
                this.jj_consume_token(581);
                break;
            }
            case 586: {
                this.jj_consume_token(586);
                break;
            }
            case 587: {
                this.jj_consume_token(587);
                break;
            }
            case 599: {
                this.jj_consume_token(599);
                break;
            }
            case 659: {
                this.jj_consume_token(659);
                break;
            }
            case 643: {
                this.jj_consume_token(643);
                break;
            }
            case 662: {
                this.jj_consume_token(662);
                break;
            }
            case 674: {
                this.jj_consume_token(674);
                break;
            }
            case 675: {
                this.jj_consume_token(675);
                break;
            }
            case 697: {
                this.jj_consume_token(697);
                break;
            }
            default: {
                this.jj_la1[377] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return new SqlIdentifier(this.unquotedIdentifier(), this.getPos());
    }

    public final SqlIdentifier ContextVariable() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 116: {
                this.jj_consume_token(116);
                break;
            }
            case 117: {
                this.jj_consume_token(117);
                break;
            }
            case 118: {
                this.jj_consume_token(118);
                break;
            }
            case 119: {
                this.jj_consume_token(119);
                break;
            }
            case 120: {
                this.jj_consume_token(120);
                break;
            }
            case 122: {
                this.jj_consume_token(122);
                break;
            }
            case 123: {
                this.jj_consume_token(123);
                break;
            }
            case 124: {
                this.jj_consume_token(124);
                break;
            }
            case 126: {
                this.jj_consume_token(126);
                break;
            }
            case 308: {
                this.jj_consume_token(308);
                break;
            }
            case 309: {
                this.jj_consume_token(309);
                break;
            }
            case 512: {
                this.jj_consume_token(512);
                break;
            }
            case 604: {
                this.jj_consume_token(604);
                break;
            }
            case 662: {
                this.jj_consume_token(662);
                break;
            }
            default: {
                this.jj_la1[378] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return new SqlIdentifier(this.unquotedIdentifier(), this.getPos());
    }

    public final SqlNode JdbcFunctionCall() throws ParseException {
        SqlNodeList args;
        String name;
        this.jj_consume_token(720);
        Span s = this.span();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 616: {
                SqlCall call = this.TimestampAddFunctionCall();
                name = call.getOperator().getName();
                args = new SqlNodeList(call.getOperandList(), this.getPos());
                break;
            }
            case 133: {
                SqlCall call = this.DateTruncFunctionCall();
                name = call.getOperator().getName();
                args = new SqlNodeList(call.getOperandList(), this.getPos());
                break;
            }
            case 619: {
                SqlCall call = this.TimestampTruncFunctionCall();
                name = call.getOperator().getName();
                args = new SqlNodeList(call.getOperandList(), this.getPos());
                break;
            }
            case 614: {
                SqlCall call = this.TimeTruncFunctionCall();
                name = call.getOperator().getName();
                args = new SqlNodeList(call.getOperandList(), this.getPos());
                break;
            }
            case 618: {
                SqlCall call = this.TimestampDiff3FunctionCall();
                name = call.getOperator().getName();
                args = new SqlNodeList(call.getOperandList(), this.getPos());
                break;
            }
            case 613: {
                SqlCall call = this.TimeDiffFunctionCall();
                name = call.getOperator().getName();
                args = new SqlNodeList(call.getOperandList(), this.getPos());
                break;
            }
            default: {
                this.jj_la1[382] = this.jj_gen;
                if (this.jj_2_94(3)) {
                    SqlCall call = this.TimestampDiffFunctionCall();
                    name = call.getOperator().getName();
                    args = new SqlNodeList(call.getOperandList(), this.getPos());
                    break;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 105: {
                        this.jj_consume_token(105);
                        name = this.unquotedIdentifier();
                        this.jj_consume_token(715);
                        SqlNode e = this.Expression(SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                        args = new SqlNodeList(this.getPos());
                        args.add(e);
                        this.jj_consume_token(727);
                        SqlLiteral tl = this.JdbcOdbcDataType();
                        args.add(tl);
                        this.jj_consume_token(716);
                        break block0;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 14: 
                    case 17: 
                    case 20: 
                    case 21: 
                    case 24: 
                    case 26: 
                    case 27: 
                    case 31: 
                    case 32: 
                    case 34: 
                    case 35: 
                    case 39: 
                    case 47: 
                    case 49: 
                    case 52: 
                    case 53: 
                    case 57: 
                    case 58: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 74: 
                    case 77: 
                    case 78: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 86: 
                    case 87: 
                    case 88: 
                    case 90: 
                    case 92: 
                    case 93: 
                    case 95: 
                    case 96: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 104: 
                    case 108: 
                    case 109: 
                    case 110: 
                    case 114: 
                    case 117: 
                    case 123: 
                    case 124: 
                    case 128: 
                    case 130: 
                    case 131: 
                    case 133: 
                    case 135: 
                    case 136: 
                    case 138: 
                    case 141: 
                    case 145: 
                    case 146: 
                    case 147: 
                    case 149: 
                    case 150: 
                    case 151: 
                    case 153: 
                    case 154: 
                    case 156: 
                    case 157: 
                    case 159: 
                    case 160: 
                    case 162: 
                    case 165: 
                    case 167: 
                    case 168: 
                    case 170: 
                    case 171: 
                    case 174: 
                    case 175: 
                    case 177: 
                    case 180: 
                    case 185: 
                    case 187: 
                    case 189: 
                    case 191: 
                    case 192: 
                    case 193: 
                    case 197: 
                    case 205: 
                    case 206: 
                    case 207: 
                    case 209: 
                    case 210: 
                    case 212: 
                    case 214: 
                    case 215: 
                    case 216: 
                    case 223: 
                    case 224: 
                    case 225: 
                    case 226: 
                    case 227: 
                    case 230: 
                    case 231: 
                    case 233: 
                    case 235: 
                    case 236: 
                    case 239: 
                    case 241: 
                    case 242: 
                    case 243: 
                    case 245: 
                    case 246: 
                    case 247: 
                    case 248: 
                    case 249: 
                    case 252: 
                    case 253: 
                    case 254: 
                    case 257: 
                    case 260: 
                    case 262: 
                    case 263: 
                    case 264: 
                    case 268: 
                    case 271: 
                    case 273: 
                    case 274: 
                    case 275: 
                    case 276: 
                    case 278: 
                    case 286: 
                    case 287: 
                    case 288: 
                    case 289: 
                    case 290: 
                    case 291: 
                    case 294: 
                    case 295: 
                    case 297: 
                    case 299: 
                    case 300: 
                    case 301: 
                    case 302: 
                    case 306: 
                    case 308: 
                    case 309: 
                    case 310: 
                    case 311: 
                    case 312: 
                    case 313: 
                    case 315: 
                    case 319: 
                    case 320: 
                    case 324: 
                    case 325: 
                    case 326: 
                    case 328: 
                    case 329: 
                    case 330: 
                    case 331: 
                    case 332: 
                    case 333: 
                    case 334: 
                    case 335: 
                    case 339: 
                    case 340: 
                    case 341: 
                    case 343: 
                    case 344: 
                    case 345: 
                    case 346: 
                    case 351: 
                    case 357: 
                    case 359: 
                    case 360: 
                    case 362: 
                    case 363: 
                    case 364: 
                    case 365: 
                    case 367: 
                    case 369: 
                    case 370: 
                    case 379: 
                    case 380: 
                    case 383: 
                    case 384: 
                    case 385: 
                    case 388: 
                    case 392: 
                    case 393: 
                    case 395: 
                    case 396: 
                    case 397: 
                    case 398: 
                    case 399: 
                    case 400: 
                    case 401: 
                    case 403: 
                    case 404: 
                    case 405: 
                    case 406: 
                    case 407: 
                    case 411: 
                    case 412: 
                    case 413: 
                    case 416: 
                    case 417: 
                    case 418: 
                    case 419: 
                    case 423: 
                    case 425: 
                    case 428: 
                    case 431: 
                    case 432: 
                    case 434: 
                    case 435: 
                    case 436: 
                    case 438: 
                    case 439: 
                    case 448: 
                    case 452: 
                    case 454: 
                    case 455: 
                    case 457: 
                    case 458: 
                    case 460: 
                    case 461: 
                    case 462: 
                    case 465: 
                    case 466: 
                    case 467: 
                    case 468: 
                    case 469: 
                    case 472: 
                    case 473: 
                    case 474: 
                    case 477: 
                    case 478: 
                    case 479: 
                    case 480: 
                    case 482: 
                    case 483: 
                    case 488: 
                    case 489: 
                    case 490: 
                    case 491: 
                    case 493: 
                    case 494: 
                    case 495: 
                    case 498: 
                    case 499: 
                    case 500: 
                    case 501: 
                    case 504: 
                    case 506: 
                    case 507: 
                    case 508: 
                    case 509: 
                    case 510: 
                    case 511: 
                    case 514: 
                    case 518: 
                    case 519: 
                    case 522: 
                    case 523: 
                    case 524: 
                    case 526: 
                    case 532: 
                    case 533: 
                    case 534: 
                    case 535: 
                    case 536: 
                    case 537: 
                    case 538: 
                    case 539: 
                    case 540: 
                    case 541: 
                    case 542: 
                    case 543: 
                    case 544: 
                    case 545: 
                    case 546: 
                    case 547: 
                    case 548: 
                    case 549: 
                    case 550: 
                    case 551: 
                    case 552: 
                    case 553: 
                    case 554: 
                    case 555: 
                    case 556: 
                    case 557: 
                    case 558: 
                    case 559: 
                    case 560: 
                    case 561: 
                    case 562: 
                    case 563: 
                    case 564: 
                    case 565: 
                    case 566: 
                    case 567: 
                    case 568: 
                    case 569: 
                    case 570: 
                    case 571: 
                    case 572: 
                    case 573: 
                    case 574: 
                    case 575: 
                    case 576: 
                    case 577: 
                    case 578: 
                    case 579: 
                    case 580: 
                    case 581: 
                    case 583: 
                    case 584: 
                    case 586: 
                    case 587: 
                    case 589: 
                    case 590: 
                    case 591: 
                    case 592: 
                    case 595: 
                    case 596: 
                    case 599: 
                    case 606: 
                    case 608: 
                    case 611: 
                    case 613: 
                    case 614: 
                    case 616: 
                    case 617: 
                    case 618: 
                    case 619: 
                    case 624: 
                    case 626: 
                    case 627: 
                    case 628: 
                    case 629: 
                    case 630: 
                    case 631: 
                    case 637: 
                    case 638: 
                    case 639: 
                    case 643: 
                    case 645: 
                    case 646: 
                    case 648: 
                    case 649: 
                    case 650: 
                    case 651: 
                    case 655: 
                    case 656: 
                    case 659: 
                    case 661: 
                    case 662: 
                    case 663: 
                    case 664: 
                    case 665: 
                    case 666: 
                    case 668: 
                    case 669: 
                    case 670: 
                    case 674: 
                    case 675: 
                    case 679: 
                    case 681: 
                    case 683: 
                    case 684: 
                    case 693: 
                    case 694: 
                    case 695: 
                    case 696: 
                    case 697: 
                    case 698: 
                    case 699: 
                    case 763: 
                    case 764: 
                    case 765: 
                    case 766: 
                    case 767: 
                    case 768: 
                    case 770: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 262: 
                            case 299: 
                            case 472: 
                            case 643: {
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 262: {
                                        this.jj_consume_token(262);
                                        break;
                                    }
                                    case 299: {
                                        this.jj_consume_token(299);
                                        break;
                                    }
                                    case 472: {
                                        this.jj_consume_token(472);
                                        break;
                                    }
                                    case 643: {
                                        this.jj_consume_token(643);
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[379] = this.jj_gen;
                                        this.jj_consume_token(-1);
                                        throw new ParseException();
                                    }
                                }
                                name = this.unquotedIdentifier();
                                break;
                            }
                            case 2: 
                            case 34: 
                            case 52: 
                            case 60: 
                            case 63: 
                            case 64: 
                            case 66: 
                            case 77: 
                            case 84: 
                            case 108: 
                            case 109: 
                            case 110: 
                            case 114: 
                            case 117: 
                            case 123: 
                            case 124: 
                            case 153: 
                            case 177: 
                            case 189: 
                            case 197: 
                            case 207: 
                            case 209: 
                            case 223: 
                            case 236: 
                            case 242: 
                            case 268: 
                            case 291: 
                            case 295: 
                            case 297: 
                            case 306: 
                            case 308: 
                            case 309: 
                            case 311: 
                            case 319: 
                            case 331: 
                            case 332: 
                            case 335: 
                            case 339: 
                            case 359: 
                            case 360: 
                            case 363: 
                            case 369: 
                            case 411: 
                            case 412: 
                            case 413: 
                            case 423: 
                            case 438: 
                            case 448: 
                            case 452: 
                            case 454: 
                            case 483: 
                            case 498: 
                            case 522: 
                            case 581: 
                            case 586: 
                            case 587: 
                            case 599: 
                            case 659: 
                            case 662: 
                            case 674: 
                            case 675: 
                            case 697: {
                                SqlIdentifier id = this.ReservedFunctionName();
                                name = id.getSimple();
                                break;
                            }
                            case 596: {
                                name = this.NonReservedJdbcFunctionName();
                                break;
                            }
                            case 1: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: 
                            case 7: 
                            case 8: 
                            case 9: 
                            case 14: 
                            case 17: 
                            case 20: 
                            case 21: 
                            case 24: 
                            case 26: 
                            case 27: 
                            case 31: 
                            case 32: 
                            case 35: 
                            case 39: 
                            case 47: 
                            case 49: 
                            case 53: 
                            case 57: 
                            case 58: 
                            case 61: 
                            case 62: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: 
                            case 71: 
                            case 74: 
                            case 78: 
                            case 80: 
                            case 81: 
                            case 82: 
                            case 83: 
                            case 86: 
                            case 87: 
                            case 88: 
                            case 90: 
                            case 92: 
                            case 93: 
                            case 95: 
                            case 96: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: 
                            case 104: 
                            case 128: 
                            case 130: 
                            case 131: 
                            case 133: 
                            case 135: 
                            case 136: 
                            case 138: 
                            case 141: 
                            case 145: 
                            case 146: 
                            case 147: 
                            case 149: 
                            case 150: 
                            case 151: 
                            case 154: 
                            case 156: 
                            case 157: 
                            case 159: 
                            case 160: 
                            case 162: 
                            case 165: 
                            case 167: 
                            case 168: 
                            case 170: 
                            case 171: 
                            case 174: 
                            case 175: 
                            case 180: 
                            case 185: 
                            case 187: 
                            case 191: 
                            case 192: 
                            case 193: 
                            case 205: 
                            case 206: 
                            case 210: 
                            case 212: 
                            case 214: 
                            case 215: 
                            case 216: 
                            case 224: 
                            case 225: 
                            case 226: 
                            case 227: 
                            case 230: 
                            case 231: 
                            case 233: 
                            case 235: 
                            case 239: 
                            case 241: 
                            case 243: 
                            case 245: 
                            case 246: 
                            case 247: 
                            case 248: 
                            case 249: 
                            case 252: 
                            case 253: 
                            case 254: 
                            case 257: 
                            case 260: 
                            case 263: 
                            case 264: 
                            case 271: 
                            case 273: 
                            case 274: 
                            case 275: 
                            case 276: 
                            case 278: 
                            case 286: 
                            case 287: 
                            case 288: 
                            case 289: 
                            case 290: 
                            case 294: 
                            case 300: 
                            case 301: 
                            case 302: 
                            case 310: 
                            case 312: 
                            case 313: 
                            case 315: 
                            case 320: 
                            case 324: 
                            case 325: 
                            case 326: 
                            case 328: 
                            case 329: 
                            case 330: 
                            case 333: 
                            case 334: 
                            case 340: 
                            case 341: 
                            case 343: 
                            case 344: 
                            case 345: 
                            case 346: 
                            case 351: 
                            case 357: 
                            case 362: 
                            case 364: 
                            case 365: 
                            case 367: 
                            case 370: 
                            case 379: 
                            case 380: 
                            case 383: 
                            case 384: 
                            case 385: 
                            case 388: 
                            case 392: 
                            case 393: 
                            case 395: 
                            case 396: 
                            case 397: 
                            case 398: 
                            case 399: 
                            case 400: 
                            case 401: 
                            case 403: 
                            case 404: 
                            case 405: 
                            case 406: 
                            case 407: 
                            case 416: 
                            case 417: 
                            case 418: 
                            case 419: 
                            case 425: 
                            case 428: 
                            case 431: 
                            case 432: 
                            case 434: 
                            case 435: 
                            case 436: 
                            case 439: 
                            case 455: 
                            case 457: 
                            case 458: 
                            case 460: 
                            case 461: 
                            case 462: 
                            case 465: 
                            case 466: 
                            case 467: 
                            case 468: 
                            case 469: 
                            case 473: 
                            case 474: 
                            case 477: 
                            case 478: 
                            case 479: 
                            case 480: 
                            case 482: 
                            case 488: 
                            case 489: 
                            case 490: 
                            case 491: 
                            case 493: 
                            case 494: 
                            case 495: 
                            case 499: 
                            case 500: 
                            case 501: 
                            case 504: 
                            case 506: 
                            case 507: 
                            case 508: 
                            case 509: 
                            case 510: 
                            case 511: 
                            case 514: 
                            case 518: 
                            case 519: 
                            case 523: 
                            case 524: 
                            case 526: 
                            case 532: 
                            case 533: 
                            case 534: 
                            case 535: 
                            case 536: 
                            case 537: 
                            case 538: 
                            case 539: 
                            case 540: 
                            case 541: 
                            case 542: 
                            case 543: 
                            case 544: 
                            case 545: 
                            case 546: 
                            case 547: 
                            case 548: 
                            case 549: 
                            case 550: 
                            case 551: 
                            case 552: 
                            case 553: 
                            case 554: 
                            case 555: 
                            case 556: 
                            case 557: 
                            case 558: 
                            case 559: 
                            case 560: 
                            case 561: 
                            case 562: 
                            case 563: 
                            case 564: 
                            case 565: 
                            case 566: 
                            case 567: 
                            case 568: 
                            case 569: 
                            case 570: 
                            case 571: 
                            case 572: 
                            case 573: 
                            case 574: 
                            case 575: 
                            case 576: 
                            case 577: 
                            case 578: 
                            case 579: 
                            case 580: 
                            case 583: 
                            case 584: 
                            case 589: 
                            case 590: 
                            case 591: 
                            case 592: 
                            case 595: 
                            case 606: 
                            case 608: 
                            case 611: 
                            case 613: 
                            case 614: 
                            case 616: 
                            case 617: 
                            case 618: 
                            case 619: 
                            case 624: 
                            case 626: 
                            case 627: 
                            case 628: 
                            case 629: 
                            case 630: 
                            case 631: 
                            case 637: 
                            case 638: 
                            case 639: 
                            case 645: 
                            case 646: 
                            case 648: 
                            case 649: 
                            case 650: 
                            case 651: 
                            case 655: 
                            case 656: 
                            case 661: 
                            case 663: 
                            case 664: 
                            case 665: 
                            case 666: 
                            case 668: 
                            case 669: 
                            case 670: 
                            case 679: 
                            case 681: 
                            case 683: 
                            case 684: 
                            case 693: 
                            case 694: 
                            case 695: 
                            case 696: 
                            case 698: 
                            case 699: 
                            case 763: 
                            case 764: 
                            case 765: 
                            case 766: 
                            case 767: 
                            case 768: 
                            case 770: {
                                name = this.Identifier();
                                break;
                            }
                            default: {
                                this.jj_la1[380] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        if (this.jj_2_92(2)) {
                            this.jj_consume_token(715);
                            this.jj_consume_token(739);
                            Span s1 = this.span();
                            this.jj_consume_token(716);
                            args = new SqlNodeList(s1.pos());
                            args.add(SqlIdentifier.star(s1.pos()));
                            break block0;
                        }
                        if (this.jj_2_93(2)) {
                            this.jj_consume_token(715);
                            this.jj_consume_token(716);
                            args = SqlNodeList.EMPTY;
                            break block0;
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 715: {
                                args = this.ParenthesizedQueryOrCommaList(SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                                break block0;
                            }
                        }
                        this.jj_la1[381] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_la1[383] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(722);
        return new SqlJdbcFunctionCall(name).createCall(s.end(this), args.getList());
    }

    public final SqlBinaryOperator BinaryQueryOperator() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 652: {
                this.jj_consume_token(652);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 10: {
                        this.jj_consume_token(10);
                        return SqlStdOperatorTable.UNION_ALL;
                    }
                    case 166: {
                        this.jj_consume_token(166);
                        return SqlStdOperatorTable.UNION;
                    }
                }
                this.jj_la1[384] = this.jj_gen;
                return SqlStdOperatorTable.UNION;
            }
            case 267: {
                this.jj_consume_token(267);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 10: {
                        this.jj_consume_token(10);
                        return SqlStdOperatorTable.INTERSECT_ALL;
                    }
                    case 166: {
                        this.jj_consume_token(166);
                        return SqlStdOperatorTable.INTERSECT;
                    }
                }
                this.jj_la1[385] = this.jj_gen;
                return SqlStdOperatorTable.INTERSECT;
            }
            case 190: 
            case 515: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 190: {
                        this.jj_consume_token(190);
                        break;
                    }
                    case 515: {
                        this.jj_consume_token(515);
                        if (this.conformance.isMinusAllowed()) break;
                        throw SqlUtil.newContextException(this.getPos(), Static.RESOURCE.minusNotAllowed());
                    }
                    default: {
                        this.jj_la1[386] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 10: {
                        this.jj_consume_token(10);
                        return SqlStdOperatorTable.EXCEPT_ALL;
                    }
                    case 166: {
                        this.jj_consume_token(166);
                        return SqlStdOperatorTable.EXCEPT;
                    }
                }
                this.jj_la1[387] = this.jj_gen;
                return SqlStdOperatorTable.EXCEPT;
            }
        }
        this.jj_la1[388] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SqlBinaryOperator BinaryMultisetOperator() throws ParseException {
        this.jj_consume_token(342);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 652: {
                this.jj_consume_token(652);
                block5 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 10: 
                    case 166: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 10: {
                                this.jj_consume_token(10);
                                break block5;
                            }
                            case 166: {
                                this.jj_consume_token(166);
                                return SqlStdOperatorTable.MULTISET_UNION_DISTINCT;
                            }
                        }
                        this.jj_la1[389] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        this.jj_la1[390] = this.jj_gen;
                    }
                }
                return SqlStdOperatorTable.MULTISET_UNION;
            }
            case 267: {
                this.jj_consume_token(267);
                block12 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 10: 
                    case 166: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 10: {
                                this.jj_consume_token(10);
                                break block12;
                            }
                            case 166: {
                                this.jj_consume_token(166);
                                return SqlStdOperatorTable.MULTISET_INTERSECT_DISTINCT;
                            }
                        }
                        this.jj_la1[391] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        this.jj_la1[392] = this.jj_gen;
                    }
                }
                return SqlStdOperatorTable.MULTISET_INTERSECT;
            }
            case 190: {
                this.jj_consume_token(190);
                block19 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 10: 
                    case 166: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 10: {
                                this.jj_consume_token(10);
                                break block19;
                            }
                            case 166: {
                                this.jj_consume_token(166);
                                return SqlStdOperatorTable.MULTISET_EXCEPT_DISTINCT;
                            }
                        }
                        this.jj_la1[393] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        this.jj_la1[394] = this.jj_gen;
                    }
                }
                return SqlStdOperatorTable.MULTISET_EXCEPT;
            }
        }
        this.jj_la1[395] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SqlBinaryOperator BinaryRowOperator() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 728: {
                this.jj_consume_token(728);
                return SqlStdOperatorTable.EQUALS;
            }
            case 729: {
                this.jj_consume_token(729);
                return SqlStdOperatorTable.GREATER_THAN;
            }
            case 730: {
                this.jj_consume_token(730);
                return SqlStdOperatorTable.LESS_THAN;
            }
            case 733: {
                this.jj_consume_token(733);
                return SqlStdOperatorTable.LESS_THAN_OR_EQUAL;
            }
            case 734: {
                this.jj_consume_token(734);
                return SqlStdOperatorTable.GREATER_THAN_OR_EQUAL;
            }
            case 735: {
                this.jj_consume_token(735);
                return SqlStdOperatorTable.NOT_EQUALS;
            }
            case 736: {
                this.jj_consume_token(736);
                if (!this.conformance.isBangEqualAllowed()) {
                    throw SqlUtil.newContextException(this.getPos(), Static.RESOURCE.bangEqualNotAllowed());
                }
                return SqlStdOperatorTable.NOT_EQUALS;
            }
            case 737: {
                this.jj_consume_token(737);
                return SqlStdOperatorTable.PLUS;
            }
            case 738: {
                this.jj_consume_token(738);
                return SqlStdOperatorTable.MINUS;
            }
            case 739: {
                this.jj_consume_token(739);
                return SqlStdOperatorTable.MULTIPLY;
            }
            case 740: {
                this.jj_consume_token(740);
                return SqlStdOperatorTable.DIVIDE;
            }
            case 741: {
                this.jj_consume_token(741);
                if (!this.conformance.isPercentRemainderAllowed()) {
                    throw SqlUtil.newContextException(this.getPos(), Static.RESOURCE.percentRemainderNotAllowed());
                }
                return SqlStdOperatorTable.PERCENT_REMAINDER;
            }
            case 742: {
                this.jj_consume_token(742);
                return SqlStdOperatorTable.CONCAT;
            }
            case 15: {
                this.jj_consume_token(15);
                return SqlStdOperatorTable.AND;
            }
            case 381: {
                this.jj_consume_token(381);
                return SqlStdOperatorTable.OR;
            }
        }
        this.jj_la1[396] = this.jj_gen;
        if (this.jj_2_95(2)) {
            this.jj_consume_token(272);
            this.jj_consume_token(166);
            this.jj_consume_token(220);
            return SqlStdOperatorTable.IS_DISTINCT_FROM;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 272: {
                this.jj_consume_token(272);
                this.jj_consume_token(358);
                this.jj_consume_token(166);
                this.jj_consume_token(220);
                return SqlStdOperatorTable.IS_NOT_DISTINCT_FROM;
            }
            case 322: {
                this.jj_consume_token(322);
                this.jj_consume_token(371);
                return SqlStdOperatorTable.MEMBER_OF;
            }
        }
        this.jj_la1[397] = this.jj_gen;
        if (this.jj_2_96(2)) {
            this.jj_consume_token(593);
            this.jj_consume_token(371);
            return SqlStdOperatorTable.SUBMULTISET_OF;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 358: {
                this.jj_consume_token(358);
                this.jj_consume_token(593);
                this.jj_consume_token(371);
                return SqlStdOperatorTable.NOT_SUBMULTISET_OF;
            }
            case 103: {
                this.jj_consume_token(103);
                return SqlStdOperatorTable.CONTAINS;
            }
            case 390: {
                this.jj_consume_token(390);
                return SqlStdOperatorTable.OVERLAPS;
            }
            case 186: {
                this.jj_consume_token(186);
                return SqlStdOperatorTable.PERIOD_EQUALS;
            }
            case 424: {
                this.jj_consume_token(424);
                return SqlStdOperatorTable.PRECEDES;
            }
            case 598: {
                this.jj_consume_token(598);
                return SqlStdOperatorTable.SUCCEEDS;
            }
        }
        this.jj_la1[398] = this.jj_gen;
        if (this.jj_2_97(2)) {
            this.jj_consume_token(248);
            this.jj_consume_token(424);
            return SqlStdOperatorTable.IMMEDIATELY_PRECEDES;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 248: {
                this.jj_consume_token(248);
                this.jj_consume_token(598);
                return SqlStdOperatorTable.IMMEDIATELY_SUCCEEDS;
            }
            case 342: {
                SqlBinaryOperator op = this.BinaryMultisetOperator();
                return op;
            }
        }
        this.jj_la1[399] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SqlPrefixOperator PrefixRowOperator() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 737: {
                this.jj_consume_token(737);
                return SqlStdOperatorTable.UNARY_PLUS;
            }
            case 738: {
                this.jj_consume_token(738);
                return SqlStdOperatorTable.UNARY_MINUS;
            }
            case 358: {
                this.jj_consume_token(358);
                return SqlStdOperatorTable.NOT;
            }
            case 196: {
                this.jj_consume_token(196);
                return SqlStdOperatorTable.EXISTS;
            }
            case 653: {
                this.jj_consume_token(653);
                return SqlStdOperatorTable.UNIQUE;
            }
        }
        this.jj_la1[400] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SqlPostfixOperator PostfixRowOperator() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 272: {
                this.jj_consume_token(272);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: {
                        this.jj_consume_token(1);
                        this.jj_consume_token(513);
                        return SqlStdOperatorTable.IS_A_SET;
                    }
                    case 358: {
                        this.jj_consume_token(358);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 361: {
                                this.jj_consume_token(361);
                                return SqlStdOperatorTable.IS_NOT_NULL;
                            }
                            case 642: {
                                this.jj_consume_token(642);
                                return SqlStdOperatorTable.IS_NOT_TRUE;
                            }
                            case 202: {
                                this.jj_consume_token(202);
                                return SqlStdOperatorTable.IS_NOT_FALSE;
                            }
                            case 654: {
                                this.jj_consume_token(654);
                                return SqlStdOperatorTable.IS_NOT_UNKNOWN;
                            }
                            case 1: {
                                this.jj_consume_token(1);
                                this.jj_consume_token(513);
                                return SqlStdOperatorTable.IS_NOT_A_SET;
                            }
                            case 179: {
                                this.jj_consume_token(179);
                                return SqlStdOperatorTable.IS_NOT_EMPTY;
                            }
                        }
                        this.jj_la1[401] = this.jj_gen;
                        if (this.jj_2_98(2)) {
                            this.jj_consume_token(278);
                            this.jj_consume_token(671);
                            return SqlStdOperatorTable.IS_NOT_JSON_VALUE;
                        }
                        if (this.jj_2_99(2)) {
                            this.jj_consume_token(278);
                            this.jj_consume_token(367);
                            return SqlStdOperatorTable.IS_NOT_JSON_OBJECT;
                        }
                        if (this.jj_2_100(2)) {
                            this.jj_consume_token(278);
                            this.jj_consume_token(19);
                            return SqlStdOperatorTable.IS_NOT_JSON_ARRAY;
                        }
                        if (this.jj_2_101(2)) {
                            this.jj_consume_token(278);
                            this.jj_consume_token(488);
                            return SqlStdOperatorTable.IS_NOT_JSON_SCALAR;
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 278: {
                                this.jj_consume_token(278);
                                return SqlStdOperatorTable.IS_NOT_JSON_VALUE;
                            }
                        }
                        this.jj_la1[402] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    case 179: 
                    case 202: 
                    case 278: 
                    case 361: 
                    case 642: 
                    case 654: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 361: {
                                this.jj_consume_token(361);
                                return SqlStdOperatorTable.IS_NULL;
                            }
                            case 642: {
                                this.jj_consume_token(642);
                                return SqlStdOperatorTable.IS_TRUE;
                            }
                            case 202: {
                                this.jj_consume_token(202);
                                return SqlStdOperatorTable.IS_FALSE;
                            }
                            case 654: {
                                this.jj_consume_token(654);
                                return SqlStdOperatorTable.IS_UNKNOWN;
                            }
                            case 179: {
                                this.jj_consume_token(179);
                                return SqlStdOperatorTable.IS_EMPTY;
                            }
                        }
                        this.jj_la1[403] = this.jj_gen;
                        if (this.jj_2_102(2)) {
                            this.jj_consume_token(278);
                            this.jj_consume_token(671);
                            return SqlStdOperatorTable.IS_JSON_VALUE;
                        }
                        if (this.jj_2_103(2)) {
                            this.jj_consume_token(278);
                            this.jj_consume_token(367);
                            return SqlStdOperatorTable.IS_JSON_OBJECT;
                        }
                        if (this.jj_2_104(2)) {
                            this.jj_consume_token(278);
                            this.jj_consume_token(19);
                            return SqlStdOperatorTable.IS_JSON_ARRAY;
                        }
                        if (this.jj_2_105(2)) {
                            this.jj_consume_token(278);
                            this.jj_consume_token(488);
                            return SqlStdOperatorTable.IS_JSON_SCALAR;
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 278: {
                                this.jj_consume_token(278);
                                return SqlStdOperatorTable.IS_JSON_VALUE;
                            }
                        }
                        this.jj_la1[404] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_la1[405] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 212: {
                this.jj_consume_token(212);
                this.JsonRepresentation();
                return SqlStdOperatorTable.JSON_VALUE_EXPRESSION;
            }
        }
        this.jj_la1[406] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String NonReservedKeyWord() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: 
            case 5: 
            case 8: 
            case 17: 
            case 24: 
            case 31: 
            case 39: 
            case 53: 
            case 61: 
            case 69: 
            case 71: 
            case 80: 
            case 83: 
            case 88: 
            case 93: 
            case 98: 
            case 100: 
            case 128: 
            case 133: 
            case 138: 
            case 146: 
            case 150: 
            case 156: 
            case 160: 
            case 167: 
            case 168: 
            case 180: 
            case 191: 
            case 205: 
            case 212: 
            case 216: 
            case 226: 
            case 231: 
            case 239: 
            case 245: 
            case 248: 
            case 253: 
            case 260: 
            case 271: 
            case 274: 
            case 286: 
            case 289: 
            case 300: 
            case 310: 
            case 315: 
            case 325: 
            case 330: 
            case 334: 
            case 343: 
            case 346: 
            case 362: 
            case 367: 
            case 380: 
            case 385: 
            case 393: 
            case 397: 
            case 400: 
            case 404: 
            case 407: 
            case 418: 
            case 428: 
            case 434: 
            case 439: 
            case 458: 
            case 462: 
            case 467: 
            case 473: 
            case 478: 
            case 482: 
            case 490: 
            case 494: 
            case 500: 
            case 506: 
            case 509: 
            case 514: 
            case 523: 
            case 532: 
            case 535: 
            case 538: 
            case 541: 
            case 544: 
            case 547: 
            case 550: 
            case 553: 
            case 556: 
            case 559: 
            case 562: 
            case 565: 
            case 568: 
            case 571: 
            case 574: 
            case 577: 
            case 580: 
            case 589: 
            case 592: 
            case 608: 
            case 614: 
            case 618: 
            case 626: 
            case 629: 
            case 637: 
            case 645: 
            case 649: 
            case 655: 
            case 663: 
            case 666: 
            case 668: 
            case 683: 
            case 694: 
            case 698: {
                this.NonReservedKeyWord0of3();
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 20: 
            case 26: 
            case 32: 
            case 47: 
            case 57: 
            case 62: 
            case 67: 
            case 74: 
            case 81: 
            case 86: 
            case 90: 
            case 95: 
            case 99: 
            case 102: 
            case 130: 
            case 135: 
            case 141: 
            case 147: 
            case 151: 
            case 157: 
            case 162: 
            case 170: 
            case 174: 
            case 185: 
            case 192: 
            case 206: 
            case 214: 
            case 224: 
            case 227: 
            case 233: 
            case 241: 
            case 246: 
            case 249: 
            case 254: 
            case 263: 
            case 273: 
            case 276: 
            case 287: 
            case 290: 
            case 301: 
            case 312: 
            case 320: 
            case 326: 
            case 329: 
            case 340: 
            case 344: 
            case 351: 
            case 364: 
            case 370: 
            case 383: 
            case 388: 
            case 395: 
            case 398: 
            case 401: 
            case 405: 
            case 416: 
            case 419: 
            case 431: 
            case 435: 
            case 455: 
            case 460: 
            case 465: 
            case 468: 
            case 474: 
            case 479: 
            case 488: 
            case 491: 
            case 495: 
            case 501: 
            case 507: 
            case 510: 
            case 518: 
            case 524: 
            case 533: 
            case 536: 
            case 539: 
            case 542: 
            case 545: 
            case 548: 
            case 551: 
            case 554: 
            case 557: 
            case 560: 
            case 563: 
            case 566: 
            case 569: 
            case 572: 
            case 575: 
            case 578: 
            case 583: 
            case 590: 
            case 595: 
            case 611: 
            case 616: 
            case 619: 
            case 627: 
            case 630: 
            case 638: 
            case 646: 
            case 650: 
            case 656: 
            case 664: 
            case 669: 
            case 679: 
            case 684: 
            case 695: 
            case 699: {
                this.NonReservedKeyWord1of3();
                break;
            }
            case 4: 
            case 7: 
            case 14: 
            case 21: 
            case 27: 
            case 35: 
            case 49: 
            case 58: 
            case 68: 
            case 70: 
            case 78: 
            case 82: 
            case 87: 
            case 92: 
            case 96: 
            case 101: 
            case 104: 
            case 131: 
            case 136: 
            case 145: 
            case 149: 
            case 154: 
            case 159: 
            case 165: 
            case 171: 
            case 175: 
            case 187: 
            case 193: 
            case 210: 
            case 215: 
            case 225: 
            case 230: 
            case 235: 
            case 243: 
            case 247: 
            case 252: 
            case 257: 
            case 264: 
            case 275: 
            case 278: 
            case 288: 
            case 294: 
            case 302: 
            case 313: 
            case 324: 
            case 328: 
            case 333: 
            case 341: 
            case 345: 
            case 357: 
            case 365: 
            case 379: 
            case 384: 
            case 392: 
            case 396: 
            case 399: 
            case 403: 
            case 406: 
            case 417: 
            case 425: 
            case 432: 
            case 436: 
            case 457: 
            case 461: 
            case 466: 
            case 469: 
            case 477: 
            case 480: 
            case 489: 
            case 493: 
            case 499: 
            case 504: 
            case 508: 
            case 511: 
            case 519: 
            case 526: 
            case 534: 
            case 537: 
            case 540: 
            case 543: 
            case 546: 
            case 549: 
            case 552: 
            case 555: 
            case 558: 
            case 561: 
            case 564: 
            case 567: 
            case 570: 
            case 573: 
            case 576: 
            case 579: 
            case 584: 
            case 591: 
            case 606: 
            case 613: 
            case 617: 
            case 624: 
            case 628: 
            case 631: 
            case 639: 
            case 648: 
            case 651: 
            case 661: 
            case 665: 
            case 670: 
            case 681: 
            case 693: 
            case 696: {
                this.NonReservedKeyWord2of3();
                break;
            }
            default: {
                this.jj_la1[407] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return this.unquotedIdentifier();
    }

    public final void NonReservedKeyWord0of3() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: {
                this.jj_consume_token(1);
                break;
            }
            case 5: {
                this.jj_consume_token(5);
                break;
            }
            case 8: {
                this.jj_consume_token(8);
                break;
            }
            case 17: {
                this.jj_consume_token(17);
                break;
            }
            case 24: {
                this.jj_consume_token(24);
                break;
            }
            case 31: {
                this.jj_consume_token(31);
                break;
            }
            case 39: {
                this.jj_consume_token(39);
                break;
            }
            case 53: {
                this.jj_consume_token(53);
                break;
            }
            case 61: {
                this.jj_consume_token(61);
                break;
            }
            case 71: {
                this.jj_consume_token(71);
                break;
            }
            case 69: {
                this.jj_consume_token(69);
                break;
            }
            case 80: {
                this.jj_consume_token(80);
                break;
            }
            case 83: {
                this.jj_consume_token(83);
                break;
            }
            case 88: {
                this.jj_consume_token(88);
                break;
            }
            case 93: {
                this.jj_consume_token(93);
                break;
            }
            case 98: {
                this.jj_consume_token(98);
                break;
            }
            case 100: {
                this.jj_consume_token(100);
                break;
            }
            case 128: {
                this.jj_consume_token(128);
                break;
            }
            case 133: {
                this.jj_consume_token(133);
                break;
            }
            case 138: {
                this.jj_consume_token(138);
                break;
            }
            case 146: {
                this.jj_consume_token(146);
                break;
            }
            case 150: {
                this.jj_consume_token(150);
                break;
            }
            case 156: {
                this.jj_consume_token(156);
                break;
            }
            case 160: {
                this.jj_consume_token(160);
                break;
            }
            case 167: {
                this.jj_consume_token(167);
                break;
            }
            case 168: {
                this.jj_consume_token(168);
                break;
            }
            case 180: {
                this.jj_consume_token(180);
                break;
            }
            case 191: {
                this.jj_consume_token(191);
                break;
            }
            case 205: {
                this.jj_consume_token(205);
                break;
            }
            case 212: {
                this.jj_consume_token(212);
                break;
            }
            case 216: {
                this.jj_consume_token(216);
                break;
            }
            case 226: {
                this.jj_consume_token(226);
                break;
            }
            case 231: {
                this.jj_consume_token(231);
                break;
            }
            case 239: {
                this.jj_consume_token(239);
                break;
            }
            case 245: {
                this.jj_consume_token(245);
                break;
            }
            case 248: {
                this.jj_consume_token(248);
                break;
            }
            case 253: {
                this.jj_consume_token(253);
                break;
            }
            case 260: {
                this.jj_consume_token(260);
                break;
            }
            case 271: {
                this.jj_consume_token(271);
                break;
            }
            case 274: {
                this.jj_consume_token(274);
                break;
            }
            case 286: {
                this.jj_consume_token(286);
                break;
            }
            case 289: {
                this.jj_consume_token(289);
                break;
            }
            case 300: {
                this.jj_consume_token(300);
                break;
            }
            case 310: {
                this.jj_consume_token(310);
                break;
            }
            case 315: {
                this.jj_consume_token(315);
                break;
            }
            case 325: {
                this.jj_consume_token(325);
                break;
            }
            case 330: {
                this.jj_consume_token(330);
                break;
            }
            case 334: {
                this.jj_consume_token(334);
                break;
            }
            case 343: {
                this.jj_consume_token(343);
                break;
            }
            case 346: {
                this.jj_consume_token(346);
                break;
            }
            case 362: {
                this.jj_consume_token(362);
                break;
            }
            case 367: {
                this.jj_consume_token(367);
                break;
            }
            case 380: {
                this.jj_consume_token(380);
                break;
            }
            case 385: {
                this.jj_consume_token(385);
                break;
            }
            case 393: {
                this.jj_consume_token(393);
                break;
            }
            case 397: {
                this.jj_consume_token(397);
                break;
            }
            case 400: {
                this.jj_consume_token(400);
                break;
            }
            case 404: {
                this.jj_consume_token(404);
                break;
            }
            case 407: {
                this.jj_consume_token(407);
                break;
            }
            case 418: {
                this.jj_consume_token(418);
                break;
            }
            case 428: {
                this.jj_consume_token(428);
                break;
            }
            case 434: {
                this.jj_consume_token(434);
                break;
            }
            case 439: {
                this.jj_consume_token(439);
                break;
            }
            case 458: {
                this.jj_consume_token(458);
                break;
            }
            case 462: {
                this.jj_consume_token(462);
                break;
            }
            case 467: {
                this.jj_consume_token(467);
                break;
            }
            case 473: {
                this.jj_consume_token(473);
                break;
            }
            case 478: {
                this.jj_consume_token(478);
                break;
            }
            case 482: {
                this.jj_consume_token(482);
                break;
            }
            case 490: {
                this.jj_consume_token(490);
                break;
            }
            case 494: {
                this.jj_consume_token(494);
                break;
            }
            case 500: {
                this.jj_consume_token(500);
                break;
            }
            case 506: {
                this.jj_consume_token(506);
                break;
            }
            case 509: {
                this.jj_consume_token(509);
                break;
            }
            case 514: {
                this.jj_consume_token(514);
                break;
            }
            case 523: {
                this.jj_consume_token(523);
                break;
            }
            case 532: {
                this.jj_consume_token(532);
                break;
            }
            case 535: {
                this.jj_consume_token(535);
                break;
            }
            case 538: {
                this.jj_consume_token(538);
                break;
            }
            case 541: {
                this.jj_consume_token(541);
                break;
            }
            case 544: {
                this.jj_consume_token(544);
                break;
            }
            case 547: {
                this.jj_consume_token(547);
                break;
            }
            case 550: {
                this.jj_consume_token(550);
                break;
            }
            case 553: {
                this.jj_consume_token(553);
                break;
            }
            case 556: {
                this.jj_consume_token(556);
                break;
            }
            case 559: {
                this.jj_consume_token(559);
                break;
            }
            case 562: {
                this.jj_consume_token(562);
                break;
            }
            case 565: {
                this.jj_consume_token(565);
                break;
            }
            case 568: {
                this.jj_consume_token(568);
                break;
            }
            case 571: {
                this.jj_consume_token(571);
                break;
            }
            case 574: {
                this.jj_consume_token(574);
                break;
            }
            case 577: {
                this.jj_consume_token(577);
                break;
            }
            case 580: {
                this.jj_consume_token(580);
                break;
            }
            case 589: {
                this.jj_consume_token(589);
                break;
            }
            case 592: {
                this.jj_consume_token(592);
                break;
            }
            case 608: {
                this.jj_consume_token(608);
                break;
            }
            case 614: {
                this.jj_consume_token(614);
                break;
            }
            case 618: {
                this.jj_consume_token(618);
                break;
            }
            case 626: {
                this.jj_consume_token(626);
                break;
            }
            case 629: {
                this.jj_consume_token(629);
                break;
            }
            case 637: {
                this.jj_consume_token(637);
                break;
            }
            case 645: {
                this.jj_consume_token(645);
                break;
            }
            case 649: {
                this.jj_consume_token(649);
                break;
            }
            case 655: {
                this.jj_consume_token(655);
                break;
            }
            case 663: {
                this.jj_consume_token(663);
                break;
            }
            case 666: {
                this.jj_consume_token(666);
                break;
            }
            case 668: {
                this.jj_consume_token(668);
                break;
            }
            case 683: {
                this.jj_consume_token(683);
                break;
            }
            case 694: {
                this.jj_consume_token(694);
                break;
            }
            case 698: {
                this.jj_consume_token(698);
                break;
            }
            default: {
                this.jj_la1[408] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void NonReservedKeyWord1of3() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 3: {
                this.jj_consume_token(3);
                break;
            }
            case 6: {
                this.jj_consume_token(6);
                break;
            }
            case 9: {
                this.jj_consume_token(9);
                break;
            }
            case 20: {
                this.jj_consume_token(20);
                break;
            }
            case 26: {
                this.jj_consume_token(26);
                break;
            }
            case 32: {
                this.jj_consume_token(32);
                break;
            }
            case 47: {
                this.jj_consume_token(47);
                break;
            }
            case 57: {
                this.jj_consume_token(57);
                break;
            }
            case 62: {
                this.jj_consume_token(62);
                break;
            }
            case 67: {
                this.jj_consume_token(67);
                break;
            }
            case 74: {
                this.jj_consume_token(74);
                break;
            }
            case 81: {
                this.jj_consume_token(81);
                break;
            }
            case 86: {
                this.jj_consume_token(86);
                break;
            }
            case 90: {
                this.jj_consume_token(90);
                break;
            }
            case 95: {
                this.jj_consume_token(95);
                break;
            }
            case 99: {
                this.jj_consume_token(99);
                break;
            }
            case 102: {
                this.jj_consume_token(102);
                break;
            }
            case 130: {
                this.jj_consume_token(130);
                break;
            }
            case 135: {
                this.jj_consume_token(135);
                break;
            }
            case 141: {
                this.jj_consume_token(141);
                break;
            }
            case 147: {
                this.jj_consume_token(147);
                break;
            }
            case 151: {
                this.jj_consume_token(151);
                break;
            }
            case 157: {
                this.jj_consume_token(157);
                break;
            }
            case 162: {
                this.jj_consume_token(162);
                break;
            }
            case 170: {
                this.jj_consume_token(170);
                break;
            }
            case 174: {
                this.jj_consume_token(174);
                break;
            }
            case 185: {
                this.jj_consume_token(185);
                break;
            }
            case 192: {
                this.jj_consume_token(192);
                break;
            }
            case 206: {
                this.jj_consume_token(206);
                break;
            }
            case 214: {
                this.jj_consume_token(214);
                break;
            }
            case 224: {
                this.jj_consume_token(224);
                break;
            }
            case 227: {
                this.jj_consume_token(227);
                break;
            }
            case 233: {
                this.jj_consume_token(233);
                break;
            }
            case 241: {
                this.jj_consume_token(241);
                break;
            }
            case 246: {
                this.jj_consume_token(246);
                break;
            }
            case 249: {
                this.jj_consume_token(249);
                break;
            }
            case 254: {
                this.jj_consume_token(254);
                break;
            }
            case 263: {
                this.jj_consume_token(263);
                break;
            }
            case 273: {
                this.jj_consume_token(273);
                break;
            }
            case 276: {
                this.jj_consume_token(276);
                break;
            }
            case 287: {
                this.jj_consume_token(287);
                break;
            }
            case 290: {
                this.jj_consume_token(290);
                break;
            }
            case 301: {
                this.jj_consume_token(301);
                break;
            }
            case 312: {
                this.jj_consume_token(312);
                break;
            }
            case 320: {
                this.jj_consume_token(320);
                break;
            }
            case 326: {
                this.jj_consume_token(326);
                break;
            }
            case 329: {
                this.jj_consume_token(329);
                break;
            }
            case 340: {
                this.jj_consume_token(340);
                break;
            }
            case 344: {
                this.jj_consume_token(344);
                break;
            }
            case 351: {
                this.jj_consume_token(351);
                break;
            }
            case 364: {
                this.jj_consume_token(364);
                break;
            }
            case 370: {
                this.jj_consume_token(370);
                break;
            }
            case 383: {
                this.jj_consume_token(383);
                break;
            }
            case 388: {
                this.jj_consume_token(388);
                break;
            }
            case 395: {
                this.jj_consume_token(395);
                break;
            }
            case 398: {
                this.jj_consume_token(398);
                break;
            }
            case 401: {
                this.jj_consume_token(401);
                break;
            }
            case 405: {
                this.jj_consume_token(405);
                break;
            }
            case 416: {
                this.jj_consume_token(416);
                break;
            }
            case 419: {
                this.jj_consume_token(419);
                break;
            }
            case 431: {
                this.jj_consume_token(431);
                break;
            }
            case 435: {
                this.jj_consume_token(435);
                break;
            }
            case 455: {
                this.jj_consume_token(455);
                break;
            }
            case 460: {
                this.jj_consume_token(460);
                break;
            }
            case 465: {
                this.jj_consume_token(465);
                break;
            }
            case 468: {
                this.jj_consume_token(468);
                break;
            }
            case 474: {
                this.jj_consume_token(474);
                break;
            }
            case 479: {
                this.jj_consume_token(479);
                break;
            }
            case 488: {
                this.jj_consume_token(488);
                break;
            }
            case 491: {
                this.jj_consume_token(491);
                break;
            }
            case 495: {
                this.jj_consume_token(495);
                break;
            }
            case 501: {
                this.jj_consume_token(501);
                break;
            }
            case 507: {
                this.jj_consume_token(507);
                break;
            }
            case 510: {
                this.jj_consume_token(510);
                break;
            }
            case 518: {
                this.jj_consume_token(518);
                break;
            }
            case 524: {
                this.jj_consume_token(524);
                break;
            }
            case 533: {
                this.jj_consume_token(533);
                break;
            }
            case 536: {
                this.jj_consume_token(536);
                break;
            }
            case 539: {
                this.jj_consume_token(539);
                break;
            }
            case 542: {
                this.jj_consume_token(542);
                break;
            }
            case 545: {
                this.jj_consume_token(545);
                break;
            }
            case 548: {
                this.jj_consume_token(548);
                break;
            }
            case 551: {
                this.jj_consume_token(551);
                break;
            }
            case 554: {
                this.jj_consume_token(554);
                break;
            }
            case 557: {
                this.jj_consume_token(557);
                break;
            }
            case 560: {
                this.jj_consume_token(560);
                break;
            }
            case 563: {
                this.jj_consume_token(563);
                break;
            }
            case 566: {
                this.jj_consume_token(566);
                break;
            }
            case 569: {
                this.jj_consume_token(569);
                break;
            }
            case 572: {
                this.jj_consume_token(572);
                break;
            }
            case 575: {
                this.jj_consume_token(575);
                break;
            }
            case 578: {
                this.jj_consume_token(578);
                break;
            }
            case 583: {
                this.jj_consume_token(583);
                break;
            }
            case 590: {
                this.jj_consume_token(590);
                break;
            }
            case 595: {
                this.jj_consume_token(595);
                break;
            }
            case 611: {
                this.jj_consume_token(611);
                break;
            }
            case 616: {
                this.jj_consume_token(616);
                break;
            }
            case 619: {
                this.jj_consume_token(619);
                break;
            }
            case 627: {
                this.jj_consume_token(627);
                break;
            }
            case 630: {
                this.jj_consume_token(630);
                break;
            }
            case 638: {
                this.jj_consume_token(638);
                break;
            }
            case 646: {
                this.jj_consume_token(646);
                break;
            }
            case 650: {
                this.jj_consume_token(650);
                break;
            }
            case 656: {
                this.jj_consume_token(656);
                break;
            }
            case 664: {
                this.jj_consume_token(664);
                break;
            }
            case 669: {
                this.jj_consume_token(669);
                break;
            }
            case 679: {
                this.jj_consume_token(679);
                break;
            }
            case 684: {
                this.jj_consume_token(684);
                break;
            }
            case 695: {
                this.jj_consume_token(695);
                break;
            }
            case 699: {
                this.jj_consume_token(699);
                break;
            }
            default: {
                this.jj_la1[409] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void NonReservedKeyWord2of3() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 4: {
                this.jj_consume_token(4);
                break;
            }
            case 7: {
                this.jj_consume_token(7);
                break;
            }
            case 14: {
                this.jj_consume_token(14);
                break;
            }
            case 21: {
                this.jj_consume_token(21);
                break;
            }
            case 27: {
                this.jj_consume_token(27);
                break;
            }
            case 35: {
                this.jj_consume_token(35);
                break;
            }
            case 49: {
                this.jj_consume_token(49);
                break;
            }
            case 58: {
                this.jj_consume_token(58);
                break;
            }
            case 70: {
                this.jj_consume_token(70);
                break;
            }
            case 68: {
                this.jj_consume_token(68);
                break;
            }
            case 78: {
                this.jj_consume_token(78);
                break;
            }
            case 82: {
                this.jj_consume_token(82);
                break;
            }
            case 87: {
                this.jj_consume_token(87);
                break;
            }
            case 92: {
                this.jj_consume_token(92);
                break;
            }
            case 96: {
                this.jj_consume_token(96);
                break;
            }
            case 101: {
                this.jj_consume_token(101);
                break;
            }
            case 104: {
                this.jj_consume_token(104);
                break;
            }
            case 131: {
                this.jj_consume_token(131);
                break;
            }
            case 136: {
                this.jj_consume_token(136);
                break;
            }
            case 145: {
                this.jj_consume_token(145);
                break;
            }
            case 149: {
                this.jj_consume_token(149);
                break;
            }
            case 154: {
                this.jj_consume_token(154);
                break;
            }
            case 159: {
                this.jj_consume_token(159);
                break;
            }
            case 165: {
                this.jj_consume_token(165);
                break;
            }
            case 171: {
                this.jj_consume_token(171);
                break;
            }
            case 175: {
                this.jj_consume_token(175);
                break;
            }
            case 187: {
                this.jj_consume_token(187);
                break;
            }
            case 193: {
                this.jj_consume_token(193);
                break;
            }
            case 210: {
                this.jj_consume_token(210);
                break;
            }
            case 215: {
                this.jj_consume_token(215);
                break;
            }
            case 225: {
                this.jj_consume_token(225);
                break;
            }
            case 230: {
                this.jj_consume_token(230);
                break;
            }
            case 235: {
                this.jj_consume_token(235);
                break;
            }
            case 243: {
                this.jj_consume_token(243);
                break;
            }
            case 247: {
                this.jj_consume_token(247);
                break;
            }
            case 252: {
                this.jj_consume_token(252);
                break;
            }
            case 257: {
                this.jj_consume_token(257);
                break;
            }
            case 264: {
                this.jj_consume_token(264);
                break;
            }
            case 275: {
                this.jj_consume_token(275);
                break;
            }
            case 278: {
                this.jj_consume_token(278);
                break;
            }
            case 288: {
                this.jj_consume_token(288);
                break;
            }
            case 294: {
                this.jj_consume_token(294);
                break;
            }
            case 302: {
                this.jj_consume_token(302);
                break;
            }
            case 313: {
                this.jj_consume_token(313);
                break;
            }
            case 324: {
                this.jj_consume_token(324);
                break;
            }
            case 328: {
                this.jj_consume_token(328);
                break;
            }
            case 333: {
                this.jj_consume_token(333);
                break;
            }
            case 341: {
                this.jj_consume_token(341);
                break;
            }
            case 345: {
                this.jj_consume_token(345);
                break;
            }
            case 357: {
                this.jj_consume_token(357);
                break;
            }
            case 365: {
                this.jj_consume_token(365);
                break;
            }
            case 379: {
                this.jj_consume_token(379);
                break;
            }
            case 384: {
                this.jj_consume_token(384);
                break;
            }
            case 392: {
                this.jj_consume_token(392);
                break;
            }
            case 396: {
                this.jj_consume_token(396);
                break;
            }
            case 399: {
                this.jj_consume_token(399);
                break;
            }
            case 403: {
                this.jj_consume_token(403);
                break;
            }
            case 406: {
                this.jj_consume_token(406);
                break;
            }
            case 417: {
                this.jj_consume_token(417);
                break;
            }
            case 425: {
                this.jj_consume_token(425);
                break;
            }
            case 432: {
                this.jj_consume_token(432);
                break;
            }
            case 436: {
                this.jj_consume_token(436);
                break;
            }
            case 457: {
                this.jj_consume_token(457);
                break;
            }
            case 461: {
                this.jj_consume_token(461);
                break;
            }
            case 466: {
                this.jj_consume_token(466);
                break;
            }
            case 469: {
                this.jj_consume_token(469);
                break;
            }
            case 477: {
                this.jj_consume_token(477);
                break;
            }
            case 480: {
                this.jj_consume_token(480);
                break;
            }
            case 489: {
                this.jj_consume_token(489);
                break;
            }
            case 493: {
                this.jj_consume_token(493);
                break;
            }
            case 499: {
                this.jj_consume_token(499);
                break;
            }
            case 504: {
                this.jj_consume_token(504);
                break;
            }
            case 508: {
                this.jj_consume_token(508);
                break;
            }
            case 511: {
                this.jj_consume_token(511);
                break;
            }
            case 519: {
                this.jj_consume_token(519);
                break;
            }
            case 526: {
                this.jj_consume_token(526);
                break;
            }
            case 534: {
                this.jj_consume_token(534);
                break;
            }
            case 537: {
                this.jj_consume_token(537);
                break;
            }
            case 540: {
                this.jj_consume_token(540);
                break;
            }
            case 543: {
                this.jj_consume_token(543);
                break;
            }
            case 546: {
                this.jj_consume_token(546);
                break;
            }
            case 549: {
                this.jj_consume_token(549);
                break;
            }
            case 552: {
                this.jj_consume_token(552);
                break;
            }
            case 555: {
                this.jj_consume_token(555);
                break;
            }
            case 558: {
                this.jj_consume_token(558);
                break;
            }
            case 561: {
                this.jj_consume_token(561);
                break;
            }
            case 564: {
                this.jj_consume_token(564);
                break;
            }
            case 567: {
                this.jj_consume_token(567);
                break;
            }
            case 570: {
                this.jj_consume_token(570);
                break;
            }
            case 573: {
                this.jj_consume_token(573);
                break;
            }
            case 576: {
                this.jj_consume_token(576);
                break;
            }
            case 579: {
                this.jj_consume_token(579);
                break;
            }
            case 584: {
                this.jj_consume_token(584);
                break;
            }
            case 591: {
                this.jj_consume_token(591);
                break;
            }
            case 606: {
                this.jj_consume_token(606);
                break;
            }
            case 613: {
                this.jj_consume_token(613);
                break;
            }
            case 617: {
                this.jj_consume_token(617);
                break;
            }
            case 624: {
                this.jj_consume_token(624);
                break;
            }
            case 628: {
                this.jj_consume_token(628);
                break;
            }
            case 631: {
                this.jj_consume_token(631);
                break;
            }
            case 639: {
                this.jj_consume_token(639);
                break;
            }
            case 648: {
                this.jj_consume_token(648);
                break;
            }
            case 651: {
                this.jj_consume_token(651);
                break;
            }
            case 661: {
                this.jj_consume_token(661);
                break;
            }
            case 665: {
                this.jj_consume_token(665);
                break;
            }
            case 670: {
                this.jj_consume_token(670);
                break;
            }
            case 681: {
                this.jj_consume_token(681);
                break;
            }
            case 693: {
                this.jj_consume_token(693);
                break;
            }
            case 696: {
                this.jj_consume_token(696);
                break;
            }
            default: {
                this.jj_la1[410] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void UnusedExtension() throws ParseException {
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(8, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_10(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_10();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(9, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_11(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_11();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(10, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_12(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_12();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(11, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_13(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_13();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(12, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_14(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_14();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(13, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_15(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_15();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(14, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_16(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_16();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(15, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_17(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_17();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(16, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_18(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_18();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(17, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_19(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_19();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(18, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_20(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_20();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(19, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_21(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_21();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(20, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_22(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_22();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(21, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_23(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_23();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(22, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_24(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_24();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(23, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_25(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_25();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(24, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_26(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_26();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(25, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_27(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_27();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(26, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_28(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_28();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(27, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_29(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_29();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(28, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_30(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_30();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(29, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_31(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_31();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(30, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_32(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_32();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(31, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_33(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_33();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(32, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_34(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_34();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(33, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_35(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_35();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(34, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_36(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_36();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(35, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_37(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_37();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(36, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_38(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_38();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(37, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_39(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_39();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(38, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_40(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_40();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(39, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_41(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_41();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(40, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_42(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_42();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(41, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_43(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_43();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(42, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_44(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_44();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(43, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_45(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_45();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(44, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_46(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_46();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(45, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_47(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_47();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(46, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_48(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_48();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(47, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_49(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_49();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(48, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_50(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_50();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(49, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_51(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_51();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(50, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_52(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_52();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(51, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_53(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_53();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(52, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_54(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_54();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(53, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_55(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_55();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(54, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_56(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_56();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(55, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_57(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_57();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(56, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_58(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_58();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(57, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_59(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_59();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(58, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_60(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_60();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(59, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_61(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_61();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(60, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_62(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_62();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(61, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_63(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_63();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(62, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_64(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_64();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(63, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_65(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_65();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(64, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_66(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_66();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(65, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_67(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_67();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(66, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_68(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_68();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(67, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_69(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_69();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(68, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_70(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_70();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(69, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_71(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_71();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(70, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_72(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_72();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(71, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_73(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_73();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(72, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_74(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_74();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(73, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_75(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_75();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(74, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_76(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_76();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(75, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_77(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_77();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(76, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_78(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_78();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(77, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_79(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_79();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(78, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_80(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_80();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(79, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_81(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_81();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(80, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_82(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_82();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(81, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_83(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_83();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(82, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_84(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_84();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(83, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_85(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_85();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(84, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_86(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_86();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(85, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_87(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_87();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(86, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_88(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_88();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(87, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_89(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_89();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(88, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_90(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_90();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(89, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_91(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_91();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(90, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_92(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_92();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(91, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_93(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_93();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(92, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_94(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_94();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(93, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_95(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_95();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(94, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_96(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_96();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(95, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_97(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_97();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(96, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_98(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_98();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(97, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_99(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_99();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(98, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_100(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_100();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(99, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_101(int xla) {
        th