/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import io.micrometer.context.ContextSnapshot;
import reactor.core.CoreSubscriber;
import reactor.core.Scannable;
import reactor.core.observability.SignalListener;
import reactor.core.observability.SignalListenerFactory;
import reactor.core.publisher.ContextPropagation;
import reactor.core.publisher.FluxTapRestoringThreadLocals;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoOperator;
import reactor.core.publisher.Operators;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;

final class MonoTapRestoringThreadLocals<T, STATE>
extends MonoOperator<T, T> {
    final SignalListenerFactory<T, STATE> tapFactory;
    final STATE commonTapState;

    MonoTapRestoringThreadLocals(Mono<? extends T> source, SignalListenerFactory<T, STATE> tapFactory) {
        super(source);
        this.tapFactory = tapFactory;
        this.commonTapState = tapFactory.initializePublisherState(source);
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        Context alteredContext;
        SignalListener<T> signalListener;
        try {
            signalListener = this.tapFactory.createListener(this.source, actual.currentContext().readOnly(), this.commonTapState);
        }
        catch (Throwable generatorError) {
            Operators.error(actual, generatorError);
            return;
        }
        try {
            signalListener.doFirst();
        }
        catch (Throwable listenerError) {
            signalListener.handleListenerError(listenerError);
            Operators.error(actual, listenerError);
            return;
        }
        try {
            alteredContext = signalListener.addToContext(actual.currentContext());
        }
        catch (Throwable e) {
            signalListener.handleListenerError(new IllegalStateException("Unable to augment tap Context at construction via addToContext", e));
            alteredContext = actual.currentContext();
        }
        try (ContextSnapshot.Scope ignored = ContextPropagation.setThreadLocals(alteredContext);){
            this.source.subscribe(new FluxTapRestoringThreadLocals.TapSubscriber<T>(actual, signalListener, alteredContext));
        }
    }

    @Override
    @Nullable
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.PREFETCH) {
            return -1;
        }
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        return super.scanUnsafe(key);
    }
}

