/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.collection.iteration;

import com.vladsch.flexmark.util.collection.iteration.ReversibleIterator;
import java.util.BitSet;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class BitSetIterator
implements ReversibleIterator<Integer> {
    @NotNull
    private final BitSet bitSet;
    private final boolean reversed;
    private int next;
    private int last;

    public BitSetIterator(@NotNull BitSet bitSet) {
        this(bitSet, false);
    }

    public BitSetIterator(@NotNull BitSet bitSet, boolean reversed) {
        this.bitSet = bitSet;
        this.reversed = reversed;
        this.next = reversed ? bitSet.previousSetBit(bitSet.length()) : bitSet.nextSetBit(0);
        this.last = -1;
    }

    @Override
    public boolean isReversed() {
        return this.reversed;
    }

    @Override
    public boolean hasNext() {
        return this.next != -1;
    }

    @Override
    public Integer next() {
        if (this.next == -1) {
            throw new NoSuchElementException();
        }
        this.last = this.next;
        this.next = this.reversed ? (this.next == 0 ? -1 : this.bitSet.previousSetBit(this.next - 1)) : this.bitSet.nextSetBit(this.next + 1);
        return this.last;
    }

    @Override
    public void remove() {
        if (this.last == -1) {
            throw new NoSuchElementException();
        }
        this.bitSet.clear(this.last);
    }

    @Override
    public void forEachRemaining(@NotNull Consumer<? super Integer> consumer) {
        while (this.hasNext()) {
            consumer.accept(this.next());
        }
    }
}

