/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.storage;

import java.util.stream.Collectors;
import org.apache.ignite3.internal.catalog.Catalog;
import org.apache.ignite3.internal.catalog.commands.CatalogUtils;
import org.apache.ignite3.internal.catalog.descriptors.CatalogZoneDescriptor;
import org.apache.ignite3.internal.catalog.events.AlterZoneEventParameters;
import org.apache.ignite3.internal.catalog.events.CatalogEvent;
import org.apache.ignite3.internal.catalog.events.CatalogEventParameters;
import org.apache.ignite3.internal.catalog.storage.Fireable;
import org.apache.ignite3.internal.catalog.storage.UpdateEntry;
import org.apache.ignite3.internal.catalog.storage.serialization.MarshallableEntryType;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.tostring.S;

public class AlterZoneEntry
implements UpdateEntry,
Fireable {
    private final CatalogZoneDescriptor descriptor;

    public AlterZoneEntry(CatalogZoneDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public CatalogZoneDescriptor descriptor() {
        return this.descriptor;
    }

    @Override
    public int typeId() {
        return MarshallableEntryType.ALTER_ZONE.id();
    }

    @Override
    public CatalogEvent eventType() {
        return CatalogEvent.ZONE_ALTER;
    }

    @Override
    public CatalogEventParameters createEventParameters(long causalityToken, int catalogVersion) {
        return new AlterZoneEventParameters(causalityToken, catalogVersion, this.descriptor);
    }

    @Override
    public Catalog applyUpdate(Catalog catalog, HybridTimestamp timestamp) {
        this.descriptor.updateTimestamp(timestamp);
        return new Catalog(catalog.version(), catalog.time(), catalog.objectIdGenState(), catalog.zones().stream().map(z -> z.id() == this.descriptor.id() ? this.descriptor : z).collect(Collectors.toList()), catalog.schemas(), CatalogUtils.defaultZoneIdOpt(catalog));
    }

    public String toString() {
        return S.toString(this);
    }
}

