/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.core.exception.handler;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.micronaut.http.HttpStatus;
import java.io.IOException;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.List;
import java.util.stream.Collectors;
import javax.net.ssl.SSLException;
import org.apache.ignite3.internal.cli.core.exception.ExceptionHandler;
import org.apache.ignite3.internal.cli.core.exception.ExceptionWriter;
import org.apache.ignite3.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite3.internal.cli.core.style.component.ErrorUiComponent;
import org.apache.ignite3.internal.cli.core.style.element.UiElement;
import org.apache.ignite3.internal.cli.core.style.element.UiElements;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.rest.client.invoker.ApiException;
import org.apache.ignite3.rest.client.model.InvalidParam;
import org.apache.ignite3.rest.client.model.Problem;

public class IgniteCliApiExceptionHandler
implements ExceptionHandler<IgniteCliApiException> {
    private static final IgniteLogger LOG = Loggers.forClass(IgniteCliApiExceptionHandler.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();

    @Override
    public int handle(ExceptionWriter err, IgniteCliApiException e) {
        ErrorUiComponent.ErrorComponentBuilder errorComponentBuilder = ErrorUiComponent.builder();
        if (e.getCause() instanceof ApiException) {
            ApiException cause = (ApiException)e.getCause();
            Throwable apiCause = cause.getCause();
            if (apiCause instanceof UnknownHostException) {
                errorComponentBuilder.header("Unknown host: %s", UiElements.url(e.getUrl())).verbose(apiCause.getMessage(), new UiElement[0]);
            } else if (apiCause instanceof ConnectException) {
                errorComponentBuilder.header("Node unavailable", new UiElement[0]).details("Could not connect to node with URL %s", UiElements.url(e.getUrl())).verbose(apiCause.getMessage(), new UiElement[0]);
            } else if (apiCause instanceof SSLException) {
                errorComponentBuilder.header("SSL error", new UiElement[0]).details("Could not connect to node with URL %s. Check SSL configuration", UiElements.url(e.getUrl())).verbose(apiCause.getMessage(), new UiElement[0]);
            } else if (apiCause != null) {
                errorComponentBuilder.header(apiCause.getMessage(), new UiElement[0]);
            } else if (cause.getCode() == HttpStatus.UNAUTHORIZED.getCode()) {
                errorComponentBuilder.header("Authentication error", new UiElement[0]).details("Could not connect to node with URL %s. Check authentication configuration or provided username/password", UiElements.url(e.getUrl())).verbose(e.getMessage(), new UiElement[0]);
            } else if (cause.getResponseBody() != null) {
                Problem problem = IgniteCliApiExceptionHandler.extractProblem(cause.getResponseBody());
                IgniteCliApiExceptionHandler.renderProblem(errorComponentBuilder, problem);
            } else {
                errorComponentBuilder.header(IgniteCliApiExceptionHandler.header(e), new UiElement[0]);
            }
        } else if (e.getCause() instanceof IOException || e.getCause() instanceof IllegalArgumentException) {
            errorComponentBuilder.header("Unexpected error", new UiElement[0]).details(e.getCause().getMessage(), new UiElement[0]).verbose(e.getMessage(), new UiElement[0]);
        } else {
            errorComponentBuilder.header(IgniteCliApiExceptionHandler.header(e), new UiElement[0]);
        }
        ErrorUiComponent errorComponent = errorComponentBuilder.build();
        LOG.error(errorComponent.header(), (Throwable)e);
        err.write(errorComponent.render());
        return 1;
    }

    private static String header(IgniteCliApiException e) {
        return e.getCause() == e ? e.getMessage() : e.getCause().getMessage();
    }

    private static Problem extractProblem(String responseBody) {
        try {
            return (Problem)objectMapper.readValue(responseBody, Problem.class);
        }
        catch (JsonProcessingException ex) {
            LOG.error("Failed to extract problem from body {}", ex, responseBody);
            throw new RuntimeException(ex);
        }
    }

    private static void renderProblem(ErrorUiComponent.ErrorComponentBuilder errorComponentBuilder, Problem problem) {
        List<InvalidParam> invalidParams = problem.getInvalidParams();
        if (invalidParams != null && !invalidParams.isEmpty()) {
            errorComponentBuilder.details(IgniteCliApiExceptionHandler.extractInvalidParams(invalidParams), new UiElement[0]);
        }
        errorComponentBuilder.header(problem.getDetail() != null ? problem.getDetail() : problem.getTitle(), new UiElement[0]).errorCode(problem.getCode()).traceId(problem.getTraceId());
    }

    private static String extractInvalidParams(List<InvalidParam> invalidParams) {
        return invalidParams.stream().map(invalidParam -> invalidParam.getName() + ": " + invalidParam.getReason()).collect(Collectors.joining(System.lineSeparator()));
    }

    @Override
    public Class<IgniteCliApiException> applicableException() {
        return IgniteCliApiException.class;
    }
}

