/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.core.repl.registry.impl;

import jakarta.inject.Singleton;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.cli.call.cluster.topology.PhysicalTopologyCall;
import org.apache.ignite3.internal.cli.core.JdbcUrlFactory;
import org.apache.ignite3.internal.cli.core.call.UrlCallInput;
import org.apache.ignite3.internal.cli.core.repl.PeriodicSessionTask;
import org.apache.ignite3.internal.cli.core.repl.SessionInfo;
import org.apache.ignite3.internal.cli.core.repl.registry.JdbcUrlRegistry;
import org.apache.ignite3.internal.cli.core.repl.registry.impl.NodeNameRegistryImpl;
import org.apache.ignite3.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite3.internal.cli.logger.CliLoggers;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.rest.client.api.NodeManagementApi;
import org.apache.ignite3.rest.client.invoker.ApiException;
import org.apache.ignite3.rest.client.model.ClusterNode;
import org.apache.ignite3.rest.client.model.NodeInfo;
import org.jetbrains.annotations.Nullable;

@Singleton
public class JdbcUrlRegistryImpl
implements JdbcUrlRegistry,
PeriodicSessionTask {
    private static final IgniteLogger LOG = CliLoggers.forClass(JdbcUrlRegistryImpl.class);
    private final PhysicalTopologyCall physicalTopologyCall;
    private final ApiClientFactory clientFactory;
    private final JdbcUrlFactory jdbcUrlFactory;
    private volatile Set<String> jdbcUrls = Set.of();

    public JdbcUrlRegistryImpl(PhysicalTopologyCall physicalTopologyCall, ApiClientFactory clientFactory, JdbcUrlFactory jdbcUrlFactory) {
        this.physicalTopologyCall = physicalTopologyCall;
        this.clientFactory = clientFactory;
        this.jdbcUrlFactory = jdbcUrlFactory;
    }

    @Override
    public void update(SessionInfo sessionInfo) {
        this.jdbcUrls = this.physicalTopologyCall.execute(new UrlCallInput(sessionInfo.nodeUrl())).body().stream().map(this::fetchJdbcUrl).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @Override
    public void onDisconnect() {
        this.jdbcUrls = Set.of();
    }

    @Override
    public Set<String> jdbcUrls() {
        return Set.copyOf(this.jdbcUrls);
    }

    @Nullable
    private String fetchJdbcUrl(ClusterNode node) {
        try {
            String nodeUrl = NodeNameRegistryImpl.urlFromClusterNode(node.getMetadata());
            if (nodeUrl != null) {
                NodeInfo nodeInfo = new NodeManagementApi(this.clientFactory.getClient(nodeUrl)).nodeInfo();
                return this.jdbcUrlFactory.constructJdbcUrl(nodeUrl, nodeInfo.getJdbcPort());
            }
        }
        catch (ApiException e) {
            LOG.warn("Couldn't fetch jdbc url of node {}", e, node.getName());
        }
        return null;
    }
}

