/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.compute.executor.platform.dotnet;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite3.compute.JobExecutionContext;
import org.apache.ignite3.internal.compute.ComputeJobDataHolder;
import org.apache.ignite3.internal.compute.executor.platform.PlatformComputeConnection;
import org.apache.ignite3.internal.compute.executor.platform.PlatformComputeTransport;
import org.apache.ignite3.internal.compute.executor.platform.dotnet.DotNetExecutorProcess;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.util.ExceptionUtils;
import org.apache.ignite3.lang.ErrorGroups;
import org.apache.ignite3.lang.IgniteException;
import org.apache.ignite3.lang.TraceableException;
import org.jetbrains.annotations.Nullable;

public class DotNetComputeExecutor {
    private static final IgniteLogger LOG = Loggers.forClass(DotNetComputeExecutor.class);
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();
    private static final String DOTNET_BINARY_PATH = DotNetComputeExecutor.resolveDotNetBinaryPath();
    private static final int PROCESS_START_TIMEOUT_MS = 5000;
    private static final int PROCESS_START_MAX_ATTEMPTS = 2;
    private final PlatformComputeTransport transport;
    private final AtomicLong jobIdGen = new AtomicLong();
    private DotNetExecutorProcess process;

    public DotNetComputeExecutor(PlatformComputeTransport transport) {
        assert (transport != null);
        this.transport = transport;
    }

    public Callable<CompletableFuture<ComputeJobDataHolder>> getJobCallable(String jobClassName, @Nullable ComputeJobDataHolder arg, JobExecutionContext context) {
        return () -> this.executeJobAsync(jobClassName, arg, context);
    }

    public synchronized void beginUndeployUnit(Path unitPath) {
        try {
            String unitPathStr = unitPath.toRealPath(new LinkOption[0]).toString();
            if (this.process == null || DotNetComputeExecutor.isDead(this.process) || this.process.connectionFut().isCompletedExceptionally()) {
                return;
            }
            ((CompletableFuture)this.process.connectionFut().thenCompose(c -> c.undeployUnitsAsync(List.of(unitPathStr)))).exceptionally(e -> {
                TraceableException te;
                Throwable cause = ExceptionUtils.unwrapCause(e);
                if (cause instanceof TraceableException && (te = (TraceableException)((Object)cause)).code() == ErrorGroups.Client.SERVER_TO_CLIENT_REQUEST_ERR) {
                    return true;
                }
                LOG.warn(".NET unit undeploy error: " + e.getMessage(), (Throwable)e);
                return false;
            });
        }
        catch (Throwable t) {
            LOG.warn(".NET unit undeploy error: " + t.getMessage(), t);
        }
    }

    public synchronized void stop() {
        if (this.process != null) {
            this.process.process().destroy();
        }
    }

    private CompletableFuture<ComputeJobDataHolder> executeJobAsync(String jobClassName, @Nullable ComputeJobDataHolder arg, JobExecutionContext context) {
        if (context.isCancelled()) {
            return CompletableFuture.failedFuture(new CancellationException("Job was cancelled"));
        }
        long jobId = this.jobIdGen.incrementAndGet();
        return this.getPlatformComputeConnectionWithRetryAsync().thenCompose(conn -> ((CompletableFuture)conn.connectionFut().thenCompose(c -> c.executeJobAsync(jobId, jobClassName, context, arg))).exceptionally(e -> {
            Throwable cause = ExceptionUtils.unwrapCause(e);
            if (cause instanceof TraceableException) {
                TraceableException te = (TraceableException)((Object)cause);
                if (te.code() == ErrorGroups.Client.SERVER_TO_CLIENT_REQUEST_ERR) {
                    Throwable cause2 = DotNetComputeExecutor.handleTransportError(conn.process(), cause);
                    throw new IgniteException(te.traceId(), te.code(), ".NET compute executor connection lost", cause2);
                }
                throw new IgniteException(te.traceId(), te.code(), ".NET job failed: " + cause.getMessage(), (Throwable)e);
            }
            throw new IgniteException(ErrorGroups.Compute.COMPUTE_JOB_FAILED_ERR, ".NET job failed: " + cause.getMessage(), (Throwable)e);
        }));
    }

    private CompletableFuture<DotNetExecutorProcess> getPlatformComputeConnectionWithRetryAsync() {
        CompletableFuture<DotNetExecutorProcess> fut = new CompletableFuture<DotNetExecutorProcess>();
        this.getPlatformComputeConnectionWithRetryAsync(fut, null);
        return fut;
    }

    private void getPlatformComputeConnectionWithRetryAsync(CompletableFuture<DotNetExecutorProcess> fut, @Nullable List<Throwable> errors) {
        this.getPlatformComputeConnection().handle((res, e) -> {
            if (e == null) {
                fut.complete((DotNetExecutorProcess)res);
                return null;
            }
            List errors0 = errors == null ? new ArrayList() : errors;
            errors0.add(e);
            if (errors0.size() < 2) {
                this.getPlatformComputeConnectionWithRetryAsync(fut, errors0);
            } else {
                IgniteException finalErr = new IgniteException(ErrorGroups.Common.INTERNAL_ERR, "Could not start .NET executor process in 2 attempts");
                for (Throwable t : errors0) {
                    finalErr.addSuppressed(t);
                }
                fut.completeExceptionally(finalErr);
            }
            return null;
        });
    }

    private CompletableFuture<DotNetExecutorProcess> getPlatformComputeConnection() {
        CompletableFuture<DotNetExecutorProcess> fut = new CompletableFuture<DotNetExecutorProcess>();
        DotNetExecutorProcess proc = this.ensureProcessStarted();
        proc.connectionFut().orTimeout(5000L, TimeUnit.MILLISECONDS).handle((res, e) -> {
            if (e == null && res.isActive()) {
                fut.complete(proc);
            } else {
                fut.completeExceptionally(DotNetComputeExecutor.handleTransportError(proc.process(), e));
            }
            return null;
        });
        return fut;
    }

    private static Throwable handleTransportError(Process proc, @Nullable Throwable cause) {
        TraceableException te;
        Throwable cause0;
        String output = DotNetComputeExecutor.getProcessOutputTail(proc, 10000);
        if (proc.isAlive()) {
            proc.destroyForcibly();
        }
        if (cause != null && (cause0 = ExceptionUtils.unwrapCause(cause)) instanceof TraceableException && (te = (TraceableException)((Object)cause)).code() == ErrorGroups.Client.PROTOCOL_COMPATIBILITY_ERR) {
            return cause;
        }
        return new IgniteException(ErrorGroups.Compute.COMPUTE_PLATFORM_EXECUTOR_ERR, ".NET executor process failed to establish connection with the server: " + output, cause);
    }

    private static String getProcessOutputTail(Process proc, int tail) {
        try {
            InputStream procInputStream = proc.getInputStream();
            while (procInputStream.available() > tail) {
                int toSkip = procInputStream.available() - tail;
                long skipped = procInputStream.skip(toSkip);
                assert (skipped == (long)toSkip) : skipped + " != " + toSkip;
            }
            return new String(procInputStream.readAllBytes(), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            return "Failed to read process output: " + e.getMessage();
        }
    }

    private synchronized DotNetExecutorProcess ensureProcessStarted() {
        if (DotNetComputeExecutor.isDead(this.process)) {
            String executorId = DotNetComputeExecutor.generateSecureRandomId();
            CompletableFuture<PlatformComputeConnection> fut = this.transport.registerComputeExecutorId(executorId);
            String dotnetBinaryPath = DOTNET_BINARY_PATH;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Starting .NET executor process [executorId={}, binaryPath={}]", executorId, dotnetBinaryPath);
            }
            Process proc = DotNetComputeExecutor.startDotNetProcess(this.transport.serverAddress(), this.transport.sslEnabled(), executorId, dotnetBinaryPath);
            proc.onExit().thenRun(() -> {
                if (!fut.completeExceptionally(DotNetComputeExecutor.handleTransportError(proc, new IgniteException(ErrorGroups.Compute.COMPUTE_PLATFORM_EXECUTOR_ERR, ".NET executor process exited")))) {
                    fut.thenAccept(PlatformComputeConnection::close);
                }
            });
            this.process = new DotNetExecutorProcess(proc, fut);
        }
        return this.process;
    }

    private static boolean isDead(DotNetExecutorProcess proc) {
        if (proc == null) {
            return true;
        }
        if (!proc.process().isAlive()) {
            return true;
        }
        PlatformComputeConnection conn = proc.connectionFut().getNow(null);
        return conn != null && !conn.isActive();
    }

    static Process startDotNetProcess(String address, boolean ssl, String executorId, String binaryPath) {
        ProcessBuilder processBuilder = new ProcessBuilder("dotnet", binaryPath);
        processBuilder.redirectErrorStream(true);
        processBuilder.environment().put("IGNITE_COMPUTE_EXECUTOR_SERVER_ADDRESS", address);
        processBuilder.environment().put("IGNITE_COMPUTE_EXECUTOR_SERVER_SSL_ENABLED", Boolean.toString(ssl));
        processBuilder.environment().put("IGNITE_COMPUTE_EXECUTOR_ID", executorId);
        try {
            return processBuilder.start();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String resolveDotNetBinaryPath() {
        return DotNetComputeExecutor.resolveDotNetBinaryDir().resolve("Apache.Ignite.Internal.ComputeExecutor.dll").normalize().toString();
    }

    private static Path resolveDotNetBinaryDir() {
        Path basePath = DotNetComputeExecutor.getCurrentClassPath();
        if (basePath.endsWith(Paths.get("modules", "compute", "build", "classes", "java", "main"))) {
            return basePath.resolve(Path.of("..", "..", "..", "..", "..", "platforms", "dotnet", "Apache.Ignite.Internal.ComputeExecutor", "bin", "Debug", "net8.0"));
        }
        if (basePath.getParent().endsWith(Paths.get("modules", "compute", "build", "libs"))) {
            return basePath.getParent().resolve(Path.of("..", "..", "..", "platforms", "dotnet", "Apache.Ignite.Internal.ComputeExecutor", "bin", "Debug", "net8.0"));
        }
        return basePath.getParent().resolve("dotnet");
    }

    private static Path getCurrentClassPath() {
        URL url = DotNetComputeExecutor.class.getProtectionDomain().getCodeSource().getLocation();
        try {
            return Paths.get(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private static String generateSecureRandomId() {
        byte[] randomBytes = new byte[64];
        SECURE_RANDOM.nextBytes(randomBytes);
        return new String(Base64.getEncoder().encode(randomBytes), StandardCharsets.UTF_8);
    }
}

