/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.rest.deployment.exception.handler;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.server.exceptions.ExceptionHandler;
import jakarta.inject.Singleton;
import org.apache.ignite3.internal.deployunit.exception.DeploymentUnitNotFoundException;
import org.apache.ignite3.internal.rest.api.Problem;
import org.apache.ignite3.internal.rest.constants.HttpCode;
import org.apache.ignite3.internal.rest.problem.HttpProblemResponse;

@Singleton
@Requires(classes={DeploymentUnitNotFoundException.class, ExceptionHandler.class})
public class DeploymentUnitNotFoundExceptionHandler
implements ExceptionHandler<DeploymentUnitNotFoundException, HttpResponse<? extends Problem>> {
    public HttpResponse<? extends Problem> handle(HttpRequest request, DeploymentUnitNotFoundException exception) {
        return HttpProblemResponse.from(Problem.fromHttpCode(HttpCode.NOT_FOUND).detail(exception.getMessage()).build());
    }
}

