/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.table.distributed.storage;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.schema.BinaryRow;
import org.jetbrains.annotations.Nullable;

public class RowBatch {
    public final List<BinaryRow> requestedRows = new ArrayList<BinaryRow>();
    final IntList originalRowOrder = new IntArrayList();
    @Nullable
    public CompletableFuture<?> resultFuture;

    public void add(BinaryRow row, int originalIndex) {
        this.requestedRows.add(row);
        this.originalRowOrder.add(originalIndex);
    }

    @Nullable
    Object getCompletedResult() {
        CompletableFuture<?> resultFuture = this.resultFuture;
        assert (resultFuture != null);
        assert (resultFuture.isDone());
        return resultFuture.join();
    }

    int getOriginalRowIndex(int resultRowIndex) {
        return this.originalRowOrder.getInt(resultRowIndex);
    }

    static CompletableFuture<Void> allResultFutures(Collection<RowBatch> batches) {
        return CompletableFuture.allOf((CompletableFuture[])batches.stream().map(rowBatch -> rowBatch.resultFuture).toArray(CompletableFuture[]::new));
    }

    static int getTotalRequestedRowSize(Collection<RowBatch> batches) {
        int totalSize = 0;
        for (RowBatch batch : batches) {
            totalSize += batch.requestedRows.size();
        }
        return totalSize;
    }
}

