/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.amoro.AmoroTable;
import org.apache.amoro.api.OptimizerRegisterInfo;
import org.apache.amoro.api.OptimizingService;
import org.apache.amoro.api.OptimizingTask;
import org.apache.amoro.api.OptimizingTaskId;
import org.apache.amoro.api.OptimizingTaskResult;
import org.apache.amoro.config.Configurations;
import org.apache.amoro.config.TableConfiguration;
import org.apache.amoro.exception.ForbiddenException;
import org.apache.amoro.exception.IllegalTaskStateException;
import org.apache.amoro.exception.ObjectNotExistsException;
import org.apache.amoro.exception.PluginRetryAuthException;
import org.apache.amoro.exception.TaskNotFoundException;
import org.apache.amoro.resource.Resource;
import org.apache.amoro.resource.ResourceGroup;
import org.apache.amoro.server.AmoroManagementConf;
import org.apache.amoro.server.catalog.CatalogManager;
import org.apache.amoro.server.optimizing.OptimizingProcess;
import org.apache.amoro.server.optimizing.OptimizingProcessMeta;
import org.apache.amoro.server.optimizing.OptimizingQueue;
import org.apache.amoro.server.optimizing.OptimizingStatus;
import org.apache.amoro.server.optimizing.TaskRuntime;
import org.apache.amoro.server.persistence.StatedPersistentBase;
import org.apache.amoro.server.persistence.mapper.OptimizerMapper;
import org.apache.amoro.server.persistence.mapper.OptimizingMapper;
import org.apache.amoro.server.persistence.mapper.ResourceMapper;
import org.apache.amoro.server.resource.OptimizerInstance;
import org.apache.amoro.server.resource.OptimizerManager;
import org.apache.amoro.server.resource.OptimizerThread;
import org.apache.amoro.server.resource.QuotaProvider;
import org.apache.amoro.server.table.RuntimeHandlerChain;
import org.apache.amoro.server.table.TableRuntime;
import org.apache.amoro.server.table.TableService;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.shade.guava32.com.google.common.collect.Sets;
import org.apache.amoro.shade.guava32.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.amoro.shade.thrift.org.apache.thrift.TException;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOptimizingService
extends StatedPersistentBase
implements OptimizingService.Iface,
QuotaProvider {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultOptimizingService.class);
    private final long optimizerTouchTimeout;
    private final long taskAckTimeout;
    private final long taskExecuteTimeout;
    private final int maxPlanningParallelism;
    private final long pollingTimeout;
    private final long refreshGroupInterval;
    private final Map<String, OptimizingQueue> optimizingQueueByGroup = new ConcurrentHashMap<String, OptimizingQueue>();
    private final Map<String, OptimizingQueue> optimizingQueueByToken = new ConcurrentHashMap<String, OptimizingQueue>();
    private final Map<String, OptimizerInstance> authOptimizers = new ConcurrentHashMap<String, OptimizerInstance>();
    private final OptimizerKeeper optimizerKeeper = new OptimizerKeeper();
    private final OptimizingConfigWatcher optimizingConfigWatcher = new OptimizingConfigWatcher();
    private final CatalogManager catalogManager;
    private final OptimizerManager optimizerManager;
    private final TableService tableService;
    private final RuntimeHandlerChain tableHandlerChain;
    private final ExecutorService planExecutor;

    public DefaultOptimizingService(Configurations serviceConfig, CatalogManager catalogManager, OptimizerManager optimizerManager, TableService tableService) {
        this.optimizerTouchTimeout = ((Duration)serviceConfig.get(AmoroManagementConf.OPTIMIZER_HB_TIMEOUT)).toMillis();
        this.taskAckTimeout = ((Duration)serviceConfig.get(AmoroManagementConf.OPTIMIZER_TASK_ACK_TIMEOUT)).toMillis();
        this.taskExecuteTimeout = ((Duration)serviceConfig.get(AmoroManagementConf.OPTIMIZER_TASK_EXECUTE_TIMEOUT)).toMillis();
        this.refreshGroupInterval = ((Duration)serviceConfig.get(AmoroManagementConf.OPTIMIZING_REFRESH_GROUP_INTERVAL)).toMillis();
        this.maxPlanningParallelism = serviceConfig.getInteger(AmoroManagementConf.OPTIMIZER_MAX_PLANNING_PARALLELISM);
        this.pollingTimeout = ((Duration)serviceConfig.get(AmoroManagementConf.OPTIMIZER_POLLING_TIMEOUT)).toMillis();
        this.tableService = tableService;
        this.catalogManager = catalogManager;
        this.optimizerManager = optimizerManager;
        this.tableHandlerChain = new TableRuntimeHandlerImpl();
        this.planExecutor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("plan-executor-thread-%d").setDaemon(true).build());
    }

    public RuntimeHandlerChain getTableRuntimeHandler() {
        return this.tableHandlerChain;
    }

    private void loadOptimizingQueues(List<TableRuntime> tableRuntimeMetaList) {
        List optimizerGroups = this.getAs(ResourceMapper.class, ResourceMapper::selectResourceGroups);
        List optimizers = this.getAs(OptimizerMapper.class, OptimizerMapper::selectAll);
        Map<String, List<TableRuntime>> groupToTableRuntimes = tableRuntimeMetaList.stream().collect(Collectors.groupingBy(TableRuntime::getOptimizerGroup));
        optimizerGroups.forEach(group -> {
            String groupName = group.getName();
            List tableRuntimes = (List)groupToTableRuntimes.remove(groupName);
            OptimizingQueue optimizingQueue = new OptimizingQueue(this.catalogManager, (ResourceGroup)group, this, this.planExecutor, Optional.ofNullable(tableRuntimes).orElseGet(ArrayList::new), this.maxPlanningParallelism);
            this.optimizingQueueByGroup.put(groupName, optimizingQueue);
        });
        optimizers.forEach(optimizer -> this.registerOptimizer((OptimizerInstance)((Object)optimizer), false));
        groupToTableRuntimes.keySet().forEach(groupName -> LOG.warn("Unloaded task runtime in group {}", groupName));
    }

    private void registerOptimizer(OptimizerInstance optimizer, boolean needPersistent) {
        if (needPersistent) {
            this.doAs(OptimizerMapper.class, mapper -> mapper.insertOptimizer(optimizer));
        }
        OptimizingQueue optimizingQueue = this.optimizingQueueByGroup.get(optimizer.getGroupName());
        optimizingQueue.addOptimizer(optimizer);
        this.authOptimizers.put(optimizer.getToken(), optimizer);
        this.optimizingQueueByToken.put(optimizer.getToken(), optimizingQueue);
        this.optimizerKeeper.keepInTouch(optimizer);
    }

    private void unregisterOptimizer(String token) {
        this.doAs(OptimizerMapper.class, mapper -> mapper.deleteOptimizer(token));
        OptimizingQueue optimizingQueue = this.optimizingQueueByToken.remove(token);
        OptimizerInstance optimizer = this.authOptimizers.remove(token);
        if (optimizingQueue != null) {
            optimizingQueue.removeOptimizer(optimizer);
        }
    }

    public void ping() {
    }

    public List<TaskRuntime<?>> listTasks(String optimizerGroup) {
        return this.getQueueByGroup(optimizerGroup).collectTasks();
    }

    public void touch(String authToken) {
        OptimizerInstance optimizer = this.getAuthenticatedOptimizer(authToken).touch();
        LOG.debug("Optimizer {} touch time: {}", (Object)optimizer.getToken(), (Object)optimizer.getTouchTime());
        this.doAs(OptimizerMapper.class, mapper -> mapper.updateTouchTime(optimizer.getToken()));
    }

    private OptimizerInstance getAuthenticatedOptimizer(String authToken) {
        Preconditions.checkArgument((authToken != null ? 1 : 0) != 0, (Object)"authToken can not be null");
        return Optional.ofNullable(this.authOptimizers.get(authToken)).orElseThrow(() -> new PluginRetryAuthException("Optimizer has not been authenticated"));
    }

    public OptimizingTask pollTask(String authToken, int threadId) {
        LOG.debug("Optimizer {} (threadId {}) try polling task", (Object)authToken, (Object)threadId);
        OptimizingQueue queue = this.getQueueByToken(authToken);
        return Optional.ofNullable(queue.pollTask(this.pollingTimeout)).map(task -> this.extractOptimizingTask((TaskRuntime<?>)task, authToken, threadId, queue)).orElse(null);
    }

    private OptimizingTask extractOptimizingTask(TaskRuntime<?> task, String authToken, int threadId, OptimizingQueue queue) {
        try {
            OptimizerThread optimizerThread = this.getAuthenticatedOptimizer(authToken).getThread(threadId);
            task.schedule(optimizerThread);
            LOG.info("OptimizerThread {} polled task {}", (Object)optimizerThread, (Object)task.getTaskId());
            return task.extractProtocolTask();
        }
        catch (Throwable throwable) {
            LOG.error("Schedule task {} failed, put it to retry queue", (Object)task.getTaskId(), (Object)throwable);
            queue.retryTask(task);
            return null;
        }
    }

    public void ackTask(String authToken, int threadId, OptimizingTaskId taskId) {
        LOG.info("Ack task {} by optimizer {} (threadId {})", new Object[]{taskId, authToken, threadId});
        OptimizingQueue queue = this.getQueueByToken(authToken);
        Optional.ofNullable(queue.getTask(taskId)).orElseThrow(() -> new TaskNotFoundException(taskId)).ack(this.getAuthenticatedOptimizer(authToken).getThread(threadId));
    }

    public void completeTask(String authToken, OptimizingTaskResult taskResult) {
        LOG.info("Optimizer {} (threadId {}) complete task {} (status: {})", new Object[]{authToken, taskResult.getThreadId(), taskResult.getTaskId(), taskResult.getErrorMessage() == null ? "SUCCESS" : "FAIL"});
        OptimizingQueue queue = this.getQueueByToken(authToken);
        OptimizerThread thread = this.getAuthenticatedOptimizer(authToken).getThread(taskResult.getThreadId());
        Optional.ofNullable(queue.getTask(taskResult.getTaskId())).orElseThrow(() -> new TaskNotFoundException(taskResult.getTaskId())).complete(thread, taskResult);
    }

    public String authenticate(OptimizerRegisterInfo registerInfo) {
        LOG.info("Register optimizer {}.", (Object)registerInfo);
        Optional.ofNullable(registerInfo.getProperties().get("heart-beat-interval")).ifPresent(interval -> {
            if (Long.parseLong(interval) >= this.optimizerTouchTimeout) {
                throw new ForbiddenException(String.format("The %s:%s configuration should be less than AMS's %s:%s", "heart-beat-interval", interval, AmoroManagementConf.OPTIMIZER_HB_TIMEOUT.key(), this.optimizerTouchTimeout));
            }
        });
        OptimizingQueue queue = this.getQueueByGroup(registerInfo.getGroupName());
        OptimizerInstance optimizer = new OptimizerInstance(registerInfo, queue.getContainerName());
        this.registerOptimizer(optimizer, true);
        return optimizer.getToken();
    }

    public boolean cancelProcess(long processId) throws TException {
        OptimizingProcessMeta processMeta = this.getAs(OptimizingMapper.class, m -> m.getOptimizingProcess(processId));
        if (processMeta == null) {
            return false;
        }
        long tableId = processMeta.getTableId();
        TableRuntime tableRuntime = this.tableService.getRuntime(tableId);
        if (tableRuntime == null) {
            return false;
        }
        OptimizingProcess process = tableRuntime.getOptimizingProcess();
        if (process == null || process.getProcessId() != processId) {
            return false;
        }
        process.close();
        return true;
    }

    private OptimizingQueue getQueueByGroup(String optimizerGroup) {
        return this.getOptionalQueueByGroup(optimizerGroup).orElseThrow(() -> new ObjectNotExistsException("Optimizer group " + optimizerGroup));
    }

    private Optional<OptimizingQueue> getOptionalQueueByGroup(String optimizerGroup) {
        Preconditions.checkArgument((optimizerGroup != null ? 1 : 0) != 0, (Object)"optimizerGroup can not be null");
        return Optional.ofNullable(this.optimizingQueueByGroup.get(optimizerGroup));
    }

    private OptimizingQueue getQueueByToken(String token) {
        Preconditions.checkArgument((token != null ? 1 : 0) != 0, (Object)"optimizer token can not be null");
        return Optional.ofNullable(this.optimizingQueueByToken.get(token)).orElseThrow(() -> new PluginRetryAuthException("Optimizer has not been authenticated"));
    }

    public void deleteOptimizer(String group, String resourceId) {
        List deleteOptimizers = this.getAs(OptimizerMapper.class, mapper -> mapper.selectByResourceId(resourceId));
        deleteOptimizers.forEach(optimizer -> {
            String token = optimizer.getToken();
            this.unregisterOptimizer(token);
        });
    }

    public void createResourceGroup(ResourceGroup resourceGroup) {
        this.doAsTransaction(() -> {
            OptimizingQueue optimizingQueue = new OptimizingQueue(this.catalogManager, resourceGroup, this, this.planExecutor, new ArrayList<TableRuntime>(), this.maxPlanningParallelism);
            this.optimizingQueueByGroup.put(resourceGroup.getName(), optimizingQueue);
        });
    }

    public void deleteResourceGroup(String groupName) {
        OptimizingQueue optimizingQueue = this.optimizingQueueByGroup.remove(groupName);
        optimizingQueue.dispose();
    }

    public void updateResourceGroup(ResourceGroup resourceGroup) {
        Optional.ofNullable(this.optimizingQueueByGroup.get(resourceGroup.getName())).ifPresent(queue -> queue.updateOptimizerGroup(resourceGroup));
    }

    public void dispose() {
        this.optimizerKeeper.dispose();
        this.tableHandlerChain.dispose();
        this.optimizingQueueByGroup.clear();
        this.optimizingQueueByToken.clear();
        this.authOptimizers.clear();
        this.planExecutor.shutdown();
        this.optimizingConfigWatcher.dispose();
    }

    @Override
    public int getTotalQuota(String resourceGroup) {
        return this.authOptimizers.values().stream().filter(optimizer -> optimizer.getGroupName().equals(resourceGroup)).mapToInt(Resource::getThreadCount).sum();
    }

    private class OptimizingConfigWatcher
    implements Runnable {
        private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("resource-group-watcher-%d").build());

        private OptimizingConfigWatcher() {
        }

        void start() {
            this.run();
            this.scheduler.scheduleAtFixedRate(this, DefaultOptimizingService.this.refreshGroupInterval, DefaultOptimizingService.this.refreshGroupInterval, TimeUnit.MILLISECONDS);
        }

        @Override
        public void run() {
            this.syncGroups();
        }

        private void syncGroups() {
            try {
                List resourceGroups = DefaultOptimizingService.this.optimizerManager.listResourceGroups();
                Set groupNames = resourceGroups.stream().map(ResourceGroup::getName).collect(Collectors.toSet());
                Sets.difference(DefaultOptimizingService.this.optimizingQueueByGroup.keySet(), groupNames).forEach(DefaultOptimizingService.this::deleteResourceGroup);
                resourceGroups.forEach(resourceGroup -> {
                    boolean newGroup;
                    boolean bl = newGroup = !DefaultOptimizingService.this.optimizingQueueByGroup.containsKey(resourceGroup.getName());
                    if (newGroup) {
                        DefaultOptimizingService.this.createResourceGroup((ResourceGroup)resourceGroup);
                    } else if (!((OptimizingQueue)DefaultOptimizingService.this.optimizingQueueByGroup.get(resourceGroup.getName())).getOptimizerGroup().equals(resourceGroup)) {
                        DefaultOptimizingService.this.updateResourceGroup((ResourceGroup)resourceGroup);
                    }
                });
            }
            catch (Throwable t) {
                LOG.error("Sync optimizer groups failed, will retry later.", t);
            }
        }

        void dispose() {
            this.scheduler.shutdown();
        }
    }

    private class OptimizerKeeper
    implements Runnable {
        private volatile boolean stopped = false;
        private final Thread thread = new Thread((Runnable)this, "optimizer-keeper-thread");
        private final DelayQueue<OptimizerKeepingTask> suspendingQueue = new DelayQueue();

        public OptimizerKeeper() {
            this.thread.setDaemon(true);
        }

        public void keepInTouch(OptimizerInstance optimizerInstance) {
            Preconditions.checkNotNull((Object)((Object)optimizerInstance), (Object)"token can not be null");
            this.suspendingQueue.add(new OptimizerKeepingTask(optimizerInstance));
        }

        public void start() {
            this.thread.start();
        }

        public void dispose() {
            this.stopped = true;
            this.thread.interrupt();
        }

        @Override
        public void run() {
            while (!this.stopped) {
                try {
                    OptimizerKeepingTask keepingTask = (OptimizerKeepingTask)this.suspendingQueue.take();
                    String token = keepingTask.getToken();
                    boolean isExpired = !keepingTask.tryKeeping();
                    Optional.ofNullable(keepingTask.getQueue()).ifPresent(queue -> queue.collectTasks(this.buildSuspendingPredication(DefaultOptimizingService.this.authOptimizers.keySet())).forEach(task -> this.retryTask((TaskRuntime<?>)task, (OptimizingQueue)queue)));
                    if (isExpired) {
                        LOG.info("Optimizer {} has been expired, unregister it", (Object)keepingTask.getOptimizer());
                        DefaultOptimizingService.this.unregisterOptimizer(token);
                        continue;
                    }
                    LOG.debug("Optimizer {} is being touched, keep it", (Object)keepingTask.getOptimizer());
                    this.keepInTouch(keepingTask.getOptimizer());
                }
                catch (InterruptedException keepingTask) {
                }
                catch (Throwable t) {
                    LOG.error("OptimizerKeeper has encountered a problem.", t);
                }
            }
        }

        private void retryTask(TaskRuntime<?> task, OptimizingQueue queue) {
            if (task.getStatus() == TaskRuntime.Status.ACKED && task.getStartTime() + DefaultOptimizingService.this.taskExecuteTimeout < System.currentTimeMillis()) {
                LOG.warn("Task {} has been suspended in ACK state for {} (start time: {}), put it to retry queue, optimizer {}. (Note: The task may have finished executing, but ams did not receive the COMPLETE message from the optimizer.)", new Object[]{task.getTaskId(), Duration.ofMillis(DefaultOptimizingService.this.taskExecuteTimeout), task.getStartTime(), task.getResourceDesc()});
            } else {
                LOG.info("Task {} is suspending, since it's optimizer is expired, put it to retry queue, optimizer {}", (Object)task.getTaskId(), (Object)task.getResourceDesc());
            }
            try {
                queue.retryTask(task);
            }
            catch (IllegalTaskStateException e) {
                LOG.error("Retry task {} failed due to {}, will check it in next round", (Object)task.getTaskId(), (Object)e.getMessage());
            }
        }

        private Predicate<TaskRuntime<?>> buildSuspendingPredication(Set<String> activeTokens) {
            return task -> StringUtils.isNotBlank((CharSequence)task.getToken()) && !activeTokens.contains(task.getToken()) && task.getStatus() != TaskRuntime.Status.SUCCESS || task.getStatus() == TaskRuntime.Status.SCHEDULED && task.getStartTime() + DefaultOptimizingService.this.taskAckTimeout < System.currentTimeMillis() || task.getStatus() == TaskRuntime.Status.ACKED && task.getStartTime() + DefaultOptimizingService.this.taskExecuteTimeout < System.currentTimeMillis();
        }
    }

    private class OptimizerKeepingTask
    implements Delayed {
        private final OptimizerInstance optimizerInstance;
        private final long lastTouchTime;

        public OptimizerKeepingTask(OptimizerInstance optimizer) {
            this.optimizerInstance = optimizer;
            this.lastTouchTime = optimizer.getTouchTime();
        }

        public boolean tryKeeping() {
            return Objects.equals((Object)this.optimizerInstance, DefaultOptimizingService.this.authOptimizers.get(this.optimizerInstance.getToken())) && this.lastTouchTime != this.optimizerInstance.getTouchTime();
        }

        @Override
        public long getDelay(@NotNull TimeUnit unit) {
            return unit.convert(this.lastTouchTime + DefaultOptimizingService.this.optimizerTouchTimeout - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(@NotNull Delayed o) {
            OptimizerKeepingTask another = (OptimizerKeepingTask)o;
            return Long.compare(this.lastTouchTime, another.lastTouchTime);
        }

        public String getToken() {
            return this.optimizerInstance.getToken();
        }

        public OptimizingQueue getQueue() {
            return (OptimizingQueue)DefaultOptimizingService.this.optimizingQueueByGroup.get(this.optimizerInstance.getGroupName());
        }

        public OptimizerInstance getOptimizer() {
            return this.optimizerInstance;
        }
    }

    private class TableRuntimeHandlerImpl
    extends RuntimeHandlerChain {
        private TableRuntimeHandlerImpl() {
        }

        @Override
        public void handleStatusChanged(TableRuntime tableRuntime, OptimizingStatus originalStatus) {
            if (!tableRuntime.getOptimizingStatus().isProcessing()) {
                DefaultOptimizingService.this.getOptionalQueueByGroup(tableRuntime.getOptimizerGroup()).ifPresent(q -> q.refreshTable(tableRuntime));
            }
        }

        @Override
        public void handleConfigChanged(TableRuntime tableRuntime, TableConfiguration originalConfig) {
            String originalGroup = originalConfig.getOptimizingConfig().getOptimizerGroup();
            if (!tableRuntime.getOptimizerGroup().equals(originalGroup)) {
                DefaultOptimizingService.this.getOptionalQueueByGroup(originalGroup).ifPresent(q -> q.releaseTable(tableRuntime));
            }
            DefaultOptimizingService.this.getOptionalQueueByGroup(tableRuntime.getOptimizerGroup()).ifPresent(q -> q.refreshTable(tableRuntime));
        }

        @Override
        public void handleTableAdded(AmoroTable<?> table, TableRuntime tableRuntime) {
            DefaultOptimizingService.this.getOptionalQueueByGroup(tableRuntime.getOptimizerGroup()).ifPresent(q -> q.refreshTable(tableRuntime));
        }

        @Override
        public void handleTableRemoved(TableRuntime tableRuntime) {
            DefaultOptimizingService.this.getOptionalQueueByGroup(tableRuntime.getOptimizerGroup()).ifPresent(queue -> queue.releaseTable(tableRuntime));
        }

        @Override
        protected void initHandler(List<TableRuntime> tableRuntimeList) {
            LOG.info("OptimizerManagementService begin initializing");
            DefaultOptimizingService.this.loadOptimizingQueues(tableRuntimeList);
            DefaultOptimizingService.this.optimizerKeeper.start();
            DefaultOptimizingService.this.optimizingConfigWatcher.start();
            LOG.info("SuspendingDetector for Optimizer has been started.");
            LOG.info("OptimizerManagementService initializing has completed");
        }

        @Override
        protected void doDispose() {
        }
    }
}

