/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.catalog;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Map;
import org.apache.amoro.AmoroTable;
import org.apache.amoro.TableFormat;
import org.apache.amoro.api.CatalogMeta;
import org.apache.amoro.config.Configurations;
import org.apache.amoro.exception.ObjectNotExistsException;
import org.apache.amoro.formats.iceberg.IcebergTable;
import org.apache.amoro.formats.mixed.MixedTable;
import org.apache.amoro.io.AuthenticatedFileIO;
import org.apache.amoro.server.AmoroManagementConf;
import org.apache.amoro.server.catalog.InternalCatalog;
import org.apache.amoro.server.table.TableMetadata;
import org.apache.amoro.server.table.internal.InternalIcebergCreator;
import org.apache.amoro.server.table.internal.InternalIcebergHandler;
import org.apache.amoro.server.table.internal.InternalMixedIcebergCreator;
import org.apache.amoro.server.table.internal.InternalMixedIcebergHandler;
import org.apache.amoro.server.table.internal.InternalTableCreator;
import org.apache.amoro.server.table.internal.InternalTableHandler;
import org.apache.amoro.server.utils.InternalTableUtil;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.table.BasicKeyedTable;
import org.apache.amoro.table.BasicUnkeyedTable;
import org.apache.amoro.table.ChangeTable;
import org.apache.amoro.table.PrimaryKeySpec;
import org.apache.amoro.table.TableMetaStore;
import org.apache.amoro.utils.CatalogUtil;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.rest.RESTCatalog;
import org.apache.iceberg.rest.requests.CreateTableRequest;

public class InternalCatalogImpl
extends InternalCatalog {
    private static final String URI = "uri";
    final int httpPort;
    final String exposedHost;
    final Cache<AmoroTable<?>, FileIO> fileIOCloser;

    protected InternalCatalogImpl(CatalogMeta metadata, Configurations serverConfiguration) {
        super(metadata);
        this.httpPort = serverConfiguration.getInteger(AmoroManagementConf.HTTP_SERVER_PORT);
        this.exposedHost = serverConfiguration.getString(AmoroManagementConf.SERVER_EXPOSE_HOST);
        this.fileIOCloser = this.newFileIOCloser();
    }

    @Override
    public CatalogMeta getMetadata() {
        CatalogMeta meta = super.getMetadata();
        if (!meta.getCatalogProperties().containsKey(URI)) {
            meta.putToCatalogProperties(URI, this.defaultRestURI());
        }
        meta.putToCatalogProperties("catalog-impl", RESTCatalog.class.getName());
        return meta.deepCopy();
    }

    @Override
    public void updateMetadata(CatalogMeta metadata) {
        String uri;
        String defaultUrl = this.defaultRestURI();
        if (defaultUrl.equals(uri = metadata.getCatalogProperties().getOrDefault(URI, defaultUrl))) {
            metadata.getCatalogProperties().remove(URI);
        }
        super.updateMetadata(metadata);
    }

    @Override
    public AmoroTable<?> loadTable(String database, String tableName) {
        InternalTableHandler<TableOperations> handler;
        Preconditions.checkArgument((!this.isChangeStoreName(tableName) ? 1 : 0) != 0, (Object)"table name is invalid for load table");
        try {
            handler = this.newTableHandler(database, tableName);
        }
        catch (ObjectNotExistsException e) {
            return null;
        }
        if (TableFormat.ICEBERG.equals((Object)handler.tableMetadata().getFormat())) {
            return this.loadIcebergTable(database, tableName, handler);
        }
        if (TableFormat.MIXED_ICEBERG.equals((Object)handler.tableMetadata().getFormat())) {
            return this.loadMixedIcebergTable(database, tableName, handler);
        }
        throw new IllegalArgumentException("Unsupported table format:" + handler.tableMetadata().getFormat());
    }

    private AmoroTable<?> loadIcebergTable(String database, String tableName, InternalTableHandler<TableOperations> handler) {
        TableMetadata tableMetadata = handler.tableMetadata();
        TableOperations ops = handler.newTableOperator();
        BaseTable table = new BaseTable(ops, TableIdentifier.of((String[])new String[]{tableMetadata.getTableIdentifier().getDatabase(), tableMetadata.getTableIdentifier().getTableName()}).toString());
        org.apache.amoro.table.TableIdentifier tableIdentifier = org.apache.amoro.table.TableIdentifier.of((String)this.name(), (String)database, (String)tableName);
        IcebergTable amoroTable = IcebergTable.newIcebergTable((org.apache.amoro.table.TableIdentifier)tableIdentifier, (Table)table, (TableMetaStore)CatalogUtil.buildMetaStore((CatalogMeta)this.getMetadata()), (Map)this.getMetadata().getCatalogProperties());
        this.fileIOCloser.put((Object)amoroTable, (Object)ops.io());
        return amoroTable;
    }

    private AmoroTable<?> loadMixedIcebergTable(String database, String tableName, InternalTableHandler<TableOperations> handler) {
        BasicUnkeyedTable mixedIcebergTable;
        TableMetadata tableMetadata = handler.tableMetadata();
        org.apache.amoro.table.TableIdentifier tableIdentifier = org.apache.amoro.table.TableIdentifier.of((String)this.name(), (String)database, (String)tableName);
        AuthenticatedFileIO fileIO = InternalTableUtil.newIcebergFileIo(this.getMetadata());
        BaseTable baseTable = this.loadTableStore(tableMetadata, false);
        if (InternalTableUtil.isKeyedMixedTable(tableMetadata)) {
            BaseTable changeTable = this.loadTableStore(tableMetadata, true);
            PrimaryKeySpec.Builder keySpecBuilder = PrimaryKeySpec.builderFor((Schema)baseTable.schema());
            tableMetadata.buildTableMeta().getKeySpec().getFields().forEach(arg_0 -> ((PrimaryKeySpec.Builder)keySpecBuilder).addColumn(arg_0));
            PrimaryKeySpec keySpec = keySpecBuilder.build();
            mixedIcebergTable = new BasicKeyedTable(tableMetadata.getTableLocation(), keySpec, (org.apache.amoro.table.BaseTable)new BasicKeyedTable.BaseInternalTable(tableIdentifier, (Table)baseTable, fileIO, this.getMetadata().getCatalogProperties()), (ChangeTable)new BasicKeyedTable.ChangeInternalTable(tableIdentifier, (Table)changeTable, fileIO, this.getMetadata().getCatalogProperties()));
        } else {
            mixedIcebergTable = new BasicUnkeyedTable(tableIdentifier, (Table)baseTable, fileIO, this.getMetadata().getCatalogProperties());
        }
        MixedTable amoroTable = new MixedTable((org.apache.amoro.table.MixedTable)mixedIcebergTable, TableFormat.MIXED_ICEBERG);
        this.fileIOCloser.put((Object)amoroTable, (Object)fileIO);
        return amoroTable;
    }

    private BaseTable loadTableStore(TableMetadata tableMetadata, boolean isChangeStore) {
        TableOperations ops = this.newTableStoreHandler(tableMetadata, isChangeStore).newTableOperator();
        return new BaseTable(ops, TableIdentifier.of((String[])new String[]{tableMetadata.getTableIdentifier().getDatabase(), tableMetadata.getTableIdentifier().getTableName()}).toString());
    }

    private String defaultRestURI() {
        return "http://" + this.exposedHost + ":" + this.httpPort + "/api/iceberg/rest";
    }

    @Override
    public InternalTableCreator newTableCreator(String database, String tableName, TableFormat format, CreateTableRequest creatorArguments) {
        if (this.tableExists(database, tableName)) {
            throw new AlreadyExistsException("Table " + this.name() + "." + database + "." + tableName + " already exists.", new Object[0]);
        }
        if (TableFormat.ICEBERG.equals((Object)format)) {
            return new InternalIcebergCreator(this.getMetadata(), database, tableName, creatorArguments);
        }
        if (TableFormat.MIXED_ICEBERG.equals((Object)format)) {
            return new InternalMixedIcebergCreator(this.getMetadata(), database, tableName, creatorArguments);
        }
        throw new IllegalArgumentException("Unsupported table format:" + format);
    }

    public InternalTableHandler<TableOperations> newTableHandler(String database, String tableName) {
        String realTableName = this.realTableName(tableName);
        TableMetadata metadata = this.loadTableMetadata(database, realTableName);
        if (TableFormat.ICEBERG.equals((Object)metadata.getFormat())) {
            return new InternalIcebergHandler(this.getMetadata(), metadata);
        }
        if (TableFormat.MIXED_ICEBERG.equals((Object)metadata.getFormat())) {
            boolean isChangeStore = this.isChangeStoreName(tableName);
            return this.newTableStoreHandler(metadata, isChangeStore);
        }
        throw new IllegalArgumentException("Unsupported table format:" + metadata.getFormat());
    }

    private String realTableName(String tableStoreName) {
        if (this.isChangeStoreName(tableStoreName)) {
            return tableStoreName.substring(0, tableStoreName.length() - "@change".length());
        }
        return tableStoreName;
    }

    private boolean isChangeStoreName(String tableName) {
        String separator = "@";
        if (!tableName.contains(separator)) {
            return false;
        }
        Preconditions.checkArgument((tableName.indexOf(separator) == tableName.lastIndexOf(separator) && tableName.endsWith("@change") ? 1 : 0) != 0, (String)"illegal table name: %s, %s is not allowed in table name.", (Object)tableName, (Object)separator);
        return true;
    }

    private InternalTableHandler<TableOperations> newTableStoreHandler(TableMetadata metadata, boolean isChangeStore) {
        return new InternalMixedIcebergHandler(this.getMetadata(), metadata, isChangeStore);
    }

    private Cache<AmoroTable<?>, FileIO> newFileIOCloser() {
        return Caffeine.newBuilder().weakKeys().removalListener((tbl, fileIO, cause) -> {
            if (null != fileIO) {
                fileIO.close();
            }
        }).build();
    }
}

