/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.manager;

import java.io.Closeable;

public class ClassLoaderContext
implements Closeable {
    private final ClassLoader originalClassLoader;

    public ClassLoaderContext(Object object) {
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader targetClassLoader = object.getClass().getClassLoader();
        if (currentClassLoader != targetClassLoader) {
            this.originalClassLoader = currentClassLoader;
            Thread.currentThread().setContextClassLoader(targetClassLoader);
        } else {
            this.originalClassLoader = null;
        }
    }

    @Override
    public void close() {
        if (this.originalClassLoader != null) {
            Thread.currentThread().setContextClassLoader(this.originalClassLoader);
        }
    }
}

