/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.leaderelection;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.runtime.leaderelection.LeaderInformation;

public class LeaderInformationRegister {
    private static final LeaderInformationRegister EMPTY_REGISTER = new LeaderInformationRegister(Collections.emptyMap());
    private final Map<String, LeaderInformation> leaderInformationPerComponentId;

    public static LeaderInformationRegister empty() {
        return EMPTY_REGISTER;
    }

    public static LeaderInformationRegister of(String componentId, LeaderInformation leaderInformation) {
        return new LeaderInformationRegister(Collections.singletonMap(componentId, leaderInformation));
    }

    public static LeaderInformationRegister merge(@Nullable LeaderInformationRegister leaderInformationRegister, String componentId, LeaderInformation leaderInformation) {
        HashMap<String, LeaderInformation> existingLeaderInformation = new HashMap<String, LeaderInformation>(leaderInformationRegister == null ? Collections.emptyMap() : leaderInformationRegister.leaderInformationPerComponentId);
        if (leaderInformation.isEmpty()) {
            existingLeaderInformation.remove(componentId);
        } else {
            existingLeaderInformation.put(componentId, leaderInformation);
        }
        return new LeaderInformationRegister(existingLeaderInformation);
    }

    public static LeaderInformationRegister clear(@Nullable LeaderInformationRegister leaderInformationRegister, String componentId) {
        if (leaderInformationRegister == null || !leaderInformationRegister.getRegisteredComponentIds().iterator().hasNext()) {
            return LeaderInformationRegister.empty();
        }
        return LeaderInformationRegister.merge(leaderInformationRegister, componentId, LeaderInformation.empty());
    }

    public LeaderInformationRegister(Map<String, LeaderInformation> leaderInformationPerComponentId) {
        this.leaderInformationPerComponentId = leaderInformationPerComponentId.entrySet().stream().filter(entry -> !((LeaderInformation)entry.getValue()).isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public Optional<LeaderInformation> forComponentId(String componentId) {
        return Optional.ofNullable(this.leaderInformationPerComponentId.get(componentId));
    }

    public LeaderInformation forComponentIdOrEmpty(String componentId) {
        return this.forComponentId(componentId).orElse(LeaderInformation.empty());
    }

    public Iterable<String> getRegisteredComponentIds() {
        return this.leaderInformationPerComponentId.keySet();
    }

    public boolean hasLeaderInformation(String componentId) {
        return this.leaderInformationPerComponentId.containsKey(componentId);
    }

    public boolean hasNoLeaderInformation() {
        return this.leaderInformationPerComponentId.isEmpty();
    }
}

