/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils;

import java.io.IOException;
import java.util.Arrays;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerUtils;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.Preconditions;

@Internal
public class NestedSerializersSnapshotDelegate {
    private static final int MAGIC_NUMBER = 1333245;
    private static final int VERSION = 1;
    private final TypeSerializerSnapshot<?>[] nestedSnapshots;

    public NestedSerializersSnapshotDelegate(TypeSerializer<?> ... serializers) {
        this.nestedSnapshots = TypeSerializerUtils.snapshot(serializers);
    }

    @Internal
    NestedSerializersSnapshotDelegate(TypeSerializerSnapshot<?>[] snapshots) {
        this.nestedSnapshots = Preconditions.checkNotNull(snapshots);
    }

    public TypeSerializer<?>[] getRestoredNestedSerializers() {
        return NestedSerializersSnapshotDelegate.snapshotsToRestoreSerializers(this.nestedSnapshots);
    }

    public <T> TypeSerializer<T> getRestoredNestedSerializer(int pos) {
        Preconditions.checkArgument(pos < this.nestedSnapshots.length);
        TypeSerializerSnapshot<?> snapshot = this.nestedSnapshots[pos];
        return snapshot.restoreSerializer();
    }

    public TypeSerializerSnapshot<?>[] getNestedSerializerSnapshots() {
        return this.nestedSnapshots;
    }

    public final void writeNestedSerializerSnapshots(DataOutputView out) throws IOException {
        out.writeInt(1333245);
        out.writeInt(1);
        out.writeInt(this.nestedSnapshots.length);
        for (TypeSerializerSnapshot<?> snap : this.nestedSnapshots) {
            TypeSerializerSnapshot.writeVersionedSnapshot(out, snap);
        }
    }

    public static NestedSerializersSnapshotDelegate readNestedSerializerSnapshots(DataInputView in, ClassLoader cl) throws IOException {
        int magicNumber = in.readInt();
        if (magicNumber != 1333245) {
            throw new IOException(String.format("Corrupt data, magic number mismatch. Expected %8x, found %8x", 1333245, magicNumber));
        }
        int version = in.readInt();
        if (version != 1) {
            throw new IOException("Unrecognized version: " + version);
        }
        int numSnapshots = in.readInt();
        TypeSerializerSnapshot[] nestedSnapshots = new TypeSerializerSnapshot[numSnapshots];
        for (int i = 0; i < numSnapshots; ++i) {
            nestedSnapshots[i] = TypeSerializerSnapshot.readVersionedSnapshot(in, cl);
        }
        return new NestedSerializersSnapshotDelegate(nestedSnapshots);
    }

    private static TypeSerializer<?>[] snapshotsToRestoreSerializers(TypeSerializerSnapshot<?> ... snapshots) {
        return (TypeSerializer[])Arrays.stream(snapshots).map(TypeSerializerSnapshot::restoreSerializer).toArray(TypeSerializer[]::new);
    }
}

