/*
 * Decompiled with CFR 0.152.
 */
package com.github.pagehelper.dialect.rowbounds;

import com.github.pagehelper.dialect.AbstractRowBoundsDialect;
import com.github.pagehelper.dialect.ReplaceSql;
import com.github.pagehelper.dialect.replace.RegexWithNolockReplaceSql;
import com.github.pagehelper.dialect.replace.SimpleWithNolockReplaceSql;
import com.github.pagehelper.parser.SqlServerSqlParser;
import com.github.pagehelper.parser.defaults.DefaultSqlServerSqlParser;
import com.github.pagehelper.util.ClassUtil;
import com.github.pagehelper.util.StringUtil;
import java.util.Properties;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.session.RowBounds;

public class SqlServerRowBoundsDialect
extends AbstractRowBoundsDialect {
    protected SqlServerSqlParser sqlServerSqlParser;
    protected ReplaceSql replaceSql;

    @Override
    public String getCountSql(MappedStatement ms, BoundSql boundSql, Object parameterObject, RowBounds rowBounds, CacheKey countKey) {
        String sql = boundSql.getSql();
        sql = this.replaceSql.replace(sql);
        sql = this.countSqlParser.getSmartCountSql(sql);
        sql = this.replaceSql.restore(sql);
        return sql;
    }

    @Override
    public String getPageSql(String sql, RowBounds rowBounds, CacheKey pageKey) {
        pageKey.update((Object)rowBounds.getOffset());
        pageKey.update((Object)rowBounds.getLimit());
        sql = this.replaceSql.replace(sql);
        sql = this.sqlServerSqlParser.convertToPageSql(sql, null, null);
        sql = this.replaceSql.restore(sql);
        sql = sql.replace(String.valueOf(Long.MIN_VALUE), String.valueOf(rowBounds.getOffset()));
        sql = sql.replace(String.valueOf(Long.MAX_VALUE), String.valueOf(rowBounds.getLimit()));
        return sql;
    }

    @Override
    public void setProperties(Properties properties) {
        super.setProperties(properties);
        this.sqlServerSqlParser = ClassUtil.newInstance(properties.getProperty("sqlServerSqlParser"), SqlServerSqlParser.class, properties, DefaultSqlServerSqlParser::new);
        String replaceSql = properties.getProperty("replaceSql");
        this.replaceSql = StringUtil.isEmpty(replaceSql) || "simple".equalsIgnoreCase(replaceSql) ? new SimpleWithNolockReplaceSql() : ("regex".equalsIgnoreCase(replaceSql) ? new RegexWithNolockReplaceSql() : (ReplaceSql)ClassUtil.newInstance(replaceSql, properties));
    }
}

