/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.UnresolvedSeed$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ExpressionWithRandomSeed;
import org.apache.spark.sql.catalyst.expressions.LeafExpression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Nondeterministic;
import org.apache.spark.sql.catalyst.expressions.Stateful;
import org.apache.spark.sql.catalyst.expressions.Uuid$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.RandomUUIDGenerator;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_() - Returns an universally unique identifier (UUID) string. The value is returned as a canonical UUID 36-character string.", examples="\n    Examples:\n      > SELECT _FUNC_();\n       46707d92-02f4-4817-8116-a4c3b23e6266\n  ", note="\n    The function is non-deterministic.\n  ", since="2.3.0", group="misc_funcs")
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015h\u0001\u0002\u0011\"\u0001:B\u0001B\u0011\u0001\u0003\u0016\u0004%\ta\u0011\u0005\t\u0015\u0002\u0011\t\u0012)A\u0005\t\")1\n\u0001C\u0001\u0019\")1\n\u0001C\u0001\u001f\")\u0001\u000b\u0001C!#\")Q\u000b\u0001C!-\"A\u0011\f\u0001EC\u0002\u0013\u0005#\fC\u0003_\u0001\u0011\u0005#\fC\u0003`\u0001\u0011\u0005\u0003\rC\u0005h\u0001\u0001\u0007\t\u0011)Q\u0005Q\")!\u000f\u0001C)g\")A\u0010\u0001C){\"9\u0011q\u0002\u0001\u0005B\u0005E\u0001BBA\u0017\u0001\u0011\u0005s\nC\u0005\u00020\u0001\t\t\u0011\"\u0001\u00022!I\u0011Q\u0007\u0001\u0012\u0002\u0013\u0005\u0011q\u0007\u0005\n\u0003\u001b\u0002\u0011\u0011!C!\u0003\u001fB\u0011\"!\u0019\u0001\u0003\u0003%\t!a\u0019\t\u0013\u0005\u0015\u0004!!A\u0005\u0002\u0005\u001d\u0004\"CA7\u0001\u0005\u0005I\u0011IA8\u0011%\ti\bAA\u0001\n\u0003\ty\bC\u0005\u0002\u0004\u0002\t\t\u0011\"\u0011\u0002\u0006\u001eI\u0011qV\u0011\u0002\u0002#\u0005\u0011\u0011\u0017\u0004\tA\u0005\n\t\u0011#\u0001\u00024\"11\n\u0007C\u0001\u0003\u0003D\u0011\"a1\u0019\u0003\u0003%)%!2\t\u0013\u0005\u001d\u0007$!A\u0005\u0002\u0006%\u0007\"CAg1E\u0005I\u0011AA\u001c\u0011%\ty\rGA\u0001\n\u0003\u000b\t\u000eC\u0005\u0002Zb\t\n\u0011\"\u0001\u00028!I\u00111\u001c\r\u0002\u0002\u0013%\u0011Q\u001c\u0002\u0005+VLGM\u0003\u0002#G\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t!S%\u0001\u0005dCR\fG._:u\u0015\t1s%A\u0002tc2T!\u0001K\u0015\u0002\u000bM\u0004\u0018M]6\u000b\u0005)Z\u0013AB1qC\u000eDWMC\u0001-\u0003\ry'oZ\u0002\u0001'\u0019\u0001qf\r\u001c:\u007fA\u0011\u0001'M\u0007\u0002C%\u0011!'\t\u0002\u000f\u0019\u0016\fg-\u0012=qe\u0016\u001c8/[8o!\t\u0001D'\u0003\u00026C\tA1\u000b^1uK\u001a,H\u000e\u0005\u00021o%\u0011\u0001(\t\u0002\u0019\u000bb\u0004(/Z:tS>tw+\u001b;i%\u0006tGm\\7TK\u0016$\u0007C\u0001\u001e>\u001b\u0005Y$\"\u0001\u001f\u0002\u000bM\u001c\u0017\r\\1\n\u0005yZ$a\u0002)s_\u0012,8\r\u001e\t\u0003u\u0001K!!Q\u001e\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u0015I\fg\u000eZ8n'\u0016,G-F\u0001E!\rQTiR\u0005\u0003\rn\u0012aa\u00149uS>t\u0007C\u0001\u001eI\u0013\tI5H\u0001\u0003M_:<\u0017a\u0003:b]\u0012|WnU3fI\u0002\na\u0001P5oSRtDCA'O!\t\u0001\u0004\u0001C\u0004C\u0007A\u0005\t\u0019\u0001#\u0015\u00035\u000bab]3fI\u0016C\bO]3tg&|g.F\u0001S!\t\u00014+\u0003\u0002UC\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\u0017]LG\u000f\u001b(foN+W\r\u001a\u000b\u0003\u001b^CQ\u0001\u0017\u0004A\u0002\u001d\u000bAa]3fI\u0006A!/Z:pYZ,G-F\u0001\\!\tQD,\u0003\u0002^w\t9!i\\8mK\u0006t\u0017\u0001\u00038vY2\f'\r\\3\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012!\u0019\t\u0003E\u0016l\u0011a\u0019\u0006\u0003I\u0016\nQ\u0001^=qKNL!AZ2\u0003\u0011\u0011\u000bG/\u0019+za\u0016\fqB]1oI>lw)\u001a8fe\u0006$xN\u001d\t\u0003S2l\u0011A\u001b\u0006\u0003W\u000e\nA!\u001e;jY&\u0011QN\u001b\u0002\u0014%\u0006tGm\\7V+&#u)\u001a8fe\u0006$xN\u001d\u0015\u0003\u0015=\u0004\"A\u000f9\n\u0005E\\$!\u0003;sC:\u001c\u0018.\u001a8u\u0003IIg.\u001b;jC2L'0Z%oi\u0016\u0014h.\u00197\u0015\u0005Q<\bC\u0001\u001ev\u0013\t18H\u0001\u0003V]&$\b\"\u0002=\f\u0001\u0004I\u0018A\u00049beRLG/[8o\u0013:$W\r\u001f\t\u0003uiL!a_\u001e\u0003\u0007%sG/\u0001\u0007fm\u0006d\u0017J\u001c;fe:\fG\u000eF\u0002\u007f\u0003\u0007\u0001\"AO@\n\u0007\u0005\u00051HA\u0002B]fDq!!\u0002\r\u0001\u0004\t9!A\u0003j]B,H\u000f\u0005\u0003\u0002\n\u0005-Q\"A\u0012\n\u0007\u000551EA\u0006J]R,'O\\1m%><\u0018!\u00033p\u000f\u0016t7i\u001c3f)\u0019\t\u0019\"a\b\u0002*A!\u0011QCA\u000e\u001b\t\t9BC\u0002\u0002\u001a\u0005\nqaY8eK\u001e,g.\u0003\u0003\u0002\u001e\u0005]!\u0001C#yaJ\u001cu\u000eZ3\t\u000f\u0005\u0005R\u00021\u0001\u0002$\u0005\u00191\r\u001e=\u0011\t\u0005U\u0011QE\u0005\u0005\u0003O\t9B\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000f\u0005-R\u00021\u0001\u0002\u0014\u0005\u0011QM^\u0001\nMJ,7\u000f[\"paf\fAaY8qsR\u0019Q*a\r\t\u000f\t{\u0001\u0013!a\u0001\t\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\u001dU\r!\u00151H\u0016\u0003\u0003{\u0001B!a\u0010\u0002J5\u0011\u0011\u0011\t\u0006\u0005\u0003\u0007\n)%A\u0005v]\u000eDWmY6fI*\u0019\u0011qI\u001e\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002L\u0005\u0005#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!!\u0015\u0011\t\u0005M\u0013QL\u0007\u0003\u0003+RA!a\u0016\u0002Z\u0005!A.\u00198h\u0015\t\tY&\u0001\u0003kCZ\f\u0017\u0002BA0\u0003+\u0012aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLX#A=\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019a0!\u001b\t\u0011\u0005-4#!AA\u0002e\f1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA9!\u0015\t\u0019(!\u001f\u007f\u001b\t\t)HC\u0002\u0002xm\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\tY(!\u001e\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u00047\u0006\u0005\u0005\u0002CA6+\u0005\u0005\t\u0019\u0001@\u0002\r\u0015\fX/\u00197t)\rY\u0016q\u0011\u0005\t\u0003W2\u0012\u0011!a\u0001}\":\u0002!a#\u0002\u0012\u0006M\u0015qSAM\u0003;\u000by*a)\u0002&\u0006%\u00161\u0016\t\u0004a\u00055\u0015bAAHC\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAAK\u0003\u0005\rqLR+O\u0007~C\u0013\u0006I\u0017!%\u0016$XO\u001d8tA\u0005t\u0007%\u001e8jm\u0016\u00148/\u00197ms\u0002*h.[9vK\u0002JG-\u001a8uS\u001aLWM\u001d\u0011)+VKE)\u000b\u0011tiJLgn\u001a\u0018!)\",\u0007E^1mk\u0016\u0004\u0013n\u001d\u0011sKR,(O\\3eA\u0005\u001c\b%\u0019\u0011dC:|g.[2bY\u0002*V+\u0013#!gYj3\r[1sC\u000e$XM\u001d\u0011tiJLgn\u001a\u0018\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!a'\u0002-*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00115m]\u0002t\u0007Z\u001d3[A\u0012d\rN\u00175qE:T\u0006O\u00192m5\nGgY\u001aceM*gG\r\u001c7\u0015\u0001\u0002\u0013\u0001\u00028pi\u0016\f#!!)\u0002U)\u0001\u0003\u0005\t\u0011UQ\u0016\u0004c-\u001e8di&|g\u000eI5tA9|g.\f3fi\u0016\u0014X.\u001b8jgRL7M\f\u0006!A\u0005)1/\u001b8dK\u0006\u0012\u0011qU\u0001\u0006e9\u001ad\u0006M\u0001\u0006OJ|W\u000f]\u0011\u0003\u0003[\u000b!\"\\5tG~3WO\\2t\u0003\u0011)V/\u001b3\u0011\u0005AB2\u0003\u0002\r\u00026~\u0002b!a.\u0002>\u0012kUBAA]\u0015\r\tYlO\u0001\beVtG/[7f\u0013\u0011\ty,!/\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t\u0017\u0007\u0006\u0002\u00022\u0006AAo\\*ue&tw\r\u0006\u0002\u0002R\u0005)\u0011\r\u001d9msR\u0019Q*a3\t\u000f\t[\u0002\u0013!a\u0001\t\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$\u0013'A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005M\u0017Q\u001b\t\u0004u\u0015#\u0005\u0002CAl;\u0005\u0005\t\u0019A'\u0002\u0007a$\u0003'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002`B!\u00111KAq\u0013\u0011\t\u0019/!\u0016\u0003\r=\u0013'.Z2u\u0001")
public class Uuid
extends LeafExpression
implements Stateful,
ExpressionWithRandomSeed,
scala.Serializable {
    private boolean resolved;
    private final Option<Object> randomSeed;
    private transient RandomUUIDGenerator randomGenerator;
    private final Seq<Enumeration.Value> nodePatterns;
    private boolean deterministic;
    private transient boolean org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized;
    private volatile byte bitmap$0;

    public static Option<Object> $lessinit$greater$default$1() {
        return Uuid$.MODULE$.$lessinit$greater$default$1();
    }

    public static Option<Option<Object>> unapply(Uuid uuid) {
        return Uuid$.MODULE$.unapply(uuid);
    }

    public static Option<Object> apply$default$1() {
        return Uuid$.MODULE$.apply$default$1();
    }

    public static <A> Function1<Option<Object>, A> andThen(Function1<Uuid, A> function1) {
        return Uuid$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, Uuid> compose(Function1<A, Option<Object>> function1) {
        return Uuid$.MODULE$.compose(function1);
    }

    @Override
    public boolean fastEquals(TreeNode<?> other) {
        return Stateful.fastEquals$(this, other);
    }

    @Override
    public final boolean foldable() {
        return Nondeterministic.foldable$(this);
    }

    @Override
    public final void initialize(int partitionIndex) {
        Nondeterministic.initialize$(this, partitionIndex);
    }

    @Override
    public final Object eval(InternalRow input) {
        return Nondeterministic.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return Nondeterministic.eval$default$1$(this);
    }

    @Override
    public Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$ExpressionWithRandomSeed$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    private boolean deterministic$lzycompute() {
        Uuid uuid = this;
        synchronized (uuid) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.deterministic = Nondeterministic.deterministic$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.deterministic;
    }

    @Override
    public final boolean deterministic() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.deterministic$lzycompute() : this.deterministic;
    }

    @Override
    public boolean org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized() {
        return this.org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized_$eq(boolean x$1) {
        this.org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized = x$1;
    }

    public Option<Object> randomSeed() {
        return this.randomSeed;
    }

    @Override
    public Expression seedExpression() {
        return (Expression)this.randomSeed().map((Function1 & Serializable & scala.Serializable)v -> Literal$.MODULE$.apply(v)).getOrElse((Function0 & Serializable & scala.Serializable)() -> UnresolvedSeed$.MODULE$);
    }

    @Override
    public Uuid withNewSeed(long seed) {
        return new Uuid((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)seed)));
    }

    private boolean resolved$lzycompute() {
        Uuid uuid = this;
        synchronized (uuid) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.resolved = this.randomSeed().isDefined();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.resolved$lzycompute() : this.resolved;
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public void initializeInternal(int partitionIndex) {
        this.randomGenerator = new RandomUUIDGenerator(BoxesRunTime.unboxToLong((Object)this.randomSeed().get()) + (long)partitionIndex);
    }

    @Override
    public Object evalInternal(InternalRow input) {
        return this.randomGenerator.getNextUUIDUTF8String();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String randomGen = ctx.freshName("randomGen");
        String x$1 = "org.apache.spark.sql.catalyst.util.RandomUUIDGenerator";
        String x$2 = randomGen;
        boolean x$3 = true;
        boolean x$4 = false;
        Function1<String, String> x$5 = ctx.addMutableState$default$3();
        ctx.addMutableState(x$1, x$2, x$5, x$3, x$4);
        ctx.addPartitionInitializationStatement(new StringBuilder(82).append(randomGen).append(" = ").append("new org.apache.spark.sql.catalyst.util.RandomUUIDGenerator(").append(this.randomSeed().get()).append("L + partitionIndex);").toString());
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"final UTF8String ", " = ", ".getNextUUIDUTF8String();"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.value(), randomGen})), FalseLiteral$.MODULE$, ev.copy$default$3());
    }

    @Override
    public Uuid freshCopy() {
        return new Uuid(this.randomSeed());
    }

    public Uuid copy(Option<Object> randomSeed) {
        return new Uuid(randomSeed);
    }

    public Option<Object> copy$default$1() {
        return this.randomSeed();
    }

    @Override
    public String productPrefix() {
        return "Uuid";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return this.randomSeed();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Uuid;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Uuid)) return false;
        boolean bl = true;
        if (!bl) return false;
        Uuid uuid = (Uuid)x$1;
        Option<Object> option = this.randomSeed();
        Option<Object> option2 = uuid.randomSeed();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!uuid.canEqual(this)) return false;
        return true;
    }

    public Uuid(Option<Object> randomSeed) {
        this.randomSeed = randomSeed;
        Nondeterministic.$init$(this);
        Stateful.$init$(this);
        ExpressionWithRandomSeed.$init$(this);
    }

    public Uuid() {
        this((Option<Object>)None$.MODULE$);
    }
}

