/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.data;

import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;

public final class DataTreeNode
implements Serializable {
    private final long mask;
    private final long index;
    public static final DataTreeNode ROOT = new DataTreeNode(0L, 0L);

    public static DataTreeNode of(long mask, long index) {
        if (index > mask) {
            throw new IllegalArgumentException("index can not be greater than mask");
        }
        return new DataTreeNode(mask, index);
    }

    public static DataTreeNode ofId(long id) {
        long mask = DataTreeNode.maskOfId(id);
        long index = id - mask - 1L;
        return new DataTreeNode(mask, index);
    }

    public static long maskOfId(long id) {
        long temp = id;
        int i = 0;
        while (temp != 1L) {
            temp >>= 1;
            ++i;
        }
        return (1L << i) - 1L;
    }

    private DataTreeNode(long mask, long index) {
        this.mask = mask;
        this.index = index;
    }

    public long mask() {
        return this.mask;
    }

    public long index() {
        return this.index;
    }

    public boolean isSonOf(@Nonnull DataTreeNode another) {
        if (another.equals(this)) {
            return true;
        }
        if (this.mask <= another.mask()) {
            return false;
        }
        return (this.index & another.mask) == another.index;
    }

    public DataTreeNode left() {
        return DataTreeNode.of((this.mask << 1) + 1L, this.index);
    }

    public DataTreeNode right() {
        return DataTreeNode.of((this.mask << 1) + 1L, this.index + this.mask + 1L);
    }

    public DataTreeNode parent() {
        Preconditions.checkArgument((this.mask > 0L ? 1 : 0) != 0);
        long parentMask = this.mask - 1L >> 1;
        long parentIndex = this.index > parentMask ? this.index - parentMask - 1L : this.index;
        return DataTreeNode.of(parentMask, parentIndex);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataTreeNode treeNode = (DataTreeNode)o;
        return this.mask == treeNode.mask && this.index == treeNode.index;
    }

    public int hashCode() {
        return Objects.hash(this.mask, this.index);
    }

    public String toString() {
        return String.format("TreeNode(%s,%s)", this.mask, this.index);
    }

    public long getMask() {
        return this.mask;
    }

    public long getIndex() {
        return this.index;
    }

    public long getId() {
        return this.mask + 1L + this.index;
    }
}

