/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.optimizing;

import java.util.Arrays;
import java.util.UUID;
import org.apache.amoro.io.reader.GenericCombinedIcebergDataReader;
import org.apache.amoro.io.writer.GenericIcebergPartitionedFanoutWriter;
import org.apache.amoro.io.writer.IcebergFanoutPosDeleteWriter;
import org.apache.amoro.optimizing.AbstractRewriteFilesExecutor;
import org.apache.amoro.optimizing.OptimizingDataReader;
import org.apache.amoro.optimizing.RewriteFilesInput;
import org.apache.amoro.table.MixedTable;
import org.apache.amoro.utils.map.StructLikeCollections;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Table;
import org.apache.iceberg.data.GenericAppenderFactory;
import org.apache.iceberg.data.IdentityPartitionConverters;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.deletes.PositionDelete;
import org.apache.iceberg.io.DeleteWriteResult;
import org.apache.iceberg.io.FileAppenderFactory;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.FileWriter;
import org.apache.iceberg.io.OutputFileFactory;
import org.apache.iceberg.io.TaskWriter;
import org.apache.iceberg.io.UnpartitionedWriter;

public class IcebergRewriteExecutor
extends AbstractRewriteFilesExecutor {
    public IcebergRewriteExecutor(RewriteFilesInput input, MixedTable table, StructLikeCollections structLikeCollections) {
        super(input, table, structLikeCollections);
    }

    @Override
    protected OptimizingDataReader dataReader() {
        return new GenericCombinedIcebergDataReader(this.io, this.table.schema(), this.table.spec(), this.table.asUnkeyedTable().encryption(), this.table.properties().get("schema.name-mapping.default"), false, IdentityPartitionConverters::convertConstant, false, this.structLikeCollections, this.input);
    }

    @Override
    protected FileWriter<PositionDelete<Record>, DeleteWriteResult> posWriter() {
        return new IcebergFanoutPosDeleteWriter<Record>(this.fullMetricAppenderFactory(this.fileSpec()), this.deleteFileFormat(), this.partition(), this.table.io(), this.table.asUnkeyedTable().encryption(), UUID.randomUUID().toString());
    }

    @Override
    protected TaskWriter<Record> dataWriter() {
        OutputFileFactory outputFileFactory = OutputFileFactory.builderFor((Table)this.table.asUnkeyedTable(), (int)this.table.spec().specId(), (long)0L).build();
        GenericAppenderFactory appenderFactory = new GenericAppenderFactory(this.table.schema(), this.table.spec());
        appenderFactory.setAll(this.table.properties());
        if (this.table.spec().isUnpartitioned()) {
            return new UnpartitionedWriter(this.table.spec(), this.dataFileFormat(), (FileAppenderFactory)appenderFactory, outputFileFactory, (FileIO)this.io, this.targetSize());
        }
        return new GenericIcebergPartitionedFanoutWriter(this.table.schema(), this.table.spec(), this.dataFileFormat(), (FileAppenderFactory<Record>)appenderFactory, outputFileFactory, this.io, this.targetSize());
    }

    @Override
    protected long targetSize() {
        long targetSize = super.targetSize();
        long inputSize = Arrays.stream(this.input.rewrittenDataFiles()).mapToLong(ContentFile::fileSizeInBytes).sum();
        return inputSize < targetSize ? Long.MAX_VALUE : targetSize;
    }

    private PartitionSpec fileSpec() {
        return (PartitionSpec)this.table.asUnkeyedTable().specs().get(this.input.allFiles()[0].specId());
    }
}

