/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.utils.map;

import java.io.Serializable;
import org.apache.amoro.utils.StructLikeSet;
import org.apache.amoro.utils.map.StructLikeBaseMap;
import org.apache.amoro.utils.map.StructLikeMemoryMap;
import org.apache.amoro.utils.map.StructLikeSpillableMap;
import org.apache.iceberg.types.Types;

public class StructLikeCollections
implements Serializable {
    public static final StructLikeCollections DEFAULT = new StructLikeCollections(false, 0L);
    private final boolean enableSpillableMap;
    private Long maxInMemorySizeInBytes;
    private String backendBaseDir;

    public StructLikeCollections(boolean enableSpillableMap, Long maxInMemorySizeInBytes) {
        if (maxInMemorySizeInBytes == null || maxInMemorySizeInBytes == 0L) {
            enableSpillableMap = false;
        }
        this.enableSpillableMap = enableSpillableMap;
        if (enableSpillableMap) {
            this.maxInMemorySizeInBytes = maxInMemorySizeInBytes;
        }
    }

    public StructLikeCollections(boolean enableSpillableMap, long maxInMemorySizeInBytes, String backendBaseDir) {
        this.enableSpillableMap = enableSpillableMap;
        this.maxInMemorySizeInBytes = maxInMemorySizeInBytes;
        this.backendBaseDir = backendBaseDir;
    }

    public <T> StructLikeBaseMap<T> createStructLikeMap(Types.StructType type) {
        if (!this.enableSpillableMap) {
            return StructLikeMemoryMap.create(type);
        }
        return StructLikeSpillableMap.create(type, this.maxInMemorySizeInBytes, this.backendBaseDir);
    }

    public StructLikeSet createStructLikeSet(Types.StructType type) {
        if (!this.enableSpillableMap) {
            return StructLikeSet.createMemorySet(type);
        }
        return StructLikeSet.createSpillableSet(type, this.maxInMemorySizeInBytes, this.backendBaseDir);
    }
}

